/*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
  										
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "msavdecoder.h"
#include "mscodec.h"
extern MSFilter *ms_mpeg_encoder_new();
extern MSFilter *ms_mpeg4_encoder_new();



MSCodecInfo MPEGinfo={
	{
		"MPEG1 codec",
		0,
		MS_FILTER_VIDEO_CODEC,
		ms_mpeg_encoder_new,
		"This is a MPEG1 codec taken from the ffmpeg project."
	},
	ms_mpeg_encoder_new,
	ms_mpeg_decoder_new,
	0,
	0,
	0,	/*bitrate */
	0,	/*sample freq */
	0,
	"MPV",
	1,
	1
};

MSCodecInfo MPEG4info={
	{
		"MPEG4 codec",
		0,
		MS_FILTER_VIDEO_CODEC,
		ms_mpeg4_encoder_new,
		"This is a MPEG4 codec taken from the ffmpeg project."
	},
	ms_mpeg4_encoder_new,
	ms_mpeg4_decoder_new,
	0,
	0,
	0,	/*bitrate */
	0,	/*sample freq */
	0,
	"MP4V-ES",
	1,
	1
};

#ifdef HAVE_GLIB
gchar * g_module_check_init(GModule *module)
{
	ms_AVCodec_init();
	return NULL;
}
#else
gchar * g_module_check_init()
{
	ms_AVCodec_init();
	return NULL;
}
#endif

void ms_AVCodec_init()
{
	avcodec_init();
	avcodec_register_all();
	ms_filter_register((MSFilterInfo*)&MPEGinfo);
	//ms_filter_register((MSFilterInfo*)&MPEG4info);
}


static MSAVDecoderClass *ms_avdecoder_class=NULL;

MSFilter *ms_h263decoder_new()
{
	return ms_AVdecoder_new_with_codec(CODEC_ID_H263);
}

MSFilter *ms_mpeg_decoder_new()
{
	return ms_AVdecoder_new_with_codec(CODEC_ID_MPEG1VIDEO);
}

MSFilter *ms_mpeg4_decoder_new()
{
	return ms_AVdecoder_new_with_codec(CODEC_ID_MPEG4);
}

MSFilter * ms_AVdecoder_new_with_codec(enum CodecID codec_id)
{
	MSAVDecoder *enc;

	enc=g_malloc(sizeof(MSAVDecoder));
	if (ms_avdecoder_class==NULL)
	{
		 ms_avdecoder_class=g_malloc(sizeof(MSAVDecoderClass));
		 ms_AVdecoder_class_init(ms_avdecoder_class);
	}
	MS_FILTER(enc)->klass=(MSFilterClass*)ms_avdecoder_class;
	ms_AVdecoder_init(enc,avcodec_find_decoder(codec_id));
	return MS_FILTER(enc);
}


void ms_AVdecoder_init(MSAVDecoder *dec, AVCodec *codec)
{
	gint error;
	
	ms_filter_init(MS_FILTER(dec));
	MS_FILTER(dec)->inqueues=dec->q_inputs;
	MS_FILTER(dec)->outqueues=dec->q_outputs;
	memset(&dec->av_context,0,sizeof(AVCodecContext));
	dec->av_codec=codec;
	dec->av_opened=0;
	
	dec->obufwrap.size=0;
	dec->obufwrap.buffer=NULL;
	dec->obufwrap.ref_count=1;	/* so that it is never freed by anybody */
	dec->obufwrap2=NULL;
}

void ms_AVdecoder_class_init(MSAVDecoderClass *klass)
{
	ms_filter_class_init(MS_FILTER_CLASS(klass));
	ms_filter_class_set_name( MS_FILTER_CLASS(klass),"AVdecoder");
	MS_FILTER_CLASS(klass)->max_qinputs=MSAVDECODER_MAX_INPUTS;
	MS_FILTER_CLASS(klass)->max_qoutputs=MSAVDECODER_MAX_INPUTS;
	MS_FILTER_CLASS(klass)->r_maxgran=0;
	MS_FILTER_CLASS(klass)->w_maxgran=0;
	MS_FILTER_CLASS(klass)->destroy=(MSFilterDestroyFunc)ms_AVdecoder_destroy;
	MS_FILTER_CLASS(klass)->process=(MSFilterProcessFunc)ms_AVdecoder_process;
}

void ms_AVdecoder_uninit(MSAVDecoder *dec)
{
	avcodec_close(&dec->av_context);
}
void ms_AVdecoder_destroy( MSAVDecoder *obj)
{
	ms_AVdecoder_uninit(obj);
	g_free(obj);
}

gint ms_AVdecoder_set_format(MSAVDecoder *dec, gchar *fmt)
{
	gint format;
	if (strcmp(fmt,"YUV420P")==0) format=PIX_FMT_YUV420P;
	else if (strcmp(fmt,"YUV422")==0) format=PIX_FMT_YUV422;
	else if (strcmp(fmt,"RGB24")==0) format=PIX_FMT_RGB24;	
	else if (strcmp(fmt,"BGR24")==0) format=PIX_FMT_BGR24;
	else if (strcmp(fmt,"YUV422P")==0) format=PIX_FMT_YUV422P;
	else if (strcmp(fmt,"YUV444P")==0) format=PIX_FMT_YUV444P;
	else {
		g_warning("ms_AVdecoder_set_format: unsupported format %s.",fmt);
		return -1;
	}
	dec->output_pix_fmt=format;
	return 0;
}

void ms_AVdecoder_process(MSAVDecoder *r)
{
	AVPicture orig;
	AVPicture transformed;
	MSQueue *inq,*outq;
	MSMessage *inm,*outm;
	gint error;
	gint got_picture;
	gint len,isize;
	char *data;
	AVCodecContext *ctx=&r->av_context;
	
	inq=r->q_inputs[0];
	outq=r->q_outputs[0];
	
	/* get a picture from the input queue */
	inm=ms_queue_get(inq);
	g_return_if_fail(inm!=NULL);
	if (!r->av_opened){
		error=avcodec_open(&r->av_context, r->av_codec);
		if (error!=0) g_warning("avcodec_open() failed: %i",error);
		else r->av_opened=1;
	}
	
	isize=inm->size;
	data=inm->data;
	while(isize>0){
		len=avcodec_decode_video(&r->av_context,&orig,&got_picture,data,isize);
		if (len<0) {
			ms_warning("ms_AVdecoder_process: error %i.",len);
			break;
		}
		if (got_picture) {
			ms_trace("ms_AVdecoder_process: got_picture: width=%i height=%i fmt=%i",
					ctx->width,ctx->height,ctx->pix_fmt);
			/* set the image in the wanted format */
			if (ctx->pix_fmt!=r->output_pix_fmt){
				gint dest_size;
				ms_trace("Converting image.");
				outm=ms_message_alloc();
				if (r->obufwrap2==NULL){
					dest_size=avpicture_get_size(r->output_pix_fmt,ctx->width,ctx->height);
					r->obufwrap2=ms_buffer_new(dest_size);
					r->obufwrap2->ref_count++;
				}
				ms_message_set_buf(outm,r->obufwrap2);
				avpicture_fill(&transformed,outm->data,r->output_pix_fmt,ctx->width,ctx->height);
				img_convert(&transformed, r->output_pix_fmt,
						&orig,ctx->pix_fmt,ctx->width,ctx->height);
			}else 
			{
				/* set up the static buffer*/
				r->obufwrap.buffer=orig.data[0];
				r->obufwrap.size=avpicture_get_size(ctx->pix_fmt,ctx->width,ctx->height);
				outm=ms_message_alloc();
				ms_message_set_buf(outm,&r->obufwrap);
			}
			ms_queue_put(outq,outm);
		}
		isize-=len;
		data+=len;
    	ms_trace("ms_AVdecoder_process: got_picture=0");
    }
    ms_message_destroy(inm);
}

void ms_AVdecoder_set_width(MSAVDecoder *av,gint w)
{
	av->av_context.width=av->width=w;
}

void ms_AVdecoder_set_height(MSAVDecoder *av,gint h)
{
	av->av_context.height=av->height=h;
}

