#include "commandimp.h"
#include <vector>
#include <deque>

namespace MLS {

using namespace std;
using namespace strutil;

deque<string> g_CmdHistory;

vector<string> PathComplete(const string &path, bool bPathsearch)
{
	//          l
	// 012345678901
	// workspace/l
	// /usr/src/red
	vector<string> entries;
	entries.clear();
	
	string::size_type loc;
	
	string d, name;
	
	if ((loc = path.rfind('/')) == string::npos)
	{
		// 지정 디렉토리가 없다면 현 디렉토리 및 path 검색
		name = path;
		int len = name.size();
		
		DIR *dir = opendir(".");
		if (!dir) return entries;
			
		struct dirent *entry;
		while( (entry = readdir(dir)) != NULL)
		{
			if (!strcmp(entry->d_name, ".") || !strcmp(entry->d_name, "..")) continue;
				
			if (!strncmp(name.c_str(), entry->d_name, len))
			{
				string fullname = d + entry->d_name;
					
				struct stat statbuf;
				if (stat(fullname.c_str(), &statbuf) == -1) continue;

				// 검토해야 할 사항.
				//if (S_ISDIR(statbuf.st_mode)) fullname += '/';
				
				// cd 일 경우 디렉토리만 넣는다.
				if (bPathsearch == true)
					entries.push_back(fullname);
				else
					if (S_ISDIR(statbuf.st_mode))
						entries.push_back(fullname);
			}
		}				
		closedir(dir);
		
		// path 상의 실행가능 파일들에 대해 검색 - cd 실행시 불가하게 함
		if (bPathsearch == true)
		{
			StringTokenizer st(getenv("PATH"), ":");
			while(st.Next())
			{
				d = st.Get();
				
				if (d.empty()) continue;
				if (*d.rbegin() != '/') d += '/';
							
				DIR *dir = opendir(d.c_str());		
				if (!dir) continue;
				
				struct dirent *entry;
				while( (entry = readdir(dir)) != NULL)
				{
					if (!strcmp(entry->d_name, ".") || !strcmp(entry->d_name, "..")) continue;		
					
					if (!strncmp(name.c_str(), entry->d_name, len))
					{
						string fullname = d + entry->d_name;
						
						struct stat statbuf;
						if (stat(fullname.c_str(), &statbuf) == -1) continue;
						
						if (S_ISDIR(statbuf.st_mode)) continue;
						
						if ((S_IXUSR & statbuf.st_mode) || (S_IXGRP & statbuf.st_mode) || (S_IXOTH & statbuf.st_mode))
							entries.push_back(entry->d_name);
					}
				}
				closedir(dir);
			}
		}
	}
	else
	{
		d = path.substr(0, loc+1);
		name = path.substr(loc+1);
		int len = name.size();
		
		// 지정 디렉토리가 있다면 				
		DIR *dir = opendir(d.c_str());		
		if (!dir) return entries;
		
		struct dirent *entry;		
		while( (entry = readdir(dir)) != NULL)
		{
			if (!strcmp(entry->d_name, ".") || !strcmp(entry->d_name, "..")) continue;
			
			if (!strncmp(name.c_str(), entry->d_name, len))
			{
				string fullname = d + entry->d_name;
				
				struct stat statbuf;
				if (stat(fullname.c_str(), &statbuf) == -1) continue;
				
				//if (S_ISDIR(statbuf.st_mode)) fullname += '/';

				// cd 일 경우 디렉토리만 넣는다.
				if (bPathsearch == true)
					entries.push_back(fullname);
				else
					if (S_ISDIR(statbuf.st_mode))
						entries.push_back(fullname);
			}
		}				
		closedir(dir);
	}
	return entries;
}

string	Com_entry(vector<string>& vStr, int cur)
{
	string  sName, sName2;
	if (vStr.size() == 0) return "";
	if (vStr.size() == 1) return vStr[0];
	sName = vStr[0];
	for (int nLength = cur; nLength < sName.size(); nLength++)
	{
		for (int nCount = 1; nCount < vStr.size(); nCount++)
		{
			sName2 = vStr[nCount];
			if (nLength > vStr[nCount].size()) continue;
			if (sName[nLength] != sName2[nLength])
			{
				return sName.substr(0, nLength);
			}
		}
	}
	return sName;
}

void CommandImp::Shell()
{ 
	WINDOW *win = newwin(1, g_nCOLS, g_nLINES-1, 0);
	wbkgd(win, COLOR(COLOR_WHITE, COLOR_BLACK));
	
	curs_set(1);
	
	int W = g_nCOLS - 4;

	wstring wstr = L"";
	int cur=wstr.size(), scroll= wstr.size() > W ? wstr.size()-W : 0; // 커서, 스크롤	
	int key, key2, key3, key4, nFirst = 0, nEnd = 0, W1 = 0, viewcur = 0;
	
	vector<string> com_entry;	
	int index = 0, start = 0;
	int his = g_CmdHistory.size();
	
	if (panel->isZip() == true)
	{
		//MsgBox(1, gettext("Error"), gettext("Shell can't execute, zip exit !!!"));
		return;
	}
	
	g_MainFrame->ShellExe(true);
	//int backspaceChar = g_Keybind.GetDefinition("backspace");

	string	sKey, sViewStr, str;
	string  sPrompt, sLogin, sHostName;

	char	cHostName[100];
	memset(&cHostName, 0, sizeof(cHostName));
	if (gethostname((char*)&cHostName, sizeof(cHostName)) == -1)
		sPrompt = "$ ";
	else
	{
		struct passwd* pw = getpwuid(getuid());
		sLogin = pw->pw_name;
	}
	if (strlen(cHostName) == 0 || sLogin.size() == 0)
		sPrompt = "$ ";
	sHostName = cHostName;
	if (sHostName.find(".") != string::npos)
		sHostName = sHostName.substr(0, sHostName.find("."));
	
	while(1)
	{
	// 찍고
		wattron (win, COLOR(COLOR_WHITE, COLOR_BLACK));
		wmove(win, 0, 0);
		whline(win, ' ', g_nCOLS);

		if (sPrompt != "$ ")
		{	
			sPrompt = "";
			string sPath = panel->GetPathView();
			if (sPath == panel->GetRealPath("~")) sPath = "~";
			if (sPath != "/" && sPath.substr(sPath.size()-1, 1) == "/")
				sPath = sPath.substr(0, sPath.size()-1);
			if (krstrlen(sPath) > 40)
				sPath = "..." + krstrncpy(sPath, krstrlen(sPath)- 37, 37);
			sPrompt = sPrompt + sLogin + "@" + sHostName  + ":" + sPath;
			if (sLogin == "root")
				sPrompt = sPrompt + "# ";
			else
				sPrompt = sPrompt + "$ ";
		}
		wprintw(win, "%s", sPrompt.c_str());

		// Width 결정
		W1 = g_nCOLS - krstrlen(sPrompt);
		if (wstr.size() != 0)
		if (wstrlen(wstr.substr(nFirst, W1)) > W)
		{
			while(1) {
				if (wstrlen(wstr.substr(nFirst, W1)) <= W) break;
				W1--;
			}
			
		}
		nEnd = nFirst + W1;
		
		sViewStr = wstrtostr(wstr.substr(nFirst, W1));
		wprintw(win, "%s", sViewStr.c_str());
		
		// 커서가 있는 곳으로 이동한다.
		viewcur = wstrlen(wstr.substr(nFirst, cur-nFirst));
		wmove(win, 0, krstrlen(sPrompt)+viewcur);
		wrefresh(win);	
		key = getch();

		if (key >= 0x80 || key == 27)
		{
			nodelay(stdscr, TRUE);
			key2 = getch();
			key3 = getch();
			key4 = getch();
			nodelay(stdscr, FALSE);
		}
		else
		{
			key2 = ERR;	key3 = ERR; key4 = ERR;
		}

		if (key != 27)
		{
			sKey = "";
			sKey.append(1, (char)key);
			
			// utf8 -> 3char, etc -> 2char
			if (key2 != ERR) sKey.append(1, (char)key2);
			if (key3 != ERR) sKey.append(1, (char)key3);
		}

		// 27, 79, 72 (linux) ::  27, 91, 72 (vt100)
		if (key == 27 && (key2 == 91 || key2 == 79))
		{
			// 리모트 접속 End, Home 키
			if (key3 == 72) key = KEY_HOME;
			if (key3 == 70) key = KEY_END;
			// Konsole. End Home 키
			if (key3 == 49 && key4 == 126) key = KEY_HOME;
			if (key3 == 52 && key4 == 126) key = KEY_END;
		}

		LOG("sKey [%d] [%d] [%d] [%d]", key, key2, key3, key4);
		
		if (key == '\t')
		{
			//      l            c
			// 01234567890123456789
			// break /usr/src/red p
			// /usr/src/redhat
			// 커서를 기점으로 앞의 것을 취한다.
			if (!index)
			{
				wstring::size_type loc;
				if ((loc=wstr.rfind(L' ', cur-1)) != wstring::npos)
					start = loc + 1;
				else
					start = 0;

				// cd 일 경우에는 디렉토리만 넣는다.
				if (wstr.substr(0, 2) == L"cd")
					com_entry = PathComplete(wstrtostr(wstr.substr(start, cur-start)), false);
				else
					com_entry = PathComplete(wstrtostr(wstr.substr(start, cur-start)), true);
			}
			
			if (com_entry.empty()) continue;

			//string &rf = com_entry[index % com_entry.size()];
			wstring rf;
			
			if (config.GetBool("TabFileRotate"))
				rf = strtowstr(addslash(com_entry[index % com_entry.size()]));
			else
				rf = strtowstr(addslash(Com_entry(com_entry, start)));			
			
			wstr.erase(start, cur-start);
			wstr.insert(start, rf);
			
			cur = start + rf.size();
			if (nEnd < wstr.size()-3)
			{
				nFirst = wstr.size()-W1+3;
				if (nFirst < 0) nFirst = 0;
			}
			index++;
		}
		else index = 0;	
		
		if (key == KEY_UP)
		{
			if (g_CmdHistory.empty()) continue;
			
			his--;			
			if (his < 0) his = g_CmdHistory.size()-1;
			
			wstr = strtowstr(g_CmdHistory[his]);
			cur = wstr.size();
			nFirst = wstr.size()-W1+3;
			if (nFirst < 0) nFirst = 0;
			continue;
		}
				
		if (key == KEY_DOWN)
		{
			if (g_CmdHistory.empty()) continue;
			
			his++;
			if (his >= g_CmdHistory.size()) his = 0;
			
			wstr = strtowstr(g_CmdHistory[his]);
			cur = wstr.size();
			nFirst = wstr.size()-W1+3;
			if (nFirst < 0) nFirst = 0;
			continue;
		}		
	
	// home, end, pgup, pgdn, 화살표, 아스키
	// 기타 키가 들어오면 씹는다..
		if (key == KEY_HOME || key == KEY_PPAGE)
		{
			cur = 0;
			nFirst = 0;
			continue;
		}
	
		if (key == KEY_END || key == KEY_NPAGE)  
		{
			if (nEnd < wstr.size()-3)
			{
				nFirst = wstr.size()-W1+3;
				if (nFirst < 0) nFirst = 0;
			}
			cur = wstr.size();
			continue;
		}
	
		if (key == KEY_LEFT)
		{
			cur--;
			if (cur < 0) cur = 0;
			if (cur-nFirst < 3)
			{
				nFirst = cur - 3;
				if (nFirst < 0) nFirst = 0;
			}
			continue;
		}
	
		if (key == KEY_RIGHT)
		{
			cur++;
			if (cur > wstr.size()) cur = wstr.size();
			if (cur > nEnd-3)
			{
				if (nFirst < wstr.size()-5)
					nFirst = nFirst + 1;
			}
			continue;
		}
	
		if (key == 27) 
		{
			g_MainFrame->ShellExe(false);
			curs_set(0);
			delwin(win);
			Refresh();
			return;
		}
		
		if (key == KEY_RESIZE)
		{
			g_nLINES = LINES;
			g_nCOLS = COLS;
			curs_set(0);
			delwin(win);
			Refresh();
			return;
		}
		
		if (key == 13 || key == 10) break;
		
		// backspace 커서 위치에서 한글자 지운다.
		// Konsole bugfix
		if (key == KEY_BS || key == KEY_BS_2 || key == 8)
		{
			if (!wstr.empty() && cur)
			{
				wstr.erase(cur-1, 1);
				cur--;
				if (cur-nFirst > 4)
				{
					nFirst=nFirst-1;
					if (nFirst < 0) nFirst = 0;
				}
			}
			continue;
		}
	
		// del..		
		if (key == 330 || key == KEY_DC)
		{
			if (!wstr.empty())
				wstr.erase(cur, 1);
			continue;
		}
	
		if (32 <= key)
		{
			//MsgBox(1, "f", "%d", cur);
			wstring	wstrkey = strtowstr(sKey);
			if (wstrkey.size() > 0)
			{
				wstr.insert((wstring::size_type)cur, wstrkey);
				cur = cur + wstrkey.size();
				if (cur >= nEnd) nFirst=nFirst+wstrkey.size();
			}
			continue;
		}
	}	
	
	curs_set(0);
	delwin(win);

	str = wstrtostr(wstr);
	if (str.empty())
	{
		g_MainFrame->ShellExe(false);
		return;
	}
	
	while(g_CmdHistory.size() >= 50) g_CmdHistory.pop_front();
	
	g_CmdHistory.push_back(str);
	ParseAndRun(str, true);
	
	Refresh();

	g_MainFrame->ShellExe(true);
}

};

