#ifndef MLSSELECTION_H
#define MLSSELECTION_H

#include <vector>
#include <string>

namespace MLS {

class Selection{
	
	typedef std::vector<std::string> FileContainer;

	std::string   _sZipName;		///< Tar file name
	FileContainer vData;
	uint           nSize;
	std::string   sBaseDir;
	
public:
    Selection(std::string sZipName = "") { _sZipName = sZipName; }
    ~Selection();

    const std::string	&GetZipFile() const { return _sZipName; }
    void				SetZipFile(const std::string& sZipName) { _sZipName = sZipName; }
    
	void 				SetBaseDir(const std::string &s) { sBaseDir = s; }
	
	void 				Add(const std::string &s, int size=0) 
	{ 
		if (!s.empty()) 
		{ vData.push_back(s); nSize+=size; }
	}
	
	void 				Clear()                         	{ vData.clear(); }
	
	int  				Size() const						{ return vData.size(); }
	const FileContainer &GetData() const 					{ return vData; } 
	const std::string 	&GetBaseDir() const 				{ return sBaseDir; } 
	std::string 		GetFullPath(int index) const;
	const std::string 	&operator[](int index) const 		{ return vData[index]; }
	
	/// 데이터의 전체 사이즈를 얻는다
	uint  				GetSize() const 					{ return nSize; }
	
	/// 데이터의 크기를 계산한다 ( 파일마운트라고 가정함 )
	uint  				CalcSize();
	
	/// 데이터 내용을 디렉토리에 대하여 확장시킨다
	void 				ExpandDir(bool bCtlBreak = false);
};

};

#endif
