///	\file	reader.h
///	\brief	reader.h
#ifndef reader_h_
#define reader_h_

#include "file.h"
#include "progress.h"
#include <vector>

namespace MLS {	
	///	\brief	Reader 인터페이스
	class Reader:public Counter
	{
		public:
			///	\brief	초기화 함수
			///	\param	path	읽을 directory 명
			///	\return	???
			virtual bool Init(const std::string &path) = 0;

			///	\brief	다음 원소로 위치를 이동
			///	\return	위치 이동 성공 여부
			virtual bool Next() = 0;

			///	\brief	현재 파일정보를 얻음
			///	\param	r	반환값
			///	\return	정보 얻기 성공 여부
			virtual bool GetInfo(File &r) = 0;

			///	\brief	제거 함수
			virtual void Destroy() = 0;

			///	\brief	해당 하는 대상들을 복사함
			///	\param	tCpyData	반환값
			///	\param	sTarget		찾을 값(?)
			///	\return	??
			virtual int  Copy(vector<string>& tCpyData, string& sTarget) = 0;

			///	\brief	해당 되는 대상을 삭제함
			///	\param	tRemoveData	삭제할 대상
			///	\return	???
			virtual int  Remove(vector<string>& tRemoveData) = 0;
			
			///	\brief	Zip 파일을 보기 위함
			///	\param	tFile	/tmp 밑에 복사할 파일
			///	\return	???
			virtual int  View(File& tFile, const string& sTmpDir) = 0;
			
			///	\brief	'/' directory인가?
			///	\return	true	:	'/' diretory\n
			///			false	:	'/' directory가 아니다
			virtual bool isRoot() { return false; }
			
			virtual vector<MLS::File*>	GetFiles() { vector<File*>	vFiles; return vFiles; }
	};
}; // namespace 

#endif
