///	\file	panel_reader.cpp
///	\brief	panel_reader.cpp
#include <string>

#include "panel.h"
#include "reader.h"
#include "ZipReader.h"
#include "dirreader.h"

using namespace std;
using namespace MLS;

/// \brief	절대경로에 맞는 Reader를 얻어온다	
///	\param	path	절대경로
/// \return	절대경로에 맞는 reader
Reader *Panel::GetReader(const string &path)
{
	if (path.empty()) return NULL;

	if (_nZip == 0)
	{
		LOG("PATH Dir :: %s", path.c_str());
		
		// /로 시작하고.. 끝이 /으로 끝난다면..
		if (path[0] == '/' && path[path.size()-1] == '/')
			return &_Dir_Reader;
	}
	else
	{
		LOG("PATH Zip :: %s", path.c_str());

		if (_sZipFile.empty()) return NULL;
		
		_Zip_Reader.SetZipFile(path, _sZipFile);
		return &_Zip_Reader;
	}

	return NULL;
}
