///	\file	panel_move.cpp
///	\brief	panel_move.cpp
#include <string>
#include <sys/stat.h>
#include <errno.h>
#include <iostream>

#include "panel.h"
#include "DirMcd.h"
#include "dialog.h"
#include "strutil.h"

using namespace std;
using namespace strutil;

// 옮기는 작업

using namespace MLS;

int Move(Selection &files, string target_path)
{
	StatBox s(	gettext("Move"), (gettext("To ") + target_path).c_str());	
	
	s.setUL(gettext("Calculating file sizes..."));
	s.show();
		
	// 1. 선택한 것을 하는 것인가..
	// 2. 그냥 한 파일만 이동하는 것인가
	
	bool bOverwriteAll = false;	
	int size = files.GetSize();	
	string sizes = toregular(size);
	
	struct stat src_stat, tar_stat, dir_stat;
	
	FILE *fp, *out;	 // 원본, 타겟
	
	//ostringstream count;
	char	count[1024];
	
	char *buf = new char[65536]; 
	
	uint last_size, p=1, p_size=0, c_size;
			
	string source_name;
	string target_name;		
	
	// 파일 이동			
	for (int t=0; t< files.Size(); t++)
	{
		const string &cur_name = files[t];
		
		// 파일 이름이 없을경우 continue	
		if (cur_name.empty()) continue;
		
		// 옮기기..		
		source_name = files.GetBaseDir() + cur_name;
		target_name = target_path + cur_name;
		
		if (stat(source_name.c_str(), &src_stat) == -1)
		{
			if (YNBox(	gettext("Source is not found. continue ?"), YN_N)==YN_Y)
				break;
			
			else continue;			
		}
		
		// 타겟이 이미 있는지 확인
		if (!bOverwriteAll && stat(target_name.c_str(), &tar_stat) != -1) 
		{// 만약에 타겟이 있다면..
			vector<string> q;			
			q.push_back(gettext("Overwrite"));
			q.push_back(gettext("Skip"));
			q.push_back(gettext("Overwrite All"));
			q.push_back(gettext("Cancel"));
			
			int x = SelectBox((gettext("File exists : ") + cur_name).c_str(), q, 0);
			
			s.redraw();
			
			switch(x)
			{
				case 0:				
					break;
				
				case 1:
					c_size += src_stat.st_size;
					p++;
					continue;
				
				case 2:
					bOverwriteAll = true;
					break;
						
				case 3:
					goto halt;
						
				default:
					break;
			}
						
									
		}
		
		//count.str("");
		//count << '<' << p << '/' << files.size() << '>';

		sprintf(count,"<%ld/%ld>", p, files.Size());
		
		s.setUL(cur_name.c_str());
		
		//s.setBL(count.str().c_str());		
		s.setBL(count);
		s.setBR(sizes.c_str());
		
		s.setU(60);		
				
		if (size) s.setB(p_size * 60 / size);
		
		s.show();
		
		
		int err = rename(source_name.c_str(), target_name.c_str());				
		
		// EXDEV에 대해서 복사/삭제 오퍼레이션으로 전환해야하는데 그냥;;;
		if (err == -1 && errno == EXDEV)
		{
			if (YNBox(gettext("Move failure, continue?"), YN_N)==YN_Y)
				break;									
		}
		
		p_size += src_stat.st_size;		
		
		s.setU(60);		
				
		if (size) s.setB(p_size * 60 / size);
		
		s.show();
	}
halt:
		
	return 1;	
}
		

int Panel::cmd_move(void)
{
	DirMcd mcd("", gettext("Select the directory where you want to copy these files"));
	
	mcd.AddDirectory(_path);
	mcd.setCur(_path);
	
	if (!mcd.proc()) return -1;
	
	Selection sel = GetSelection();
	
	return Move(sel, mcd.getCur());	
}
/*
int Panel::cmd_move(void)
{
	Mcd mcd("Select the directory where you want move these files");
	mcd.setCur(_path);
	if (!mcd.proc()) return -1;
	
	string msg = "To " + mcd.getCur();
	
	StatBox s("Move", msg.c_str());	
	s.setUL("Calculating file sizes...");
	s.show();	
	// 1. 선택한 것을 하는 것인가..
	// 2. 그냥 한 파일만 복사하는 것인가
	
	int size;	
	vector<string> &files=GetSelection(size);
	
	struct stat stat_bufs;	
	FILE *fp, *out;	
	char count[25];
	char *buf = new char[65536]; 
	uint last_size, p=1, p_size=0, c_size;
	string sizes = toregular(size);	
	int key;
		
	bool bExit=false;
	bool bsDir=true;
	
	// /home/ioklo/ 에서 복사 시작  /p/로..
	// /home/ioklo/mls/p.dir   ==> /p/mls/p.dir
	
	// /home/ioklo/ 현재 디렉토리 source_path
	// /p/          타겟 디렉토리 target_path
	// mls/         복사시점 디렉토리 cur_path
	// p.dir        파일 이름  cur_name
	// /p/mls/      복사점..  tcur_path = target_path + cur_path
	
	// mls/p.dir    = cur_path + cur_name
	// /p/mls/p.dir =  tcur_path + cur_name
	
	string target_path = mcd.getCur();
	
	string source_name;
	string target_name;
	
	string cur_path;
	string tcur_path = target_path;
	
	// 파일 옮김
	for (vector<string>::iterator i=files.begin(); i!=files.end(); ++i)
	{
		string &cur_name = *i;		
		
		// 우선 파일이 있나 검사한다.
		// 없다면 이동한다
		// 이동이 안되었다면 복사해버린다.
		
		// 우선 파일이 있나 검사한다
		source_name = cur_path + cur_name;
		target_name = tcur_path + cur_name;
			
		if (lstat(source_name.c_str(), &stat_bufs)==-1 && errno == ENOENT)		
		{// 없다면 이동한다
			if (rename(source_name.c_str(), target_name.c_str())==-1)
			{// 이동이 안되었다면 복사하고 지워버린다
				
			}
			else ;
		}
		s.setUL((*i).c_str());
		sprintf(count, "<%d/%d>", p, files.size());
		s.setBL(count);
		s.setBR(sizes.c_str());
		
		
		fp=fopen(source_name.c_str(), "rb");
		
		
		c_size=0;
		s.show();
		
		if (lstat(target_name.c_str(), &stat_bufs)!=-1)
		{
			string t = "Overwrite " + (*i);
			int yn=YNBox(t.c_str(), YN_N);
			s.redraw();
			if (yn==-1) break;
			if (yn==YN_N) 
			{
				c_size += stat_bufs.st_size;
				p++;
				continue;
			}
		}		
		nodelay(stdscr, TRUE);
		if (fp)		
		{		
		out=fopen(target_name.c_str(), "wb");				
			while(!feof(fp))
			{
				key=getch();
								
				if (key!=-1)
				{
					int yn=YNBox("Do you want to stop move operation?", YN_N);
					s.redraw();
					if (yn==YN_Y)
					{
						bExit=true;
						break;
					}
				}				
				
				last_size = fread(buf, 1, 65536, fp);			
				fwrite(buf, 1, last_size, out);
				
				c_size +=last_size;
				p_size +=last_size;
				
				s.setUR(toregular(p_size).c_str());
				
				if (stat_bufs.st_size) s.setU((int)((float)c_size/(float)stat_bufs.st_size* 60));
				if (size) 
				{
					s.setB((int)((float)p_size/(float)size* 60));
				}
				s.show();
			}
		fclose(out);
		}
		fclose(fp);
		nodelay(stdscr, FALSE);
		if (bExit) break;
		
		p++;								
	}
	delete []buf;
	return 1;
}

*/
