/* *************************************************************************
 *   Copyright (C) 2004 by Byoungyoung, La                                 *
 *   la9527@yahoo.co.kr                                                    *
 ************************************************************************* */
 
///	\file	ZipReader.h
///	\brief	ZipReader.h	
#ifndef ZipReader_h_
#define ZipReader_h_
 
#include "define.h"
#include "mls.h"
#include "dialog.h"
#include "reader.h"
#include "file.h"
#include "TargzUtil.h"
#include "mlslocale.h"
#include "progress.h"

namespace MLS
{
	///	\brief	zip file reader
	class ZipReader:public Reader
	{
		public:
			ZipReader();
			~ZipReader();
			
			///	\brief	zipfile name을 설정한다.
			///	\param	sDir		zipfile이 위치하는 directory
			///	\param	sFilename	zipfile name
			void	SetZipFile(const string& sDir, const string& sFilename)
			{
				m_sDir = sDir; m_sFilename = sFilename;
			}

			string	GetZipPath()	{ return m_sFilePath; }
			string	GetZipFileName() 	{ return m_sFilename; }
			
			virtual vector<MLS::File*>	GetFiles()
			{
				vector<File*>	tAllFiles;
				m_pTargzUtil->GetAll_Files(&tAllFiles);
				return tAllFiles;
			}
			
			virtual int  Copy(vector<string>& tCpyData, string& sTarget);
			virtual int  Remove(vector<string>& tRemoveData);
			virtual int  View(File& tFile, const string& sTmpDir);
		
			virtual bool Init(const std::string &path = "");
			virtual bool Next();
			virtual bool GetInfo(File& tFile);
			virtual void Destroy();
			virtual bool isRoot();
			
			
		private:
			TargzUtil*			m_pTargzUtil;	///< targz util object
			vector<MLS::File*>	m_Filelist;		///< filelist 벡터
			uint				m_CurrentData;	///< 현재 선택된 파일 index
			string				m_currentPath;	///< current path?
			string				m_ZipCurrentDir;///< zip current dir?
			int					m_Count;		///< count ?

			string				m_sDir;			///< zipfile이 있는 direictory (수시로 변함)
			string				m_sFilePath;	///< zipfile path (고정)
			string				m_sFilename;	///< zipfile name
	};
};

#endif

