/***************************************************************************
 *   Copyright (C) 2004 by Byoungyoung, La                                 *
 *   la9527@yahoo.co.kr                                                    *
 ***************************************************************************/

#ifndef __PROGRESS_H__ 
#define __PROGRESS_H__ 
 
#include "define.h"
#include "strutil.h"
#include "dialog.h"
#include "mlsmutex.h"
#include "mlsthread.h"

namespace MLS {

class Counter
{
	public:
		Counter() 	{ m_nCounter = 0; }
		~Counter() 	{ m_nCounter = 100; }
		int 	GetCounter() 				{ return m_nCounter; }
		void 	SetCounter(int nCounter)	{ m_nCounter = nCounter; }
	private:
		int		m_nCounter;
};

class Progress: public MlsThread
{
	public:
		Progress(const string& sTitle, const string& sMsg = "")
		{
			m_sTitle = sTitle;
			m_sMsg = sMsg;
		}

		void    SetTitle(const string& sTitle) { m_sTitle = sTitle; }	
		void    SetMsg(const string& sMsg) { m_sMsg = sMsg; }

		void*	Execute(void* pArg)
		{
			string 	sValue;
			int 	nCount;
			char	cView[20];
			ProgressBox		m_tProgBox(m_sTitle.c_str(), m_sMsg.c_str());			
			m_tProgBox.redraw();
			
			for (;;)
			{
				nCount = ((Counter*)pArg)->GetCounter();
				
				sprintf(cView, "%d / 100 %%", nCount);
				m_tProgBox.setRightStr(cView);
				m_tProgBox.setCount(nCount);
				
				m_tProgBox.show();
				
				if (nCount == 100) break;
				if (IsRun() == PTHREAD_END) break;
				Thread_uSleep(10000);
			}
			return (void*)this;
		}
		
	private:
		string m_sTitle;
		string m_sMsg;
};

};

#endif
