/* *************************************************************************
 *   Copyright (C) 2004 by Byoungyoung, La                                 *
 *   la9527@yahoo.co.kr                                                    *
 *                                                                         *
 ************************************************************************* */
///	\file	exception.h
///	\brief	예외 처리 class header

#ifndef Exception_h
#define Exception_h

#include "define.h"
#include <stdarg.h>

namespace MLS
{
	///	\brief	예외 처리 class
	class   Exception
	{
		public:
				Exception(char* pMsg);
				Exception(const string& pMsg = "");
				Exception(const char* fmt, ...);
				Exception(const char* file, int lineno, string  pMsg);
				Exception(const char *file, int lineno, const char *fmt, ...);

				~Exception();

				char*   GetInfo(void);

				///	\brief	문자열로 형 변환시키는 함수(char * oprator)
				///	\return	char *로 형변환된 error 내용
				operator        char*() {return (char*)m_strError.c_str();}
				friend  ostream&        operator>>(ostream& output, Exception& tEx);

		protected:
				string  m_strError;		///<	에러내용
				string  m_sExcepInfo;	///<	예외 정보
	};
}

#endif
