/* *************************************************************************
 *   Copyright (C) 2004 by Byoungyoung, La                                 *
 *   la9527@yahoo.co.kr                                                    *
 *                                                                         *
 ************************************************************************* */

///	\file	exception.cpp
///	\brief	예외정보 소스
#include "exception.h"

using namespace MLS;

///	\brief	생성자
///	\param	pMsg	에러, 예외 내용
Exception::
Exception(char*	pMsg)
{
	if(pMsg)
	{
		m_strError		+= pMsg;
		m_sExcepInfo	+= pMsg;
	}
}

///	\brief	생성자
///	\param	pMsg	에러, 예외 내용
Exception::
Exception(const string&	pMsg)
{
	if(pMsg == "")
	{
		m_strError		+= pMsg;
		m_sExcepInfo	+= pMsg;
	}
}

///	\brief	생성자
///	\param	file	예외나 에러가 난 파일이름
///	\param	lineno	줄 번호
///	\param	pMsg	에러, 예외 내용
Exception::
Exception(const char* file, int lineno, string	pMsg)
{
	// . 에러내용을 추가
	m_strError = "";
	if(pMsg != "")
		m_strError	+= pMsg;

	// . 예외정보에 파일이름 추가
 	char 	cLinenoTmp[30];
	memset(&cLinenoTmp, 0, sizeof(cLinenoTmp));
	sprintf(cLinenoTmp, "%s", file);

	m_sExcepInfo = "";
	m_sExcepInfo = m_sExcepInfo + "(" + cLinenoTmp;

	// . 예외정보에 줄번호 정보 추가
	memset(&cLinenoTmp, 0, sizeof(cLinenoTmp));
	sprintf(cLinenoTmp, "%d", lineno);

	// . 예외정보에 에러내용 추가 
	m_sExcepInfo = m_sExcepInfo + ", " + cLinenoTmp;
	m_sExcepInfo = m_sExcepInfo + ") *" + pMsg;
	//cout << m_sExcepInfo << endl;
}

Exception::
Exception(const char* fmt, ...)
{
	char		buffer[4096];
	int 		buflen = 0;
	va_list 	ap;

	// . 예외, 에러 내용 길이가 적당하다면
	if (strlen(fmt) < sizeof(buffer))
	{
		// .. 그외 에러, 예외내용을 넣는다.
		va_start(ap, fmt);
		vsprintf(buffer+buflen, fmt, ap);
		va_end(ap);

		m_strError = "";
		m_strError	= m_strError + buffer;
	}
	else
	{
		cerr << "Exception Error :: Beffer Over Flow :: " << endl;
	}
}

///	\brief	생성자
///	\param	file	예외나 에러가 난 파일이름
///	\param	lineno	줄 번호
///	\param	fmt		string format
Exception::
Exception(const char *file, int lineno, const char *fmt, ...)
{
	char		buffer[4096];
	int 		buflen = 0;
	va_list 	ap;

	// . 예외, 에러 내용 길이가 적당하다면
	if (strlen(fmt) < sizeof(buffer))
	{
		// .. 파일정보와 줄번호를 넣는다.
		buflen = sprintf(buffer, "- (%s,%03d) *", file, lineno);

		// .. 그외 에러, 예외내용을 넣는다.
		va_start(ap, fmt);
		vsprintf(buffer+buflen, fmt, ap);
		va_end(ap);

		m_strError = "";
		m_strError	= m_strError + buffer;
	}
	else
	{
		cerr << "Exception Error :: Beffer Over Flow :: " << endl;
	}
}

///	\brief	소멸자
Exception::
~Exception()
{
}

///	\brief	operator >> 함수
///	\param	output	출력할 stream
///	\param	tEx		예외, 에러
///	\return	출력할 stream
ostream&
operator>>(ostream& output, Exception& tEx)
{
	// . char 형으로 형변환하여 출력
	return output << (char*)tEx;
}

///	\brief	예외정보를 얻는다.
///	\return	예외정보 내용
char*
Exception::
GetInfo(void)
{
	return (char*)m_sExcepInfo.c_str();
}

