/* *************************************************************************
 *   Copyright (C) 2004 by Byoungyoung, La                                 *
 *   la9527@yahoo.co.kr                                                    *
 *                                                                         *
 ************************************************************************* */
///	\file	define.h
///	\brief	define.h
 
#ifndef __DEFINE_H__
#define __DEFINE_H__

// 프로그램 기본세팅
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <string>
#include <map>
#include <vector>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#define		ERROR	-1		///< ERROR 정의
#define		SUCCESS 0		///< SUCCESS 정의

typedef unsigned int uint;	///< unsigned int 재정의

extern int		g_nLINES;
extern int		g_nCOLS;

#ifdef _DEBUG
#include <stdio.h>
#include <stdarg.h>

extern bool g_Log;

///	\brief	로그를 stderr로 출력한다
///	\param	szStr	로그 내용
inline void LOG( char *szStr , ...)
{
	if (!g_Log) return;

    va_list args;
    char szBuf[4096];

    va_start(args,szStr);
    vsprintf(szBuf,szStr,args);
    va_end(args);

	fprintf(stderr, "%s\n", szBuf);
}
	
#else
#define LOG(fmt, args...)  // gnu 전용...
#endif // _DEBUG

#endif // _DEFINE_H_
