/***************************************************************************
 *   Copyright (C) 2004 by Byoungyoung, La                                 *
 *   la9527@yahoo.co.kr                                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef	 	__STRLINETOKEN_H__
#define		__STRLINETOKEN_H__

#include "define.h"
#include "strutil.h"
#include "mlslocale.h"

using namespace strutil;
using namespace MLS;

class StrLineToken
{
	vector<wstring>	_vStr;
	wstring			_SrcString;
	
	int		_width;
	uint	_curline;
	
	public:
		StrLineToken(const wstring& sLineStr = L"", int nViewWidth=80)
		{
			SetWString(sLineStr, nViewWidth);
		}

		void	SetWString(wstring sLineWStr, int nViewWidth)
		{
			string			sLineStr;
			string			sViewStr;
			wstring			sConvStr;
			bool			bNextLine = false;
			int				nKrStrSize;

			_vStr.clear();
			
			_SrcString = sLineWStr;
			_curline = 0;

			if (sLineWStr.size() == 0) return;
			sLineStr = wstrtostr(sLineWStr);

			do
			{
				nKrStrSize = krstrlen(sLineStr);
				if (nKrStrSize <= nViewWidth)
				{
					sViewStr = krstrncpy(sLineStr, 0, nKrStrSize);
					bNextLine = true;
				}
				else
				{
					sViewStr = krstrncpy(sLineStr, 0, nViewWidth);
					sLineStr = krstrncpy(sLineStr, nViewWidth, nKrStrSize-nViewWidth);
					bNextLine = false;
				}

				sConvStr = strtowstr(sViewStr);
				_vStr.push_back(sConvStr);
			}
			while(bNextLine == false);
		}
		
		bool	Set_LineData(const wstring& sWStr, uint nLine)
		{
			if (_vStr.size() <= nLine)
				_vStr.push_back(sWStr);
			else
				_vStr[nLine] = sWStr;
			return true;
		}

		wstring GetWString()
		{
			wstring sStr = L"";
			for (uint nSize = 0;nSize < _vStr.size(); nSize++)
			{
				sStr = sStr + _vStr[nSize];
			}
			return sStr;
		}

		uint			LineSize()						{ return _vStr.size(); }
		
		wstring	Get()
		{
			if (_vStr.size() == 0 || _vStr.size() <= _curline) return L"";
			return _vStr[_curline];
		}

		wstring	GetLineStr(uint nLineNum)
		{
			if (_vStr.size() == 0 || _vStr.size() <= nLineNum) return L"";
			return _vStr[nLineNum];
		}
		
		uint			GetCurNum()						{ return _curline; }

		bool Next()
		{
			if (_vStr.size() > _curline)
			{
				_curline++;
				return true;
			}
			return false;
		}

		bool NextChk()
		{
			if (_vStr.size() > _curline)
			{
				return true;
			}
			return false;
		}
};

#endif
