#include "../lcp3.h"	// LineControl Proto 3
#include "../common.h"	// DialControl + LineControl Proto 2
#include <stdio.h>

int main(int argc, char **argv)
{
	int max = 0;
	printf("\n-------------------------------------------------------\n");
	printf("get_max_lcp3_pack_size(): %d\n", get_max_lcp3_pack_size());
	printf("input buffer size: sizeof(struct p_order_t): %d\n\n", sizeof(struct p_order_t));
	printf("sizeof(struct t_lcp3_cmd): %d\n\n", sizeof(struct t_lcp3_cmd));
	printf("sizeof(struct t_lcp3_info_enckey): %d\n", sizeof(struct t_lcp3_info_enckey));
	printf("sizeof(struct t_lcp3_info_auth): %d\n", sizeof(struct t_lcp3_info_auth));
	printf("sizeof(struct t_lcp3_info_ack): %d\n", sizeof(struct t_lcp3_info_ack));
	printf("sizeof(struct t_lcp3_info_line): %d\n", sizeof(struct t_lcp3_info_line));
	printf("sizeof(struct t_lcp3_info_tput): %d\n", sizeof(struct t_lcp3_info_tput));
	printf("sizeof(struct t_lcp3_info_status): %d\n", sizeof(struct t_lcp3_info_status));
	printf("sizeof(struct t_lcp3_info_isdn): %d\n", sizeof(struct t_lcp3_info_isdn));
	printf("-------------------------------------------------------\n");
	//----------
	if ( get_max_lcp3_pack_size() > sizeof(struct p_order_t) )
	{
	    printf("\nERROR: get_max_lcp3_pack_size() > sizeof(struct p_order_t)\n");
	    printf("       Buffers of server are to small!\n\n");
	    exit(1);
	}
	max = 0;
	if ( sizeof(struct t_lcp3_info_enckey) > max ) max = sizeof(struct t_lcp3_info_enckey);
	if ( sizeof(struct t_lcp3_info_auth) > max ) max = sizeof(struct t_lcp3_info_auth);
	if ( sizeof(struct t_lcp3_info_ack) > max ) max = sizeof(struct t_lcp3_info_ack);
	if ( sizeof(struct t_lcp3_info_line) > max ) max = sizeof(struct t_lcp3_info_line);
	if ( sizeof(struct t_lcp3_info_tput) > max ) max = sizeof(struct t_lcp3_info_tput);
	if ( sizeof(struct t_lcp3_info_status) > max ) max = sizeof(struct t_lcp3_info_status);
	if ( sizeof(struct t_lcp3_info_isdn) > max ) max = sizeof(struct t_lcp3_info_isdn);
	if ( max != LCP3_MAX_INFO_SIZE )
	{
	    printf("\nERROR: biggest info struct != LCP3_MAX_INFO_SIZE\n");
	    printf("       biggest info struct == %d\n\n", max);
	    exit(2);
	}
	printf("\nLCP3 buffer sizes used by server are large enough.\n\n");
	exit(0);
}
