/***************************************************************************
                          lkey.cpp  -  description
                             -------------------
    begin                : Fri Feb 28 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <lineak/lkey.h>
#include <X11/Xlib.h>

int LKey::keycount = 0;

LKey::LKey() : LObject(null, PRESS, CODE) {
   keysym = 0x1008FF01 + keycount;
   keycount++;
   keycode = 0;
}
LKey::~LKey() {}
LKey::LKey(string name, int code) : LObject(name, PRESS, CODE) {
   keysym = 0x1008FF01 + keycount;
   keycount++;
   keycode = code;
}
void LKey::setKeySym(KeySym ikeysym) {
	keysym = ikeysym;
}
void LKey::setKeyCode(KeyCode code) {
	keycode = code;
}
void LKey::print(ostream&out)  {
   if (name != null) {
	out << "Object: " << name << endl;
	out << "   event_type = " << LObject::getEventTypeString() << endl;
	out << "   type = " << LObject::getTypeString() << endl;
	out << "   keycode = " << keycode << endl;
	out << "   keysym = " << keysym << endl;
	//out << "   modifier = " << getModifierString() << endl;
	//out << "   modifier numeric = " << modifier << endl;
	if (!isToggle()) {
		out << "   toggle = false" << endl;
		for (map<unsigned int,LCommand>::iterator i = commands.begin(); i!= commands.end(); i++) {
			out << "   modifier = " << LObject::getModifierString((i->first));
			out << " and command = " << commands[(i->first)] << endl;
		}		
		
	}
	else {
		out << "   toggle = true" << endl;
		out << "   number of toggle names = " << toggle_names.size() << endl;
		string s;
		for (unsigned int i = 0; i< toggle_names.size(); i++) {
		   s = toggle_names.front();
		   cout << "   toggle name = " << s << endl;
		   cout << "    and command = " << tog_commands[s];
		   toggle_names.pop();
		   toggle_names.push(s);
		}
		//for (map<string,LCommand>::const_iterator i = commands.begin(); i != commands.end(); i++)
		//	out << "    for togglename = " << i->first << " command = " << i->second << endl;
		//out << "   and non-toggle command = " << commands[name] << endl;
	}
        out << endl;
   } else
      cerr << "Attempting to output an empty key!" << endl;
}

ostream & operator<<(ostream &out, LKey &rhs) {
   rhs.print(out);
   return out;
}
