/***************************************************************************
                          lconfig.cpp  -  description
                             -------------------
    begin                : Fri Jan 17 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <lineak/lconfig.h>
#include <lineak/lineak_util_functions.h>
#include <lineak/lineak_core_functions.h>
#include <lineak/configdirectives.h>
#include <lineak/lkbd.h>
#include <lineak/lobject.h>
#include <lineak/lkey.h>
#include <lineak/lcommand.h>

using namespace lineak_util_functions;
using namespace lineak_core_functions;

//vector<string> LConfig::special_dirs;
//bool LConfig::special_dirs_init = false;

LConfig::LConfig() {

/* Setting defaults is no longer our problem.
	directives.addValue("KeyboardType", null);
	directives.addValue("conffilename", null);
	directives.addValue("CdromDevice", DEFAULT_CDROM_DEVICE);
	directives.addValue("MixerDevice", DEFAULT_MIXER_DEVICE);
	directives.addValue("Screensaver", null);

  	directives.addValue("Display_font", DISPLAY_FONT);
  	directives.addValue("Display_color", DISPLAY_COLOR);
  	directives.addValue("Display_pos", DISPLAY_POS);
  	directives.addValue("Display_align", DISPLAY_ALIGN);
  	directives.addValue("Display_timeout", DISPLAY_TIMEOUT);
  	directives.addValue("Display_hoffset", DISPLAY_HOFFSET);
  	directives.addValue("Display_voffset", DISPLAY_VOFFSET);
  	directives.addValue("Display_soffset", DISPLAY_SOFFSET);
*/
}
LConfig::LConfig(const LConfig & rhs) : LConfigData() {
	if (this != &rhs) {
		//comtable.clear();
		//comtable = rhs.comtable;
		//modtable.clear();
		//modtable = rhs.modtable;
		keycommtable = rhs.keycommtable;
		
                directives.clear();
    		directives = rhs.directives;
                vec.clear();
                vec = rhs.vec;
	}
}
LConfig & LConfig::operator=(const LConfig & rhs) {
	if (this != &rhs) {
		//comtable.clear();
		//comtable = rhs.comtable;
		//modtable.clear();
		//modtable = rhs.modtable;
		keycommtable = rhs.keycommtable;
		
                directives.clear();
    		directives = rhs.directives;
                vec.clear();
                vec = rhs.vec;
	}
	return *this;
}
LConfig::LConfig(ConfigDirectives &dirs) {
	directives = dirs;
	if (directives.isEmpty())
		error("Creating a config with no ConfigDirectives!");
}
LConfig::~LConfig(){
}
/** Empty all data */
void LConfig::clear() {
  directives.clear();
  keycommtable.clear();
  vec.clear();
}
/** Return a list of keynames that we have LCommands for. */
/*const vector<string>& LConfig::getCommandKeyNames(){
	vec.clear();
	for (map<const string, LCommand>::const_iterator i = comtable.begin(); i != comtable.end(); i++)
		vec.push_back(i->first);
	return vec;
} */
/** Return a map of commands indexed by keycodes. */
/* map<const int,  LCommand> LConfig::getKeyCommandIndex(const map< string, LObject*>& skeys) {
	map<const int,  LCommand> table;
	string comm;
	for ( map< string, LObject*>::const_iterator i = skeys.begin(); i != skeys.end(); i++ ) {
	   if( i->second->getType() == CODE || i->second->getType() == SYM ) {
	      const LKey * key = static_cast<const LKey*>(i->second);
	      table[key->getKeyCode()] = comtable[i->first];
	   }
	}
	return (table);
} */
/** Return a map of commands indexed by keycodes. */
/* map<const int,  LCommand> LConfig::getKeyCommandIndex(const LKbd& keyboard) {
	return (getKeyCommandIndex(keyboard.getObjects()));
} */
/** Return a map of commands indexed by keycodes. */
/* map<const unsigned int,  LCommand> LConfig::getButtonCommandIndex(const map< string, LObject*>& skeys) {
	map<const unsigned int,  LCommand> table;
	string comm;
	for ( map< string, LObject*>::const_iterator i = skeys.begin(); i != skeys.end(); i++ ) {
	   if( i->second->getType() == BUTTON ) {
	      const LKey * key = static_cast<const LKey*>(i->second);
	      table[key->getKeyCode()] = comtable[i->first];
	   }
	}
	return (table);
} */
/** Return a map of commands indexed by keycodes. */
/* map<const unsigned int,  LCommand> LConfig::getButtonCommandIndex(const LKbd& keyboard) {
	return (getButtonCommandIndex(keyboard.getObjects()));
} */
/* LCommand& LConfig::getCommand(const string& key) {
	return comtable[key];
} */
/*
void LConfig::setCommand(string key, LCommand command) {
	comtable[key] = command;
} */
/*
void LConfig::addKey(string key, LCommand command, bool respect_toggle) {
//  cout << "Setting command\n";
//  lineak_util_functions::inspect_vector(command.getArgs());
	if (!respect_toggle)
		setCommand(key, command);

} */
/** Add a name, modifier mapping to the modtable map */
/* void LConfig::addModifier(string key, unsigned int modifiers) {
   modtable[key] = modifiers;
} */
/** Get a modifier for a key */
/* unsigned int LConfig::getModifier(const string & key) {
   return modtable[key];
} */
string LConfig::getValue(string key) const {
	return directives.getValue(key);
}
void LConfig::setValue(string key, string value) {
	directives.addValue(key,value);
}
int LConfig::getIntValue(string key) const {
	return directives.getIntValue(key);
}
void LConfig::setValue(string key, int value) {
	directives.addValue(key,value);
}
/** Set the configfilename */
void LConfig::setFilename(string file) {
	directives.addValue("conffilename", file);
}
/** Add a keycomm to the configuration. */
void LConfig::addKeycomm(const string key, keycommand_info info) {
    map<const string, vector<keycommand_info> >::iterator it = keycommtable.begin();
    it = keycommtable.find(key);
    if (key.find('+') != string::npos)
       cerr << "WARNING, YOU ARE ADDING AN UNPARSED KEYNAME TO THE LCONFIG. THIS WILL NOT WORK!!!" << endl;
    if ( it == keycommtable.end() ) {
       vector<keycommand_info> tvec;
       tvec.push_back(info);
       keycommtable[key] = tvec;
    }
    else {
       keycommtable[key].push_back(info);
    }
}
vector<keycommand_info>& LConfig::getKeycomm(const string key) {
    map<const string, vector<keycommand_info> >::iterator it = keycommtable.begin();
    it = keycommtable.find(key);
    if ( it != keycommtable.end() ) {
       return (keycommtable[key]);
    }
    else {
       tv.clear();
       return tv;
    }
}
/** Is this an empty object? Our critieria of being empty is:
	if both the conffilename and KeyboardType values are undefined or null
	if the command table is empty
	*/
bool LConfig::isEmpty(){
	msg("Checking some isSet's to see if they are empty.");
	if ((!directives.isSet("KeyboardType") && !directives.isSet("conffilename")) || keycommtable.empty() )
		return false;
        msg("Checking the KeyboardType and conffilename to see if they are empty.");
	return ((directives.getValue("KeyboardType") == null) && (directives.getValue("conffilename") == null));
}
// /** UPdate the list of macros we support. */
// void LConfig::setDirectives(const vector<string>& directivelist) {
// 	if (specials_dirs_init)
// 		specials_dirs.clear();
// 
// 	special_dirs = directivelist;
// 	special_dirs_init = true;
// }

void LConfig::print(ostream &out) {
        //cout << "printing lconfig\n";
	string value;
    	out << CONF_HEADER;
	string kbtype, cd, mix, conf;

    	// WE MAY WANT TO JUST DO:  out << directives << endl;
	directives.print(out);
	out << endl;
	// Output all of the commands now.
    	LCommand command;
	for (map<const string, vector<keycommand_info> >::const_iterator i = keycommtable.begin(); i != keycommtable.end(); i++ ) {
	        const vector<keycommand_info>& comms = (i->second);
		
	        for (unsigned int j = 0; j < (i->second).size(); j++) {
		     out << comms[j].config_name << " = ";
		     command = comms[j].command;
		     out << command.getCommand() << endl;
		}
    	}
}
