#!/bin/bash

OLDNAME=podxtpro
NEWNAME=line6usb

function confirm {
    while /bin/true; do
	echo -n $1" "
	read answer
	if test $answer == y -o $answer == Y; then return 0; fi
	if test $answer == n -o $answer == N; then echo "Aborting..."; exit 1; fi
	echo "Please type 'y' or 'n'!"
    done
}

FOUND=0

# check privileges:
if test $UID != 0; then
    echo "This script must be run as root."
    echo "Aborting..."
    exit 1
fi

# remove RPM package:
if which rpm > /dev/null; then
    if rpm -q $OLDNAME > /dev/null; then
	FOUND=1
	echo
	if confirm "Uninstall old $OLDNAME RPM package (y/n)?"; then
	    if ! rpm -e $OLDNAME; then
		echo "Aborting..."
		exit 1
	    fi
	fi
    fi
fi

# unload driver:
if lsmod | grep $OLDNAME > /dev/null; then
    FOUND=1
    echo
    if confirm "Unload old $OLDNAME driver (y/n)?"; then
	if ! rmmod $OLDNAME; then
	    echo "Aborting..."
	    exit 1
	fi
    fi
fi

# remove kernel modules:
TMP=/tmp/$OLDNAME-kernel_modules_$$.txt
find /lib/modules -name "*$OLDNAME*" > $TMP

if test -s $TMP; then
    FOUND=1
    echo
    echo "The following files related to the old $OLDNAME driver have been found:"
    cat $TMP
    if confirm "Delete these files (y/n)? [ATTENTION: they cannot be restored!]"; then
	if ! rm -f `cat $TMP`; then
	    rm -f $TMP
	    echo "Aborting..."
	    exit 1
	fi
    fi
fi

rm -f $TMP

# success:
echo

if test $FOUND == 0; then
    echo "No old version of the $OLDNAME driver has been found on your system,"
else
    echo "The old $OLDNAME driver has been removed successfully,"
fi

echo "you can now install $NEWNAME version 0.6 or later."
