#!/usr/bin/perl

sub create_remove_files
{
    my $d = @_[0];
    print ctrl_c "\nint ${d}_create_files(int firmware, int type, struct device *dev) {\n\tint err;\n";

    foreach $i (0 .. $#index) {
	next if $device[$i] ne $d;
	$p = $param[$i];
	$b = $bits[$i];
	$fw = $firmware[$i];
	$cond[$i] = "";
	$cond[$i] .= "if((type & ($b)) != 0) " if($b ne "");
	$cond[$i] .= "if(firmware >= $fw) " if($fw ne "");
	print ctrl_c "\t".$cond[$i]."CHECK_RETURN(device_create_file(dev, &dev_attr_$p));\n";
    }

    print ctrl_c "  return 0;\n}\n\nvoid ${d}_remove_files(int firmware, int type, struct device *dev) {\n";

    foreach $i (0 .. $#index) {
	next if $device[$i] ne $d;
	$p = $param[$i];
	print ctrl_c "\t".$cond[$i]."device_remove_file(dev, &dev_attr_$p);\n";
    }

    print ctrl_c "}\n\nEXPORT_SYMBOL(${d}_create_files);\nEXPORT_SYMBOL(${d}_remove_files);\n";
}

# open files:
open(ctrl_h, "control.h");
open(ctrl_c, "> control.c.new");

# read parameters and indices:
while(<ctrl_h>) {
    next if !/(\w+?)_(\w+)\s*=\s*(\d+)/;
    $d = lc($1);
    next if $d eq "variaxmidi";  # these are handled separately
    $p = $2;
    $i = $3;
    $fw = /\/\*\s*firmware:\s*(.*?)\s*\*\// ? int($1 * 100) : "";
    $t = /\/\*\s*type:\s*(.*?)\s*\*\// ? $1 : "";
    $b = /\/\*\s*device:\s*(.*?)\s*\*\// ? $1 : "";
    push(@device, $d);
    push(@param, $p);
    push(@index, $i);
    push(@firmware, $fw);
    $f = $t =~ /float/;
    push(@bits, $b);
    push(@floatval, $f);
    push(@readwrite, $d ne "variax");
}

# print header:
open(ctrl_c_in, "control_intro.c");

while(<ctrl_c_in>) {
    print ctrl_c $_;
}

# access functions:
foreach $i (0 .. $#index) {
    $d = $device[$i];
    $D = uc($d);
    $p = $param[$i];
    $t = $floatval[$i] ? "float" : "int";
    $a = $readwrite[$i] ? "RW" : "R";
    print ctrl_c "${D}_PARAM_${a}(${t}, ${p});\n";
}

# device attributes:
print ctrl_c "\n";

foreach $i (0 .. $#index) {
    $d = $device[$i];
    $p1 = $param[$i];

    if($p1 =~ /__/) {
        $p2 = $p1;
        $p2 =~ s/__.*//;
        $attr = "ATTR2($p1, $p2";
    }
    else {
        $attr = "ATTR($p1";
    }

    if($readwrite[$i]) {
        print ctrl_c "static DEVICE_$attr, S_IWUGO | S_IRUGO, ${d}_get_$p1, ${d}_set_$p1);\n";
    }
    else {
        print ctrl_c "static DEVICE_$attr, S_IRUGO, ${d}_get_$p1, line6_nop_write);\n";
    }
}

# creation and removal procedures for sysfs entries, and symbol export:
create_remove_files("pod");
create_remove_files("variax");

# replace file if different:
if(system("diff --brief control.c control.c.new > /dev/null")) {
    unlink("control.c");
    rename("control.c.new", "control.c");
}
else {
    unlink("control.c.new");
}
