/*
 * =======================================================================================
 *
 *      Filename:  perfmon_icelakeX_counters.h
 *
 *      Description:  Counter Header File of perfmon module for Intel Icelake X.
 *
 *      Version:   5.3
 *      Released:  10.11.2023
 *
 *      Author:   Thomas Gruber (tr), thomas.roehl@googlemail.com
 *      Project:  likwid
 *
 *      Copyright (C) 2023 RRZE, University Erlangen-Nuremberg
 *
 *      This program is free software: you can redistribute it and/or modify it under
 *      the terms of the GNU General Public License as published by the Free Software
 *      Foundation, either version 3 of the License, or (at your option) any later
 *      version.
 *
 *      This program is distributed in the hope that it will be useful, but WITHOUT ANY
 *      WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 *      PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along with
 *      this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * =======================================================================================
 */

#define NUM_COUNTERS_ICELAKEX 408
#define NUM_COUNTERS_CORE_ICELAKEX 18
#define NUM_COUNTERS_UNCORE_ICELAKEX 21

#define ICX_VALID_OPTIONS_FIXED EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_COUNT_KERNEL_MASK
#define ICX_VALID_OPTIONS_PMC EVENT_OPTION_EDGE_MASK|EVENT_OPTION_COUNT_KERNEL_MASK|EVENT_OPTION_INVERT_MASK| \
            EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_IN_TRANS_MASK|EVENT_OPTION_THRESHOLD_MASK
#define ICX_VALID_OPTIONS_CBOX  EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|\
                                EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_TID_MASK

#define ICX_VALID_OPTIONS_UBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define ICX_VALID_OPTIONS_BBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define ICX_VALID_OPTIONS_SBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define ICX_VALID_OPTIONS_QBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_MATCH0_MASK
#define ICX_VALID_OPTIONS_WBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_OCCUPANCY_EDGE_MASK|EVENT_OPTION_OCCUPANCY_INVERT_MASK
#define ICX_VALID_OPTIONS_PBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define ICX_VALID_OPTIONS_IBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define ICX_VALID_OPTIONS_EUBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK

static RegisterMap icelakeX_counter_map[NUM_COUNTERS_ICELAKEX] = {
    /* Fixed Counters: instructions retired, cycles unhalted core */
    {"FIXC0", PMC0, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_FIXED},
    {"FIXC1", PMC1, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_FIXED},
    {"FIXC2", PMC2, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_FIXED},
    {"FIXC3", PMC3, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_FIXED},
    /* PMC Counters: 4 48bit wide */
    {"PMC0", PMC4, PMC, MSR_PERFEVTSEL0, MSR_PMC0, 0, MSR_DEV, ICX_VALID_OPTIONS_PMC},
    {"PMC1", PMC5, PMC, MSR_PERFEVTSEL1, MSR_PMC1, 0, MSR_DEV, ICX_VALID_OPTIONS_PMC},
    {"PMC2", PMC6, PMC, MSR_PERFEVTSEL2, MSR_PMC2, 0, MSR_DEV, ICX_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC3", PMC7, PMC, MSR_PERFEVTSEL3, MSR_PMC3, 0, MSR_DEV, ICX_VALID_OPTIONS_PMC},
    /* Additional PMC Counters if HyperThreading is not active: 4 48bit wide */
    {"PMC4", PMC8, PMC, MSR_PERFEVTSEL4, MSR_PMC4, 0, MSR_DEV, ICX_VALID_OPTIONS_PMC},
    {"PMC5", PMC9, PMC, MSR_PERFEVTSEL5, MSR_PMC5, 0, MSR_DEV, ICX_VALID_OPTIONS_PMC},
    {"PMC6", PMC10, PMC, MSR_PERFEVTSEL6, MSR_PMC6, 0, MSR_DEV, ICX_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC7", PMC11, PMC, MSR_PERFEVTSEL7, MSR_PMC7, 0, MSR_DEV, ICX_VALID_OPTIONS_PMC},
    /* Temperature Sensor*/
    {"TMP0", PMC12, THERMAL, 0, IA32_THERM_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Vcore Status*/
    {"VTG0", PMC13, VOLTAGE, 0, MSR_PERF_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Intel Performance Metrics (first level of TMA tree) */
    {"TMA0", PMC14, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA1", PMC15, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA2", PMC16, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA3", PMC17, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    /* RAPL counters */
    {"PWR0", PMC18, POWER, 0, MSR_PKG_ENERGY_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR1", PMC19, POWER, 0, MSR_PP0_ENERGY_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR2", PMC20, POWER, 0, MSR_PP1_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR3", PMC21, POWER, 0, MSR_DRAM_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR4", PMC22, POWER, 0, MSR_PLATFORM_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"MBOX0C0", PMC23, MBOX0, MMIO_ICX_IMC_BOX_CTL0, MMIO_ICX_IMC_BOX_CTR0, 0, MMIO_IMC_DEVICE_0_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX0C1", PMC24, MBOX0, MMIO_ICX_IMC_BOX_CTL1, MMIO_ICX_IMC_BOX_CTR1, 0, MMIO_IMC_DEVICE_0_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX0C2", PMC25, MBOX0, MMIO_ICX_IMC_BOX_CTL2, MMIO_ICX_IMC_BOX_CTR2, 0, MMIO_IMC_DEVICE_0_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX0C3", PMC26, MBOX0, MMIO_ICX_IMC_BOX_CTL3, MMIO_ICX_IMC_BOX_CTR3, 0, MMIO_IMC_DEVICE_0_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX1C0", PMC27, MBOX1, MMIO_ICX_IMC_BOX_CTL0, MMIO_ICX_IMC_BOX_CTR0, 0, MMIO_IMC_DEVICE_0_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX1C1", PMC28, MBOX1, MMIO_ICX_IMC_BOX_CTL1, MMIO_ICX_IMC_BOX_CTR1, 0, MMIO_IMC_DEVICE_0_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX1C2", PMC29, MBOX1, MMIO_ICX_IMC_BOX_CTL2, MMIO_ICX_IMC_BOX_CTR2, 0, MMIO_IMC_DEVICE_0_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX1C3", PMC30, MBOX1, MMIO_ICX_IMC_BOX_CTL3, MMIO_ICX_IMC_BOX_CTR3, 0, MMIO_IMC_DEVICE_0_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX2C0", PMC31, MBOX2, MMIO_ICX_IMC_BOX_CTL0, MMIO_ICX_IMC_BOX_CTR0, 0, MMIO_IMC_DEVICE_0_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX2C1", PMC32, MBOX2, MMIO_ICX_IMC_BOX_CTL1, MMIO_ICX_IMC_BOX_CTR1, 0, MMIO_IMC_DEVICE_0_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX2C2", PMC33, MBOX2, MMIO_ICX_IMC_BOX_CTL2, MMIO_ICX_IMC_BOX_CTR2, 0, MMIO_IMC_DEVICE_0_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX2C3", PMC34, MBOX2, MMIO_ICX_IMC_BOX_CTL3, MMIO_ICX_IMC_BOX_CTR3, 0, MMIO_IMC_DEVICE_0_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX3C0", PMC35, MBOX3, MMIO_ICX_IMC_BOX_CTL0, MMIO_ICX_IMC_BOX_CTR0, 0, MMIO_IMC_DEVICE_0_CH_3, EVENT_OPTION_NONE_MASK},
    {"MBOX3C1", PMC36, MBOX3, MMIO_ICX_IMC_BOX_CTL1, MMIO_ICX_IMC_BOX_CTR1, 0, MMIO_IMC_DEVICE_0_CH_3, EVENT_OPTION_NONE_MASK},
    {"MBOX3C2", PMC37, MBOX3, MMIO_ICX_IMC_BOX_CTL2, MMIO_ICX_IMC_BOX_CTR2, 0, MMIO_IMC_DEVICE_0_CH_3, EVENT_OPTION_NONE_MASK},
    {"MBOX3C3", PMC38, MBOX3, MMIO_ICX_IMC_BOX_CTL3, MMIO_ICX_IMC_BOX_CTR3, 0, MMIO_IMC_DEVICE_0_CH_3, EVENT_OPTION_NONE_MASK},
    {"MBOX4C0", PMC39, MBOX4, MMIO_ICX_IMC_BOX_CTL0, MMIO_ICX_IMC_BOX_CTR0, 0, MMIO_IMC_DEVICE_0_CH_4, EVENT_OPTION_NONE_MASK},
    {"MBOX4C1", PMC40, MBOX4, MMIO_ICX_IMC_BOX_CTL1, MMIO_ICX_IMC_BOX_CTR1, 0, MMIO_IMC_DEVICE_0_CH_4, EVENT_OPTION_NONE_MASK},
    {"MBOX4C2", PMC41, MBOX4, MMIO_ICX_IMC_BOX_CTL2, MMIO_ICX_IMC_BOX_CTR2, 0, MMIO_IMC_DEVICE_0_CH_4, EVENT_OPTION_NONE_MASK},
    {"MBOX4C3", PMC42, MBOX4, MMIO_ICX_IMC_BOX_CTL3, MMIO_ICX_IMC_BOX_CTR3, 0, MMIO_IMC_DEVICE_0_CH_4, EVENT_OPTION_NONE_MASK},
    {"MBOX5C0", PMC43, MBOX5, MMIO_ICX_IMC_BOX_CTL0, MMIO_ICX_IMC_BOX_CTR0, 0, MMIO_IMC_DEVICE_0_CH_5, EVENT_OPTION_NONE_MASK},
    {"MBOX5C1", PMC44, MBOX5, MMIO_ICX_IMC_BOX_CTL1, MMIO_ICX_IMC_BOX_CTR1, 0, MMIO_IMC_DEVICE_0_CH_5, EVENT_OPTION_NONE_MASK},
    {"MBOX5C2", PMC45, MBOX5, MMIO_ICX_IMC_BOX_CTL2, MMIO_ICX_IMC_BOX_CTR2, 0, MMIO_IMC_DEVICE_0_CH_5, EVENT_OPTION_NONE_MASK},
    {"MBOX5C3", PMC46, MBOX5, MMIO_ICX_IMC_BOX_CTL3, MMIO_ICX_IMC_BOX_CTR3, 0, MMIO_IMC_DEVICE_0_CH_5, EVENT_OPTION_NONE_MASK},
    {"MBOX6C0", PMC47, MBOX6, MMIO_ICX_IMC_BOX_CTL0, MMIO_ICX_IMC_BOX_CTR0, 0, MMIO_IMC_DEVICE_0_CH_6, EVENT_OPTION_NONE_MASK},
    {"MBOX6C1", PMC48, MBOX6, MMIO_ICX_IMC_BOX_CTL1, MMIO_ICX_IMC_BOX_CTR1, 0, MMIO_IMC_DEVICE_0_CH_6, EVENT_OPTION_NONE_MASK},
    {"MBOX6C2", PMC49, MBOX6, MMIO_ICX_IMC_BOX_CTL2, MMIO_ICX_IMC_BOX_CTR2, 0, MMIO_IMC_DEVICE_0_CH_6, EVENT_OPTION_NONE_MASK},
    {"MBOX6C3", PMC50, MBOX6, MMIO_ICX_IMC_BOX_CTL3, MMIO_ICX_IMC_BOX_CTR3, 0, MMIO_IMC_DEVICE_0_CH_6, EVENT_OPTION_NONE_MASK},
    {"MBOX7C0", PMC51, MBOX7, MMIO_ICX_IMC_BOX_CTL0, MMIO_ICX_IMC_BOX_CTR0, 0, MMIO_IMC_DEVICE_0_CH_7, EVENT_OPTION_NONE_MASK},
    {"MBOX7C1", PMC52, MBOX7, MMIO_ICX_IMC_BOX_CTL1, MMIO_ICX_IMC_BOX_CTR1, 0, MMIO_IMC_DEVICE_0_CH_7, EVENT_OPTION_NONE_MASK},
    {"MBOX7C2", PMC53, MBOX7, MMIO_ICX_IMC_BOX_CTL2, MMIO_ICX_IMC_BOX_CTR2, 0, MMIO_IMC_DEVICE_0_CH_7, EVENT_OPTION_NONE_MASK},
    {"MBOX7C3", PMC54, MBOX7, MMIO_ICX_IMC_BOX_CTL3, MMIO_ICX_IMC_BOX_CTR3, 0, MMIO_IMC_DEVICE_0_CH_7, EVENT_OPTION_NONE_MASK},
    {"CBOX0C0", PMC55, CBOX0, MSR_UNC_ICX_C0_PMON_CTL0, MSR_UNC_ICX_C0_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX0C1", PMC56, CBOX0, MSR_UNC_ICX_C0_PMON_CTL1, MSR_UNC_ICX_C0_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX0C2", PMC57, CBOX0, MSR_UNC_ICX_C0_PMON_CTL2, MSR_UNC_ICX_C0_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX0C3", PMC58, CBOX0, MSR_UNC_ICX_C0_PMON_CTL3, MSR_UNC_ICX_C0_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX1C0", PMC59, CBOX1, MSR_UNC_ICX_C1_PMON_CTL0, MSR_UNC_ICX_C1_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX1C1", PMC60, CBOX1, MSR_UNC_ICX_C1_PMON_CTL1, MSR_UNC_ICX_C1_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX1C2", PMC61, CBOX1, MSR_UNC_ICX_C1_PMON_CTL2, MSR_UNC_ICX_C1_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX1C3", PMC62, CBOX1, MSR_UNC_ICX_C1_PMON_CTL3, MSR_UNC_ICX_C1_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX2C0", PMC63, CBOX2, MSR_UNC_ICX_C2_PMON_CTL0, MSR_UNC_ICX_C2_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX2C1", PMC64, CBOX2, MSR_UNC_ICX_C2_PMON_CTL1, MSR_UNC_ICX_C2_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX2C2", PMC65, CBOX2, MSR_UNC_ICX_C2_PMON_CTL2, MSR_UNC_ICX_C2_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX2C3", PMC66, CBOX2, MSR_UNC_ICX_C2_PMON_CTL3, MSR_UNC_ICX_C2_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX3C0", PMC67, CBOX3, MSR_UNC_ICX_C3_PMON_CTL0, MSR_UNC_ICX_C3_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX3C1", PMC68, CBOX3, MSR_UNC_ICX_C3_PMON_CTL1, MSR_UNC_ICX_C3_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX3C2", PMC69, CBOX3, MSR_UNC_ICX_C3_PMON_CTL2, MSR_UNC_ICX_C3_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX3C3", PMC70, CBOX3, MSR_UNC_ICX_C3_PMON_CTL3, MSR_UNC_ICX_C3_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX4C0", PMC71, CBOX4, MSR_UNC_ICX_C4_PMON_CTL0, MSR_UNC_ICX_C4_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX4C1", PMC72, CBOX4, MSR_UNC_ICX_C4_PMON_CTL1, MSR_UNC_ICX_C4_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX4C2", PMC73, CBOX4, MSR_UNC_ICX_C4_PMON_CTL2, MSR_UNC_ICX_C4_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX4C3", PMC74, CBOX4, MSR_UNC_ICX_C4_PMON_CTL3, MSR_UNC_ICX_C4_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX5C0", PMC75, CBOX5, MSR_UNC_ICX_C5_PMON_CTL0, MSR_UNC_ICX_C5_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX5C1", PMC76, CBOX5, MSR_UNC_ICX_C5_PMON_CTL1, MSR_UNC_ICX_C5_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX5C2", PMC77, CBOX5, MSR_UNC_ICX_C5_PMON_CTL2, MSR_UNC_ICX_C5_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX5C3", PMC78, CBOX5, MSR_UNC_ICX_C5_PMON_CTL3, MSR_UNC_ICX_C5_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX6C0", PMC79, CBOX6, MSR_UNC_ICX_C6_PMON_CTL0, MSR_UNC_ICX_C6_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX6C1", PMC80, CBOX6, MSR_UNC_ICX_C6_PMON_CTL1, MSR_UNC_ICX_C6_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX6C2", PMC81, CBOX6, MSR_UNC_ICX_C6_PMON_CTL2, MSR_UNC_ICX_C6_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX6C3", PMC82, CBOX6, MSR_UNC_ICX_C6_PMON_CTL3, MSR_UNC_ICX_C6_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX7C0", PMC83, CBOX7, MSR_UNC_ICX_C7_PMON_CTL0, MSR_UNC_ICX_C7_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX7C1", PMC84, CBOX7, MSR_UNC_ICX_C7_PMON_CTL1, MSR_UNC_ICX_C7_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX7C2", PMC85, CBOX7, MSR_UNC_ICX_C7_PMON_CTL2, MSR_UNC_ICX_C7_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX7C3", PMC86, CBOX7, MSR_UNC_ICX_C7_PMON_CTL3, MSR_UNC_ICX_C7_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX8C0", PMC87, CBOX8, MSR_UNC_ICX_C8_PMON_CTL0, MSR_UNC_ICX_C8_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX8C1", PMC88, CBOX8, MSR_UNC_ICX_C8_PMON_CTL1, MSR_UNC_ICX_C8_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX8C2", PMC89, CBOX8, MSR_UNC_ICX_C8_PMON_CTL2, MSR_UNC_ICX_C8_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX8C3", PMC90, CBOX8, MSR_UNC_ICX_C8_PMON_CTL3, MSR_UNC_ICX_C8_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX9C0", PMC91, CBOX9, MSR_UNC_ICX_C9_PMON_CTL0, MSR_UNC_ICX_C9_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX9C1", PMC92, CBOX9, MSR_UNC_ICX_C9_PMON_CTL1, MSR_UNC_ICX_C9_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX9C2", PMC93, CBOX9, MSR_UNC_ICX_C9_PMON_CTL2, MSR_UNC_ICX_C9_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX9C3", PMC94, CBOX9, MSR_UNC_ICX_C9_PMON_CTL3, MSR_UNC_ICX_C9_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX10C0", PMC95, CBOX10, MSR_UNC_ICX_C10_PMON_CTL0, MSR_UNC_ICX_C10_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX10C1", PMC96, CBOX10, MSR_UNC_ICX_C10_PMON_CTL1, MSR_UNC_ICX_C10_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX10C2", PMC97, CBOX10, MSR_UNC_ICX_C10_PMON_CTL2, MSR_UNC_ICX_C10_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX10C3", PMC98, CBOX10, MSR_UNC_ICX_C10_PMON_CTL3, MSR_UNC_ICX_C10_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX11C0", PMC99, CBOX11, MSR_UNC_ICX_C11_PMON_CTL0, MSR_UNC_ICX_C11_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX11C1", PMC100, CBOX11, MSR_UNC_ICX_C11_PMON_CTL1, MSR_UNC_ICX_C11_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX11C2", PMC101, CBOX11, MSR_UNC_ICX_C11_PMON_CTL2, MSR_UNC_ICX_C11_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX11C3", PMC102, CBOX11, MSR_UNC_ICX_C11_PMON_CTL3, MSR_UNC_ICX_C11_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX12C0", PMC103, CBOX12, MSR_UNC_ICX_C12_PMON_CTL0, MSR_UNC_ICX_C12_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX12C1", PMC104, CBOX12, MSR_UNC_ICX_C12_PMON_CTL1, MSR_UNC_ICX_C12_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX12C2", PMC105, CBOX12, MSR_UNC_ICX_C12_PMON_CTL2, MSR_UNC_ICX_C12_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX12C3", PMC106, CBOX12, MSR_UNC_ICX_C12_PMON_CTL3, MSR_UNC_ICX_C12_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX13C0", PMC107, CBOX13, MSR_UNC_ICX_C13_PMON_CTL0, MSR_UNC_ICX_C13_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX13C1", PMC108, CBOX13, MSR_UNC_ICX_C13_PMON_CTL1, MSR_UNC_ICX_C13_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX13C2", PMC109, CBOX13, MSR_UNC_ICX_C13_PMON_CTL2, MSR_UNC_ICX_C13_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX13C3", PMC110, CBOX13, MSR_UNC_ICX_C13_PMON_CTL3, MSR_UNC_ICX_C13_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX14C0", PMC111, CBOX14, MSR_UNC_ICX_C14_PMON_CTL0, MSR_UNC_ICX_C14_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX14C1", PMC112, CBOX14, MSR_UNC_ICX_C14_PMON_CTL1, MSR_UNC_ICX_C14_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX14C2", PMC113, CBOX14, MSR_UNC_ICX_C14_PMON_CTL2, MSR_UNC_ICX_C14_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX14C3", PMC114, CBOX14, MSR_UNC_ICX_C14_PMON_CTL3, MSR_UNC_ICX_C14_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX15C0", PMC115, CBOX15, MSR_UNC_ICX_C15_PMON_CTL0, MSR_UNC_ICX_C15_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX15C1", PMC116, CBOX15, MSR_UNC_ICX_C15_PMON_CTL1, MSR_UNC_ICX_C15_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX15C2", PMC117, CBOX15, MSR_UNC_ICX_C15_PMON_CTL2, MSR_UNC_ICX_C15_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX15C3", PMC118, CBOX15, MSR_UNC_ICX_C15_PMON_CTL3, MSR_UNC_ICX_C15_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX16C0", PMC119, CBOX16, MSR_UNC_ICX_C16_PMON_CTL0, MSR_UNC_ICX_C16_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX16C1", PMC120, CBOX16, MSR_UNC_ICX_C16_PMON_CTL1, MSR_UNC_ICX_C16_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX16C2", PMC121, CBOX16, MSR_UNC_ICX_C16_PMON_CTL2, MSR_UNC_ICX_C16_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX16C3", PMC122, CBOX16, MSR_UNC_ICX_C16_PMON_CTL3, MSR_UNC_ICX_C16_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX17C0", PMC123, CBOX17, MSR_UNC_ICX_C17_PMON_CTL0, MSR_UNC_ICX_C17_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX17C1", PMC124, CBOX17, MSR_UNC_ICX_C17_PMON_CTL1, MSR_UNC_ICX_C17_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX17C2", PMC125, CBOX17, MSR_UNC_ICX_C17_PMON_CTL2, MSR_UNC_ICX_C17_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX17C3", PMC126, CBOX17, MSR_UNC_ICX_C17_PMON_CTL3, MSR_UNC_ICX_C17_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX18C0", PMC127, CBOX18, MSR_UNC_ICX_C18_PMON_CTL0, MSR_UNC_ICX_C18_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX18C1", PMC128, CBOX18, MSR_UNC_ICX_C18_PMON_CTL1, MSR_UNC_ICX_C18_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX18C2", PMC129, CBOX18, MSR_UNC_ICX_C18_PMON_CTL2, MSR_UNC_ICX_C18_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX18C3", PMC130, CBOX18, MSR_UNC_ICX_C18_PMON_CTL3, MSR_UNC_ICX_C18_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX19C0", PMC131, CBOX19, MSR_UNC_ICX_C19_PMON_CTL0, MSR_UNC_ICX_C19_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX19C1", PMC132, CBOX19, MSR_UNC_ICX_C19_PMON_CTL1, MSR_UNC_ICX_C19_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX19C2", PMC133, CBOX19, MSR_UNC_ICX_C19_PMON_CTL2, MSR_UNC_ICX_C19_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX19C3", PMC134, CBOX19, MSR_UNC_ICX_C19_PMON_CTL3, MSR_UNC_ICX_C19_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX20C0", PMC135, CBOX20, MSR_UNC_ICX_C20_PMON_CTL0, MSR_UNC_ICX_C20_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX20C1", PMC136, CBOX20, MSR_UNC_ICX_C20_PMON_CTL1, MSR_UNC_ICX_C20_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX20C2", PMC137, CBOX20, MSR_UNC_ICX_C20_PMON_CTL2, MSR_UNC_ICX_C20_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX20C3", PMC138, CBOX20, MSR_UNC_ICX_C20_PMON_CTL3, MSR_UNC_ICX_C20_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX21C0", PMC139, CBOX21, MSR_UNC_ICX_C21_PMON_CTL0, MSR_UNC_ICX_C21_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX21C1", PMC140, CBOX21, MSR_UNC_ICX_C21_PMON_CTL1, MSR_UNC_ICX_C21_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX21C2", PMC141, CBOX21, MSR_UNC_ICX_C21_PMON_CTL2, MSR_UNC_ICX_C21_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX21C3", PMC142, CBOX21, MSR_UNC_ICX_C21_PMON_CTL3, MSR_UNC_ICX_C21_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX22C0", PMC143, CBOX22, MSR_UNC_ICX_C22_PMON_CTL0, MSR_UNC_ICX_C22_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX22C1", PMC144, CBOX22, MSR_UNC_ICX_C22_PMON_CTL1, MSR_UNC_ICX_C22_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX22C2", PMC145, CBOX22, MSR_UNC_ICX_C22_PMON_CTL2, MSR_UNC_ICX_C22_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX22C3", PMC146, CBOX22, MSR_UNC_ICX_C22_PMON_CTL3, MSR_UNC_ICX_C22_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX23C0", PMC147, CBOX23, MSR_UNC_ICX_C23_PMON_CTL0, MSR_UNC_ICX_C23_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX23C1", PMC148, CBOX23, MSR_UNC_ICX_C23_PMON_CTL1, MSR_UNC_ICX_C23_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX23C2", PMC149, CBOX23, MSR_UNC_ICX_C23_PMON_CTL2, MSR_UNC_ICX_C23_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX23C3", PMC150, CBOX23, MSR_UNC_ICX_C23_PMON_CTL3, MSR_UNC_ICX_C23_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX24C0", PMC151, CBOX24, MSR_UNC_ICX_C24_PMON_CTL0, MSR_UNC_ICX_C24_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX24C1", PMC152, CBOX24, MSR_UNC_ICX_C24_PMON_CTL1, MSR_UNC_ICX_C24_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX24C2", PMC153, CBOX24, MSR_UNC_ICX_C24_PMON_CTL2, MSR_UNC_ICX_C24_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX24C3", PMC154, CBOX24, MSR_UNC_ICX_C24_PMON_CTL3, MSR_UNC_ICX_C24_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX25C0", PMC155, CBOX25, MSR_UNC_ICX_C25_PMON_CTL0, MSR_UNC_ICX_C25_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX25C1", PMC156, CBOX25, MSR_UNC_ICX_C25_PMON_CTL1, MSR_UNC_ICX_C25_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX25C2", PMC157, CBOX25, MSR_UNC_ICX_C25_PMON_CTL2, MSR_UNC_ICX_C25_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX25C3", PMC158, CBOX25, MSR_UNC_ICX_C25_PMON_CTL3, MSR_UNC_ICX_C25_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX26C0", PMC159, CBOX26, MSR_UNC_ICX_C26_PMON_CTL0, MSR_UNC_ICX_C26_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX26C1", PMC160, CBOX26, MSR_UNC_ICX_C26_PMON_CTL1, MSR_UNC_ICX_C26_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX26C2", PMC161, CBOX26, MSR_UNC_ICX_C26_PMON_CTL2, MSR_UNC_ICX_C26_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX26C3", PMC162, CBOX26, MSR_UNC_ICX_C26_PMON_CTL3, MSR_UNC_ICX_C26_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX27C0", PMC163, CBOX27, MSR_UNC_ICX_C27_PMON_CTL0, MSR_UNC_ICX_C27_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX27C1", PMC164, CBOX27, MSR_UNC_ICX_C27_PMON_CTL1, MSR_UNC_ICX_C27_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX27C2", PMC165, CBOX27, MSR_UNC_ICX_C27_PMON_CTL2, MSR_UNC_ICX_C27_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX27C3", PMC166, CBOX27, MSR_UNC_ICX_C27_PMON_CTL3, MSR_UNC_ICX_C27_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX28C0", PMC167, CBOX28, MSR_UNC_ICX_C28_PMON_CTL0, MSR_UNC_ICX_C28_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX28C1", PMC168, CBOX28, MSR_UNC_ICX_C28_PMON_CTL1, MSR_UNC_ICX_C28_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX28C2", PMC169, CBOX28, MSR_UNC_ICX_C28_PMON_CTL2, MSR_UNC_ICX_C28_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX28C3", PMC170, CBOX28, MSR_UNC_ICX_C28_PMON_CTL3, MSR_UNC_ICX_C28_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX29C0", PMC171, CBOX29, MSR_UNC_ICX_C29_PMON_CTL0, MSR_UNC_ICX_C29_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX29C1", PMC172, CBOX29, MSR_UNC_ICX_C29_PMON_CTL1, MSR_UNC_ICX_C29_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX29C2", PMC173, CBOX29, MSR_UNC_ICX_C29_PMON_CTL2, MSR_UNC_ICX_C29_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX29C3", PMC174, CBOX29, MSR_UNC_ICX_C29_PMON_CTL3, MSR_UNC_ICX_C29_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX30C0", PMC175, CBOX30, MSR_UNC_ICX_C30_PMON_CTL0, MSR_UNC_ICX_C30_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX30C1", PMC176, CBOX30, MSR_UNC_ICX_C30_PMON_CTL1, MSR_UNC_ICX_C30_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX30C2", PMC177, CBOX30, MSR_UNC_ICX_C30_PMON_CTL2, MSR_UNC_ICX_C30_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX30C3", PMC178, CBOX30, MSR_UNC_ICX_C30_PMON_CTL3, MSR_UNC_ICX_C30_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX31C0", PMC179, CBOX31, MSR_UNC_ICX_C31_PMON_CTL0, MSR_UNC_ICX_C31_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX31C1", PMC180, CBOX31, MSR_UNC_ICX_C31_PMON_CTL1, MSR_UNC_ICX_C31_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX31C2", PMC181, CBOX31, MSR_UNC_ICX_C31_PMON_CTL2, MSR_UNC_ICX_C31_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX31C3", PMC182, CBOX31, MSR_UNC_ICX_C31_PMON_CTL3, MSR_UNC_ICX_C31_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX32C0", PMC183, CBOX32, MSR_UNC_ICX_C32_PMON_CTL0, MSR_UNC_ICX_C32_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX32C1", PMC184, CBOX32, MSR_UNC_ICX_C32_PMON_CTL1, MSR_UNC_ICX_C32_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX32C2", PMC185, CBOX32, MSR_UNC_ICX_C32_PMON_CTL2, MSR_UNC_ICX_C32_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX32C3", PMC186, CBOX32, MSR_UNC_ICX_C32_PMON_CTL3, MSR_UNC_ICX_C32_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX33C0", PMC187, CBOX33, MSR_UNC_ICX_C33_PMON_CTL0, MSR_UNC_ICX_C33_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX33C1", PMC188, CBOX33, MSR_UNC_ICX_C33_PMON_CTL1, MSR_UNC_ICX_C33_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX33C2", PMC189, CBOX33, MSR_UNC_ICX_C33_PMON_CTL2, MSR_UNC_ICX_C33_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX33C3", PMC190, CBOX33, MSR_UNC_ICX_C33_PMON_CTL3, MSR_UNC_ICX_C33_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX34C0", PMC191, CBOX34, MSR_UNC_ICX_C34_PMON_CTL0, MSR_UNC_ICX_C34_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX34C1", PMC192, CBOX34, MSR_UNC_ICX_C34_PMON_CTL1, MSR_UNC_ICX_C34_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX34C2", PMC193, CBOX34, MSR_UNC_ICX_C34_PMON_CTL2, MSR_UNC_ICX_C34_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX34C3", PMC194, CBOX34, MSR_UNC_ICX_C34_PMON_CTL3, MSR_UNC_ICX_C34_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX35C0", PMC195, CBOX35, MSR_UNC_ICX_C35_PMON_CTL0, MSR_UNC_ICX_C35_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX35C1", PMC196, CBOX35, MSR_UNC_ICX_C35_PMON_CTL1, MSR_UNC_ICX_C35_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX35C2", PMC197, CBOX35, MSR_UNC_ICX_C35_PMON_CTL2, MSR_UNC_ICX_C35_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX35C3", PMC198, CBOX35, MSR_UNC_ICX_C35_PMON_CTL3, MSR_UNC_ICX_C35_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX36C0", PMC199, CBOX36, MSR_UNC_ICX_C36_PMON_CTL0, MSR_UNC_ICX_C36_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX36C1", PMC200, CBOX36, MSR_UNC_ICX_C36_PMON_CTL1, MSR_UNC_ICX_C36_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX36C2", PMC201, CBOX36, MSR_UNC_ICX_C36_PMON_CTL2, MSR_UNC_ICX_C36_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX36C3", PMC202, CBOX36, MSR_UNC_ICX_C36_PMON_CTL3, MSR_UNC_ICX_C36_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX37C0", PMC203, CBOX37, MSR_UNC_ICX_C37_PMON_CTL0, MSR_UNC_ICX_C37_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX37C1", PMC204, CBOX37, MSR_UNC_ICX_C37_PMON_CTL1, MSR_UNC_ICX_C37_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX37C2", PMC205, CBOX37, MSR_UNC_ICX_C37_PMON_CTL2, MSR_UNC_ICX_C37_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX37C3", PMC206, CBOX37, MSR_UNC_ICX_C37_PMON_CTL3, MSR_UNC_ICX_C37_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX38C0", PMC207, CBOX38, MSR_UNC_ICX_C38_PMON_CTL0, MSR_UNC_ICX_C38_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX38C1", PMC208, CBOX38, MSR_UNC_ICX_C38_PMON_CTL1, MSR_UNC_ICX_C38_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX38C2", PMC209, CBOX38, MSR_UNC_ICX_C38_PMON_CTL2, MSR_UNC_ICX_C38_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX38C3", PMC210, CBOX38, MSR_UNC_ICX_C38_PMON_CTL3, MSR_UNC_ICX_C38_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX39C0", PMC211, CBOX39, MSR_UNC_ICX_C39_PMON_CTL0, MSR_UNC_ICX_C39_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX39C1", PMC212, CBOX39, MSR_UNC_ICX_C39_PMON_CTL1, MSR_UNC_ICX_C39_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX39C2", PMC213, CBOX39, MSR_UNC_ICX_C39_PMON_CTL2, MSR_UNC_ICX_C39_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"CBOX39C3", PMC214, CBOX39, MSR_UNC_ICX_C39_PMON_CTL3, MSR_UNC_ICX_C39_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_CBOX},
    {"UBOXFIX", PMC215, UBOXFIX, MSR_UNC_ICX_U_PMON_GLOBAL_UCLK_CTL, MSR_UNC_ICX_U_PMON_GLOBAL_UCLK_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"UBOX0", PMC216, UBOX, MSR_UNC_ICX_U_PMON_CTL0, MSR_UNC_ICX_U_PMON_CTR0, 1, MSR_DEV, ICX_VALID_OPTIONS_UBOX},
    {"UBOX1", PMC217, UBOX, MSR_UNC_ICX_U_PMON_CTL1, MSR_UNC_ICX_U_PMON_CTR1, 1, MSR_DEV, ICX_VALID_OPTIONS_UBOX},
    {"M2M0C0", PMC218, BBOX0, PCI_UNC_ICX_M2M_PMON_CTL0, PCI_UNC_ICX_M2M_PMON_CTR0, -1, PCI_HA_DEVICE_0, ICX_VALID_OPTIONS_BBOX},
    {"M2M0C1", PMC219, BBOX0, PCI_UNC_ICX_M2M_PMON_CTL1, PCI_UNC_ICX_M2M_PMON_CTR1, -1, PCI_HA_DEVICE_0, ICX_VALID_OPTIONS_BBOX},
    {"M2M0C2", PMC220, BBOX0, PCI_UNC_ICX_M2M_PMON_CTL2, PCI_UNC_ICX_M2M_PMON_CTR2, -1, PCI_HA_DEVICE_0, ICX_VALID_OPTIONS_BBOX},
    {"M2M0C3", PMC221, BBOX0, PCI_UNC_ICX_M2M_PMON_CTL3, PCI_UNC_ICX_M2M_PMON_CTR3, -1, PCI_HA_DEVICE_0, ICX_VALID_OPTIONS_BBOX},
    {"M2M1C0", PMC222, BBOX1, PCI_UNC_ICX_M2M_PMON_CTL0, PCI_UNC_ICX_M2M_PMON_CTR0, -1, PCI_HA_DEVICE_1, ICX_VALID_OPTIONS_BBOX},
    {"M2M1C1", PMC223, BBOX1, PCI_UNC_ICX_M2M_PMON_CTL1, PCI_UNC_ICX_M2M_PMON_CTR1, -1, PCI_HA_DEVICE_1, ICX_VALID_OPTIONS_BBOX},
    {"M2M1C2", PMC224, BBOX1, PCI_UNC_ICX_M2M_PMON_CTL2, PCI_UNC_ICX_M2M_PMON_CTR2, -1, PCI_HA_DEVICE_1, ICX_VALID_OPTIONS_BBOX},
    {"M2M1C3", PMC225, BBOX1, PCI_UNC_ICX_M2M_PMON_CTL3, PCI_UNC_ICX_M2M_PMON_CTR3, -1, PCI_HA_DEVICE_1, ICX_VALID_OPTIONS_BBOX},
    {"M2M2C0", PMC226, BBOX2, PCI_UNC_ICX_M2M_PMON_CTL0, PCI_UNC_ICX_M2M_PMON_CTR0, -1, PCI_HA_DEVICE_2, ICX_VALID_OPTIONS_BBOX},
    {"M2M2C1", PMC227, BBOX2, PCI_UNC_ICX_M2M_PMON_CTL1, PCI_UNC_ICX_M2M_PMON_CTR1, -1, PCI_HA_DEVICE_2, ICX_VALID_OPTIONS_BBOX},
    {"M2M2C2", PMC228, BBOX2, PCI_UNC_ICX_M2M_PMON_CTL2, PCI_UNC_ICX_M2M_PMON_CTR2, -1, PCI_HA_DEVICE_2, ICX_VALID_OPTIONS_BBOX},
    {"M2M2C3", PMC229, BBOX2, PCI_UNC_ICX_M2M_PMON_CTL3, PCI_UNC_ICX_M2M_PMON_CTR3, -1, PCI_HA_DEVICE_2, ICX_VALID_OPTIONS_BBOX},
    {"M2M3C0", PMC230, BBOX3, PCI_UNC_ICX_M2M_PMON_CTL0, PCI_UNC_ICX_M2M_PMON_CTR0, -1, PCI_HA_DEVICE_3, ICX_VALID_OPTIONS_BBOX},
    {"M2M3C1", PMC231, BBOX3, PCI_UNC_ICX_M2M_PMON_CTL1, PCI_UNC_ICX_M2M_PMON_CTR1, -1, PCI_HA_DEVICE_3, ICX_VALID_OPTIONS_BBOX},
    {"M2M3C2", PMC232, BBOX3, PCI_UNC_ICX_M2M_PMON_CTL2, PCI_UNC_ICX_M2M_PMON_CTR2, -1, PCI_HA_DEVICE_3, ICX_VALID_OPTIONS_BBOX},
    {"M2M3C3", PMC233, BBOX3, PCI_UNC_ICX_M2M_PMON_CTL3, PCI_UNC_ICX_M2M_PMON_CTR3, -1, PCI_HA_DEVICE_3, ICX_VALID_OPTIONS_BBOX},
    {"WBOX0", PMC234, WBOX, MSR_UNC_ICX_PCU_PMON_CTL0, MSR_UNC_ICX_PCU_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_WBOX},
    {"WBOX1", PMC235, WBOX, MSR_UNC_ICX_PCU_PMON_CTL1, MSR_UNC_ICX_PCU_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_WBOX},
    {"WBOX2", PMC236, WBOX, MSR_UNC_ICX_PCU_PMON_CTL2, MSR_UNC_ICX_PCU_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_WBOX},
    {"WBOX3", PMC237, WBOX, MSR_UNC_ICX_PCU_PMON_CTL3, MSR_UNC_ICX_PCU_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_WBOX},
    {"SBOX0C0", PMC238, SBOX0, PCI_UNC_ICX_M3UPI_PMON_CTL0, PCI_UNC_ICX_M3UPI_PMON_CTR0, -1, PCI_R3QPI_DEVICE_LINK_0, ICX_VALID_OPTIONS_SBOX},
    {"SBOX0C1", PMC239, SBOX0, PCI_UNC_ICX_M3UPI_PMON_CTL1, PCI_UNC_ICX_M3UPI_PMON_CTR1, -1, PCI_R3QPI_DEVICE_LINK_0, ICX_VALID_OPTIONS_SBOX},
    {"SBOX0C2", PMC240, SBOX0, PCI_UNC_ICX_M3UPI_PMON_CTL2, PCI_UNC_ICX_M3UPI_PMON_CTR2, -1, PCI_R3QPI_DEVICE_LINK_0, ICX_VALID_OPTIONS_SBOX},
    {"SBOX0C3", PMC241, SBOX0, PCI_UNC_ICX_M3UPI_PMON_CTL3, PCI_UNC_ICX_M3UPI_PMON_CTR3, -1, PCI_R3QPI_DEVICE_LINK_0, ICX_VALID_OPTIONS_SBOX},
    {"SBOX1C0", PMC242, SBOX1, PCI_UNC_ICX_M3UPI_PMON_CTL0, PCI_UNC_ICX_M3UPI_PMON_CTR0, -1, PCI_R3QPI_DEVICE_LINK_1, ICX_VALID_OPTIONS_SBOX},
    {"SBOX1C1", PMC243, SBOX1, PCI_UNC_ICX_M3UPI_PMON_CTL1, PCI_UNC_ICX_M3UPI_PMON_CTR1, -1, PCI_R3QPI_DEVICE_LINK_1, ICX_VALID_OPTIONS_SBOX},
    {"SBOX1C2", PMC244, SBOX1, PCI_UNC_ICX_M3UPI_PMON_CTL2, PCI_UNC_ICX_M3UPI_PMON_CTR2, -1, PCI_R3QPI_DEVICE_LINK_1, ICX_VALID_OPTIONS_SBOX},
    {"SBOX1C3", PMC245, SBOX1, PCI_UNC_ICX_M3UPI_PMON_CTL3, PCI_UNC_ICX_M3UPI_PMON_CTR3, -1, PCI_R3QPI_DEVICE_LINK_1, ICX_VALID_OPTIONS_SBOX},
    {"SBOX2C0", PMC246, SBOX2, PCI_UNC_ICX_M3UPI_PMON_CTL0, PCI_UNC_ICX_M3UPI_PMON_CTR0, -1, PCI_R3QPI_DEVICE_LINK_2, ICX_VALID_OPTIONS_SBOX},
    {"SBOX2C1", PMC247, SBOX2, PCI_UNC_ICX_M3UPI_PMON_CTL1, PCI_UNC_ICX_M3UPI_PMON_CTR1, -1, PCI_R3QPI_DEVICE_LINK_2, ICX_VALID_OPTIONS_SBOX},
    {"SBOX2C2", PMC248, SBOX2, PCI_UNC_ICX_M3UPI_PMON_CTL2, PCI_UNC_ICX_M3UPI_PMON_CTR2, -1, PCI_R3QPI_DEVICE_LINK_2, ICX_VALID_OPTIONS_SBOX},
    {"SBOX2C3", PMC249, SBOX2, PCI_UNC_ICX_M3UPI_PMON_CTL3, PCI_UNC_ICX_M3UPI_PMON_CTR3, -1, PCI_R3QPI_DEVICE_LINK_2, ICX_VALID_OPTIONS_SBOX},
    {"QBOX0C0", PMC250, QBOX0, PCI_UNC_ICX_UPI_PMON_CTL0, PCI_UNC_ICX_UPI_PMON_CTR0, -1, PCI_QPI_DEVICE_PORT_0, ICX_VALID_OPTIONS_QBOX},
    {"QBOX0C1", PMC251, QBOX0, PCI_UNC_ICX_UPI_PMON_CTL1, PCI_UNC_ICX_UPI_PMON_CTR1, -1, PCI_QPI_DEVICE_PORT_0, ICX_VALID_OPTIONS_QBOX},
    {"QBOX0C2", PMC252, QBOX0, PCI_UNC_ICX_UPI_PMON_CTL2, PCI_UNC_ICX_UPI_PMON_CTR2, -1, PCI_QPI_DEVICE_PORT_0, ICX_VALID_OPTIONS_QBOX},
    {"QBOX0C3", PMC253, QBOX0, PCI_UNC_ICX_UPI_PMON_CTL3, PCI_UNC_ICX_UPI_PMON_CTR3, -1, PCI_QPI_DEVICE_PORT_0, ICX_VALID_OPTIONS_QBOX},
    {"QBOX1C0", PMC254, QBOX1, PCI_UNC_ICX_UPI_PMON_CTL0, PCI_UNC_ICX_UPI_PMON_CTR0, -1, PCI_QPI_DEVICE_PORT_1, ICX_VALID_OPTIONS_QBOX},
    {"QBOX1C1", PMC255, QBOX1, PCI_UNC_ICX_UPI_PMON_CTL1, PCI_UNC_ICX_UPI_PMON_CTR1, -1, PCI_QPI_DEVICE_PORT_1, ICX_VALID_OPTIONS_QBOX},
    {"QBOX1C2", PMC256, QBOX1, PCI_UNC_ICX_UPI_PMON_CTL2, PCI_UNC_ICX_UPI_PMON_CTR2, -1, PCI_QPI_DEVICE_PORT_1, ICX_VALID_OPTIONS_QBOX},
    {"QBOX1C3", PMC257, QBOX1, PCI_UNC_ICX_UPI_PMON_CTL3, PCI_UNC_ICX_UPI_PMON_CTR3, -1, PCI_QPI_DEVICE_PORT_1, ICX_VALID_OPTIONS_QBOX},
    {"QBOX2C0", PMC258, QBOX2, PCI_UNC_ICX_UPI_PMON_CTL0, PCI_UNC_ICX_UPI_PMON_CTR0, -1, PCI_QPI_DEVICE_PORT_2, ICX_VALID_OPTIONS_QBOX},
    {"QBOX2C1", PMC259, QBOX2, PCI_UNC_ICX_UPI_PMON_CTL1, PCI_UNC_ICX_UPI_PMON_CTR1, -1, PCI_QPI_DEVICE_PORT_2, ICX_VALID_OPTIONS_QBOX},
    {"QBOX2C2", PMC260, QBOX2, PCI_UNC_ICX_UPI_PMON_CTL2, PCI_UNC_ICX_UPI_PMON_CTR2, -1, PCI_QPI_DEVICE_PORT_2, ICX_VALID_OPTIONS_QBOX},
    {"QBOX2C3", PMC261, QBOX2, PCI_UNC_ICX_UPI_PMON_CTL3, PCI_UNC_ICX_UPI_PMON_CTR3, -1, PCI_QPI_DEVICE_PORT_2, ICX_VALID_OPTIONS_QBOX},
    {"PBOX0C0", PMC262, PBOX, MSR_UNC_M2IOSF_M2PCIE0_PMON_CTL0, MSR_UNC_M2IOSF_M2PCIE0_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX0C1", PMC263, PBOX, MSR_UNC_M2IOSF_M2PCIE0_PMON_CTL1, MSR_UNC_M2IOSF_M2PCIE0_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX0C2", PMC264, PBOX, MSR_UNC_M2IOSF_M2PCIE0_PMON_CTL2, MSR_UNC_M2IOSF_M2PCIE0_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX0C3", PMC265, PBOX, MSR_UNC_M2IOSF_M2PCIE0_PMON_CTL3, MSR_UNC_M2IOSF_M2PCIE0_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX1C0", PMC266, PBOX1, MSR_UNC_M2IOSF_M2PCIE1_PMON_CTL0, MSR_UNC_M2IOSF_M2PCIE1_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX1C1", PMC267, PBOX1, MSR_UNC_M2IOSF_M2PCIE1_PMON_CTL1, MSR_UNC_M2IOSF_M2PCIE1_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX1C2", PMC268, PBOX1, MSR_UNC_M2IOSF_M2PCIE1_PMON_CTL2, MSR_UNC_M2IOSF_M2PCIE1_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX1C3", PMC269, PBOX1, MSR_UNC_M2IOSF_M2PCIE1_PMON_CTL3, MSR_UNC_M2IOSF_M2PCIE1_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX2C0", PMC270, PBOX2, MSR_UNC_M2IOSF_M2PCIE2_PMON_CTL0, MSR_UNC_M2IOSF_M2PCIE2_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX2C1", PMC271, PBOX2, MSR_UNC_M2IOSF_M2PCIE2_PMON_CTL1, MSR_UNC_M2IOSF_M2PCIE2_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX2C2", PMC272, PBOX2, MSR_UNC_M2IOSF_M2PCIE2_PMON_CTL2, MSR_UNC_M2IOSF_M2PCIE2_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX2C3", PMC273, PBOX2, MSR_UNC_M2IOSF_M2PCIE2_PMON_CTL3, MSR_UNC_M2IOSF_M2PCIE2_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX3C0", PMC274, PBOX3, MSR_UNC_M2IOSF_M2PCIE3_PMON_CTL0, MSR_UNC_M2IOSF_M2PCIE3_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX3C1", PMC275, PBOX3, MSR_UNC_M2IOSF_M2PCIE3_PMON_CTL1, MSR_UNC_M2IOSF_M2PCIE3_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX3C2", PMC276, PBOX3, MSR_UNC_M2IOSF_M2PCIE3_PMON_CTL2, MSR_UNC_M2IOSF_M2PCIE3_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX3C3", PMC277, PBOX3, MSR_UNC_M2IOSF_M2PCIE3_PMON_CTL3, MSR_UNC_M2IOSF_M2PCIE3_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX4C0", PMC278, PBOX4, MSR_UNC_M2IOSF_M2PCIE4_PMON_CTL0, MSR_UNC_M2IOSF_M2PCIE4_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX4C1", PMC279, PBOX4, MSR_UNC_M2IOSF_M2PCIE4_PMON_CTL1, MSR_UNC_M2IOSF_M2PCIE4_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX4C2", PMC280, PBOX4, MSR_UNC_M2IOSF_M2PCIE4_PMON_CTL2, MSR_UNC_M2IOSF_M2PCIE4_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX4C3", PMC281, PBOX4, MSR_UNC_M2IOSF_M2PCIE4_PMON_CTL3, MSR_UNC_M2IOSF_M2PCIE4_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX5C0", PMC282, PBOX5, MSR_UNC_M2IOSF_M2PCIE5_PMON_CTL0, MSR_UNC_M2IOSF_M2PCIE5_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX5C1", PMC283, PBOX5, MSR_UNC_M2IOSF_M2PCIE5_PMON_CTL1, MSR_UNC_M2IOSF_M2PCIE5_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX5C2", PMC284, PBOX5, MSR_UNC_M2IOSF_M2PCIE5_PMON_CTL2, MSR_UNC_M2IOSF_M2PCIE5_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"PBOX5C3", PMC285, PBOX5, MSR_UNC_M2IOSF_M2PCIE5_PMON_CTL3, MSR_UNC_M2IOSF_M2PCIE5_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_PBOX},
    {"IBOX0C0", PMC286, IBOX0, MSR_UNC_M2IOSF_IRP0_PMON_CTL0, MSR_UNC_M2IOSF_IRP0_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX0C1", PMC287, IBOX0, MSR_UNC_M2IOSF_IRP0_PMON_CTL1, MSR_UNC_M2IOSF_IRP0_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX1C0", PMC288, IBOX1, MSR_UNC_M2IOSF_IRP1_PMON_CTL0, MSR_UNC_M2IOSF_IRP1_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX1C1", PMC289, IBOX1, MSR_UNC_M2IOSF_IRP1_PMON_CTL1, MSR_UNC_M2IOSF_IRP1_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX2C0", PMC290, IBOX2, MSR_UNC_M2IOSF_IRP2_PMON_CTL0, MSR_UNC_M2IOSF_IRP2_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX2C1", PMC291, IBOX2, MSR_UNC_M2IOSF_IRP2_PMON_CTL1, MSR_UNC_M2IOSF_IRP2_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX3C0", PMC292, IBOX3, MSR_UNC_M2IOSF_IRP3_PMON_CTL0, MSR_UNC_M2IOSF_IRP3_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX3C1", PMC293, IBOX3, MSR_UNC_M2IOSF_IRP3_PMON_CTL1, MSR_UNC_M2IOSF_IRP3_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX4C0", PMC294, IBOX4, MSR_UNC_M2IOSF_IRP4_PMON_CTL0, MSR_UNC_M2IOSF_IRP4_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX4C1", PMC295, IBOX4, MSR_UNC_M2IOSF_IRP4_PMON_CTL1, MSR_UNC_M2IOSF_IRP4_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX5C0", PMC296, IBOX5, MSR_UNC_M2IOSF_IRP5_PMON_CTL0, MSR_UNC_M2IOSF_IRP5_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"IBOX5C1", PMC297, IBOX5, MSR_UNC_M2IOSF_IRP5_PMON_CTL1, MSR_UNC_M2IOSF_IRP5_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_IBOX},
    {"TCBOX0C0", PMC298, EUBOX0, MSR_UNC_M2IOSF_TC0_PMON_CTL0, MSR_UNC_M2IOSF_TC0_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX0C1", PMC299, EUBOX0, MSR_UNC_M2IOSF_TC0_PMON_CTL1, MSR_UNC_M2IOSF_TC0_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX0C2", PMC300, EUBOX0, MSR_UNC_M2IOSF_TC0_PMON_CTL2, MSR_UNC_M2IOSF_TC0_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX0C3", PMC301, EUBOX0, MSR_UNC_M2IOSF_TC0_PMON_CTL3, MSR_UNC_M2IOSF_TC0_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOXFIX0", PMC302, EUBOX0FIX, 0, MSR_UNC_M2IOSF_TC0_PMON_CLK, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"TCBOX1C0", PMC303, EUBOX1, MSR_UNC_M2IOSF_TC1_PMON_CTL0, MSR_UNC_M2IOSF_TC1_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX1C1", PMC304, EUBOX1, MSR_UNC_M2IOSF_TC1_PMON_CTL1, MSR_UNC_M2IOSF_TC1_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX1C2", PMC305, EUBOX1, MSR_UNC_M2IOSF_TC1_PMON_CTL2, MSR_UNC_M2IOSF_TC1_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX1C3", PMC306, EUBOX1, MSR_UNC_M2IOSF_TC1_PMON_CTL3, MSR_UNC_M2IOSF_TC1_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOXFIX1", PMC307, EUBOX1FIX, 0, MSR_UNC_M2IOSF_TC1_PMON_CLK, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"TCBOX2C0", PMC308, EUBOX2, MSR_UNC_M2IOSF_TC2_PMON_CTL0, MSR_UNC_M2IOSF_TC2_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX2C1", PMC309, EUBOX2, MSR_UNC_M2IOSF_TC2_PMON_CTL1, MSR_UNC_M2IOSF_TC2_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX2C2", PMC310, EUBOX2, MSR_UNC_M2IOSF_TC2_PMON_CTL2, MSR_UNC_M2IOSF_TC2_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX2C3", PMC311, EUBOX2, MSR_UNC_M2IOSF_TC2_PMON_CTL3, MSR_UNC_M2IOSF_TC2_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOXFIX2", PMC312, EUBOX2FIX, 0, MSR_UNC_M2IOSF_TC2_PMON_CLK, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"TCBOX3C0", PMC313, EUBOX3, MSR_UNC_M2IOSF_TC3_PMON_CTL0, MSR_UNC_M2IOSF_TC3_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX3C1", PMC314, EUBOX3, MSR_UNC_M2IOSF_TC3_PMON_CTL1, MSR_UNC_M2IOSF_TC3_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX3C2", PMC315, EUBOX3, MSR_UNC_M2IOSF_TC3_PMON_CTL2, MSR_UNC_M2IOSF_TC3_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX3C3", PMC316, EUBOX3, MSR_UNC_M2IOSF_TC3_PMON_CTL3, MSR_UNC_M2IOSF_TC3_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOXFIX3", PMC317, EUBOX3FIX, 0, MSR_UNC_M2IOSF_TC3_PMON_CLK, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"TCBOX4C0", PMC318, EUBOX4, MSR_UNC_M2IOSF_TC4_PMON_CTL0, MSR_UNC_M2IOSF_TC4_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX4C1", PMC319, EUBOX4, MSR_UNC_M2IOSF_TC4_PMON_CTL1, MSR_UNC_M2IOSF_TC4_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX4C2", PMC320, EUBOX4, MSR_UNC_M2IOSF_TC4_PMON_CTL2, MSR_UNC_M2IOSF_TC4_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX4C3", PMC321, EUBOX4, MSR_UNC_M2IOSF_TC4_PMON_CTL3, MSR_UNC_M2IOSF_TC4_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOXFIX4", PMC322, EUBOX4FIX, 0, MSR_UNC_M2IOSF_TC4_PMON_CLK, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"TCBOX5C0", PMC323, EUBOX5, MSR_UNC_M2IOSF_TC5_PMON_CTL0, MSR_UNC_M2IOSF_TC5_PMON_CTR0, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX5C1", PMC324, EUBOX5, MSR_UNC_M2IOSF_TC5_PMON_CTL1, MSR_UNC_M2IOSF_TC5_PMON_CTR1, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX5C2", PMC325, EUBOX5, MSR_UNC_M2IOSF_TC5_PMON_CTL2, MSR_UNC_M2IOSF_TC5_PMON_CTR2, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOX5C3", PMC326, EUBOX5, MSR_UNC_M2IOSF_TC5_PMON_CTL3, MSR_UNC_M2IOSF_TC5_PMON_CTR3, 0, MSR_DEV, ICX_VALID_OPTIONS_EUBOX},
    {"TCBOXFIX5", PMC327, EUBOX5FIX, 0, MSR_UNC_M2IOSF_TC5_PMON_CLK, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX0PORT0", PMC328, IBOX0FIX, 0, MSR_UNC_M2IOSF_IIO0_PMON_PORT0, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX0PORT1", PMC329, IBOX0FIX, 0, MSR_UNC_M2IOSF_IIO0_PMON_PORT1, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX0PORT2", PMC330, IBOX0FIX, 0, MSR_UNC_M2IOSF_IIO0_PMON_PORT2, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX0PORT3", PMC331, IBOX0FIX, 0, MSR_UNC_M2IOSF_IIO0_PMON_PORT3, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX0PORT4", PMC332, IBOX0FIX, 0, MSR_UNC_M2IOSF_IIO0_PMON_PORT4, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX0PORT5", PMC333, IBOX0FIX, 0, MSR_UNC_M2IOSF_IIO0_PMON_PORT5, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX0PORT6", PMC334, IBOX0FIX, 0, MSR_UNC_M2IOSF_IIO0_PMON_PORT6, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX0PORT7", PMC335, IBOX0FIX, 0, MSR_UNC_M2IOSF_IIO0_PMON_PORT7, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX1PORT0", PMC336, IBOX1FIX, 0, MSR_UNC_M2IOSF_IIO1_PMON_PORT0, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX1PORT1", PMC337, IBOX1FIX, 0, MSR_UNC_M2IOSF_IIO1_PMON_PORT1, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX1PORT2", PMC338, IBOX1FIX, 0, MSR_UNC_M2IOSF_IIO1_PMON_PORT2, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX1PORT3", PMC339, IBOX1FIX, 0, MSR_UNC_M2IOSF_IIO1_PMON_PORT3, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX1PORT4", PMC340, IBOX1FIX, 0, MSR_UNC_M2IOSF_IIO1_PMON_PORT4, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX1PORT5", PMC341, IBOX1FIX, 0, MSR_UNC_M2IOSF_IIO1_PMON_PORT5, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX1PORT6", PMC342, IBOX1FIX, 0, MSR_UNC_M2IOSF_IIO1_PMON_PORT6, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX1PORT7", PMC343, IBOX1FIX, 0, MSR_UNC_M2IOSF_IIO1_PMON_PORT7, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX2PORT0", PMC344, IBOX2FIX, 0, MSR_UNC_M2IOSF_IIO2_PMON_PORT0, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX2PORT1", PMC345, IBOX2FIX, 0, MSR_UNC_M2IOSF_IIO2_PMON_PORT1, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX2PORT2", PMC346, IBOX2FIX, 0, MSR_UNC_M2IOSF_IIO2_PMON_PORT2, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX2PORT3", PMC347, IBOX2FIX, 0, MSR_UNC_M2IOSF_IIO2_PMON_PORT3, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX2PORT4", PMC348, IBOX2FIX, 0, MSR_UNC_M2IOSF_IIO2_PMON_PORT4, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX2PORT5", PMC349, IBOX2FIX, 0, MSR_UNC_M2IOSF_IIO2_PMON_PORT5, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX2PORT6", PMC350, IBOX2FIX, 0, MSR_UNC_M2IOSF_IIO2_PMON_PORT6, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX2PORT7", PMC351, IBOX2FIX, 0, MSR_UNC_M2IOSF_IIO2_PMON_PORT7, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX3PORT0", PMC352, IBOX3FIX, 0, MSR_UNC_M2IOSF_IIO3_PMON_PORT0, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX3PORT1", PMC353, IBOX3FIX, 0, MSR_UNC_M2IOSF_IIO3_PMON_PORT1, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX3PORT2", PMC354, IBOX3FIX, 0, MSR_UNC_M2IOSF_IIO3_PMON_PORT2, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX3PORT3", PMC355, IBOX3FIX, 0, MSR_UNC_M2IOSF_IIO3_PMON_PORT3, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX3PORT4", PMC356, IBOX3FIX, 0, MSR_UNC_M2IOSF_IIO3_PMON_PORT4, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX3PORT5", PMC357, IBOX3FIX, 0, MSR_UNC_M2IOSF_IIO3_PMON_PORT5, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX3PORT6", PMC358, IBOX3FIX, 0, MSR_UNC_M2IOSF_IIO3_PMON_PORT6, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX3PORT7", PMC359, IBOX3FIX, 0, MSR_UNC_M2IOSF_IIO3_PMON_PORT7, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX4PORT0", PMC360, IBOX4FIX, 0, MSR_UNC_M2IOSF_IIO4_PMON_PORT0, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX4PORT1", PMC361, IBOX4FIX, 0, MSR_UNC_M2IOSF_IIO4_PMON_PORT1, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX4PORT2", PMC362, IBOX4FIX, 0, MSR_UNC_M2IOSF_IIO4_PMON_PORT2, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX4PORT3", PMC363, IBOX4FIX, 0, MSR_UNC_M2IOSF_IIO4_PMON_PORT3, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX4PORT4", PMC364, IBOX4FIX, 0, MSR_UNC_M2IOSF_IIO4_PMON_PORT4, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX4PORT5", PMC365, IBOX4FIX, 0, MSR_UNC_M2IOSF_IIO4_PMON_PORT5, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX4PORT6", PMC366, IBOX4FIX, 0, MSR_UNC_M2IOSF_IIO4_PMON_PORT6, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX4PORT7", PMC367, IBOX4FIX, 0, MSR_UNC_M2IOSF_IIO4_PMON_PORT7, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX5PORT0", PMC368, IBOX5FIX, 0, MSR_UNC_M2IOSF_IIO5_PMON_PORT0, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX5PORT1", PMC369, IBOX5FIX, 0, MSR_UNC_M2IOSF_IIO5_PMON_PORT1, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX5PORT2", PMC370, IBOX5FIX, 0, MSR_UNC_M2IOSF_IIO5_PMON_PORT2, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX5PORT3", PMC371, IBOX5FIX, 0, MSR_UNC_M2IOSF_IIO5_PMON_PORT3, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX5PORT4", PMC372, IBOX5FIX, 0, MSR_UNC_M2IOSF_IIO5_PMON_PORT4, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX5PORT5", PMC373, IBOX5FIX, 0, MSR_UNC_M2IOSF_IIO5_PMON_PORT5, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX5PORT6", PMC374, IBOX5FIX, 0, MSR_UNC_M2IOSF_IIO5_PMON_PORT6, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"IBOX5PORT7", PMC375, IBOX5FIX, 0, MSR_UNC_M2IOSF_IIO5_PMON_PORT7, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"WBOX0FIX", PMC376, WBOX0FIX, 0, MSR_UNC_V3_PCU_CC3_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"WBOX1FIX", PMC377, WBOX0FIX, 0, MSR_UNC_V3_PCU_CC6_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"WBOX2FIX", PMC378, WBOX0FIX, 0, MSR_UNC_V3_PCU_PC3_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"WBOX3FIX", PMC379, WBOX0FIX, 0, MSR_UNC_V3_PCU_PC6_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"MDEV0C0", PMC380, MDEV0, 0, MMIO_ICX_IMC_FREERUN_DDR_RD, 0, MMIO_IMC_DEVICE_0_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV0C1", PMC381, MDEV0, 0, MMIO_ICX_IMC_FREERUN_DDR_WR, 0, MMIO_IMC_DEVICE_0_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV0C2", PMC382, MDEV0, 0, MMIO_ICX_IMC_FREERUN_PMM_RD, 0, MMIO_IMC_DEVICE_0_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV0C3", PMC383, MDEV0, 0, MMIO_ICX_IMC_FREERUN_PMM_WR, 0, MMIO_IMC_DEVICE_0_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV0C4", PMC384, MDEV0, 0, MMIO_ICX_IMC_FREERUN_DCLK, 0, MMIO_IMC_DEVICE_0_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV1C0", PMC385, MDEV1, 0, MMIO_ICX_IMC_FREERUN_DDR_RD, 0, MMIO_IMC_DEVICE_1_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV1C1", PMC386, MDEV1, 0, MMIO_ICX_IMC_FREERUN_DDR_WR, 0, MMIO_IMC_DEVICE_1_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV1C2", PMC387, MDEV1, 0, MMIO_ICX_IMC_FREERUN_PMM_RD, 0, MMIO_IMC_DEVICE_1_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV1C3", PMC388, MDEV1, 0, MMIO_ICX_IMC_FREERUN_PMM_WR, 0, MMIO_IMC_DEVICE_1_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV1C4", PMC389, MDEV1, 0, MMIO_ICX_IMC_FREERUN_DCLK, 0, MMIO_IMC_DEVICE_1_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV2C0", PMC390, MDEV2, 0, MMIO_ICX_IMC_FREERUN_DDR_RD, 0, MMIO_IMC_DEVICE_2_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV2C1", PMC391, MDEV2, 0, MMIO_ICX_IMC_FREERUN_DDR_WR, 0, MMIO_IMC_DEVICE_2_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV2C2", PMC392, MDEV2, 0, MMIO_ICX_IMC_FREERUN_PMM_RD, 0, MMIO_IMC_DEVICE_2_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV2C3", PMC393, MDEV2, 0, MMIO_ICX_IMC_FREERUN_PMM_WR, 0, MMIO_IMC_DEVICE_2_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV2C4", PMC394, MDEV2, 0, MMIO_ICX_IMC_FREERUN_DCLK, 0, MMIO_IMC_DEVICE_2_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV3C0", PMC395, MDEV3, 0, MMIO_ICX_IMC_FREERUN_DDR_RD, 0, MMIO_IMC_DEVICE_3_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV3C1", PMC396, MDEV3, 0, MMIO_ICX_IMC_FREERUN_DDR_WR, 0, MMIO_IMC_DEVICE_3_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV3C2", PMC397, MDEV3, 0, MMIO_ICX_IMC_FREERUN_PMM_RD, 0, MMIO_IMC_DEVICE_3_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV3C3", PMC398, MDEV3, 0, MMIO_ICX_IMC_FREERUN_PMM_WR, 0, MMIO_IMC_DEVICE_3_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MDEV3C4", PMC399, MDEV3, 0, MMIO_ICX_IMC_FREERUN_DCLK, 0, MMIO_IMC_DEVICE_3_FREERUN, EVENT_OPTION_NONE_MASK},
    {"MBOX0FIX", PMC400, MBOX0FIX, MMIO_ICX_IMC_BOX_CLK_CTL, MMIO_ICX_IMC_BOX_CLK_CTR, 0, MMIO_IMC_DEVICE_0_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX1FIX", PMC401, MBOX1FIX, MMIO_ICX_IMC_BOX_CLK_CTL, MMIO_ICX_IMC_BOX_CLK_CTR, 0, MMIO_IMC_DEVICE_0_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX2FIX", PMC402, MBOX2FIX, MMIO_ICX_IMC_BOX_CLK_CTL, MMIO_ICX_IMC_BOX_CLK_CTR, 0, MMIO_IMC_DEVICE_0_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX3FIX", PMC403, MBOX3FIX, MMIO_ICX_IMC_BOX_CLK_CTL, MMIO_ICX_IMC_BOX_CLK_CTR, 0, MMIO_IMC_DEVICE_0_CH_3, EVENT_OPTION_NONE_MASK},
    {"MBOX4FIX", PMC404, MBOX4FIX, MMIO_ICX_IMC_BOX_CLK_CTL, MMIO_ICX_IMC_BOX_CLK_CTR, 0, MMIO_IMC_DEVICE_0_CH_4, EVENT_OPTION_NONE_MASK},
    {"MBOX5FIX", PMC405, MBOX5FIX, MMIO_ICX_IMC_BOX_CLK_CTL, MMIO_ICX_IMC_BOX_CLK_CTR, 0, MMIO_IMC_DEVICE_0_CH_5, EVENT_OPTION_NONE_MASK},
    {"MBOX5FIX", PMC406, MBOX6FIX, MMIO_ICX_IMC_BOX_CLK_CTL, MMIO_ICX_IMC_BOX_CLK_CTR, 0, MMIO_IMC_DEVICE_0_CH_6, EVENT_OPTION_NONE_MASK},
    {"MBOX7FIX", PMC407, MBOX7FIX, MMIO_ICX_IMC_BOX_CLK_CTL, MMIO_ICX_IMC_BOX_CLK_CTR, 0, MMIO_IMC_DEVICE_0_CH_7, EVENT_OPTION_NONE_MASK},
};


static BoxMap icelakeX_box_map[NUM_UNITS] = {
    [FIXED] =  {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48},
    [PMC] = {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48},
    [THERMAL] = {0, 0, 0, 0, 0, 0, 8},
    [POWER] = {0, 0, 0, 0, 0, 0, 32},
    [VOLTAGE] = {0, 0, 0, 0, 0, 0, 16},
    [METRICS] = {0, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS, 48, 0, 0, 8},
    [MBOX0] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_0, 48, 0},
    [MBOX1] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_1, 48, 0},
    [MBOX2] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_2, 48, 0},
    [MBOX3] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_3, 48, 0},
    [MBOX4] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_4, 48, 0},
    [MBOX5] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_5, 48, 0},
    [MBOX6] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_6, 48, 0},
    [MBOX7] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_7, 48, 0},
    [MBOX0FIX] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_0, 48, 0},
    [MBOX1FIX] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_1, 48, 0},
    [MBOX2FIX] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_2, 48, 0},
    [MBOX3FIX] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_3, 48, 0},
    [MBOX4FIX] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_4, 48, 0},
    [MBOX5FIX] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_5, 48, 0},
    [MBOX6FIX] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_6, 48, 0},
    [MBOX7FIX] = {MMIO_ICX_IMC_BOX_CTRL, MMIO_ICX_IMC_BOX_STATUS, MMIO_ICX_IMC_BOX_STATUS,0, 1, MMIO_IMC_DEVICE_0_CH_7, 48, 0},
    [MDEV0] = {0, 0, 0, 0, 1, MMIO_IMC_DEVICE_0_FREERUN, 64},
    [MDEV1] = {0, 0, 0, 0, 1, MMIO_IMC_DEVICE_1_FREERUN, 64},
    [MDEV2] = {0, 0, 0, 0, 1, MMIO_IMC_DEVICE_2_FREERUN, 64},
    [MDEV3] = {0, 0, 0, 0, 1, MMIO_IMC_DEVICE_3_FREERUN, 64},
    [CBOX0] = {MSR_UNC_ICX_C0_PMON_CTRL, MSR_UNC_ICX_C0_PMON_STATUS, MSR_UNC_ICX_C0_PMON_STATUS, 0, 0, MSR_DEV, 48, MSR_UNC_ICX_C0_PMON_FILTER},
    [CBOX1] = {MSR_UNC_ICX_C1_PMON_CTRL, MSR_UNC_ICX_C1_PMON_STATUS, MSR_UNC_ICX_C1_PMON_STATUS, 1, 0, MSR_DEV, 48, MSR_UNC_ICX_C1_PMON_FILTER},
    [CBOX2] = {MSR_UNC_ICX_C2_PMON_CTRL, MSR_UNC_ICX_C2_PMON_STATUS, MSR_UNC_ICX_C2_PMON_STATUS, 2, 0, MSR_DEV, 48, MSR_UNC_ICX_C2_PMON_FILTER},
    [CBOX3] = {MSR_UNC_ICX_C3_PMON_CTRL, MSR_UNC_ICX_C3_PMON_STATUS, MSR_UNC_ICX_C3_PMON_STATUS, 3, 0, MSR_DEV, 48, MSR_UNC_ICX_C3_PMON_FILTER},
    [CBOX4] = {MSR_UNC_ICX_C4_PMON_CTRL, MSR_UNC_ICX_C4_PMON_STATUS, MSR_UNC_ICX_C4_PMON_STATUS, 4, 0, MSR_DEV, 48, MSR_UNC_ICX_C4_PMON_FILTER},
    [CBOX5] = {MSR_UNC_ICX_C5_PMON_CTRL, MSR_UNC_ICX_C5_PMON_STATUS, MSR_UNC_ICX_C5_PMON_STATUS, 5, 0, MSR_DEV, 48, MSR_UNC_ICX_C5_PMON_FILTER},
    [CBOX6] = {MSR_UNC_ICX_C6_PMON_CTRL, MSR_UNC_ICX_C6_PMON_STATUS, MSR_UNC_ICX_C6_PMON_STATUS, 6, 0, MSR_DEV, 48, MSR_UNC_ICX_C6_PMON_FILTER},
    [CBOX7] = {MSR_UNC_ICX_C7_PMON_CTRL, MSR_UNC_ICX_C7_PMON_STATUS, MSR_UNC_ICX_C7_PMON_STATUS, 7, 0, MSR_DEV, 48, MSR_UNC_ICX_C7_PMON_FILTER},
    [CBOX8] = {MSR_UNC_ICX_C8_PMON_CTRL, MSR_UNC_ICX_C8_PMON_STATUS, MSR_UNC_ICX_C8_PMON_STATUS, 8, 0, MSR_DEV, 48, MSR_UNC_ICX_C8_PMON_FILTER},
    [CBOX9] = {MSR_UNC_ICX_C9_PMON_CTRL, MSR_UNC_ICX_C9_PMON_STATUS, MSR_UNC_ICX_C9_PMON_STATUS, 9, 0, MSR_DEV, 48, MSR_UNC_ICX_C9_PMON_FILTER},
    [CBOX10] = {MSR_UNC_ICX_C10_PMON_CTRL, MSR_UNC_ICX_C10_PMON_STATUS, MSR_UNC_ICX_C10_PMON_STATUS, 10, 0, MSR_DEV, 48, MSR_UNC_ICX_C10_PMON_FILTER},
    [CBOX11] = {MSR_UNC_ICX_C11_PMON_CTRL, MSR_UNC_ICX_C11_PMON_STATUS, MSR_UNC_ICX_C11_PMON_STATUS, 11, 0, MSR_DEV, 48, MSR_UNC_ICX_C11_PMON_FILTER},
    [CBOX12] = {MSR_UNC_ICX_C12_PMON_CTRL, MSR_UNC_ICX_C12_PMON_STATUS, MSR_UNC_ICX_C12_PMON_STATUS, 12, 0, MSR_DEV, 48, MSR_UNC_ICX_C12_PMON_FILTER},
    [CBOX13] = {MSR_UNC_ICX_C13_PMON_CTRL, MSR_UNC_ICX_C13_PMON_STATUS, MSR_UNC_ICX_C13_PMON_STATUS, 13, 0, MSR_DEV, 48, MSR_UNC_ICX_C13_PMON_FILTER},
    [CBOX14] = {MSR_UNC_ICX_C14_PMON_CTRL, MSR_UNC_ICX_C14_PMON_STATUS, MSR_UNC_ICX_C14_PMON_STATUS, 14, 0, MSR_DEV, 48, MSR_UNC_ICX_C14_PMON_FILTER},
    [CBOX15] = {MSR_UNC_ICX_C15_PMON_CTRL, MSR_UNC_ICX_C15_PMON_STATUS, MSR_UNC_ICX_C15_PMON_STATUS, 15, 0, MSR_DEV, 48, MSR_UNC_ICX_C15_PMON_FILTER},
    [CBOX16] = {MSR_UNC_ICX_C16_PMON_CTRL, MSR_UNC_ICX_C16_PMON_STATUS, MSR_UNC_ICX_C16_PMON_STATUS, 16, 0, MSR_DEV, 48, MSR_UNC_ICX_C16_PMON_FILTER},
    [CBOX17] = {MSR_UNC_ICX_C17_PMON_CTRL, MSR_UNC_ICX_C17_PMON_STATUS, MSR_UNC_ICX_C17_PMON_STATUS, 17, 0, MSR_DEV, 48, MSR_UNC_ICX_C17_PMON_FILTER},
    [CBOX18] = {MSR_UNC_ICX_C18_PMON_CTRL, MSR_UNC_ICX_C18_PMON_STATUS, MSR_UNC_ICX_C18_PMON_STATUS, 18, 0, MSR_DEV, 48, MSR_UNC_ICX_C18_PMON_FILTER},
    [CBOX19] = {MSR_UNC_ICX_C19_PMON_CTRL, MSR_UNC_ICX_C19_PMON_STATUS, MSR_UNC_ICX_C19_PMON_STATUS, 19, 0, MSR_DEV, 48, MSR_UNC_ICX_C19_PMON_FILTER},
    [CBOX20] = {MSR_UNC_ICX_C20_PMON_CTRL, MSR_UNC_ICX_C20_PMON_STATUS, MSR_UNC_ICX_C20_PMON_STATUS, 20, 0, MSR_DEV, 48, MSR_UNC_ICX_C20_PMON_FILTER},
    [CBOX21] = {MSR_UNC_ICX_C21_PMON_CTRL, MSR_UNC_ICX_C21_PMON_STATUS, MSR_UNC_ICX_C21_PMON_STATUS, 21, 0, MSR_DEV, 48, MSR_UNC_ICX_C21_PMON_FILTER},
    [CBOX22] = {MSR_UNC_ICX_C22_PMON_CTRL, MSR_UNC_ICX_C22_PMON_STATUS, MSR_UNC_ICX_C22_PMON_STATUS, 22, 0, MSR_DEV, 48, MSR_UNC_ICX_C22_PMON_FILTER},
    [CBOX23] = {MSR_UNC_ICX_C23_PMON_CTRL, MSR_UNC_ICX_C23_PMON_STATUS, MSR_UNC_ICX_C23_PMON_STATUS, 23, 0, MSR_DEV, 48, MSR_UNC_ICX_C23_PMON_FILTER},
    [CBOX24] = {MSR_UNC_ICX_C24_PMON_CTRL, MSR_UNC_ICX_C24_PMON_STATUS, MSR_UNC_ICX_C24_PMON_STATUS, 24, 0, MSR_DEV, 48, MSR_UNC_ICX_C24_PMON_FILTER},
    [CBOX25] = {MSR_UNC_ICX_C25_PMON_CTRL, MSR_UNC_ICX_C25_PMON_STATUS, MSR_UNC_ICX_C25_PMON_STATUS, 25, 0, MSR_DEV, 48, MSR_UNC_ICX_C25_PMON_FILTER},
    [CBOX26] = {MSR_UNC_ICX_C26_PMON_CTRL, MSR_UNC_ICX_C26_PMON_STATUS, MSR_UNC_ICX_C26_PMON_STATUS, 26, 0, MSR_DEV, 48, MSR_UNC_ICX_C26_PMON_FILTER},
    [CBOX27] = {MSR_UNC_ICX_C27_PMON_CTRL, MSR_UNC_ICX_C27_PMON_STATUS, MSR_UNC_ICX_C27_PMON_STATUS, 27, 0, MSR_DEV, 48, MSR_UNC_ICX_C27_PMON_FILTER},
    [CBOX28] = {MSR_UNC_ICX_C28_PMON_CTRL, MSR_UNC_ICX_C28_PMON_STATUS, MSR_UNC_ICX_C28_PMON_STATUS, 28, 0, MSR_DEV, 48, MSR_UNC_ICX_C28_PMON_FILTER},
    [CBOX29] = {MSR_UNC_ICX_C29_PMON_CTRL, MSR_UNC_ICX_C29_PMON_STATUS, MSR_UNC_ICX_C29_PMON_STATUS, 29, 0, MSR_DEV, 48, MSR_UNC_ICX_C29_PMON_FILTER},
    [CBOX30] = {MSR_UNC_ICX_C30_PMON_CTRL, MSR_UNC_ICX_C30_PMON_STATUS, MSR_UNC_ICX_C30_PMON_STATUS, 30, 0, MSR_DEV, 48, MSR_UNC_ICX_C30_PMON_FILTER},
    [CBOX31] = {MSR_UNC_ICX_C31_PMON_CTRL, MSR_UNC_ICX_C31_PMON_STATUS, MSR_UNC_ICX_C31_PMON_STATUS, 31, 0, MSR_DEV, 48, MSR_UNC_ICX_C31_PMON_FILTER},
    [CBOX32] = {MSR_UNC_ICX_C32_PMON_CTRL, MSR_UNC_ICX_C32_PMON_STATUS, MSR_UNC_ICX_C32_PMON_STATUS, 32, 0, MSR_DEV, 48, MSR_UNC_ICX_C32_PMON_FILTER},
    [CBOX33] = {MSR_UNC_ICX_C33_PMON_CTRL, MSR_UNC_ICX_C33_PMON_STATUS, MSR_UNC_ICX_C33_PMON_STATUS, 33, 0, MSR_DEV, 48, MSR_UNC_ICX_C33_PMON_FILTER},
    [CBOX34] = {MSR_UNC_ICX_C34_PMON_CTRL, MSR_UNC_ICX_C34_PMON_STATUS, MSR_UNC_ICX_C34_PMON_STATUS, 34, 0, MSR_DEV, 48, MSR_UNC_ICX_C34_PMON_FILTER},
    [CBOX35] = {MSR_UNC_ICX_C35_PMON_CTRL, MSR_UNC_ICX_C35_PMON_STATUS, MSR_UNC_ICX_C35_PMON_STATUS, 35, 0, MSR_DEV, 48, MSR_UNC_ICX_C35_PMON_FILTER},
    [CBOX36] = {MSR_UNC_ICX_C36_PMON_CTRL, MSR_UNC_ICX_C36_PMON_STATUS, MSR_UNC_ICX_C36_PMON_STATUS, 36, 0, MSR_DEV, 48, MSR_UNC_ICX_C36_PMON_FILTER},
    [CBOX37] = {MSR_UNC_ICX_C37_PMON_CTRL, MSR_UNC_ICX_C37_PMON_STATUS, MSR_UNC_ICX_C37_PMON_STATUS, 37, 0, MSR_DEV, 48, MSR_UNC_ICX_C37_PMON_FILTER},
    [CBOX38] = {MSR_UNC_ICX_C38_PMON_CTRL, MSR_UNC_ICX_C38_PMON_STATUS, MSR_UNC_ICX_C38_PMON_STATUS, 38, 0, MSR_DEV, 48, MSR_UNC_ICX_C38_PMON_FILTER},
    [CBOX39] = {MSR_UNC_ICX_C39_PMON_CTRL, MSR_UNC_ICX_C39_PMON_STATUS, MSR_UNC_ICX_C39_PMON_STATUS, 39, 0, MSR_DEV, 48, MSR_UNC_ICX_C39_PMON_FILTER},
    [UBOXFIX] = {MSR_V4_UNC_PERF_GLOBAL_CTRL, MSR_V4_UNC_PERF_GLOBAL_STATUS, MSR_V4_UNC_PERF_GLOBAL_STATUS, 0, 0, 0, 48},
    [UBOX] = {MSR_V4_UNC_PERF_GLOBAL_CTRL, MSR_V4_UNC_PERF_GLOBAL_STATUS, MSR_V4_UNC_PERF_GLOBAL_STATUS, 1, 0, 0, 48},
    [BBOX0] = {PCI_UNC_ICX_M2M_PMON_CTRL, PCI_UNC_ICX_M2M_PMON_STATUS, PCI_UNC_ICX_M2M_PMON_STATUS, -1, 1, PCI_HA_DEVICE_0, 48},
    [BBOX1] = {PCI_UNC_ICX_M2M_PMON_CTRL, PCI_UNC_ICX_M2M_PMON_STATUS, PCI_UNC_ICX_M2M_PMON_STATUS, -1, 1, PCI_HA_DEVICE_1, 48},
    [BBOX2] = {PCI_UNC_ICX_M2M_PMON_CTRL, PCI_UNC_ICX_M2M_PMON_STATUS, PCI_UNC_ICX_M2M_PMON_STATUS, -1, 1, PCI_HA_DEVICE_2, 48},
    [BBOX3] = {PCI_UNC_ICX_M2M_PMON_CTRL, PCI_UNC_ICX_M2M_PMON_STATUS, PCI_UNC_ICX_M2M_PMON_STATUS, -1, 1, PCI_HA_DEVICE_3, 48},
    [SBOX0] = {PCI_UNC_ICX_M3UPI_PMON_CTRL, PCI_UNC_ICX_M3UPI_PMON_STATUS, PCI_UNC_ICX_M3UPI_PMON_STATUS, -1, 1, PCI_R3QPI_DEVICE_LINK_0, 48},
    [SBOX1] = {PCI_UNC_ICX_M3UPI_PMON_CTRL, PCI_UNC_ICX_M3UPI_PMON_STATUS, PCI_UNC_ICX_M3UPI_PMON_STATUS, -1, 1, PCI_R3QPI_DEVICE_LINK_1, 48},
    [SBOX2] = {PCI_UNC_ICX_M3UPI_PMON_CTRL, PCI_UNC_ICX_M3UPI_PMON_STATUS, PCI_UNC_ICX_M3UPI_PMON_STATUS, -1, 1, PCI_R3QPI_DEVICE_LINK_2, 48},
    [QBOX0] = {PCI_UNC_ICX_UPI_PMON_CTRL, PCI_UNC_ICX_UPI_PMON_STATUS, PCI_UNC_ICX_UPI_PMON_STATUS, -1, 1, PCI_QPI_DEVICE_PORT_0, 48},
    [QBOX1] = {PCI_UNC_ICX_UPI_PMON_CTRL, PCI_UNC_ICX_UPI_PMON_STATUS, PCI_UNC_ICX_UPI_PMON_STATUS, -1, 1, PCI_QPI_DEVICE_PORT_1, 48},
    [QBOX2] = {PCI_UNC_ICX_UPI_PMON_CTRL, PCI_UNC_ICX_UPI_PMON_STATUS, PCI_UNC_ICX_UPI_PMON_STATUS, -1, 1, PCI_QPI_DEVICE_PORT_2, 48},
    [PBOX] = {MSR_UNC_M2IOSF_M2PCIE0_PMON_CTRL, MSR_UNC_M2IOSF_M2PCIE0_PMON_STATUS, MSR_UNC_M2IOSF_M2PCIE0_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [PBOX1] = {MSR_UNC_M2IOSF_M2PCIE1_PMON_CTRL, MSR_UNC_M2IOSF_M2PCIE1_PMON_STATUS, MSR_UNC_M2IOSF_M2PCIE1_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [PBOX2] = {MSR_UNC_M2IOSF_M2PCIE2_PMON_CTRL, MSR_UNC_M2IOSF_M2PCIE2_PMON_STATUS, MSR_UNC_M2IOSF_M2PCIE2_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [PBOX3] = {MSR_UNC_M2IOSF_M2PCIE3_PMON_CTRL, MSR_UNC_M2IOSF_M2PCIE3_PMON_STATUS, MSR_UNC_M2IOSF_M2PCIE3_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [PBOX4] = {MSR_UNC_M2IOSF_M2PCIE4_PMON_CTRL, MSR_UNC_M2IOSF_M2PCIE4_PMON_STATUS, MSR_UNC_M2IOSF_M2PCIE4_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [PBOX5] = {MSR_UNC_M2IOSF_M2PCIE5_PMON_CTRL, MSR_UNC_M2IOSF_M2PCIE5_PMON_STATUS, MSR_UNC_M2IOSF_M2PCIE5_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [IBOX0] = {MSR_UNC_M2IOSF_IRP0_PMON_CTRL, MSR_UNC_M2IOSF_IRP0_PMON_STATUS, MSR_UNC_M2IOSF_IRP0_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [IBOX1] = {MSR_UNC_M2IOSF_IRP1_PMON_CTRL, MSR_UNC_M2IOSF_IRP1_PMON_STATUS, MSR_UNC_M2IOSF_IRP1_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [IBOX2] = {MSR_UNC_M2IOSF_IRP2_PMON_CTRL, MSR_UNC_M2IOSF_IRP2_PMON_STATUS, MSR_UNC_M2IOSF_IRP2_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [IBOX3] = {MSR_UNC_M2IOSF_IRP3_PMON_CTRL, MSR_UNC_M2IOSF_IRP3_PMON_STATUS, MSR_UNC_M2IOSF_IRP3_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [IBOX4] = {MSR_UNC_M2IOSF_IRP4_PMON_CTRL, MSR_UNC_M2IOSF_IRP4_PMON_STATUS, MSR_UNC_M2IOSF_IRP4_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [IBOX5] = {MSR_UNC_M2IOSF_IRP5_PMON_CTRL, MSR_UNC_M2IOSF_IRP5_PMON_STATUS, MSR_UNC_M2IOSF_IRP5_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [EUBOX0] = {MSR_UNC_M2IOSF_TC0_PMON_CTRL, MSR_UNC_M2IOSF_TC0_PMON_STATUS, MSR_UNC_M2IOSF_TC0_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [EUBOX1] = {MSR_UNC_M2IOSF_TC1_PMON_CTRL, MSR_UNC_M2IOSF_TC1_PMON_STATUS, MSR_UNC_M2IOSF_TC1_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [EUBOX2] = {MSR_UNC_M2IOSF_TC2_PMON_CTRL, MSR_UNC_M2IOSF_TC2_PMON_STATUS, MSR_UNC_M2IOSF_TC2_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [EUBOX3] = {MSR_UNC_M2IOSF_TC3_PMON_CTRL, MSR_UNC_M2IOSF_TC3_PMON_STATUS, MSR_UNC_M2IOSF_TC3_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [EUBOX4] = {MSR_UNC_M2IOSF_TC4_PMON_CTRL, MSR_UNC_M2IOSF_TC4_PMON_STATUS, MSR_UNC_M2IOSF_TC4_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [EUBOX5] = {MSR_UNC_M2IOSF_TC5_PMON_CTRL, MSR_UNC_M2IOSF_TC5_PMON_STATUS, MSR_UNC_M2IOSF_TC5_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [EUBOX0FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [EUBOX1FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [EUBOX2FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [EUBOX3FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [EUBOX4FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [EUBOX5FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [IBOX0FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [IBOX1FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [IBOX2FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [IBOX3FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [IBOX4FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [IBOX5FIX] = {0, 0, 0, 0, 0, MSR_DEV, 48},
    [WBOX] = {MSR_UNC_ICX_PCU_PMON_CTRL, MSR_UNC_ICX_PCU_PMON_STATUS, MSR_UNC_ICX_PCU_PMON_STATUS, -1, 0, MSR_DEV, 48},
    [WBOX0FIX] = {0, 0, 0, -1, 0, MSR_DEV, 64},
    [WBOX1FIX] = {0, 0, 0, -1, 0, MSR_DEV, 64},
    [WBOX2FIX] = {0, 0, 0, -1, 0, MSR_DEV, 64},
    [WBOX3FIX] = {0, 0, 0, -1, 0, MSR_DEV, 64},
};

static PciDevice icelakeX_pci_devices[MAX_NUM_PCI_DEVICES] = {
 [MSR_DEV] = {NODEVTYPE, "", "MSR", ""},
 [MMIO_IMC_DEVICE_0_CH_0] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX0", 0x3451},
 [MMIO_IMC_DEVICE_0_CH_1] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX1", 0x3451},
 [MMIO_IMC_DEVICE_0_CH_2] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX2", 0x3451},
 [MMIO_IMC_DEVICE_0_CH_3] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX3", 0x3451},
 [MMIO_IMC_DEVICE_0_CH_4] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX4", 0x3451},
 [MMIO_IMC_DEVICE_0_CH_5] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX5", 0x3451},
 [MMIO_IMC_DEVICE_0_CH_6] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX6", 0x3451},
 [MMIO_IMC_DEVICE_0_CH_7] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX7", 0x3451},
 [MMIO_IMC_DEVICE_0_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV0", 0x3451},
 [MMIO_IMC_DEVICE_1_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV1", 0x3451},
 [MMIO_IMC_DEVICE_2_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV2", 0x3451},
 [MMIO_IMC_DEVICE_3_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV3", 0x3451},
 [PCI_HA_DEVICE_0] = {HA, "0c.0", "PCI_HA_DEVICE_0", "BBOX0", 0x344A},
 [PCI_HA_DEVICE_1] = {HA, "0d.0", "PCI_HA_DEVICE_1", "BBOX1", 0x344A},
 [PCI_HA_DEVICE_2] = {HA, "0e.0", "PCI_HA_DEVICE_2", "BBOX2", 0x344A},
 [PCI_HA_DEVICE_3] = {HA, "0f.0", "PCI_HA_DEVICE_3", "BBOX3", 0x344A},
 [PCI_R3QPI_DEVICE_LINK_0] = {R3QPI, "05.1", "PCI_R3QPI_DEVICE_LINK_0", "SBOX0", 0x3446},
 [PCI_R3QPI_DEVICE_LINK_1] = {R3QPI, "06.1", "PCI_R3QPI_DEVICE_LINK_1", "SBOX1", 0x3446},
 [PCI_R3QPI_DEVICE_LINK_2] = {R3QPI, "07.1", "PCI_R3QPI_DEVICE_LINK_2", "SBOX2", 0x3446},
 [PCI_QPI_DEVICE_PORT_0] = {QPI, "02.1", "PCI_QPI_DEVICE_PORT_0", "QBOX0", 0x3441},
 [PCI_QPI_DEVICE_PORT_1] = {QPI, "03.1", "PCI_QPI_DEVICE_PORT_1", "QBOX1", 0x3441},
 [PCI_QPI_DEVICE_PORT_2] = {QPI, "04.1", "PCI_QPI_DEVICE_PORT_2", "QBOX2", 0x3441},
};

static char* icelakeX_translate_types[NUM_UNITS] = {
    [FIXED] = "/sys/bus/event_source/devices/cpu",
    [PMC] = "/sys/bus/event_source/devices/cpu",
    [POWER] = "/sys/bus/event_source/devices/power",
    [MBOX0] = "/sys/bus/event_source/devices/uncore_imc_0",
    [MBOX1] = "/sys/bus/event_source/devices/uncore_imc_1",
    [MBOX2] = "/sys/bus/event_source/devices/uncore_imc_2",
    [MBOX3] = "/sys/bus/event_source/devices/uncore_imc_3",
    [MBOX4] = "/sys/bus/event_source/devices/uncore_imc_4",
    [MBOX5] = "/sys/bus/event_source/devices/uncore_imc_5",
    [MBOX6] = "/sys/bus/event_source/devices/uncore_imc_6",
    [MBOX7] = "/sys/bus/event_source/devices/uncore_imc_7",
    [MBOX0FIX] = "/sys/bus/event_source/devices/uncore_imc_0",
    [MBOX1FIX] = "/sys/bus/event_source/devices/uncore_imc_1",
    [MBOX2FIX] = "/sys/bus/event_source/devices/uncore_imc_2",
    [MBOX3FIX] = "/sys/bus/event_source/devices/uncore_imc_3",
    [MBOX4FIX] = "/sys/bus/event_source/devices/uncore_imc_4",
    [MBOX5FIX] = "/sys/bus/event_source/devices/uncore_imc_5",
    [MBOX6FIX] = "/sys/bus/event_source/devices/uncore_imc_6",
    [MBOX7FIX] = "/sys/bus/event_source/devices/uncore_imc_7",
    [CBOX0] = "/sys/bus/event_source/devices/uncore_cha_0",
    [CBOX1] = "/sys/bus/event_source/devices/uncore_cha_1",
    [CBOX2] = "/sys/bus/event_source/devices/uncore_cha_2",
    [CBOX3] = "/sys/bus/event_source/devices/uncore_cha_3",
    [CBOX4] = "/sys/bus/event_source/devices/uncore_cha_4",
    [CBOX5] = "/sys/bus/event_source/devices/uncore_cha_5",
    [CBOX6] = "/sys/bus/event_source/devices/uncore_cha_6",
    [CBOX7] = "/sys/bus/event_source/devices/uncore_cha_7",
    [CBOX8] = "/sys/bus/event_source/devices/uncore_cha_8",
    [CBOX9] = "/sys/bus/event_source/devices/uncore_cha_9",
    [CBOX10] = "/sys/bus/event_source/devices/uncore_cha_10",
    [CBOX11] = "/sys/bus/event_source/devices/uncore_cha_11",
    [CBOX12] = "/sys/bus/event_source/devices/uncore_cha_12",
    [CBOX13] = "/sys/bus/event_source/devices/uncore_cha_13",
    [CBOX14] = "/sys/bus/event_source/devices/uncore_cha_14",
    [CBOX15] = "/sys/bus/event_source/devices/uncore_cha_15",
    [CBOX16] = "/sys/bus/event_source/devices/uncore_cha_16",
    [CBOX17] = "/sys/bus/event_source/devices/uncore_cha_17",
    [CBOX18] = "/sys/bus/event_source/devices/uncore_cha_18",
    [CBOX19] = "/sys/bus/event_source/devices/uncore_cha_19",
    [CBOX20] = "/sys/bus/event_source/devices/uncore_cha_20",
    [CBOX21] = "/sys/bus/event_source/devices/uncore_cha_21",
    [CBOX22] = "/sys/bus/event_source/devices/uncore_cha_22",
    [CBOX23] = "/sys/bus/event_source/devices/uncore_cha_23",
    [CBOX24] = "/sys/bus/event_source/devices/uncore_cha_24",
    [CBOX25] = "/sys/bus/event_source/devices/uncore_cha_25",
    [CBOX26] = "/sys/bus/event_source/devices/uncore_cha_26",
    [CBOX27] = "/sys/bus/event_source/devices/uncore_cha_27",
    [CBOX28] = "/sys/bus/event_source/devices/uncore_cha_28",
    [CBOX29] = "/sys/bus/event_source/devices/uncore_cha_29",
    [CBOX30] = "/sys/bus/event_source/devices/uncore_cha_30",
    [CBOX31] = "/sys/bus/event_source/devices/uncore_cha_31",
    [CBOX32] = "/sys/bus/event_source/devices/uncore_cha_32",
    [CBOX33] = "/sys/bus/event_source/devices/uncore_cha_33",
    [CBOX34] = "/sys/bus/event_source/devices/uncore_cha_34",
    [CBOX35] = "/sys/bus/event_source/devices/uncore_cha_35",
    [CBOX36] = "/sys/bus/event_source/devices/uncore_cha_36",
    [CBOX37] = "/sys/bus/event_source/devices/uncore_cha_37",
    [CBOX38] = "/sys/bus/event_source/devices/uncore_cha_38",
    [CBOX39] = "/sys/bus/event_source/devices/uncore_cha_39",
    [BBOX0] = "/sys/bus/event_source/devices/uncore_m2m_0",
    [BBOX1] = "/sys/bus/event_source/devices/uncore_m2m_1",
    [BBOX2] = "/sys/bus/event_source/devices/uncore_m2m_2",
    [BBOX3] = "/sys/bus/event_source/devices/uncore_m2m_3",
    [WBOX] = "/sys/bus/event_source/devices/uncore_pcu",
    [QBOX0] = "/sys/bus/event_source/devices/uncore_upi_0",
    [QBOX1] = "/sys/bus/event_source/devices/uncore_upi_1",
    [QBOX2] = "/sys/bus/event_source/devices/uncore_upi_2",
    [SBOX0] = "/sys/bus/event_source/devices/uncore_m3upi_0",
    [SBOX1] = "/sys/bus/event_source/devices/uncore_m3upi_1",
    [SBOX2] = "/sys/bus/event_source/devices/uncore_m3upi_2",
    [UBOX] = "/sys/bus/event_source/devices/uncore_ubox",
    [UBOXFIX] = "/sys/bus/event_source/devices/uncore_ubox",
};

static char* registerTypeNamesIcelakeX[MAX_UNITS] = {
    [BBOX0] = "Mesh to memory controller Interface 0",
    [BBOX1] = "Mesh to memory controller Interface 1",
    [BBOX2] = "Mesh to memory controller Interface 2",
    [BBOX3] = "Mesh to memory controller Interface 3",
    [SBOX0] = "Mesh to UPI Interface 0",
    [SBOX1] = "Mesh to UPI Interface 1",
    [SBOX2] = "Mesh to UPI Interface 2",
    [QBOX0] = "UPI link layer Interface 0",
    [QBOX1] = "UPI link layer Interface 1",
    [QBOX2] = "UPI link layer Interface 2",
    [MBOX0] = "Memory Controller 0 Channel 0",
    [MBOX1] = "Memory Controller 0 Channel 1",
    [MBOX2] = "Memory Controller 1 Channel 0",
    [MBOX3] = "Memory Controller 1 Channel 1",
    [MBOX4] = "Memory Controller 2 Channel 0",
    [MBOX5] = "Memory Controller 2 Channel 1",
    [MBOX6] = "Memory Controller 3 Channel 0",
    [MBOX7] = "Memory Controller 3 Channel 1",
    [MBOX0FIX] = "Memory Controller 0 Channel 0 Fixed Counter",
    [MBOX1FIX] = "Memory Controller 0 Channel 1 Fixed Counter",
    [MBOX2FIX] = "Memory Controller 1 Channel 0 Fixed Counter",
    [MBOX3FIX] = "Memory Controller 1 Channel 1 Fixed Counter",
    [MBOX4FIX] = "Memory Controller 2 Channel 0 Fixed Counter",
    [MBOX5FIX] = "Memory Controller 2 Channel 1 Fixed Counter",
    [MBOX6FIX] = "Memory Controller 3 Channel 0 Fixed Counter",
    [MBOX7FIX] = "Memory Controller 3 Channel 1 Fixed Counter",
    [MDEV0] = "Memory Controller 0",
    [MDEV1] = "Memory Controller 1",
    [MDEV2] = "Memory Controller 2",
    [MDEV3] = "Memory Controller 3",
    [EUBOX0] = "Traffic Controller Interface 0",
    [EUBOX0FIX] = "Traffic Controller Interface 0 Fixed Counter",
    [EUBOX1] = "Traffic Controller Interface 1",
    [EUBOX1FIX] = "Traffic Controller Interface 1 Fixed Counter",
    [EUBOX2] = "Traffic Controller Interface 2",
    [EUBOX2FIX] = "Traffic Controller Interface 2 Fixed Counter",
    [EUBOX3] = "Traffic Controller Interface 3",
    [EUBOX3FIX] = "Traffic Controller Interface 3 Fixed Counter",
    [EUBOX4] = "Traffic Controller Interface 4",
    [EUBOX4FIX] = "Traffic Controller Interface 4 Fixed Counter",
    [EUBOX5] = "Traffic Controller Interface 5",
    [EUBOX5FIX] = "Traffic Controller Interface 6 Fixed Counter",
    [IBOX0FIX] = "IIO Bandwidth In Interface 0 Free-Running Counter",
    [IBOX1FIX] = "IIO Bandwidth In Interface 1 Free-Running Counter",
    [IBOX2FIX] = "IIO Bandwidth In Interface 2 Free-Running Counter",
    [IBOX3FIX] = "IIO Bandwidth In Interface 3 Free-Running Counter",
    [IBOX4FIX] = "IIO Bandwidth In Interface 4 Free-Running Counter",
    [IBOX5FIX] = "IIO Bandwidth In Interface 5 Free-Running Counter",
};
