#!/bin/bash
#
#	Developed by Rodrigo P. Telles <rodrigo@telles.org> under GPL :)
#
# Format of conf file:
# ---------------------------------
# Objects:
# OBJ:/etc:0:READ
# OBJ:/etc/shadow:0:DENY
# 
# Subjects:
# SUB:/usr/sbin/sshd:0:READ:/etc/shadow
# SUB:/sbin/update:1:GRANT:CAP_SYS_ADMIN
# SUB:/sbin/init:-1:GRANT:CAP_SYS_RAWIO
# SUB:/usr/sbin/sshd:-1:GRANT:CAP_NET_BIND_SERVICE
# ---------------------------------
# PS:
# ******* Objects needs to be declared before subjects **********
# Object context: OBJ = FILENAME || DIR
# Subject context: OBJ = FILENAME || DIR || CAPABILITIES
# One by line !
#
# WARNING: This script delete all objects in "/etc/lids.conf"
# I do not make responsible for any damage that this script can come
# to cause !

caps="^CAP_\(CHOWN\|DAC_OVERRIDE\|DAC_READ_SEARCH\|FOWNER\|FSETID\|KILL\|SETGID\|SETUID\|SETPCAP\|LINUX_IMMUTABLE\|NET_\(BIND_SERVICE\|BROADCAST\|ADMIN\|RAW\)\|IP_\(LOCK\|OWNER\)\|SYS_\(MODULE\|RAWIO\|CHROOT\|PTRACE\|PACCT\|ADMIN\|BOOT\|NICE\|RESOURCE\|TIME\|TTY_CONFIG\)\|MKNOD\|LEASE\|HIDDEN\|INIT_KILL\)$"

log=/var/log/lids.log
conf=/etc/lids/lids.objs
lids='/sbin/lidsadm'

if [ $(echo $BASH_VERSION) != '2.04.0(1)-release' ] ; then
	printf "Sorry, you need bash version 2.04.0(1)-release, and your is $BASH_VERSION\n"
	exit 1
fi	

if [ $(id -u) != 0 ] ; then
	printf "You must be root to run this program !!!\n"
	exit 1
fi	

if [ ! -f "$conf" -a ! -r "$conf" ] ; then
	printf "Error: $conf not found or unreadable !!!\n"
	exit 1
fi	

if [ ! -f "$lids" -a ! -x "$lids" ] ; then
	printf "Error: $lids not found or not executable !!!\n"
	exit 1
fi

if [ -f "$log" -a ! -w "$log" ] ; then
	printf "Error: $log is not writeable !!!\n"
	exit 1
fi

$lids -Z 2>&1 >> $log

lids_obj() {
	TYPE=$1
	SUB_OBJ=$2
	INH=$3	
	PERM=$4
	CAP_OBJ=$5
	[ "$6" = 'WD' ] && domain=-d
	case "$TYPE" in
	OBJ|obj)
		if [ -z "$SUB_OBJ" -o ! -f "$SUB_OBJ" -a ! -d "$SUB_OBJ" ] ; then
			printf "[$SUB_OBJ] invalid ($REC) on line ${CONT}\n" >> $log
			ERR=$((ERR+1))
			continue
		fi	
		if [ "$INH" != "1" -a "$INH" != "-1" -a "$INH" != "0"  ] ; then
			printf "[$INH] invalid ($REC) on line ${CONT}\n" >> $log
			ERR=$((ERR+1))
			continue
		fi	
		if [ ! "$(echo $PERM|grep -i '\(READ\|DENY\|APPEND\|WRITE\|IGNORE\)')" ] ; then
			printf "[$PERM] invalid ($REC) on line ${CONT}\n" >> $log
			ERR=$((ERR+1))
			continue	
		fi	
		ERRO=$($lids -A -o $SUB_OBJ -i $INH -j $PERM 2>&1)
		RETVAL=$?
		if [ "$RETVAL" != "0" ] ; then
			printf "Error: object=[$SUB_OBJ] perm=[$PERM] inherit=[$INH] -> $ERRO\n" >> $log
			ERR=$((ERR+1))	
		fi
		;;
	SUB|sub)
		if [ -z "$SUB_OBJ" -o ! -f "$SUB_OBJ" -a ! -d "$SUB_OBJ" ] ; then
			printf "[$SUB_OBJ] invalid ($REC) on line ${CONT}\n" >> $log
			ERR=$((ERR+1))
			continue
		fi	
		if [ "$INH" != "1" -a "$INH" != "-1" -a "$INH" != "0" ] ; then
			printf "[$INH] invalid ($REC) on line ${CONT}\n" >> $log
			ERR=$((ERR+1))
			continue
		fi	
		if [ ! "$(echo $PERM|grep -i '\(GRANT\|READ\|APPEND\|WRITE\|IGNORE\|DENY\)')" ] ; then
			printf "[$PERM] invalid ($REC) on line ${CONT}\n" >> $log
			ERR=$((ERR+1))
			continue	
		fi	
		if [ \( "$(echo $CAP_OBJ|grep '^CAP_')" -a ! "$(echo $CAP_OBJ|grep "$caps")" \) -o ! "$CAP_OBJ" ] ; then
			printf "[$CAP_OBJ] invalid ($REC) on line ${CONT}\n" >> $log
			ERR=$((ERR+1))
			continue
		fi	
		
		ERRO=$($lids -A -s $SUB_OBJ -o $CAP_OBJ -i $INH $domain -j $PERM 2>&1)
		RETVAL=$?	
		if [ "$RETVAL" != "0" ] ; then
			printf "Error: subject=[$SUB_OBJ] object=[$CAP_OBJ] inherit=[$INH] perm=[$PERM] -> $ERRO\n" >> $log
			ERR=$((ERR+1))
		fi
		;;
	*)
		printf "\nMethod not found->[$TYPE]\n\n"
		exit 1
	
	esac	
}	


ERR=0
CONT=0
for REC in $(grep -v "\(^#\|^$\)" $conf); do
	TYPE=${REC%%:*}
	REST=${REC#*:}
	SUB_OBJ=${REST%%:*}
	REST=${REST#*:}
	INH=${REST%%:*}
	REST=${REST#*:}
	PERM=${REST%%:*}
	REST=${REST#*:}
	CAP_OBJ=${REST%%:*}
	REST=${REST#*:}
	DOMAIN=${REST%%:*}
	CONT=$((CONT+1))
	lids_obj $TYPE $SUB_OBJ $INH $PERM $CAP_OBJ $DOMAIN
done
printf "=========================================================	
			\rRead objects : ${CONT}
			\rErrors: ${ERR}
			\rInserted objects successfully: $((CONT - ERR))
			\r=========================================================\n\n" >> $log

exit 0
