! -*- F90 -*-


!DECK  ID>, QCDCOM.                                                     
                                                                        
!DECK  ID>, QCDCOM.                                                     
                                                                        
!------------------------QCDNUM COMMON BLOCKS---------------------      
                                                                        
!DECK  ID>, QCDNUM.                                                     
                                                                        
!DECK  ID>, QNINIT.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE QNINIT 
!     =================                                                 
                                                                        
!---  QNINIT: initialisation.                                           
!---  Called by user.                                                   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*8 CHVERS,CHDATE 
      COMMON/QCVERS/ CHVERS,CHDATE 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
      CHARACTER*7 TSNAM 
      COMMON/QCTRCE/ TSNAM(0:19) 
      COMMON/QCTRCI/ NTCAL(0:19),ITADR 
!                                                                       
! common added by MRW 18/3/05 to make silent mode for LHAPDF            
!                                                                       
      common/lhasilent/lhasilent 
!                                                                       
                                                                        
      CHVERS = '16.12   ' 
      CHDATE = '12-08-98' 
                                                                        
      LDOUBL = .TRUE. 
      if(lhasilent.eq.0) then 
      WRITE(6,'(/////)') 
      WRITE(6,                                                          &
     &'(8X,''+-----------------------------------------------+'')')     
      WRITE(6,                                                          &
     &'(8X,''|                                               |'')')     
!      LDOUBL = .TRUE.                                                  
      WRITE(6,                                                          &
     &'(8X,''| You are using the double precision version of |'')')     
      WRITE(6,                                                          &
     &'(8X,''|                                               |'')')     
      WRITE(6,                                                          &
     &'(8X,''|              Q C D N U M '',A8,                          &
     &     ''             |'')') CHVERS                                 
      WRITE(6,                                                          &
     &'(8X,''|                                               |'')')     
      WRITE(6,                                                          &
     &'(8X,''|         Author  : Michiel Botje               |'')')     
      WRITE(6,                                                          &
     &'(8X,''|         Email   : h24@nikhef.nl               |'')')     
      WRITE(6,                                                          &
     &'(8X,''|                                               |'')')     
      WRITE(6,                                                          &
     &'(8X,''|         Date    : '',A8,                                 &
     &     ''                    |'')') CHDATE                          
      WRITE(6,                                                          &
     &'(8X,''|         Max NX  : '',I3,                                 &
     &     ''                         |'')') MXX-1                      
      WRITE(6,                                                          &
     &'(8X,''|         Max NQ2 : '',I3,                                 &
     &     ''                         |'')') MQ2-1                      
      WRITE(6,                                                          &
     &'(8X,''|                                               |'')')     
      WRITE(6,                                                          &
     &'(8X,''+-----------------------------------------------+'')')     
      WRITE(6,'(/////)') 
      endif 
                                                                        
      IORD   = 2 
      IOLAST = -999 
      Q0ALFA = 50. 
      ALPHA0 = 0.180 
      QALAST = -999. 
      ASLAST = -999. 
      SCAX0  = 0.20 
      SCAQ0  = 1.D10 
                                                                        
      PI     = 3.14159265359 
      PROTON = 0.9382796 
      EUTRON = 0.9395731 
      UCLEON = (PROTON + EUTRON) / 2. 
      UDSCBT(1) = 0.005 
      UDSCBT(2) = 0.01 
      UDSCBT(3) = 0.3 
      UDSCBT(4) = 1.5 
      UDSCBT(5) = 5.0 
      UDSCBT(6) = 188. 
      CBMSTF(4) = UDSCBT(4) 
      CBMSTF(5) = UDSCBT(4) 
      CBMSTF(6) = UDSCBT(5) 
      CBMSTF(7) = UDSCBT(5) 
      CHARGE(4) = 4./9. 
      CHARGE(5) = 4./9. 
      CHARGE(6) = 1./9. 
      CHARGE(7) = 1./9. 
      AAM2H     = 1. 
      BBM2H     = 0. 
      AAM2L     = 1. 
      BBM2L     = 0. 
      AAAR2     = 1. 
      BBBR2     = 0. 
      FL_FAC    = 0. 
      C1S3   = 1./3. 
      C2S3   = 2./3. 
      C4S3   = 4./3. 
      C5S3   = 5./3. 
      C8S3   = 8./3. 
      C14S3  = 14./3. 
      C16S3  = 16./3. 
      C20S3  = 20./3. 
      C28S3  = 28./3. 
      C38S3  = 38./3. 
      C40S3  = 40./3. 
      C44S3  = 44./3. 
      C52S3  = 52./3. 
      C136S3 = 136./3. 
      C11S6  = 11./6. 
      C2S9   = 2./9. 
      C4S9   = 4./9. 
      C10S9  = 10./9. 
      C14S9  = 14./9. 
      C16S9  = 16./9. 
      C40S9  = 40./9. 
      C44S9  = 44./9. 
      C62S9  = 62./9. 
      C112S9 = 112./9. 
      C182S9 = 182./9. 
      C11S12 = 11./12. 
      C35S18 = 35./18. 
      C11S3  = 11./3. 
      C22S3  = 22./3. 
      C61S12 = 61./12. 
      C215S1 = 215./12. 
      C29S12 = 29./12. 
      CPI2S3 = PI**2/3. 
      CPIA   = 67./18. - CPI2S3/2. 
      CPIB   = 4.*CPI2S3 
      CPIC   = 17./18. + 3.5*CPI2S3 
      CPID   = 367./36. - CPI2S3 
      CPIE   = 5. - CPI2S3 
      CPIF   = CPI2S3 - 218./9. 
                                                                        
      CCA    = 3. 
      CCF    = (CCA*CCA-1.)/(2.*CCA) 
      CTF    = 0.5 
      CATF   = CCA*CTF 
      CFTF   = CCF*CTF 
                                                                        
      DO I = 1,10 
        T_SPENT(I) = 0. 
        E_CALLS(I) = 0. 
        N_CALLS(I) = 0 
      ENDDO 
      LTIME  = .FALSE. 
                                                                        
      LBMARK = .FALSE. 
      LW1ANA = .TRUE. 
      LW1NUM = .FALSE. 
      LW2NUM = .TRUE. 
      LW2STF = .TRUE. 
      LWF2C  = .FALSE. 
      LWF2B  = .FALSE. 
      LWFLC  = .FALSE. 
      LWFLB  = .FALSE. 
      LIMCK  = .TRUE. 
      LPLUS  = .TRUE. 
      LALFOK = .FALSE. 
      LDQ2OK = .FALSE. 
      LWT1OK = .FALSE. 
      LWT2OK = .FALSE. 
      LWTFOK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
      LCLOWQ = .TRUE. 
      LASOLD = .FALSE. 
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
      CALL QNFALS(LE_DONE,MXX) 
      CALL QNINUL(IQL_LAST,10) 
      CALL QNINUL(IQ0_LAST,10) 
      CALL QNINUL(IQH_LAST,10) 
                                                                        
      ITADR = 0 
      DO I = 0,19 
        TSNAM(I) = '       ' 
        NTCAL(I) = 0 
      ENDDO 
                                                                        
      NXX    = 0 
      NQ2    = 0 
      NGRVER = 0 
      NDFAST = 30 
      XMICUT = -1. 
      QMICUT = -1. 
      QMACUT = -1. 
      RS2CUT = -1. 
      QMINAS = 0. 
      THRS34 = -1.D10 
      THRS45 =  1.D10 
                                                                        
      CALL VZERO_LHA (WGTFF1,MXX*(MXX+1)/2) 
      CALL VZERO_LHA (WGTFG1,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTGF1,MXX*(MXX+1)/2) 
      CALL VZERO_LHA (WGTGG1,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTPP2,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTPM2,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTNS2,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTFF2,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTFG2,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTGF2,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTGG2,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTC2Q,MXX*(MXX+1)/2) 
      CALL VZERO_LHA (WGTC2G,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (YNTC2Q,MXX) 
      CALL VZERO_LHA (WGTCLQ,MXX*(MXX+1)/2) 
      CALL VZERO_LHA (WGTCLG,MXX*(MXX+1)*3/2) 
      CALL VZERO_LHA (WGTC3Q,MXX*(MXX+1)/2) 
                                                                        
      CALL QNVNUL(PWGT,11*31*3) 
      CALL QNINUL(NFMAP,MQ2) 
      CALL QNINUL(MARKFF,MXX*MQ2) 
      CALL QNINUL(MARKFH,MXX*MQ2) 
      CALL QNINUL(MARKQQ,MQ2) 
      CALL QNINUL(IDFAST,7*30) 
      CALL QNINUL(IFCNT,3*5) 
                                                                        
      CALL QNVNUL(PDFQCD,MXX*MQ2*11) 
      DO ID = 1,NDFMAX 
        DO IX = 1,MXX 
          DO IQ = 1,MQ2 
            FSTORE(IX,IQ,30+ID) = -501. 
          ENDDO 
        ENDDO 
      ENDDO 
                                                                        
      PNAM(0)   = 'GLUON' 
      PNAM(1)   = 'SINGL' 
      LNFP(0,3) = .TRUE. 
      LNFP(0,4) = .TRUE. 
      LNFP(0,5) = .TRUE. 
      LNFP(1,3) = .TRUE. 
      LNFP(1,4) = .TRUE. 
      LNFP(1,5) = .TRUE. 
      DO 10 I = 2,30 
        PNAM(I)   = 'FREE ' 
        LNFP(I,3) = .FALSE. 
        LNFP(I,4) = .FALSE. 
        LNFP(I,5) = .FALSE. 
   10 END DO 
      PWGT(0,0,3) = 1. 
      PWGT(0,0,4) = 1. 
      PWGT(0,0,5) = 1. 
      PWGT(1,1,3) = 1. 
      PWGT(1,1,4) = 1. 
      PWGT(1,1,5) = 1. 
      STFNAM(1)   = 'F2   ' 
      STFNAM(2)   = 'FL   ' 
      STFNAM(3)   = 'XF3  ' 
      STFNAM(4)   = 'F2C  ' 
      STFNAM(5)   = 'FLC  ' 
      STFNAM(6)   = 'F2B  ' 
      STFNAM(7)   = 'FLB  ' 
                                                                        
      CALL QTRACE('QNINIT ',0) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QTRACE.                                                     
                                                                        
!     ===============================                                   
      SUBROUTINE QTRACE(SRNAM,IPRINT) 
!     ===============================                                   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*7 SRNAM 
                                                                        
      CHARACTER*7 TSNAM 
      COMMON/QCTRCE/ TSNAM(0:19) 
      COMMON/QCTRCI/ NTCAL(0:19),ITADR 
                                                                        
                                                                        
      IF(IPRINT.EQ.0) THEN 
                                                                        
        IF(SRNAM.EQ.TSNAM(ITADR)) THEN 
          NTCAL(ITADR) = NTCAL(ITADR) + 1 
        ELSE 
          ITADR = MOD(ITADR+1,20) 
          TSNAM(ITADR) = SRNAM 
          NTCAL(ITADR) = 1 
        ENDIF 
                                                                        
      ELSE 
                                                                        
        WRITE(6,'(/'' ----------------------------'')') 
                                                                        
        K = -20 
        DO I = ITADR+1,ITADR+19 
          J = MOD(I,20) 
          K = K+1 
          WRITE(6,'(I4,2X,A7,''  #calls = '',I5)')                      &
     &    K,TSNAM(J),NTCAL(J)                                           
        ENDDO 
        K = 0 
        WRITE(6,'(I4,2X,A7,''  #calls = '',I5,''  <--- error'')')       &
     &  K,TSNAM(ITADR),NTCAL(ITADR)                                     
                                                                        
        WRITE(6,'( '' ----------------------------'')') 
                                                                        
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNDUMP.                                                     
                                                                        
!     ======================                                            
      SUBROUTINE QNDUMP(LUN) 
!     ======================                                            
                                                                        
!---  QNDUMP: write weight tables to LUN.                               
!---  Called by user.                                                   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
      CHARACTER*8 CHVERS,CHDATE 
      COMMON/QCVERS/ CHVERS,CHDATE 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      REAL                                                              &
     &WH_C0KG,WH_C1KG,WH_C1BKG,                                         &
     &WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ                                 
                                                                        
      COMMON/QCHWGT/                                                    &
     &WH_C0KG(0:MXX,MQ2,4:7),                                           &
     &WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),                   &
     &WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),                   &
     &WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)                    
                                                                        
                                                                        
      DIMENSION STOREM(6) 
                                                                        
      CALL QTRACE('QNDUMP ',0) 
                                                                        
      STOREM(1) = CBMSTF(4) 
      STOREM(2) = CBMSTF(6) 
      STOREM(3) = 0. 
      STOREM(4) = 0. 
      STOREM(5) = 0. 
      STOREM(6) = 0. 
                                                                        
      WRITE(LUN) MXX,MQ2 
      WRITE(LUN) CHVERS,CHDATE 
      WRITE(LUN) STOREM 
      WRITE(LUN) LWT1OK,LWT2OK,LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,      &
     &           LPLUS                                                  
      WRITE(LUN) XXTAB,Q2TAB,                                           &
     &           NXX,NQ2,IQF2C,IQF2B,IQFLC,IQFLB                        
      IF(LWT1OK) THEN 
      WRITE(LUN) WGTFF1,WGTFG1,WGTGF1,WGTGG1 
      ENDIF 
      IF(LWT2OK) THEN 
      WRITE(LUN) WGTPP2,WGTPM2,WGTNS2,WGTFF2,WGTFG2,WGTGF2,WGTGG2 
      ENDIF 
      IF(LWTFOK) THEN 
      WRITE(LUN) WGTC2Q,WGTC2G,YNTC2Q,WGTCLQ,WGTCLG,WGTC3Q 
      ENDIF 
      IF(LWFCOK.OR.LWLCOK.OR.LWFBOK.OR.LWLBOK) THEN 
      WRITE(LUN) WH_C0KG,WH_C1KG,WH_C1BKG,                              &
     &           WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ                      
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNREAD.                                                     
                                                                        
!     =================================                                 
      SUBROUTINE QNREAD(LUN,ISTOP,IERR) 
!     =================================                                 
                                                                        
!---  QNDUMP: read weight tables from LUN.                              
!---  Called by user.                                                   
!---  Input  integer LUN                                                
!---         integer ISTOP = 0 read the file                            
!---                 ISTOP = 1 read only when ierr = 0                  
!---                 ISTOP = 2 stop the program when ierr .ne. 0        
!---  Output integer IERR  = 0 all ok                                   
!---                       = 1 xgrid on file .ne. that in QCDNUM        
!---                       = 2 file contains heavy quark weight tables a
!---                           qgrid on file .ne. that in QCDNUM        
!---                       = 3 file contains charm weight tables and    
!---                           c mass on the file .ne. that in QCDNUM   
!---                       = 4 file contains bottom weight tables and   
!---                           b mass on the file .ne. that in QCDNUM   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
      CHARACTER*8 CHVERS,CHDATE 
      COMMON/QCVERS/ CHVERS,CHDATE 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      REAL                                                              &
     &WH_C0KG,WH_C1KG,WH_C1BKG,                                         &
     &WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ                                 
                                                                        
      COMMON/QCHWGT/                                                    &
     &WH_C0KG(0:MXX,MQ2,4:7),                                           &
     &WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),                   &
     &WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),                   &
     &WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)                    
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CHARACTER*8 RHVERS,RHDATE 
      LOGICAL     RWT1OK,RWT2OK,RWTFOK,RWFCOK 
      LOGICAL     RWLCOK,RWFBOK,RWLBOK,RPLUS 
      LOGICAL     LREADX,LREADQ,LREADB,LREADC 
      DIMENSION   RMASS(6) 
      DIMENSION   RXTAB(MXX),RQTAB(MQ2) 
      DIMENSION   IRF2C(MQ2),IRF2B(MQ2),IRFLC(MQ2),IRFLB(MQ2) 
!                                                                       
! common added 18/3/05 by MRW                                           
      common/lhasilent/lhasilent 
                                                                        
      CALL QTRACE('QNREAD ',0) 
                                                                        
      REWIND LUN 
                                                                        
!--   Setup the weight adresses                                         
!--   (Usually done in QNFILW, but this routine might not be called)    
      DO IX0 = 1,MXX 
        DO IX = IX0,MXX 
          IWADR(IX,IX0) = IWTAD(IX,IX0) 
        ENDDO 
      ENDDO 
                                                                        
!--   Read header information                                           
      READ(LUN,ERR=500) KXX,KQ2 
      IF(KXX.NE.MXX.OR.KQ2.NE.MQ2) THEN 
        WRITE(6,'(/'' QNREAD: nxmax, nqmax on file  '',2I5,             &
     &            /''         nxmax, nqmax in QCDNUM'',2I5,             &
     &            /''         Incompatible ---> STOP'')')               &
     &                        KXX,KQ2,MXX,MQ2                           
        STOP 
      ENDIF 
      READ(LUN,ERR=500) RHVERS,RHDATE 
      READ(RHVERS(1:2),'(I2)') IV 
                                                                        
!--   If ISTOP > 0 : stop when fileversion = QCDNUM15 or lower          
!--   If ISTOP = 0 : read up to the weight tables                       
      IF(IV.LE.15.AND.ISTOP.NE.0) THEN 
        WRITE(6,'(/'' QNREAD: file was written with QCDNUM'',A8,        &
     &             '' Incompatible ---> STOP'')')                       &
     &   RHVERS                                                         
        STOP 
      ENDIF 
      if(lhasilent.eq.0)                                                &
     & WRITE(6,'(/'' QNREAD: file was written with QCDNUM'',A8)')       &
     & RHVERS                                                           
                                                                        
      READ(LUN,ERR=500) RMASS 
      READ(LUN,ERR=500) RWT1OK,RWT2OK,RWTFOK,RWFCOK,RWLCOK,RWFBOK,      &
     &                  RWLBOK,RPLUS                                    
      READ(LUN,ERR=500) RXTAB,RQTAB,                                    &
     &                  NRX,NRQ,IRF2C,IRF2B,IRFLC,IRFLB                 
                                                                        
      IERR   = 0 
      LREADX = .FALSE. 
      LREADQ = .FALSE. 
      LREADC = .FALSE. 
      LREADB = .FALSE. 
                                                                        
!--   Check xgrid (if there is one already defined)                     
      IF(NXX.NE.0)     THEN 
        IF(NXX.NE.NRX) THEN 
          IERR = 1 
        ELSE 
          DO IX = 1,NXX 
            IF(RXTAB(IX).NE.XXTAB(IX)) IERR = 1 
          ENDDO 
        ENDIF 
      ENDIF 
                                                                        
!--   What to do when xgrid is different                                
      IF(IERR.EQ.1) THEN 
        IF(ISTOP.EQ.1) THEN 
          WRITE(6,'(/                                                   &
     &    '' QNREAD: X grid in memory different from that on file'',    &
     &    '' ---> abandon reading'')')                                  
          RETURN 
        ENDIF 
        IF(ISTOP.EQ.2) THEN 
          WRITE(6,'(/                                                   &
     &    '' QNREAD: X grid in memory different from that on file'',    &
     &    '' ---> STOP'')')                                             
          STOP 
        ENDIF 
      ENDIF 
                                                                        
      IF(IERR.EQ.1.OR.NXX.LE.0) LREADX = .TRUE. 
                                                                        
!--   Check Q2 grid if there is one already defined and if there are    
!--   heavy quark weight tables on the file                             
      IF(NQ2.NE.0.AND.(RWFCOK.OR.RWLCOK.OR.RWFBOK.OR.RWLBOK)) THEN 
        IF(NQ2.NE.NRQ) THEN 
          IERR = 2 
        ELSE 
          DO IQ = 1,NQ2 
            IF(RQTAB(IQ).NE.Q2TAB(IQ)) IERR = 2 
          ENDDO 
        ENDIF 
      ENDIF 
                                                                        
!--   What to do when qgrid is different                                
      IF(IERR.EQ.2) THEN 
        IF(ISTOP.EQ.1) THEN 
          WRITE(6,'(/                                                   &
     &    '' QNREAD: Q2 grid in memory different from that on file'',   &
     &    '' ---> abandon reading'')')                                  
          RETURN 
        ENDIF 
        IF(ISTOP.EQ.2) THEN 
          WRITE(6,'(/                                                   &
     &    '' QNREAD: Q2 grid in memory different from that on file'',   &
     &    '' ---> STOP'')')                                             
          STOP 
        ENDIF 
      ENDIF 
                                                                        
      IF(IERR.EQ.2.OR.NQ2.LE.0) LREADQ = .TRUE. 
                                                                        
!--   Check charm mass if there are charm weight tables on the file     
      IF(RWFCOK.OR.RWLCOK) THEN 
        IF(IV.LE.15) THEN 
          IF(RMASS(4).NE.CBMSTF(4)) IERR = 3 
        ELSE 
          IF(RMASS(1).NE.CBMSTF(4)) IERR = 3 
        ENDIF 
      ENDIF 
                                                                        
!--   What to do when charm mass is different                           
      IF(IERR.EQ.3) THEN 
        IF(ISTOP.EQ.1) THEN 
          WRITE(6,'(/                                                   &
     &    '' QNREAD: Charm mass in memory different from that on file'',&
     &    '' ---> abandon reading'')')                                  
          RETURN 
        ENDIF 
        IF(ISTOP.EQ.2) THEN 
          WRITE(6,'(/                                                   &
     &    '' QNREAD: Charm mass in memory different from that on'',     &
     &    '' file ---> STOP'')')                                        
          STOP 
        ENDIF 
        LREADC = .TRUE. 
      ENDIF 
                                                                        
!--   Check bottom mass if there are bottom weight tables on the file   
      IF(RWFBOK.OR.RWLBOK) THEN 
        IF(IV.LE.15) THEN 
          IF(RMASS(5).NE.CBMSTF(6)) IERR = 4 
        ELSE 
          IF(RMASS(2).NE.CBMSTF(6)) IERR = 4 
        ENDIF 
      ENDIF 
                                                                        
!--   What to do when bottom mass is different                          
      IF(IERR.EQ.4) THEN 
        IF(ISTOP.EQ.1) THEN 
          WRITE(6,'(/                                                   &
     &    '' QNREAD: Bottom mass in memory different from that on'',    &
     &    '' file ---> abandon reading'')')                             
          RETURN 
        ENDIF 
        IF(ISTOP.EQ.2) THEN 
          WRITE(6,'(/                                                   &
     &    '' QNREAD: Bottom mass in memory different from that on'',    &
     &    '' file ---> STOP'')')                                        
          STOP 
        ENDIF 
        LREADB = .TRUE. 
      ENDIF 
                                                                        
!--   ok..... continue.......                                           
      LPLUS  = RPLUS 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
      IF(LREADX) THEN 
!--     Copy xgrid to qcdnum common block                               
        NXX = NRX 
        DO IX = 1,NXX+1 
          XXTAB(IX) = RXTAB(IX) 
        ENDDO 
        WRITE(6,'(/                                                     &
     &    '' QNREAD: xgrid table read in (original overwritten)'')')    
!--     Invalidate all weight tables since the grid has changed         
        LWT1OK = .FALSE. 
        LWT2OK = .FALSE. 
        LWTFOK = .FALSE. 
        LWFCOK = .FALSE. 
        LWLCOK = .FALSE. 
        LWFBOK = .FALSE. 
        LWLBOK = .FALSE. 
        LMARK  = .FALSE. 
        NGRVER = NGRVER+1 
!--     Invalidate all evolutions                                       
        CALL QNFALS(LEVDONE,MXX*10) 
!---    Update IFAILC                                                   
        CALL GRSETC 
!---    Update NFMAP                                                    
        CALL QNSETT 
!---    Update heavy quark xgrid                                        
        CALL GXHDEF 
      ENDIF 
                                                                        
      IF(LREADQ) THEN 
!--     Copy q2 grid to common block                                    
        NQ2 = NRQ 
        DO IQ = 1,NQ2 
          Q2TAB(IQ) = RQTAB(IQ) 
        ENDDO 
        WRITE(6,'(/                                                     &
     &    '' QNREAD: qgrid table read in (original overwritten)'')')    
!--     Invalidate hq weight tables since the grid has changed          
        LALFOK = .FALSE. 
        LDQ2OK = .FALSE. 
        LWFCOK = .FALSE. 
        LWLCOK = .FALSE. 
        LWFBOK = .FALSE. 
        LWLBOK = .FALSE. 
        LMARK  = .FALSE. 
        NGRVER = NGRVER + 1 
!--     Invalidate all evolutions                                       
        CALL QNFALS(LEVDONE,MXX*10) 
!---    Update IFAILC                                                   
        CALL GRSETC 
!---    Update NFMAP                                                    
        CALL QNSETT 
      ENDIF 
                                                                        
      IF(LREADC) THEN 
        IF(IV.LE.15) THEN 
          UDSCBT(4) = RMASS(4) 
          CBMSTF(4) = RMASS(4) 
          CBMSTF(5) = RMASS(4) 
        ELSE 
          CBMSTF(4) = RMASS(1) 
          CBMSTF(5) = RMASS(1) 
        ENDIF 
        WRITE(6,'(/                                                     &
     &    '' QNREAD: charm mass read in (original overwritten)'')')     
!--     Invalidate charm weight tables since charm mass has changed     
        LWFCOK = .FALSE. 
        LWLCOK = .FALSE. 
!--     Invalidate alpha_s table                                        
        LALFOK = .FALSE. 
      ENDIF 
                                                                        
      IF(LREADB) THEN 
        IF(IV.LE.15) THEN 
          UDSCBT(5) = RMASS(5) 
          CBMSTF(6) = RMASS(5) 
          CBMSTF(7) = RMASS(5) 
        ELSE 
          CBMSTF(6) = RMASS(2) 
          CBMSTF(7) = RMASS(2) 
        ENDIF 
        WRITE(6,'(/                                                     &
     &    '' QNREAD: bottom mass read in (original overwritten)'')')    
!--     Invalidate bottom weight tables since charm mass has changed    
        LWFBOK = .FALSE. 
        LWLBOK = .FALSE. 
!--     Invalidate alpha_s table                                        
        LALFOK = .FALSE. 
      ENDIF 
                                                                        
      IF(IV.LE.15) THEN 
        WRITE(6,'(/'' QNREAD: file was written with QCDNUM'',A8)')      &
     &   RHVERS                                                         
        WRITE(6,'( '' ------> Abandon reading the weight tables'')') 
        RETURN 
      ENDIF 
                                                                        
      IF(RWT1OK) THEN 
        READ(LUN,ERR=500) WGTFF1,WGTFG1,WGTGF1,WGTGG1 
        LWT1OK = .TRUE. 
        if(lhasilent.eq.0)                                              &
     &   WRITE(6,'(/'' QNREAD: LO weight tables read in'')')            
      ENDIF 
                                                                        
      IF(RWT2OK) THEN 
        READ(LUN,ERR=500) WGTPP2,WGTPM2,WGTNS2,WGTFF2,WGTFG2,WGTGF2,    &
     &                    WGTGG2                                        
        LWT2OK = .TRUE. 
        if(lhasilent.eq.0)                                              &
     &   WRITE(6,'(/'' QNREAD: NLO weight tables read in'')')           
      ENDIF 
                                                                        
      IF(RWTFOK) THEN 
        READ(LUN,ERR=500) WGTC2Q,WGTC2G,YNTC2Q,WGTCLQ,WGTCLG,WGTC3Q 
        LWTFOK = .TRUE. 
        if(lhasilent.eq.0)                                              &
     &   WRITE(6,'(/'' QNREAD: F2, FL weight tables read in'')')        
      ENDIF 
                                                                        
      IF(RWFCOK.OR.RWLCOK.OR.RWFBOK.OR.RWLBOK) THEN 
        READ(LUN,ERR=500) WH_C0KG,WH_C1KG,WH_C1BKG,                     &
     &                    WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ             
        LWFCOK = RWFCOK 
        LWLCOK = RWLCOK 
        LWFBOK = RWFBOK 
        LWLBOK = RWLBOK 
        if(lhasilent.eq.0) then 
        IF(RWFCOK)                                                      &
     &  WRITE(6,'(/'' QNREAD: F2C weight tables read in'')')            
        IF(RWLCOK)                                                      &
     &  WRITE(6,'(/'' QNREAD: FLC weight tables read in'')')            
        IF(RWFBOK)                                                      &
     &  WRITE(6,'(/'' QNREAD: F2B weight tables read in'')')            
        IF(RWLBOK)                                                      &
     &  WRITE(6,'(/'' QNREAD: FLB weight tables read in'')')            
        endif 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' QNREAD: cannot read file on lun = '',I5,            &
     &           '' ---> STOP'')') LUN                                  
                                                                        
      CALL QTRACE('QNREAD ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNPRIN.                                                     
!                                                                       
!     ======================                                            
      SUBROUTINE QNPRIN(LUN) 
!     ======================                                            
                                                                        
!---  QNPRIN: print default + current setting of QCDNUM parameters.     
!---  Called by QPRINT                                                  
!---  Input parameter: LUN. To be opened by user unless LUN = 6.        
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      IF(RS2CUT.GE.0.) THEN 
        RS2C = SQRT(RS2CUT) 
      ELSE 
        RS2C = RS2CUT 
      ENDIF 
                                                                        
      WRITE(LUN,'(//'' +-------+---+-------+--------------+'',          &
     & ''------------------------------------+'')')                     
      WRITE(LUN,'(  '' | var   |typ| deflt |     value    |'',          &
     & '' description                        |'')')                     
      WRITE(LUN,'(  '' +-------+---+-------+--------------+'',          &
     & ''------------------------------------+'')')                     
      WRITE(LUN,'('' | W1ANA | L |   T   | '',6X,L1,5X,                 &
     & '' | Analytical LO weight calculation   |'')') LW1ANA            
      WRITE(LUN,'('' | W1NUM | L |   F   | '',6X,L1,5X,                 &
     & '' | Numerical  LO weight calculation   |'')') LW1NUM            
      WRITE(LUN,'('' | W2NUM | L |   T   | '',6X,L1,5X,                 &
     & '' | Numerical NLO weight calculation   |'')') LW2NUM            
      WRITE(LUN,'('' | W2STF | L |   T   | '',6X,L1,5X,                 &
     & '' | Structure function NLO weights     |'')') LW2STF            
      WRITE(LUN,'('' | WTF2C | L |   F   | '',6X,L1,5X,                 &
     & '' | F2_charm  weight calculation       |'')') LWF2C             
      WRITE(LUN,'('' | WTF2B | L |   F   | '',6X,L1,5X,                 &
     & '' | F2_bottom weight calculation       |'')') LWF2B             
      WRITE(LUN,'('' | WTFLC | L |   F   | '',6X,L1,5X,                 &
     & '' | FL_charm  weight calculation       |'')') LWFLC             
      WRITE(LUN,'('' | WTFLB | L |   F   | '',6X,L1,5X,                 &
     & '' | FL_bottom weight calculation       |'')') LWFLB             
      WRITE(LUN,'('' | LIMCK | L |   T   | '',6X,L1,5X,                 &
     & '' | Check x, Q2 limits and cuts        |'')') LIMCK             
      WRITE(LUN,'('' | CLOWQ | L |   T   | '',6X,L1,5X,                 &
     & '' | Heavy F2,FL only for Q2 > 1.5 GeV2 |'')') LCLOWQ            
      WRITE(LUN,'('' | ORDER | I |   2   | '',6X,I1,5X,                 &
     & '' | LO (1) or NLO (2) calculations     |'')') IORD              
      WRITE(LUN,'('' | SCAX0 | R |  0.20 | '',E12.5,                    &
     & '' | x-grid  scale from log --> linear  |'')') SCAX0             
      WRITE(LUN,'('' | SCAQ0 | R | +inf  | '',E12.5,                    &
     & '' | Q2-grid scale from log --> linear  |'')') SCAQ0             
      WRITE(LUN,'('' | MCSTF | R |  1.5  | '',E12.5,                    &
     & '' | C mass for F2c, FLc (GeV)          |'')') CBMSTF(4)         
      WRITE(LUN,'('' | MBSTF | R |  5.0  | '',E12.5,                    &
     & '' | B mass for F2b, FLb (GeV)          |'')') CBMSTF(6)         
      WRITE(LUN,'('' | MCALF | R |  1.5  | '',E12.5,                    &
     & '' | C mass for alpha_s evolution (GeV) |'')') UDSCBT(4)         
      WRITE(LUN,'('' | MBALF | R |  5.0  | '',E12.5,                    &
     & '' | B mass for alpha_s evolution (GeV) |'')') UDSCBT(5)         
      WRITE(LUN,'('' | MTALF | R | 188.  | '',E12.5,                    &
     & '' | T mass for alpha_s evolution (GeV) |'')') UDSCBT(6)         
      WRITE(LUN,'('' | ALFAS | R | 0.180 | '',E12.5,                    &
     & '' | Value of alpha_s                   |'')') ALPHA0            
      WRITE(LUN,'('' | ALFQ0 | R |  50.  | '',E12.5,                    &
     & '' | Q2 where alpha_s is given (GeV2)   |'')') Q0ALFA            
      WRITE(LUN,'('' | AAAR2 | R |  1.0  | '',E12.5,                    &
     & '' | R2 = A*M2 + B (ren. scale)         |'')') AAAR2             
      WRITE(LUN,'('' | BBBR2 | R |  0.0  | '',E12.5,                    &
     & '' | R2 = A*M2 + B (ren. scale)         |'')') BBBR2             
      WRITE(LUN,'('' | AAM2L | R |  1.0  | '',E12.5,                    &
     & '' | M2 = A*Q2 + B (light fact. scale)  |'')') AAM2L             
      WRITE(LUN,'('' | BBM2L | R |  0.0  | '',E12.5,                    &
     & '' | M2 = A*Q2 + B (light fact. scale)  |'')') BBM2L             
      WRITE(LUN,'('' | AAM2H | R |  1.0  | '',E12.5,                    &
     & '' | M2 = A*Q2 + B (heavy fact. scale)  |'')') AAM2H             
      WRITE(LUN,'('' | BBM2H | R |  0.0  | '',E12.5,                    &
     & '' | M2 = A*Q2 + B (heavy fact. scale)  |'')') BBM2H             
      WRITE(LUN,'(  '' +-------+---+-------+--------------+'',          &
     & ''------------------------------------+'')')                     
      WRITE(LUN,'('' | TCHRM | R | -inf  | '',E12.5,                    &
     & '' | Charm threshold  (GeV2)            |'')') THRS34            
      WRITE(LUN,'('' | TBOTT | R | +inf  | '',E12.5,                    &
     & '' | Bottom threshold (GeV2)            |'')') THRS45            
      WRITE(LUN,'('' | XMINC | R |  0.0  | '',E12.5,                    &
     & '' | Xmin cut  (.le.0 = no cut)         |'')') XMICUT            
      WRITE(LUN,'('' | QMINC | R |  0.0  | '',E12.5,                    &
     & '' | Qmin cut  (.le.0 = no cut)         |'')') QMICUT            
      WRITE(LUN,'('' | QMAXC | R |  0.0  | '',E12.5,                    &
     & '' | Qmax cut  (.le.0 = no cut)         |'')') QMACUT            
      WRITE(LUN,'('' | ROOTS | R |  0.0  | '',E12.5,                    &
     & '' | Roots cut (.le.0 = no cut)         |'')') RS2C              
      WRITE(LUN,'('' | QMINA | R |  0.0  | '',E12.5,                    &
     & '' | Lowest Q2 gridpoint above Lambda2  |'')') QMINAS            
      WRITE(LUN,'(  '' +-------+---+-------+--------------+'',          &
     & ''------------------------------------+'')')                     
      WRITE(LUN,'('' | ASOLD | L |   F   | '',6X,L1,5X,                 &
     & '' | Use old (incorrect) a_s evolution  |'')') LASOLD            
      WRITE(LUN,'('' | BMARK | L |   F   | '',6X,L1,5X,                 &
     & '' | Do not use: for tests only         |'')') LBMARK            
      WRITE(LUN,'('' | FLFAC | R |  0.0  | '',E12.5,                    &
     & '' | Hands off : for experts only       |'')') BBM2H             
      WRITE(LUN,'(  '' +-------+---+-------+--------------+'',          &
     & ''------------------------------------+'')')                     
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNVERS.                                                     
!                                                                       
!     ==============================================                    
      SUBROUTINE QNVERS(VERSION,LDOUBLE,NXMAX,NQMAX) 
!     ==============================================                    
                                                                        
!---  QNVERS: return version number, dp flag and max # of gridpoints.   
!---  Called by user.                                                   
!---  Output variables: VERSION (character*8)                           
!---                    LDOUBLE (logical)                               
!---                    NXMAX, NQMAX (integer); set by parameter        
!---                    statement in common block QCNXQM.               
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*8 VERSION 
      LOGICAL     LDOUBLE 
                                                                        
      CHARACTER*8 CHVERS,CHDATE 
      COMMON/QCVERS/ CHVERS,CHDATE 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      CALL QTRACE('QNVERS ',0) 
                                                                        
      VERSION = CHVERS 
      LDOUBLE = LDOUBL 
      NXMAX   = MXX-1 
      NQMAX   = MQ2-1 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QPRINT.                                                     
                                                                        
!     ==========================                                        
      SUBROUTINE QPRINT(LUN,OPT) 
!     ==========================                                        
                                                                        
!---  QPRINT: steering routine to print various QCDNUM info on          
!--           logical unit number LUN (to be opened by the user).       
!---  Called by user.                                                   
!---  Input integer LUN  :  locical unit number.                        
!---        character OPT: 'A' (All)        print all info.             
!---                       'B' (Booklist)   print pdf definitions.      
!---                       'P' (Parameters) Parameter/option list.      
!---                       'S' (Statistics) # STF function calls.       
!---                       'T' (Timelog)    timelog.                    
!---                       'X' (Xq2grid)    grid,thresholds,cuts.       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT 
      CHARACTER*1   OPT1 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      CALL QTRACE('QPRINT ',0) 
                                                                        
      IF(LENOCC_LHA(OPT).LT.1) GOTO 500 
      OPT1 = OPT(1:1) 
      CALL CLTOU_LHA(OPT1) 
                                                                        
                           !                                            
      IF(OPT1.EQ.'T') THEN 
        CALL QPTIME(LUN) 
      ELSEIF(OPT1.EQ.'P') THEN 
        CALL QNPRIN(LUN) 
      ELSEIF(OPT1.EQ.'B') THEN 
        CALL QNLIST(LUN) 
      ELSEIF(OPT1.EQ.'S') THEN 
        CALL QNSTAT(LUN) 
      ELSEIF(OPT1.EQ.'X') THEN 
        CALL QPGRID(LUN) 
      ELSEIF(OPT1.EQ.'A') THEN 
        CALL QNPRIN(LUN) 
        CALL QNLIST(LUN) 
        CALL QPGRID(LUN) 
        CALL QNSTAT(LUN) 
        CALL QPTIME(LUN) 
      ELSE 
        GOTO 500 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QPRINT ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input LUN :'',I5   )') LUN 
      WRITE(6,'( ''       OPT :'',A    )') OPT 
      WRITE(6,'(/'' Option should be A, B, P, S, T or X'')') 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNTIME.                                                     
                                                                        
!     ======================                                            
      SUBROUTINE QNTIME(OPT) 
!     ======================                                            
                                                                        
!---  QNTIME: start/halt/continue the timelog.                          
!---  Called by user and by QPTIME.                                     
!---  Input variable: 'Start'    initialise and start the timelog.      
!---                  'Hold'     stop logging.                          
!---                  'Cont'     continue logging.                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT 
      CHARACTER*1   OPT1 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      CALL QTRACE('QNTIME ',0) 
                                                                        
      IF(LENOCC_LHA(OPT).LT.1) GOTO 500 
      OPT1 = OPT(1:1) 
      CALL CLTOU_LHA(OPT1) 
                                                                        
      IF(OPT1.EQ.'S') THEN 
                                                                        
        DO I = 1,10 
          T_SPENT(I) = 0. 
          E_CALLS(I) = 0. 
          N_CALLS(I) = 0 
        ENDDO 
        LTIME = .TRUE. 
                                                                        
        N_CALLS(1) = N_CALLS(1)+1 
        CALL TIMEX_LHA(T_START(1)) 
                                                                        
      ELSEIF(OPT1.EQ.'H') THEN 
                                                                        
        LTIME = .FALSE. 
        CALL TIMEX_LHA(T_END(1)) 
        T_SPENT(1) = T_SPENT(1)+T_END(1)-T_START(1) 
        T_START(1) = T_END(1) 
                                                                        
      ELSEIF(OPT1.EQ.'C') THEN 
                                                                        
        IF(.NOT.LTIME) THEN 
          LTIME = .TRUE. 
          N_CALLS(1) = N_CALLS(1)+1 
          CALL TIMEX_LHA(T_START(1)) 
        ENDIF 
                                                                        
      ELSE 
                                                                        
        GOTO 500 
                                                                        
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNTIME ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input OPT :'',A    )') OPT 
      WRITE(6,'(/'' Option should be S, H or C         '')') 
                                                                        
      CALL QTRACE('QNTIME ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QPTIME.                                                     
                                                                        
!     ======================                                            
      SUBROUTINE QPTIME(LUN) 
!     ======================                                            
                                                                        
!---  QPTIME: start/print the timelog.                                  
!---  Called by QPRINT.                                                 
!---  Input variable: LUN logical unit number                           
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      CALL QNTIME('H') 
                                                                        
      N_TOT      = N_CALLS(3)+N_CALLS(4)+N_CALLS(5) 
      E_TOT      = E_CALLS(3)+E_CALLS(4)+E_CALLS(5) 
      T_TOT      = T_SPENT(3)+T_SPENT(4)+T_SPENT(5) 
      T_REST     = T_SPENT(1)-T_TOT-T_SPENT(2)-T_SPENT(6) 
      DUMMY      = 1. 
      F_FAST     = 0. 
      DO J = 1,5 
        F_FAST   = F_FAST+IFCNT(1,J) 
      ENDDO 
      WRITE(LUN,                                                        &
     &  '(//'' -------------------------------------------------'')')   
      WRITE(LUN,                                                        &
     &  '(  '' Routine     # calls   # evols   CPU sec  CPU/evol'')')   
      WRITE(LUN,                                                        &
     &  '(  '' -------------------------------------------------'')')   
      WRITE(LUN,                                                        &
     & '('' EVOLNM   '',I10,2F10.1,F10.2)') N_CALLS(3),                 &
     &      E_CALLS(3),T_SPENT(3),T_SPENT(3)/MAX(E_CALLS(3),DUMMY)      
      WRITE(LUN,                                                        &
     & '('' EVOLNP   '',I10,2F10.1,F10.2)') N_CALLS(4),                 &
     &      E_CALLS(4),T_SPENT(4),T_SPENT(4)/MAX(E_CALLS(4),DUMMY)      
      WRITE(LUN,                                                        &
     & '('' EVOLSG   '',I10,2F10.1,F10.2)') N_CALLS(5),                 &
     &      E_CALLS(5),T_SPENT(5),T_SPENT(5)/MAX(E_CALLS(5),DUMMY)      
      WRITE(LUN,                                                        &
     &  '(  '' -------------------------------------------------'')')   
      WRITE(LUN,                                                        &
     & '('' AP total '',I10,2F10.1,F10.2)') N_TOT,                      &
     &      E_TOT,T_TOT,T_TOT/MAX(E_TOT,DUMMY)                          
      WRITE(LUN,'('' '')') 
      WRITE(LUN,                                                        &
     & '('' STFAST   '',I10,   2F10.1)') N_CALLS(6),F_FAST,T_SPENT(6)   
      WRITE(LUN,                                                        &
     & '('' QNFILW   '',I10,10X,F10.1)') N_CALLS(2),T_SPENT(2)          
      WRITE(LUN,                                                        &
     & '('' Other    '',10X,10X,F10.1)') T_REST                         
      WRITE(LUN,                                                        &
     &  '(  '' -------------------------------------------------'')')   
      WRITE(LUN,                                                        &
     & '('' Total    '',10X,10X,F10.1)') T_SPENT(1)                     
      WRITE(LUN,                                                        &
     &  '(  '' -------------------------------------------------'')')   
                                                                        
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNSTAT.                                                     
                                                                        
!     ======================                                            
      SUBROUTINE QNSTAT(LUN) 
!     ======================                                            
                                                                        
!---  QNSTAT: print number of structure function calculations.          
!---  Called by user.                                                   
!---  Input parameter: LUN to be opened by user unless LUN = 6.         
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      DIMENSION ITOT(5) 
                                                                        
       DO J = 1,5 
        ITOT(J) = 0 
        DO I = -1,1 
          ITOT(J) = ITOT(J)+IFCNT(I,J) 
        ENDDO 
      ENDDO 
                                                                        
      WRITE(LUN,'(//'' ------------------------------'',                &
     &   ''--------------------------------------------'')')            
      WRITE(LUN,'(  '' Structure function calls '',                     &
     &   ''           F2       FL      xF3'',                           &
     &                ''      F2h      FLh'')')                         
      WRITE(LUN,'(  '' ------------------------------'',                &
     &   ''--------------------------------------------'')')            
      WRITE(LUN,                                                        &
     & '('' Slow calculation             '',5I9)') (IFCNT( 0,J),J=1,5)  
      WRITE(LUN,                                                        &
     & '('' Fast calculation             '',5I9)') (IFCNT( 1,J),J=1,5)  
      WRITE(LUN,                                                        &
     & '('' Outside grid or cuts         '',5I9)') (IFCNT(-1,J),J=1,5)  
      WRITE(LUN,'(  '' ------------------------------'',                &
     &   ''--------------------------------------------'')')            
      WRITE(LUN,                                                        &
     & '('' Total                        '',5I9)') (   ITOT(J),J=1,5)   
      WRITE(LUN,'(  '' ------------------------------'',                &
     &   ''--------------------------------------------'')')            
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNIVAL.                                                     
                                                                        
!     ================================                                  
      SUBROUTINE QNIVAL(OPT,FLAG,IVAL) 
!     ================================                                  
                                                                        
!---  QNIVAL: set/get integer variable.                                 
!---  Called by user or internally by s/r QNISET and QNIGET.            
!---  Input parameters: 'OPT'   = 'Set' or 'Get'.                       
!---                    'FLAG'  = variable name to set or get.          
!---                    'IVAL' (integer) input or output variable.      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT 
      CHARACTER*1   OPT1 
      CHARACTER*(*) FLAG 
      CHARACTER*5   FLAG5 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      IF(LENOCC_LHA(OPT).LT.1)  THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
      IF(LENOCC_LHA(FLAG).LT.5) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
      OPT1   = OPT(1:1) 
      FLAG5  = FLAG(1:5) 
      CALL CLTOU_LHA(OPT1) 
      CALL CLTOU_LHA(FLAG5) 
                                                                        
!     ----------------------                                            
                           !                                            
      IF(OPT1.EQ.'S') THEN 
!     ----------------------                                            
                                                                        
        IF    (FLAG5.EQ.'ORDER') THEN 
          IF(IVAL.LE.0.OR.IVAL.GE.3) THEN 
            IERR = 3 
            GOTO 500 
          ENDIF 
          IORD   = IVAL 
!--       Invalidate all evolutions                                     
          CALL QNFALS(LEVDONE,MXX*10) 
          LALFOK = .FALSE. 
        ELSE 
          IERR = 2 
          GOTO 500 
        ENDIF 
                                                                        
!     --------------------------                                        
                               !                                        
      ELSEIF(OPT1.EQ.'G') THEN 
!     --------------------------                                        
                                                                        
        IF    (FLAG5.EQ.'ORDER') THEN 
          IVAL = IORD 
        ELSE 
          IERR = 2 
          GOTO 500 
        ENDIF 
                                                                        
!     ------                                                            
           !                                                            
      ELSE 
!     ------                                                            
                                                                        
        IERR = 1 
        GOTO 500 
                                                                        
!     -------                                                           
            !                                                           
      ENDIF 
!     -------                                                           
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNIVAL ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input OPT : '',A    )') OPT 
      WRITE(6,'( ''       VAR : '',A    )') FLAG 
      WRITE(6,'( ''       VAL : '',I10  )') IVAL 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' OPT should be either SET or GET '')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Variable VAR not found'')') 
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' IVAL out of allowed range'')') 
      ENDIF 
                                                                        
      CALL QTRACE('QNIVAL ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNISET.                                                     
                                                                        
!     ============================                                      
      SUBROUTINE QNISET(FLAG,IVAL) 
!     ============================                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) FLAG 
                                                                        
      CALL QTRACE('QNISET ',0) 
                                                                        
      CALL QNIVAL('SET',FLAG,IVAL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNIGET.                                                     
                                                                        
!     ============================                                      
      SUBROUTINE QNIGET(FLAG,IVAL) 
!     ============================                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) FLAG 
                                                                        
      CALL QTRACE('QNIGET ',0) 
                                                                        
      CALL QNIVAL('GET',FLAG,IVAL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNRVAL.                                                     
                                                                        
!     ===============================                                   
      SUBROUTINE QNRVAL(OPT,FLAG,VAL) 
!     ===============================                                   
                                                                        
!---  QNRVAL: set/get floating point variable.                          
!---  Called by user or internally by s/r QNRSET and QNRGET.            
!---  Input parameters: 'OPT'   = 'Set' or 'Get'.                       
!---                    'FLAG'  = variable name to set or get.          
!---                    'VAL' (real or d.p.) input or output variable.  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT 
      CHARACTER*1   OPT1 
      CHARACTER*(*) FLAG 
      CHARACTER*5   FLAG5 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      IF(LENOCC_LHA(OPT).LT.1)  THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
      IF(LENOCC_LHA(FLAG).LT.5) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
      OPT1   = OPT(1:1) 
      FLAG5  = FLAG(1:5) 
      CALL CLTOU_LHA(OPT1) 
      CALL CLTOU_LHA(FLAG5) 
                                                                        
!     ----------------------                                            
                           !                                            
      IF(OPT1.EQ.'S') THEN 
!     ----------------------                                            
                                                                        
        IF    (FLAG5.EQ.'AAM2H'.OR.FLAG5.EQ.'AATQ2') THEN 
          IF(VAL.LE.0.) THEN 
            IERR = 3 
            GOTO 500 
          ENDIF 
          AAM2H  = VAL 
          DO I = 1,30 
            LFFCAL(4,I) = .FALSE. 
            LFFCAL(5,I) = .FALSE. 
            LFFCAL(6,I) = .FALSE. 
            LFFCAL(7,I) = .FALSE. 
          ENDDO 
        ELSEIF(FLAG5.EQ.'BBM2H'.OR.FLAG5.EQ.'PLUSB') THEN 
          BBM2H  = VAL 
          DO I = 1,30 
            LFFCAL(4,I) = .FALSE. 
            LFFCAL(5,I) = .FALSE. 
            LFFCAL(6,I) = .FALSE. 
            LFFCAL(7,I) = .FALSE. 
          ENDDO 
        ELSEIF(FLAG5.EQ.'AAM2L') THEN 
          IF(VAL.LE.0.) THEN 
            IERR = 3 
            GOTO 500 
          ENDIF 
          AAM2L  = VAL 
          DO I = 1,30 
            LFFCAL(1,I) = .FALSE. 
            LFFCAL(2,I) = .FALSE. 
            LFFCAL(3,I) = .FALSE. 
          ENDDO 
        ELSEIF(FLAG5.EQ.'BBM2L') THEN 
          BBM2L  = VAL 
          DO I = 1,30 
            LFFCAL(1,I) = .FALSE. 
            LFFCAL(2,I) = .FALSE. 
            LFFCAL(3,I) = .FALSE. 
          ENDDO 
        ELSEIF(FLAG5.EQ.'AAAR2') THEN 
          AAAR2  = VAL 
!--       Invalidate all evolutions                                     
          CALL QNFALS(LEVDONE,MXX*10) 
          LALFOK = .FALSE. 
          DO I = 1,30 
            DO J = 1,7 
              LFFCAL(J,I)  = .FALSE. 
            ENDDO 
          ENDDO 
        ELSEIF(FLAG5.EQ.'BBBR2') THEN 
          BBBR2  = VAL 
!--       Invalidate all evolutions                                     
          CALL QNFALS(LEVDONE,MXX*10) 
          LALFOK = .FALSE. 
          DO I = 1,30 
            DO J = 1,7 
              LFFCAL(J,I)  = .FALSE. 
            ENDDO 
          ENDDO 
        ELSEIF(FLAG5.EQ.'FLFAC') THEN 
          FL_FAC = VAL 
          DO I = 1,30 
            LFFCAL(2,I)  = .FALSE. 
          ENDDO 
        ELSEIF(FLAG5.EQ.'SCAX0') THEN 
          IF(VAL.LE.0.) THEN 
            IERR = 3 
            GOTO 500 
          ENDIF 
          SCAX0     = VAL 
        ELSEIF(FLAG5.EQ.'SCAQ0') THEN 
          IF(VAL.LE.0.) THEN 
            IERR = 3 
            GOTO 500 
          ENDIF 
          SCAQ0     = VAL 
        ELSE 
          IF(VAL.LE.0.) THEN 
            IERR = 3 
            GOTO 500 
          ENDIF 
!--       Invalidate all evolutions                                     
          CALL QNFALS(LEVDONE,MXX*10) 
                             !force alpha_s to be recalculated          
          LALFOK = .FALSE. 
          IF    (FLAG5.EQ.'UMASS') THEN 
            UDSCBT(1) = VAL 
          ELSEIF(FLAG5.EQ.'DMASS') THEN 
            UDSCBT(2) = VAL 
          ELSEIF(FLAG5.EQ.'SMASS') THEN 
            UDSCBT(3) = VAL 
          ELSEIF(FLAG5.EQ.'CMASS') THEN 
            UDSCBT(4) = VAL 
            CBMSTF(4) = VAL 
            CBMSTF(5) = VAL 
                              !invalidate F2C weight tables             
            LWFCOK = .FALSE. 
                              !invalidate FLC weight tables             
            LWLCOK = .FALSE. 
          ELSEIF(FLAG5.EQ.'MCSTF') THEN 
            CBMSTF(4) = VAL 
            CBMSTF(5) = VAL 
            LWFCOK = .FALSE. 
            LWLCOK = .FALSE. 
          ELSEIF(FLAG5.EQ.'MCALF') THEN 
            UDSCBT(4) = VAL 
          ELSEIF(FLAG5.EQ.'BMASS') THEN 
            UDSCBT(5) = VAL 
            CBMSTF(6) = VAL 
            CBMSTF(7) = VAL 
                              !invalidate F2B weight tables             
            LWFBOK = .FALSE. 
                              !invalidate FLB weight tables             
            LWLBOK = .FALSE. 
          ELSEIF(FLAG5.EQ.'MBSTF') THEN 
            CBMSTF(6) = VAL 
            CBMSTF(7) = VAL 
            LWFBOK = .FALSE. 
            LWLBOK = .FALSE. 
          ELSEIF(FLAG5.EQ.'MBALF') THEN 
            UDSCBT(5) = VAL 
          ELSEIF(FLAG5.EQ.'MTALF') THEN 
            UDSCBT(6) = VAL 
          ELSEIF(FLAG5.EQ.'TMASS') THEN 
            UDSCBT(6) = VAL 
          ELSEIF(FLAG5.EQ.'ALFAS') THEN 
            ALPHA0    = VAL 
          ELSEIF(FLAG5.EQ.'ALFQ0') THEN 
            Q0ALFA    = VAL 
          ELSE 
            IERR = 2 
            GOTO 500 
          ENDIF 
        ENDIF 
                                                                        
!     --------------------------                                        
                               !                                        
      ELSEIF(OPT1.EQ.'G') THEN 
!     --------------------------                                        
                                                                        
        IF    (FLAG5.EQ.'SCAX0') THEN 
          VAL = SCAX0 
        ELSEIF(FLAG5.EQ.'SCAQ0') THEN 
          VAL = SCAQ0 
        ELSEIF(FLAG5.EQ.'AAM2H'.OR.FLAG5.EQ.'AATQ2') THEN 
          VAL = AAM2H 
        ELSEIF(FLAG5.EQ.'BBM2H'.OR.FLAG5.EQ.'PLUSB') THEN 
          VAL = BBM2H 
        ELSEIF(FLAG5.EQ.'AAM2L') THEN 
          VAL = AAM2L 
        ELSEIF(FLAG5.EQ.'BBM2L') THEN 
          VAL = BBM2L 
        ELSEIF(FLAG5.EQ.'AAAR2') THEN 
          VAL = AAAR2 
        ELSEIF(FLAG5.EQ.'BBBR2') THEN 
          VAL = BBBR2 
        ELSEIF(FLAG5.EQ.'FLFAC') THEN 
          VAL = FL_FAC 
        ELSEIF(FLAG5.EQ.'UMASS') THEN 
          VAL = UDSCBT(1) 
        ELSEIF(FLAG5.EQ.'DMASS') THEN 
          VAL = UDSCBT(2) 
        ELSEIF(FLAG5.EQ.'SMASS') THEN 
          VAL = UDSCBT(3) 
        ELSEIF(FLAG5.EQ.'CMASS') THEN 
          VAL = UDSCBT(4) 
        ELSEIF(FLAG5.EQ.'BMASS') THEN 
          VAL = UDSCBT(5) 
        ELSEIF(FLAG5.EQ.'TMASS') THEN 
          VAL = UDSCBT(6) 
        ELSEIF(FLAG5.EQ.'MCSTF') THEN 
          VAL = CBMSTF(4) 
        ELSEIF(FLAG5.EQ.'MBSTF') THEN 
          VAL = CBMSTF(6) 
        ELSEIF(FLAG5.EQ.'MCALF') THEN 
          VAL = UDSCBT(4) 
        ELSEIF(FLAG5.EQ.'MBALF') THEN 
          VAL = UDSCBT(5) 
        ELSEIF(FLAG5.EQ.'MTALF') THEN 
          VAL = UDSCBT(6) 
        ELSEIF(FLAG5.EQ.'ALFAS') THEN 
          VAL = ALPHA0 
        ELSEIF(FLAG5.EQ.'ALFQ0') THEN 
          VAL = Q0ALFA 
        ELSEIF(FLAG5.EQ.'TCHRM') THEN 
          VAL = THRS34 
        ELSEIF(FLAG5.EQ.'TBOTT') THEN 
          VAL = THRS45 
        ELSEIF(FLAG5.EQ.'XMINC') THEN 
          VAL = XMICUT 
        ELSEIF(FLAG5.EQ.'QMINC') THEN 
          VAL = QMICUT 
        ELSEIF(FLAG5.EQ.'QMAXC') THEN 
          VAL = QMACUT 
        ELSEIF(FLAG5.EQ.'ROOTS') THEN 
          IF(RS2CUT.GE.0.) THEN 
            VAL = SQRT(RS2CUT) 
          ELSE 
            VAL = RS2CUT 
          ENDIF 
        ELSEIF(FLAG5.EQ.'QMINA') THEN 
          VAL = QMINAS 
        ELSE 
          IERR = 2 
          GOTO 500 
        ENDIF 
                                                                        
!     ------                                                            
           !                                                            
      ELSE 
!     ------                                                            
                                                                        
        IERR = 1 
        GOTO 500 
                                                                        
!     -------                                                           
            !                                                           
      ENDIF 
!     -------                                                           
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNRVAL ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input OPT : '',A    )') OPT 
      WRITE(6,'( ''       VAR : '',A    )') FLAG 
      WRITE(6,'( ''       VAL : '',E12.5)') RVAL 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' OPT should be either SET or GET '')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Variable VAR not found'')') 
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' VAL should be .gt. 0  '')') 
      ENDIF 
                                                                        
      CALL QTRACE('QNRVAL ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNRSET.                                                     
                                                                        
!     ============================                                      
      SUBROUTINE QNRSET(FLAG,RVAL) 
!     ============================                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) FLAG 
                                                                        
      CALL QTRACE('QNRSET ',0) 
                                                                        
      CALL QNRVAL('SET',FLAG,RVAL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNRGET.                                                     
                                                                        
!     ============================                                      
      SUBROUTINE QNRGET(FLAG,RVAL) 
!     ============================                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) FLAG 
                                                                        
      CALL QTRACE('QNRGET ',0) 
                                                                        
      CALL QNRVAL('GET',FLAG,RVAL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNLVAL.                                                     
                                                                        
!     ================================                                  
      SUBROUTINE QNLVAL(OPT,FLAG,LVAL) 
!     ================================                                  
                                                                        
!---  QNLVAL: set/get logical variable.                                 
!---  Called by user or internally by s/r QNLSET and QNLGET.            
!---  Input parameters: 'OPT'   = 'Set' or 'Get'.                       
!---                    'FLAG'  = variable name to set or get.          
!---                    'VAL' (logical) input or output variable.       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT 
      CHARACTER*1   OPT1 
      CHARACTER*(*) FLAG 
      CHARACTER*5   FLAG5 
      LOGICAL       LVAL 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      IF(LENOCC_LHA(OPT).LT.1)  THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
      IF(LENOCC_LHA(FLAG).LT.5) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
      OPT1   = OPT(1:1) 
      FLAG5  = FLAG(1:5) 
      CALL CLTOU_LHA(OPT1) 
      CALL CLTOU_LHA(FLAG5) 
                                                                        
!     ----------------------                                            
                           !                                            
      IF(OPT1.EQ.'S') THEN 
!     ----------------------                                            
                                                                        
        IF    (FLAG5.EQ.'W1ANA' ) THEN 
          LW1ANA = LVAL 
          IF(LW1ANA) LW1NUM = .FALSE. 
        ELSEIF(FLAG5.EQ.'W1NUM' ) THEN 
          LW1NUM = LVAL 
          IF(LW1NUM) LW1ANA = .FALSE. 
        ELSEIF(FLAG5.EQ.'W2NUM' ) THEN 
          LW2NUM = LVAL 
        ELSEIF(FLAG5.EQ.'W2STF' ) THEN 
          LW2STF = LVAL 
        ELSEIF(FLAG5.EQ.'WTF2C' ) THEN 
          LWF2C  = LVAL 
        ELSEIF(FLAG5.EQ.'WTFLC' ) THEN 
          LWFLC  = LVAL 
        ELSEIF(FLAG5.EQ.'WTF2B' ) THEN 
          LWF2B  = LVAL 
        ELSEIF(FLAG5.EQ.'WTFLB' ) THEN 
          LWFLB  = LVAL 
        ELSEIF(FLAG5.EQ.'BMARK' ) THEN 
          LBMARK = LVAL 
          LALFOK = .FALSE. 
        ELSEIF(FLAG5.EQ.'LIMCK' ) THEN 
          LIMCK  = LVAL 
        ELSEIF(FLAG5.EQ.'CLOWQ' ) THEN 
          LCLOWQ = LVAL 
        ELSEIF(FLAG5.EQ.'ASOLD' ) THEN 
          LASOLD = LVAL 
          LALFOK = .FALSE. 
        ELSE 
          IERR = 2 
          GOTO 500 
        ENDIF 
                                                                        
!     --------------------------                                        
                               !                                        
      ELSEIF(OPT1.EQ.'G') THEN 
!     --------------------------                                        
                                                                        
        IF    (FLAG5.EQ.'W1ANA' ) THEN 
          LVAL = LW1ANA 
        ELSEIF(FLAG5.EQ.'W1NUM' ) THEN 
          LVAL = LW1NUM 
        ELSEIF(FLAG5.EQ.'W2NUM' ) THEN 
          LVAL = LW2NUM 
        ELSEIF(FLAG5.EQ.'W2STF' ) THEN 
          LVAL = LW2STF 
        ELSEIF(FLAG5.EQ.'WTF2C' ) THEN 
          LVAL = LWF2C 
        ELSEIF(FLAG5.EQ.'WTFLC' ) THEN 
          LVAL = LWFLC 
        ELSEIF(FLAG5.EQ.'WTF2B' ) THEN 
          LVAL = LWF2B 
        ELSEIF(FLAG5.EQ.'WTFLB' ) THEN 
          LVAL = LWFLB 
        ELSEIF(FLAG5.EQ.'BMARK' ) THEN 
          LVAL = LBMARK 
        ELSEIF(FLAG5.EQ.'LIMCK' ) THEN 
          LVAL = LIMCK 
        ELSEIF(FLAG5.EQ.'CLOWQ' ) THEN 
          LVAL = LCLOWQ 
        ELSEIF(FLAG5.EQ.'ASOLD' ) THEN 
          LVAL = LASOLD 
        ELSE 
          IERR = 2 
          GOTO 500 
        ENDIF 
                                                                        
!     ------                                                            
           !                                                            
      ELSE 
!     ------                                                            
                                                                        
        IERR = 1 
        GOTO 500 
                                                                        
!     -------                                                           
            !                                                           
      ENDIF 
!     -------                                                           
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNLVAL ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input OPT : '',A    )') OPT 
      WRITE(6,'( ''       VAR : '',A    )') FLAG 
      WRITE(6,'( ''       VAL : '',L2   )') LVAL 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' OPT should be either SET or GET '')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Variable VAR not found'')') 
      ENDIF 
                                                                        
      CALL QTRACE('QNLVAL ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNLSET.                                                     
                                                                        
!     ============================                                      
      SUBROUTINE QNLSET(FLAG,LVAL) 
!     ============================                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) FLAG 
      LOGICAL       LVAL 
                                                                        
      CALL QTRACE('QNLSET ',0) 
                                                                        
      CALL QNLVAL('SET',FLAG,LVAL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNLGET.                                                     
                                                                        
!     ============================                                      
      SUBROUTINE QNLGET(FLAG,LVAL) 
!     ============================                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) FLAG 
      LOGICAL       LVAL 
                                                                        
      CALL QTRACE('QNLGET ',0) 
                                                                        
      CALL QNLVAL('GET',FLAG,LVAL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRMXMQ.                                                     
                                                                        
!     ============================                                      
      SUBROUTINE GRMXMQ(NXMA,NQMA) 
!     ============================                                      
                                                                        
!---  GRMXMQ: return max allowed number of x, Q2 gridpoints.            
!---  Called by user.                                                   
!---  MXX and MQ2 are set by parameter statement in common QCNXQM.      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CALL QTRACE('GRMXMQ ',0) 
                                                                        
      NXMA = MXX-1 
      NQMA = MQ2-1 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRGIVE.                                                     
                                                                        
!     ========================================                          
      SUBROUTINE GRGIVE(NX,XMI,XMA,NQ,QMI,QMA) 
!     ========================================                          
                                                                        
!---  GRGIVE: return current grid definition.                           
!---  Called by user.                                                   
!---  Output variables: NX  (integer) number of x gridpoints.           
!---                    XMI (real or d.p.) lowest x value.              
!---                    XMA (real or d.p.) highest x value = 1.         
!---                    NQ  (integer) number of Q2 gridpoints.          
!---                    QMI (real or d.p.) lowest Q2 value.             
!---                    QMA (real or d.p.) highest Q2 value.            
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CALL QTRACE('GRGIVE ',0) 
                                                                        
      NX  = NXX 
      XMI = XXTAB(1) 
      XMA = XXTAB(NXX+1) 
      NQ  = NQ2 
      QMI = Q2TAB(1) 
      QMA = Q2TAB(NQ2) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRXNUL.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE GRXNUL 
!     =================                                                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('GRXNUL ',0) 
                                                                        
!---  Invalidate weight tables (validated by call to QNFILW)            
      LWT1OK = .FALSE. 
      LWT2OK = .FALSE. 
      LWTFOK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!---  Set grid to zero                                                  
      CALL QNVNUL(XXTAB,MXX) 
      CALL QNVNUL(XHTAB,MXX) 
      CALL QNINUL(IHTAB,MXX) 
      NXX    = 0 
      NGRVER = 0 
                                                                        
!---  Update IFAILC                                                     
      CALL GRSETC 
                                                                        
!---  Update NFMAP                                                      
      CALL QNSETT 
                                                                        
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRXINP.                                                     
                                                                        
!     ============================                                      
      SUBROUTINE GRXINP(XARRAY,NX) 
!     ============================                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DIMENSION XARRAY(*) 
                                                                        
      DATA EPSI /1.E-6/ 
                                                                        
      CALL QTRACE('GRXINP ',0) 
                                                                        
      IF(NX.LE.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF((NX+NXX).GT.MXX-1) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
!---  Invalidate weight tables (validated by call to QNFILW)            
      LWT1OK = .FALSE. 
      LWT2OK = .FALSE. 
      LWTFOK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!---  if this number changes, QCDNUM knows that the grid has changed    
      NGRVER = NGRVER + 1 
                                                                        
      IF(NXX.EQ.0) THEN 
        DO 10 IX = 1,NX 
          X = XARRAY(IX) 
          IF(X.LE.0..OR.X.GT.1.) THEN 
            IERR = 3 
            GOTO 500 
          ENDIF 
          NXX    = NXX+1 
          XXTAB(IX) = X 
   10   CONTINUE 
        IF(XXTAB(NXX).EQ.1.) THEN 
          NXX = NXX-1 
        ELSE 
          XXTAB(NXX+1) = 1. 
        ENDIF 
        RETURN 
      ENDIF 
                                                                        
      IF(XXTAB(NXX).EQ.1.) THEN 
        NXX = NXX-1 
      ELSE 
        XXTAB(NXX+1) = 1. 
      ENDIF 
                                                                        
      NXP = NXX+1 
                                                                        
      DO 100 IX = 1,NX 
                                                                        
        X = XARRAY(IX) 
                                                                        
        IF(X.LE.0..OR.X.GT.1.) THEN 
          IERR = 3 
          GOTO 500 
        ENDIF 
                                                                        
!mb     IF(X.LT.XXTAB(1)-EPSI) THEN                                     
        IF(X/XXTAB(1).LT.1.-EPSI) THEN 
                                                                        
          DO 20 JX = NXP,1,-1 
            XXTAB(JX+1) = XXTAB(JX) 
   20     CONTINUE 
          NXP    = NXP+1 
          XXTAB(1)  = X 
                                                                        
!mb     ELSEIF(X.GT.XXTAB(NXP)+EPSI) THEN                               
        ELSEIF(X/XXTAB(NXP).GT.1.+EPSI) THEN 
                                                                        
          NXP    = NXP+1 
          XXTAB(NXP) = X 
                                                                        
        ELSE 
                                                                        
          DO 30 I = 1,NXP 
!mb         IF(XXTAB(I).LE.X+EPSI) IX0 = I                              
            IF(XXTAB(I)/X.LE.1.+EPSI) IX0 = I 
   30     CONTINUE 
                                                                        
!mb       IF(ABS(XXTAB(IX0)-X).LE.EPSI) THEN                            
          IF(ABS(XXTAB(IX0)/X-1.).LE.EPSI) THEN 
            XXTAB(IX0) = X 
          ELSE 
            DO 40 JX = NXP,IX0+1,-1 
              XXTAB(JX+1) = XXTAB(JX) 
   40       CONTINUE 
            NXP = NXP+1 
            XXTAB(IX0+1) = X 
          ENDIF 
                                                                        
        ENDIF 
                                                                        
  100 END DO 
                                                                        
      IF(XXTAB(NXP).EQ.1.) THEN 
        NXX = NXP-1 
      ELSE 
        NXX = NXP 
        XXTAB(NXX+1) = 1. 
      ENDIF 
                                                                        
!---  Update IFAILC                                                     
      CALL GRSETC 
                                                                        
!---  Update NFMAP                                                      
      CALL QNSETT 
                                                                        
!---  Update heavy quark xgrid                                          
      CALL GXHDEF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r GRXINP ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input X  :'',E12.5)') X 
      WRITE(6,'( ''       NX :'',I5   )') NX 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' NX must be .ge. 1'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Maximum number of gridpoints exceeded '')') 
        WRITE(6,'(/'' # existing x  gridpoints ='',I5/                  &
     &             '' # points to be added     ='',I5/                  &
     &             '' maximum # points allowed ='',I5)')                &
     &                NXX, NX, MXX-1                                    
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Value of X outside allowed range (0,1]'')') 
      ENDIF 
                                                                        
      CALL QTRACE('GRXINP ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, GRXDEF.                                                     
                                                                        
!     ==========================                                        
      SUBROUTINE GRXDEF(NX,XMIN) 
!     ==========================                                        
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('GRXDEF ',0) 
                                                                        
      IF(NX.LE.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF(NX.GT.MXX-1) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      IF(XMIN.LE.0.OR.XMIN.GE.1.) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
                                                                        
!---  Invalidate weight tables (validated by call to QNFILW)            
      LWT1OK = .FALSE. 
      LWT2OK = .FALSE. 
      LWTFOK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!---  if this number changes, QCDNUM knows that the grid has changed    
      NGRVER = NGRVER + 1 
                                                                        
      XMAX = 1. 
      YMIN = SYFROMX(XMIN) 
      YMAX = SYFROMX(XMAX) 
      BW   = (YMAX-YMIN)/NX 
      DO I = 1,NX 
        YI = YMIN+(I-1)*BW 
        XXTAB(I) = SXFROMY(YI) 
      ENDDO 
      XXTAB(1)    = XMIN 
      XXTAB(NX+1) = 1. 
      NXX         = NX 
                                                                        
!---  Update IFAILC                                                     
      CALL GRSETC 
                                                                        
!---  Update NFMAP                                                      
      CALL QNSETT 
                                                                        
!---  Update heavy quark xgrid                                          
      CALL GXHDEF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r GRXDEF ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NX    :'',I5   )') NX 
      WRITE(6,'( ''       Xmin  :'',E12.5)') XMIN 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' NX must be .ge. 1'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' NX > max number of gridpoints'',                  &
     &             '' allowed:'',I5)') MXX-1                            
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Xmin outside allowed range (0,1]'')') 
      ENDIF 
                                                                        
      CALL QTRACE('GRXDEF ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, GRXLIM.                                                     
                                                                        
!     ==========================                                        
      SUBROUTINE GRXLIM(NX,XMIN) 
!     ==========================                                        
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DATA EPSI / 1.E-6 / 
                                                                        
      CALL QTRACE('GRXLIM ',0) 
                                                                        
      IF(NX.LE.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF(NX.GT.MXX-1) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
!---  Invalidate weight tables (validated by call to QNFILW)            
      LWT1OK = .FALSE. 
      LWT2OK = .FALSE. 
      LWTFOK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
      IF(XMIN.LE.0.OR.XMIN.GE.1.) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
                                                                        
!---  if this number changes, QCDNUM knows that the grid has changed    
      NGRVER = NGRVER + 1 
                                                                        
      IF(NXX.EQ.0) THEN 
        XXTAB(1) = 1. 
      ELSEIF(XXTAB(NXX).EQ.1.) THEN 
        NXX = NXX-1 
      ELSE 
        XXTAB(NXX+1) = 1. 
      ENDIF 
                                                                        
      NXP = NXX+1 
                                                                        
!mb   IF(XMIN.LT.XXTAB(1)-EPSI) THEN                                    
      IF(XMIN/XXTAB(1).LT.1.-EPSI) THEN 
        DO 20 IX = NXP,1,-1 
          XXTAB(IX+1) = XXTAB(IX) 
   20   CONTINUE 
        NXP   = NXP+1 
        XXTAB(1) = XMIN 
      ENDIF 
                                                                        
      IF(NX.GT.NXP-1) THEN 
   30   CONTINUE 
        GAPMAX = 0. 
        DO 35 IX = 1,NXP-1 
          GAP = SYFROMX(XXTAB(IX+1))-SYFROMX(XXTAB(IX)) 
          IF(GAP.GT.GAPMAX) THEN 
            GAPMAX = GAP 
            IX0    = IX 
          ENDIF 
   35   CONTINUE 
        DO 40 IX = NXP,IX0+1,-1 
          XXTAB(IX+1) = XXTAB(IX) 
   40   CONTINUE 
        NXP = NXP+1 
        XXTAB(IX0+1) = 0.5*(XXTAB(IX0)+XXTAB(IX0+2)) 
        IF(NXP-1.LT.NX) GOTO 30 
                                                                        
      ELSEIF(NX.LT.NXP-1) THEN 
   50   CONTINUE 
        GAPMIN = 999999. 
        DO 55 IX = 2,NXP-1 
          GAP = SYFROMX(XXTAB(IX+1))-SYFROMX(XXTAB(IX-1)) 
          IF(GAP.LE.GAPMIN) THEN 
            GAPMIN = GAP 
            IX0    = IX 
          ENDIF 
   55   CONTINUE 
        DO 60 IX = IX0,NXP-1 
          XXTAB(IX) = XXTAB(IX+1) 
   60   CONTINUE 
        XXTAB(NXP) = 0. 
        NXP = NXP-1 
        IF(NXP-1.GT.NX) GOTO 50 
      ENDIF 
                                                                        
      IF(XXTAB(NXP).EQ.1.) THEN 
        NXX = NXP-1 
      ELSE 
        NXX = NXP 
        XXTAB(NXX+1) = 1. 
      ENDIF 
                                                                        
!---  Update IFAILC                                                     
      CALL GRSETC 
                                                                        
!---  Update NFMAP                                                      
      CALL QNSETT 
                                                                        
!---  Update heavy quark xgrid                                          
      CALL GXHDEF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r GRXLIM ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NX    :'',I5   )') NX 
      WRITE(6,'( ''       Xmin  :'',E12.5)') XMIN 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' NX must be .ge. 1'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' NX > max number of gridpoints'',                  &
     &             '' allowed:'',I5)') MXX-1                            
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Xmin outside allowed range (0,1]'')') 
      ENDIF 
                                                                        
      CALL QTRACE('GRXLIM ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, GXHDEF.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE GXHDEF 
!     =================                                                 
                                                                        
!--   Create a purely logarithmic grid in x (XHTAB) for use             
!--   in the heavy quark structure function calculations.               
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      IF(NXX.EQ.0.OR.NXX.GE.MXX)           RETURN 
      IF(XXTAB(1).LE.0..OR.XXTAB(1).GE.1.) RETURN 
                                                                        
      XL1 = LOG(XXTAB(1)) 
      XL2 = 0. 
      BW  = (XL2-XL1)/NXX 
                                                                        
      DO IX = 1,NXX 
        XL = XL1 + (IX-1)*BW 
        XHTAB(IX) = EXP(XL) 
        IHTAB(IX) = ABS(IXFROMX(XHTAB(IX))) 
      ENDDO 
      XHTAB(NXX+1) = 1. 
      IHTAB(NXX+1) = NXX+1 
                                                                        
      RETURN 
      END                                           
                                                                        
                                                                        
!DECK  ID>, SYFROMX.                                                    
                                                                        
!     ====================================                              
      DOUBLE PRECISION FUNCTION SYFROMX(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      IF(X.LE.SCAX0) THEN 
        SYFROMX = LOG(X) 
      ELSE 
        SYFROMX = LOG(SCAX0) + (X-SCAX0)/SCAX0 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, SXFROMY.                                                    
                                                                        
!     ====================================                              
      DOUBLE PRECISION FUNCTION SXFROMY(Y) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      IF(Y.LE.LOG(SCAX0)) THEN 
        SXFROMY = EXP(Y) 
      ELSE 
        SXFROMY = (Y-LOG(SCAX0)+1.) * SCAX0 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRXOUT.                                                     
                                                                        
!     =========================                                         
      SUBROUTINE GRXOUT(XARRAY) 
!     =========================                                         
                                                                        
!---  Copy XXTAB to XARRAY which should have been dimensioned           
!---  to at least NXX+1 by the user.                                    
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      DIMENSION XARRAY(*) 
                                                                        
      CALL QTRACE('GRXOUT ',0) 
                                                                        
      DO 10 IX = 1,NXX+1 
        XARRAY(IX) = XXTAB(IX) 
   10 END DO 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, LOGXGR.                                                     
                                                                        
!     ===============================                                   
      LOGICAL FUNCTION LOGXGR(IDUMMY) 
!     ===============================                                   
                                                                        
!---  Figure out if xgrid is purely logarithmic                         
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      REAL    RAT1,RAT 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      LOGXGR = .FALSE. 
                                                                        
      IF(NXX.LE.0) RETURN 
                                                                        
      RAT1   = XXTAB(2)/XXTAB(1) 
      LOGXGR = .TRUE. 
      DO IX = 1,NXX 
        RAT = XXTAB(IX+1)/XXTAB(IX) 
        IF(RAT.NE.RAT1) LOGXGR = .FALSE. 
      ENDDO 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRQNUL.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE GRQNUL 
!     =================                                                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('GRQNUL ',0) 
                                                                        
!---  Invalidate weight tables (validated by call to QNFILW)            
      LALFOK = .FALSE. 
      LDQ2OK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!---  Set grid to zero                                                  
      CALL QNVNUL(Q2TAB,MQ2) 
      NQ2    = 0 
      NGRVER = 0 
                                                                        
!---  Update IFAILC                                                     
      CALL GRSETC 
                                                                        
!---  Update NFMAP                                                      
      CALL QNSETT 
                                                                        
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRQINP.                                                     
!                                                                       
!     ============================                                      
      SUBROUTINE GRQINP(QARRAY,NQ) 
!     ============================                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DIMENSION QARRAY(*) 
                                                                        
      DATA EPSI /1.E-6/ 
                                                                        
      CALL QTRACE('GRQINP ',0) 
                                                                        
      IF(NQ.LE.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF((NQ+NQ2).GT.MQ2-1) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
!---  Invalidate weight tables (validated by call to QNFILW)            
      LALFOK = .FALSE. 
      LDQ2OK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!---  if this number changes, QCDNUM knows that the grid has changed    
      NGRVER = NGRVER + 1 
                                                                        
      IF(NQ2.EQ.0) THEN 
        DO 10 IQ = 1,NQ 
          Q = QARRAY(IQ) 
          IF(Q.LE.0.) THEN 
            IERR = 3 
            GOTO 500 
          ENDIF 
          NQ2    = NQ2+1 
          Q2TAB(IQ) = Q 
   10   CONTINUE 
        RETURN 
      ENDIF 
                                                                        
      DO 100 IQ = 1,NQ 
                                                                        
        Q = QARRAY(IQ) 
                                                                        
        IF(Q.LE.0.) THEN 
          IERR = 3 
          GOTO 500 
        ENDIF 
                                                                        
!mb     IF(Q.LT.Q2TAB(1)-EPSI) THEN                                     
        IF(Q/Q2TAB(1).LT.1.-EPSI) THEN 
                                                                        
          DO 20 JQ = NQ2,1,-1 
            Q2TAB(JQ+1) = Q2TAB(JQ) 
   20     CONTINUE 
          NQ2    = NQ2+1 
          Q2TAB(1)  = Q 
                                                                        
!mb     ELSEIF(Q.GT.Q2TAB(NQ2)+EPSI) THEN                               
        ELSEIF(Q/Q2TAB(NQ2).GT.1.+EPSI) THEN 
                                                                        
          NQ2    = NQ2+1 
          Q2TAB(NQ2) = Q 
                                                                        
        ELSE 
                                                                        
          DO 30 I = 1,NQ2 
!mb         IF(Q2TAB(I).LE.Q+EPSI) IQ0 = I                              
            IF(Q2TAB(I)/Q.LE.1.+EPSI) IQ0 = I 
   30     CONTINUE 
                                                                        
!mb       IF(ABS(Q2TAB(IQ0)-Q).LE.EPSI) THEN                            
          IF(ABS(Q2TAB(IQ0)/Q-1.).LE.EPSI) THEN 
            Q2TAB(IQ0) = Q 
          ELSE 
            DO 40 JQ = NQ2,IQ0+1,-1 
              Q2TAB(JQ+1) = Q2TAB(JQ) 
   40       CONTINUE 
            NQ2 = NQ2+1 
            Q2TAB(IQ0+1) = Q 
          ENDIF 
                                                                        
        ENDIF 
                                                                        
  100 END DO 
                                                                        
!---  Update IFAILC                                                     
      CALL GRSETC 
                                                                        
!---  Update NFMAP                                                      
      CALL QNSETT 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r GRQINP ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input Q2 :'',E12.5)') Q 
      WRITE(6,'( ''       NQ :'',I5   )') NQ 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' NQ must be .ge. 1'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Maximum number of gridpoints exceeded '')') 
        WRITE(6,'(/'' # existing Q2 gridpoints ='',I5/                  &
     &             '' # points to be added     ='',I5/                  &
     &             '' maximum # points allowed ='',I5)')                &
     &                NQ2, NQ, MQ2-1                                    
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Value of Q2 outside allowed range > 0'')') 
      ENDIF 
                                                                        
      CALL QTRACE('GRQINP ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, GRQDEF.                                                     
                                                                        
!     ===============================                                   
      SUBROUTINE GRQDEF(NQ,QMIN,QMAX) 
!     ===============================                                   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('GRQDEF ',0) 
                                                                        
      IF(NQ.LE.1) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF(NQ.GT.MQ2-1) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      IF(QMIN.LE.0.OR.QMAX.LE.0.OR.QMIN.GE.QMAX) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
                                                                        
!---  Invalidate weight tables (validated by call to QNFILW)            
      LALFOK = .FALSE. 
      LDQ2OK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!---  if this number changes, QCDNUM knows that the grid has changed    
      NGRVER = NGRVER + 1 
                                                                        
      YMIN = SYFROMQ(QMIN) 
      YMAX = SYFROMQ(QMAX) 
      BW   = (YMAX-YMIN)/(NQ-1) 
      DO I = 1,NQ 
        YI = YMIN+(I-1)*BW 
        Q2TAB(I) = SQFROMY(YI) 
      ENDDO 
      Q2TAB(1)  = QMIN 
      Q2TAB(NQ) = QMAX 
      NQ2       = NQ 
                                                                        
!---  Update IFAILC                                                     
      CALL GRSETC 
                                                                        
!---  Update NFMAP                                                      
      CALL QNSETT 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r GRQDEF ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NQ    :'',I5   )') NQ 
      WRITE(6,'( ''       Q2min :'',E12.5)') QMIN 
      WRITE(6,'( ''       Q2max :'',E12.5)') QMAX 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' NQ must be .ge. 2'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' NQ > max number of gridpoints'',                  &
     &             '' allowed:'',I5)') MQ2-1                            
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Qmin and/or Qmax .le. 0 or Qmin .ge. Qmax'')') 
      ENDIF 
                                                                        
      CALL QTRACE('GRQDEF ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, GRQLIM.                                                     
                                                                        
!     ===============================                                   
      SUBROUTINE GRQLIM(NQ,QMIN,QMAX) 
!     ===============================                                   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DATA EPSI /1.E-6/ 
                                                                        
      CALL QTRACE('GRQLIM ',0) 
                                                                        
      IF(NQ.LE.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF(NQ.GT.MQ2-1) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
!---  Invalidate weight tables (validated by call to QNFILW)            
      LALFOK = .FALSE. 
      LDQ2OK = .FALSE. 
      LWFCOK = .FALSE. 
      LWLCOK = .FALSE. 
      LWFBOK = .FALSE. 
      LWLBOK = .FALSE. 
      LMARK  = .FALSE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!---  if this number changes, QCDNUM knows that the grid has changed    
      NGRVER = NGRVER + 1 
                                                                        
      IF(NQ2.EQ.0) THEN 
                                                                        
        IF(QMIN.LE.0..OR.QMAX.LE.0..OR.QMIN.GE.QMAX) THEN 
          IERR = 3 
          GOTO 500 
        ENDIF 
                                                                        
        CALL GRQDEF(NQ,QMI,QMA) 
                                                                        
      ELSE 
                                                                        
        IF(QMIN.LE.0..OR.QMAX.LE.0..OR.QMIN.GE.QMAX) THEN 
          IERR = 3 
          GOTO 500 
        ENDIF 
                                                                        
!mb     IF(QMIN.LT.Q2TAB(1)-EPSI) THEN                                  
        IF(QMIN/Q2TAB(1).LT.1.-EPSI) THEN 
          DO 20 IQ = NQ2,1,-1 
            Q2TAB(IQ+1) = Q2TAB(IQ) 
   20     CONTINUE 
          NQ2      = NQ2+1 
          Q2TAB(1) = QMIN 
        ENDIF 
!mb     IF(QMAX.GT.Q2TAB(NQ2)+EPSI) THEN                                
        IF(QMAX/Q2TAB(NQ2).GT.1.+EPSI) THEN 
          NQ2        = NQ2+1 
          Q2TAB(NQ2) = QMAX 
        ENDIF 
                                                                        
        IF(NQ.GT.NQ2) THEN 
   30     CONTINUE 
          GAPMAX = 0. 
          DO 35 IQ = 1,NQ2-1 
            GAP = SYFROMQ(Q2TAB(IQ+1))-SYFROMQ(Q2TAB(IQ)) 
            IF(GAP.GT.GAPMAX) THEN 
              GAPMAX = GAP 
              IQ0    = IQ 
            ENDIF 
   35     CONTINUE 
          DO 40 IQ = NQ2,IQ0+1,-1 
            Q2TAB(IQ+1) = Q2TAB(IQ) 
   40     CONTINUE 
          NQ2 = NQ2+1 
          Q2TAB(IQ0+1) = SQRT(Q2TAB(IQ0)*Q2TAB(IQ0+2)) 
          IF(NQ2.LT.NQ) GOTO 30 
                                                                        
        ELSEIF(NQ.LT.NQ2) THEN 
   50     CONTINUE 
          GAPMIN = 999999. 
          DO 55 IQ = 2,NQ2-1 
            GAP = SYFROMQ(Q2TAB(IQ+1))-SYFROMQ(Q2TAB(IQ-1)) 
            IF(GAP.LE.GAPMIN) THEN 
              GAPMIN = GAP 
              IQ0    = IQ 
            ENDIF 
   55     CONTINUE 
          DO 60 IQ = IQ0,NQ2-1 
            Q2TAB(IQ) = Q2TAB(IQ+1) 
   60     CONTINUE 
          Q2TAB(NQ2) = 0. 
          NQ2 = NQ2-1 
          IF(NQ2.GT.NQ) GOTO 50 
        ENDIF 
                                                                        
      ENDIF 
                                                                        
!---  Update IFAILC                                                     
      CALL GRSETC 
                                                                        
!---  Update NFMAP                                                      
      CALL QNSETT 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r GRQLIM ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NQ    :'',I5   )') NQ 
      WRITE(6,'( ''       Q2min :'',E12.5)') QMIN 
      WRITE(6,'( ''       Q2max :'',E12.5)') QMAX 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' NQ must be .ge. 1'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' NQ > max number of gridpoints'',                  &
     &             '' allowed:'',I5)') MQ2-1                            
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Qmin and/or Qmax .le. 0 or Qmin .ge. Qmax'')') 
      ENDIF 
                                                                        
      CALL QTRACE('GRQLIM ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, SYFROMQ.                                                    
                                                                        
!     ====================================                              
      DOUBLE PRECISION FUNCTION SYFROMQ(Q) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      IF(Q.LE.SCAQ0) THEN 
        SYFROMQ = LOG(Q) 
      ELSE 
        SYFROMQ = LOG(SCAQ0) + (Q-SCAQ0)/SCAQ0 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, SQFROMY.                                                    
                                                                        
!     ====================================                              
      DOUBLE PRECISION FUNCTION SQFROMY(Y) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      IF(Y.LE.LOG(SCAQ0)) THEN 
        SQFROMY = EXP(Y) 
      ELSE 
        SQFROMY = (Y-LOG(SCAQ0)+1.) * SCAQ0 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
                                                                        
!DECK  ID>, GRQOUT.                                                     
                                                                        
!     =========================                                         
      SUBROUTINE GRQOUT(QARRAY) 
!     =========================                                         
                                                                        
!---  Copy Q2TAB to QARRAY which should have been dimensioned           
!---  to at least NQ2 by the user.                                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      DIMENSION QARRAY(*) 
                                                                        
      CALL QTRACE('GRQOUT ',0) 
                                                                        
      DO 10 IQ = 1,NQ2 
        QARRAY(IQ) = Q2TAB(IQ) 
   10 END DO 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, IXFROMX.                                                    
                                                                        
!     ===========================                                       
      INTEGER FUNCTION IXFROMX(X) 
!     ===========================                                       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!---  Returns gridindex IX given a value for X.                         
!---  If X is outside the current gridboundary then IXFROMX = 0.        
!---  If X corresponds to gridindex IX  then IXFROMX = IX.              
!---  If X lies above IX and below IX+1 then IXFROMX = -IX.             
                                                                        
!---  NB: X and XXTAB are different only if |X-XXTAB| < epsi.           
!---  NB: If since the previous call the grid did not change            
!---      (i.e. NGRVER is the same) and if X did not change, then       
!---      IXFROMX just returns the result of the previous call.         
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      SAVE XLAST,IXLAST,NGLAST 
                                                                        
      DATA XLAST  / 0. / 
      DATA IXLAST / 0 / 
      DATA NGLAST / 0 / 
      DATA EPSI   /1.E-6/ 
                                                                        
!     CALL QTRACE('IXFROMX',0)                                          
                                                                        
      IF(X.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN 
        IXFROMX = IXLAST 
        RETURN 
      ENDIF 
                                                                        
      IX      = 0 
      IXLAST  = 0 
      NGLAST  = NGRVER 
      XLAST   = X 
      IXFROMX = 0 
                                                                        
      IF(X.GT.1..OR.NXX.LE.0)   RETURN 
      IF(X/XXTAB(1).LT.1.-EPSI) RETURN 
                                                                        
      DO 10 I = 1,NXX 
!mb     IF(XXTAB(I).LE.X+EPSI) IX = I                                   
        IF(XXTAB(I)/X.LE.1.+EPSI) IX = I 
   10 END DO 
                                                                        
!mb   IF(ABS(XXTAB(IX)-X).LE.EPSI) THEN                                 
      IF(ABS(XXTAB(IX)/X-1.).LE.EPSI) THEN 
        IXFROMX = IX 
        IXLAST  = IX 
      ELSE 
        IXFROMX = -IX 
        IXLAST  = -IX 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!------------------------------------------------                       
                                                                        
!-      REAL XR,X1,X2,XLAST                                             
!-                                                                      
!-+SEQ,QCNXQM.                                                          
!-+SEQ,QCGRID.                                                          
!-                                                                      
!-      SAVE XLAST,IXLAST,NGLAST                                        
!-                                                                      
!-      DATA XLAST  / 0. /                                              
!-      DATA IXLAST / 0 /                                               
!-      DATA NGLAST / 0 /                                               
!-                                                                      
!-*     CALL QTRACE('IXFROMX',0)                                        
!-                                                                      
!-      XR = X                                                          
!-      IF(XR.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN                       
!-        IXFROMX = IXLAST                                              
!-        RETURN                                                        
!-      ENDIF                                                           
!-                                                                      
!-      IX      = 0                                                     
!-      IXLAST  = 0                                                     
!-      NGLAST  = NGRVER                                                
!-      XLAST   = X                                                     
!-      IXFROMX = 0                                                     
!-                                                                      
!-      IF(XR.GT.1..OR.NXX.LE.0)   RETURN                               
!-      X1 = XXTAB(1)                                                   
!-      IF(XR.LT.X1)               RETURN                               
!-                                                                      
!-      DO IX = 1,NXX                                                   
!-        X2 = XXTAB(IX+1)                                              
!-        IF(X1.LE.XR.AND.XR.LT.X2) THEN                                
!-          IXFROMX = -IX                                               
!-          IF(X1.EQ.XR) IXFROMX = IX                                   
!-          IXLAST = IX                                                 
!-          RETURN                                                      
!-        ENDIF                                                         
!-        X1 = X2                                                       
!-      ENDDO                                                           
!-                                                                      
!-      RETURN                                                          
!-      END                                                             
                                                                        
!DECK  ID>, IHFROMH.                                                    
                                                                        
!     ===========================                                       
      INTEGER FUNCTION IHFROMH(X) 
!     ===========================                                       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!---  Returns gridindex IX of heavy quark grid given a value for X.     
!---  If X is outside the current gridboundary then IHFROMH = 0.        
!---  If X corresponds to gridindex IX  then IHFROMH = IX.              
!---  If X lies above IX and below IX+1 then IHFROMH = -IX.             
                                                                        
!---  NB: X and XHTAB are different only if |X-XHTAB| < epsi.           
!---  NB: If since the previous call the grid did not change            
!---      (i.e. NGRVER is the same) and if X did not change, then       
!---      IHFROMH just returns the result of the previous call.         
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      SAVE XLAST,IXLAST,NGLAST 
                                                                        
      DATA XLAST  / 0. / 
      DATA IXLAST / 0 / 
      DATA NGLAST / 0 / 
      DATA EPSI   /1.E-6/ 
                                                                        
!     CALL QTRACE('IHFROMH',0)                                          
                                                                        
      IF(X.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN 
        IHFROMH = IXLAST 
        RETURN 
      ENDIF 
                                                                        
      IX      = 0 
      IXLAST  = 0 
      NGLAST  = NGRVER 
      XLAST   = X 
      IHFROMH = 0 
                                                                        
      IF(X.GT.1..OR.NXX.LE.0)   RETURN 
      IF(X/XHTAB(1).LT.1.-EPSI) RETURN 
                                                                        
      DO 10 I = 1,NXX 
!mb     IF(XHTAB(I).LE.X+EPSI) IX = I                                   
        IF(XHTAB(I)/X.LE.1.+EPSI) IX = I 
   10 END DO 
                                                                        
!mb   IF(ABS(XHTAB(IX)-X).LE.EPSI) THEN                                 
      IF(ABS(XHTAB(IX)/X-1.).LE.EPSI) THEN 
        IHFROMH = IX 
        IXLAST  = IX 
      ELSE 
        IHFROMH = -IX 
        IXLAST  = -IX 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!------------------------------------------------                       
                                                                        
!-      REAL XR,X1,X2,XLAST                                             
!-                                                                      
!-+SEQ,QCNXQM.                                                          
!-+SEQ,QCGRID.                                                          
!-                                                                      
!-      SAVE XLAST,IXLAST,NGLAST                                        
!-                                                                      
!-      DATA XLAST  / 0. /                                              
!-      DATA IXLAST / 0 /                                               
!-      DATA NGLAST / 0 /                                               
!-                                                                      
!-*     CALL QTRACE('IXFROMX',0)                                        
!-                                                                      
!-      XR = X                                                          
!-      IF(XR.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN                       
!-        IXFROMX = IXLAST                                              
!-        RETURN                                                        
!-      ENDIF                                                           
!-                                                                      
!-      IX      = 0                                                     
!-      IXLAST  = 0                                                     
!-      NGLAST  = NGRVER                                                
!-      XLAST   = X                                                     
!-      IXFROMX = 0                                                     
!-                                                                      
!-      IF(XR.GT.1..OR.NXX.LE.0)   RETURN                               
!-      X1 = XHTAB(1)                                                   
!-      IF(XR.LT.X1)               RETURN                               
!-                                                                      
!-      DO IX = 1,NXX                                                   
!-        X2 = XHTAB(IX+1)                                              
!-        IF(X1.LE.XR.AND.XR.LT.X2) THEN                                
!-          IXFROMX = -IX                                               
!-          IF(X1.EQ.XR) IXFROMX = IX                                   
!-          IXLAST = IX                                                 
!-          RETURN                                                      
!-        ENDIF                                                         
!-        X1 = X2                                                       
!-      ENDDO                                                           
!-                                                                      
!-      RETURN                                                          
!-      END                                                             
                                                                        
!DECK  ID>, IXNEARX.                                                    
                                                                        
!     ===========================                                       
      INTEGER FUNCTION IXNEARX(X) 
!     ===========================                                       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!---  Returns closest gridindex IX given a value for X.                 
!---  If X is outside the current gridboundary then IXNEARX = 0.        
!---  If X corresponds to gridindex IX  then IXNEARX = IX.              
!---  If X lies above IX and below IX+1 then IXNEARX = -IX or -IX-1.    
                                                                        
!---  NB: X and XXTAB are different only if |X-XXTAB| < epsi.           
!---  NB: If since the previous call the grid did not change            
!---      (i.e. NGRVER is the same) and if X did not change, then       
!---      IXNEARX just returns the result of the previous call.         
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      SAVE XLAST,IXLAST,NGLAST 
                                                                        
      DATA XLAST  / 0. / 
      DATA IXLAST / 0 / 
      DATA NGLAST / 0 / 
      DATA EPSI   /1.E-6/ 
                                                                        
!     CALL QTRACE('IXNEARX',0)                                          
                                                                        
      IF(X.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN 
        IXNEARX = IXLAST 
        RETURN 
      ENDIF 
                                                                        
      IX      = 0 
      IXLAST  = 0 
      NGLAST  = NGRVER 
      XLAST   = X 
      IXNEARX = 0 
                                                                        
      IF(X.GT.1..OR.NXX.LE.0)   RETURN 
      IF(X/XXTAB(1).LT.1.-EPSI) RETURN 
                                                                        
      DO 10 I = 1,NXX 
!mb     IF(XXTAB(I).LE.X+EPSI) IX = I                                   
        IF(XXTAB(I)/X.LE.1.+EPSI) IX = I 
   10 END DO 
                                                                        
!mb   IF(ABS(XXTAB(IX)-X).LE.EPSI) THEN                                 
      IF(ABS(XXTAB(IX)/X-1.).LE.EPSI) THEN 
        IXNEARX = IX 
        IXLAST  = IX 
      ELSE 
        GAP     = SYFROMX(XXTAB(IX+1))-SYFROMX(XXTAB(IX)) 
        DEL     = SYFROMX(X)-SYFROMX(XXTAB(IX)) 
        IF(DEL/GAP.LE.0.5) THEN 
          IXNEARX = -IX 
        ELSE 
          IXNEARX = -MIN(IX+1,NXX) 
        ENDIF 
        IXLAST  = IXNEARX 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, IQFROMQ.                                                    
                                                                        
!     ===========================                                       
      INTEGER FUNCTION IQFROMQ(Q) 
!     ===========================                                       
                                                                        
!---  Returns gridindex IQ given a value for Q.                         
!---  If Q is outside the current gridboundary then IQFROMQ = 0.        
!---  If Q corresponds to gridindex IQ  then IQFROMQ = IQ.              
!---  If Q lies above IQ and below IQ+1 then IQFROMQ = -IQ.             
                                                                        
!---  NB: Q and Q2TAB are different only if |Q-Q2TAB| < epsi.           
!---  NB: If since the previous call the grid did not change            
!---      (i.e. NGRVER is the same) and if Q did not change, then       
!---      IQFROMQ just returns the result of the previous call.         
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      SAVE QLAST,IQLAST,NGLAST 
                                                                        
      DATA QLAST  / 0. / 
      DATA IQLAST / 0 / 
      DATA NGLAST / 0 / 
      DATA EPSI   /1.E-6/ 
                                                                        
!     CALL QTRACE('IQFROMQ',0)                                          
                                                                        
      IF(Q.EQ.QLAST.AND.NGRVER.EQ.NGLAST) THEN 
        IQFROMQ = IQLAST 
        RETURN 
      ENDIF 
                                                                        
      IQ      = 0 
      IQLAST  = 0 
      NGLAST  = NGRVER 
      QLAST   = Q 
      IQFROMQ = 0 
                                                                        
      IF(NQ2.EQ.0)                RETURN 
      IF(Q/Q2TAB(1).LT.1.-EPSI)   RETURN 
      IF(Q/Q2TAB(NQ2).GT.1.+EPSI) RETURN 
                                                                        
      DO 10 I = 1,NQ2 
!mb   IF(Q2TAB(I).LE.Q+EPSI) IQ = I                                     
      IF(Q2TAB(I)/Q.LE.1.+EPSI) IQ = I 
   10 END DO 
                                                                        
!mb   IF(ABS(Q2TAB(IQ)-Q).LE.EPSI) THEN                                 
      IF(ABS(Q2TAB(IQ)/Q-1.).LE.EPSI) THEN 
        IQFROMQ = IQ 
        IQLAST  = IQ 
      ELSE 
        IQFROMQ = -IQ 
        IQLAST  = -IQ 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!------------------------------------------------                       
                                                                        
!-      REAL QR,Q1,Q2,QLAST                                             
!-                                                                      
!-+SEQ,QCNXQM.                                                          
!-+SEQ,QCGRID.                                                          
!-                                                                      
!-      SAVE QLAST,IQLAST,NGLAST                                        
!-                                                                      
!-      DATA QLAST  / 0. /                                              
!-      DATA IQLAST / 0 /                                               
!-      DATA NGLAST / 0 /                                               
!-                                                                      
!-*     CALL QTRACE('IQFROMQ',0)                                        
!-                                                                      
!-      QR = Q                                                          
!-      IF(QR.EQ.QLAST.AND.NGRVER.EQ.NGLAST) THEN                       
!-        IQFROMQ = IQLAST                                              
!-        RETURN                                                        
!-      ENDIF                                                           
!-                                                                      
!-      IQ      = 0                                                     
!-      IQLAST  = 0                                                     
!-      NGLAST  = NGRVER                                                
!-      QLAST   = Q                                                     
!-      IQFROMQ = 0                                                     
!-                                                                      
!-                                                                      
!-      IF(NQ2.LE.0)   RETURN                                           
!-      Q1 = Q2TAB(1)                                                   
!-      IF(QR.LT.Q1)   RETURN                                           
!-      Q2 = Q2TAB(NQ2)                                                 
!-      IF(QR.GT.Q2)   RETURN                                           
!-      IF(QR.EQ.Q2)   THEN                                             
!-        IQFROMQ = NQ2                                                 
!-        IQLAST  = NQ2                                                 
!-        RETURN                                                        
!-      ENDIF                                                           
!-                                                                      
!-      DO IQ = 1,NQ2-1                                                 
!-        Q2 = Q2TAB(IQ+1)                                              
!-        IF(Q1.LE.QR.AND.QR.LT.Q2) THEN                                
!-          IQFROMQ = -IQ                                               
!-          IF(Q1.EQ.QR) IQFROMQ = IQ                                   
!-          IQLAST = IQ                                                 
!-          RETURN                                                      
!-        ENDIF                                                         
!-        Q1 = Q2                                                       
!-      ENDDO                                                           
!-                                                                      
!-      RETURN                                                          
!-      END                                                             
                                                                        
!DECK  ID>, IQNEARQ.                                                    
                                                                        
!     ===========================                                       
      INTEGER FUNCTION IQNEARQ(Q) 
!     ===========================                                       
                                                                        
!---  Returns closest gridindex IQ given a value for Q.                 
!---  If Q is outside the current gridboundary then IQNEARQ = 0.        
!---  If Q corresponds to gridindex IQ  then IQNEARQ = IQ.              
!---  If Q lies above IQ and below IQ+1 then IQNEARQ = -IQ or -IQ-1.    
                                                                        
!---  NB: Q and Q2TAB are different only if |Q-Q2TAB| < epsi.           
!---  NB: If since the previous call the grid did not change            
!---      (i.e. NGRVER is the same) and if Q did not change, then       
!---      IQNEARQ just returns the result of the previous call.         
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      SAVE QLAST,IQLAST,NGLAST 
                                                                        
      DATA QLAST  / 0. / 
      DATA IQLAST / 0 / 
      DATA NGLAST / 0 / 
      DATA EPSI   /1.E-6/ 
                                                                        
!     CALL QTRACE('IQNEARQ',0)                                          
                                                                        
      IF(Q.EQ.QLAST.AND.NGRVER.EQ.NGLAST) THEN 
        IQNEARQ = IQLAST 
        RETURN 
      ENDIF 
                                                                        
      IQ      = 0 
      IQLAST  = 0 
      NGLAST  = NGRVER 
      QLAST   = Q 
      IQNEARQ = 0 
                                                                        
      IF(NQ2.EQ.0)                RETURN 
      IF(Q/Q2TAB(1).LT.1.-EPSI)   RETURN 
      IF(Q/Q2TAB(NQ2).GT.1.+EPSI) RETURN 
                                                                        
      DO 10 I = 1,NQ2 
!mb   IF(Q2TAB(I).LE.Q+EPSI) IQ = I                                     
      IF(Q2TAB(I)/Q.LE.1.+EPSI) IQ = I 
   10 END DO 
                                                                        
!mb   IF(ABS(Q2TAB(IQ)-Q).LE.EPSI) THEN                                 
      IF(ABS(Q2TAB(IQ)/Q-1.).LE.EPSI) THEN 
        IQNEARQ = IQ 
        IQLAST  = IQ 
      ELSE 
        GAP     = LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        DEL     = LOG(Q/Q2TAB(IQ)) 
        IF(DEL/GAP.LE.0.5) THEN 
          IQNEARQ = -IQ 
        ELSE 
          IQNEARQ = -MIN(IQ+1,NQ2) 
        ENDIF 
        IQLAST  = IQNEARQ 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, XFROMIX.                                                    
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION XFROMIX(IX) 
!     =====================================                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!---  Returns x given the gridindex IX.                                 
!---  If IX is out of range [1,NXX] then XFROMIX = 0.                   
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
!     CALL QTRACE('XFROMIX',0)                                          
                                                                        
      IF(IX.LE.0) THEN 
        XFROMIX = 0. 
      ELSEIF(IX.GT.NXX) THEN 
        XFROMIX = 0. 
      ELSE 
        XFROMIX = XXTAB(IX) 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QFROMIQ.                                                    
!                                                                       
!     =====================================                             
      DOUBLE PRECISION FUNCTION QFROMIQ(IQ) 
!     =====================================                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!---  Returns Q2 given the gridindex IQ.                                
!---  If IQ is out of range [1,NQ2] then QFROMIQ = 0.                   
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
!     CALL QTRACE('QFROMIQ',0)                                          
                                                                        
      IF(IQ.LE.0) THEN 
        QFROMIQ = 0. 
      ELSEIF(IQ.GT.NQ2) THEN 
        QFROMIQ = 0. 
      ELSE 
        QFROMIQ = Q2TAB(IQ) 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRCUTS.                                                     
                                                                        
!     ====================================                              
      SUBROUTINE GRCUTS(XMI,QMI,QMA,ROOTS) 
!     ====================================                              
                                                                        
!---  GRCUTS:  user input of cuts.                                      
!---  Input :  Double precision XMI:  reject x  .lt. XMI                
!---                            QMI:  reject Q2 .lt. QMI                
!---                            QMA:  reject Q2 .gt. QMA                
!---                          ROOTS:  reject Q2 .gt. x * roots**2       
!---  Output:  XMICUT, QMICUT, QMACUT, RS2CUT in +seq,QCGRID.           
!---  NB    :  No cut is applied when XMI etc .le. 0 (XMICUT etc = -1.) 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CALL QTRACE('GRCUTS ',0) 
                                                                        
      IF(XMI.LE.0..OR.XMI.GE.1.) THEN 
        XMICUT = -1. 
      ELSE 
        XMICUT = XMI 
      ENDIF 
                                                                        
      IF(QMI.LE.0.) THEN 
        QMICUT = -1. 
      ELSE 
        QMICUT = QMI 
      ENDIF 
                                                                        
      IF(QMA.LE.0.) THEN 
        QMACUT = -0.5 
      ELSE 
        QMACUT = QMA 
      ENDIF 
                                                                        
      IF(ROOTS.LE.0.) THEN 
        RS2CUT = -1. 
      ELSE 
        RS2CUT = ROOTS*ROOTS 
      ENDIF 
                                                                        
      IF(QMICUT.GE.QMACUT.AND.QMACUT.GT.0.) THEN 
                                                                        
        WRITE(6,'(/'' ------------------------------------'')') 
        WRITE(6,'( '' QCDNUM error in s/r GRCUTS ---> STOP'')') 
        WRITE(6,'( '' ------------------------------------'')') 
        WRITE(6,'( '' Input Xmin  :'',E12.5)') XMI 
        WRITE(6,'( ''       Q2min :'',E12.5)') QMI 
        WRITE(6,'( ''       Q2max :'',E12.5)') QMA 
        WRITE(6,'( ''       rootS :'',E12.5)') ROOTS 
        WRITE(6,'(/'' Value of Q2min .ge. Q2max'')') 
                                                                        
        CALL QTRACE('GRCUTS ',1) 
                                                                        
        STOP 
                                                                        
      ENDIF 
                                                                        
      CALL GRSETC 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GRSETC.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE GRSETC 
!     =================                                                 
                                                                        
!---  Input:  XMIN, QMIN, QMAX, RS2CUT + grid-definitions, all this     
!---          as stored in QCGRID.                                      
!---  Output: integer array IFAILC(IX,IQ) (see below).                  
!---  Called  by GRCUTS (user input of cuts) and                        
!---          by all grid definition routines (update of IFAILC).       
                                                                        
!---  Fill the array IFAILC(IX,IQ) such that                            
!---  IFAILC = 0    : gridpoint passes all cuts                         
!---  IFAILC = ijkl : i = 0/1 no/yes fail roots cut                     
!---                  j = 0/1 no/yes fail qmax cut                      
!---                  k = 0/1 no/yes fail qmin cut                      
!---                  l = 0/1 no/yes fail xmin cut                      
                                                                        
!---  For any  x,Q2 passing the cuts the four surrounding gridpoints    
!---  will also be flagged as passing the cut. This then guarantees     
!---  that parton distributions are available on the surrounding        
!---  gridpoints for interpolation purposes.                            
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DO IX = 1,MXX 
        DO IQ = 1,MQ2 
          IFAILC(IX,IQ) = 11111 
        ENDDO 
      ENDDO 
      IF(NXX.LE.0)  RETURN 
      IF(NQ2.LE.0)  RETURN 
                                                                        
      DO IQ = 1,NQ2 
        DO IX = 1,NXX 
          IXP1          = MIN(IX+1,NXX) 
          IQP1          = MIN(IQ+1,NQ2) 
          IQM1          = MAX(IQ-1,1) 
          IFAILC(IX,IQ) = 0 
          IF(XXTAB(IXP1).LE.XMICUT.AND.XMICUT.GT.0.)                    &
     &       IFAILC(IX,IQ) = IFAILC(IX,IQ)+1                            
          IF(Q2TAB(IQP1).LE.QMICUT.AND.QMICUT.GT.0.)                    &
     &       IFAILC(IX,IQ) = IFAILC(IX,IQ)+10                           
          IF(Q2TAB(IQM1).GE.QMACUT.AND.QMACUT.GT.0.)                    &
     &       IFAILC(IX,IQ) = IFAILC(IX,IQ)+100                          
          IF(Q2TAB(IQM1).GE.XXTAB(IXP1)*RS2CUT.AND.RS2CUT.GT.0.)        &
     &       IFAILC(IX,IQ) = IFAILC(IX,IQ)+1000                         
          IF(Q2TAB(IQP1).LE.QMINAS.AND.QMINAS.GT.0.)                    &
     &       IFAILC(IX,IQ) = IFAILC(IX,IQ)+10000                        
                                                                        
        ENDDO 
      ENDDO 
                                                                        
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, IFAILXQ.                                                    
                                                                        
!     =============================                                     
      INTEGER FUNCTION IFAILXQ(X,Q) 
!     =============================                                     
                                                                        
!---  User interface to ICUTXQ                                          
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CALL QTRACE('IFAILXQ',0) 
                                                                        
      IFAILXQ = ICUTXQ(X,Q,0) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, ICUTXQ.                                                     
                                                                        
!     ==================================                                
      INTEGER FUNCTION ICUTXQ(X,Q,IPRIN) 
!     ==================================                                
                                                                        
!---  ICUTXQ = ijkl : i = 0/1  no/yes fail ROOTS cut                    
!---                  j = 0/1  no/yes fail QMAX cut                     
!---                  k = 0/1  no/yes fail QMIN cut                     
!---                  l = 0/1  no/yes fail XMIN cut                     
                                                                        
!---  Input integer IPRIN = 0/1 no/yes printout.                        
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CHARACTER*4 PASS(0:1) 
                                                                        
      DATA PASS /'pass','fail'/ 
                                                                        
!--   No x-grid available                                               
      IF(NXX.LE.0) THEN 
        ICUTXQ = 11111 
        RETURN 
      ENDIF 
!--   No Q2 grid available                                              
      IF(NQ2.LE.0) THEN 
        ICUTXQ = 11111 
        RETURN 
      ENDIF 
!--   x > 1                                                             
      IF(X.GT.1.0) THEN 
        ICUTXQ = 11111 
        RETURN 
      ENDIF 
                                                                        
      I1 = 0 
      I2 = 0 
      I3 = 0 
      I4 = 0 
      I5 = 0 
                                                                        
      IF((X.LT.XXTAB(1)).OR.(X.LT.XMICUT.AND.XMICUT.GT.0.))             &
     &    I1 = 1                                                        
      IF((Q.LT.Q2TAB(1)).OR.(Q.LT.QMICUT.AND.QMICUT.GT.0.))             &
     &    I2 = 1                                                        
      IF((Q.GT.Q2TAB(NQ2)).OR.(Q.GT.QMACUT.AND.QMACUT.GT.0.))           &
     &    I3 = 1                                                        
      IF(Q.GT.X*RS2CUT.AND.RS2CUT.GT.0.)                                &
     &    I4 = 1                                                        
      IF((Q.LT.Q2TAB(1)).OR.(Q.LT.QMINAS.AND.QMINAS.GT.0.))             &
     &    I5 = 1                                                        
                                                                        
      ICUTXQ = 10000*I5 + 1000*I4 + 100*I3 + 10*I2 + I1 
                                                                        
      IF(IPRIN.EQ.1) THEN 
                                                                        
        XMIPR = XMICUT 
        IF(XMICUT.LE.0.) XMIPR = XXTAB(1) 
        QMIPR = QMICUT 
        IF(QMICUT.LE.0.) QMIPR = Q2TAB(1) 
        QMAPR = QMACUT 
        IF(QMACUT.LE.0.) QMAPR = Q2TAB(NQ2) 
        WRITE(6,'('' '')') 
        WRITE(6,'('' x  ='',E12.5,'' xmin        = '',E12.5,            &
     &            '' pass/fail = '',A4)') X, XMIPR, PASS(I1)            
        WRITE(6,'('' Q2 ='',E12.5,'' Qmin        = '',E12.5,            &
     &            '' pass/fail = '',A4)') Q, QMIPR, PASS(I2)            
        WRITE(6,'('' Q2 ='',E12.5,'' Qmax        = '',E12.5,            &
     &            '' pass/fail = '',A4)') Q, QMAPR, PASS(I3)            
        WRITE(6,'('' s  ='',E12.5,'' Smax        = '',E12.5,            &
     &            '' pass/fail = '',A4)') Q/X, RS2CUT, PASS(I4)         
        WRITE(6,'('' Q2 ='',E12.5,'' Qmin_alphas = '',E12.5,            &
     &            '' pass/fail = '',A4)') Q, QMINAS, PASS(I5)           
        WRITE(6,'('' '')') 
                                                                        
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, IFAILIJ.                                                    
                                                                        
!     ===============================                                   
      INTEGER FUNCTION IFAILIJ(IX,IQ) 
!     ===============================                                   
                                                                        
!---  User interface to ICUTIJ                                          
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CALL QTRACE('IFAILIJ',0) 
                                                                        
      IFAILIJ = ICUTIJ(IX,IQ,0) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, ICUTIJ.                                                     
                                                                        
!     ====================================                              
      INTEGER FUNCTION ICUTIJ(JX,JQ,IPRIN) 
!     ====================================                              
                                                                        
!---  ICUTIJ = ijklm : i = 0/1  no/yes fail QMINA cut                   
!---                   j = 0/1  no/yes fail ROOTS cut                   
!---                   k = 0/1  no/yes fail QMAX  cut                   
!---                   l = 0/1  no/yes fail QMIN  cut                   
!---                   m = 0/1  no/yes fail XMIN  cut                   
                                                                        
!---  ijklm is taken from array IFAILC.                                 
!---  IFAILC is set by s/r GRSETC                                       
                                                                        
!---  Input integer IPRIN = 0/1 no/yes printout.                        
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CHARACTER*4 PASS(0:1) 
                                                                        
      DATA PASS /'pass','fail'/ 
                                                                        
      ICUTIJ = 11111 
                                                                        
!--   No x-grid available                                               
      IF(NXX.LE.0) RETURN 
!--   No Q2 grid available                                              
      IF(NQ2.LE.0) RETURN 
                                                                        
      IX     = ABS(JX) 
      IQ     = ABS(JQ) 
      IF(IX.GE.1.AND.IX.LE.NXX.AND.IQ.GE.1.AND.IQ.LE.NQ2)               &
     &  ICUTIJ = IFAILC(IX,IQ)                                          
                                                                        
      IF(IPRIN.EQ.1) THEN 
                                                                        
        IF(IX.GE.1.AND.IX.LE.NXX.AND.IQ.GE.1.AND.IQ.LE.NQ2) THEN 
          X  =  XXTAB(IX) 
          Q  =  Q2TAB(IQ) 
        ELSE 
          X  =  0. 
          Q  =  0. 
        ENDIF 
        I5 =  ICUTIJ/10000. 
        I4 = (ICUTIJ-10000*I5)/1000. 
        I3 = (ICUTIJ-10000*I5-1000*I4)/100. 
        I2 = (ICUTIJ-10000*I5-1000*I4-100*I3)/10. 
        I1 =  ICUTIJ-10000*I5-1000*I4-100*I3-10*I2 
                                                                        
        XMIPR = XMICUT 
        IF(XMICUT.LE.0.) XMIPR = XXTAB(1) 
        QMIPR = QMICUT 
        IF(QMICUT.LE.0.) QMIPR = Q2TAB(1) 
        QMAPR = QMACUT 
        IF(QMACUT.LE.0.) QMAPR = Q2TAB(NQ2) 
        WRITE(6,'('' '')') 
        WRITE(6,'('' IX = '',I5,'' x  ='',E12.5,'' xmin        = '',    &
     &  E12.5,'' pass/fail = '',A4)') IX, X, XMIPR, PASS(I1)            
        WRITE(6,'('' IQ = '',I5,'' Q2 ='',E12.5,'' Qmin        = '',    &
     &  E12.5,'' pass/fail = '',A4)') IQ, Q, QMIPR, PASS(I2)            
        WRITE(6,'('' IQ = '',I5,'' Q2 ='',E12.5,'' Qmax        = '',    &
     &  E12.5,'' pass/fail = '',A4)') IQ, Q, QMAPR, PASS(I3)            
        WRITE(6,'(''      '',5X,'' s  ='',E12.5,'' Smax        = '',    &
     &  E12.5,'' pass/fail = '',A4)') Q/X, RS2CUT, PASS(I4)             
        WRITE(6,'('' IQ = '',I5,'' Q2 ='',E12.5,'' Qmin_alphas = '',    &
     &  E12.5,'' pass/fail = '',A4)') IQ, Q, QMINAS, PASS(I5)           
        WRITE(6,'('' '')') 
                                                                        
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QTHRES.                                                     
                                                                        
!     ==========================                                        
      SUBROUTINE QTHRES(T34,T45) 
!     ==========================                                        
                                                                        
!---  QTHRES:  user input of flavour thresholds.                        
!---  Input :  Double precision T34:  Q2 .lt. T34 --> f = 3             
!---                                  Q2 .ge. T34 --> f = 4             
!---                            T45:  Q2 .lt. T45 --> f = 4             
!---                                  Q2 .ge. T45 --> f = 5             
!---  Output:  THRS34 and THRS45 in +seq,QCGRID.                        
!---  NB1   :  Default THRS34 = -huge, THRS45 = +huge --> f = 4.        
!---  NB2   :  The array NFMAP(Q2) = 3,4,5 is setup here through a      
!---           call to QNSETT and maintained further in the grid        
!---           defining routines.                                       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CALL QTRACE('QTHRES ',0) 
                                                                        
      IF(T34.GE.T45) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      THRS34 = T34 
      THRS45 = T45 
                                                                        
!---  Fill the flavour map                                              
      CALL QNSETT 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QTHRES ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input Threshold34 :'',E12.5)') T34 
      WRITE(6,'( ''       Threshold45 :'',E12.5)') T45 
      WRITE(6,'(/'' Value of T34 .ge. T45'')') 
                                                                        
      CALL QTRACE('QTHRES ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNSETT.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE QNSETT 
!     =================                                                 
                                                                        
!---  Input:  THRS34 and THRS45 + grid-definitions, all this            
!---          as stored in QCGRID.                                      
!---  Output: integer array NFMAP(IQ) = 3,4,5                           
!---  Called  by QTHRES (user input of thresholds) and                  
!---          by all grid definition routines (update of NFMAP).        
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      IF(NQ2.LE.0) THEN 
        DO IQ = 1,MQ2 
          NFMAP(IQ) = 4 
        ENDDO 
        RETURN 
      ENDIF 
                                                                        
      DO IQ = 1,NQ2 
                                NFMAP(IQ) = 4 
        IF(Q2TAB(IQ).LT.THRS34) NFMAP(IQ) = 3 
        IF(Q2TAB(IQ).GE.THRS45) NFMAP(IQ) = 5 
      ENDDO 
                                                                        
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNFMAP.                                                     
                                                                        
!     ==============================                                    
      SUBROUTINE QNFMAP(OPT,T34,T45) 
!     ==============================                                    
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT 
                                                                        
                                                                        
!---  Obsolete 17/07/96: use QTHRES instead                             
                                                                        
      CALL QTHRES(T34,T45) 
                                                                        
      RETURN 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNFSET.                                                     
                                                                        
!     ===========================                                       
      SUBROUTINE QNFSET(IX,IQ,NF) 
!     ===========================                                       
                                                                        
      WRITE(6,'(/'' QNFSET: this routine is not available'',            &
     &           '' ---> STOP'')')                                      
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNFNUL.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE QNFNUL 
!     =================                                                 
                                                                        
      WRITE(6,'(/'' QNFNUL: this routine is not available'',            &
     &           '' ---> STOP'')')                                      
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, NFLGET.                                                     
                                                                        
!     ===========================                                       
      INTEGER FUNCTION NFLGET(IQ) 
!     ===========================                                       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CALL QTRACE('NFLGET ',0) 
                                                                        
      NFLGET = 0 
      IF(IQ.GE.1.AND.IQ.LE.NQ2) THEN 
        NFLGET = NFMAP(IQ) 
      ELSE 
        WRITE(6,'(/'' ------------------------------------'')') 
        WRITE(6,'( '' QCDNUM error in s/r NFLGET ---> STOP'')') 
        WRITE(6,'( '' ------------------------------------'')') 
        WRITE(6,'( '' Input IQ :'',I10)') IQ 
        WRITE(6,'(/'' IQ outside grid boundary'')') 
        CALL QTRACE('NFLGET ',1) 
        STOP 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QPGRID.                                                     
                                                                        
!     ======================                                            
      SUBROUTINE QPGRID(LUN) 
!     ======================                                            
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
!--   Write x-Q2 evolution grid                                         
!--   -------------------------                                         
                                                                        
      WRITE(LUN,'(/'' QCDNUM x-Q2 evolution grid'')') 
      WRITE(LUN,'( '' --------------------------'')') 
                                                                        
      CALL GRGIVE(N_X,X_MI,X_MA,N_Q,Q_MI,Q_MA) 
                                                                        
      WRITE(LUN,'(/''   nx      xmin      xmax'',                       &
     &             ''   nq      qmin      qmax'')')                     
      WRITE(LUN,'(I5,2F10.7,I5,2F10.2)')                                &
     &            N_X,X_MI,X_MA,N_Q,Q_MI,Q_MA                           
      WRITE(LUN,'(/'' Xgrid (heavy quarks)'')') 
      WRITE(LUN,'(5(I4,E12.5))') (I,XHTAB(I),I=1,NXX) 
      WRITE(LUN,'(/'' Xgrid'')') 
      WRITE(LUN,'(5(I4,E12.5))') (I,XXTAB(I),I=1,NXX) 
      WRITE(LUN,'(/'' Qgrid'')') 
      WRITE(LUN,'(5(I4,E12.5))') (I,Q2TAB(I),I=1,NQ2) 
      IF(RS2CUT.GE.0.) THEN 
        RS2C = SQRT(RS2CUT) 
      ELSE 
        RS2C = RS2CUT 
      ENDIF 
      WRITE(LUN,'(/'' Thresholds and cuts''/                            &
     &             '' Q2  charm .......: '',E12.5/                      &
     &             '' Q2 bottom .......: '',E12.5/                      &
     &             '' Xmin  cut .......: '',E12.5/                      &
     &             '' Qmin  cut .......: '',E12.5/                      &
     &             '' Qmax  cut .......: '',E12.5/                      &
     &             '' Roots cut .......: '',E12.5/                      &
     &             '' Qmin  alpha_s ...: '',E12.5/)')                   &
     &             THRS34,THRS45,XMICUT,QMICUT,QMACUT,RS2C,QMINAS       
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QDELQ2.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE QDELQ2 
!     =================                                                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
!--   Pre-calculate log distance in Q2 for up and down evolution        
                                                                        
      DO 10 IQ = 2,NQ2 
        DELUP(IQ) = LOG(Q2TAB(IQ)/Q2TAB(IQ-1)) 
   10 END DO 
      DO 20 IQ = NQ2-1,1,-1 
        DELDN(IQ) = LOG(Q2TAB(IQ)/Q2TAB(IQ+1)) 
   20 END DO 
                                                                        
      LDQ2OK = .TRUE. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QFMARK.                                                     
                                                                        
!     ======================                                            
      SUBROUTINE QFMARK(X,Q) 
!     ======================                                            
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('QFMARK ',0) 
                                                                        
!--   Mark gridpoints for fast structure function calculation           
                                                                        
      IERR = 0 
      IF(X.LE.0. .OR. X.GT.1.) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
      IF(Q.LE.0.) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
!--   Mark the evolution grid                                           
                                                                        
      IX = IXFROMX(X) 
      IQ = IQFROMQ(Q) 
      IF(IX.EQ.0.OR.IQ.EQ.0) THEN 
        IERR = 3 
        GOTO 500 
      ELSEIF(IX.GT.0.AND.IQ.GT.0) THEN 
        MARKFF(IX,IQ)    = 1 
        MARKQQ(IQ)       = 1 
        LMARK            = .TRUE. 
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN 
        MARKFF(-IX,IQ)   = 1 
        MARKFF(-IX+1,IQ) = 1 
        MARKQQ(IQ)       = 1 
        LMARK            = .TRUE. 
      ELSEIF(IX.GT.0.AND.IQ.LT.0) THEN 
        MARKFF(IX,-IQ)   = 1 
        MARKFF(IX,-IQ+1) = 1 
        MARKQQ(-IQ)      = 1 
        MARKQQ(-IQ+1)    = 1 
        LMARK            = .TRUE. 
      ELSEIF(IX.LT.0.AND.IQ.LT.0) THEN 
        MARKFF(-IX,-IQ)     = 1 
        MARKFF(-IX+1,-IQ)   = 1 
        MARKFF(-IX,-IQ+1)   = 1 
        MARKFF(-IX+1,-IQ+1) = 1 
        MARKQQ(-IQ)         = 1 
        MARKQQ(-IQ+1)       = 1 
        LMARK               = .TRUE. 
      ENDIF 
                                                                        
!--   Mark the heavy quark grid                                         
                                                                        
      IX = IHFROMH(X) 
      IQ = IQFROMQ(Q) 
      IF(IX.EQ.0.OR.IQ.EQ.0) THEN 
        IERR = 3 
        GOTO 500 
      ELSEIF(IX.GT.0.AND.IQ.GT.0) THEN 
        MARKFH(IX,IQ)    = 1 
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN 
        MARKFH(-IX,IQ)   = 1 
        MARKFH(-IX+1,IQ) = 1 
      ELSEIF(IX.GT.0.AND.IQ.LT.0) THEN 
        MARKFH(IX,-IQ)   = 1 
        MARKFH(IX,-IQ+1) = 1 
      ELSEIF(IX.LT.0.AND.IQ.LT.0) THEN 
        MARKFH(-IX,-IQ)     = 1 
        MARKFH(-IX+1,-IQ)   = 1 
        MARKFH(-IX,-IQ+1)   = 1 
        MARKFH(-IX+1,-IQ+1) = 1 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QFMARK ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input x  :'',E12.5)') X 
      WRITE(6,'( '' Input Q2 :'',E12.5)') Q 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' Value of x outside allowed range [0,1]'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Value of Q2 outside allowed range > 0'')') 
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Value of x and/or Q2 outside grid'')') 
        IDUM = ICUTXQ(X,Q,1) 
      ENDIF 
                                                                        
      CALL QTRACE('QFMARK ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QFMNUL.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE QFMNUL 
!     =================                                                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('QFMNUL ',0) 
                                                                        
!--   Clear gridpoints for fast structure function calculation          
                                                                        
      CALL QNINUL(MARKFF,MXX*MQ2) 
      CALL QNINUL(MARKQQ,MQ2) 
      CALL QNINUL(IDFAST,7*30) 
      NDFAST = 30 
      LMARK  = .FALSE. 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, STFCLR.                                                     
                                                                        
!     =================                                                 
      SUBROUTINE STFCLR 
!     =================                                                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
!--   Clear memory allocation for STFAST                                
                                                                        
      CALL QTRACE('STFCLR ',0) 
                                                                        
      CALL QNINUL(IDFAST,7*30) 
      NDFAST = 30 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNFILW.                                                     
                                                                        
!     ================================                                  
      SUBROUTINE QNFILW(IQLIST,NQLIST) 
!     ================================                                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      DIMENSION IQLIST(*) 
                                                                        
      IF(LTIME) CALL TIMEX_LHA(T_START(2)) 
                                                                        
      CALL QTRACE('QNFILW ',0) 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!--   Setup the adresses                                                
      DO IX0 = 1,MXX 
        DO IX = IX0,MXX 
          IWADR(IX,IX0) = IWTAD(IX,IX0) 
        ENDDO 
      ENDDO 
                                                                        
!--   Now calculate weights                                             
      IF(LW1ANA) THEN 
        DO 30 NF = 3,5 
        CALL FILLO1(NF) 
   30   CONTINUE 
        LW1NUM = .FALSE. 
        LWT1OK = .TRUE. 
        WRITE(6,'(/'' QNFILW: Calculate LO weights analytically'')') 
      ENDIF 
                                                                        
      I1 = 0 
      I2 = 0 
      I3 = 0 
      IF(LW1NUM) THEN 
        I1     = 1 
        LWT1OK = .TRUE. 
        WRITE(6,'(/'' QNFILW: Calculate LO weights numerically'')') 
      ENDIF 
      IF(LW2NUM) THEN 
        I2     = 1 
        LWT2OK = .TRUE. 
        WRITE(6,'(/'' QNFILW: Calculate NLO weights'')') 
      ENDIF 
      IF(LW2STF) THEN 
        I3     = 1 
        LWTFOK = .TRUE. 
        WRITE(6,'(/'' QNFILW: Calculate F2 weights'')') 
      ENDIF 
                                                                        
      DO 40 NF = 3,5 
      CALL FILLWF(I1,I2,I3,NF) 
   40 END DO 
                                                                        
      IF(LWF2C.OR.LWF2B.OR.LWFLC.OR.LWFLB) THEN 
                                                                        
!---    Check charm, bottom mass                                        
        IF(.NOT.(0..LT.CBMSTF(4) .AND. CBMSTF(4).EQ.CBMSTF(5) .AND.     &
     &    CBMSTF(4).LT.CBMSTF(6) .AND. CBMSTF(6).EQ.CBMSTF(7))) THEN    
          IERR = 2 
          GOTO 500 
        ENDIF 
                                                                        
        IF(LWF2C) THEN 
          LWFCOK = .TRUE. 
          CALL FIL_F2H(4) 
          WRITE(6,'(/'' QNFILW: Calculate F2c weights'')') 
        ENDIF 
        IF(LWF2B) THEN 
          LWFBOK = .TRUE. 
          CALL FIL_F2H(6) 
          WRITE(6,'(/'' QNFILW: Calculate F2b weights'')') 
        ENDIF 
        IF(LWFLC) THEN 
          LWLCOK = .TRUE. 
          CALL FIL_FLH(5) 
          WRITE(6,'(/'' QNFILW: Calculate FLc weights'')') 
        ENDIF 
        IF(LWFLB) THEN 
          LWLBOK = .TRUE. 
          CALL FIL_FLH(7) 
          WRITE(6,'(/'' QNFILW: Calculate FLb weights'')') 
        ENDIF 
                                                                        
      ENDIF 
                                                                        
      WRITE(6,'(/)') 
                                                                        
      IF(LTIME) THEN 
        CALL TIMEX_LHA(T_END(2)) 
        T_SPENT(2) = T_SPENT(2)+T_END(2)-T_START(2) 
        N_CALLS(2) = N_CALLS(2)+1 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNFILW ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid available'')') 
      ENDIF 
      IF(IERR.EQ.2) THEN 
        WRITE(6,'( '' Cmass (F2c,FLc) ='',2E12.5)') CBMSTF(4),CBMSTF(5) 
        WRITE(6,'( '' Bmass (F2b,FLb) ='',2E12.5)') CBMSTF(6),CBMSTF(7) 
        WRITE(6,'(/'' Masses not in ascending order or not equal'',     &
     &             '' for F2 and FL'')')                                
      ENDIF 
                                                                        
      CALL QTRACE('QNFILW ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNGETW.                                                     
                                                                        
!     ===============================================                   
      DOUBLE PRECISION FUNCTION QNGETW(OPT,IX0,IX,IQ) 
!     ===============================================                   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      REAL                                                              &
     &WH_C0KG,WH_C1KG,WH_C1BKG,                                         &
     &WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ                                 
                                                                        
      COMMON/QCHWGT/                                                    &
     &WH_C0KG(0:MXX,MQ2,4:7),                                           &
     &WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),                   &
     &WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),                   &
     &WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)                    
                                                                        
                                                                        
      CHARACTER*(*) OPT 
      CHARACTER*8   OPT8 
                                                                        
      CALL QTRACE('QNGETW ',0) 
                                                                        
      IERR = 0 
      IF(IX0.LE.0.OR.IX0.GT.MXX-1) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
      IF(IX.LE.0.OR.IX.GT.MXX-1) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
      IF(IQ.LE.0.OR.IQ.GT.MQ2-1) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      NF  = NFMAP(IQ) 
      IF(NF.LT.3.OR.NF.GT.5) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      IF(IX.LT.IX0) THEN 
        QNGETW = 0. 
        RETURN 
      ENDIF 
                                                                        
      LEN = MIN(LENOCC_LHA(OPT),8) 
      OPT8(1:LEN) = OPT(1:LEN) 
      CALL CLTOU_LHA(OPT8) 
                                                                        
      IF(OPT8(1:6).EQ.'WGTFF1') THEN 
        QNGETW = WGTFF1(IWTAD(IX,IX0)) 
      ELSEIF(OPT8(1:6).EQ.'WGTFG1') THEN 
        QNGETW = WGTFG1(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTGF1') THEN 
        QNGETW = WGTGF1(IWTAD(IX,IX0)) 
      ELSEIF(OPT8(1:6).EQ.'WGTGG1') THEN 
        QNGETW = WGTGG1(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTPP2') THEN 
        QNGETW = WGTPP2(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTPM2') THEN 
        QNGETW = WGTPM2(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTNS2') THEN 
        QNGETW = WGTNS2(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTFF2') THEN 
        QNGETW = WGTFF2(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTFG2') THEN 
        QNGETW = WGTFG2(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTGF2') THEN 
        QNGETW = WGTGF2(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTGG2') THEN 
        QNGETW = WGTGG2(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTC2Q') THEN 
        QNGETW = WGTC2Q(IWTAD(IX,IX0)) 
      ELSEIF(OPT8(1:6).EQ.'WGTC2G') THEN 
        QNGETW = WGTC2G(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTCLQ') THEN 
        QNGETW = WGTCLQ(IWTAD(IX,IX0)) 
      ELSEIF(OPT8(1:6).EQ.'WGTCLG') THEN 
        QNGETW = WGTCLG(IWTAD(IX,IX0),NF) 
      ELSEIF(OPT8(1:6).EQ.'WGTC3Q') THEN 
        QNGETW = WGTC3Q(IWTAD(IX,IX0)) 
      ELSEIF(OPT8(1:7).EQ.'WH_C02G') THEN 
        QNGETW = WH_C0KG(IX-IX0,IQ,4) 
      ELSEIF(OPT8(1:7).EQ.'WH_C12G') THEN 
        QNGETW = WH_C1KG(IX-IX0,IQ,4) 
      ELSEIF(OPT8(1:8).EQ.'WH_C1B2G') THEN 
        QNGETW = WH_C1BKG(IX-IX0,IQ,4) 
      ELSEIF(OPT8(1:7).EQ.'WH_C12Q') THEN 
        QNGETW = WH_C1KQ(IX-IX0,IQ,4) 
      ELSEIF(OPT8(1:8).EQ.'WH_C1B2Q') THEN 
        QNGETW = WH_C1BKQ(IX-IX0,IQ,4) 
      ELSEIF(OPT8(1:7).EQ.'WH_D12Q') THEN 
        QNGETW = WH_D1KQ(IX-IX0,IQ,4) 
      ELSEIF(OPT8(1:8).EQ.'WH_D1B2Q') THEN 
        QNGETW = WH_D1BKQ(IX-IX0,IQ,4) 
      ELSEIF(OPT8(1:7).EQ.'WH_C0LG') THEN 
        QNGETW = WH_C0KG(IX-IX0,IQ,5) 
      ELSEIF(OPT8(1:7).EQ.'WH_C1LG') THEN 
        QNGETW = WH_C1KG(IX-IX0,IQ,5) 
      ELSEIF(OPT8(1:8).EQ.'WH_C1BLG') THEN 
        QNGETW = WH_C1BKG(IX-IX0,IQ,5) 
      ELSEIF(OPT8(1:7).EQ.'WH_C1LQ') THEN 
        QNGETW = WH_C1KQ(IX-IX0,IQ,5) 
      ELSEIF(OPT8(1:8).EQ.'WH_C1BLQ') THEN 
        QNGETW = WH_C1BKQ(IX-IX0,IQ,5) 
      ELSEIF(OPT8(1:7).EQ.'WH_D1LQ') THEN 
        QNGETW = WH_D1KQ(IX-IX0,IQ,5) 
      ELSEIF(OPT8(1:8).EQ.'WH_D1BLQ') THEN 
        QNGETW = WH_D1BKQ(IX-IX0,IQ,5) 
      ELSE 
        IERR = 3 
        GOTO 500 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNGETW ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input OPT      :'',A)') OPT 
      WRITE(6,'( ''       IX0      :'',I10)') IX0 
      WRITE(6,'( ''       IX       :'',I10)') IX 
      WRITE(6,'( ''       IQ       :'',I10)') IQ 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' IX0, IX and/or IQ outside allowed range'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' NF(IX,IQ) ='',I3,'' outside allowed range'')') NF 
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Unknown option'')') 
      ENDIF 
                                                                        
      CALL QTRACE('QNGETW ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QSTRIP.                                                     
                                                                        
!     =================================                                 
      SUBROUTINE QSTRIP(NAMEIN,NAMEOUT) 
!     =================================                                 
                                                                        
!---  Truncate NAMEIN to 5 characters and convert to upper case         
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) NAMEIN 
      CHARACTER*5   NAMEOUT 
                                                                        
      LEN            = MIN(LENOCC_LHA(NAMEIN),5) 
      NAMEOUT        = '     ' 
      NAMEOUT(1:LEN) = NAMEIN(1:LEN) 
      CALL CLTOU_LHA(NAMEOUT) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, CHKNAM.                                                     
                                                                        
!     ====================================                              
      SUBROUTINE CHKNAM(ID,NAME,SNAME,NAM) 
!     ====================================                              
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
                                                                        
      CHARACTER*(*) NAME, SNAME 
      CHARACTER*5 NAM 
                                                                        
      LEN = MIN(LENOCC_LHA(NAME),5) 
      NAM = '     ' 
      NAM(1:LEN) = NAME(1:LEN) 
      CALL CLTOU_LHA(NAM) 
                                                                        
      IF(NAM.EQ.'     ') THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF(NAM.EQ.'FREE ') THEN 
        PNAM(ID)      =  NAM 
        LNFP(ID,3)    = .FALSE. 
        LNFP(ID,4)    = .FALSE. 
        LNFP(ID,5)    = .FALSE. 
        IF(ID.LE.10) THEN 
          DO JD = 0,30 
            PWGT(ID,JD,3) = 0. 
            PWGT(ID,JD,4) = 0. 
            PWGT(ID,JD,5) = 0. 
          ENDDO 
        ELSE 
          DO JD = 0,10 
            PWGT(JD,ID,3) = 0. 
            PWGT(JD,ID,4) = 0. 
            PWGT(JD,ID,5) = 0. 
          ENDDO 
        ENDIF 
        RETURN 
      ENDIF 
                                                                        
      IF(PNAM(ID).NE.'FREE '.AND.PNAM(ID).NE.NAM) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      DO JD = 0,30 
         IF(JD.EQ.ID) EXIT
         IF(PNAM(JD).EQ.NAM) THEN 
            IERR = 3 
            GOTO 500 
         ENDIF 
      END DO 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r '',A,'' ---> STOP'')')          &
     &              SNAME                                               
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input ID   :'',I10)') ID 
      WRITE(6,'( '' Input NAME :'',A)') NAM 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' Blank name not allowed'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' ID already booked'')') 
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' NAME already used'')') 
      ENDIF 
                                                                        
      CALL QTRACE('CHKNAM ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNBOOK.                                                     
                                                                        
!     ==========================                                        
      SUBROUTINE QNBOOK(ID,NAME) 
!     ==========================                                        
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
                                                                        
      CHARACTER*(*) NAME 
      CHARACTER*5    NAM 
                                                                        
      CALL QTRACE('QNBOOK ',0) 
                                                                        
      CALL CHKNAM(ID,NAME,'QNBOOK',NAM) 
                                                                        
      PNAM(ID)      =  NAM 
      LNFP(ID,3)    = .TRUE. 
      LNFP(ID,4)    = .TRUE. 
      LNFP(ID,5)    = .TRUE. 
      PWGT(ID,ID,3) = 1. 
      PWGT(ID,ID,4) = 1. 
      PWGT(ID,ID,5) = 1. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNLINC.                                                     
                                                                        
!     ===================================                               
      SUBROUTINE QNLINC(ID,NAME,NF,WEITS) 
!     ===================================                               
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
                                                                        
      CHARACTER*(*) NAME 
      CHARACTER*5   NAM 
      DIMENSION     WEITS(10) 
                                                                        
      CALL QTRACE('QNLINC ',0) 
                                                                        
      IF(ID.LE.10.OR.ID.GE.31) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF(NF.LT.3 .OR.NF.GT.5 ) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      CALL CHKNAM(ID,NAME,'QNLINC',NAM) 
                                                                        
      PNAM(ID)    = NAM 
      LNFP(ID,NF) = .TRUE. 
      DO 20 I=1,10 
        PWGT(I,ID,NF) = WEITS(I) 
   20 END DO 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNLINC ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input ID        :'',I0)') ID 
      WRITE(6,'( ''       NAME      :'',A)') NAME 
      WRITE(6,'( ''       NF        :'',I0)') NF 
      WRITE(6,'( ''       FACTORS(1):'',E12.5)') WEITS(1) 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' ID outside allowed range [11,30]'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' NF outside allowed range [3,5]'')') 
      ENDIF 
                                                                        
      CALL QTRACE('QNLINC ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNGIVE.                                                     
                                                                        
!     ===================================                               
      SUBROUTINE QNGIVE(ID,NF,NAME,WEITS) 
!     ===================================                               
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
                                                                        
      CHARACTER*5 NAME 
      DIMENSION   WEITS(10) 
                                                                        
      CALL QTRACE('QNGIVE ',1) 
                                                                        
      IF(ID.LT.0.OR.ID.GT.30.OR.NF.LT.3.OR.NF.GT.5) THEN 
                                                                        
        NAME = 'NULL ' 
        DO 10 I=1,10 
          WEITS(I) = 0. 
   10   CONTINUE 
                                                                        
      ELSE 
                                                                        
        NAME = PNAM(ID) 
        DO 15 I=1,10 
          WEITS(I) = PWGT(I,ID,NF) 
   15   CONTINUE 
                                                                        
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, IDCHEK.                                                     
                                                                        
!     =============================                                     
      INTEGER FUNCTION IPDFID(UNAM) 
!     =============================                                     
                                                                        
!---  IPDFID = identifier of memory resident quark distn                
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAM 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
                                                                        
      CALL QTRACE('IPDFID ',0) 
                                                                        
      CALL QSTRIP(UNAM,NAM) 
                                                                        
      IF(NAM.EQ.'     '.OR.NAM.EQ.'FREE ') THEN 
        GOTO 500 
      ENDIF 
                                                                        
      ID = -1 
      DO I = 1,10 
        IF(NAM.EQ.PNAM(I)) ID = I 
      ENDDO 
                                                                        
      IPDFID = ID 
                                                                        
      IF(ID.EQ.-1) THEN 
        GOTO 500 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r IPDFID ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NAME      :'',A)') UNAM 
      WRITE(6,'(/'' NAME not booked at all or NAME does not refer''/    &
     &           '' to a memory resident quark distribution'')')        
      IF(NAM(1:1).EQ.' ')                                               &
     &WRITE(6,'(/'' WARNING: NAME has one or more leading blanks'')')   
                                                                        
      CALL QTRACE('IPDFID ',1) 
                                                                        
      STOP 
      END                                           
                                                                        
                                                                        
!DECK  ID>, IDCHEK.                                                     
                                                                        
!     ============================================                      
      INTEGER FUNCTION IDCHEK(NAM,NF,SRNAME,ISTOP) 
!     ============================================                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*6   SRNAME 
      CHARACTER*5   NAMLAST,NAM 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
                                                                        
      SAVE IDLAST,NAMLAST 
                                                                        
      DATA IDLAST      /   0    / 
      DATA NAMLAST     / '    ' / 
                                                                        
      IDCHEK = -1 
                                                                        
      IF(NAM.EQ.'     '.OR.NAM.EQ.'FREE '.OR.                           &
     &   NF.LT.3.OR.NF.GT.5)                       THEN                 
        IF(ISTOP.EQ.1) THEN 
          IERR = 1 
          GOTO 500 
        ENDIF 
        RETURN 
      ENDIF 
                                                                        
      ID = -1 
      IF(NAM.EQ.NAMLAST.AND.LNFP(IDLAST,NF)) THEN 
        ID     = IDLAST 
      ELSE 
        DO 10 I = 0,30 
          IF(NAM.EQ.PNAM(I).AND.LNFP(I,NF)) ID = I 
   10   CONTINUE 
        IDLAST  = ID 
        NAMLAST = NAM 
      ENDIF 
                                                                        
      IDCHEK = ID 
                                                                        
      IF(ID.EQ.-1.AND.ISTOP.EQ.1) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r '',A,'' ---> STOP'')')          &
     &              SRNAME                                              
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NAME      :'',A)') NAM 
      WRITE(6,'( ''       NF        :'',I10)') NF 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' Input name not allowed and/or NF outside'',       &
     &             '' the allowed range [3,5]'')')                      
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' NAME not booked at all or, if NAME refers to''/   &
     &             '' a linear combination, it might not have been''/   &
     &             '' booked for NF flavours'')')                       
        IF(NAM(1:1).EQ.' ')                                             &
     &  WRITE(6,'(/'' WARNING: NAME has one or more leading blanks'')') 
      ENDIF 
                                                                        
      CALL QTRACE('IDCHEK ',1) 
                                                                        
      STOP 
      END                                           
                                                                        
!DECK  ID>, QNLIST.                                                     
                                                                        
!     ======================                                            
      SUBROUTINE QNLIST(LUN) 
!     ======================                                            
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*5 NAM 
      CHARACTER*3 II 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
                                                                        
      WRITE(LUN,'(////)') 
      WRITE(LUN,'(1X,''+'',13(''-''),''+'',60(''-''),''+'')') 
      WRITE(LUN,'('' |             | W_'',I2,                           &
     &           9(''  W_'',I2),'' |'')') (J, J=1,10)                   
      WRITE(LUN,'('' | ID NAME  nf | '',A4,                             &
     &           9(2X,A4),'' |'')') (PNAM(J),J=1,10)                    
      WRITE(LUN,'(1X,''+'',13(''-''),''+'',60(''-''),''+'')') 
      DO I = 0,10 
         IF(IDCHEK(PNAM(I),3,'      ',0).EQ.-1) EXIT
         WRITE(LUN,'('' |'',I3,1X,A5,''    |'',F5.2,                     &
     &9(F6.2),'' |'')') I, PNAM(I),(PWGT(J,I,3),J=1,10)    
      END DO 
      WRITE(LUN,'(1X,''+'',13(''-''),''+'',60(''-''),''+'')') 
      DO 20 I = 11,30 
        NAM = PNAM(I) 
        WRITE(II,'(I3)') I 
        IF(IDCHEK(PNAM(I),3,'      ',0).NE.-1) THEN 
        WRITE(LUN,'('' |'',A3,1X,A5,''  3 |'',F5.2,                     &
     &             9(F6.2),'' |'')') II, NAM,(PWGT(J,I,3),J=1,10)       
        NAM = '     ' 
        II  = '   ' 
        ENDIF 
        IF(IDCHEK(PNAM(I),4,'      ',0).NE.-1) THEN 
        WRITE(LUN,'('' |'',A3,1X,A5,''  4 |'',F5.2,                     &
     &             9(F6.2),'' |'')') II, NAM,(PWGT(J,I,4),J=1,10)       
        NAM = '     ' 
        II  = '   ' 
        ENDIF 
        IF(IDCHEK(PNAM(I),5,'      ',0).NE.-1) THEN 
        WRITE(LUN,'('' |'',A3,1X,A5,''  5 |'',F5.2,                     &
     &             9(F6.2),'' |'')') II, NAM, (PWGT(J,I,5),J=1,10)      
        NAM = '     ' 
        II  = '   ' 
        ENDIF 
   20 END DO 
      WRITE(LUN,'(1X,''+'',13(''-''),''+'',60(''-''),''+'')') 
      WRITE(LUN,'(////)') 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNPSET.                                                     
!     =================================                                 
      SUBROUTINE QNPSET(UNAM,IX,IQ,VAL) 
!     =================================                                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAME 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('QNPSET ',0) 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
                                                                        
      ID = IDCHEK(NAME,4,'QNPSET',1) 
                                                                        
      IF(ID.EQ.-1) RETURN 
                                                                        
      IF(IX.LT.1.OR.IX.GT.NXX) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      IF(IQ.LT.1.OR.IQ.GT.NQ2) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      IF(ID.LT.0.OR.ID.GT.10) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
                                                                        
!--   If a different input value, invalidate evolution for this         
!--   and all lower x-grid points                                       
      IF(VAL.NE.PDFQCD(IX,IQ,ID)) THEN 
        DO JX = 1,IX 
          LEVDONE(JX,MAX(ID,1)) = .FALSE. 
        ENDDO 
      ENDIF 
                                                                        
      PDFQCD(IX,IQ,ID) = VAL 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNPSET ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NAME :'',A)') UNAM 
      WRITE(6,'( ''         IX :'',I10)') IX 
      WRITE(6,'( ''         IQ :'',I10)') IQ 
      WRITE(6,'( ''      Value :'',E12.5)') VAL 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid available'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' IX and/or IQ outside grid boundary'')') 
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' Apparently you try to assign a value'',           &
     &             '' to a linear combination: no thank you'')')        
      ENDIF 
                                                                        
      CALL QTRACE('QNPSET ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QADDSI.                                                     
                                                                        
!     =================================                                 
      SUBROUTINE QADDSI(UNAM,IQ,FACTOR) 
!     =================================                                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAME 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('QADDSI ',0) 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
                                                                        
      ID = IDCHEK(NAME,4,'QADDSI',1) 
                                                                        
      IF(ID.EQ.-1) RETURN 
                                                                        
      IF(ID.EQ.0.OR.ID.EQ.1) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
                                                                        
      IF(IQ.LT.1.OR.IQ.GT.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
                                                                        
      IF(ID.LT.0.OR.ID.GT.10) THEN 
        IERR = 4 
        GOTO 500 
      ENDIF 
                                                                        
      DO IX = 1,NXX 
!--     Invalidate evolution of this pdf                                
        LEVDONE(IX,MAX(ID,1)) = .FALSE. 
        PDFQCD(IX,IQ,ID) = PDFQCD(IX,IQ,ID)+                            &
     &                     FACTOR*PDFQCD(IX,IQ,1)                       
      ENDDO 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QADDSI ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NAME :'',A)') UNAM 
      WRITE(6,'( ''         IQ :'',I10)') IQ 
      WRITE(6,'( ''     Factor :'',E12.5)') FACTOR 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid available'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' This routine cannot be used'',                    &
     &             '' for singlet or gluon'')')                         
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' IX and/or IQ outside grid boundary'')') 
      ELSEIF(IERR.EQ.4) THEN 
        WRITE(6,'(/'' Apparently you try to assign a value'',           &
     &             '' to a linear combination: no thank you'')')        
      ENDIF 
                                                                        
      CALL QTRACE('QADDSI ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, QNPNUL.                                                     
                                                                        
!     =======================                                           
      SUBROUTINE QNPNUL(UNAM) 
!     =======================                                           
                                                                        
!---  Set parton distribution 'NAME' to zero.                           
!---  Called by user.                                                   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAME 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('QNPNUL ',0) 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
                                                                        
      ID = IDCHEK(NAME,4,'QNPNUL',1) 
                                                                        
      IF(ID.EQ.-1) RETURN 
                                                                        
      IF(ID.LT.0.OR.ID.GT.10) THEN 
        GOTO 500 
      ENDIF 
                                                                        
      DO IX = 1,MXX 
        DO IQ = 1,MQ2 
          PDFQCD(IX,IQ,ID) = 0. 
        ENDDO 
      ENDDO 
                                                                        
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QNPNUL ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NAME :'',A)') UNAM 
      WRITE(6,'(/'' Apparently you try to clear'',                      &
     &           '' a linear combination: no thank you'')')             
                                                                        
      CALL QTRACE('QNPNUL ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, IX1CHK.                                                     
                                                                        
!     ==============================                                    
      INTEGER FUNCTION IX1CHK(ISTOP) 
!     ==============================                                    
                                                                        
!---  Check all pdfs are zero at NXX+1 (x = 1).                         
!---  IX1CHK = 0    : All ok.                                           
!---         = 1    : Nonzero entry in gluon or singlet.                
!---         = 2-10 : Nonzero entry in PDF 2-10.                        
!---  Called by user.                                                   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('IX1CHK ',0) 
                                                                        
      IERR = -1 
      JQ   =  0 
                                                                        
      DO ID = 0,10 
        DO IQ = 1,NQ2 
          IF(ABS(PDFQCD(NXX+1,IQ,ID)).GT.1.E-11) THEN 
            IERR = ID 
            JQ   = IQ 
          ENDIF 
        ENDDO 
      ENDDO 
                                                                        
      IF(IERR.EQ.-1) THEN 
        IX1CHK = 0 
        RETURN 
      ENDIF 
                                                                        
      IX1CHK = MAX(IERR,1) 
      IF(ISTOP.EQ.0) RETURN 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r IX1CHK ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Pdf identifier  ID :'',I5)') IERR 
      WRITE(6,'( '' X = 1 gridpoint IX :'',I5)') NXX+1 
      WRITE(6,'( '' Q2    gridpoint IQ :'',I5)') JQ 
      WRITE(6,'(/'' Pdf nonzero at x = 1;''/                            &
     &           '' this should never happen....'')')                   
                                                                        
      CALL QTRACE('IX1CHK ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, EVOLSG.                                                     
                                                                        
!     ================================                                  
      SUBROUTINE EVOLSG(IQ0,IUQL,IUQH) 
!     ================================                                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      IF(LTIME) CALL TIMEX_LHA(T_START(5)) 
                                                                        
      CALL QTRACE('EVOLSG ',0) 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IQL = IUQL 
      IQH = IUQH 
                                                                        
      IXL = MAX(ABS(IXFROMX(XMICUT)),1) 
      IQD = ABS(IQFROMQ(QMICUT)) 
      IQD = MAX(IQD,ABS(IQFROMQ(QMINAS))) 
      IQU = ABS(IQFROMQ(QMACUT)) 
      IF(IQD.NE.0) IQL = MAX(IQD,IQL) 
      IF(IQU.NE.0) IQH = MIN(IQU+1,IQH) 
                                                                        
      IF(IQL.LE.0) IQL = 1 
      IF(IQH.LE.0.OR.IQH.GT.NQ2) IQH = NQ2 
      IF(IQL.EQ.IQ0.AND.IQH.EQ.IQ0) RETURN 
      IF(IQL.GE.IQH) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
      IF(IQL.LT.1.OR.IQL.GE.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
      IF(IQH.LE.1.OR.IQH.GT.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
      IF(IQ0.LT.IQL.OR.IQ0.GT.IQH) THEN 
        IERR = 4 
        GOTO 500 
      ENDIF 
      IF(.NOT.LWT1OK) THEN 
        IERR = 5 
        GOTO 500 
      ENDIF 
      IF(IORD.EQ.2.AND..NOT.LWT2OK) THEN 
        IERR = 6 
        GOTO 500 
      ENDIF 
                                                                        
      IRUN = 0 
      IF(.NOT.LALFOK) THEN 
        CALL QFILAS('EVOLSG') 
        IRUN = 1 
      ENDIF 
      IF(.NOT.LDQ2OK) THEN 
        CALL QDELQ2 
        IRUN = 1 
      ENDIF 
                                                                        
      DO IX = 1,NXX 
      LE_DONE(IX) = LEVDONE(IX,1) 
      DO IQ = 1,NQ2 
        FGLQCD(IX,IQ) = PDFQCD(IX,IQ,0) 
        FSIQCD(IX,IQ) = PDFQCD(IX,IQ,1) 
      ENDDO 
      ENDDO 
                                                                        
      IF(IQ0.NE.IQ0_LAST(1) .OR.                                        &
     &   IQL.NE.IQL_LAST(1) .OR.                                        &
     &   IQH.NE.IQH_LAST(1)     ) IRUN = 1                              
                                                                        
      CALL APSI(IXL,IQ0,IQL,IQH,IRUN,EVL) 
                                                                        
      IQ0_LAST(1) = IQ0 
      IQL_LAST(1) = IQL 
      IQH_LAST(1) = IQH 
                                                                        
      DO IX = 1,NXX 
      LEVDONE(IX,1) = LE_DONE(IX) 
      DO IQ = 1,NQ2 
        PDFQCD(IX,IQ,0) = FGLQCD(IX,IQ) 
        PDFQCD(IX,IQ,1) = FSIQCD(IX,IQ) 
      ENDDO 
      ENDDO 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      IF(LTIME) THEN 
        CALL TIMEX_LHA(T_END(5)) 
        T_SPENT(5) = T_SPENT(5)+T_END(5)-T_START(5) 
        N_CALLS(5) = N_CALLS(5)+1 
        E_CALLS(5) = E_CALLS(5)+EVL 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r EVOLSG ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input      IQ0      :'',I5)') IQ0 
      WRITE(6,'( ''            IQLow    :'',I5)') IUQL 
      WRITE(6,'( ''            IQHigh   :'',I5)') IUQH 
      IF(IERR.NE.1) THEN 
        WRITE(6,'(/'' After cuts IQ0, Q20 :'',I5,E12.5)') IQ0,Q2TAB(IQ0) 
        WRITE(6,'( ''            IQL, Q2L :'',I5,E12.5)') IQL,Q2TAB(IQL) 
        WRITE(6,'( ''            IQH, Q2H :'',I5,E12.5)') IQH,Q2TAB(IQH) 
      ENDIF 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid available'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Value of IQL .ge. IQH'',                          &
     &             '' (after applying Q2 cuts, if any)'')')             
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' IQL and/or IQH outside grid boundary'')') 
      ELSEIF(IERR.EQ.4) THEN 
        WRITE(6,'(/'' IQ0 outside the range [IQL,IQH]'',                &
     &             '' (after applying Q2 cuts, if any)'')')             
      ELSEIF(IERR.EQ.5) THEN 
        WRITE(6,'(/'' No LO weight tables available'',                  &
     &             '' (please call s/r QNFILW)'')')                     
      ELSEIF(IERR.EQ.6) THEN 
        WRITE(6,'(/'' No NLO weight tables available'',                 &
     &             '' (please call s/r QNFILW)'')')                     
      ENDIF 
                                                                        
      CALL QTRACE('EVOLSG ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
                                                                        
!DECK  ID>, APSI.                                                       
!     =========================================                         
      SUBROUTINE APSI(IXL,IQ0,IQL,IQH,IRUN,EVL) 
!     =========================================                         
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      EVL = 0. 
                                                                        
      FSI = FSIQCD(NXX,IQ0) 
      FGL = FGLQCD(NXX,IQ0) 
!     -------------------------------------------                       
                                                !                       
      IF(.NOT.LE_DONE(NXX) .OR. IRUN.EQ.1) THEN 
!     -------------------------------------------                       
                                                                        
        NF  = NFMAP(IQ0) 
                                                                        
        WQQ = ALFAPQ(IQ0) * WGTFF1(IWADR(NXX,NXX))    +                 &
     &        ALFA2Q(IQ0) * WGTFF2(IWADR(NXX,NXX),NF)                   
        WQG = ALFAPQ(IQ0) * WGTFG1(IWADR(NXX,NXX),NF) +                 &
     &        ALFA2Q(IQ0) * WGTFG2(IWADR(NXX,NXX),NF)                   
        WGQ = ALFAPQ(IQ0) * WGTGF1(IWADR(NXX,NXX))    +                 &
     &        ALFA2Q(IQ0) * WGTGF2(IWADR(NXX,NXX),NF)                   
        WGG = ALFAPQ(IQ0) * WGTGG1(IWADR(NXX,NXX),NF) +                 &
     &        ALFA2Q(IQ0) * WGTGG2(IWADR(NXX,NXX),NF)                   
                                                                        
        DSI = WQQ*FSI+WQG*FGL 
        DGL = WGQ*FSI+WGG*FGL 
                                                                        
        FSI0 = FSI 
        DSI0 = DSI 
        FGL0 = FGL 
        DGL0 = DGL 
        FSIQCD(NXX,IQ0) = FSI 
        DSIQCD(NXX,IQ0) = DSI 
        FGLQCD(NXX,IQ0) = FGL 
        DGGQCD(NXX,IQ0) = DGL 
        EVL             = EVL+1. 
                                                                        
        DO 100 IQ = IQ0+1,IQH 
          DEL = DELUP(IQ) 
          NF  = NFMAP(IQ) 
          WQQ = ALFAPQ(IQ) * WGTFF1(IWADR(NXX,NXX))    +                &
     &          ALFA2Q(IQ) * WGTFF2(IWADR(NXX,NXX),NF)                  
          WQG = ALFAPQ(IQ) * WGTFG1(IWADR(NXX,NXX),NF) +                &
     &          ALFA2Q(IQ) * WGTFG2(IWADR(NXX,NXX),NF)                  
          WGQ = ALFAPQ(IQ) * WGTGF1(IWADR(NXX,NXX))    +                &
     &          ALFA2Q(IQ) * WGTGF2(IWADR(NXX,NXX),NF)                  
          WGG = ALFAPQ(IQ) * WGTGG1(IWADR(NXX,NXX),NF) +                &
     &          ALFA2Q(IQ) * WGTGG2(IWADR(NXX,NXX),NF)                  
          AAS = 2.*FSI + DSI*DEL 
          BBS = 2. - WQQ*DEL 
          AAG = 2.*FGL + DGL*DEL 
          BBG = 2. - WGG*DEL 
          FSI = (AAS*BBG+WQG*AAG*DEL) / (BBS*BBG-WQG*WGQ*DEL*DEL) 
          FGL = (AAG*BBS+WGQ*AAS*DEL) / (BBG*BBS-WGQ*WQG*DEL*DEL) 
          DSI = WQQ*FSI+WQG*FGL 
          DGL = WGQ*FSI+WGG*FGL 
          FSIQCD(NXX,IQ) = FSI 
          DSIQCD(NXX,IQ) = DSI 
          FGLQCD(NXX,IQ) = FGL 
          DGGQCD(NXX,IQ) = DGL 
  100   CONTINUE 
        EVL = EVL+IQH-IQ0 
                                                                        
        FSI = FSI0 
        DSI = DSI0 
        FGL = FGL0 
        DGL = DGL0 
                                                                        
        DO 200 IQ = IQ0-1,IQL,-1 
          DEL = DELDN(IQ) 
          NF  = NFMAP(IQ) 
          WQQ = ALFAPQ(IQ) * WGTFF1(IWADR(NXX,NXX))    +                &
     &          ALFA2Q(IQ) * WGTFF2(IWADR(NXX,NXX),NF)                  
          WQG = ALFAPQ(IQ) * WGTFG1(IWADR(NXX,NXX),NF) +                &
     &          ALFA2Q(IQ) * WGTFG2(IWADR(NXX,NXX),NF)                  
          WGQ = ALFAPQ(IQ) * WGTGF1(IWADR(NXX,NXX))    +                &
     &          ALFA2Q(IQ) * WGTGF2(IWADR(NXX,NXX),NF)                  
          WGG = ALFAPQ(IQ) * WGTGG1(IWADR(NXX,NXX),NF) +                &
     &          ALFA2Q(IQ) * WGTGG2(IWADR(NXX,NXX),NF)                  
          AAS = 2.*FSI + DSI*DEL 
          BBS = 2. - WQQ*DEL 
          AAG = 2.*FGL + DGL*DEL 
          BBG = 2. - WGG*DEL 
          FSI = (AAS*BBG+WQG*AAG*DEL) / (BBS*BBG-WQG*WGQ*DEL*DEL) 
          FGL = (AAG*BBS+WGQ*AAS*DEL) / (BBG*BBS-WGQ*WQG*DEL*DEL) 
          DSI = WQQ*FSI+WQG*FGL 
          DGL = WGQ*FSI+WGG*FGL 
          FSIQCD(NXX,IQ) = FSI 
          DSIQCD(NXX,IQ) = DSI 
          FGLQCD(NXX,IQ) = FGL 
          DGGQCD(NXX,IQ) = DGL 
  200   CONTINUE 
        EVL = EVL+IQ0-IQL 
                                                                        
!     -------                                                           
            !                                                           
      ENDIF 
!     -------                                                           
                                                                        
!     ---------------------------                                       
                                !                                       
      DO IX0 = NXX-1,IXL,-1 
!     ---------------------------                                       
                                                                        
        FSI = FSIQCD(IX0,IQ0) 
        FGL = FGLQCD(IX0,IQ0) 
        IF(LE_DONE(IX0) .AND. IRUN.EQ.0) EXIT
        ALF = ALFAPQ(IQ0) 
        AL2 = ALFA2Q(IQ0) 
        SQQ1 = 0. 
        SQG1 = 0. 
        SGQ1 = 0. 
        SGG1 = 0. 
        SQQ2 = 0. 
        SQG2 = 0. 
        SGQ2 = 0. 
        SGG2 = 0. 
        NF  = NFMAP(IQ0) 
        DO 220 IX = NXX,IX0+1,-1 
          IADR = IWADR(IX,IX0) 
          SQQ1 = SQQ1 + WGTFF1(IADR)      * FSIQCD(IX,IQ0) 
          SQQ2 = SQQ2 + WGTFF2(IADR,NF)   * FSIQCD(IX,IQ0) 
          SQG1 = SQG1 + WGTFG1(IADR,NF)   * FGLQCD(IX,IQ0) 
          SQG2 = SQG2 + WGTFG2(IADR,NF)   * FGLQCD(IX,IQ0) 
          SGQ1 = SGQ1 + WGTGF1(IADR)      * FSIQCD(IX,IQ0) 
          SGQ2 = SGQ2 + WGTGF2(IADR,NF)   * FSIQCD(IX,IQ0) 
          SGG1 = SGG1 + WGTGG1(IADR,NF)   * FGLQCD(IX,IQ0) 
          SGG2 = SGG2 + WGTGG2(IADR,NF)   * FGLQCD(IX,IQ0) 
  220   CONTINUE 
        IAD = IWADR(IX0,IX0) 
        SQQ = ALF*SQQ1 + AL2*SQQ2 
        SQG = ALF*SQG1 + AL2*SQG2 
        SGQ = ALF*SGQ1 + AL2*SGQ2 
        SGG = ALF*SGG1 + AL2*SGG2 
        WQQ = ALF* WGTFF1(IAD)        + AL2*WGTFF2(IAD,NF) 
        WQG = ALF* WGTFG1(IAD,NF)     + AL2*WGTFG2(IAD,NF) 
        WGQ = ALF* WGTGF1(IAD)        + AL2*WGTGF2(IAD,NF) 
        WGG = ALF* WGTGG1(IAD,NF)     + AL2*WGTGG2(IAD,NF) 
        DSI = WQQ*FSI+SQQ+WQG*FGL+SQG 
        DGL = WGQ*FSI+SGQ+WGG*FGL+SGG 
                                                                        
        FSI0 = FSI 
        DSI0 = DSI 
        FGL0 = FGL 
        DGL0 = DGL 
        FSIQCD(IX0,IQ0) = FSI 
        DSIQCD(IX0,IQ0) = DSI 
        FGLQCD(IX0,IQ0) = FGL 
        DGGQCD(IX0,IQ0) = DGL 
        EVL             = EVL+NXX-IX0+1 
                                                                        
        DO 250 IQ = IQ0+1,IQH 
          IF(IFAILC(IX0,IQ).NE.0) GOTO 250 
          ALF = ALFAPQ(IQ) 
          AL2 = ALFA2Q(IQ) 
          DEL = DELUP(IQ) 
          SQQ1 = 0. 
          SQG1 = 0. 
          SGQ1 = 0. 
          SGG1 = 0. 
          SQQ2 = 0. 
          SQG2 = 0. 
          SGQ2 = 0. 
          SGG2 = 0. 
          NF  = NFMAP(IQ) 
          DO 230 IX = NXX,IX0+1,-1 
            IADR = IWADR(IX,IX0) 
            SQQ1 = SQQ1 + WGTFF1(IADR)      * FSIQCD(IX,IQ) 
            SQQ2 = SQQ2 + WGTFF2(IADR,NF)   * FSIQCD(IX,IQ) 
            SQG1 = SQG1 + WGTFG1(IADR,NF)   * FGLQCD(IX,IQ) 
            SQG2 = SQG2 + WGTFG2(IADR,NF)   * FGLQCD(IX,IQ) 
            SGQ1 = SGQ1 + WGTGF1(IADR)      * FSIQCD(IX,IQ) 
            SGQ2 = SGQ2 + WGTGF2(IADR,NF)   * FSIQCD(IX,IQ) 
            SGG1 = SGG1 + WGTGG1(IADR,NF)   * FGLQCD(IX,IQ) 
            SGG2 = SGG2 + WGTGG2(IADR,NF)   * FGLQCD(IX,IQ) 
  230     CONTINUE 
          IAD = IWADR(IX0,IX0) 
          SQQ = ALF*SQQ1 + AL2*SQQ2 
          SQG = ALF*SQG1 + AL2*SQG2 
          SGQ = ALF*SGQ1 + AL2*SGQ2 
          SGG = ALF*SGG1 + AL2*SGG2 
          WQQ = ALF* WGTFF1(IAD)        + AL2*WGTFF2(IAD,NF) 
          WQG = ALF* WGTFG1(IAD,NF)     + AL2*WGTFG2(IAD,NF) 
          WGQ = ALF* WGTGF1(IAD)        + AL2*WGTGF2(IAD,NF) 
          WGG = ALF* WGTGG1(IAD,NF)     + AL2*WGTGG2(IAD,NF) 
          AAS = 2.*FSI + (DSI+SQQ+SQG)*DEL 
          BBS = 2. - WQQ*DEL 
          AAG = 2.*FGL + (DGL+SGQ+SGG)*DEL 
          BBG = 2. - WGG*DEL 
          FSI = (AAS*BBG+WQG*AAG*DEL) / (BBS*BBG-WQG*WGQ*DEL*DEL) 
          FGL = (AAG*BBS+WGQ*AAS*DEL) / (BBG*BBS-WGQ*WQG*DEL*DEL) 
          DSI = WQQ*FSI+SQQ+WQG*FGL+SQG 
          DGL = WGQ*FSI+SGQ+WGG*FGL+SGG 
          FSIQCD(IX0,IQ) = FSI 
          DSIQCD(IX0,IQ) = DSI 
          FGLQCD(IX0,IQ) = FGL 
          DGGQCD(IX0,IQ) = DGL 
          EVL            = EVL+NXX-IX0+1 
  250   CONTINUE 
                                                                        
        FSI = FSI0 
        DSI = DSI0 
        FGL = FGL0 
        DGL = DGL0 
                                                                        
        DO 270 IQ = IQ0-1,IQL,-1 
          ALF = ALFAPQ(IQ) 
          AL2 = ALFA2Q(IQ) 
          DEL = DELDN(IQ) 
          SQQ1 = 0. 
          SQG1 = 0. 
          SGQ1 = 0. 
          SGG1 = 0. 
          SQQ2 = 0. 
          SQG2 = 0. 
          SGQ2 = 0. 
          SGG2 = 0. 
          NF  = NFMAP(IQ) 
          DO 260 IX = NXX,IX0+1,-1 
            IADR = IWADR(IX,IX0) 
            SQQ1 = SQQ1 + WGTFF1(IADR)      * FSIQCD(IX,IQ) 
            SQQ2 = SQQ2 + WGTFF2(IADR,NF)   * FSIQCD(IX,IQ) 
            SQG1 = SQG1 + WGTFG1(IADR,NF)   * FGLQCD(IX,IQ) 
            SQG2 = SQG2 + WGTFG2(IADR,NF)   * FGLQCD(IX,IQ) 
            SGQ1 = SGQ1 + WGTGF1(IADR)      * FSIQCD(IX,IQ) 
            SGQ2 = SGQ2 + WGTGF2(IADR,NF)   * FSIQCD(IX,IQ) 
            SGG1 = SGG1 + WGTGG1(IADR,NF)   * FGLQCD(IX,IQ) 
            SGG2 = SGG2 + WGTGG2(IADR,NF)   * FGLQCD(IX,IQ) 
  260     CONTINUE 
          IAD = IWADR(IX0,IX0) 
          SQQ = ALF*SQQ1 + AL2*SQQ2 
          SQG = ALF*SQG1 + AL2*SQG2 
          SGQ = ALF*SGQ1 + AL2*SGQ2 
          SGG = ALF*SGG1 + AL2*SGG2 
          WQQ = ALF* WGTFF1(IAD)        + AL2*WGTFF2(IAD,NF) 
          WQG = ALF* WGTFG1(IAD,NF)     + AL2*WGTFG2(IAD,NF) 
          WGQ = ALF* WGTGF1(IAD)        + AL2*WGTGF2(IAD,NF) 
          WGG = ALF* WGTGG1(IAD,NF)     + AL2*WGTGG2(IAD,NF) 
          AAS = 2.*FSI + (DSI+SQQ+SQG)*DEL 
          BBS = 2. - WQQ*DEL 
          AAG = 2.*FGL + (DGL+SGQ+SGG)*DEL 
          BBG = 2. - WGG*DEL 
          FSI = (AAS*BBG+WQG*AAG*DEL) / (BBS*BBG-WQG*WGQ*DEL*DEL) 
          FGL = (AAG*BBS+WGQ*AAS*DEL) / (BBG*BBS-WGQ*WQG*DEL*DEL) 
          DSI = WQQ*FSI+SQQ+WQG*FGL+SQG 
          DGL = WGQ*FSI+SGQ+WGG*FGL+SGG 
          FSIQCD(IX0,IQ) = FSI 
          DSIQCD(IX0,IQ) = DSI 
          FGLQCD(IX0,IQ) = FGL 
          DGGQCD(IX0,IQ) = DGL 
          EVL            = EVL+NXX-IX0+1 
  270   CONTINUE 
                                                                        
!     ----------                                                        
               !                                                        
      END DO 
!     ----------                                                        
                                                                        
      EVL = EVL*2./(NXX*(NXX+1)*NQ2) 
                                                                        
      CALL QNTRUE(LE_DONE,NXX) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, EVOLNM.                                                     
                                                                        
!     =====================================                             
      SUBROUTINE EVOLNM(UNAM,IQ0,IUQL,IUQH) 
!     =====================================                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAME 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      IF(LTIME) CALL TIMEX_LHA(T_START(3)) 
                                                                        
      CALL QTRACE('EVOLNM ',0) 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IQL = IUQL 
      IQH = IUQH 
                                                                        
      IXL = MAX(ABS(IXFROMX(XMICUT)),1) 
      IQD = ABS(IQFROMQ(QMICUT)) 
      IQD = MAX(IQD,ABS(IQFROMQ(QMINAS))) 
      IQU = ABS(IQFROMQ(QMACUT)) 
      IF(IQD.NE.0) IQL = MAX(IQD,IQL) 
      IF(IQU.NE.0) IQH = MIN(IQU+1,IQH) 
                                                                        
      IF(IQL.LE.0) IQL = 1 
      IF(IQH.LE.0.OR.IQH.GT.NQ2) IQH = NQ2 
      IF(IQL.EQ.IQ0.AND.IQH.EQ.IQ0) RETURN 
      IF(IQL.GE.IQH) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
      IF(IQL.LT.1.OR.IQL.GE.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
      IF(IQH.LE.1.OR.IQH.GT.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
      IF(IQ0.LT.IQL.OR.IQ0.GT.IQH) THEN 
        IERR = 4 
        GOTO 500 
      ENDIF 
      IF(.NOT.LWT1OK) THEN 
        IERR = 5 
        GOTO 500 
      ENDIF 
      IF(IORD.EQ.2.AND..NOT.LWT2OK) THEN 
        IERR = 6 
        GOTO 500 
      ENDIF 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
                                                                        
      NFMI = 9 
      NFMA = 0 
      DO 15 IQ = IQL,IQH 
      NFMI = MIN(NFMI,NFMAP(IQ)) 
      NFMA = MAX(NFMA,NFMAP(IQ)) 
   15 END DO 
                                                                        
      DO 16 NF = NFMI,NFMA 
        ID = IDCHEK(NAME,NF,'EVOLNM',1) 
   16 END DO 
                                                                        
      IRUN = 0 
      IF(LPLUS) THEN 
        DO 19 NF = 3,5 
        DO 18 IX0 = 1,NXX 
        DO 17 IX  = IX0,NXX 
          WGTNS2(IWADR(IX,IX0),NF) = WGTPM2(IWADR(IX,IX0),NF) 
   17   CONTINUE 
   18   CONTINUE 
   19   CONTINUE 
        IRUN = 1 
      ENDIF 
      LPLUS = .FALSE. 
                                                                        
      IF(.NOT.LALFOK) THEN 
        CALL QFILAS('EVOLNM') 
        IRUN = 1 
      ENDIF 
      IF(.NOT.LDQ2OK) THEN 
        CALL QDELQ2 
        IRUN = 1 
      ENDIF 
                                                                        
      DO IX = 1,NXX 
      LE_DONE(IX) = LEVDONE(IX,ID) 
      DO IQ = 1,NQ2 
        FNSQCD(IX,IQ) = PDFQCD(IX,IQ,ID) 
      ENDDO 
      ENDDO 
                                                                        
      IF(IQ0.NE.IQ0_LAST(ID) .OR.                                       &
     &   IQL.NE.IQL_LAST(ID) .OR.                                       &
     &   IQH.NE.IQH_LAST(ID)     ) IRUN = 1                             
                                                                        
      CALL APNS(IXL,IQ0,IQL,IQH,IRUN,EVL) 
                                                                        
      IQ0_LAST(ID) = IQ0 
      IQL_LAST(ID) = IQL 
      IQH_LAST(ID) = IQH 
                                                                        
      DO IX = 1,NXX 
      LEVDONE(IX,ID) = LE_DONE(IX) 
      DO IQ = 1,NQ2 
        PDFQCD(IX,IQ,ID) = FNSQCD(IX,IQ) 
      ENDDO 
      ENDDO 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      IF(LTIME) THEN 
        CALL TIMEX_LHA(T_END(3)) 
        T_SPENT(3) = T_SPENT(3)+T_END(3)-T_START(3) 
        N_CALLS(3) = N_CALLS(3)+1 
        E_CALLS(3) = E_CALLS(3)+EVL 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r EVOLNM ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input      NAME     :'',A)')  UNAM 
      WRITE(6,'( ''            IQ0      :'',I5)') IQ0 
      WRITE(6,'( ''            IQLow    :'',I5)') IUQL 
      WRITE(6,'( ''            IQHigh   :'',I5)') IUQH 
      IF(IERR.NE.1) THEN 
        WRITE(6,'(/'' After cuts IQ0, Q20 :'',I5,E12.5)') IQ0,Q2TAB(IQ0) 
        WRITE(6,'( ''            IQL, Q2L :'',I5,E12.5)') IQL,Q2TAB(IQL) 
        WRITE(6,'( ''            IQH, Q2H :'',I5,E12.5)') IQH,Q2TAB(IQH) 
      ENDIF 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid available'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Value of IQL .ge. IQH'',                          &
     &             '' (after applying Q2 cuts, if any)'')')             
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' IQL and/or IQH outside grid boundary'')') 
      ELSEIF(IERR.EQ.4) THEN 
        WRITE(6,'(/'' IQ0 outside the range [IQL,IQH]'',                &
     &             '' (after applying Q2 cuts, if any)'')')             
      ELSEIF(IERR.EQ.5) THEN 
        WRITE(6,'(/'' No LO weight tables available'',                  &
     &             '' (please call s/r QNFILW)'')')                     
      ELSEIF(IERR.EQ.6) THEN 
        WRITE(6,'(/'' No NLO weight tables available'',                 &
     &             '' (please call s/r QNFILW)'')')                     
      ENDIF 
                                                                        
      CALL QTRACE('EVOLNM ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, EVOLNP.                                                     
                                                                        
!     =====================================                             
      SUBROUTINE EVOLNP(UNAM,IQ0,IUQL,IUQH) 
!     =====================================                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAME 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      IF(LTIME) CALL TIMEX_LHA(T_START(4)) 
                                                                        
      CALL QTRACE('EVOLNP ',0) 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IQL = IUQL 
      IQH = IUQH 
                                                                        
      IXL = MAX(ABS(IXFROMX(XMICUT)),1) 
      IQD = ABS(IQFROMQ(QMICUT)) 
      IQD = MAX(IQD,ABS(IQFROMQ(QMINAS))) 
      IQU = ABS(IQFROMQ(QMACUT)) 
      IF(IQD.NE.0) IQL = MAX(IQD,IQL) 
      IF(IQU.NE.0) IQH = MIN(IQU+1,IQH) 
                                                                        
      IF(IQL.LE.0) IQL = 1 
      IF(IQH.LE.0.OR.IQH.GT.NQ2) IQH = NQ2 
      IF(IQL.EQ.IQ0.AND.IQH.EQ.IQ0) RETURN 
      IF(IQL.GE.IQH) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
      IF(IQL.LT.1.OR.IQL.GE.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
      IF(IQH.LE.1.OR.IQH.GT.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
      IF(IQ0.LT.IQL.OR.IQ0.GT.IQH) THEN 
        IERR = 4 
        GOTO 500 
      ENDIF 
      IF(.NOT.LWT1OK) THEN 
        IERR = 5 
        GOTO 500 
      ENDIF 
      IF(IORD.EQ.2.AND..NOT.LWT2OK) THEN 
        IERR = 6 
        GOTO 500 
      ENDIF 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
                                                                        
      NFMI = 9 
      NFMA = 0 
      DO 15 IQ = IQL,IQH 
      NFMI = MIN(NFMI,NFMAP(IQ)) 
      NFMA = MAX(NFMA,NFMAP(IQ)) 
   15 END DO 
                                                                        
      DO 16 NF = NFMI,NFMA 
        ID = IDCHEK(NAME,NF,'EVOLNP',1) 
   16 END DO 
                                                                        
      IRUN = 0 
      IF(.NOT.LPLUS) THEN 
        DO 19 NF  = 3,5 
        DO 18 IX0 = 1,NXX 
        DO 17 IX  = IX0,NXX 
          WGTNS2(IWADR(IX,IX0),NF) = WGTPP2(IWADR(IX,IX0),NF) 
   17   CONTINUE 
   18   CONTINUE 
   19   CONTINUE 
        IRUN = 1 
      ENDIF 
      LPLUS = .TRUE. 
                                                                        
      IF(.NOT.LALFOK) THEN 
        CALL QFILAS('EVOLNP') 
        IRUN = 1 
      ENDIF 
      IF(.NOT.LDQ2OK) THEN 
        CALL QDELQ2 
        IRUN = 1 
      ENDIF 
                                                                        
      DO 25 IX = 1,NXX 
      DO 20 IQ = 1,NQ2 
   20 END DO 
   25 END DO 
                                                                        
      DO IX = 1,NXX 
      LE_DONE(IX) = LEVDONE(IX,ID) 
      DO IQ = 1,NQ2 
        FNSQCD(IX,IQ) = PDFQCD(IX,IQ,ID) 
      ENDDO 
      ENDDO 
                                                                        
      IF(IQ0.NE.IQ0_LAST(ID) .OR.                                       &
     &   IQL.NE.IQL_LAST(ID) .OR.                                       &
     &   IQH.NE.IQH_LAST(ID)     ) IRUN = 1                             
                                                                        
      CALL APNS(IXL,IQ0,IQL,IQH,IRUN,EVL) 
                                                                        
      IQ0_LAST(ID) = IQ0 
      IQL_LAST(ID) = IQL 
      IQH_LAST(ID) = IQH 
                                                                        
      DO IX = 1,NXX 
      LEVDONE(IX,ID) = LE_DONE(IX) 
      DO IQ = 1,NQ2 
        PDFQCD(IX,IQ,ID) = FNSQCD(IX,IQ) 
      ENDDO 
      ENDDO 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      IF(LTIME) THEN 
        CALL TIMEX_LHA(T_END(4)) 
        T_SPENT(4) = T_SPENT(4)+T_END(4)-T_START(4) 
        N_CALLS(4) = N_CALLS(4)+1 
        E_CALLS(4) = E_CALLS(4)+EVL 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r EVOLNP ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input      NAME     :'',A)')  UNAM 
      WRITE(6,'( ''            IQ0      :'',I5)') IQ0 
      WRITE(6,'( ''            IQLow    :'',I5)') IUQL 
      WRITE(6,'( ''            IQHigh   :'',I5)') IUQH 
      IF(IERR.NE.1) THEN 
        WRITE(6,'(/'' After cuts IQ0, Q20 :'',I5,E12.5)') IQ0,Q2TAB(IQ0) 
        WRITE(6,'( ''            IQL, Q2L :'',I5,E12.5)') IQL,Q2TAB(IQL) 
        WRITE(6,'( ''            IQH, Q2H :'',I5,E12.5)') IQH,Q2TAB(IQH) 
      ENDIF 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid available'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Value of IQL .ge. IQH'',                          &
     &             '' (after applying Q2 cuts, if any)'')')             
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' IQL and/or IQH outside grid boundary'')') 
      ELSEIF(IERR.EQ.4) THEN 
        WRITE(6,'(/'' IQ0 outside the range [IQL,IQH]'',                &
     &             '' (after applying Q2 cuts, if any)'')')             
      ELSEIF(IERR.EQ.5) THEN 
        WRITE(6,'(/'' No LO weight tables available'',                  &
     &             '' (please call s/r QNFILW)'')')                     
      ELSEIF(IERR.EQ.6) THEN 
        WRITE(6,'(/'' No NLO weight tables available'',                 &
     &             '' (please call s/r QNFILW)'')')                     
      ENDIF 
                                                                        
      CALL QTRACE('EVOLNP ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, EVPLUS.                                                     
                                                                        
!     =====================================                             
      SUBROUTINE EVPLUS(UNAM,IQ0,IUQL,IUQH) 
!     =====================================                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAME 
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      IF(LTIME) CALL TIMEX_LHA(T_START(4)) 
                                                                        
      CALL QTRACE('EVPLUS ',0) 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IQL = IUQL 
      IQH = IUQH 
                                                                        
      IXL = MAX(ABS(IXFROMX(XMICUT)),1) 
      IQD = ABS(IQFROMQ(QMICUT)) 
      IQD = MAX(IQD,ABS(IQFROMQ(QMINAS))) 
      IQU = ABS(IQFROMQ(QMACUT)) 
      IF(IQD.NE.0) IQL = MAX(IQD,IQL) 
      IF(IQU.NE.0) IQH = MIN(IQU+1,IQH) 
                                                                        
      IF(IQL.LE.0) IQL = 1 
      IF(IQH.LE.0.OR.IQH.GT.NQ2) IQH = NQ2 
      IF(IQL.EQ.IQ0.AND.IQH.EQ.IQ0) RETURN 
      IF(IQL.GE.IQH) THEN 
        IERR = 2 
        GOTO 500 
      ENDIF 
      IF(IQL.LT.1.OR.IQL.GE.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
      IF(IQH.LE.1.OR.IQH.GT.NQ2) THEN 
        IERR = 3 
        GOTO 500 
      ENDIF 
      IF(IQ0.LT.IQL.OR.IQ0.GT.IQH) THEN 
        IERR = 4 
        GOTO 500 
      ENDIF 
      IF(NFMAP(IQL).NE.NFMAP(IQH-1)) THEN 
        IERR = 5 
        GOTO 500 
      ENDIF 
      IF(.NOT.LWT1OK) THEN 
        IERR = 6 
        GOTO 500 
      ENDIF 
      IF(IORD.EQ.2.AND..NOT.LWT2OK) THEN 
        IERR = 7 
        GOTO 500 
      ENDIF 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
                                                                        
      NFMI = 9 
      NFMA = 0 
      DO 15 IQ = IQL,IQH 
      NFMI = MIN(NFMI,NFMAP(IQ)) 
      NFMA = MAX(NFMA,NFMAP(IQ)) 
   15 END DO 
                                                                        
      DO 16 NF = NFMI,NFMA 
        ID = IDCHEK(NAME,NF,'EVPLUS',1) 
   16 END DO 
                                                                        
      IRUN = 0 
      IF(.NOT.LPLUS) THEN 
        DO 19 NF  = 3,5 
        DO 18 IX0 = 1,NXX 
        DO 17 IX  = IX0,NXX 
          WGTNS2(IWADR(IX,IX0),NF) = WGTPP2(IWADR(IX,IX0),NF) 
   17   CONTINUE 
   18   CONTINUE 
   19   CONTINUE 
        IRUN = 1 
      ENDIF 
      LPLUS = .TRUE. 
                                                                        
      IF(.NOT.LALFOK) THEN 
        CALL QFILAS('EVPLUS') 
        IRUN = 1 
      ENDIF 
      IF(.NOT.LDQ2OK) THEN 
        CALL QDELQ2 
        IRUN = 1 
      ENDIF 
                                                                        
      DO IX = 1,NXX 
      LE_DONE(IX) = LEVDONE(IX,ID) 
      DO IQ = 1,NQ2 
        FNSQCD(IX,IQ) = PDFQCD(IX,IQ,ID) 
      ENDDO 
      ENDDO 
                                                                        
      IF(IQ0.NE.IQ0_LAST(ID) .OR.                                       &
     &   IQL.NE.IQL_LAST(ID) .OR.                                       &
     &   IQH.NE.IQH_LAST(ID)     ) IRUN = 1                             
                                                                        
      CALL APNS(IXL,IQ0,IQL,IQH,IRUN,EVL) 
                                                                        
      IQ0_LAST(ID) = IQ0 
      IQL_LAST(ID) = IQL 
      IQH_LAST(ID) = IQH 
                                                                        
      DO IX = 1,NXX 
      LEVDONE(IX,ID) = LE_DONE(IX) 
      DO IQ = 1,NQ2 
        PDFQCD(IX,IQ,ID) = FNSQCD(IX,IQ) 
      ENDDO 
      ENDDO 
                                                                        
      DO I = 1,30 
        DO J = 1,7 
          LFFCAL(J,I)  = .FALSE. 
        ENDDO 
      ENDDO 
                                                                        
      IF(LTIME) THEN 
        CALL TIMEX_LHA(T_END(4)) 
        T_SPENT(4) = T_SPENT(4)+T_END(4)-T_START(4) 
        N_CALLS(4) = N_CALLS(4)+1 
        E_CALLS(4) = E_CALLS(4)+EVL 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r EVPLUS ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NAME   :'',A)') UNAM 
      WRITE(6,'( '' Input IQ0    :'',I10)') IQ0 
      WRITE(6,'( ''       IQLow  :'',I10)') IUQL 
      WRITE(6,'( ''       IQHigh :'',I10)') IUQH 
      IF(IERR.NE.1) THEN 
        WRITE(6,'(/'' After cuts IQ0, Q20 :'',I5,E12.5)') IQ0,Q2TAB(IQ0) 
        WRITE(6,'( ''            IQL, Q2L :'',I5,E12.5)') IQL,Q2TAB(IQL) 
        WRITE(6,'( ''            IQH, Q2H :'',I5,E12.5)') IQH,Q2TAB(IQH) 
      ENDIF 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid available'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' Value of IQL .ge. IQH'',                          &
     &             '' (after applying Q2 cuts, if any)'')')             
      ELSEIF(IERR.EQ.3) THEN 
        WRITE(6,'(/'' IQL and/or IQH outside grid boundary'')') 
      ELSEIF(IERR.EQ.4) THEN 
        WRITE(6,'(/'' IQ0 outside the range [IQL,IQH]'')') 
      ELSEIF(IERR.EQ.5) THEN 
        WRITE(6,'(/'' [IQL,IQH} crosses a flavour threshold'')') 
      ELSEIF(IERR.EQ.6) THEN 
        WRITE(6,'(/'' No LO weight tables available'',                  &
     &             '' (please call s/r QNFILW)'')')                     
      ELSEIF(IERR.EQ.7) THEN 
        WRITE(6,'(/'' No NLO weight tables available'',                 &
     &             '' (please call s/r QNFILW)'')')                     
      ENDIF 
                                                                        
      CALL QTRACE('EVPLUS ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, APNS.                                                       
                                                                        
!     =========================================                         
      SUBROUTINE APNS(IXL,IQ0,IQL,IQH,IRUN,EVL) 
!     =========================================                         
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      EVL = 0. 
                                                                        
      FNS = FNSQCD(NXX,IQ0) 
!     -------------------------------------------                       
                                                !                       
      IF(.NOT.LE_DONE(NXX) .OR. IRUN.EQ.1) THEN 
!     -------------------------------------------                       
                                                                        
        NF   = NFMAP(IQ0) 
        WGT  = ALFAPQ(IQ0)*WGTFF1(IWADR(NXX,NXX)) +                     &
     &         ALFA2Q(IQ0)*WGTNS2(IWADR(NXX,NXX),NF)                    
        DNS  = WGT*FNS 
        FNS0 = FNS 
        DNS0 = DNS 
        FNSQCD(NXX,IQ0) = FNS 
        DNSQCD(NXX,IQ0) = DNS 
        EVL             = EVL+1. 
                                                                        
        DO 100 IQ = IQ0+1,IQH 
          NF   = NFMAP(IQ) 
          WGT  = ALFAPQ(IQ)*WGTFF1(IWADR(NXX,NXX)) +                    &
     &           ALFA2Q(IQ)*WGTNS2(IWADR(NXX,NXX),NF)                   
          FNS = ( 2.*FNS + DNS*DELUP(IQ) ) / ( 2. - WGT*DELUP(IQ) ) 
          DNS = WGT*FNS 
          FNSQCD(NXX,IQ) = FNS 
          DNSQCD(NXX,IQ) = DNS 
  100   CONTINUE 
        EVL = EVL+IQH-IQ0 
                                                                        
        FNS = FNS0 
        DNS = DNS0 
                                                                        
        DO 200 IQ = IQ0-1,IQL,-1 
          NF   = NFMAP(IQ) 
          WGT  = ALFAPQ(IQ)*WGTFF1(IWADR(NXX,NXX)) +                    &
     &           ALFA2Q(IQ)*WGTNS2(IWADR(NXX,NXX),NF)                   
          FNS = ( 2.*FNS + DNS*DELDN(IQ) ) / ( 2. - WGT*DELDN(IQ) ) 
          DNS = WGT*FNS 
          FNSQCD(NXX,IQ) = FNS 
          DNSQCD(NXX,IQ) = DNS 
  200   CONTINUE 
        EVL = EVL+IQ0-IQL 
                                                                        
!     -------                                                           
            !                                                           
      ENDIF 
!     -------                                                           
                                                                        
!     ---------------------------                                       
                                !                                       
      DO IX0 = NXX-1,IXL,-1 
!     --------------------------- 
                                                                        
        FNS = FNSQCD(IX0,IQ0) 
        IF(LE_DONE(IX0).AND.IRUN.EQ.0) EXIT
        ALFAS = ALFAPQ(IQ0) 
        ALFA2 = ALFA2Q(IQ0) 
        SUM   = 0. 
        NF    = NFMAP(IQ0) 
        DO 220 IX = NXX,IX0+1,-1 
          WFF1  = WGTFF1(IWADR(IX,IX0)) 
          WNS2  = WGTNS2(IWADR(IX,IX0),NF) 
          SUM   = SUM + (ALFAS*WFF1+ALFA2*WNS2) * FNSQCD(IX,IQ0) 
  220   CONTINUE 
        WGT = ALFAS*WGTFF1(IWADR(IX0,IX0)) +                            &
     &        ALFA2*WGTNS2(IWADR(IX0,IX0),NF)                           
        DNS = WGT*FNS + SUM 
                                                                        
        FNS0 = FNS 
        DNS0 = DNS 
        FNSQCD(IX0,IQ0) = FNS 
        DNSQCD(IX0,IQ0) = DNS 
        EVL             = EVL+NXX-IX0+1 
                                                                        
        DO 250 IQ = IQ0+1,IQH 
          IF(IFAILC(IX0,IQ).NE.0) GOTO 250 
          ALFAS = ALFAPQ(IQ) 
          ALFA2 = ALFA2Q(IQ) 
          DELIQ = DELUP(IQ) 
          SUM   = 0. 
          NF    = NFMAP(IQ) 
          DO 230 IX = NXX,IX0+1,-1 
            WFF1  = WGTFF1(IWADR(IX,IX0)) 
            WNS2  = WGTNS2(IWADR(IX,IX0),NF) 
            SUM   = SUM + (ALFAS*WFF1+ALFA2*WNS2) *  FNSQCD(IX,IQ) 
  230     CONTINUE 
          WGT = ALFAS*WGTFF1(IWADR(IX0,IX0)) +                          &
     &          ALFA2*WGTNS2(IWADR(IX0,IX0),NF)                         
          FNS = ( 2.*FNS + (DNS+SUM)*DELIQ ) / ( 2. - WGT*DELIQ ) 
          DNS = WGT*FNS + SUM 
          FNSQCD(IX0,IQ) = FNS 
          DNSQCD(IX0,IQ) = DNS 
          EVL            = EVL+NXX-IX0+1 
  250   CONTINUE 
                                                                        
        FNS = FNS0 
        DNS = DNS0 
                                                                        
        DO 270 IQ = IQ0-1,IQL,-1 
          ALFAS = ALFAPQ(IQ) 
          ALFA2 = ALFA2Q(IQ) 
          DELIQ = DELDN(IQ) 
          SUM   = 0. 
          NF  = NFMAP(IQ) 
          DO 260 IX = NXX,IX0+1,-1 
            WFF1  = WGTFF1(IWADR(IX,IX0)) 
            WNS2  = WGTNS2(IWADR(IX,IX0),NF) 
            SUM   = SUM + (ALFAS*WFF1+ALFA2*WNS2) * FNSQCD(IX,IQ) 
  260     CONTINUE 
          WGT = ALFAS*WGTFF1(IWADR(IX0,IX0)) +                          &
     &          ALFA2*WGTNS2(IWADR(IX0,IX0),NF)                         
          FNS = ( 2.*FNS + (DNS+SUM)*DELIQ ) / ( 2. - WGT*DELIQ ) 
          DNS = WGT*FNS + SUM 
          FNSQCD(IX0,IQ) = FNS 
          DNSQCD(IX0,IQ) = DNS 
          EVL            = EVL+NXX-IX0+1 
  270   CONTINUE 
                                                                        
!     ----------                                                        
               !                                                        
      END DO 
!     ----------                                                        
                                                                        
      EVL = EVL*2./(NXX*(NXX+1)*NQ2) 
                                                                        
      CALL QNTRUE(LE_DONE,NXX) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNPGET.                                                     
                                                                        
!     ============================================                      
      DOUBLE PRECISION FUNCTION QNPGET(NAME,IX,IQ) 
!     ============================================                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) NAME 
                                                                        
!---  Obsolete (21/05/96): use QPDFIJ instead                           
                                                                        
      QNPGET = QPDFIJ(NAME,IX,IQ,IFL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QPDFIJ.                                                     
                                                                        
!     ================================================                  
      DOUBLE PRECISION FUNCTION QPDFIJ(UNAM,IX,IQ,IFL) 
!     ================================================                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!---  Returns parton distribution 'NAME' at gridpoint IX,IQ             
!---  Output IFL =  0 : Inside grid or cuts                             
!---               -1 : Outside grid or cuts                            
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAME 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('QPDFIJ ',0) 
                                                                        
      QPDFIJ = 0. 
      IERR   = 0 
      IFL    = 0 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
      IF(IX.LT.1.OR.IX.GT.MXX-1 .OR.                                    &
     &   IQ.LT.1.OR.IQ.GT.MQ2-1) THEN                                   
        IERR =  2 
        IFL  = -1 
        IF(LIMCK) GOTO 500 
        RETURN 
      ENDIF 
      IF(IFAILC(IX,IQ).NE.0)   THEN 
        IERR =  2 
        IFL  = -1 
        IF(LIMCK) GOTO 500 
        RETURN 
      ENDIF 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
                                                                        
      NF = NFMAP(IQ) 
      ID = IDCHEK(NAME,NF,'QPDFIJ',1) 
                                                                        
      IF(ID.EQ.-1) RETURN 
                                                                        
      QPDFIJ = GET_PDFIJ(ID,IX,IQ) 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QPDFIJ ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NAME : '',A)') UNAM 
      WRITE(6,'( ''       IX   : '',I5)') IX 
      WRITE(6,'( ''       IQ   : '',I5)') IQ 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid defined'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' IX and/or IQ outside grid or cuts'')') 
        IDUM = ICUTIJ(IX,IQ,1) 
      ENDIF 
                                                                        
      CALL QTRACE('QPDFIJ ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, PARTXQ.                                                     
                                                                        
!     ===================================                               
      SUBROUTINE PARTXQ(NAME,X,Q,VAL,IFL) 
!     ===================================                               
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) NAME 
                                                                        
!---  Obsolete (21/05/96): use QPDFXQ instead                           
                                                                        
      VAL = QPDFXQ(NAME,X,Q,IFL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QPDFXQ.                                                     
                                                                        
!     ==============================================                    
      DOUBLE PRECISION FUNCTION QPDFXQ(UNAM,X,Q,IFL) 
!     ==============================================                    
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!---  Returns parton distribution 'NAME' at X,Q                         
!---  Output IFL =  0 : Inside grid                                     
!---               -1 : Outside grid or cuts                            
                                                                        
      CHARACTER*(*) UNAM 
      CHARACTER*5   NAME 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CALL QTRACE('QPDFXQ ',0) 
                                                                        
      VAL    = 0. 
      IFL    = 0 
      QPDFXQ = 0. 
                                                                        
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR =  1 
        IFL  = -1 
        GOTO 500 
      ENDIF 
      JFL = ICUTXQ(X,Q,0) 
      IF(JFL.NE.0) THEN 
        IERR =  2 
        IFL  = -1 
        IF(LIMCK) GOTO 500 
        RETURN 
      ENDIF 
                                                                        
      IX  = ABS(IXFROMX(X)) 
      IQ  = MIN(ABS(IQFROMQ(Q)),NQ2-1) 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
                                                                        
      NF  = NFMAP(IQ) 
      ID  = IDCHEK(NAME,NF,'QPDFXQ',1) 
                                                                        
      IF(.NOT.LDQ2OK) CALL QDELQ2 
                                                                        
      TX  = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX)) 
      TQ  = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
                                                                        
      QPDFXQ = GET_PDFXQ(ID,IX,IQ,TX,TQ) 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r QPDFXQ ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input NAME : '',A)') UNAM 
      WRITE(6,'( ''       X    : '',E12.5)') X 
      WRITE(6,'( ''       Q2   : '',E12.5)') Q 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' No x-Q2 grid defined'')') 
      ELSEIF(IERR.EQ.2) THEN 
        WRITE(6,'(/'' X and/or Q2 outside grid or cuts'')') 
        IDUM = ICUTXQ(X,Q,1) 
      ENDIF 
                                                                        
      CALL QTRACE('QPDFXQ ',1) 
                                                                        
      STOP 
      END                                           
                                                                        
!DECK  ID>, GET_PDFIJ.                                                  
                                                                        
!     =============================================                     
      DOUBLE PRECISION FUNCTION GET_PDFIJ(ID,IX,IQ) 
!     =============================================                     
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Return parton distribution ID at IX,IQ.                           
!--   IX should be in the range 1,...NXX.                               
!--   IQ should be in the range 1,...NQ2.                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      GET_PDFIJ = 0. 
                                                                        
      NF = NFMAP(IQ) 
                                                                        
      DO I = 0,10 
        GET_PDFIJ = GET_PDFIJ + PWGT(I,ID,NF)*PDFQCD(IX,IQ,I) 
      ENDDO 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GET_PDFXQ.                                                  
                                                                        
!     ===================================================               
      DOUBLE PRECISION FUNCTION GET_PDFXQ(ID,IX,IQ,TX,TQ) 
!     ===================================================               
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Return parton distribution ID at X,Q.                             
!--   IX gridpoint at or below x; should be in the range 1,...NXX.      
!--   IQ gridpoint at or below Q; should be in the range 1,...NQ2-1.    
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      F11  = GET_PDFIJ(ID,IX,IQ) 
      F12  = GET_PDFIJ(ID,IX,IQ+1) 
      F21  = GET_PDFIJ(ID,IX+1,IQ) 
      F22  = GET_PDFIJ(ID,IX+1,IQ+1) 
      F1   = (1.-TQ)*F11 + TQ*F12 
      F2   = (1.-TQ)*F21 + TQ*F22 
                                                                        
      GET_PDFXQ  = (1.-TX)*F1 + TX*F2 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, BKFAST.                                                     
                                                                        
!     ==============================                                    
      SUBROUTINE BKFAST(IDF,ID,IERR) 
!     ==============================                                    
                                                                        
!---  Book the NDFMAX arrays available for STFAST storage.              
!---  Called by STFAST.                                                 
!---  Input  : IDF = structure function identifier;                     
!---            1  2   3   4   5   6   7                                
!---           F2 FL xF3 F2c Flc F2b Flb                                
!---           ID = parton dist identifier (1-30).                      
!---  Output : set IDFAST(IDF,ID) = j; the results of                   
!---           STFAST for the combination IDF,ID are                    
!---           stored in FSTORE(ix,iq,j).                               
!---           If j.gt.NDFMAX (no more space) then BKFAST               
!---           acts as a do-nothing & sets ierr .ne. 0.                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      IERR = 0 
      IF(IDFAST(IDF,ID).EQ.0) THEN 
        IF(NDFAST.EQ.30+NDFMAX) THEN 
          IERR = 1 
          RETURN 
        ENDIF 
        NDFAST = NDFAST + 1 
        IDFAST(IDF,ID) = NDFAST 
        ISTFID(NDFAST) = IDF 
        IPDFID(NDFAST) = ID 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, STFAST.                                                     
                                                                        
!     ===========================                                       
      SUBROUTINE STFAST(OPT,UNAM) 
!     ===========================                                       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT,UNAM 
      CHARACTER*5   NAME 
      CHARACTER*5   OPT5 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      IF(LTIME) CALL TIMEX_LHA(T_START(6)) 
                                                                        
      CALL QTRACE('STFAST ',0) 
                                                                        
      IERR = 0 
      IF(.NOT.LMARK) THEN 
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
      CALL QSTRIP(OPT ,OPT5) 
                                                                        
      JX  = 0 
      JQ  = 0 
      XX  = 0. 
      QQ  = 0. 
      IDF = IFCHEK(OPT5,NAME,JX,JQ,XX,QQ,'STFAST',1,ID) 
                                                                        
      IF(.NOT.LALFOK) CALL QFILAS('STFAST') 
      IF(.NOT.LDQ2OK) CALL QDELQ2 
                                                                        
      IF(IDF.GE.1.AND.IDF.LE.7) THEN 
        CALL BKFAST(IDF,ID,IERR) 
        IF(IERR.NE.0) THEN 
          LFFCAL(IDF,ID) = .FALSE. 
          RETURN 
        ENDIF 
      ELSE 
        IERR = 10 
        GOTO 500 
      ENDIF 
                                                                        
      IF    (IDF.EQ.1)  THEN 
        CALL FASTF2(ID) 
      ELSEIF(IDF.EQ.2)  THEN 
        CALL FASTFL(ID) 
      ELSEIF(IDF.EQ.3)  THEN 
        CALL FASTF3(ID) 
      ELSE 
        CALL FASTFKH(IDF,ID) 
      ENDIF 
                                                                        
      IF(LTIME) THEN 
        CALL TIMEX_LHA(T_END(6)) 
        T_SPENT(6) = T_SPENT(6)+T_END(6)-T_START(6) 
        N_CALLS(6) = N_CALLS(6)+1 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r STFAST ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input OPT  : '',A)') OPT 
      WRITE(6,'( '' Input NAME : '',A)') UNAM 
      IF(IERR.EQ.1) THEN 
        WRITE(6,                                                        &
     &  '(/'' No gridpoints marked for fast calculation''/              &
     &     '' Please call s/r QFMARK before STFAST'')')                 
      ELSEIF(IERR.EQ.10) THEN 
        WRITE(6,'(/'' Unknown input option OPT'')') 
      ENDIF 
                                                                        
      CALL QTRACE('STFAST ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, FASTF2.                                                     
                                                                        
!     =====================                                             
      SUBROUTINE FASTF2(ID) 
!     =====================                                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DIMENSION QUARKS(MXX),GLUONS(MXX) 
                                                                        
!--   Get adress where to store F2                                      
      JD = IDFAST(1,ID) 
                                                                        
!--   Loop over all Q2 gridpoints                                       
      DO 100 IQ = 1,NQ2 
                                                                        
!--     Initialise FSTORE and get minimum value of x                    
        IXMIN = 999999 
        DO IX = 1,NXX 
          FSTORE(IX,IQ,JD) = -401. 
          IF(MARKFF(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX) 
        ENDDO 
                                                                        
!--     Is this Q2 gridpoint marked?                                    
        IF(MARKQQ(IQ).NE.1) EXIT
                                                                        
!--     Get scale and check if inside Q2 gridboundaries                 
        QMU   = Q2TAB(IQ)*AAM2L + BBM2L 
        IMU   = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
        IF(IMU.EQ.0) EXIT
        QR2   = QMU*AAAR2 + BBBR2 
        IR2   = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
        IF(IR2.EQ.0) EXIT 
                                                                        
!--     Calculate F2 for all marked gridpoints                          
        FACT = LOG(Q2TAB(IQ)/QMU) 
        NF   = NFMAP(IMU) 
        TX   = 0. 
        TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
        TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
        AS   = GET_AS(IR2,TR) 
        DO IX0 = NXX,IXMIN,-1 
          GLUONS(IX0) = GET_PDFXQ( 0,IX0,IMU,TX,TQ) 
          QUARKS(IX0) = GET_PDFXQ(ID,IX0,IMU,TX,TQ) 
          IF(MARKFF(IX0,IQ).EQ.1) THEN 
            FFF0 = QUARKS(IX0) 
            IF(IORD.EQ.1) THEN 
              FSTORE(IX0,IQ,JD) = FFF0 
            ELSE 
              FF = 0. 
              DO IX = IX0,NXX 
                FF = FF +                                               &
     &              (WGTC2Q(IWADR(IX,IX0))+                             &
     &               WGTFF1(IWADR(IX,IX0))*FACT)*QUARKS(IX) +           &
     &              (WGTC2G(IWADR(IX,IX0),NF)+                          &
     &               WGTFG1(IWADR(IX,IX0),NF)*FACT)*                    &
     &               GLUONS(IX)*PWGT(1,ID,NF)                           
              ENDDO 
              FSTORE(IX0,IQ,JD) = FFF0 + AS*FF 
            ENDIF 
          ENDIF 
        ENDDO 
        FSTORE(NXX+1,IQ,JD) = 0. 
                                                                        
  100 END DO 
                                                                        
!--   Mark F2 calculated for pdf ID                                     
      LFFCAL(1,ID) = .TRUE. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FASTFL.                                                     
                                                                        
!     =====================                                             
      SUBROUTINE FASTFL(ID) 
!     =====================                                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DIMENSION QUARKS(MXX),GLUONS(MXX) 
                                                                        
!--   Get adress where to store FL                                      
      JD = IDFAST(2,ID) 
                                                                        
!--   Loop over all Q2 gridpoints                                       
      DO 100 IQ = 1,NQ2 
                                                                        
!--     Initialise FSTORE and get minimum value of x                    
        IXMIN = 999999 
        DO IX = 1,NXX 
          FSTORE(IX,IQ,JD) = -401. 
          IF(MARKFF(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX) 
        ENDDO 
                                                                        
!--     Is this Q2 gridpoint marked?                                    
        IF(MARKQQ(IQ).NE.1) EXIT
                                                                        
!--     Get scale and check if inside Q2 gridboundaries                 
        QMU  = Q2TAB(IQ)*AAM2L + BBM2L 
        IMU  = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
        IF(IMU.EQ.0) EXIT
        QR2   = QMU*AAAR2 + BBBR2 
        IR2   = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
        IF(IR2.EQ.0) EXIT 
                                                                        
!--     Calculate FL for all marked gridpoints                          
        FACT = LOG(Q2TAB(IQ)/QMU)*FL_FAC 
        NF   = NFMAP(IMU) 
        TX   = 0. 
        TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
        TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
        AS   = GET_AS(IR2,TR) 
        DO IX0 = NXX,IXMIN,-1 
          GLUONS(IX0) = GET_PDFXQ( 0,IX0,IMU,TX,TQ) 
          QUARKS(IX0) = GET_PDFXQ(ID,IX0,IMU,TX,TQ) 
          IF(MARKFF(IX0,IQ).EQ.1) THEN 
            FFF0 = 0. 
            IF(IORD.EQ.1) THEN 
              FSTORE(IX0,IQ,JD) = 0. 
            ELSE 
              FF = 0. 
              DO IX = IX0,NXX 
                FF = FF +                                               &
     &              (WGTCLQ(IWADR(IX,IX0))+                             &
     &               WGTFF1(IWADR(IX,IX0))*FACT)*QUARKS(IX) +           &
     &              (WGTCLG(IWADR(IX,IX0),NF)+                          &
     &               WGTFG1(IWADR(IX,IX0),NF)*FACT)*                    &
     &               GLUONS(IX)*PWGT(1,ID,NF)                           
              ENDDO 
              FSTORE(IX0,IQ,JD) = FFF0 + AS*FF 
            ENDIF 
          ENDIF 
        ENDDO 
        FSTORE(NXX+1,IQ,JD) = 0. 
                                                                        
  100 END DO 
                                                                        
!--   Mark FL calculated for pdf ID                                     
      LFFCAL(2,ID) = .TRUE. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FASTF3.                                                     
                                                                        
!     =====================                                             
      SUBROUTINE FASTF3(ID) 
!     =====================                                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DIMENSION QUARKS(MXX) 
                                                                        
!--   Get adress where to store F3                                      
      JD = IDFAST(3,ID) 
                                                                        
!--   Loop over all Q2 gridpoints                                       
      DO 100 IQ = 1,NQ2 
                                                                        
!--     Initialise FSTORE and get minimum value of x                    
        IXMIN = 999999 
        DO IX = 1,NXX 
          FSTORE(IX,IQ,JD) = -401. 
          IF(MARKFF(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX) 
        ENDDO 
                                                                        
!--     Is this Q2 gridpoint marked?                                    
        IF(MARKQQ(IQ).NE.1) EXIT
                                                                        
!--     Get scale and check if inside Q2 gridboundaries                 
        QMU  = Q2TAB(IQ)*AAM2L + BBM2L 
        IMU  = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
        IF(IMU.EQ.0) EXIT
        QR2   = QMU*AAAR2 + BBBR2 
        IR2   = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
        IF(IR2.EQ.0) EXIT
                                                                        
!--     Calculate F3 for all marked gridpoints                          
        FACT = LOG(Q2TAB(IQ)/QMU) 
        TX   = 0. 
        TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
        TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
        AS   = GET_AS(IR2,TR) 
        DO IX0 = NXX,IXMIN,-1 
          QUARKS(IX0) = GET_PDFXQ(ID,IX0,IMU,TX,TQ) 
          IF(MARKFF(IX0,IQ).EQ.1) THEN 
            FFF0 = QUARKS(IX0) 
            IF(IORD.EQ.1) THEN 
              FSTORE(IX0,IQ,JD) = FFF0 
            ELSE 
              FF = 0. 
              DO IX = IX0,NXX 
                FF = FF +                                               &
     &              (WGTC3Q(IWADR(IX,IX0))+                             &
     &               WGTFF1(IWADR(IX,IX0))*FACT)*QUARKS(IX)             
              ENDDO 
              FSTORE(IX0,IQ,JD) = FFF0 + AS*FF 
            ENDIF 
          ENDIF 
        ENDDO 
        FSTORE(NXX+1,IQ,JD) = 0. 
                                                                        
  100 END DO 
                                                                        
!--   Mark F3 calculated for pdf ID                                     
      LFFCAL(3,ID) = .TRUE. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FASTFKH.                                                    
                                                                        
!     ==========================                                        
      SUBROUTINE FASTFKH(IDF,ID) 
!     ==========================                                        
                                                                        
!--   IDF   = 4,5,6,7 for F2c,FLc,F2b,FLb                               
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WH_C0KG,WH_C1KG,WH_C1BKG,                                         &
     &WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ                                 
                                                                        
      COMMON/QCHWGT/                                                    &
     &WH_C0KG(0:MXX,MQ2,4:7),                                           &
     &WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),                   &
     &WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),                   &
     &WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)                    
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      DIMENSION QU(MXX),GL(MXX),SI(MXX) 
                                                                        
!--   Correct quark mass                                                
      QMASS = CBMSTF(IDF) 
      CCCC  = CHARGE(IDF) 
                                                                        
!--   Get adress where to store FKH                                     
      JD = IDFAST(IDF,ID) 
                                                                        
!--   FKH in LO                                                         
      IF(IORD.EQ.1) THEN 
                                                                        
        DO 100 IQ = 1,NQ2 
          IXMIN = 999999 
          DO IX = 1,NXX 
            FSTORE(IX,IQ,JD) = -401. 
            IF(MARKFH(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX) 
          ENDDO 
          IF(MARKQQ(IQ).NE.1) GOTO 100 
          QMU = Q2TAB(IQ)*AAM2H + BBM2H 
          IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
          IF(IMU.EQ.0) GOTO 100 
          QR2 = QMU*AAAR2 + BBBR2 
          IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
          IF(IR2.EQ.0) GOTO 100 
          TQ = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
          TR = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
          AS = GET_AS(IR2,TR) 
          DO IX0 = NXX,IXMIN,-1 
            IXL     = IHTAB(IX0) 
            X       = XHTAB(IX0) 
            TX      = (X-XXTAB(IXL))/(XXTAB(IXL+1)-XXTAB(IXL)) 
            GL(IX0) = GET_PDFXQ( 0,IXL,IMU,TX,TQ) 
            IF(MARKFH(IX0,IQ).EQ.1) THEN 
              FF   = 0. 
              DO IX = IX0,NXX 
                FF     = FF   +                                         &
     &            WH_C0KG(IX-IX0,IQ,IDF)*GL(IX)                         
              ENDDO 
              FSTORE(IX0,IQ,JD) = CCCC*AS*FF 
            ENDIF 
          ENDDO 
          FSTORE(NXX+1,IQ,JD) = 0. 
  100   CONTINUE 
                                                                        
                                                                        
!--   FKH in NLO                                                        
      ELSE 
                                                                        
        DO 200 IQ = 1,NQ2 
          IXMIN = 999999 
          DO IX = 1,NXX 
            FSTORE(IX,IQ,JD) = -401. 
            IF(MARKFH(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX) 
          ENDDO 
          IF(MARKQQ(IQ).NE.1) GOTO 200 
          QMU = Q2TAB(IQ)*AAM2H + BBM2H 
          IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
          IF(IMU.EQ.0) GOTO 200 
          QR2 = QMU*AAAR2 + BBBR2 
          IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
          IF(IR2.EQ.0) GOTO 200 
          TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
          TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
          AS   = GET_AS(IR2,TR) 
          FACT = LOG(QMU/(QMASS*QMASS)) 
          DO IX0 = NXX,IXMIN,-1 
            IXL     = IHTAB(IX0) 
            X       = XHTAB(IX0) 
            TX      = (X-XXTAB(IXL))/(XXTAB(IXL+1)-XXTAB(IXL)) 
            GL(IX0) = GET_PDFXQ( 0,IXL,IMU,TX,TQ) 
            SI(IX0) = GET_PDFXQ( 1,IXL,IMU,TX,TQ) 
            QU(IX0) = GET_PDFXQ(ID,IXL,IMU,TX,TQ) 
            IF(MARKFH(IX0,IQ).EQ.1) THEN 
              F1 = 0. 
              F2 = 0. 
              F3 = 0. 
              F4 = 0. 
              DO IX = IX0,NXX 
                I    = IX-IX0 
                F1   = F1 +                                             &
     &          WH_C0KG(I,IQ,IDF)*GL(IX)                                
                F2   = F2 +                                             &
     &         (WH_C1KG(I,IQ,IDF)+WH_C1BKG(I,IQ,IDF)*FACT)*GL(IX)       
                F3   = F3 +                                             &
     &         (WH_C1KQ(I,IQ,IDF)+WH_C1BKQ(I,IQ,IDF)*FACT)*SI(IX)       
                F4   = F4 +                                             &
     &         (WH_D1KQ(I,IQ,IDF)+WH_D1BKQ(I,IQ,IDF)*FACT)*QU(IX)       
              ENDDO 
              FSTORE(IX0,IQ,JD) = CCCC *                                &
     &          (AS*F1+AS*AS*(F2+F3)) + AS*AS*F4                        
            ENDIF 
          ENDDO 
          FSTORE(NXX+1,IQ,JD) = 0. 
  200   CONTINUE 
                                                                        
      ENDIF 
                                                                        
      LFFCAL(IDF,ID) = .TRUE. 
                                                                        
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNFGET.                                                     
                                                                        
!     ================================================                  
      DOUBLE PRECISION FUNCTION QNFGET(OPT,NAME,IX,IQ) 
!     ================================================                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT,NAME 
                                                                        
!---  Obsolete (16/07/96): use QSTFIJ instead                           
                                                                        
      QNFGET = QSTFIJ(OPT,NAME,IX,IQ,IFL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QSTFIJ.                                                     
                                                                        
!     ====================================================              
      DOUBLE PRECISION FUNCTION QSTFIJ(OPT,UNAM,IX,IQ,IFL) 
!     ====================================================              
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!---  Returns stf 'OPT' from pdf 'NAME' at gridpoint IX,IQ              
!---  IFL =  0 : F2 sucessfully calculated                              
!---         1 : Fast calculation                                       
!---        -1 : Scale mu outside grid                                  
                                                                        
      CHARACTER*(*) OPT,UNAM 
      CHARACTER*5   NAME 
      CHARACTER*5   OPT5 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CALL QTRACE('QSTFIJ ',0) 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
      CALL QSTRIP(OPT ,OPT5) 
                                                                        
      QSTFIJ = 0. 
      IFL    = 0 
      X      = 0. 
      Q      = 0. 
      IERR   = IFCHEK(OPT5,NAME,IX,IQ,X,Q,'QSTFIJ',1,ID) 
                                                                        
!--   Outside grid or cuts?                                             
      IF(IERR.EQ.-2) THEN 
        IFL  = -1 
        RETURN 
      ENDIF 
                                                                        
      IF(.NOT.LALFOK) CALL QFILAS('QSTFIJ') 
      IF(.NOT.LDQ2OK) CALL QDELQ2 
                                                                        
      IF(IERR.EQ.1) THEN 
        QSTFIJ = GET_F2(ID,IX,IQ,IFL) 
        IFCNT(IFL,1) = IFCNT(IFL,1)+1 
      ELSEIF(IERR.EQ.2) THEN 
        QSTFIJ = GET_FL(ID,IX,IQ,IFL) 
        IFCNT(IFL,2) = IFCNT(IFL,2)+1 
      ELSEIF(IERR.EQ.3) THEN 
        QSTFIJ = GET_F3(ID,IX,IQ,IFL) 
        IFCNT(IFL,3) = IFCNT(IFL,3)+1 
!---  Use GETFKH instead of GET_FKH for the heavy quarks since          
!---  we have to interpolate on the heavy quark grid.                   
      ELSEIF(IERR.EQ.4) THEN 
        CALL GETFKH(4,ID,XXTAB(IX),Q2TAB(IQ),QSTFIJ,IFL) 
        IFCNT(IFL,4) = IFCNT(IFL,4)+1 
      ELSEIF(IERR.EQ.5) THEN 
        CALL GETFKH(5,ID,XXTAB(IX),Q2TAB(IQ),QSTFIJ,IFL) 
        IFCNT(IFL,5) = IFCNT(IFL,5)+1 
      ELSEIF(IERR.EQ.6) THEN 
        CALL GETFKH(6,ID,XXTAB(IX),Q2TAB(IQ),QSTFIJ,IFL) 
        IFCNT(IFL,4) = IFCNT(IFL,4)+1 
      ELSEIF(IERR.EQ.7) THEN 
        CALL GETFKH(7,ID,XXTAB(IX),Q2TAB(IQ),QSTFIJ,IFL) 
        IFCNT(IFL,5) = IFCNT(IFL,5)+1 
      ENDIF 
                                                                        
      RETURN 
                                                                        
      END                                           
                                                                        
!DECK  ID>, STRFXQ.                                                     
                                                                        
!     =======================================                           
      SUBROUTINE STRFXQ(OPT,NAME,X,Q,VAL,IFL) 
!     =======================================                           
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT,NAME 
                                                                        
!---  Obsolete (16/07/96): use QSTFXQ instead                           
                                                                        
      VAL = QSTFXQ(OPT,NAME,X,Q,IFL) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QSTFXQ.                                                     
                                                                        
!     ==================================================                
      DOUBLE PRECISION FUNCTION QSTFXQ(OPT,UNAM,X,Q,IFL) 
!     ==================================================                
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
!---  IFL =  0 : F2 sucessfully calculated                              
!---         1 : Fast calculation                                       
!---        -1 : Scale mu outside grid                                  
                                                                        
      CHARACTER*(*) OPT,UNAM 
      CHARACTER*5   NAME 
      CHARACTER*5   OPT5 
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      CALL QTRACE('QSTFXQ ',0) 
                                                                        
      CALL QSTRIP(UNAM,NAME) 
      CALL QSTRIP(OPT ,OPT5) 
                                                                        
      QSTFXQ = 0. 
      IFL    = 0 
      IERR   = IFCHEK(OPT5,NAME,0,0,X,Q,'QSTFXQ',1,ID) 
                                                                        
!--   Outside grid or cuts?                                             
      IF(IERR.EQ.-2) THEN 
        IFL = -1 
        RETURN 
      ENDIF 
                                                                        
      IF(.NOT.LALFOK) CALL QFILAS('QSTFXQ') 
      IF(.NOT.LDQ2OK) CALL QDELQ2 
                                                                        
      IF    (IERR.EQ.1) THEN 
        CALL GETF2(ID,X,Q,STRF,IFL) 
        IFCNT(IFL,1) = IFCNT(IFL,1)+1 
      ELSEIF(IERR.EQ.2) THEN 
        CALL GETFL(ID,X,Q,STRF,IFL) 
        IFCNT(IFL,2) = IFCNT(IFL,2)+1 
      ELSEIF(IERR.EQ.3) THEN 
        CALL GETF3(ID,X,Q,STRF,IFL) 
        IFCNT(IFL,3) = IFCNT(IFL,3)+1 
      ELSEIF(IERR.EQ.4) THEN 
        CALL GETFKH(4,ID,X,Q,STRF,IFL) 
        IFCNT(IFL,4) = IFCNT(IFL,4)+1 
      ELSEIF(IERR.EQ.5) THEN 
        CALL GETFKH(5,ID,X,Q,STRF,IFL) 
        IFCNT(IFL,5) = IFCNT(IFL,5)+1 
      ELSEIF(IERR.EQ.6) THEN 
        CALL GETFKH(6,ID,X,Q,STRF,IFL) 
        IFCNT(IFL,4) = IFCNT(IFL,4)+1 
      ELSEIF(IERR.EQ.7) THEN 
        CALL GETFKH(7,ID,X,Q,STRF,IFL) 
        IFCNT(IFL,5) = IFCNT(IFL,5)+1 
      ENDIF 
                                                                        
      QSTFXQ = STRF 
                                                                        
      RETURN 
                                                                        
      END                                           
                                                                        
!DECK  ID>, IFCHEK.                                                     
                                                                        
!     ============================================================      
      INTEGER FUNCTION IFCHEK(OPT,NAME,JX,JQ,XX,QQ,SRNAM,ISTOP,ID) 
!     ============================================================      
                                                                        
!---  Check for structure function calculation                          
                                                                        
!---  IFCHEK = -5: Q2 < 1.5 GeV2 for heavy quark stfs                   
!---           -4: No weight tables                                     
!---           -3: Input NAME corresponds to gluon                      
!---           -2: x,Q2,M2,R2 outside grid or cuts                      
!---           -1: No x,Q2 grid available                               
!---            0: Unknown option                                       
!---          1-7: F2, FL, xF3, F2c, FLc, F2b, FLb                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*5   OPT 
      CHARACTER*5   NAME 
      CHARACTER*6   SRNAM 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL LTIME 
      REAL T_START,T_END,T_SPENT 
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),      &
     &E_CALLS(10),LTIME                                                 
      COMMON/QCFCNT/IFCNT(-1:1,5) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
                                                                        
!--   Check if valid option                                             
      IERR   = IDFCHK(OPT) 
      IF(IERR.EQ.0) GOTO 500 
      JJ = IERR 
      IF(IERR.EQ.6) JJ = 4 
      IF(IERR.EQ.7) JJ = 5 
                                                                        
!--   Check x,Q2 grid available                                         
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN 
        IERR = -1 
        GOTO 500 
      ENDIF 
                                                                        
      IF(SRNAM.NE.'STFAST') THEN 
!--   --------------------------                                        
                                                                        
!--     Get x, Q2                                                       
        IF(SRNAM.EQ.'QSTFIJ') THEN 
          X = XFROMIX(JX) 
          Q = QFROMIQ(JQ) 
        ELSE 
          X = XX 
          Q = QQ 
        ENDIF 
                                                                        
!--     Check x,Q2 inside grid                                          
        QP  = Q 
        IX  = ABS(IXFROMX(X)) 
        IQ  = MIN(ABS(IQFROMQ(Q)),NQ2-1) 
        IF(IX.EQ.0.OR.IQ.EQ.0)  THEN 
          IFCNT(-1,JJ) = IFCNT(-1,JJ)+1 
          IERR = -2 
          GOTO 500 
        ENDIF 
                                                                        
!--     Check factorisation scale inside grid or cuts                   
        IF(IERR.LE.3) THEN 
          QM = AAM2L*Q + BBM2L 
        ELSE 
          QM = AAM2H*Q + BBM2H 
        ENDIF 
        QP   = QM 
        IFLG = ICUTXQ(X,QP,0) 
        IF(IFLG.NE.0) THEN 
          IFCNT(-1,JJ) = IFCNT(-1,JJ)+1 
          IERR = -2 
          GOTO 500 
        ENDIF 
        IM2 = MIN(ABS(IQFROMQ(QM)),NQ2-1) 
                                                                        
!--     Check renormalisation scale inside grid and above Lamba2        
        QR  = AAAR2*QM + BBBR2 
        QP  = QR 
        IR2 = MIN(ABS(IQFROMQ(QR)),NQ2-1) 
        IF(IR2.EQ.0 .OR. IFLG.GE.10000)  THEN 
          IFCNT(-1,JJ) = IFCNT(-1,JJ)+1 
          IERR = -2 
          GOTO 500 
        ENDIF 
                                                                        
!--     Check if the parton distribution is booked                      
        ID = IDCHEK(NAME,NFMAP(IQ)   ,SRNAM,1) 
        ID = IDCHEK(NAME,NFMAP(IQ+1) ,SRNAM,1) 
        ID = IDCHEK(NAME,NFMAP(IM2)  ,SRNAM,1) 
        ID = IDCHEK(NAME,NFMAP(IM2+1),SRNAM,1) 
        ID = IDCHEK(NAME,NFMAP(IR2)  ,SRNAM,1) 
        ID = IDCHEK(NAME,NFMAP(IR2+1),SRNAM,1) 
                                                                        
      ELSE 
!--   ----                                                              
                                                                        
!--     Check if the parton distribution is booked                      
        NFMIN = NFMAP(1) 
        NFMAX = NFMAP(NQ2) 
        DO NF = NFMIN,NFMAX 
          ID = IDCHEK(NAME,NF,'STFAST',1) 
        ENDDO 
                                                                        
      ENDIF 
!--   -----                                                             
                                                                        
!--   No structure functions from the gluon                             
      IF(ID.EQ.0) THEN 
        IERR = -3 
        GOTO 500 
      ENDIF 
                                                                        
!--   Check if the weight tables are available                          
      IF(IERR.LE.3) THEN 
        IF(IORD.EQ.2.AND..NOT.LWTFOK) THEN 
          IERR = -4 
          GOTO 500 
        ENDIF 
      ELSEIF(IERR.EQ.4) THEN 
        IF(.NOT.LWFCOK) THEN 
          IERR = -4 
          GOTO 500 
        ENDIF 
      ELSEIF(IERR.EQ.5) THEN 
        IF(.NOT.LWLCOK) THEN 
          IERR = -4 
          GOTO 500 
        ENDIF 
      ELSEIF(IERR.EQ.6) THEN 
        IF(.NOT.LWFBOK) THEN 
          IERR = -4 
          GOTO 500 
        ENDIF 
      ELSEIF(IERR.EQ.7) THEN 
        IF(.NOT.LWLBOK) THEN 
          IERR = -4 
          GOTO 500 
        ENDIF 
      ENDIF 
                                                                        
!--   Check low Q2 for heavy quarks                                     
      IF(SRNAM.NE.'STFAST') THEN 
        IF(IERR.GE.4) THEN 
          IF(LCLOWQ.AND.Q.LE.1.5) THEN 
            IERR = -5 
            GOTO 500 
          ENDIF 
        ENDIF 
      ENDIF 
                                                                        
      IFCHEK = IERR 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
                                                                        
      IFCHEK = IERR 
                                                                        
!--   Stop?                                                             
      IF(ISTOP.EQ.0) RETURN 
      IF(.NOT.LIMCK.AND.IERR.EQ.-2) RETURN 
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r '',A6,'' ---> STOP'')')         &
     &      SRNAM                                                       
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Input Opt  : '',A)')     OPT 
      WRITE(6,'( ''       Name : '',A)')     NAME 
      IF(SRNAM.NE.'STFAST') THEN 
        IF(SRNAM.EQ.'QSTFIJ') THEN 
          WRITE(6,'( ''       IX   : '',I10  )') JX 
          WRITE(6,'( ''       IQ   : '',I10  )') JQ 
        ELSE 
          WRITE(6,'( ''       x    : '',E12.5)') XX 
          WRITE(6,'( ''       Q2   : '',E12.5)') QQ 
        ENDIF 
      ENDIF 
      IF(IERR.EQ.0) THEN 
        WRITE(6,'(/'' Unknown option'')') 
      ELSEIF(IERR.EQ.-1) THEN 
        WRITE(6,'(/'' No x-Q2 grid available'')') 
      ELSEIF(IERR.EQ.-2) THEN 
        WRITE(6,'(/'' X, Q2 or mu2 outside grid or cuts'')') 
        IDUM = ICUTXQ(X,QP,1) 
      ELSEIF(IERR.EQ.-3) THEN 
        WRITE(6,'(/'' Strf from the gluon, no thank you'')') 
      ELSEIF(IERR.EQ.-4) THEN 
        WRITE(6,'(/'' No weight tables available'')') 
      ELSEIF(IERR.EQ.-5) THEN 
        WRITE(6,'(/'' Cannot calculate F2h, FLh for Q2 < 1.5 GeV2'')') 
      ENDIF 
                                                                        
      CALL QTRACE('IFCHEK ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, IDFCHK.                                                     
                                                                        
!     =============================                                     
      INTEGER FUNCTION IDFCHK(OPT5) 
!     =============================                                     
                                                                        
!--   Returns 1,2,3,4,5,6,7 for F2,Fl,xF3,F2c,FLc,F2b,FLb.              
!--   Returns 0 if no valid OPT is given on input.                      
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*5   OPT5 
                                                                        
      IDFCHK = 0 
                                                                        
      IF    (OPT5(1:3).EQ.'F2 ')  THEN 
        IDFCHK = 1 
      ELSEIF(OPT5(1:3).EQ.'FL ')  THEN 
        IDFCHK = 2 
      ELSEIF(OPT5(1:3).EQ.'XF3')  THEN 
        IDFCHK = 3 
      ELSEIF(OPT5(1:3).EQ.'F2C')  THEN 
        IDFCHK = 4 
      ELSEIF(OPT5(1:3).EQ.'FLC')  THEN 
        IDFCHK = 5 
      ELSEIF(OPT5(1:3).EQ.'F2B')  THEN 
        IDFCHK = 6 
      ELSEIF(OPT5(1:3).EQ.'FLB')  THEN 
        IDFCHK = 7 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GETF2.                                                      
                                                                        
!     ================================                                  
      SUBROUTINE GETF2(ID,X,Q,VAL,IFL) 
!     ================================                                  
                                                                        
!---  IFL =  0 : F2 sucessfully calculated                              
!---         1 : Fast calculation                                       
!---        -1 : Scale mu outside grid                                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      VAL =  0. 
      JER =  1 
      IFL = -1 
      IX = IXFROMX(X) 
      IQ = IQFROMQ(Q) 
                                                                        
      IF(IX.GT.0.AND.IQ.GT.0) THEN 
        VAL = GET_F2(ID,IX,IQ,IERR) 
        JER = MIN(JER,IERR) 
      ELSEIF(IX.GT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN 
        IQ   = -IQ 
        VAL1 = GET_F2(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_F2(ID,IX,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        VAL  = (1.-TQ)*VAL1 + TQ*VAL2 
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN 
        IX   = -IX 
        VAL1 = GET_F2(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_F2(ID,IX+1,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX)) 
        VAL  = (1.-TX)*VAL1 + TX*VAL2 
      ELSEIF(IX.LT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN 
        IX   = -IX 
        IQ   = -IQ 
        VAL1 = GET_F2(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_F2(ID,IX,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        VAL3 = GET_F2(ID,IX+1,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL4 = GET_F2(ID,IX+1,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        VAL1 = (1.-TQ)*VAL1 + TQ*VAL2 
        VAL2 = (1.-TQ)*VAL3 + TQ*VAL4 
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX)) 
        VAL  = (1.-TX)*VAL1 + TX*VAL2 
      ELSE 
        VAL  =  0. 
        JER  = -1 
      ENDIF 
                                                                        
      IFL = JER 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GET_F2.                                                     
                                                                        
!     ================================================                  
      DOUBLE PRECISION FUNCTION GET_F2(ID,IX0,IQ,IERR) 
!     ================================================                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Input:  ID      parton distribution identifier                    
!--           IX0     x gridpoint                                       
!--           Q       Q2 value                                          
!--   Output: IERR =  0 F2 successfully calculated                      
!--                =  1 Fast calculation                                
!--                = -1 Scale mu outside grid                           
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      GET_F2 = 0. 
                                                                        
      IF(LFFCAL(1,ID)) THEN 
        IERR = 1 
        JD   = IDFAST(1,ID) 
        GET_F2 = FSTORE(IX0,IQ,JD) 
        IF(GET_F2.GE.-99.) RETURN 
      ENDIF 
                                                                        
      IERR = 0 
      QMU = AAM2L*Q2TAB(IQ) + BBM2L 
      IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
      IF(IMU.EQ.0) THEN 
        IERR = -1 
        RETURN 
      ENDIF 
                                                                        
      TX   = 0. 
      TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
      FFF0 = GET_PDFXQ(ID,IX0,IMU,TX,TQ) 
                                                                        
      IF(IORD.EQ.1) THEN 
        GET_F2 = FFF0 
        RETURN 
      ENDIF 
                                                                        
      QR2 = QMU*AAAR2 + BBBR2 
      IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
      IF(IR2.EQ.0) THEN 
        IERR = -1 
        RETURN 
      ENDIF 
      TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
                                                                        
      NF   = NFMAP(IMU) 
      FACT = LOG(Q2TAB(IQ)/QMU) 
      F2   = 0. 
      DO IX = IX0,NXX 
        QU = GET_PDFXQ(ID,IX,IMU,TX,TQ) 
        GL = GET_PDFXQ( 0,IX,IMU,TX,TQ) 
        F2 = F2 +                                                       &
     &      (WGTC2Q(IWADR(IX,IX0))+                                     &
     &       WGTFF1(IWADR(IX,IX0))*FACT)*QU +                           &
     &      (WGTC2G(IWADR(IX,IX0),NF)+                                  &
     &       WGTFG1(IWADR(IX,IX0),NF)*FACT)*GL*PWGT(1,ID,NF)            
      ENDDO 
      GET_F2 = FFF0 + GET_AS(IR2,TR)*F2 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GETFL.                                                      
                                                                        
!     ================================                                  
      SUBROUTINE GETFL(ID,X,Q,VAL,IFL) 
!     ================================                                  
                                                                        
                                                                        
!---  IFL =  0 : F2 sucessfully calculated                              
!---         1 : Fast calculation                                       
!---        -1 : Scale mu outside grid                                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      VAL =  0. 
      JER =  1 
      IFL = -1 
      IX = IXFROMX(X) 
      IQ = IQFROMQ(Q) 
                                                                        
      IF(IX.GT.0.AND.IQ.GT.0) THEN 
        VAL = GET_FL(ID,IX,IQ,IERR) 
        JER = MIN(JER,IERR) 
      ELSEIF(IX.GT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN 
        IQ   = -IQ 
        VAL1 = GET_FL(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_FL(ID,IX,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        VAL  = (1.-TQ)*VAL1 + TQ*VAL2 
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN 
        IX   = -IX 
        VAL1 = GET_FL(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_FL(ID,IX+1,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX)) 
        VAL  = (1.-TX)*VAL1 + TX*VAL2 
      ELSEIF(IX.LT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN 
        IX   = -IX 
        IQ   = -IQ 
        VAL1 = GET_FL(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_FL(ID,IX,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        VAL3 = GET_FL(ID,IX+1,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL4 = GET_FL(ID,IX+1,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        VAL1 = (1.-TQ)*VAL1 + TQ*VAL2 
        VAL2 = (1.-TQ)*VAL3 + TQ*VAL4 
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX)) 
        VAL  = (1.-TX)*VAL1 + TX*VAL2 
      ELSE 
        VAL  =  0. 
        JER  = -1 
      ENDIF 
                                                                        
      IFL = JER 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GET_FL.                                                     
                                                                        
!     ================================================                  
      DOUBLE PRECISION FUNCTION GET_FL(ID,IX0,IQ,IERR) 
!     ================================================                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Input:  ID      parton distribution identifier                    
!--           IX0     x gridpoint                                       
!--           Q       Q2 value                                          
!--   Output: IERR =  0 FL successfully calculated                      
!--                =  1 Fast calculation                                
!--                = -1 Scale mu outside grid                           
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      GET_FL = 0. 
                                                                        
      IF(LFFCAL(2,ID)) THEN 
        IERR = 1 
        JD   = IDFAST(2,ID) 
        GET_FL = FSTORE(IX0,IQ,JD) 
        IF(GET_FL.GE.-99.) RETURN 
      ENDIF 
                                                                        
      IERR = 0 
                                                                        
      IF(IORD.EQ.1) THEN 
        GET_FL = 0. 
        RETURN 
      ENDIF 
                                                                        
      QMU = AAM2L*Q2TAB(IQ) + BBM2L 
      IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
      IF(IMU.EQ.0) THEN 
        IERR = -1 
        RETURN 
      ENDIF 
                                                                        
      QR2 = QMU*AAAR2 + BBBR2 
      IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
      IF(IR2.EQ.0) THEN 
        IERR = -1 
        RETURN 
      ENDIF 
                                                                        
      TX   = 0. 
      TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
      TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
                                                                        
      NF   = NFMAP(IMU) 
      FACT = LOG(Q2TAB(IQ)/QMU)*FL_FAC 
      FL   = 0. 
      DO IX = IX0,NXX 
        QU = GET_PDFXQ(ID,IX,IMU,TX,TQ) 
        GL = GET_PDFXQ( 0,IX,IMU,TX,TQ) 
        FL = FL +                                                       &
     &      (WGTCLQ(IWADR(IX,IX0))+                                     &
     &       WGTFF1(IWADR(IX,IX0))*FACT)*QU +                           &
     &      (WGTCLG(IWADR(IX,IX0),NF)+                                  &
     &       WGTFG1(IWADR(IX,IX0),NF)*FACT)*GL*PWGT(1,ID,NF)            
      ENDDO 
      GET_FL = GET_AS(IR2,TR)*FL 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GETF3.                                                      
                                                                        
!     ================================                                  
      SUBROUTINE GETF3(ID,X,Q,VAL,IFL) 
!     ================================                                  
                                                                        
                                                                        
!---  IFL =  0 : F2 sucessfully calculated                              
!---         1 : Fast calculation                                       
!---        -1 : Scale mu outside grid                                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      VAL =  0. 
      JER =  1 
      IFL = -1 
      IX = IXFROMX(X) 
      IQ = IQFROMQ(Q) 
                                                                        
      IF(IX.GT.0.AND.IQ.GT.0) THEN 
        VAL = GET_F3(ID,IX,IQ,IERR) 
        JER = MIN(JER,IERR) 
      ELSEIF(IX.GT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN 
        IQ   = -IQ 
        VAL1 = GET_F3(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_F3(ID,IX,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        VAL  = (1.-TQ)*VAL1 + TQ*VAL2 
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN 
        IX   = -IX 
        VAL1 = GET_F3(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_F3(ID,IX+1,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX)) 
        VAL  = (1.-TX)*VAL1 + TX*VAL2 
      ELSEIF(IX.LT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN 
        IX   = -IX 
        IQ   = -IQ 
        VAL1 = GET_F3(ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_F3(ID,IX,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        VAL3 = GET_F3(ID,IX+1,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL4 = GET_F3(ID,IX+1,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        VAL1 = (1.-TQ)*VAL1 + TQ*VAL2 
        VAL2 = (1.-TQ)*VAL3 + TQ*VAL4 
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX)) 
        VAL  = (1.-TX)*VAL1 + TX*VAL2 
      ELSE 
        VAL  =  0. 
        JER  = -1 
      ENDIF 
                                                                        
      IFL = JER 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GET_F3.                                                     
                                                                        
!     ================================================                  
      DOUBLE PRECISION FUNCTION GET_F3(ID,IX0,IQ,IERR) 
!     ================================================                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Input:  ID      parton distribution identifier                    
!--           IX0     x gridpoint                                       
!--           Q       Q2 value                                          
!--   Output: IERR =  0 F3 successfully calculated                      
!--                =  1 Fast calculation                                
!--                = -1 Scale mu outside grid                           
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      GET_F3 = 0. 
                                                                        
      IF(LFFCAL(3,ID)) THEN 
        IERR = 1 
        JD   = IDFAST(3,ID) 
        GET_F3 = FSTORE(IX0,IQ,JD) 
        IF(GET_F3.GE.-99.) RETURN 
      ENDIF 
                                                                        
      IERR = 0 
                                                                        
      QMU = AAM2L*Q2TAB(IQ) + BBM2L 
      IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
      IF(IMU.EQ.0) THEN 
        IERR = -1 
        RETURN 
      ENDIF 
                                                                        
      TX   = 0. 
      TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
      FFF0 = GET_PDFXQ(ID,IX0,IMU,TX,TQ) 
                                                                        
      IF(IORD.EQ.1) THEN 
        GET_F3 = FFF0 
        RETURN 
      ENDIF 
                                                                        
      QR2 = QMU*AAAR2 + BBBR2 
      IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
      IF(IR2.EQ.0) THEN 
        IERR = -1 
        RETURN 
      ENDIF 
      TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
                                                                        
      F3   = 0. 
      FACT = LOG(Q2TAB(IQ)/QMU) 
      DO IX = IX0,NXX 
        QU = GET_PDFXQ(ID,IX,IMU,TX,TQ) 
        F3 = F3 +                                                       &
     &      (WGTC3Q(IWADR(IX,IX0))+                                     &
     &       WGTFF1(IWADR(IX,IX0))*FACT)*QU                             
      ENDDO 
      GET_F3 = FFF0 + GET_AS(IR2,TR)*F3 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GETFKH.                                                     
                                                                        
!     =====================================                             
      SUBROUTINE GETFKH(IDF,ID,X,Q,VAL,IFL) 
!     =====================================                             
                                                                        
!---  Input : IDF = 4,5,6,7 for F2c,FLc,F2b,Flb                         
!---          ID  = parton distribution identifier                      
!---          X   = x value                                             
!---          Q   = Q2 value                                            
                                                                        
!---  Output: VAL = heavy quark structure function                      
!---          IFL =  0 : F2 sucessfully calculated                      
!---                 1 : Fast calculation                               
!---                -1 : Scale mu outside grid                          
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      VAL =  0. 
      IFL = -1 
                                                                        
      JER = 1 
      IX  = IHFROMH(X) 
      IQ  = IQFROMQ(Q) 
                                                                        
      IF(IX.GT.0.AND.IQ.GT.0) THEN 
        VAL = GET_FKH(IDF,ID,IX,IQ,IERR) 
        JER = MIN(JER,IERR) 
      ELSEIF(IX.GT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN 
        IQ   = -IQ 
        VAL1 = GET_FKH(IDF,ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_FKH(IDF,ID,IX,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        VAL  = (1.-TQ)*VAL1 + TQ*VAL2 
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN 
        IX   = -IX 
        VAL1 = GET_FKH(IDF,ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_FKH(IDF,ID,IX+1,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        TX   = (X-XHTAB(IX))/(XHTAB(IX+1)-XHTAB(IX)) 
        VAL  = (1.-TX)*VAL1 + TX*VAL2 
      ELSEIF(IX.LT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN 
        IX   = -IX 
        IQ   = -IQ 
        VAL1 = GET_FKH(IDF,ID,IX,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL2 = GET_FKH(IDF,ID,IX,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        VAL3 = GET_FKH(IDF,ID,IX+1,IQ,IERR) 
        JER  = MIN(JER,IERR) 
        VAL4 = GET_FKH(IDF,ID,IX+1,IQ+1,IERR) 
        JER  = MIN(JER,IERR) 
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ)) 
        VAL1 = (1.-TQ)*VAL1 + TQ*VAL2 
        VAL2 = (1.-TQ)*VAL3 + TQ*VAL4 
        TX   = (X-XHTAB(IX))/(XHTAB(IX+1)-XHTAB(IX)) 
        VAL  = (1.-TX)*VAL1 + TX*VAL2 
      ELSE 
        VAL  =  0. 
        JER  = -1 
      ENDIF 
                                                                        
      IFL = JER 
                                                                        
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FILLWF.                                                     
                                                                        
!     ====================================                              
      SUBROUTINE FILLWF(IO1,IO2,IF2,NFLAV) 
!     ====================================                              
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      EXTERNAL C2Q, C2QX0, C2G, CLQ, CLG, D3Q 
      EXTERNAL PQGLO, PGQLO, PQQLO, PQQX0, PGGLO, PGGX0 
      EXTERNAL PP1SFUN, PP1SX0, PM1SFUN, PM1SX0 
      EXTERNAL FF1SFUN, FF1SX0, GF1SFUN, XP1TFUN 
      EXTERNAL GG1SFUN, GG1SX0, FG1SFUN, XG1TFUN 
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      EGAUSS = 0.0001 
      NF     = NFLAV 
                                                                        
      CWFGG  = 6.*(11./12.-NF/18.) - 6. 
                                                                        
      DO 90 IX0 = 1,NXX 
                                                                        
        X0 = XXTAB(IX0) 
                                                                        
        YNTC2Q(IX0) = DGAUSS_LHA(C2Q,0.D0,X0,EGAUSS) 
                                                                        
        SI = X0/XXTAB(IX0) 
        SP = X0/XXTAB(IX0+1) 
                                                                        
        IF(IO1.NE.0) THEN 
          CALL S1FUNC(PQGLO  ,SP,SI,S1PQG) 
          WGTFG1(IWADR(IX0,IX0),NF) =   S1PQG 
          CALL S1FUNC(PGQLO  ,SP,SI,S1PGQ) 
          WGTGF1(IWADR(IX0,IX0)) =   S1PGQ 
          CALL S1FUNC(PQQX0  ,SP,SI,S1PQQ) 
          WGTFF1(IWADR(IX0,IX0)) =   S1PQQ+2.+(8./3.)*LOG(1.-SP) 
          CALL S1FUNC(PGGX0  ,SP,SI,S1PGG) 
          WGTGG1(IWADR(IX0,IX0),NF) =   S1PGG+6.*LOG(1.-SP)+CWFGG 
        ENDIF 
                                                                        
        IF(IO2.NE.0) THEN 
          TERM1 = DGAUSS_LHA(PM1SFUN,0.D0,SP,EGAUSS) 
          TERM2 = DGAUSS_LHA(XP1TFUN,0.D0,SP,EGAUSS) 
          TERM3 = DGAUSS_LHA(XG1TFUN,0.D0,SP,EGAUSS) 
          CALL S1FUNC(PP1SX0 ,SP,SI,S1NS2) 
          WGTPP2(IWADR(IX0,IX0),NF) =   S1NS2 - TERM1 
          WGTNS2(IWADR(IX0,IX0),NF) =   S1NS2 - TERM1 
          LPLUS                     =   .TRUE. 
          CALL S1FUNC(PM1SX0 ,SP,SI,S1F32) 
          WGTPM2(IWADR(IX0,IX0),NF) =   S1F32 - TERM1 
          CALL S1FUNC(FF1SX0 ,SP,SI,S1FF2) 
          WGTFF2(IWADR(IX0,IX0),NF) =   S1FF2 - TERM2 
          CALL S1FUNC(GF1SFUN,SP,SI,S1FG2) 
          WGTFG2(IWADR(IX0,IX0),NF) =   S1FG2 
          CALL S1FUNC(GG1SX0 ,SP,SI,S1GG2) 
          WGTGG2(IWADR(IX0,IX0),NF) =   S1GG2 - TERM3 
          CALL S1FUNC(FG1SFUN,SP,SI,S1GF2) 
          WGTGF2(IWADR(IX0,IX0),NF) =   S1GF2 
        ENDIF 
                                                                        
        IF(IF2.NE.0) THEN 
          TERM = DGAUSS_LHA(C2Q,0.D0,SP,EGAUSS) 
          CALL S1FUNC(C2QX0  ,SP,SI,S1C2Q) 
          WGTC2Q(IWADR(IX0,IX0))    =   S1C2Q - TERM 
          CALL S1FUNC(C2G    ,SP,SI,S1C2G) 
          WGTC2G(IWADR(IX0,IX0),NF) =   S1C2G 
          CALL S1FUNC(CLQ    ,SP,SI,S1CLQ) 
          WGTCLQ(IWADR(IX0,IX0))    =   S1CLQ 
          CALL S1FUNC(CLG    ,SP,SI,S1CLG) 
          WGTCLG(IWADR(IX0,IX0),NF) =   S1CLG 
          CALL S1FUNC(D3Q    ,SP,SI,S1D3Q) 
          WGTC3Q(IWADR(IX0,IX0))    =   S1C2Q - TERM - S1D3Q 
        ENDIF 
                                                                        
        DO 80 IX = IX0+1,NXX 
                                                                        
          SI = X0/XXTAB(IX) 
          SP = X0/XXTAB(IX+1) 
          SM = X0/XXTAB(IX-1) 
                                                                        
          IF(IO1.NE.0) THEN 
            CALL S1FUNC(PQGLO  ,SP,SI,S1PQG) 
            CALL S2FUNC(PQGLO  ,SI,SM,S2PQG) 
            WGTFG1(IWADR(IX,IX0),NF) =   (S1PQG-S2PQG) 
            CALL S1FUNC(PGQLO  ,SP,SI,S1PGQ) 
            CALL S2FUNC(PGQLO  ,SI,SM,S2PGQ) 
            WGTGF1(IWADR(IX,IX0)) =    S1PGQ-S2PGQ 
            CALL S1FUNC(PQQLO  ,SP,SI,S1PQQ) 
            CALL S2FUNC(PQQLO  ,SI,SM,S2PQQ) 
            WGTFF1(IWADR(IX,IX0)) =    S1PQQ-S2PQQ 
            CALL S1FUNC(PGGLO  ,SP,SI,S1PGG) 
            CALL S2FUNC(PGGLO  ,SI,SM,S2PGG) 
            WGTGG1(IWADR(IX,IX0),NF) =    S1PGG-S2PGG 
          ENDIF 
                                                                        
          IF(IO2.NE.0) THEN 
            CALL S1FUNC(PP1SFUN,SP,SI,S1NS2) 
            CALL S2FUNC(PP1SFUN,SI,SM,S2NS2) 
            WGTPP2(IWADR(IX,IX0),NF) =    S1NS2-S2NS2 
            WGTNS2(IWADR(IX,IX0),NF) =    S1NS2-S2NS2 
            CALL S1FUNC(PM1SFUN,SP,SI,S1F32) 
            CALL S2FUNC(PM1SFUN,SI,SM,S2F32) 
            WGTPM2(IWADR(IX,IX0),NF) =    S1F32-S2F32 
            CALL S1FUNC(FF1SFUN,SP,SI,S1FF2) 
            CALL S2FUNC(FF1SFUN,SI,SM,S2FF2) 
            WGTFF2(IWADR(IX,IX0),NF) =    S1FF2-S2FF2 
            CALL S1FUNC(GF1SFUN,SP,SI,S1FG2) 
            CALL S2FUNC(GF1SFUN,SI,SM,S2FG2) 
            WGTFG2(IWADR(IX,IX0),NF) =    S1FG2-S2FG2 
            CALL S1FUNC(GG1SFUN,SP,SI,S1GG2) 
            CALL S2FUNC(GG1SFUN,SI,SM,S2GG2) 
            WGTGG2(IWADR(IX,IX0),NF) =    S1GG2-S2GG2 
            CALL S1FUNC(FG1SFUN,SP,SI,S1GF2) 
            CALL S2FUNC(FG1SFUN,SI,SM,S2GF2) 
            WGTGF2(IWADR(IX,IX0),NF) =    S1GF2-S2GF2 
          ENDIF 
                                                                        
          IF(IF2.NE.0) THEN 
            CALL S1FUNC(C2Q    ,SP,SI,S1C2Q) 
            CALL S2FUNC(C2Q    ,SI,SM,S2C2Q) 
            WGTC2Q(IWADR(IX,IX0))    =    S1C2Q-S2C2Q 
            CALL S1FUNC(C2G    ,SP,SI,S1C2G) 
            CALL S2FUNC(C2G    ,SI,SM,S2C2G) 
            WGTC2G(IWADR(IX,IX0),NF) =    S1C2G-S2C2G 
            CALL S1FUNC(CLQ    ,SP,SI,S1CLQ) 
            CALL S2FUNC(CLQ    ,SI,SM,S2CLQ) 
            WGTCLQ(IWADR(IX,IX0))    =    S1CLQ-S2CLQ 
            CALL S1FUNC(CLG    ,SP,SI,S1CLG) 
            CALL S2FUNC(CLG    ,SI,SM,S2CLG) 
            WGTCLG(IWADR(IX,IX0),NF) =    S1CLG-S2CLG 
            CALL S1FUNC(D3Q    ,SP,SI,S1D3Q) 
            CALL S2FUNC(D3Q    ,SI,SM,S2D3Q) 
            WGTC3Q(IWADR(IX,IX0)) = S1C2Q-S2C2Q-S1D3Q+S2D3Q 
          ENDIF 
                                                                        
   80   CONTINUE 
                                                                        
   90 END DO 
                                                                        
      YWGT = 0. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, IWTADR.                                                     
                                                                        
      INTEGER FUNCTION IWTADR(I,J,K) 
                                                                        
!---  Upper diagonal storage: I .ge. J (!)                              
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      IWTADR = 1 + (J-1)*(MXX+1) -                                      &
     &         (J*(J-1))/2 + (I-J) + (K-1)*(MXX*(MXX+1))/2              
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, IWTAD.                                                      
                                                                        
      INTEGER FUNCTION IWTAD(I,J) 
                                                                        
!---  Upper diagonal storage: I .ge. J (!)                              
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      IWTAD = 1 + (J-1)*(MXX+1) - (J*(J-1))/2 + (I-J) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, S1FUNC.                                                     
                                                                        
!     ================================                                  
      SUBROUTINE S1FUNC(FUN,U,V,S1FUN) 
!     ================================                                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      EXTERNAL FUN 
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      YWGT  = U 
      S1FUN = DGAUSS_LHA(FUN,U,V,EGAUSS)*V/(V-U) 
                                                                        
      YWGT = 0. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, S2FUNC.                                                     
                                                                        
!     ================================                                  
      SUBROUTINE S2FUNC(FUN,U,V,S2FUN) 
!     ================================                                  
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      EXTERNAL FUN 
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      YWGT  = V 
      S2FUN = DGAUSS_LHA(FUN,U,V,EGAUSS)*U/(V-U) 
                                                                        
      YWGT = 0. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FILLO1.                                                     
                                                                        
!     =====================                                             
      SUBROUTINE FILLO1(NF) 
!     =====================                                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!-----          | F |     | WGTFF WGTFG |  | F |                        
!-----  d/dLnQ2 |   |  =  |             |  |   |                        
!-----          | G |     | WGTGF WGTGG |  | G |                        
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WGTFF1,WGTFG1,                                                    &
     &WGTGF1,WGTGG1,                                                    &
     &WGTPP2,WGTPM2,WGTNS2,                                             &
     &WGTFF2,WGTFG2,                                                    &
     &WGTGF2,WGTGG2,                                                    &
     &WGTC2Q,WGTC2G,YNTC2Q,                                             &
     &WGTCLQ,WGTCLG,WGTC3Q                                              
                                                                        
      COMMON/QCWEIT/                                                    &
     &WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),              &
     &WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),              &
     &WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),              &
     &WGTNS2(MXX*(MXX+1)/2,3:5),                                        &
     &WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),              &
     &WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),              &
     &WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),              &
     &WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),              &
     &WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)                             
                                                                        
      COMMON/QCWADR/ IWADR(MXX,MXX) 
                                                                        
                                                                        
      DO 100 IX0=1,NXX 
      X0  = XXTAB(IX0) 
                                                                        
      DO 100 IXI=IX0,NXX 
      SI  = X0 / XXTAB(IXI) 
      SP  = X0 / XXTAB(IXI+1) 
      IF(IXI.EQ.IX0) THEN 
         SSP = LOG(SP) / (1.-SP) 
         WPQQV = SP + 4.*LOG(1.-SP)+ 2.*SP*SSP 
         WPQGV = 3. - (1.-SP)**2   + 3.*SP*SSP 
         WPGQV = - 7. - SP    - 4.*(1.+SP)*SSP 
         WPGGV = - 12.5 - NF/3. + 6.*LOG(1.-SP) + (1.-SP)**2            &
     &                        - 6.*(1.+SP)*SSP                          
      ELSEIF(IXI.EQ.IX0+1) THEN 
         SSI = LOG(SI) / (1.-SI) 
         WPQQV =  SP-1.              +   SQQ(SI,SP)            - 2.*SSI 
         WPQGV = (SP-1.)*(2.-SI-SP) - 3.*SP*LOG(SP/SI)/(SP-SI) - 3.*SSI 
         WPGQV =  1.-SP        + 4.*(SP+1.)*LOG(SP/SI)/(SP-SI) + 8.*SSI 
         WPGGV = (1.-SP)*(2.-SI-SP) + 6.*SGG(SI,SP)           + 12.*SSI 
      ELSE 
         SM  = X0 / XXTAB(IXI-1) 
         WPQQV =  SP-SM                     + SQQ(SI,SP) - SQQ(SI,SM) 
         WPQGV = (SP-SM)*(3.-SM-SI-SP) - 3.*SP*LOG(SP/SI)/(SP-SI)       &
     &                                 + 3.*SM*LOG(SM/SI)/(SM-SI)       
         WPGQV =  SM-SP           + 4.*(SP+1.)*LOG(SP/SI)/(SP-SI)       &
     &                            - 4.*(SM+1.)*LOG(SM/SI)/(SM-SI)       
         WPGGV = (SM-SP)*(3.-SM-SI-SP) + 6.*( SGG(SI,SP) - SGG(SI,SM) ) 
      ENDIF 
                                                                        
      WGTFF1(IWADR(IXI,IX0))    =      2./3.    * SI * WPQQV 
                                                                        
      WGTFG1(IWADR(IXI,IX0),NF) =      1./6.    * SI * WPQGV * 2.*NF 
                                                                        
      WGTGF1(IWADR(IXI,IX0))    =      2./3.    * SI * WPGQV 
                                                                        
      WGTGG1(IWADR(IXI,IX0),NF) =                 SI * WPGGV 
                                                                        
  100 CONTINUE 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, SQQ.                                                        
                                                                        
!     ==================================                                
      DOUBLE PRECISION FUNCTION SQQ(X,Y) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      SQQ = 2./(Y-X) * ( 2.*(Y-1.)*LOG((1.-Y)/(1.-X)) - Y*LOG(Y/X) ) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, SGG.                                                        
                                                                        
!     ==================================                                
      DOUBLE PRECISION FUNCTION SGG(X,Y) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      SGG = ( (1.+Y)*LOG(Y/X) - (1.-Y)*LOG((1.-Y)/(1.-X)) ) / (Y-X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNSPLF.                                                     
                                                                        
!     ===============================================                   
      DOUBLE PRECISION FUNCTION QNSPLF(OPT,X,Q,NFLAV) 
!     ===============================================                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      CHARACTER*(*) OPT 
      CHARACTER*10  OPT1 
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      DATA OPT1 /'          '/ 
                                                                        
      YWGT   = 0. 
      NF     = NFLAV 
      QNSPLF = 0. 
      QPCG   = Q 
      CALL QNRGET('CMASS',QMASS) 
                                                                        
      LEN  = LENOCC_LHA(OPT) 
      IF(LEN.GT.10 .OR. LEN.LE.0) GOTO 550 
!--   Avoid changing input parameter                                    
      OPT1(1:LEN) = OPT(1:LEN) 
      CALL CLTOU_LHA(OPT1) 
                                                                        
      IF    (LEN.GE.4.AND.OPT1(1:4).EQ.'PFF1') THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = PQQLO(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PFG1') THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GT.1..OR.X.LT.0.)      RETURN 
        QNSPLF = PQGLO(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PGF1') THEN 
        IF(X.GT.1..OR.X.LT.0.)      RETURN 
        QNSPLF = PGQLO(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PGG1') THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = PGGLO(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PPL2') THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = PP1SFUN(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PMI2') THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = PM1SFUN(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PFF2') THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = FF1SFUN(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PFG2') THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = FG1SFUN(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PGF2') THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = GF1SFUN(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PGG2') THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = GG1SFUN(X) 
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C1Q')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = C2Q(X)-CLQ(X) 
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C1G')  THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = C2G(X)-CLG(X) 
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C2Q')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = C2Q(X) 
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C2G')  THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = C2G(X) 
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'CLQ')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = CLQ(X) 
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'CLG')  THEN 
        IF(NF.LE.0) GOTO 500 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = CLG(X) 
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C3Q')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = C2Q(X)-D3Q(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'C02G')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = X*C02G_FUN(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'C12G')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = X*C12G_FUN(X) 
      ELSEIF(LEN.GE.5.AND.OPT1(1:5).EQ.'C1B2G')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = X*C1B2G_FUN(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'C12Q')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = X*C12Q_FUN(X) 
      ELSEIF(LEN.GE.5.AND.OPT1(1:5).EQ.'C1B2Q')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = X*C1B2Q_FUN(X) 
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'D12Q')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = X*D12Q_FUN(X) 
      ELSEIF(LEN.GE.5.AND.OPT1(1:5).EQ.'D1B2Q')  THEN 
        IF(X.GE.1..OR.X.LT.0.)      RETURN 
        QNSPLF = X*D1B2Q_FUN(X) 
      ELSE 
        GOTO 550 
      ENDIF 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'('' QNSPLF: NF not allowed'',I10,                        &
     &          '' ---> STOP'')') NF                                    
      STOP 
                                                                        
  550 CONTINUE 
      WRITE(6,'('' QNSPLF: undefined option '',A,                       &
     &          '' ---> STOP'')') OPT                                   
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, PQGLO.                                                      
                                                                        
!     ==================================                                
      DOUBLE PRECISION FUNCTION PQGLO(X) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      PQG   = NF * ( X*X + (1.-X)*(1.-X) ) 
                                                                        
      PQGLO = (X-YWGT)*PQG/X 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PGQLO.                                                      
                                                                        
!     ==================================                                
      DOUBLE PRECISION FUNCTION PGQLO(X) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      PGQ   = 4. * ( 1. + (1.-X)*(1.-X) ) / ( 3.*X ) 
                                                                        
      PGQLO = (X-YWGT)*PGQ/X 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PQQLO.                                                      
!                                                                       
!     ==================================                                
      DOUBLE PRECISION FUNCTION PQQLO(X) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      PQQ   = (4./3.) * ( 1. + X*X ) / (1.-X) 
!                                                                       
      PQQLO = (X-YWGT)*PQQ/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PQQX0.                                                      
!                                                                       
!     ==================================                                
      DOUBLE PRECISION FUNCTION PQQX0(X) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      PQQX0 = (4./3.) * ( (X-YWGT)*(1.+X*X)/X - 2.*(1.-YWGT) ) / (1.-X) 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PGGLO.                                                      
!                                                                       
!     ==================================                                
      DOUBLE PRECISION FUNCTION PGGLO(X) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      PGG   = 6. * ( X/(1.-X) + (1.-X)/X + X*(1.-X) ) 
!                                                                       
      PGGLO = (X-YWGT)*PGG/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PGGX0.                                                      
!                                                                       
!     ==================================                                
      DOUBLE PRECISION FUNCTION PGGX0(X) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      PGGX0 = 6. * (X-YWGT) * ( (1.-X)/(X*X) + 1. - X ) 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PP1SFUN.                                                    
!                                                                       
!     ====================================                              
      DOUBLE PRECISION FUNCTION PP1SFUN(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      CX2    = X**2 
      C1PX   = 1.+X 
      C1MX   = 1.-X 
      CLX    = LOG(X) 
      CLX2   = CLX**2 
      CL1MX  = LOG(C1MX) 
      CL1PX  = LOG(C1PX) 
      CPFFX  = (1.+CX2) / C1MX 
      CPFFMX = (1.+CX2) / C1PX 
      CS3X   = -DDILOG_LHA(-X) 
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX) 
!                                                                       
      AAA = - CPFFX*2.*CLX*CL1MX - (2.*X+3./C1MX)*CLX - .5*C1PX*CLX2    &
     &      - 5.*C1MX                                                   
      BBB =   CPFFX*(.5*CLX2+C11S6*CLX+CPIA) + C1PX*CLX + C20S3*C1MX 
      CCC = - CPFFX*C2S3*(C5S3+CLX) - C4S3*C1MX 
!                                                                       
      PQQ  = C16S9*AAA + 4.*BBB + C2S3*NF*CCC 
      PQQB = - C4S9 * ( CPFFMX*CS2X + C1PX*CLX + 2.*C1MX ) 
!                                                                       
      PP1S    = PQQ + PQQB 
      PP1SFUN = (X-YWGT)*PP1S/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PP1SX0.                                                     
!                                                                       
!     ===================================                               
      DOUBLE PRECISION FUNCTION PP1SX0(X) 
!     ===================================                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      YREM   = YWGT 
      YWGT   = 0. 
      PPLUS  = PP1SFUN(X) 
      PMINU  = PM1SFUN(X) 
      YWGT   = YREM 
      PP1SX0 = (X-YWGT)*PPLUS/X - (1.-YWGT)*PMINU 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PM1SFUN.                                                    
!                                                                       
!     ====================================                              
      DOUBLE PRECISION FUNCTION PM1SFUN(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      CX2    = X**2 
      C1PX   = 1.+X 
      C1MX   = 1.-X 
      CLX    = LOG(X) 
      CLX2   = CLX**2 
      CL1MX  = LOG(C1MX) 
      CL1PX  = LOG(C1PX) 
      CPFFX  = (1.+CX2) / C1MX 
      CPFFMX = (1.+CX2) / C1PX 
      CS3X   = -DDILOG_LHA(-X) 
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX) 
!                                                                       
      AAA = - CPFFX*2.*CLX*CL1MX - (2.*X+3./C1MX)*CLX - .5*C1PX*CLX2    &
     &      - 5.*C1MX                                                   
      BBB =   CPFFX*(.5*CLX2+C11S6*CLX+CPIA) + C1PX*CLX + C20S3*C1MX 
      CCC = - CPFFX*C2S3*(C5S3+CLX) - C4S3*C1MX 
!                                                                       
      PQQ  = C16S9*AAA + 4.*BBB + C2S3*NF*CCC 
      PQQB = - C4S9 * ( CPFFMX*CS2X + C1PX*CLX + 2.*C1MX ) 
!                                                                       
      PM1S    = PQQ - PQQB 
      PM1SFUN = (X-YWGT)*PM1S/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PM1SX0.                                                     
!                                                                       
!     ===================================                               
      DOUBLE PRECISION FUNCTION PM1SX0(X) 
!     ===================================                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      YREM   = YWGT 
      YWGT   = 0. 
      PMINU  = PM1SFUN(X) 
      YWGT   = YREM 
      PM1SX0 = (X-YWGT)*PMINU/X - (1.-YWGT)*PMINU 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FF1SFUN.                                                    
!                                                                       
!     ====================================                              
      DOUBLE PRECISION FUNCTION FF1SFUN(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      CX2    = X**2 
      C1PX   = 1.+X 
      C1MX   = 1.-X 
      CLX    = LOG(X) 
      CLX2   = CLX**2 
      CL1MX  = LOG(C1MX) 
      CL1PX  = LOG(C1PX) 
      CPFFX  = (1.+CX2) / C1MX 
      CPFFMX = (1.+CX2) / C1PX 
      CS3X   = -DDILOG_LHA(-X) 
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX) 
!                                                                       
      AAA = - CPFFX*CLX*(1.5+2.*CL1MX) + 2.*CPFFMX*CS2X                 &
     &      - 1. + X + (.5-1.5*X)*CLX - .5*C1PX*CLX2                    
      BBB =   CPFFX*(C11S6*CLX+.5*CLX2+CPIA) - CPFFMX*CS2X              &
     &      + C14S3*C1MX                                                
      CCC = - CPFFX*(C10S9+C2S3*CLX) + C40S9/X - 2.*C1PX*CLX2           &
     &      - C16S3 + C40S3*X + (10.*X+C16S3*CX2+2.)*CLX                &
     &      - C112S9*CX2                                                
!                                                                       
      FF1S    = C16S9*AAA + 4.*BBB + C2S3*NF*CCC 
      FF1SFUN = (X-YWGT)*FF1S/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FF1SX0.                                                     
!                                                                       
!     ===================================                               
      DOUBLE PRECISION FUNCTION FF1SX0(X) 
!     ===================================                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      YREM   = YWGT 
      YWGT   = 0. 
      FF1S   = FF1SFUN(X) 
      XP1T   = XP1TFUN(X) 
      YWGT   = YREM 
      FF1SX0 = (X-YWGT)*FF1S/X - (1.-YWGT)*XP1T 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GF1SFUN.                                                    
!                                                                       
!     ====================================                              
      DOUBLE PRECISION FUNCTION GF1SFUN(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      CX2    = X**2 
      C1PX   = 1.+X 
      C1MX   = 1.-X 
      CLX    = LOG(X) 
      CLX2   = CLX**2 
      CL1MX  = LOG(C1MX) 
      CL1PX  = LOG(C1PX) 
      CL1MX2 = CL1MX**2 
      CPGFX  = CX2 + C1MX**2 
      CPGFMX = CX2 + C1PX**2 
      CS3X   = -DDILOG_LHA(-X) 
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX) 
!                                                                       
      AAA =   4. - 9.*X + (4.*X-1.)*CLX + (2.*X-1.)*CLX2                &
     &      + 4.*CL1MX                                                  &
     &      + (2.*CLX-2.*CLX*CL1MX+CLX2-2.*CL1MX+CL1MX2+CPIE)           &
     &      * 2. * CPGFX                                                
      DDD =   C182S9 + C14S9*X + C40S9/X + (C136S3*X-C38S3)*CLX         &
     &      - 4.*CL1MX - (2.+8.*X)*CLX2 + 2.*CS2X*CPGFMX                &
     &      + (C44S3*CLX-CLX2-2.*CL1MX2+4.*CL1MX+CPIF) * CPGFX          
!                                                                       
      GF1S    = C2S3*NF*AAA + 1.5*NF*DDD 
      GF1SFUN = (X-YWGT)*GF1S/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, XP1TFUN.                                                    
!                                                                       
!     ====================================                              
      DOUBLE PRECISION FUNCTION XP1TFUN(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      CX2    = X**2 
      C1PX   = 1.+X 
      C1MX   = 1.-X 
      CLX    = LOG(X) 
      CLX2   = CLX**2 
      CL1MX  = LOG(C1MX) 
      CL1PX  = LOG(C1PX) 
      CL1MX2 = CL1MX**2 
      CPFFX  = (1.+CX2) / C1MX 
      CPFFMX = (1.+CX2) / C1PX 
      CPFGX  = (1.+C1MX**2) / X 
      CPFGMX = - (1.+C1PX**2) / X 
      CS1X   = -DDILOG_LHA(1.D0-X) 
      CS3X   = -DDILOG_LHA(-X) 
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX) 
!                                                                       
      AAA =   CPFFX*(1.5*CLX-2.*CLX2+2.*CLX*CL1MX) + 2.*CPFFMX*CS2X     &
     &      - 1. + X + (-1.5+.5*X)*CLX + .5*C1PX*CLX2                   
      BBB =   CPFFX*(C11S6*CLX+.5*CLX2+CPIA) - CPFFMX*CS2X              &
     &      + C14S3*C1MX                                                
      CCC = - CPFFX*(C2S3*CLX+C10S9)                                    &
     &      - C52S3 + C28S3*X + C112S9*CX2 - C40S9/X                    &
     &      - (10.+18.*X+C16S3*CX2)*CLX + 2.*C1PX*CLX2                  
      PFF1T = C16S9*AAA + 4.*BBB + C2S3*NF*CCC 
!                                                                       
      AAA = -.5 + 4.5*X + (-8.+.5*X)*CLX + 2.*X*CL1MX                   &
     &      + (1.-.5*X)*CLX2                                            &
     &      + (CL1MX2+4.*CLX*CL1MX-8.*CS1X-CPIB) * CPFGX                
      BBB =   C62S9 - C35S18*X - C44S9*CX2                              &
     &      + (2.+12.*X+C8S3*CX2) * CLX                                 &
     &      - 2.*X*CL1MX - (4.+X)*CLX2 + CPFGMX*CS2X                    &
     &      + ( - 2.*CLX*CL1MX - 3.*CLX - 1.5*CLX2                      &
     &      - CL1MX2 + 8.*CS1X + CPIC ) * CPFGX                         
      PFG1T = C16S9*AAA + 4.*BBB 
!                                                                       
      XP1T    = X * ( PFF1T + PFG1T ) 
      XP1TFUN = (X-YWGT)*XP1T/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GG1SFUN.                                                    
!                                                                       
!     ====================================                              
      DOUBLE PRECISION FUNCTION GG1SFUN(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      CX2    = X**2 
      C1PX   = 1.+X 
      C1MX   = 1.-X 
      CLX    = LOG(X) 
      CLX2   = CLX**2 
      CL1MX  = LOG(C1MX) 
      CL1PX  = LOG(C1PX) 
      CL1MX2 = CL1MX**2 
      CS3X   = -DDILOG_LHA(-X) 
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX) 
!                                                                       
      CPGG  = 1./C1MX + 1./X -2. + X - CX2 
      CMPGG = 1./C1PX - 1./X -2. - X - CX2 
!                                                                       
!      AAA   = -16.+ 8.*X+ C20S3*CX2 + C4S3/X + (-6.-10.*X)*CLX +       
      AAA   = -16.+ 8.*X+ C20S3*CX2 + C4S3/X + (-6.-10.*X)*CLX          &
     &        -2.*C1PX*CLX2                                             
      BBB   = 2.* C1MX +  26./9.*(CX2-1./X) - C4S3*C1PX*CLX -           &
     &        20./9.*CPGG                                               
      CCC   = 27./2.*C1MX + 67./9.*(CX2-1./X)+(-25./3.+11./3.*x-        &
     &        44./3.*CX2)*CLX+4.*C1PX*CLX2+(67./9.-4.*CLX*CL1MX +       &
     &        CLX2-CPI2S3)*CPGG + 2.*CMPGG*CS2X                         
!                                                                       
      GG1S    = C2S3*NF*AAA + 1.5*NF*BBB + 9.* CCC 
      GG1SFUN = (X-YWGT)*GG1S/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, GG1SX0.                                                     
!                                                                       
!     ===================================                               
      DOUBLE PRECISION FUNCTION GG1SX0(X) 
!     ===================================                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      YREM   = YWGT 
      YWGT   = 0. 
      GG1S   = GG1SFUN(X) 
      XG1T   = XG1TFUN(X) 
      YWGT   = YREM 
      GG1SX0 = (X-YWGT)*GG1S/X - (1.-YWGT)*XG1T 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FG1SFUN.                                                    
!                                                                       
!     ====================================                              
      DOUBLE PRECISION FUNCTION FG1SFUN(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      CX2    = X**2 
      C1PX   = 1.+X 
      C1MX   = 1.-X 
      CLX    = LOG(X) 
      CLX2   = CLX**2 
      CL1MX  = LOG(C1MX) 
      CL1PX  = LOG(C1PX) 
      CL1MX2 = CL1MX**2 
      CPFGX  = (1.+C1MX**2) / X 
      CPFGMX = - (1.+C1PX**2) / X 
      CS3X   = -DDILOG_LHA(-X) 
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX) 
!                                                                       
      AAA   = -5./2.- 7./2.*X+(2.+7./2.*X)*CLX+(-1.+0.5*X)*CLX2         &
     &        -2.*X*CL1MX+ (-3.*CL1MX-CL1MX2)*CPFGX                     
      BBB   = 28./9.+65./18.*X+44./9.*CX2+(-12.-5.*X-8./3.*CX2)*CLX+    &
     &        (4.+X)*CLX2+2.*X*CL1MX+ (-2.*CLX*CL1MX+0.5*CLX2+          &
     &        11./3.*CL1MX+CL1MX2-0.5*CPI2S3+0.5)*CPFGX+CPFGMX*CS2X     
      CCC   = -C4S3*X- (20./9.+C4S3*CL1MX)*CPFGX 
!                                                                       
      FG1S    = C16S9*AAA+4.*BBB+2./3.*NF*CCC 
      FG1SFUN = (X-YWGT)*FG1S/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, XG1TFUN.                                                    
!                                                                       
!     ====================================                              
      DOUBLE PRECISION FUNCTION XG1TFUN(X) 
!     ====================================                              
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!                                                                       
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
!                                                                       
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
!                                                                       
      CX2    = X**2 
      C1PX   = 1.+X 
      C1MX   = 1.-X 
      CLX    = LOG(X) 
      CLX2   = CLX**2 
      CL1MX  = LOG(C1MX) 
      CL1PX  = LOG(C1PX) 
      CL1MX2 = CL1MX**2 
      CPGFX  = CX2 + C1MX**2 
      CPGFMX = CX2 + C1PX**2 
      CS1X   = -DDILOG_LHA(1.D0-X) 
      CS3X   = -DDILOG_LHA(-X) 
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX) 
!                                                                       
      CPGG  = 1./C1MX + 1./X -2. + X - CX2 
      CMPGG = 1./C1PX - 1./X -2. - X - CX2 
!                                                                       
      AAA   = -4.+12.*x-164./9.*CX2+92./9./X+(10.+14.*X+C16S3*CX2+      &
     &        C16S3/X)*CLX + 2.*C1PX*CLX2                               
      BBB   = 2.-2.*X+26./9.*(CX2-1./X)-C4S3*C1PX*CLX-                  &
     &        (20./9.+8./3.*CLX)*CPGG                                   
      CCC   = 27./2.*(C1MX)+67./9.*(CX2-1./X)+(11./3.-25./3.*X-         &
     &        44./3./X)*CLX -4.*(C1PX) * CLX2 + (4.*CLX*CL1MX -         &
     &        3.*CLX2+22./3.*CLX-CPI2S3+67./9.)*CPGG+                   &
     &        2.*CMPGG*CS2X                                             
      PGG1T = 2./3.*NF*AAA+3./2.*NF*BBB+9.*CCC 
!                                                                       
      AAA   = -8./3.-(16./9.+8./3.*CLX+8./3.*CL1MX)*CPGFX 
      BBB   = -2.+3.*X+(-7.+8.*X)*CLX-4.*CL1MX + (1.-2.*X)*CLX2         &
     &        +(-4.*CLX*CL1MX-2.*CLX2-2.*CL1MX+2.*CLX-2.*CL1MX2         &
     &        +16.*CS1X+ 2.*PI*PI - 10.)*CPGFX                          
      CCC   = -152./9.+166./9.*X-40./9./X+ (-C4S3-76./3.*X)*CLX+        &
     &        4.*CL1MX + (2.+8.*X)*CLX2+ (8.*CLX*CL1MX-CLX2-            &
     &        C4S3*CLX+10./3.*CL1MX+2.*CL1MX2-16.*CS1X-7.*CPI2S3+       &
     &        178./9.)*CPGFX+2.*CPGFMX*CS2X                             
      PGF1T = (0.5*NF)**2*AAA+2./3.*NF*BBB+3./2.*NF*CCC 
!                                                                       
      XG1T    = X * ( PGG1T + PGF1T ) 
      XG1TFUN = (X-YWGT)*XG1T/X 
!                                                                       
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C2Q.                                                        
                                                                        
!     ================================                                  
      DOUBLE PRECISION FUNCTION C2Q(X) 
!     ================================                                  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      C1MX = 1.-X 
      C2Q = 3. + C5S3*X + (C4S3*LOG(C1MX/X)-1.) * (1.+X**2) / C1MX 
      C2Q = (X-YWGT)*C2Q/X 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C2QX0.                                                      
                                                                        
                                                                        
!     ==================================                                
      DOUBLE PRECISION FUNCTION C2QX0(X) 
!     ==================================                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      C1MX = 1.-X 
      C2Q = 3. + C5S3*X + (C4S3*LOG(C1MX/X)-1.) * (1.+X**2) / C1MX 
                                                                        
      C2QX0 = ((X-YWGT)/X+YWGT-1.)*C2Q 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C2G.                                                        
                                                                        
!     ================================                                  
      DOUBLE PRECISION FUNCTION C2G(X) 
!     ================================                                  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      C1MX = 1. - X 
      C2G = -.5 + 4.*X*C1MX + .5 * (X**2+C1MX**2) * LOG(C1MX/X) 
      C2G = 2.*NF*(X-YWGT)*C2G/X 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, CLQ.                                                        
                                                                        
!     ================================                                  
      DOUBLE PRECISION FUNCTION CLQ(X) 
!     ================================                                  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      CLQ = C8S3*X 
      CLQ = (X-YWGT)*CLQ/X 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, CLG.                                                        
                                                                        
!     ================================                                  
      DOUBLE PRECISION FUNCTION CLG(X) 
!     ================================                                  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      CLG = NF*4.*X*(1.-X) 
      CLG = (X-YWGT)*CLG/X 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, D3Q.                                                        
                                                                        
!     ================================                                  
      DOUBLE PRECISION FUNCTION D3Q(X) 
!     ================================                                  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
!--   C3Q = C2Q - D3Q                                                   
                                                                        
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF 
                                                                        
      D3Q = C4S3*(1.+X) 
!--   Fixed this bug in QCDNUM16.11 17-01-98                            
!     D3Q = (X-YWGT)*C3Q/X                                              
      D3Q = (X-YWGT)*D3Q/X 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, PCGFUN.                                                     
                                                                        
!     ===================================                               
      DOUBLE PRECISION FUNCTION PCGFUN(X) 
!     ===================================                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Pcg (heavy quark) splitting function taken from                   
!--   Glueck, Hoffmann and Reya, Z. Phys. C13(1982)119 eq. (2.6).       
!--   Notice that if YWGT is set to zero, PCGFUN(X) returns Pcg(x).     
!--   Q2 and the quark mass are passed through the common block         
!--   /QCWGTC/ as QPCG and QMASS respectively.                          
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      PCG    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        U    = 1.-X 
        V    = SQRT(1.-4.*FACTOR*X/(1.-X)) 
        PCG  = (1./V)*(0.5-X*U+FACTOR*X*(3.-4.*X)/U                     &
     &         -16.*FACTOR*FACTOR*X*X)  -                               &
     &         (2.*FACTOR*X*(1.-3.*X)-8.*FACTOR*FACTOR*X*X)             &
     &         *LOG((1.+V)/(1.-V))                                      
      ENDIF 
      PCGFUN = (X-YWGT)*PCG/X 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QASTOL.                                                     
                                                                        
!     ==============================                                    
      SUBROUTINE LFROMA(AS,Q2,QL,NF) 
!     ==============================                                    
                                                                        
!---  Calculate Lambda^(nf) given alpha_s(Q^2)                          
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r LFROMA ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'(/'' This s/r is not available......     '')') 
                                                                        
      STOP 
      END                                           
                                                                        
                                                                        
!DECK  ID>, AFROML.                                                     
                                                                        
!     ==============================                                    
      SUBROUTINE AFROML(QL,NF,AS,Q2) 
!     ==============================                                    
                                                                        
!---  Calculate alpha_s(Q^2) given Lambda^(nf)                          
                                                                        
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r AFROML ---> STOP'')') 
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'(/'' This s/r is not available......     '')') 
                                                                        
      STOP 
      END                                           
                                                                        
!DECK  ID>, QNALFA.                                                     
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION QNALFA(QQ2) 
!     =====================================                             
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      IF(LBMARK) THEN 
! fix for rgr                                                           
         call rgras(qnalfa,qq2) 
!      print *,' 1 rgras called and NF is ',nf                          
!        F      = 4.                                                    
!        QCDL   = 0.250                                                 
!        QNALFA = QNALAM(F,QQ2,QCDL,IORD)                               
      ELSEIF(LASOLD) THEN 
        QNALFA = A0TOA1_OLD(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR) 
      ELSE 
        QNALFA = A0TOA1(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR) 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QALFAS.                                                     
                                                                        
!     ===================================================               
      DOUBLE PRECISION FUNCTION QALFAS(QQ2,QLAMB,NF,IERR) 
!     ===================================================               
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      IF(LBMARK) THEN 
! fix for rgr alphas                                                    
!      print *,' 2 rgras called and NF is '                             
        call rgras(qalfas,qq2) 
        QLAMB  = SQRT(Q_LAMB2(QQ2,QALFAS,NF,IORD)) 
!        F      = 4.                                                    
!        QCDL   = 0.250                                                 
!        QALFAS = QNALAM(F,QQ2,QCDL,IORD)                               
!        NF     = F                                                     
!        QLAMB  = 0.                                                    
      ELSEIF(LASOLD) THEN 
        QALFAS = A0TOA1_OLD(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR) 
        QLAMB  = SQRT(Q_LAMB2(QQ2,QALFAS,NF,IORD)) 
        IF(IERR.NE.0) QLAMB = 0. 
      ELSE 
        QALFAS = A0TOA1(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR) 
        QLAMB  = SQRT(Q_LAMB2(QQ2,QALFAS,NF,IORD)) 
        IF(IERR.NE.0) QLAMB = 0. 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QFILAS.                                                     
                                                                        
!     ========================                                          
      SUBROUTINE QFILAS(SRNAM) 
!     ========================                                          
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      CHARACTER*6 SRNAM 
                                                                        
!--   Check quark masses                                                
      IF(.NOT.(0.LE.UDSCBT(1) .AND. UDSCBT(1).LE.UDSCBT(2) .AND.        &
     & UDSCBT(2).LE.UDSCBT(3) .AND. UDSCBT(3).LT.UDSCBT(4) .AND.        &
     & UDSCBT(4).LT.UDSCBT(5) .AND. UDSCBT(5).LT.UDSCBT(6))) THEN       
        IERR = 1 
        GOTO 500 
      ENDIF 
                                                                        
      IF(LBMARK) THEN 
!-- This is a fix to put in the RGR alphas                              
        DO IQ = 1,NQ2 
                                                                        
!--       Alphas at the renormalistion scale                            
          QQ2        = Q2TAB(IQ)*AAAR2 + BBBR2 
!      print *,' 3 rgras called and iord is ',iord                      
          call rgras(ALF,QQ2) 
!      print *,nf,iord,alf,qq2                                          
          BET0       = 11.-2*NF/3. 
          ALFASQ(IQ) = ALF 
          ALFAPQ(IQ) = ALF/(2.*PI) 
          ALFA2Q(IQ) = 0. 
          IF(IORD.GE.2) THEN 
            ALFA2Q(IQ) = ALFAPQ(IQ)*ALFAPQ(IQ) 
            FACT       = LOG(QQ2/Q2TAB(IQ))*BET0*0.5 
            ALFAPQ(IQ) = ALFAPQ(IQ)*(1.+FACT*ALFAPQ(IQ)) 
          ENDIF 
                                                                        
        ENDDO 
                                                                        
                                                                        
!C--     Alphas for benchmark tests (HERA workshop)                     
!                                                                       
!        F    = 4.                                                      
!        QCDL = 0.250                                                   
!                                                                       
!        DO IQ = 1,NQ2                                                  
!                                                                       
!C--       Alphas at the renormalistion scale                           
!          QQ2        = Q2TAB(IQ)*AAAR2 + BBBR2                         
!          ALFASQ(IQ) = QNALAM(F,QQ2,QCDL,IORD)                         
!          BET0       = 11.-2.*F/3.                                     
!          ALFAPQ(IQ) = ALFASQ(IQ) /(2.*PI)                             
!          ALFA2Q(IQ) = 0.                                              
!          IEALFA(IQ) = 0                                               
!          IF(IORD.GE.2) THEN                                           
!            ALFA2Q(IQ) = ALFAPQ(IQ)*ALFAPQ(IQ)                         
!            FACT = LOG(QQ2/Q2TAB(IQ))*BET0*0.5                         
!            ALFAPQ(IQ) = ALFAPQ(IQ)*(1.+FACT*ALFAPQ(IQ))               
!          ENDIF                                                        
!                                                                       
!        ENDDO                                                          
                                                                        
      ELSEIF(LASOLD) THEN 
                                                                        
!--     Alphas from old routine (for backwards compatibility)           
                                                                        
        DO IQ = 1,NQ2 
                                                                        
!--       Alphas at the renormalistion scale                            
          QQ2        = Q2TAB(IQ)*AAAR2 + BBBR2 
          ALFASQ(IQ) = A0TOA1_OLD(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR) 
          BET0       = 11.-2*NF/3. 
          IEALFA(IQ) = IERR 
          ALFAPQ(IQ) = ALFASQ(IQ) /(2.*PI) 
          ALFA2Q(IQ) = 0. 
          IF(IORD.GE.2) THEN 
            ALFA2Q(IQ) = ALFAPQ(IQ)*ALFAPQ(IQ) 
            FACT       = LOG(QQ2/Q2TAB(IQ))*BET0*0.5 
            ALFAPQ(IQ) = ALFAPQ(IQ)*(1.+FACT*ALFAPQ(IQ)) 
          ENDIF 
                                                                        
        ENDDO 
                                                                        
      ELSE 
                                                                        
!--     This is the alphas to be used                                   
                                                                        
        DO IQ = 1,NQ2 
                                                                        
!--       Alphas at the renormalistion scale                            
          QQ2        = Q2TAB(IQ)*AAAR2 + BBBR2 
          ALF        = A0TOA1(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR) 
!          print *,iord,nf,qq2,alf                                      
          BET0       = 11.-2*NF/3. 
          IEALFA(IQ) = IERR 
          ALFASQ(IQ) = ALF 
          ALFAPQ(IQ) = ALF/(2.*PI) 
          ALFA2Q(IQ) = 0. 
          IF(IORD.GE.2) THEN 
            ALFA2Q(IQ) = ALFAPQ(IQ)*ALFAPQ(IQ) 
            FACT       = LOG(QQ2/Q2TAB(IQ))*BET0*0.5 
            ALFAPQ(IQ) = ALFAPQ(IQ)*(1.+FACT*ALFAPQ(IQ)) 
          ENDIF 
                                                                        
        ENDDO 
                                                                        
      ENDIF 
                                                                        
      LALFOK = .TRUE. 
!--   Invalidate all evolutions                                         
      CALL QNFALS(LEVDONE,MXX*10) 
                                                                        
!--   Find lowest Q2 for which alpha_s is calculated                    
      QMINAS = Q2TAB(NQ2) 
      DO IQ = NQ2,1,-1 
        IF(IEALFA(IQ).EQ.0) QMINAS = Q2TAB(IQ) 
      ENDDO 
                                                                        
      RETURN 
                                                                        
  500 CONTINUE 
      WRITE(6,'(/'' ------------------------------------'')') 
      WRITE(6,'( '' QCDNUM error in s/r '',A,'' ---> STOP'')')          &
     &              SRNAM                                               
      WRITE(6,'( '' ------------------------------------'')') 
      WRITE(6,'( '' Umass           :'',E12.5)') UDSCBT(1) 
      WRITE(6,'( '' Dmass           :'',E12.5)') UDSCBT(2) 
      WRITE(6,'( '' Smass           :'',E12.5)') UDSCBT(3) 
      WRITE(6,'( '' Cmass           :'',E12.5)') UDSCBT(4) 
      WRITE(6,'( '' Bmass           :'',E12.5)') UDSCBT(5) 
      WRITE(6,'( '' Tmass           :'',E12.5)') UDSCBT(6) 
      IF(IERR.EQ.1) THEN 
        WRITE(6,'(/'' Quark masses not in ascending order'')') 
      ENDIF 
                                                                        
      CALL QTRACE('QFILAS ',1) 
                                                                        
      STOP 
                                                                        
      END                                           
                                                                        
!DECK  ID>, GET_AS.                                                     
                                                                        
!     =======================================                           
      DOUBLE PRECISION FUNCTION GET_AS(IQ,TQ) 
!     =======================================                           
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Interpolation of alpha_s table: returns alpha_s/(2pi)             
!--   Input IQ must be in the range 1,...,NQ2-1                         
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
      GET_AS = ((1.-TQ)*ALFASQ(IQ)+TQ*ALFASQ(IQ+1))/(2.*PI) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QNALAM.                                                     
                                                                        
!     =================================================                 
      DOUBLE PRECISION FUNCTION QNALAM (F,Q2,QCDL,IORD) 
!     =================================================                 
                                                                        
      IMPLICIT DOUBLE PRECISION (A - Z) 
      INTEGER IORD 
                                                                        
      DATA PI / 3.14159265359 / 
                                                                        
!---  Calculation of alpha strong (Q**2) in NLO :                       
!---  F    = number of flavours                                         
!---  Q2   = Q**2 in GeV**2                                             
!---  QCDL = Lambda(MSbar) in GeV                                       
                                                                        
      B0     = 11.D0 - 2.D0/3.D0 * F 
      B0S    = B0 * B0 
      B1     = 102.D0 - 38.D0/3.D0 * F 
      LAM2   = QCDL * QCDL 
      LQ2    = DLOG (Q2/LAM2) 
      QNALAM = 1.D0/(B0 * LQ2) 
      IF(IORD.GE.2) QNALAM = QNALAM - 1.D0/(B0 * LQ2) *                 &
     &              (B1/B0S * DLOG(LQ2)/LQ2)                            
      QNALAM = QNALAM*4.D0*PI 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, A0TOA1.                                                     
                                                                        
!     ===========================================================       
      DOUBLE PRECISION FUNCTION A0TOA1(QSU,QS0,AS0,IORD,NFF,IERR) 
!     ===========================================================       
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
      QS1   = QSU 
                                                                        
      QMU0  = SQRT(QS0) 
      QMU1  = SQRT(QS1) 
                                                                        
      DO 10 I=1,6 
      IF(QMU0.GE.UDSCBT(I)) NF0 = I 
      IF(QMU1.GE.UDSCBT(I)) NF1 = I 
   10 END DO 
                                                                        
      IF(NF1.LT.NF0) THEN 
        IST = -1 
        JST =  0 
      ELSE 
        IST = 1 
        JST = 1 
      ENDIF 
                                                                        
      ALFA0 = AS0 
      Q00   = QS0 
                                                                        
      DO 50 NF = NF0,NF1,IST 
                                                                        
      IF(NF.NE.NF1) THEN 
        Q21 = UDSCBT(NF+JST)*UDSCBT(NF+JST) 
      ELSE 
        Q21 = QS1 
      ENDIF 
      ALFA1 = ALPHAR(Q21,Q00,ALFA0,NF,IORD,JERR) 
      ALFA0 = ALFA1 
      Q00   = Q21 
                                                                        
   50 END DO 
                                                                        
      A0TOA1 = ALFA0 
      NFF    = NF1 
      IERR   = JERR 
                                                                        
      RETURN 
      END                                           
                                                                        
!     ===============================================================   
      DOUBLE PRECISION FUNCTION A0TOA1_OLD(QSU,QS0,AS0,IORD,NFF,IERR) 
!     ===============================================================   
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      QS1   = QSU 
                                                                        
      QMU0  = SQRT(QS0) 
      QMU1  = SQRT(QS1) 
                                                                        
      DO 10 I=1,6 
      IF(QMU0.GE.UDSCBT(I)) NF0 = I 
      IF(QMU1.GE.UDSCBT(I)) NF1 = I 
   10 END DO 
                                                                        
      IF(NF1.LT.NF0) THEN 
        IST = -1 
        JST =  0 
      ELSE 
        IST = 1 
        JST = 1 
      ENDIF 
                                                                        
      ALFA0 = AS0 
      Q00   = QS0 
                                                                        
      DO 50 NF = NF0,NF1,IST 
                                                                        
      IF(NF.NE.NF1) THEN 
        Q21 = UDSCBT(NF+JST)*UDSCBT(NF+JST) 
      ELSE 
        Q21 = QS1 
      ENDIF 
      ALFA0 = ALPHAR_OLD(Q21,Q00,ALFA0,NF,IORD,JERR) 
      Q00   = Q21 
                                                                        
   50 END DO 
                                                                        
      A0TOA1_OLD = ALFA0 
      NFF        = NF1 
      IERR       = JERR 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, ALPHAR.                                                     
                                                                        
!     ==========================================================        
      DOUBLE PRECISION FUNCTION ALPHAR(QSQ,QS0,AS0,NF,IORD,IERR) 
!     ==========================================================        
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   ALPHAS FROM RGE GIVEN AS0 AT QS0                                  
                                                                        
      DATA PI / 3.14159265359 / 
                                                                        
      BET0 = 11.-2*NF/3. 
      BET1 = 102.-38*NF/3. 
      B0   = BET0/(4.*PI) 
      B1   = BET1/(4.*PI*BET0) 
      IERR = 0 
                                                                        
      TERM0 = 1./AS0+B0*LOG(QSQ/QS0) 
      IF(TERM0.LE.0.) THEN 
        ALPHAR = 100. 
        IERR   = 1 
        RETURN 
      ENDIF 
      ALFA0 = 1./TERM0 
      IF(IORD.EQ.1) THEN 
        ALPHAR = ALFA0 
        RETURN 
      ENDIF 
   20 CONTINUE 
      ARG   = (1./ALFA0+B1)/(1./AS0+B1) 
      IF(ARG.LE.0.) THEN 
        ALPHAR = 100. 
        IERR   = 1 
        RETURN 
      ELSE 
        TERM  = TERM0+B1*LOG(ARG) 
        IF(TERM.LE.0) THEN 
          ALPHAR = 100. 
          IERR   = 1 
          RETURN 
        ELSE 
          ALFA1 = 1./TERM 
        ENDIF 
      ENDIF 
      IF(ABS(ALFA1-ALFA0).GT.1.E-6) THEN 
        ALFA0 = ALFA1 
        GOTO 20 
      ENDIF 
                                                                        
      ALPHAR = ALFA1 
                                                                        
      RETURN 
      END                                           
                                                                        
!     ==============================================================    
      DOUBLE PRECISION FUNCTION ALPHAR_OLD(QSQ,QS0,AS0,NF,IORD,IERR) 
!     ==============================================================    
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!-----MARCHIANO: ALPHAS FROM RGE GIVEN AS0 AT QS0                       
!-----This routine uses an incorrect truncation -->                     
!-----alpha_s is about 0.4% too low.                                    
                                                                        
      DATA PI    / 3.1415927 / 
                                                                        
      QMU  = SQRT(QSQ) 
      QM0  = SQRT(QS0) 
                                                                        
      B3   = -(11.-2.*NF/3.)/(2.*PI) 
      B33  = -(51.-19.*NF/3.)/(4.*PI*PI) 
      B333 = -(2857.-5033.*NF/9.+325.*NF*NF/27.)/(64.*PI*PI*PI) 
      IERR = 0 
                                                                        
      TERM0 = 1./AS0-B3*LOG(QMU/QM0) 
      ALFA0 = 1./TERM0 
      IF(IORD.EQ.1) THEN 
        ALPHAR_OLD  = ALFA0 
        RETURN 
      ENDIF 
   20 CONTINUE 
      TERM = TERM0-B33*LOG(ALFA0/AS0)/B3 
      IF(IORD.EQ.3) TERM = TERM-(B333*B3-B33*B33)*(ALFA0-AS0)/(B3*B3) 
      ALFA1 = 1./TERM 
      IF(ABS(ALFA1-ALFA0).GT.1.E-6) THEN 
        ALFA0 = ALFA1 
        GOTO 20 
      ENDIF 
                                                                        
      ALPHAR_OLD = ALFA1 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, Q_LAMB2.                                                    
                                                                        
!     ==================================================                
      DOUBLE PRECISION FUNCTION Q_LAMB2(QS0,AS0,NF,IORD) 
!     ==================================================                
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Calculate lambda**2 given AS0 at QS0                              
                                                                        
      DATA PI / 3.14159265359 / 
                                                                        
      BET0 = 11.-2*NF/3. 
      BET1 = 102.-38*NF/3. 
      AS   = AS0/(4.*PI) 
                                                                        
      Q_LAMB2 = QS0*EXP(-1./(BET0*AS)) 
                                                                        
      IF(IORD.EQ.1) RETURN 
                                                                        
      ARG     = 1. + BET0/(BET1*AS) 
      POW     = BET1/(BET0*BET0) 
      Q_LAMB2 = Q_LAMB2*ARG**POW 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, QHEAVY.                                                     
                                                                        
! Heavy quark structure functions.                                      
! Heavy quark coefficient functions up to NLO are taken from the code   
! of S. Riemersma. For reference, see S. Riemersma, J. Smith and        
! W.L. van Neerven, Phys. Lett. B347(1995)143.                          
                                                                        
!DECK  ID>, GET_FKH.                                                    
                                                                        
!     =====================================================             
      DOUBLE PRECISION FUNCTION GET_FKH(IDF,ID,IX0,IQ,IERR) 
!     =====================================================             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
!--   Input:  IDF  =  4,5,6,7 for F2c,Flc,F2b,Flb                       
!--   Input:  ID      parton distribution identifier                    
!--           IX0     x gridpoint of heavy quark grid                   
!--           IQ      Q2 gridpoint                                      
!--   Output: IERR =  0 FKH successfully calculated                     
!--                =  1 Fast calculation                                
!--                = -1 Scale mu outside grid                           
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      LOGICAL                                                           &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL,LASOLD                                                     
                                                                        
      COMMON/QCFLAG/                                                    &
     &IORD,IOLAST,                                                      &
     &LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,                            &
     &LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,                          &
     &LALFOK,LDQ2OK,LWT1OK,LWT2OK,                                      &
     &LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,                  &
     &LFFCAL(7,30),LASOLD                                               
                                                                        
                                                                        
      CHARACTER*5 PNAM,STFNAM 
      LOGICAL     LNFP 
      COMMON /QCLNFP/ LNFP(0:30,3:5) 
      COMMON /QCPNAM/ PNAM(0:30) 
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5) 
      COMMON /QCFNAM/ STFNAM(7) 
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WH_C0KG,WH_C1KG,WH_C1BKG,                                         &
     &WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ                                 
                                                                        
      COMMON/QCHWGT/                                                    &
     &WH_C0KG(0:MXX,MQ2,4:7),                                           &
     &WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),                   &
     &WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),                   &
     &WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)                    
                                                                        
                                                                        
      COMMON/QCPASS/                                                    &
     &ALPHA0, Q0ALFA, ASLAST, QALAST,                                   &
     &ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),                            &
     &DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),                     &
     &FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),                                  &
     &FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),                                  &
     &FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),                                  &
     &FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,                 &
     &MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),                      &
     &ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),            &
     &IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)                            
                                                                        
      LOGICAL LEVDONE,LE_DONE 
      COMMON/QCLEVL/                                                    &
     &LEVDONE(MXX,10),LE_DONE(MXX)                                      
                                                                        
                                                                        
!--   Correct quark mass                                                
      QMASS = CBMSTF(IDF) 
      CCCC  = CHARGE(IDF) 
                                                                        
      GET_FKH = 0. 
                                                                        
      IF(LFFCAL(IDF,ID)) THEN 
        IERR = 1 
        JD   = IDFAST(IDF,ID) 
        GET_FKH = FSTORE(IX0,IQ,JD) 
        IF(GET_FKH.GE.-99.) RETURN 
      ENDIF 
                                                                        
      QMU  = Q2TAB(IQ)*AAM2H + BBM2H 
      IMU  = MIN(ABS(IQFROMQ(QMU)),NQ2-1) 
      IF(IMU.EQ.0) THEN 
        IERR = -1 
        RETURN 
      ENDIF 
      QR2 = QMU*AAAR2 + BBBR2 
      IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1) 
      IF(IR2.EQ.0) THEN 
        IERR = -1 
        RETURN 
      ENDIF 
                                                                        
      IERR = 0 
      TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU)) 
      TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2)) 
                                                                        
      IF(IORD.EQ.1) THEN 
                                                                        
        FF = 0. 
        DO IX = IX0,NXX 
          IXL = IHTAB(IX) 
          X   = XHTAB(IX) 
          TX  = (X-XXTAB(IXL))/(XXTAB(IXL+1)-XXTAB(IXL)) 
          GL  = GET_PDFXQ(0,IXL,IMU,TX,TQ) 
          FF  = FF + WH_C0KG(IX-IX0,IQ,IDF)*GL 
        ENDDO 
        GET_FKH = CCCC * GET_AS(IR2,TR) * FF 
                                                                        
      ELSE 
                                                                        
        AS = GET_AS(IR2,TR) 
        F1 = 0. 
        F2 = 0. 
        F3 = 0. 
        F4 = 0. 
        FACT = LOG(QMU/(QMASS*QMASS)) 
        DO IX = IX0,NXX 
          IXL = IHTAB(IX) 
          X   = XHTAB(IX) 
          TX  = (X-XXTAB(IXL))/(XXTAB(IXL+1)-XXTAB(IXL)) 
          GL  = GET_PDFXQ( 0,IXL,IMU,TX,TQ) 
          SI  = GET_PDFXQ( 1,IXL,IMU,TX,TQ) 
          QU  = GET_PDFXQ(ID,IXL,IMU,TX,TQ) 
          I   = IX-IX0 
          F1  = F1 +  WH_C0KG(I,IQ,IDF)*GL 
          F2  = F2 + (WH_C1KG(I,IQ,IDF)+WH_C1BKG(I,IQ,IDF)*FACT)*GL 
          F3  = F3 + (WH_C1KQ(I,IQ,IDF)+WH_C1BKQ(I,IQ,IDF)*FACT)*SI 
          F4  = F4 + (WH_D1KQ(I,IQ,IDF)+WH_D1BKQ(I,IQ,IDF)*FACT)*QU 
        ENDDO 
        GET_FKH = CCCC * (AS*F1+AS*AS*(F2+F3)) + AS*AS*F4 
      ENDIF 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FIL_F2H.                                                    
                                                                        
!     =======================                                           
      SUBROUTINE FIL_F2H(IDF) 
!     =======================                                           
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      EXTERNAL C02G_FUN, C12G_FUN, C1B2G_FUN 
      EXTERNAL           C12Q_FUN, C1B2Q_FUN 
      EXTERNAL           D12Q_FUN, D1B2Q_FUN 
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WH_C0KG,WH_C1KG,WH_C1BKG,                                         &
     &WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ                                 
                                                                        
      COMMON/QCHWGT/                                                    &
     &WH_C0KG(0:MXX,MQ2,4:7),                                           &
     &WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),                   &
     &WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),                   &
     &WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)                    
                                                                        
                                                                        
      QMASS  = CBMSTF(IDF) 
                                                                        
      EGAUSS = 0.001 
                                                                        
      DO 400 IQ = 1,NQ2 
                                                                        
        QPCG = Q2TAB(IQ) 
        APCG = 1.+4.*QMASS*QMASS/QPCG 
                                                                        
        IX0 = 1 
        X0  = XHTAB(IX0) 
                                                                        
!       WRITE(6,'('' Calculate F2H weights for IX ='',I4)') IX0         
                                                                        
        DO 200 IX = IX0,NXX 
                                                                        
          XI   = XHTAB(IX) 
          XIP1 = XHTAB(IX+1) 
          IF(IX.GT.IX0) XIM1 = XHTAB(IX-1) 
          IF(XIP1.LE.X0*APCG) GOTO 200 
          XI   = MAX(XI,X0*APCG) 
          SIP1 = X0/XIP1 
          SI   = X0/XI 
                                                                        
          CALL S1FUNC(C02G_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C0KG(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C02G_FUN,SI,SIM1,S2FUN) 
            WH_C0KG(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(C12G_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C1KG(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C12G_FUN,SI,SIM1,S2FUN) 
            WH_C1KG(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(C1B2G_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C1BKG(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C1B2G_FUN,SI,SIM1,S2FUN) 
            WH_C1BKG(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(C12Q_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C1KQ(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C12Q_FUN,SI,SIM1,S2FUN) 
            WH_C1KQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(C1B2Q_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C1BKQ(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C1B2Q_FUN,SI,SIM1,S2FUN) 
            WH_C1BKQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(D12Q_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_D1KQ(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(D12Q_FUN,SI,SIM1,S2FUN) 
            WH_D1KQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(D1B2Q_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_D1BKQ(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(D1B2Q_FUN,SI,SIM1,S2FUN) 
            WH_D1BKQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
  200   CONTINUE 
                                                                        
  400 END DO 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C02G_FUN.                                                   
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION C02G_FUN(X) 
!     =====================================                             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      DATA PI       /3.14159265359/ 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C02G    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        C02G = (C0_LG(ETA,XI)+C0_TG(ETA,XI)) * XI / (2.*PI) 
      ENDIF 
      C02G_FUN = (X-YWGT)*C02G/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C12G_FUN.                                                   
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION C12G_FUN(X) 
!     =====================================                             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C12G    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        BET  = SQRT(ETA/(1.+ETA)) 
        RHO  = 1./(1.+ETA) 
        C12G = CATF * (H1_ALG(ETA,XI)+H1_ATG(ETA,XI)) +                 &
     &         CFTF * (H1_FLG(ETA,XI)+H1_FTG(ETA,XI)) +                 &
     &  CATF * BET  * (GFUN_L(ETA,XI)+GFUN_T(ETA,XI)) +                 &
     &  CATF * RHO  * (EFUN_LA(ETA,XI)+EFUN_TA(ETA,XI)) +               &
     &  CFTF * RHO  * (EFUN_LF(ETA,XI)+EFUN_TF(ETA,XI))                 
        C12G = C12G*4.*PI/FACTOR 
      ENDIF 
      C12G_FUN = (X-YWGT)*C12G/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C1B2G_FUN.                                                  
                                                                        
!     ======================================                            
      DOUBLE PRECISION FUNCTION C1B2G_FUN(X) 
!     ======================================                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C1B2G    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI    = 1./FACTOR 
        ETA   = XI * (1.-X)/(4.*X) - 1. 
        BET   = SQRT(ETA/(1.+ETA)) 
        RHO   = 1./(1.+ETA) 
        C1B2G = CATF * (H1BAR_LG(ETA,XI)+H1BAR_TG(ETA,XI)) +            &
     &   CATF * BET  * (GBAR_L(ETA,XI)+GBAR_T(ETA,XI)) +                &
     &   CATF * RHO  * (EBAR_LA(ETA,XI)+EBAR_TA(ETA,XI))                
        C1B2G = C1B2G*4.*PI/FACTOR 
      ENDIF 
      C1B2G_FUN = (X-YWGT)*C1B2G/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C12Q_FUN.                                                   
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION C12Q_FUN(X) 
!     =====================================                             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C12Q    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        BET  = SQRT(ETA/(1.+ETA)) 
        BET3 = BET*BET*BET 
        RHO  = 1./(1.+ETA) 
        C12Q = CFTF * (H1_HLQ(ETA,XI)+H1_HTQ(ETA,XI)) +                 &
     &  CFTF * BET3 * (GFUN_L(ETA,XI)+GFUN_T(ETA,XI))                   
        C12Q = C12Q*4.*PI/FACTOR 
      ENDIF 
      C12Q_FUN = (X-YWGT)*C12Q/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C1B2Q_FUN.                                                  
                                                                        
!     ======================================                            
      DOUBLE PRECISION FUNCTION C1B2Q_FUN(X) 
!     ======================================                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C1B2Q    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI    = 1./FACTOR 
        ETA   = XI * (1.-X)/(4.*X) - 1. 
        BET   = SQRT(ETA/(1.+ETA)) 
        BET3  = BET*BET*BET 
        RHO   = 1./(1.+ETA) 
        C1B2Q = CFTF * (H1BAR_HLQ(ETA,XI)+H1BAR_HTQ(ETA,XI)) +          &
     &   CFTF * BET3 * (GBAR_L(ETA,XI)+GBAR_T(ETA,XI))                  
        C1B2Q = C1B2Q*4.*PI/FACTOR 
      ENDIF 
      C1B2Q_FUN = (X-YWGT)*C1B2Q/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, D12Q_FUN.                                                   
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION D12Q_FUN(X) 
!     =====================================                             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      D12Q    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        IF(QPCG.LE.1.5) THEN 
          D12Q = CFTF * (H1F_LLQ(ETA,XI)+H1F_LTQ(ETA,XI)) 
        ELSE 
          D12Q = CFTF * (H1_LLQ(ETA,XI)+H1_LTQ(ETA,XI)) 
        ENDIF 
        D12Q = D12Q*4.*PI/FACTOR 
      ENDIF 
      D12Q_FUN = (X-YWGT)*D12Q/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, D1B2Q_FUN.                                                  
                                                                        
!     ======================================                            
      DOUBLE PRECISION FUNCTION D1B2Q_FUN(X) 
!     ======================================                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      D1B2Q    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        IF(QPCG.LE.1.5) THEN 
          D1B2Q = CFTF * H1BAR_LTQ(ETA,XI) 
        ELSE 
          D1B2Q = 0. 
        ENDIF 
        D1B2Q = D1B2Q*4.*PI/FACTOR 
      ENDIF 
      D1B2Q_FUN = (X-YWGT)*D1B2Q/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, FIL_FLH.                                                    
                                                                        
!     =======================                                           
      SUBROUTINE FIL_FLH(IDF) 
!     =======================                                           
                                                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      EXTERNAL C0LG_FUN, C1LG_FUN, C1BLG_FUN 
      EXTERNAL           C1LQ_FUN, C1BLQ_FUN 
      EXTERNAL           D1LQ_FUN, D1BLQ_FUN 
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
#ifndef HERA                                                                        
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 120 )
#else
      PARAMETER ( MXX = 410 ) 
      PARAMETER ( MQ2 = 205 )
#endif       
                                                                        
!--   Do not set the following parameter to zero!                       
      PARAMETER ( NDFMAX = 20) 
                                                                        
                                                                        
      COMMON/QCGRID/                                                    &
     &SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,                   &
     &XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,                   &
     &NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),                  &
     &IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)                  
                                                                        
                                                                        
      REAL                                                              &
     &WH_C0KG,WH_C1KG,WH_C1BKG,                                         &
     &WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ                                 
                                                                        
      COMMON/QCHWGT/                                                    &
     &WH_C0KG(0:MXX,MQ2,4:7),                                           &
     &WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),                   &
     &WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),                   &
     &WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)                    
                                                                        
                                                                        
      QMASS  = CBMSTF(IDF) 
                                                                        
      EGAUSS = 0.001 
                                                                        
      DO 400 IQ = 1,NQ2 
                                                                        
        QPCG = Q2TAB(IQ) 
        APCG = 1.+4.*QMASS*QMASS/QPCG 
                                                                        
        IX0 = 1 
        X0  = XHTAB(IX0) 
                                                                        
!       WRITE(6,'('' Calculate FLH weights for IX ='',I4)') IX0         
                                                                        
        DO 200 IX = IX0,NXX 
                                                                        
          XI   = XHTAB(IX) 
          XIP1 = XHTAB(IX+1) 
          IF(IX.GT.IX0) XIM1 = XHTAB(IX-1) 
          IF(XIP1.LE.X0*APCG) GOTO 200 
          XI   = MAX(XI,X0*APCG) 
          SIP1 = X0/XIP1 
          SI   = X0/XI 
                                                                        
          CALL S1FUNC(C0LG_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C0KG(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C0LG_FUN,SI,SIM1,S2FUN) 
            WH_C0KG(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(C1LG_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C1KG(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C1LG_FUN,SI,SIM1,S2FUN) 
            WH_C1KG(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(C1BLG_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C1BKG(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C1BLG_FUN,SI,SIM1,S2FUN) 
            WH_C1BKG(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(C1LQ_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C1KQ(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C1LQ_FUN,SI,SIM1,S2FUN) 
            WH_C1KQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(C1BLQ_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_C1BKQ(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(C1BLQ_FUN,SI,SIM1,S2FUN) 
            WH_C1BKQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
          CALL S1FUNC(D1LQ_FUN,SIP1,SI,S1FUN) 
          IF(IX.EQ.IX0) THEN 
            WH_D1KQ(IX-IX0,IQ,IDF) = S1FUN 
          ELSE 
            SIM1 = X0/XIM1 
            CALL S2FUNC(D1LQ_FUN,SI,SIM1,S2FUN) 
            WH_D1KQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN 
          ENDIF 
                                                                        
!         CALL S1FUNC(D1BLQ_FUN,SIP1,SI,S1FUN)                          
!         IF(IX.EQ.IX0) THEN                                            
!           WH_D1BKQ(IX-IX0,IQ,IDF) = S1FUN                             
!         ELSE                                                          
!           SIM1 = X0/XIM1                                              
!           CALL S2FUNC(D1BLQ_FUN,SI,SIM1,S2FUN)                        
!           WH_D1BKQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN                       
!         ENDIF                                                         
          WH_D1BKQ(IX-IX0,IQ,IDF) = 0. 
                                                                        
  200   CONTINUE 
                                                                        
  400 END DO 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C0LG_FUN.                                                   
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION C0LG_FUN(X) 
!     =====================================                             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      DATA PI       /3.14159265359/ 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C0LG    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        C0LG = C0_LG(ETA,XI) * XI / (2.*PI) 
      ENDIF 
      C0LG_FUN = (X-YWGT)*C0LG/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C1LG_FUN.                                                   
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION C1LG_FUN(X) 
!     =====================================                             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C1LG    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        BET  = SQRT(ETA/(1.+ETA)) 
        RHO  = 1./(1.+ETA) 
        C1LG = CATF * H1_ALG(ETA,XI) +                                  &
     &         CFTF * H1_FLG(ETA,XI) +                                  &
     &  CATF * BET  * GFUN_L(ETA,XI) +                                  &
     &  CATF * RHO  * EFUN_LA(ETA,XI) +                                 &
     &  CFTF * RHO  * EFUN_LF(ETA,XI)                                   
        C1LG = C1LG*4.*PI/FACTOR 
      ENDIF 
      C1LG_FUN = (X-YWGT)*C1LG/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C1BLG_FUN.                                                  
                                                                        
!     ======================================                            
      DOUBLE PRECISION FUNCTION C1BLG_FUN(X) 
!     ======================================                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C1BLG    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI    = 1./FACTOR 
        ETA   = XI * (1.-X)/(4.*X) - 1. 
        BET   = SQRT(ETA/(1.+ETA)) 
        RHO   = 1./(1.+ETA) 
        C1BLG = CATF * H1BAR_LG(ETA,XI) +                               &
     &   CATF * BET  * GBAR_L(ETA,XI) +                                 &
     &   CATF * RHO  * EBAR_LA(ETA,XI)                                  
        C1BLG = C1BLG*4.*PI/FACTOR 
      ENDIF 
      C1BLG_FUN = (X-YWGT)*C1BLG/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C1LQ_FUN.                                                   
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION C1LQ_FUN(X) 
!     =====================================                             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C1LQ    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        BET  = SQRT(ETA/(1.+ETA)) 
        BET3 = BET*BET*BET 
        RHO  = 1./(1.+ETA) 
        C1LQ = CFTF * H1_HLQ(ETA,XI) +                                  &
     &  CFTF * BET3 * GFUN_L(ETA,XI)                                    
        C1LQ = C1LQ*4.*PI/FACTOR 
      ENDIF 
      C1LQ_FUN = (X-YWGT)*C1LQ/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, C1BLQ_FUN.                                                  
                                                                        
!     ======================================                            
      DOUBLE PRECISION FUNCTION C1BLQ_FUN(X) 
!     ======================================                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      C1BLQ    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI    = 1./FACTOR 
        ETA   = XI * (1.-X)/(4.*X) - 1. 
        BET   = SQRT(ETA/(1.+ETA)) 
        BET3  = BET*BET*BET 
        RHO   = 1./(1.+ETA) 
        C1BLQ = CFTF * H1BAR_HLQ(ETA,XI) +                              &
     &   CFTF * BET3 * GBAR_L(ETA,XI)                                   
        C1BLQ = C1BLQ*4.*PI/FACTOR 
      ENDIF 
      C1BLQ_FUN = (X-YWGT)*C1BLQ/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, D1LQ_FUN.                                                   
                                                                        
!     =====================================                             
      DOUBLE PRECISION FUNCTION D1LQ_FUN(X) 
!     =====================================                             
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      FACTOR = QMASS*QMASS/QPCG 
      D1LQ    = 0. 
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN 
        XI   = 1./FACTOR 
        ETA  = XI * (1.-X)/(4.*X) - 1. 
        IF(QPCG.LE.1.5) THEN 
          D1LQ = CFTF * H1F_LLQ(ETA,XI) 
        ELSE 
          D1LQ = CFTF * H1_LLQ(ETA,XI) 
        ENDIF 
        D1LQ = D1LQ*4.*PI/FACTOR 
      ENDIF 
      D1LQ_FUN = (X-YWGT)*D1LQ/(X*X) 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, D1BLQ_FUN.                                                  
                                                                        
!     ======================================                            
      DOUBLE PRECISION FUNCTION D1BLQ_FUN(X) 
!     ======================================                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
                                                                        
                                                                        
      COMMON/QCCONS/                                                    &
     &PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,        &
     &AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),                       &
     &C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,     &
     &C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9, &
     &C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,      &
     &C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF 
                                                                        
                                                                        
                                                                        
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF 
                                                                        
      D1BLQ_FUN = 0. 
                                                                        
      RETURN 
      END                                           
                                                                        
!DECK  ID>, BORN.                                                       
                                                                        
! This gives the Born coefficients                                      
! For QCD take tf = 1d0/2d0, for QED take  tf = 1d0.                    
! eta = (s - 4d0*m2)/4d0/m2, s is the gamma* gluon (gamma) CM Energy    
! xi = Q^2/m2                                                           
                                                                        
!     =======================================                           
      double precision function C0_Lg(eta,xi) 
!     =======================================                           
                                                                        
!     Longitudinal coefficient function: PL B347(1995)143 eq. (7).      
!     This function is called born_l in the original code.              
                                                                        
      implicit none 
      double precision eta, xi, pi, tf 
!     common/group/ca, cf, tf                                           
      parameter(tf = 0.5d0) 
      parameter(pi = 3.14159265359d0) 
                                                                        
      C0_Lg  = 0.5d0*pi*tf*xi*(1.d0 + eta + 0.25d0*xi)**(-3.d0)*        &
     &         (2.d0*dsqrt(eta*(1.d0 + eta)) -                          &
     &         dlog((dsqrt(1.d0 + eta) + dsqrt(eta))/                   &
     &              (dsqrt(1.d0 + eta) - dsqrt(eta))))                  
                                                                        
      return 
      END                                           
                                                                        
!     =======================================                           
      double precision function C0_Tg(eta,xi) 
!     =======================================                           
                                                                        
!     Transverse coefficient function: PL B347(1995)143 eq. (8).        
!     This function is called born_t in the original code.              
                                                                        
      implicit none 
      double precision eta, xi, pi, tf 
!     common/group/ca, cf, tf                                           
      parameter(tf = 0.5d0) 
      parameter(pi = 3.14159265359d0) 
                                                                        
      C0_Tg  = 0.5d0*pi*tf*(1.d0 + eta + 0.25d0*xi)**(-3)*              &
     &         (-2.d0*((1.d0 + eta - 0.25d0*xi)**2 + eta + 1.d0)*       &
     &         dsqrt(eta/(1.d0 + eta)) + (2.d0*(1.d0 + eta)**2 +        &
     &         0.125d0*xi**2 + 2.d0*eta + 1.d0)*                        &
     &         dlog((dsqrt(1.d0 + eta) + dsqrt(eta))/                   &
     &              (dsqrt(1.d0 + eta) - dsqrt(eta))))                  
                                                                        
      return 
      END                                           
                                                                        
!DECK  ID>, ASYMP.                                                      
                                                                        
! These are the functions that give the asymptotic dependence of the    
! coefficient functions with the appropriate factors. xi = mq2/m2 (Q^2/m
! If xi is small, the regular routines have convergence                 
! problems and we take the limit. (not anymore after code update 03/06/9
                                                                        
!     ==========================================                        
      double precision function Gfun_L(dummy,xi) 
!     ==========================================                        
                                                                        
!     Longitudinal: equation (19) in PLB347 (1995) 143 - 151            
!     This function is called asymp_l in the original code.             
                                                                        
      implicit none 
      double precision xilast, store 
      double precision dummy 
      double precision xi, pi, term1 
      double precision fii, fjj 
!     double precision fii_lim, fjj_lim                                 
      parameter (pi = 3.14159265359d0) 
                                                                        
      save xilast, store 
                                                                        
      data xilast, store /0.D0, 0.D0/ 
                                                                        
      if(xi.eq.xilast) then 
        Gfun_L = store 
        return 
      endif 
                                                                        
!     term1 = 1.d0/(1.d0 + 0.25d0*xi)                                   
                                                                        
!     if (xi .le. 1.d-1) then                                           
!        Gfun_L = 1.d0/6.d0/pi*(-4.d0/3.d0*term1 +                      
!    +        (1.d0  - 1.d0/6.d0*term1)*fjj_lim(xi) -                   
!    +        2.d0* (-1.d0/3.d0 + xi/15.d0 - xi**2/70.d0) +             
!    +        0.25d0*term1*fii_lim(xi) -                                
!    +        3.d0* (1.d0/3.d0 - xi/10.d0 + 11.d0*xi**2/420.d0))        
!     else                                                              
!        Gfun_L = 1.d0/6.d0/pi*(4.d0/xi - 4.d0/3.d0*term1               
!    +        + (1.d0 - 2.d0/xi - 1.d0/6.d0*term1)*fjj(xi)              
!    +        - (3.d0/xi + 0.25d0*term1)*fii(xi))                       
!     endif                                                             
                                                                        
      term1   = 1.d0/(1.d0 + 0.25d0*xi) 
                                                                        
      Gfun_L  = 1.d0/6.d0/pi*(4.d0/xi - 4.d0/3.d0*term1                 &
     &     + (1.d0 - 2.d0/xi - 1.d0/6.d0*term1)*fjj(xi)                 &
     &     - (3.d0/xi + 0.25d0*term1)*fii(xi))                          
                                                                        
      xilast = xi 
      store  = Gfun_L 
                                                                        
      return 
      END                                           
                                                                        
!     ==========================================                        
      double precision function Gfun_T(dummy,xi) 
!     ==========================================                        
                                                                        
!     Transverse: equation (20) in PLB347 (1995) 143 - 151              
!     This function is called asymp_t in the original code.             
                                                                        
      implicit none 
      double precision xilast, store 
      double precision dummy 
      double precision xi, pi, term1 
      double precision fii, fjj 
!     double precision fii_lim, fjj_lim                                 
      parameter (pi = 3.14159265359d0) 
                                                                        
      save xilast, store 
                                                                        
      data xilast, store /0.D0, 0.D0/ 
                                                                        
      if(xi.eq.xilast) then 
        Gfun_T = store 
        return 
      endif 
                                                                        
!     term1 = 1.d0/(1.d0 + 0.25d0*xi)                                   
                                                                        
!     if (xi .le. 1.d-1) then                                           
!        Gfun_T = 1.d0/6.d0/pi*(4.d0/3.d0*term1 + (7.d0/6.d0 +          
!    +        1.d0/6.d0*term1)*fjj_lim(xi) + 1/3.d0*                    
!    +        (-1.d0/3.d0 + xi/15.d0 - xi**2/70.d0) +                   
!    +        (1.d0 + 0.25d0*term1)*fii_lim(xi) + 2.d0*                 
!    +        (1.d0/3.d0 - xi/10.d0 + 11.d0*xi**2/420.d0))              
!     else                                                              
!        Gfun_T = 1.d0/6.d0/pi*(-2.d0/3.d0/xi + 4.d0/3.d0*term1         
!    +        + (7.d0/6.d0 + 1.d0/3.d0/xi + 1.d0/6.d0*term1)*fjj(xi)    
!    +        + (1.d0 + 2.d0/xi + 0.25d0*term1)*fii(xi))                
!     endif                                                             
                                                                        
      term1   = 1.d0/(1.d0 + 0.25d0*xi) 
                                                                        
      Gfun_t  = 1.d0/6.d0/pi*(-2.d0/3.d0/xi + 4.d0/3.d0*term1           &
     &     + (7.d0/6.d0 + 1.d0/3.d0/xi + 1.d0/6.d0*term1)*fjj(xi)       &
     &     + (1.d0 + 2.d0/xi + 0.25d0*term1)*fii(xi))                   
                                                                        
      xilast = xi 
      store  = Gfun_T 
                                                                        
      return 
      END                                           
                                                                        
!     ==========================================                        
      double precision function Gbar_L(dummy,xi) 
!     ==========================================                        
                                                                        
!     Longitudinal mass factorization: (21) in PLB347 (1995) 143 - 151  
!     This function is called asympbar_l in the original code.          
                                                                        
      implicit none 
      double precision xilast, store 
      double precision dummy 
      double precision xi, pi, term1 
      double precision fjj 
!     double precision fjj_lim                                          
      parameter (pi = 3.14159265359d0) 
                                                                        
      save xilast, store 
                                                                        
      data xilast, store /0.D0, 0.D0/ 
                                                                        
      if(xi.eq.xilast) then 
        Gbar_L = store 
        return 
      endif 
                                                                        
!     term1 = 1.d0/(1.d0 + 0.25d0*xi)                                   
                                                                        
!     if (xi .le. 1.d-1) then                                           
!        Gbar_L = 1.d0/6.d0/pi*(0.5d0*term1 +                           
!    +        0.25d0*term1*fjj_lim(xi) +                                
!    +        3.d0* (-1.d0/3.d0 + xi/15.d0 - xi**2/70.d0))              
!     else                                                              
!        Gbar_L = 1.d0/6.d0/pi*(-6.d0/xi + 0.5d0*term1                  
!    +        + (3.d0/xi + 0.25d0*term1)*fjj(xi))                       
!     endif                                                             
                                                                        
      term1   = 1.d0/(1.d0 + 0.25d0*xi) 
                                                                        
      Gbar_L  = 1.d0/6.d0/pi*(-6.d0/xi + 0.5d0*term1                    &
     &     + (3.d0/xi + 0.25d0*term1)*fjj(xi))                          
                                                                        
      xilast = xi 
      store  = Gbar_L 
                                                                        
      return 
      END                                           
                                                                        
!     ==========================================                        
      double precision function Gbar_T(dummy,xi) 
!     ==========================================                        
                                                                        
!     transverse mass factorization: (22) in PLB347 (1995) 143 - 151    
!     This function is called asympbar_t in the original code.          
                                                                        
      implicit none 
      double precision xilast, store 
      double precision dummy 
      double precision xi, pi, term1 
      double precision fjj 
!     double precision fjj_lim                                          
      parameter (pi = 3.14159265359d0) 
                                                                        
      save xilast, store 
                                                                        
      data xilast, store /0.D0, 0.D0/ 
                                                                        
      if(xi.eq.xilast) then 
        Gbar_T = store 
        return 
      endif 
                                                                        
!     term1 = 1.d0/(1.d0 + 0.25d0*xi)                                   
                                                                        
!     if (xi .le. 1.d-1) then                                           
!        Gbar_T = 1.d0/6.d0/pi*(-.5d0*term1 -                           
!    +        (1.d0 + 0.25d0*term1)*fjj_lim(xi) -                       
!    +        2.d0* (-1.d0/3.d0 + xi/15.d0 - xi**2/70.d0))              
!     else                                                              
!        Gbar_T = 1.d0/6.d0/pi*(4.d0/xi - 0.5d0*term1                   
!    +        - (1.d0 + 2.d0/xi + 0.25d0*term1)*fjj(xi))                
!     endif                                                             
                                                                        
      term1   = 1.d0/(1.d0 + 0.25d0*xi) 
                                                                        
      Gbar_T  = 1.d0/6.d0/pi*(4.d0/xi - 0.5d0*term1                     &
     &     - (1.d0 + 2.d0/xi + 0.25d0*term1)*fjj(xi))                   
                                                                        
      xilast = xi 
      store  = Gbar_T 
                                                                        
      return 
      END                                           
                                                                        
!     =================================                                 
      double precision function fii(xi) 
!     =================================                                 
                                                                        
!     Equation (24) in PLB347 (1995) 143 - 151                          
                                                                        
      implicit none 
      double precision pi, term1, term2, xi, di_log 
      parameter (pi = 3.14159265359d0) 
                                                                        
      term1 = dsqrt(xi) 
      term2 = dsqrt(4.d0 + xi) 
      fii = 4.d0/term1/term2*(-pi*pi/6.d0                               &
     &      - 0.5d0*(dlog((term2 + term1)/(term2 - term1)))**2          &
     &      + (dlog(0.5d0*(1.d0 - term1/term2)))**2                     &
     &      + 2.d0*di_log(0.5d0*(1.d0 - term1/term2)))                  
                                                                        
      return 
      END                                           
                                                                        
!     =================================                                 
      double precision function fjj(xi) 
!     =================================                                 
                                                                        
!     Equation (23) in PLB347 (1995) 143 - 151                          
                                                                        
      implicit none 
      double precision pi, xi, term1, term2 
      parameter (pi = 3.14159265359d0) 
                                                                        
      term1 = dsqrt(xi) 
      term2 = dsqrt(4.d0 + xi) 
      fjj = 4.d0/term1/term2*dlog((term2 + term1)/(term2 - term1)) 
                                                                        
      return 
      END                                           
                                                                        
!     =====================================                             
      double precision function fii_lim(xi) 
!     =====================================                             
                                                                        
!     this gives fii(xi) in the limit that xi -> 0 up to xi**2          
                                                                        
      implicit none 
      double precision xi 
                                                                        
      fii_lim = xi/3.d0 - xi**2/10.d0 
                                                                        
      return 
      END                                           
                                                                        
!     =====================================                             
      double precision function fjj_lim(xi) 
!     =====================================                             
                                                                        
!     this gives fjj(xi) in the limit that xi -> 0 up to xi**2          
                                                                        
      implicit none 
      double precision xi 
                                                                        
      fjj_lim = 2.d0 - xi/3.d0 + xi**2/15.d0 
                                                                        
      return 
      END                                           
                                                                        
!     ===================================                               
      double precision function di_log(x) 
!     ===================================                               
                                                                        
!     Equation (25) in PLB347 (1995) 143 - 151                          
                                                                        
      implicit double precision  (a-z) 
      dimension b(8) 
      integer ncall 
      data ncall/0/,pi6/1.644934066848226d+00/,een,vier/1.d+00,.25d+00/ 
                                                                        
      ncall = 0 
      if(ncall.eq.0)goto 2 
    1 if(x.lt.0)goto 3 
      if(x.gt.0.5)goto 4 
      z=-dlog(1.-x) 
    7 z2=z*z 
      di_log=z*(z2*(z2*(z2*(z2*(z2*(z2*(z2*b(8)+b(7))+b(6))             &
     & +b(5))+b(4))+b(3))+b(2))+een)-z2*vier                            
      if(x.gt.een)di_log=-di_log-.5*u*u+2.*pi6 
      return 
    2 b(1)=een 
      b(2)=een/36. 
      b(3)=-een/3600. 
      b(4)=een/211680. 
      b(5)=-een/(30.*362880.d+00) 
      b(6)=5./(66.*39916800.d+00) 
      b(7)=-691./(2730.*39916800.d+00*156.) 
      b(8)=een/(39916800.d+00*28080.) 
      ncall=1 
      goto 1 
    3 if(x.gt.-een)goto 5 
      y=een/(een-x) 
      z=-dlog(een-y) 
      z2=z*z 
      u=dlog(y) 
      di_log=z*(z2*(z2*(z2*(z2*(z2*(z2*(z2*b(8)+b(7))+b(6))             &
     & +b(5))+b(4))+b(3))+b(2))+een)-z2*vier-u*(z+.5*u)-pi6             
      return 
    4 if(x.ge.een)goto 10 
      y=een-x 
      z=-dlog(x) 
    6 u=dlog(y) 
      z2=z*z 
      di_log=-z*(z2*(z2*(z2*(z2*(z2*(z2*(z2*b(8)+b(7))+b(6))            &
     & +b(5))+b(4))+b(3))+b(2))+een-u)+z2*vier+pi6                      
      if(x.gt.een)di_log=-di_log-.5*z*z+pi6*2. 
      return 
    5 y=een/(een-x) 
      z=-dlog(y) 
      z2=z*z 
      di_log=-z*(z2*(z2*(z2*(z2*(z2*(z2*(z2*b(8)+b(7))+b(6))            &
     & +b(5))+b(4))+b(3))+b(2))+een)-z2*vier                            
      return 
   10 if(x.eq.een)goto 20 
      xx=1./x 
      if(x.gt.2.)goto 11 
      z=dlog(x) 
      y=1.-xx 
      goto 6 
   11 u=dlog(x) 
      z=-dlog(1.-xx) 
      goto 7 
   20 di_log=pi6 
                                                                        
      return 
      END                                           
                                                                        
!DECK  ID>, THRESH.                                                     
                                                                        
! These are the functions that give the threshold dependence of the     
! coefficient functions with the appropriate factors.                   
! eta = (W^2 - 4d0*m2)/4d0/m2  where W is the CM energy of the          
! gamma* parton system. xi = mq2/m2 (Q^2/m2)                            
                                                                        
!     =========================================                         
      double precision function Efun_LF(eta,xi) 
!     =========================================                         
                                                                        
!     Longitudinal CF group structure: eq (13) in PLB347 (195) 143 - 151
!     This function is called threshf_l in the original code.           
                                                                        
      implicit none 
      double precision pi, eta, xi, beta, term1 
      parameter (pi = 3.14159265359d0) 
                                                                        
      beta = dsqrt(eta/(1.d0 + eta)) 
      term1 = 1.d0/(1.d0 + 0.25d0*xi) 
      Efun_LF = 1.d0/6.d0/pi*xi*term1**3*beta*beta*pi*pi/2.d0 
                                                                        
      return 
      END                                           
                                                                        
!     =========================================                         
      double precision function Efun_TF(eta,xi) 
!     =========================================                         
                                                                        
!     Transverse CF group structure: eq (14) in PLB347 (195) 143 - 151  
!     This function is called threshf_t in the original code.           
                                                                        
      implicit none 
      double precision pi, eta, xi, beta, term1 
      parameter (pi = 3.14159265359d0) 
                                                                        
      beta = dsqrt(eta/(1.d0 + eta)) 
      term1 = 1.d0/(1.d0 + 0.25d0*xi) 
      Efun_TF = 0.25d0/pi*term1*pi*pi/2.d0 
                                                                        
      return 
      END                                           
                                                                        
!     =========================================                         
      double precision function Efun_LA(eta,xi) 
!     =========================================                         
                                                                        
!     Longitudinal CA group structure: eq (15) in PLB347 (195) 143 - 151
!     This function is called thresha_l in the original code.           
                                                                        
      implicit none 
      double precision pi, eta, xi, beta, term1 
      parameter (pi = 3.14159265359d0) 
                                                                        
      beta = dsqrt(eta/(1.d0 + eta)) 
      term1 = 1.d0/(1.d0 + 0.25d0*xi) 
      Efun_LA = 1.d0/6.d0/pi*xi*term1**3*beta**2*                       &
     &     (beta*(dlog(8.d0*beta*beta))**2                              &
     &     - 5.d0*beta*dlog(8.d0*beta*beta) - 0.25d0*pi*pi)             
                                                                        
      return 
      END                                           
                                                                        
!     =========================================                         
      double precision function Efun_TA(eta,xi) 
!     =========================================                         
                                                                        
!     Transverse CA group structure: eq (16) in PLB347 (195) 143 - 151  
!     This function is called thresha_t in the original code.           
      implicit none 
      double precision pi, eta, xi, beta, term1 
      parameter (pi = 3.14159265359d0) 
                                                                        
      beta = dsqrt(eta/(1.d0 + eta)) 
      term1 = 1.d0/(1.d0 + 0.25d0*xi) 
      Efun_TA = 0.25d0/pi*term1*(beta*(dlog(8.d0*beta*beta))**2         &
     &     - 5.d0*beta*dlog(8.d0*beta*beta) - 0.25d0*pi*pi)             
                                                                        
      return 
      END                                           
                                                                        
!     =========================================                         
      double precision function Ebar_LA(eta,xi) 
!     =========================================                         
                                                                        
!     Longitudinal CA group structure for the mass factorization piece: 
!     equation (17) in PLB347 (195) 143 - 151                           
!     This function is called threshbar_l in the original code.         
                                                                        
      implicit none 
      double precision pi, eta, xi, beta, term1 
      parameter (pi = 3.14159265359d0) 
                                                                        
      beta = dsqrt(eta/(1.d0 + eta)) 
      term1 = 1.d0/(1.d0 + 0.25d0*xi) 
      Ebar_LA = 1.d0/6.d0/pi*xi*term1**3*beta**3*                       &
     &     (-dlog(4.d0*beta*beta))                                      
                                                                        
      return 
      END                                           
                                                                        
!     =========================================                         
      double precision function Ebar_TA(eta,xi) 
!     =========================================                         
                                                                        
!     Transverse CA group structure for the mass factorization piece:   
!     equation (18) in PLB347 (195) 143 - 151                           
!     This function is called threshbar_t in the original code.         
                                                                        
      implicit none 
      double precision pi, eta, xi, beta, term1 
      parameter (pi = 3.14159265359d0) 
                                                                        
      beta = dsqrt(eta/(1.d0 + eta)) 
      term1 = 1.d0/(1.d0 + 0.25d0*xi) 
      Ebar_TA = 0.25d0/pi*term1*beta*(-dlog(4.d0*beta*beta)) 
                                                                        
      return 
      END                                           
                                                                        
!DECK  ID>, LOCATE.                                                     
                                                                        
!     ===========================                                       
      Subroutine Locate(xx,n,x,j) 
!     ===========================                                       
!     routine taken out of Numerical Recipes                            
                                                                        
      Integer j,n 
      Double Precision x,xx(n) 
      Integer jl,ju,jm 
                                                                        
      jl = 0 
      ju = n+1 
   10 If (ju - jl .gt. 1) then 
         jm = (ju + jl)/2 
         If ((xx(n) .gt. xx(1)) .eqv. (x .gt. xx(jm))) then 
            jl = jm 
         else 
            ju = jm 
         endif 
         goto 10 
      endif 
      j = jl 
                                                                        
      return 
      END                                           
                                                                        
!DECK  ID>, GCORRT.                                                     
                                                                        
!     ========================================                          
      double precision function h1_ATg(eta,xi) 
!     ========================================                          
                                                                        
!     eq (9) in PLB347 (1995) 143 - 151 for the transverse piece        
!     MSbar scheme                                                      
!     This routine is called subctca in the original code.              
!     Called sctca in updated code (03/06/96).                          
                                                                        
      implicit none 
      integer neta, nxi 
      parameter (neta = 73, nxi = 49) 
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi) 
      double precision eta, xi, dleta, dlxi 
      double precision pxi, peta, f(-1:1), delxi, deleta 
      integer j, ieta, ixi 
                                                                        
      data (calcpts(j, 1), j = 1,neta) /0.4323D-03, 0.5138D-03,         &
     &    0.6270D-03, 0.7996D-03, 0.9331D-03, 0.1128D-02, 0.1413D-02,   &
     &    0.1683D-02, 0.2046D-02, 0.2457D-02, 0.2961D-02, 0.3609D-02,   &
     &    0.4386D-02, 0.5294D-02, 0.6434D-02, 0.7763D-02, 0.9365D-02,   &
     &    0.1136D-01, 0.1370D-01, 0.1657D-01, 0.2004D-01, 0.2424D-01,   &
     &    0.2932D-01, 0.3548D-01, 0.4293D-01, 0.5192D-01, 0.6267D-01,   &
     &    0.7534D-01, 0.8988D-01, 0.1058D+00, 0.1217D+00, 0.1351D+00,   &
     &    0.1421D+00, 0.1379D+00, 0.1184D+00, 0.8306D-01, 0.3588D-01,   &
     &    -.1530D-01, -.6227D-01, -.9944D-01, -.1244D+00, -.1372D+00,   &
     &    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9476D-01,   &
     &    -.8013D-01, -.6655D-01, -.5451D-01, -.4402D-01, -.3519D-01,   &
     &    -.2786D-01, -.2194D-01, -.1711D-01, -.1324D-01, -.1021D-01,   &
     &    -.7860D-02, -.6008D-02, -.4529D-02, -.3433D-02, -.2592D-02,   &
     &    -.1943D-02, -.1488D-02, -.1096D-02, -.8350D-03, -.6387D-03,   &
     &    -.4413D-03, -.3097D-03, -.2442D-03, -.1783D-03, -.1122D-03,   &
     &    -.1126D-03/                                                   
                                                                        
      data (calcpts(j, 2), j = 1,neta) /0.4112D-03, 0.5596D-03,         &
     &    0.6731D-03, 0.7794D-03, 0.9800D-03, 0.1176D-02, 0.1394D-02,   &
     &    0.1665D-02, 0.2028D-02, 0.2507D-02, 0.3011D-02, 0.3593D-02,   &
     &    0.4371D-02, 0.5280D-02, 0.6421D-02, 0.7751D-02, 0.9354D-02,   &
     &    0.1135D-01, 0.1370D-01, 0.1656D-01, 0.2004D-01, 0.2424D-01,   &
     &    0.2932D-01, 0.3547D-01, 0.4293D-01, 0.5191D-01, 0.6265D-01,   &
     &    0.7532D-01, 0.8986D-01, 0.1057D+00, 0.1217D+00, 0.1351D+00,   &
     &    0.1421D+00, 0.1379D+00, 0.1184D+00, 0.8304D-01, 0.3587D-01,   &
     &    -.1531D-01, -.6227D-01, -.9945D-01, -.1244D+00, -.1372D+00,   &
     &    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9475D-01,   &
     &    -.8011D-01, -.6660D-01, -.5450D-01, -.4401D-01, -.3518D-01,   &
     &    -.2791D-01, -.2193D-01, -.1710D-01, -.1329D-01, -.1019D-01,   &
     &    -.7845D-02, -.5992D-02, -.4581D-02, -.3485D-02, -.2577D-02,   &
     &    -.1927D-02, -.1473D-02, -.1081D-02, -.8195D-03, -.6233D-03,   &
     &    -.4258D-03, -.3609D-03, -.2288D-03, -.1629D-03, -.1634D-03,   &
     &    -.9715D-04/                                                   
                                                                        
      data (calcpts(j, 3), j = 1,neta) /0.4469D-03, 0.5291D-03,         &
     &    0.6430D-03, 0.8165D-03, 0.9509D-03, 0.1147D-02, 0.1366D-02,   &
     &    0.1705D-02, 0.2069D-02, 0.2482D-02, 0.2987D-02, 0.3637D-02,   &
     &    0.4350D-02, 0.5326D-02, 0.6402D-02, 0.7734D-02, 0.9338D-02,   &
     &    0.1133D-01, 0.1370D-01, 0.1656D-01, 0.2003D-01, 0.2423D-01,   &
     &    0.2931D-01, 0.3547D-01, 0.4292D-01, 0.5190D-01, 0.6264D-01,   &
     &    0.7531D-01, 0.8984D-01, 0.1057D+00, 0.1216D+00, 0.1351D+00,   &
     &    0.1420D+00, 0.1378D+00, 0.1184D+00, 0.8300D-01, 0.3585D-01,   &
     &    -.1532D-01, -.6227D-01, -.9944D-01, -.1244D+00, -.1372D+00,   &
     &    -.1396D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9473D-01,   &
     &    -.8016D-01, -.6658D-01, -.5447D-01, -.4405D-01, -.3522D-01,   &
     &    -.2789D-01, -.2190D-01, -.1708D-01, -.1326D-01, -.1024D-01,   &
     &    -.7822D-02, -.5970D-02, -.4558D-02, -.3462D-02, -.2621D-02,   &
     &    -.1972D-02, -.1450D-02, -.1125D-02, -.7969D-03, -.6007D-03,   &
     &    -.4699D-03, -.3383D-03, -.2728D-03, -.2069D-03, -.1408D-03,   &
     &    -.7452D-04/                                                   
                                                                        
      data (calcpts(j, 4), j = 1,neta) /0.4681D-03, 0.5509D-03,         &
     &    0.6654D-03, 0.7730D-03, 0.9749D-03, 0.1172D-02, 0.1392D-02,   &
     &    0.1665D-02, 0.2031D-02, 0.2445D-02, 0.3018D-02, 0.3603D-02,   &
     &    0.4384D-02, 0.5296D-02, 0.6441D-02, 0.7775D-02, 0.9382D-02,   &
     &    0.1131D-01, 0.1370D-01, 0.1656D-01, 0.2003D-01, 0.2422D-01,   &
     &    0.2930D-01, 0.3546D-01, 0.4290D-01, 0.5188D-01, 0.6262D-01,   &
     &    0.7528D-01, 0.8980D-01, 0.1057D+00, 0.1216D+00, 0.1350D+00,   &
     &    0.1420D+00, 0.1378D+00, 0.1183D+00, 0.8296D-01, 0.3582D-01,   &
     &    -.1534D-01, -.6228D-01, -.9945D-01, -.1244D+00, -.1372D+00,   &
     &    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9477D-01,   &
     &    -.8013D-01, -.6655D-01, -.5451D-01, -.4402D-01, -.3519D-01,   &
     &    -.2786D-01, -.2194D-01, -.1711D-01, -.1323D-01, -.1020D-01,   &
     &    -.7856D-02, -.6003D-02, -.4525D-02, -.3429D-02, -.2588D-02,   &
     &    -.1938D-02, -.1483D-02, -.1092D-02, -.8303D-03, -.6341D-03,   &
     &    -.4366D-03, -.3050D-03, -.2395D-03, -.1737D-03, -.1076D-03,   &
     &    -.1079D-03/                                                   
                                                                        
      data (calcpts(j, 5), j = 1,neta) /0.4681D-03, 0.5517D-03,         &
     &    0.6672D-03, 0.7759D-03, 0.9790D-03, 0.1178D-02, 0.1399D-02,   &
     &    0.1674D-02, 0.2041D-02, 0.2457D-02, 0.2967D-02, 0.3621D-02,   &
     &    0.4405D-02, 0.5319D-02, 0.6400D-02, 0.7738D-02, 0.9348D-02,   &
     &    0.1135D-01, 0.1369D-01, 0.1655D-01, 0.2002D-01, 0.2421D-01,   &
     &    0.2928D-01, 0.3544D-01, 0.4288D-01, 0.5185D-01, 0.6259D-01,   &
     &    0.7523D-01, 0.8975D-01, 0.1056D+00, 0.1215D+00, 0.1349D+00,   &
     &    0.1419D+00, 0.1377D+00, 0.1182D+00, 0.8289D-01, 0.3577D-01,   &
     &    -.1536D-01, -.6229D-01, -.9945D-01, -.1244D+00, -.1371D+00,   &
     &    -.1396D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9472D-01,   &
     &    -.8015D-01, -.6657D-01, -.5446D-01, -.4404D-01, -.3521D-01,   &
     &    -.2788D-01, -.2189D-01, -.1713D-01, -.1325D-01, -.1022D-01,   &
     &    -.7874D-02, -.6021D-02, -.4543D-02, -.3447D-02, -.2605D-02,   &
     &    -.1956D-02, -.1501D-02, -.1109D-02, -.8482D-03, -.5853D-03,   &
     &    -.4545D-03, -.3229D-03, -.2574D-03, -.1916D-03, -.1254D-03,   &
     &    -.1258D-03/                                                   
                                                                        
      data (calcpts(j, 6), j = 1,neta) /0.4370D-03, 0.5219D-03,         &
     &    0.6388D-03, 0.8157D-03, 0.9540D-03, 0.1155D-02, 0.1379D-02,   &
     &    0.1656D-02, 0.2026D-02, 0.2445D-02, 0.2957D-02, 0.3615D-02,   &
     &    0.4403D-02, 0.5255D-02, 0.6408D-02, 0.7750D-02, 0.9365D-02,   &
     &    0.1130D-01, 0.1368D-01, 0.1653D-01, 0.2000D-01, 0.2419D-01,   &
     &    0.2926D-01, 0.3541D-01, 0.4285D-01, 0.5181D-01, 0.6253D-01,   &
     &    0.7518D-01, 0.8967D-01, 0.1055D+00, 0.1214D+00, 0.1348D+00,   &
     &    0.1418D+00, 0.1375D+00, 0.1181D+00, 0.8279D-01, 0.3571D-01,   &
     &    -.1540D-01, -.6231D-01, -.9945D-01, -.1244D+00, -.1371D+00,   &
     &    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9473D-01,   &
     &    -.8015D-01, -.6657D-01, -.5446D-01, -.4403D-01, -.3520D-01,   &
     &    -.2787D-01, -.2188D-01, -.1712D-01, -.1324D-01, -.1022D-01,   &
     &    -.7869D-02, -.6016D-02, -.4538D-02, -.3442D-02, -.2601D-02,   &
     &    -.1951D-02, -.1496D-02, -.1105D-02, -.8434D-03, -.5804D-03,   &
     &    -.4497D-03, -.3181D-03, -.2526D-03, -.1867D-03, -.1206D-03,   &
     &    -.1210D-03/                                                   
                                                                        
      data (calcpts(j, 7), j = 1,neta) /0.4271D-03, 0.5137D-03,         &
     &    0.6327D-03, 0.8119D-03, 0.9528D-03, 0.1156D-02, 0.1384D-02,   &
     &    0.1664D-02, 0.2038D-02, 0.2462D-02, 0.2979D-02, 0.3643D-02,   &
     &    0.4369D-02, 0.5295D-02, 0.6387D-02, 0.7736D-02, 0.9359D-02,   &
     &    0.1131D-01, 0.1367D-01, 0.1652D-01, 0.1998D-01, 0.2417D-01,   &
     &    0.2923D-01, 0.3537D-01, 0.4280D-01, 0.5175D-01, 0.6246D-01,   &
     &    0.7509D-01, 0.8956D-01, 0.1054D+00, 0.1212D+00, 0.1346D+00,   &
     &    0.1415D+00, 0.1373D+00, 0.1179D+00, 0.8265D-01, 0.3561D-01,   &
     &    -.1546D-01, -.6233D-01, -.9945D-01, -.1243D+00, -.1371D+00,   &
     &    -.1395D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9470D-01,   &
     &    -.8012D-01, -.6654D-01, -.5449D-01, -.4400D-01, -.3517D-01,   &
     &    -.2790D-01, -.2191D-01, -.1709D-01, -.1327D-01, -.1025D-01,   &
     &    -.7831D-02, -.5978D-02, -.4566D-02, -.3470D-02, -.2629D-02,   &
     &    -.1980D-02, -.1458D-02, -.1066D-02, -.8051D-03, -.6089D-03,   &
     &    -.4781D-03, -.3465D-03, -.6143D-03, -.1485D-03, -.1490D-03,   &
     &    -.8274D-04/                                                   
                                                                        
      data (calcpts(j, 8), j = 1,neta) /0.4171D-03, 0.5064D-03,         &
     &    0.6284D-03, 0.8110D-03, 0.9558D-03, 0.1164D-02, 0.1396D-02,   &
     &    0.1682D-02, 0.2062D-02, 0.2492D-02, 0.2950D-02, 0.3621D-02,   &
     &    0.4356D-02, 0.5291D-02, 0.6392D-02, 0.7752D-02, 0.9319D-02,   &
     &    0.1128D-01, 0.1365D-01, 0.1650D-01, 0.1995D-01, 0.2413D-01,   &
     &    0.2919D-01, 0.3531D-01, 0.4273D-01, 0.5167D-01, 0.6235D-01,   &
     &    0.7495D-01, 0.8940D-01, 0.1052D+00, 0.1210D+00, 0.1343D+00,   &
     &    0.1413D+00, 0.1370D+00, 0.1177D+00, 0.8245D-01, 0.3546D-01,   &
     &    -.1554D-01, -.6236D-01, -.9945D-01, -.1243D+00, -.1371D+00,   &
     &    -.1395D+00, -.1340D+00, -.1232D+00, -.1095D+00, -.9470D-01,   &
     &    -.8011D-01, -.6653D-01, -.5448D-01, -.4398D-01, -.3522D-01,   &
     &    -.2788D-01, -.2189D-01, -.1707D-01, -.1325D-01, -.1023D-01,   &
     &    -.7811D-02, -.6025D-02, -.4546D-02, -.3450D-02, -.2609D-02,   &
     &    -.1959D-02, -.1438D-02, -.1113D-02, -.7847D-03, -.5884D-03,   &
     &    -.4576D-03, -.3260D-03, -.2605D-03, -.1947D-03, -.1285D-03,   &
     &    -.1289D-03/                                                   
                                                                        
      data (calcpts(j, 9), j = 1,neta) /0.4435D-03, 0.5367D-03,         &
     &    0.6631D-03, 0.7841D-03, 0.9344D-03, 0.1148D-02, 0.1388D-02,   &
     &    0.1681D-02, 0.2003D-02, 0.2443D-02, 0.2978D-02, 0.3594D-02,   &
     &    0.4342D-02, 0.5289D-02, 0.6406D-02, 0.7714D-02, 0.9296D-02,   &
     &    0.1127D-01, 0.1362D-01, 0.1646D-01, 0.1991D-01, 0.2407D-01,   &
     &    0.2912D-01, 0.3524D-01, 0.4263D-01, 0.5155D-01, 0.6220D-01,   &
     &    0.7476D-01, 0.8916D-01, 0.1049D+00, 0.1206D+00, 0.1339D+00,   &
     &    0.1408D+00, 0.1366D+00, 0.1173D+00, 0.8214D-01, 0.3525D-01,   &
     &    -.1566D-01, -.6242D-01, -.9946D-01, -.1243D+00, -.1371D+00,   &
     &    -.1395D+00, -.1340D+00, -.1232D+00, -.1095D+00, -.9470D-01,   &
     &    -.8011D-01, -.6651D-01, -.5446D-01, -.4403D-01, -.3520D-01,   &
     &    -.2786D-01, -.2194D-01, -.1711D-01, -.1323D-01, -.1020D-01,   &
     &    -.7853D-02, -.6000D-02, -.4521D-02, -.3425D-02, -.2584D-02,   &
     &    -.1934D-02, -.1480D-02, -.1088D-02, -.8263D-03, -.6301D-03,   &
     &    -.4326D-03, -.3010D-03, -.2355D-03, -.1696D-03, -.1035D-03,   &
     &    -.1039D-03/                                                   
                                                                        
      data (calcpts(j,10), j = 1,neta) /0.4611D-03, 0.4933D-03,         &
     &    0.6262D-03, 0.7544D-03, 0.9129D-03, 0.1136D-02, 0.1386D-02,   &
     &    0.1691D-02, 0.2025D-02, 0.2479D-02, 0.2963D-02, 0.3595D-02,   &
     &    0.4361D-02, 0.5262D-02, 0.6332D-02, 0.7662D-02, 0.9268D-02,   &
     &    0.1120D-01, 0.1357D-01, 0.1641D-01, 0.1984D-01, 0.2399D-01,   &
     &    0.2902D-01, 0.3512D-01, 0.4249D-01, 0.5136D-01, 0.6198D-01,   &
     &    0.7448D-01, 0.8881D-01, 0.1045D+00, 0.1201D+00, 0.1333D+00,   &
     &    0.1402D+00, 0.1360D+00, 0.1167D+00, 0.8169D-01, 0.3495D-01,   &
     &    -.1584D-01, -.6249D-01, -.9946D-01, -.1243D+00, -.1370D+00,   &
     &    -.1394D+00, -.1339D+00, -.1231D+00, -.1095D+00, -.9468D-01,   &
     &    -.8007D-01, -.6653D-01, -.5441D-01, -.4398D-01, -.3521D-01,   &
     &    -.2787D-01, -.2188D-01, -.1711D-01, -.1323D-01, -.1021D-01,   &
     &    -.7857D-02, -.6004D-02, -.4525D-02, -.3429D-02, -.2588D-02,   &
     &    -.1938D-02, -.1483D-02, -.1091D-02, -.8300D-03, -.6337D-03,   &
     &    -.4363D-03, -.3047D-03, -.2392D-03, -.1733D-03, -.1072D-03,   &
     &    -.1076D-03/                                                   
                                                                        
      data (calcpts(j,11), j = 1,neta) /0.4058D-03, 0.5130D-03,         &
     &    0.6553D-03, 0.7941D-03, 0.9646D-03, 0.1135D-02, 0.1399D-02,   &
     &    0.1654D-02, 0.2007D-02, 0.2415D-02, 0.2921D-02, 0.3578D-02,   &
     &    0.4303D-02, 0.5233D-02, 0.6333D-02, 0.7629D-02, 0.9268D-02,   &
     &    0.1117D-01, 0.1351D-01, 0.1632D-01, 0.1975D-01, 0.2388D-01,   &
     &    0.2888D-01, 0.3494D-01, 0.4227D-01, 0.5110D-01, 0.6164D-01,   &
     &    0.7406D-01, 0.8831D-01, 0.1038D+00, 0.1194D+00, 0.1325D+00,   &
     &    0.1393D+00, 0.1350D+00, 0.1159D+00, 0.8103D-01, 0.3450D-01,   &
     &    -.1609D-01, -.6259D-01, -.9947D-01, -.1242D+00, -.1369D+00,   &
     &    -.1393D+00, -.1339D+00, -.1231D+00, -.1094D+00, -.9458D-01,   &
     &    -.8003D-01, -.6648D-01, -.5441D-01, -.4397D-01, -.3513D-01,   &
     &    -.2786D-01, -.2187D-01, -.1710D-01, -.1322D-01, -.1019D-01,   &
     &    -.7843D-02, -.5989D-02, -.4577D-02, -.3481D-02, -.2572D-02,   &
     &    -.1990D-02, -.1468D-02, -.1076D-02, -.8148D-03, -.6185D-03,   &
     &    -.4210D-03, -.3561D-03, -.2239D-03, -.1580D-03, -.1586D-03,   &
     &    -.9227D-04/                                                   
                                                                        
      data (calcpts(j,12), j = 1,neta) /0.4531D-03, 0.5058D-03,         &
     &    0.6618D-03, 0.7494D-03, 0.9372D-03, 0.1127D-02, 0.1346D-02,   &
     &    0.1625D-02, 0.2005D-02, 0.2442D-02, 0.2914D-02, 0.3540D-02,   &
     &    0.4304D-02, 0.5208D-02, 0.6287D-02, 0.7563D-02, 0.9184D-02,   &
     &    0.1107D-01, 0.1341D-01, 0.1621D-01, 0.1961D-01, 0.2371D-01,   &
     &    0.2867D-01, 0.3469D-01, 0.4195D-01, 0.5071D-01, 0.6116D-01,   &
     &    0.7347D-01, 0.8757D-01, 0.1029D+00, 0.1183D+00, 0.1313D+00,   &
     &    0.1379D+00, 0.1337D+00, 0.1147D+00, 0.8008D-01, 0.3385D-01,   &
     &    -.1646D-01, -.6275D-01, -.9949D-01, -.1242D+00, -.1368D+00,   &
     &    -.1392D+00, -.1337D+00, -.1230D+00, -.1093D+00, -.9456D-01,   &
     &    -.7998D-01, -.6642D-01, -.5441D-01, -.4396D-01, -.3518D-01,   &
     &    -.2783D-01, -.2190D-01, -.1707D-01, -.1325D-01, -.1022D-01,   &
     &    -.7808D-02, -.5954D-02, -.4542D-02, -.3445D-02, -.2604D-02,   &
     &    -.1954D-02, -.1499D-02, -.1107D-02, -.8456D-03, -.5826D-03,   &
     &    -.4518D-03, -.3202D-03, -.2547D-03, -.1888D-03, -.1227D-03,   &
     &    -.1231D-03/                                                   
                                                                        
      data (calcpts(j,13), j = 1,neta) /0.4062D-03, 0.5431D-03,         &
     &    0.6522D-03, 0.7622D-03, 0.9086D-03, 0.1126D-02, 0.1377D-02,   &
     &    0.1625D-02, 0.1977D-02, 0.2390D-02, 0.2910D-02, 0.3520D-02,   &
     &    0.4273D-02, 0.5104D-02, 0.6247D-02, 0.7524D-02, 0.9082D-02,   &
     &    0.1098D-01, 0.1327D-01, 0.1605D-01, 0.1941D-01, 0.2347D-01,   &
     &    0.2837D-01, 0.3432D-01, 0.4151D-01, 0.5015D-01, 0.6047D-01,   &
     &    0.7261D-01, 0.8651D-01, 0.1017D+00, 0.1168D+00, 0.1295D+00,   &
     &    0.1360D+00, 0.1318D+00, 0.1130D+00, 0.7871D-01, 0.3290D-01,   &
     &    -.1700D-01, -.6298D-01, -.9950D-01, -.1241D+00, -.1367D+00,   &
     &    -.1390D+00, -.1336D+00, -.1228D+00, -.1092D+00, -.9446D-01,   &
     &    -.7991D-01, -.6638D-01, -.5436D-01, -.4389D-01, -.3511D-01,   &
     &    -.2782D-01, -.2189D-01, -.1705D-01, -.1324D-01, -.1021D-01,   &
     &    -.7855D-02, -.6000D-02, -.4521D-02, -.3424D-02, -.2582D-02,   &
     &    -.1932D-02, -.1477D-02, -.1085D-02, -.8239D-03, -.6275D-03,   &
     &    -.4300D-03, -.3650D-03, -.2329D-03, -.1670D-03, -.1009D-03,   &
     &    -.1012D-03/                                                   
                                                                        
      data (calcpts(j,14), j = 1,neta) /0.4179D-03, 0.5134D-03,         &
     &    0.5844D-03, 0.7266D-03, 0.9092D-03, 0.1101D-02, 0.1331D-02,   &
     &    0.1629D-02, 0.1970D-02, 0.2379D-02, 0.2833D-02, 0.3451D-02,   &
     &    0.4151D-02, 0.5069D-02, 0.6103D-02, 0.7411D-02, 0.8938D-02,   &
     &    0.1082D-01, 0.1308D-01, 0.1581D-01, 0.1912D-01, 0.2311D-01,   &
     &    0.2795D-01, 0.3380D-01, 0.4086D-01, 0.4935D-01, 0.5947D-01,   &
     &    0.7138D-01, 0.8499D-01, 0.9979D-01, 0.1146D+00, 0.1270D+00,   &
     &    0.1333D+00, 0.1290D+00, 0.1105D+00, 0.7672D-01, 0.3154D-01,   &
     &    -.1778D-01, -.6329D-01, -.9952D-01, -.1239D+00, -.1364D+00,   &
     &    -.1388D+00, -.1333D+00, -.1226D+00, -.1090D+00, -.9429D-01,   &
     &    -.7975D-01, -.6632D-01, -.5426D-01, -.4385D-01, -.3505D-01,   &
     &    -.2783D-01, -.2182D-01, -.1705D-01, -.1323D-01, -.1020D-01,   &
     &    -.7844D-02, -.5988D-02, -.4575D-02, -.3478D-02, -.2569D-02,   &
     &    -.1986D-02, -.1464D-02, -.1072D-02, -.8103D-03, -.6139D-03,   &
     &    -.4831D-03, -.3514D-03, -.2192D-03, -.1533D-03, -.1539D-03,   &
     &    -.8758D-04/                                                   
                                                                        
      data (calcpts(j,15), j = 1,neta) /0.3832D-03, 0.5148D-03,         &
     &    0.6265D-03, 0.7480D-03, 0.9156D-03, 0.1099D-02, 0.1326D-02,   &
     &    0.1563D-02, 0.1918D-02, 0.2281D-02, 0.2765D-02, 0.3356D-02,   &
     &    0.4104D-02, 0.4945D-02, 0.5978D-02, 0.7226D-02, 0.8765D-02,   &
     &    0.1059D-01, 0.1280D-01, 0.1547D-01, 0.1871D-01, 0.2261D-01,   &
     &    0.2733D-01, 0.3305D-01, 0.3994D-01, 0.4821D-01, 0.5807D-01,   &
     &    0.6963D-01, 0.8283D-01, 0.9717D-01, 0.1114D+00, 0.1234D+00,   &
     &    0.1294D+00, 0.1251D+00, 0.1069D+00, 0.7389D-01, 0.2959D-01,   &
     &    -.1888D-01, -.6375D-01, -.9952D-01, -.1236D+00, -.1361D+00,   &
     &    -.1384D+00, -.1330D+00, -.1223D+00, -.1087D+00, -.9407D-01,   &
     &    -.7959D-01, -.6617D-01, -.5415D-01, -.4378D-01, -.3503D-01,   &
     &    -.2772D-01, -.2184D-01, -.1700D-01, -.1317D-01, -.1021D-01,   &
     &    -.7786D-02, -.5996D-02, -.4515D-02, -.3418D-02, -.2575D-02,   &
     &    -.1925D-02, -.1470D-02, -.1077D-02, -.8160D-03, -.6195D-03,   &
     &    -.4219D-03, -.3569D-03, -.2247D-03, -.1588D-03, -.1594D-03,   &
     &    -.9305D-04/                                                   
                                                                        
      data (calcpts(j,16), j = 1,neta) /0.3814D-03, 0.4972D-03,         &
     &    0.5997D-03, 0.7195D-03, 0.8268D-03, 0.1025D-02, 0.1277D-02,   &
     &    0.1550D-02, 0.1884D-02, 0.2238D-02, 0.2726D-02, 0.3265D-02,   &
     &    0.3976D-02, 0.4791D-02, 0.5810D-02, 0.7055D-02, 0.8466D-02,   &
     &    0.1027D-01, 0.1241D-01, 0.1500D-01, 0.1813D-01, 0.2191D-01,   &
     &    0.2647D-01, 0.3199D-01, 0.3864D-01, 0.4661D-01, 0.5610D-01,   &
     &    0.6719D-01, 0.7983D-01, 0.9351D-01, 0.1071D+00, 0.1184D+00,   &
     &    0.1239D+00, 0.1197D+00, 0.1020D+00, 0.6990D-01, 0.2683D-01,   &
     &    -.2045D-01, -.6437D-01, -.9952D-01, -.1233D+00, -.1355D+00,   &
     &    -.1378D+00, -.1324D+00, -.1218D+00, -.1083D+00, -.9371D-01,   &
     &    -.7932D-01, -.6596D-01, -.5402D-01, -.4368D-01, -.3491D-01,   &
     &    -.2772D-01, -.2176D-01, -.1698D-01, -.1321D-01, -.1018D-01,   &
     &    -.7819D-02, -.5961D-02, -.4545D-02, -.3447D-02, -.2604D-02,   &
     &    -.1953D-02, -.1431D-02, -.1105D-02, -.8437D-03, -.5805D-03,   &
     &    -.4495D-03, -.3178D-03, -.2523D-03, -.1863D-03, -.1202D-03,   &
     &    -.1205D-03/                                                   
                                                                        
      data (calcpts(j,17), j = 1,neta) /0.3666D-03, 0.4863D-03,         &
     &    0.5352D-03, 0.6784D-03, 0.8203D-03, 0.9984D-03, 0.1178D-02,   &
     &    0.1458D-02, 0.1748D-02, 0.2142D-02, 0.2619D-02, 0.3166D-02,   &
     &    0.3768D-02, 0.4559D-02, 0.5569D-02, 0.6687D-02, 0.8117D-02,   &
     &    0.9818D-02, 0.1186D-01, 0.1434D-01, 0.1733D-01, 0.2093D-01,   &
     &    0.2528D-01, 0.3053D-01, 0.3685D-01, 0.4441D-01, 0.5339D-01,   &
     &    0.6385D-01, 0.7572D-01, 0.8853D-01, 0.1012D+00, 0.1116D+00,   &
     &    0.1165D+00, 0.1122D+00, 0.9512D-01, 0.6438D-01, 0.2300D-01,   &
     &    -.2262D-01, -.6522D-01, -.9947D-01, -.1227D+00, -.1347D+00,   &
     &    -.1370D+00, -.1316D+00, -.1211D+00, -.1077D+00, -.9331D-01,   &
     &    -.7897D-01, -.6564D-01, -.5376D-01, -.4350D-01, -.3483D-01,   &
     &    -.2762D-01, -.2171D-01, -.1692D-01, -.1315D-01, -.1017D-01,   &
     &    -.7809D-02, -.5949D-02, -.4532D-02, -.3432D-02, -.2588D-02,   &
     &    -.1938D-02, -.1482D-02, -.1089D-02, -.8271D-03, -.6305D-03,   &
     &    -.4328D-03, -.3010D-03, -.2354D-03, -.1695D-03, -.1033D-03,   &
     &    -.1037D-03/                                                   
                                                                        
      data (calcpts(j,18), j = 1,neta) /0.3296D-03, 0.4115D-03,         &
     &    0.5016D-03, 0.6332D-03, 0.7788D-03, 0.9104D-03, 0.1128D-02,   &
     &    0.1399D-02, 0.1634D-02, 0.1996D-02, 0.2463D-02, 0.2957D-02,   &
     &    0.3596D-02, 0.4314D-02, 0.5208D-02, 0.6295D-02, 0.7644D-02,   &
     &    0.9209D-02, 0.1113D-01, 0.1344D-01, 0.1625D-01, 0.1962D-01,   &
     &    0.2368D-01, 0.2858D-01, 0.3446D-01, 0.4148D-01, 0.4977D-01,   &
     &    0.5941D-01, 0.7029D-01, 0.8195D-01, 0.9335D-01, 0.1026D+00,   &
     &    0.1068D+00, 0.1023D+00, 0.8599D-01, 0.5694D-01, 0.1780D-01,   &
     &    -.2557D-01, -.6633D-01, -.9933D-01, -.1218D+00, -.1335D+00,   &
     &    -.1357D+00, -.1305D+00, -.1201D+00, -.1069D+00, -.9263D-01,   &
     &    -.7842D-01, -.6529D-01, -.5351D-01, -.4325D-01, -.3460D-01,   &
     &    -.2749D-01, -.2163D-01, -.1689D-01, -.1311D-01, -.1012D-01,   &
     &    -.7758D-02, -.5895D-02, -.4542D-02, -.3441D-02, -.2596D-02,   &
     &    -.1945D-02, -.1488D-02, -.1095D-02, -.8333D-03, -.6366D-03,   &
     &    -.4388D-03, -.3069D-03, -.2413D-03, -.1753D-03, -.1091D-03,   &
     &    -.1095D-03/                                                   
                                                                        
      data (calcpts(j,19), j = 1,neta) /0.2951D-03, 0.3689D-03,         &
     &    0.4670D-03, 0.5583D-03, 0.6835D-03, 0.8831D-03, 0.1059D-02,   &
     &    0.1247D-02, 0.1494D-02, 0.1828D-02, 0.2232D-02, 0.2694D-02,   &
     &    0.3265D-02, 0.3947D-02, 0.4766D-02, 0.5738D-02, 0.6961D-02,   &
     &    0.8415D-02, 0.1017D-01, 0.1228D-01, 0.1484D-01, 0.1791D-01,   &
     &    0.2160D-01, 0.2605D-01, 0.3136D-01, 0.3769D-01, 0.4513D-01,   &
     &    0.5373D-01, 0.6336D-01, 0.7359D-01, 0.8345D-01, 0.9125D-01,   &
     &    0.9436D-01, 0.8964D-01, 0.7425D-01, 0.4728D-01, 0.1099D-01,   &
     &    -.2944D-01, -.6772D-01, -.9898D-01, -.1205D+00, -.1318D+00,   &
     &    -.1339D+00, -.1288D+00, -.1187D+00, -.1057D+00, -.9161D-01,   &
     &    -.7767D-01, -.6468D-01, -.5304D-01, -.4296D-01, -.3438D-01,   &
     &    -.2730D-01, -.2148D-01, -.1678D-01, -.1305D-01, -.1006D-01,   &
     &    -.7689D-02, -.5888D-02, -.4466D-02, -.3430D-02, -.2584D-02,   &
     &    -.1931D-02, -.1474D-02, -.1081D-02, -.8188D-03, -.6218D-03,   &
     &    -.4239D-03, -.3586D-03, -.2263D-03, -.1602D-03, -.1607D-03,   &
     &    -.9433D-04/                                                   
                                                                        
      data (calcpts(j,20), j = 1,neta) /0.2649D-03, 0.3628D-03,         &
     &    0.4389D-03, 0.5311D-03, 0.6156D-03, 0.7351D-03, 0.9273D-03,   &
     &    0.1098D-02, 0.1360D-02, 0.1614D-02, 0.1975D-02, 0.2366D-02,   &
     &    0.2840D-02, 0.3463D-02, 0.4193D-02, 0.5110D-02, 0.6146D-02,   &
     &    0.7424D-02, 0.8974D-02, 0.1083D-01, 0.1308D-01, 0.1578D-01,   &
     &    0.1902D-01, 0.2290D-01, 0.2754D-01, 0.3302D-01, 0.3944D-01,   &
     &    0.4679D-01, 0.5495D-01, 0.6349D-01, 0.7155D-01, 0.7762D-01,   &
     &    0.7945D-01, 0.7436D-01, 0.5992D-01, 0.3533D-01, 0.2460D-02,   &
     &    -.3427D-01, -.6935D-01, -.9831D-01, -.1185D+00, -.1292D+00,   &
     &    -.1312D+00, -.1263D+00, -.1166D+00, -.1040D+00, -.9026D-01,   &
     &    -.7664D-01, -.6388D-01, -.5242D-01, -.4250D-01, -.3404D-01,   &
     &    -.2704D-01, -.2125D-01, -.1666D-01, -.1292D-01, -.9981D-02,   &
     &    -.7669D-02, -.5863D-02, -.4437D-02, -.3399D-02, -.2551D-02,   &
     &    -.1897D-02, -.1440D-02, -.1046D-02, -.7831D-03, -.5859D-03,   &
     &    -.4545D-03, -.3224D-03, -.2566D-03, -.1906D-03, -.1243D-03,   &
     &    -.1246D-03/                                                   
                                                                        
      data (calcpts(j,21), j = 1,neta) /0.2746D-03, 0.2937D-03,         &
     &    0.3818D-03, 0.4467D-03, 0.5340D-03, 0.6221D-03, 0.7518D-03,   &
     &    0.9649D-03, 0.1110D-02, 0.1358D-02, 0.1692D-02, 0.2035D-02,   &
     &    0.2442D-02, 0.2911D-02, 0.3557D-02, 0.4292D-02, 0.5185D-02,   &
     &    0.6263D-02, 0.7562D-02, 0.9125D-02, 0.1101D-01, 0.1327D-01,   &
     &    0.1598D-01, 0.1921D-01, 0.2306D-01, 0.2759D-01, 0.3285D-01,   &
     &    0.3881D-01, 0.4535D-01, 0.5204D-01, 0.5812D-01, 0.6231D-01,   &
     &    0.6271D-01, 0.5712D-01, 0.4360D-01, 0.2153D-01, -.7528D-02,   &
     &    -.3993D-01, -.7107D-01, -.9708D-01, -.1155D+00, -.1254D+00,   &
     &    -.1274D+00, -.1229D+00, -.1137D+00, -.1016D+00, -.8842D-01,   &
     &    -.7514D-01, -.6277D-01, -.5157D-01, -.4185D-01, -.3357D-01,   &
     &    -.2671D-01, -.2101D-01, -.1646D-01, -.1276D-01, -.9880D-02,   &
     &    -.7626D-02, -.5813D-02, -.4450D-02, -.3342D-02, -.2559D-02,   &
     &    -.1904D-02, -.1445D-02, -.1051D-02, -.7878D-03, -.5903D-03,   &
     &    -.4587D-03, -.3265D-03, -.2606D-03, -.1945D-03, -.1282D-03,   &
     &    -.1284D-03/                                                   
                                                                        
      data (calcpts(j,22), j = 1,neta) /0.2248D-03, 0.2547D-03,         &
     &    0.3143D-03, 0.3815D-03, 0.4381D-03, 0.5321D-03, 0.6410D-03,   &
     &    0.7432D-03, 0.8898D-03, 0.1121D-02, 0.1291D-02, 0.1588D-02,   &
     &    0.1936D-02, 0.2333D-02, 0.2822D-02, 0.3406D-02, 0.4113D-02,   &
     &    0.4971D-02, 0.5996D-02, 0.7237D-02, 0.8724D-02, 0.1050D-01,   &
     &    0.1263D-01, 0.1517D-01, 0.1817D-01, 0.2168D-01, 0.2572D-01,   &
     &    0.3025D-01, 0.3511D-01, 0.3993D-01, 0.4403D-01, 0.4633D-01,   &
     &    0.4529D-01, 0.3915D-01, 0.2645D-01, 0.6839D-02, -.1830D-01,   &
     &    -.4602D-01, -.7264D-01, -.9510D-01, -.1113D+00, -.1203D+00,   &
     &    -.1222D+00, -.1182D+00, -.1097D+00, -.9839D-01, -.8586D-01,   &
     &    -.7318D-01, -.6123D-01, -.5042D-01, -.4101D-01, -.3296D-01,   &
     &    -.2623D-01, -.2068D-01, -.1623D-01, -.1258D-01, -.9749D-02,   &
     &    -.7485D-02, -.5732D-02, -.4364D-02, -.3319D-02, -.2534D-02,   &
     &    -.1877D-02, -.1418D-02, -.1089D-02, -.8255D-03, -.6277D-03,   &
     &    -.4292D-03, -.2969D-03, -.2309D-03, -.1647D-03, -.1650D-03,   &
     &    -.9859D-04/                                                   
                                                                        
      data (calcpts(j,23), j = 1,neta) /0.1575D-03, 0.1414D-03,         &
     &    0.1837D-03, 0.2659D-03, 0.3061D-03, 0.3553D-03, 0.4615D-03,   &
     &    0.5397D-03, 0.6435D-03, 0.7975D-03, 0.9631D-03, 0.1172D-02,   &
     &    0.1414D-02, 0.1714D-02, 0.2071D-02, 0.2500D-02, 0.3019D-02,   &
     &    0.3651D-02, 0.4404D-02, 0.5304D-02, 0.6396D-02, 0.7693D-02,   &
     &    0.9237D-02, 0.1107D-01, 0.1323D-01, 0.1573D-01, 0.1859D-01,   &
     &    0.2172D-01, 0.2499D-01, 0.2807D-01, 0.3035D-01, 0.3096D-01,   &
     &    0.2865D-01, 0.2205D-01, 0.1012D-01, -.7229D-02, -.2869D-01,   &
     &    -.5179D-01, -.7370D-01, -.9219D-01, -.1057D+00, -.1135D+00,   &
     &    -.1154D+00, -.1120D+00, -.1044D+00, -.9415D-01, -.8249D-01,   &
     &    -.7063D-01, -.5927D-01, -.4896D-01, -.3987D-01, -.3211D-01,   &
     &    -.2564D-01, -.2024D-01, -.1589D-01, -.1234D-01, -.9563D-02,   &
     &    -.7355D-02, -.5661D-02, -.4288D-02, -.3306D-02, -.2452D-02,   &
     &    -.1861D-02, -.1400D-02, -.1070D-02, -.8064D-03, -.6082D-03,   &
     &    -.4095D-03, -.3437D-03, -.2109D-03, -.1447D-03, -.1449D-03,   &
     &    -.7844D-04/                                                   
                                                                        
      data (calcpts(j,24), j = 1,neta) /0.9565D-04, 0.1144D-03,         &
     &    0.1394D-03, 0.1691D-03, 0.2046D-03, 0.2465D-03, 0.2996D-03,   &
     &    0.3624D-03, 0.4374D-03, 0.5335D-03, 0.6405D-03, 0.7778D-03,   &
     &    0.9370D-03, 0.1136D-02, 0.1376D-02, 0.1657D-02, 0.2002D-02,   &
     &    0.2416D-02, 0.2906D-02, 0.3499D-02, 0.4216D-02, 0.5063D-02,   &
     &    0.6065D-02, 0.7252D-02, 0.8636D-02, 0.1023D-01, 0.1200D-01,   &
     &    0.1390D-01, 0.1578D-01, 0.1735D-01, 0.1812D-01, 0.1736D-01,   &
     &    0.1409D-01, 0.7257D-02, -.3859D-02, -.1916D-01, -.3737D-01,   &
     &    -.5634D-01, -.7382D-01, -.8828D-01, -.9890D-01, -.1052D+00,   &
     &    -.1070D+00, -.1043D+00, -.9787D-01, -.8882D-01, -.7832D-01,   &
     &    -.6740D-01, -.5686D-01, -.4712D-01, -.3854D-01, -.3114D-01,   &
     &    -.2486D-01, -.1968D-01, -.1550D-01, -.1206D-01, -.9400D-02,   &
     &    -.7247D-02, -.5546D-02, -.4235D-02, -.3250D-02, -.2460D-02,   &
     &    -.1867D-02, -.1405D-02, -.1008D-02, -.8105D-03, -.6120D-03,   &
     &    -.4130D-03, -.3470D-03, -.2141D-03, -.1478D-03, -.1480D-03,   &
     &    -.8150D-04/                                                   
                                                                        
      data (calcpts(j,25), j = 1,neta) /0.4989D-04, 0.6372D-04,         &
     &    0.7586D-04, 0.9470D-04, 0.1172D-03, 0.1402D-03, 0.1717D-03,   &
     &    0.2067D-03, 0.2498D-03, 0.3003D-03, 0.3632D-03, 0.4391D-03,   &
     &    0.5342D-03, 0.6391D-03, 0.7736D-03, 0.9330D-03, 0.1122D-02,   &
     &    0.1355D-02, 0.1626D-02, 0.1957D-02, 0.2347D-02, 0.2812D-02,   &
     &    0.3356D-02, 0.3994D-02, 0.4725D-02, 0.5546D-02, 0.6430D-02,   &
     &    0.7312D-02, 0.8061D-02, 0.8431D-02, 0.8039D-02, 0.6292D-02,   &
     &    0.2426D-02, -.4343D-02, -.1454D-01, -.2794D-01, -.4336D-01,   &
     &    -.5888D-01, -.7259D-01, -.8343D-01, -.9112D-01, -.9571D-01,   &
     &    -.9709D-01, -.9512D-01, -.9001D-01, -.8241D-01, -.7327D-01,   &
     &    -.6351D-01, -.5389D-01, -.4489D-01, -.3690D-01, -.2994D-01,   &
     &    -.2399D-01, -.1903D-01, -.1502D-01, -.1176D-01, -.9151D-02,   &
     &    -.7055D-02, -.5414D-02, -.4165D-02, -.3177D-02, -.2385D-02,   &
     &    -.1790D-02, -.1394D-02, -.9966D-03, -.7984D-03, -.5996D-03,   &
     &    -.4004D-03, -.3342D-03, -.2013D-03, -.2015D-03, -.1350D-03,   &
     &    -.6850D-04/                                                   
                                                                        
      data (calcpts(j,26), j = 1,neta) /0.1907D-04, 0.1918D-04,         &
     &    0.2593D-04, 0.3718D-04, 0.4555D-04, 0.5013D-04, 0.6176D-04,   &
     &    0.7818D-04, 0.9929D-04, 0.1208D-03, 0.1428D-03, 0.1736D-03,   &
     &    0.2073D-03, 0.2545D-03, 0.3059D-03, 0.3685D-03, 0.4413D-03,   &
     &    0.5237D-03, 0.6323D-03, 0.7488D-03, 0.8974D-03, 0.1060D-02,   &
     &    0.1249D-02, 0.1461D-02, 0.1691D-02, 0.1922D-02, 0.2125D-02,   &
     &    0.2235D-02, 0.2139D-02, 0.1643D-02, 0.4357D-03, -.1939D-02,   &
     &    -.6063D-02, -.1252D-01, -.2168D-01, -.3329D-01, -.4632D-01,   &
     &    -.5906D-01, -.6983D-01, -.7774D-01, -.8286D-01, -.8565D-01,   &
     &    -.8639D-01, -.8491D-01, -.8106D-01, -.7502D-01, -.6742D-01,   &
     &    -.5900D-01, -.5047D-01, -.4236D-01, -.3498D-01, -.2847D-01,   &
     &    -.2293D-01, -.1833D-01, -.1449D-01, -.1135D-01, -.8859D-02,   &
     &    -.6821D-02, -.5307D-02, -.4054D-02, -.3063D-02, -.2336D-02,   &
     &    -.1740D-02, -.1343D-02, -.1012D-02, -.7464D-03, -.5473D-03,   &
     &    -.4146D-03, -.2817D-03, -.2153D-03, -.1489D-03, -.1490D-03,   &
     &    -.8244D-04/                                                   
                                                                        
      data (calcpts(j,27), j = 1,neta) /0.2006D-05, 0.2856D-05,         &
     &    0.1167D-05, 0.3743D-05, 0.5087D-05, -.4811D-06, 0.1882D-06,   &
     &    0.3604D-06, 0.1543D-05, -.4601D-05, -.3152D-05, -.4930D-05,   &
     &    -.8063D-05, -.1520D-04, -.1737D-04, -.2860D-04, -.4090D-04,   &
     &    -.5485D-04, -.6813D-04, -.9724D-04, -.1257D-03, -.1702D-03,   &
     &    -.2322D-03, -.3168D-03, -.4380D-03, -.6165D-03, -.8839D-03,   &
     &    -.1301D-02, -.1962D-02, -.3024D-02, -.4730D-02, -.7424D-02,   &
     &    -.1154D-01, -.1752D-01, -.2560D-01, -.3554D-01, -.4649D-01,   &
     &    -.5701D-01, -.6561D-01, -.7144D-01, -.7456D-01, -.7573D-01,   &
     &    -.7560D-01, -.7426D-01, -.7142D-01, -.6691D-01, -.6092D-01,   &
     &    -.5396D-01, -.4665D-01, -.3949D-01, -.3285D-01, -.2693D-01,   &
     &    -.2181D-01, -.1747D-01, -.1388D-01, -.1092D-01, -.8556D-02,   &
     &    -.6645D-02, -.5126D-02, -.3936D-02, -.3010D-02, -.2281D-02,   &
     &    -.1751D-02, -.1286D-02, -.1021D-02, -.7556D-03, -.5563D-03,   &
     &    -.4235D-03, -.2904D-03, -.2240D-03, -.1575D-03, -.1576D-03,   &
     &    -.9097D-04/                                                   
                                                                        
      data (calcpts(j,28), j = 1,neta) /-.1237D-04, -.1446D-04,         &
     &    -.1884D-04, -.2362D-04, -.3282D-04, -.3729D-04, -.4875D-04,   &
     &    -.5886D-04, -.7149D-04, -.8621D-04, -.1070D-03, -.1237D-03,   &
     &    -.1536D-03, -.1859D-03, -.2326D-03, -.2819D-03, -.3422D-03,   &
     &    -.4187D-03, -.5150D-03, -.6270D-03, -.7669D-03, -.9413D-03,   &
     &    -.1158D-02, -.1426D-02, -.1763D-02, -.2192D-02, -.2745D-02,   &
     &    -.3476D-02, -.4466D-02, -.5839D-02, -.7781D-02, -.1055D-01,   &
     &    -.1448D-01, -.1986D-01, -.2687D-01, -.3531D-01, -.4447D-01,   &
     &    -.5320D-01, -.6021D-01, -.6468D-01, -.6654D-01, -.6648D-01,   &
     &    -.6542D-01, -.6384D-01, -.6161D-01, -.5836D-01, -.5391D-01,   &
     &    -.4846D-01, -.4244D-01, -.3633D-01, -.3050D-01, -.2519D-01,   &
     &    -.2053D-01, -.1653D-01, -.1318D-01, -.1042D-01, -.8179D-02,   &
     &    -.6375D-02, -.4933D-02, -.3800D-02, -.2919D-02, -.2222D-02,   &
     &    -.1691D-02, -.1279D-02, -.9605D-03, -.7213D-03, -.5418D-03,   &
     &    -.4088D-03, -.3024D-03, -.2292D-03, -.1693D-03, -.1227D-03,   &
     &    -.9611D-04/                                                   
                                                                        
      data (calcpts(j,29), j = 1,neta) /-.2297D-04, -.2752D-04,         &
     &    -.3754D-04, -.4311D-04, -.5382D-04, -.5937D-04, -.7678D-04,   &
     &    -.8971D-04, -.1077D-03, -.1287D-03, -.1558D-03, -.1915D-03,   &
     &    -.2322D-03, -.2801D-03, -.3415D-03, -.4181D-03, -.5071D-03,   &
     &    -.6130D-03, -.7460D-03, -.9078D-03, -.1104D-02, -.1346D-02,   &
     &    -.1642D-02, -.2004D-02, -.2451D-02, -.3006D-02, -.3698D-02,   &
     &    -.4577D-02, -.5709D-02, -.7193D-02, -.9172D-02, -.1184D-01,   &
     &    -.1544D-01, -.2018D-01, -.2618D-01, -.3327D-01, -.4091D-01,   &
     &    -.4818D-01, -.5404D-01, -.5768D-01, -.5890D-01, -.5817D-01,   &
     &    -.5640D-01, -.5434D-01, -.5225D-01, -.4982D-01, -.4667D-01,   &
     &    -.4265D-01, -.3795D-01, -.3293D-01, -.2797D-01, -.2331D-01,   &
     &    -.1914D-01, -.1551D-01, -.1244D-01, -.9882D-02, -.7787D-02,   &
     &    -.6085D-02, -.4727D-02, -.3652D-02, -.2803D-02, -.2145D-02,   &
     &    -.1627D-02, -.1235D-02, -.9289D-03, -.6028D-03, -.5232D-03,   &
     &    -.3901D-03, -.2903D-03, -.2171D-03, -.1572D-03, -.1172D-03,   &
     &    -.8393D-04/                                                   
                                                                        
      data (calcpts(j,30), j = 1,neta) /-.2720D-04, -.2861D-04,         &
     &    -.3471D-04, -.4794D-04, -.5707D-04, -.6429D-04, -.7893D-04,   &
     &    -.9699D-04, -.1206D-03, -.1465D-03, -.1769D-03, -.2139D-03,   &
     &    -.2600D-03, -.3148D-03, -.3814D-03, -.4633D-03, -.5624D-03,   &
     &    -.6828D-03, -.8292D-03, -.1008D-02, -.1224D-02, -.1489D-02,   &
     &    -.1811D-02, -.2204D-02, -.2684D-02, -.3275D-02, -.4004D-02,   &
     &    -.4911D-02, -.6053D-02, -.7509D-02, -.9389D-02, -.1184D-01,   &
     &    -.1503D-01, -.1911D-01, -.2418D-01, -.3008D-01, -.3642D-01,   &
     &    -.4249D-01, -.4745D-01, -.5062D-01, -.5165D-01, -.5077D-01,   &
     &    -.4867D-01, -.4620D-01, -.4390D-01, -.4181D-01, -.3953D-01,   &
     &    -.3672D-01, -.3327D-01, -.2936D-01, -.2529D-01, -.2133D-01,   &
     &    -.1768D-01, -.1444D-01, -.1165D-01, -.9313D-02, -.7372D-02,   &
     &    -.5788D-02, -.4514D-02, -.3498D-02, -.2694D-02, -.2069D-02,   &
     &    -.1577D-02, -.1198D-02, -.9051D-03, -.6122D-03, -.5125D-03,   &
     &    -.3860D-03, -.2861D-03, -.2129D-03, -.1596D-03, -.1197D-03,   &
     &    -.8635D-04/                                                   
                                                                        
      data (calcpts(j,31), j = 1,neta) /-.2258D-04, -.3019D-04,         &
     &    -.3714D-04, -.4516D-04, -.5510D-04, -.6652D-04, -.8066D-04,   &
     &    -.9812D-04, -.1185D-03, -.1435D-03, -.1744D-03, -.2112D-03,   &
     &    -.2566D-03, -.3107D-03, -.3767D-03, -.4573D-03, -.5548D-03,   &
     &    -.6731D-03, -.8174D-03, -.9925D-03, -.1204D-02, -.1462D-02,   &
     &    -.1777D-02, -.2159D-02, -.2625D-02, -.3194D-02, -.3891D-02,   &
     &    -.4753D-02, -.5822D-02, -.7163D-02, -.8859D-02, -.1102D-01,   &
     &    -.1377D-01, -.1723D-01, -.2144D-01, -.2631D-01, -.3153D-01,   &
     &    -.3657D-01, -.4081D-01, -.4365D-01, -.4473D-01, -.4408D-01,   &
     &    -.4210D-01, -.3948D-01, -.3692D-01, -.3476D-01, -.3289D-01,   &
     &    -.3091D-01, -.2852D-01, -.2566D-01, -.2249D-01, -.1924D-01,   &
     &    -.1614D-01, -.1332D-01, -.1083D-01, -.8710D-02, -.6933D-02,   &
     &    -.5472D-02, -.4283D-02, -.3333D-02, -.2582D-02, -.1983D-02,   &
     &    -.1517D-02, -.1158D-02, -.8784D-03, -.6120D-03, -.4989D-03,   &
     &    -.3724D-03, -.2791D-03, -.2059D-03, -.1526D-03, -.1126D-03,   &
     &    -.8596D-04/                                                   
                                                                        
      data (calcpts(j,32), j = 1,neta) /-.2433D-04, -.2931D-04,         &
     &    -.3516D-04, -.4244D-04, -.5156D-04, -.6163D-04, -.7470D-04,   &
     &    -.9082D-04, -.1098D-03, -.1328D-03, -.1611D-03, -.1946D-03,   &
     &    -.2361D-03, -.2861D-03, -.3465D-03, -.4206D-03, -.5098D-03,   &
     &    -.6182D-03, -.7499D-03, -.9101D-03, -.1103D-02, -.1340D-02,   &
     &    -.1626D-02, -.1974D-02, -.2397D-02, -.2912D-02, -.3542D-02,   &
     &    -.4314D-02, -.5266D-02, -.6446D-02, -.7921D-02, -.9772D-02,   &
     &    -.1209D-01, -.1496D-01, -.1841D-01, -.2238D-01, -.2663D-01,   &
     &    -.3079D-01, -.3438D-01, -.3695D-01, -.3815D-01, -.3789D-01,   &
     &    -.3633D-01, -.3394D-01, -.3131D-01, -.2897D-01, -.2711D-01,   &
     &    -.2553D-01, -.2389D-01, -.2192D-01, -.1961D-01, -.1709D-01,   &
     &    -.1455D-01, -.1214D-01, -.9967D-02, -.8077D-02, -.6471D-02,   &
     &    -.5135D-02, -.4045D-02, -.3161D-02, -.2449D-02, -.1896D-02,   &
     &    -.1457D-02, -.1111D-02, -.8444D-03, -.6046D-03, -.4781D-03,   &
     &    -.3582D-03, -.2716D-03, -.1983D-03, -.1450D-03, -.1117D-03,   &
     &    -.7837D-04/                                                   
                                                                        
      data (calcpts(j,33), j = 1,neta) /-.1992D-04, -.2417D-04,         &
     &    -.2929D-04, -.3614D-04, -.4347D-04, -.5343D-04, -.6432D-04,   &
     &    -.7849D-04, -.9477D-04, -.1151D-03, -.1399D-03, -.1700D-03,   &
     &    -.2059D-03, -.2498D-03, -.3031D-03, -.3675D-03, -.4459D-03,   &
     &    -.5409D-03, -.6558D-03, -.7954D-03, -.9646D-03, -.1171D-02,   &
     &    -.1420D-02, -.1723D-02, -.2091D-02, -.2539D-02, -.3083D-02,   &
     &    -.3749D-02, -.4566D-02, -.5572D-02, -.6817D-02, -.8362D-02,   &
     &    -.1027D-01, -.1262D-01, -.1541D-01, -.1860D-01, -.2204D-01,   &
     &    -.2544D-01, -.2845D-01, -.3073D-01, -.3201D-01, -.3213D-01,   &
     &    -.3112D-01, -.2920D-01, -.2681D-01, -.2443D-01, -.2244D-01,   &
     &    -.2090D-01, -.1963D-01, -.1830D-01, -.1671D-01, -.1488D-01,   &
     &    -.1290D-01, -.1093D-01, -.9078D-02, -.7432D-02, -.6003D-02,   &
     &    -.4793D-02, -.3795D-02, -.2984D-02, -.2325D-02, -.1805D-02,   &
     &    -.1393D-02, -.1066D-02, -.8131D-03, -.5933D-03, -.4667D-03,   &
     &    -.3535D-03, -.2668D-03, -.2002D-03, -.1469D-03, -.1136D-03,   &
     &    -.8026D-04/                                                   
                                                                        
      data (calcpts(j,34), j = 1,neta) /-.1712D-04, -.2071D-04,         &
     &    -.2527D-04, -.3077D-04, -.3773D-04, -.4540D-04, -.5514D-04,   &
     &    -.6700D-04, -.8094D-04, -.9790D-04, -.1186D-03, -.1438D-03,   &
     &    -.1749D-03, -.2115D-03, -.2566D-03, -.3113D-03, -.3772D-03,   &
     &    -.4571D-03, -.5546D-03, -.6724D-03, -.8150D-03, -.9890D-03,   &
     &    -.1199D-02, -.1454D-02, -.1765D-02, -.2141D-02, -.2598D-02,   &
     &    -.3156D-02, -.3838D-02, -.4672D-02, -.5699D-02, -.6963D-02,   &
     &    -.8515D-02, -.1040D-01, -.1263D-01, -.1518D-01, -.1792D-01,   &
     &    -.2066D-01, -.2314D-01, -.2513D-01, -.2639D-01, -.2679D-01,   &
     &    -.2629D-01, -.2496D-01, -.2303D-01, -.2086D-01, -.1882D-01,   &
     &    -.1719D-01, -.1597D-01, -.1496D-01, -.1390D-01, -.1265D-01,   &
     &    -.1121D-01, -.9674D-02, -.8164D-02, -.6756D-02, -.5513D-02,   &
     &    -.4435D-02, -.3537D-02, -.2791D-02, -.2192D-02, -.1706D-02,   &
     &    -.1319D-02, -.1013D-02, -.7732D-03, -.5733D-03, -.4467D-03,   &
     &    -.3401D-03, -.2535D-03, -.1935D-03, -.1402D-03, -.1068D-03,   &
     &    -.8018D-04/                                                   
                                                                        
      data (calcpts(j,35), j = 1,neta) /-.1442D-04, -.1761D-04,         &
     &    -.2114D-04, -.2543D-04, -.3088D-04, -.3788D-04, -.4561D-04,   &
     &    -.5524D-04, -.6656D-04, -.8093D-04, -.9821D-04, -.1189D-03,   &
     &    -.1444D-03, -.1747D-03, -.2120D-03, -.2566D-03, -.3108D-03,   &
     &    -.3768D-03, -.4572D-03, -.5540D-03, -.6717D-03, -.8145D-03,   &
     &    -.9876D-03, -.1197D-02, -.1452D-02, -.1761D-02, -.2136D-02,   &
     &    -.2592D-02, -.3149D-02, -.3828D-02, -.4659D-02, -.5676D-02,   &
     &    -.6916D-02, -.8412D-02, -.1018D-01, -.1218D-01, -.1435D-01,   &
     &    -.1653D-01, -.1855D-01, -.2023D-01, -.2142D-01, -.2198D-01,   &
     &    -.2186D-01, -.2106D-01, -.1968D-01, -.1791D-01, -.1604D-01,   &
     &    -.1436D-01, -.1306D-01, -.1210D-01, -.1132D-01, -.1049D-01,   &
     &    -.9515D-02, -.8398D-02, -.7220D-02, -.6068D-02, -.5007D-02,   &
     &    -.4069D-02, -.3270D-02, -.2598D-02, -.2052D-02, -.1605D-02,   &
     &    -.1246D-02, -.9591D-03, -.7326D-03, -.5526D-03, -.4260D-03,   &
     &    -.3261D-03, -.2461D-03, -.1861D-03, -.1395D-03, -.1061D-03,   &
     &    -.7946D-04/                                                   
                                                                        
      data (calcpts(j,36), j = 1,neta) /-.1137D-04, -.1382D-04,         &
     &    -.1702D-04, -.2062D-04, -.2489D-04, -.3011D-04, -.3664D-04,   &
     &    -.4486D-04, -.5375D-04, -.6514D-04, -.7944D-04, -.9638D-04,   &
     &    -.1165D-03, -.1415D-03, -.1711D-03, -.2073D-03, -.2513D-03,   &
     &    -.3046D-03, -.3692D-03, -.4476D-03, -.5425D-03, -.6577D-03,   &
     &    -.7973D-03, -.9666D-03, -.1172D-02, -.1421D-02, -.1723D-02,   &
     &    -.2090D-02, -.2536D-02, -.3079D-02, -.3741D-02, -.4548D-02,   &
     &    -.5527D-02, -.6701D-02, -.8081D-02, -.9647D-02, -.1134D-01,   &
     &    -.1306D-01, -.1468D-01, -.1608D-01, -.1713D-01, -.1775D-01,   &
     &    -.1788D-01, -.1748D-01, -.1660D-01, -.1530D-01, -.1377D-01,   &
     &    -.1222D-01, -.1087D-01, -.9851D-02, -.9116D-02, -.8513D-02,   &
     &    -.7875D-02, -.7120D-02, -.6263D-02, -.5366D-02, -.4494D-02,   &
     &    -.3697D-02, -.2997D-02, -.2401D-02, -.1913D-02, -.1499D-02,   &
     &    -.1166D-02, -.9065D-03, -.6999D-03, -.5266D-03, -.4067D-03,   &
     &    -.3067D-03, -.2334D-03, -.1734D-03, -.1334D-03, -.1001D-03,   &
     &    -.7340D-04/                                                   
                                                                        
      data (calcpts(j,37), j = 1,neta) /-.9350D-05, -.1113D-04,         &
     &    -.1370D-04, -.1661D-04, -.2005D-04, -.2421D-04, -.2924D-04,   &
     &    -.3544D-04, -.4294D-04, -.5203D-04, -.6306D-04, -.7640D-04,   &
     &    -.9263D-04, -.1122D-03, -.1360D-03, -.1649D-03, -.1998D-03,   &
     &    -.2422D-03, -.2935D-03, -.3558D-03, -.4312D-03, -.5227D-03,   &
     &    -.6336D-03, -.7680D-03, -.9309D-03, -.1128D-02, -.1368D-02,   &
     &    -.1658D-02, -.2011D-02, -.2439D-02, -.2961D-02, -.3593D-02,   &
     &    -.4358D-02, -.5271D-02, -.6341D-02, -.7553D-02, -.8865D-02,   &
     &    -.1021D-01, -.1149D-01, -.1263D-01, -.1353D-01, -.1413D-01,   &
     &    -.1439D-01, -.1427D-01, -.1377D-01, -.1291D-01, -.1178D-01,   &
     &    -.1050D-01, -.9244D-02, -.8180D-02, -.7389D-02, -.6829D-02,   &
     &    -.6369D-02, -.5881D-02, -.5303D-02, -.4651D-02, -.3971D-02,   &
     &    -.3316D-02, -.2720D-02, -.2199D-02, -.1758D-02, -.1392D-02,   &
     &    -.1095D-02, -.8512D-03, -.6606D-03, -.5066D-03, -.3886D-03,   &
     &    -.2953D-03, -.2240D-03, -.1693D-03, -.1273D-03, -.9535D-04,   &
     &    -.7135D-04/                                                   
                                                                        
      data (calcpts(j,38), j = 1,neta) /-.7323D-05, -.8879D-05,         &
     &    -.1071D-04, -.1298D-04, -.1574D-04, -.1902D-04, -.2306D-04,   &
     &    -.2791D-04, -.3375D-04, -.4091D-04, -.4954D-04, -.6005D-04,   &
     &    -.7274D-04, -.8814D-04, -.1067D-03, -.1294D-03, -.1568D-03,   &
     &    -.1900D-03, -.2303D-03, -.2792D-03, -.3383D-03, -.4100D-03,   &
     &    -.4970D-03, -.6023D-03, -.7300D-03, -.8847D-03, -.1072D-02,   &
     &    -.1299D-02, -.1575D-02, -.1909D-02, -.2315D-02, -.2806D-02,   &
     &    -.3397D-02, -.4101D-02, -.4924D-02, -.5855D-02, -.6865D-02,   &
     &    -.7905D-02, -.8912D-02, -.9819D-02, -.1057D-01, -.1111D-01,   &
     &    -.1141D-01, -.1146D-01, -.1122D-01, -.1071D-01, -.9941D-02,   &
     &    -.8985D-02, -.7943D-02, -.6946D-02, -.6119D-02, -.5514D-02,   &
     &    -.5091D-02, -.4743D-02, -.4372D-02, -.3933D-02, -.3439D-02,   &
     &    -.2928D-02, -.2438D-02, -.1994D-02, -.1609D-02, -.1283D-02,   &
     &    -.1016D-02, -.7942D-03, -.6176D-03, -.4770D-03, -.3677D-03,   &
     &    -.2804D-03, -.2130D-03, -.1610D-03, -.1217D-03, -.9104D-04,   &
     &    -.6771D-04/                                                   
                                                                        
      data (calcpts(j,39), j = 1,neta) /-.5564D-05, -.6759D-05,         &
     &    -.8192D-05, -.9970D-05, -.1212D-04, -.1469D-04, -.1779D-04,   &
     &    -.2157D-04, -.2609D-04, -.3166D-04, -.3838D-04, -.4656D-04,   &
     &    -.5639D-04, -.6835D-04, -.8283D-04, -.1004D-03, -.1217D-03,   &
     &    -.1475D-03, -.1787D-03, -.2167D-03, -.2625D-03, -.3182D-03,   &
     &    -.3856D-03, -.4674D-03, -.5663D-03, -.6863D-03, -.8314D-03,   &
     &    -.1007D-02, -.1221D-02, -.1479D-02, -.1792D-02, -.2170D-02,   &
     &    -.2623D-02, -.3162D-02, -.3790D-02, -.4501D-02, -.5273D-02,   &
     &    -.6072D-02, -.6852D-02, -.7568D-02, -.8177D-02, -.8646D-02,   &
     &    -.8952D-02, -.9074D-02, -.9000D-02, -.8723D-02, -.8246D-02,   &
     &    -.7592D-02, -.6807D-02, -.5974D-02, -.5194D-02, -.4557D-02,   &
     &    -.4098D-02, -.3780D-02, -.3519D-02, -.3239D-02, -.2907D-02,   &
     &    -.2535D-02, -.2153D-02, -.1788D-02, -.1457D-02, -.1175D-02,   &
     &    -.9354D-03, -.7381D-03, -.5775D-03, -.4488D-03, -.3468D-03,   &
     &    -.2662D-03, -.2035D-03, -.1549D-03, -.1169D-03, -.8820D-04,   &
     &    -.6620D-04/                                                   
                                                                        
      data (calcpts(j,40), j = 1,neta) /-.4321D-05, -.5241D-05,         &
     &    -.6319D-05, -.7696D-05, -.9306D-05, -.1129D-04, -.1367D-04,   &
     &    -.1662D-04, -.2009D-04, -.2435D-04, -.2952D-04, -.3579D-04,   &
     &    -.4337D-04, -.5257D-04, -.6371D-04, -.7722D-04, -.9360D-04,   &
     &    -.1134D-03, -.1374D-03, -.1666D-03, -.2019D-03, -.2446D-03,   &
     &    -.2965D-03, -.3593D-03, -.4353D-03, -.5274D-03, -.6389D-03,   &
     &    -.7739D-03, -.9375D-03, -.1135D-02, -.1374D-02, -.1663D-02,   &
     &    -.2009D-02, -.2418D-02, -.2895D-02, -.3434D-02, -.4020D-02,   &
     &    -.4630D-02, -.5230D-02, -.5788D-02, -.6274D-02, -.6666D-02,   &
     &    -.6944D-02, -.7097D-02, -.7115D-02, -.6989D-02, -.6715D-02,   &
     &    -.6298D-02, -.5755D-02, -.5125D-02, -.4469D-02, -.3865D-02,   &
     &    -.3379D-02, -.3033D-02, -.2795D-02, -.2600D-02, -.2389D-02,   &
     &    -.2140D-02, -.1862D-02, -.1578D-02, -.1307D-02, -.1065D-02,   &
     &    -.8552D-03, -.6799D-03, -.5353D-03, -.4180D-03, -.3246D-03,   &
     &    -.2506D-03, -.1920D-03, -.1466D-03, -.1113D-03, -.8399D-04,   &
     &    -.6332D-04/                                                   
                                                                        
      data (calcpts(j,41), j = 1,neta) /-.3334D-05, -.4055D-05,         &
     &    -.4852D-05, -.5910D-05, -.7143D-05, -.8672D-05, -.1049D-04,   &
     &    -.1268D-04, -.1537D-04, -.1864D-04, -.2260D-04, -.2733D-04,   &
     &    -.3314D-04, -.4016D-04, -.4862D-04, -.5896D-04, -.7144D-04,   &
     &    -.8655D-04, -.1049D-03, -.1271D-03, -.1540D-03, -.1866D-03,   &
     &    -.2261D-03, -.2740D-03, -.3319D-03, -.4022D-03, -.4871D-03,   &
     &    -.5900D-03, -.7145D-03, -.8649D-03, -.1047D-02, -.1265D-02,   &
     &    -.1527D-02, -.1837D-02, -.2196D-02, -.2603D-02, -.3046D-02,   &
     &    -.3508D-02, -.3966D-02, -.4397D-02, -.4780D-02, -.5098D-02,   &
     &    -.5339D-02, -.5494D-02, -.5555D-02, -.5518D-02, -.5376D-02,   &
     &    -.5128D-02, -.4777D-02, -.4337D-02, -.3838D-02, -.3328D-02,   &
     &    -.2864D-02, -.2496D-02, -.2236D-02, -.2060D-02, -.1915D-02,   &
     &    -.1757D-02, -.1571D-02, -.1364D-02, -.1157D-02, -.9529D-03,   &
     &    -.7742D-03, -.6209D-03, -.4923D-03, -.3869D-03, -.3023D-03,   &
     &    -.2343D-03, -.1803D-03, -.1383D-03, -.1050D-03, -.7963D-04,   &
     &    -.6029D-04/                                                   
                                                                        
      data (calcpts(j,42), j = 1,neta) /-.2479D-05, -.3065D-05,         &
     &    -.3689D-05, -.4454D-05, -.5396D-05, -.6551D-05, -.7966D-05,   &
     &    -.9624D-05, -.1164D-04, -.1409D-04, -.1709D-04, -.2071D-04,   &
     &    -.2511D-04, -.3044D-04, -.3685D-04, -.4467D-04, -.5412D-04,   &
     &    -.6560D-04, -.7945D-04, -.9630D-04, -.1166D-03, -.1413D-03,   &
     &    -.1713D-03, -.2076D-03, -.2514D-03, -.3046D-03, -.3689D-03,   &
     &    -.4468D-03, -.5409D-03, -.6546D-03, -.7917D-03, -.9566D-03,   &
     &    -.1154D-02, -.1386D-02, -.1657D-02, -.1962D-02, -.2295D-02,   &
     &    -.2644D-02, -.2991D-02, -.3321D-02, -.3618D-02, -.3872D-02,   &
     &    -.4073D-02, -.4215D-02, -.4293D-02, -.4303D-02, -.4241D-02,   &
     &    -.4104D-02, -.3890D-02, -.3602D-02, -.3251D-02, -.2861D-02,   &
     &    -.2468D-02, -.2115D-02, -.1837D-02, -.1644D-02, -.1513D-02,   &
     &    -.1406D-02, -.1289D-02, -.1150D-02, -.9963D-03, -.8400D-03,   &
     &    -.6934D-03, -.5621D-03, -.4501D-03, -.3568D-03, -.2801D-03,   &
     &    -.2181D-03, -.1688D-03, -.1301D-03, -.9944D-04, -.7544D-04,   &
     &    -.5744D-04/                                                   
                                                                        
      data (calcpts(j,43), j = 1,neta) /-.1859D-05, -.2269D-05,         &
     &    -.2779D-05, -.3347D-05, -.4064D-05, -.4958D-05, -.5995D-05,   &
     &    -.7236D-05, -.8771D-05, -.1062D-04, -.1288D-04, -.1560D-04,   &
     &    -.1890D-04, -.2290D-04, -.2775D-04, -.3363D-04, -.4075D-04,   &
     &    -.4937D-04, -.5983D-04, -.7250D-04, -.8785D-04, -.1064D-03,   &
     &    -.1290D-03, -.1563D-03, -.1893D-03, -.2293D-03, -.2777D-03,   &
     &    -.3363D-03, -.4070D-03, -.4925D-03, -.5955D-03, -.7191D-03,   &
     &    -.8667D-03, -.1041D-02, -.1243D-02, -.1471D-02, -.1720D-02,   &
     &    -.1982D-02, -.2244D-02, -.2495D-02, -.2724D-02, -.2923D-02,   &
     &    -.3086D-02, -.3209D-02, -.3288D-02, -.3321D-02, -.3304D-02,   &
     &    -.3235D-02, -.3111D-02, -.2932D-02, -.2702D-02, -.2426D-02,   &
     &    -.2125D-02, -.1824D-02, -.1557D-02, -.1349D-02, -.1205D-02,   &
     &    -.1109D-02, -.1029D-02, -.9423D-03, -.8397D-03, -.7260D-03,   &
     &    -.6111D-03, -.5032D-03, -.4074D-03, -.3254D-03, -.2574D-03,   &
     &    -.2021D-03, -.1574D-03, -.1214D-03, -.9342D-04, -.7142D-04,   &
     &    -.5409D-04/                                                   
                                                                        
      data (calcpts(j,44), j = 1,neta) /-.1425D-05, -.1723D-05,         &
     &    -.2083D-05, -.2524D-05, -.3056D-05, -.3699D-05, -.4481D-05,   &
     &    -.5430D-05, -.6576D-05, -.7963D-05, -.9650D-05, -.1169D-04,   &
     &    -.1416D-04, -.1716D-04, -.2079D-04, -.2519D-04, -.3052D-04,   &
     &    -.3698D-04, -.4482D-04, -.5431D-04, -.6579D-04, -.7972D-04,   &
     &    -.9660D-04, -.1170D-03, -.1417D-03, -.1717D-03, -.2079D-03,   &
     &    -.2518D-03, -.3047D-03, -.3686D-03, -.4455D-03, -.5378D-03,   &
     &    -.6479D-03, -.7776D-03, -.9280D-03, -.1098D-02, -.1284D-02,   &
     &    -.1479D-02, -.1676D-02, -.1865D-02, -.2041D-02, -.2195D-02,   &
     &    -.2325D-02, -.2428D-02, -.2499D-02, -.2539D-02, -.2546D-02,   &
     &    -.2517D-02, -.2450D-02, -.2345D-02, -.2200D-02, -.2016D-02,   &
     &    -.1803D-02, -.1571D-02, -.1344D-02, -.1143D-02, -.9871D-03,   &
     &    -.8809D-03, -.8099D-03, -.7514D-03, -.6872D-03, -.6114D-03,   &
     &    -.5277D-03, -.4433D-03, -.3645D-03, -.2946D-03, -.2351D-03,   &
     &    -.1856D-03, -.1456D-03, -.1129D-03, -.8693D-04, -.6693D-04,   &
     &    -.5093D-04/                                                   
                                                                        
      data (calcpts(j,45), j = 1,neta) /-.1047D-05, -.1275D-05,         &
     &    -.1544D-05, -.1873D-05, -.2268D-05, -.2748D-05, -.3332D-05,   &
     &    -.4036D-05, -.4893D-05, -.5928D-05, -.7185D-05, -.8710D-05,   &
     &    -.1055D-04, -.1279D-04, -.1549D-04, -.1877D-04, -.2276D-04,   &
     &    -.2757D-04, -.3341D-04, -.4049D-04, -.4905D-04, -.5944D-04,   &
     &    -.7201D-04, -.8724D-04, -.1057D-03, -.1280D-03, -.1550D-03,   &
     &    -.1876D-03, -.2271D-03, -.2746D-03, -.3319D-03, -.4005D-03,   &
     &    -.4822D-03, -.5785D-03, -.6900D-03, -.8160D-03, -.9539D-03,   &
     &    -.1099D-02, -.1246D-02, -.1389D-02, -.1522D-02, -.1641D-02,   &
     &    -.1743D-02, -.1826D-02, -.1887D-02, -.1928D-02, -.1945D-02,   &
     &    -.1938D-02, -.1906D-02, -.1846D-02, -.1758D-02, -.1642D-02,   &
     &    -.1499D-02, -.1335D-02, -.1159D-02, -.9869D-03, -.8364D-03,   &
     &    -.7209D-03, -.6425D-03, -.5904D-03, -.5475D-03, -.5002D-03,   &
     &    -.4444D-03, -.3830D-03, -.3212D-03, -.2637D-03, -.2128D-03,   &
     &    -.1696D-03, -.1338D-03, -.1049D-03, -.8132D-04, -.6279D-04,   &
     &    -.4812D-04/                                                   
                                                                        
      data (calcpts(j,46), j = 1,neta) /-.7797D-06, -.9460D-06,         &
     &    -.1149D-05, -.1390D-05, -.1685D-05, -.2043D-05, -.2478D-05,   &
     &    -.3000D-05, -.3631D-05, -.4402D-05, -.5337D-05, -.6469D-05,   &
     &    -.7835D-05, -.9494D-05, -.1150D-04, -.1394D-04, -.1689D-04,   &
     &    -.2047D-04, -.2480D-04, -.3005D-04, -.3641D-04, -.4411D-04,   &
     &    -.5345D-04, -.6475D-04, -.7843D-04, -.9499D-04, -.1150D-03,   &
     &    -.1392D-03, -.1685D-03, -.2037D-03, -.2461D-03, -.2970D-03,   &
     &    -.3574D-03, -.4286D-03, -.5110D-03, -.6042D-03, -.7062D-03,   &
     &    -.8140D-03, -.9235D-03, -.1030D-02, -.1131D-02, -.1222D-02,   &
     &    -.1300D-02, -.1366D-02, -.1417D-02, -.1454D-02, -.1474D-02,   &
     &    -.1479D-02, -.1466D-02, -.1434D-02, -.1383D-02, -.1313D-02,   &
     &    -.1221D-02, -.1110D-02, -.9850D-03, -.8519D-03, -.7227D-03,   &
     &    -.6105D-03, -.5250D-03, -.4674D-03, -.4293D-03, -.3978D-03,   &
     &    -.3632D-03, -.3223D-03, -.2773D-03, -.2321D-03, -.1902D-03,   &
     &    -.1533D-03, -.1220D-03, -.9633D-04, -.7513D-04, -.5833D-04,   &
     &    -.4486D-04/                                                   
                                                                        
      data (calcpts(j,47), j = 1,neta) /-.5812D-06, -.7041D-06,         &
     &    -.8530D-06, -.1034D-05, -.1247D-05, -.1512D-05, -.1830D-05,   &
     &    -.2218D-05, -.2692D-05, -.3258D-05, -.3949D-05, -.4785D-05,   &
     &    -.5798D-05, -.7020D-05, -.8509D-05, -.1031D-04, -.1249D-04,   &
     &    -.1514D-04, -.1834D-04, -.2222D-04, -.2692D-04, -.3261D-04,   &
     &    -.3952D-04, -.4787D-04, -.5798D-04, -.7023D-04, -.8502D-04,   &
     &    -.1029D-03, -.1245D-03, -.1505D-03, -.1819D-03, -.2193D-03,   &
     &    -.2639D-03, -.3164D-03, -.3771D-03, -.4458D-03, -.5210D-03,   &
     &    -.6007D-03, -.6818D-03, -.7614D-03, -.8367D-03, -.9054D-03,   &
     &    -.9658D-03, -.1018D-02, -.1059D-02, -.1090D-02, -.1111D-02,   &
     &    -.1120D-02, -.1118D-02, -.1102D-02, -.1074D-02, -.1032D-02,   &
     &    -.9757D-03, -.9045D-03, -.8198D-03, -.7246D-03, -.6244D-03,   &
     &    -.5279D-03, -.4446D-03, -.3815D-03, -.3393D-03, -.3115D-03,   &
     &    -.2885D-03, -.2631D-03, -.2332D-03, -.2003D-03, -.1675D-03,   &
     &    -.1370D-03, -.1103D-03, -.8765D-04, -.6899D-04, -.5385D-04,   &
     &    -.4165D-04/                                                   
                                                                        
      data (calcpts(j,48), j = 1,neta) /-.4289D-06, -.5178D-06,         &
     &    -.6274D-06, -.7621D-06, -.9198D-06, -.1112D-05, -.1351D-05,   &
     &    -.1637D-05, -.1984D-05, -.2400D-05, -.2909D-05, -.3527D-05,   &
     &    -.4273D-05, -.5175D-05, -.6268D-05, -.7597D-05, -.9203D-05,   &
     &    -.1115D-04, -.1351D-04, -.1637D-04, -.1983D-04, -.2403D-04,   &
     &    -.2912D-04, -.3527D-04, -.4272D-04, -.5174D-04, -.6264D-04,   &
     &    -.7582D-04, -.9172D-04, -.1109D-03, -.1339D-03, -.1615D-03,   &
     &    -.1943D-03, -.2329D-03, -.2775D-03, -.3278D-03, -.3832D-03,   &
     &    -.4419D-03, -.5019D-03, -.5609D-03, -.6172D-03, -.6690D-03,   &
     &    -.7152D-03, -.7550D-03, -.7880D-03, -.8138D-03, -.8322D-03,   &
     &    -.8427D-03, -.8453D-03, -.8395D-03, -.8249D-03, -.8008D-03,   &
     &    -.7669D-03, -.7226D-03, -.6678D-03, -.6033D-03, -.5315D-03,   &
     &    -.4565D-03, -.3860D-03, -.3231D-03, -.2767D-03, -.2458D-03,   &
     &    -.2256D-03, -.2088D-03, -.1903D-03, -.1684D-03, -.1445D-03,   &
     &    -.1206D-03, -.9858D-04, -.7925D-04, -.6292D-04, -.4952D-04,   &
     &    -.3852D-04/                                                   
                                                                        
      data (calcpts(j,49), j = 1,neta) /-.3130D-06, -.3793D-06,         &
     &    -.4580D-06, -.5590D-06, -.6787D-06, -.8204D-06, -.9885D-06,   &
     &    -.1201D-05, -.1456D-05, -.1761D-05, -.2137D-05, -.2588D-05,   &
     &    -.3137D-05, -.3800D-05, -.4604D-05, -.5579D-05, -.6762D-05,   &
     &    -.8190D-05, -.9926D-05, -.1203D-04, -.1457D-04, -.1765D-04,   &
     &    -.2138D-04, -.2590D-04, -.3137D-04, -.3800D-04, -.4600D-04,   &
     &    -.5567D-04, -.6735D-04, -.8141D-04, -.9832D-04, -.1185D-03,   &
     &    -.1426D-03, -.1708D-03, -.2035D-03, -.2405D-03, -.2811D-03,   &
     &    -.3241D-03, -.3683D-03, -.4121D-03, -.4539D-03, -.4927D-03,   &
     &    -.5276D-03, -.5582D-03, -.5840D-03, -.6048D-03, -.6204D-03,   &
     &    -.6307D-03, -.6355D-03, -.6346D-03, -.6277D-03, -.6146D-03,   &
     &    -.5947D-03, -.5677D-03, -.5333D-03, -.4915D-03, -.4427D-03,   &
     &    -.3888D-03, -.3330D-03, -.2798D-03, -.2343D-03, -.2003D-03,   &
     &    -.1778D-03, -.1630D-03, -.1509D-03, -.1374D-03, -.1215D-03,   &
     &    -.1041D-03, -.8673D-04, -.7079D-04, -.5686D-04, -.4513D-04,   &
     &    -.3539D-04/                                                   
                                                                        
      data (dlaeta(j), j = 1,neta) /                                    &
     & -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,       &
     & -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0,       &
     & -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0,               &
     & -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0,       &
     & -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,             &
     & -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,       &
     & -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,&
     & -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,         &
     &  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,           &
     &  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,  &
     &  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,           &
     &  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,           &
     &  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,    &
     &  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0,           &
     &  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/           
                                                                        
      data (dlaxi(j), j = 1,nxi) /                                      &
     & -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,       &
     & -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,       &
     & -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,&
     & -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,         &
     &  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,           &
     &  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,  &
     &  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,           &
     &  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,           &
     &  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,    &
     &  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/                         
                                                                        
      dleta = dlog10(eta) 
      dlxi = dlog10(xi) 
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1) 
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi) 
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta) 
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1) 
      call locate(dlaeta,neta, dleta, ieta) 
      call locate(dlaxi, nxi, dlxi, ixi) 
!     interpolating between the appropriate points                      
      delxi = 1d0/6d0 
      deleta = 1d0/6d0 
!  lagrange 3-pt.                                                       
      if (ixi .le. 2) ixi = 2 
      if (ixi .ge. 48) ixi = 48 
      if (ieta .le. 2) ieta = 2 
      if (ieta .ge. 72) ieta = 72 
      pxi = (dlxi - dlaxi(ixi))/delxi 
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +                 &
     &     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +                         &
     &     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)                      
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +                    &
     &     (1d0 - pxi**2)*calcpts(ieta,ixi) +                           &
     &     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)                        
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +                  &
     &     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +                         &
     &     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)                      
      peta = (dleta - dlaeta(ieta))/deleta 
      h1_ATg = peta*(peta-1d0)/2d0*f(-1) +                              &
     &     (1d0 - peta**2)*f(0) +                                       &
     &     peta*(peta+1d0)/2d0*f(1)                                     
!MB  +     + peta*(peta+1d0)/2d0*f(1)                                   
      return 
      END                                           
                                                                        
!     ========================================                          
      double precision function h1_FTg(eta,xi) 
!     ========================================                          
                                                                        
!     eq (10) in PLB347 (1995) 143 - 151 for the transverse piece       
!     MSbar scheme                                                      
!     This routine is called subctcf in the original code.              
!     Called sctcf in updated code (03/06/96).                          
                                                                        
      implicit none 
      integer neta, nxi 
      parameter (neta = 73, nxi = 49) 
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi) 
      double precision eta, xi, dleta, dlxi 
      double precision pxi, peta, f(-1:1), delxi, deleta 
      integer j, ieta, ixi 
      data (calcpts(j, 1), j = 1,neta) /-.2005D-03, -.2004D-03,         &
     &    -.3501D-03, -.3497D-03, -.4991D-03, -.4983D-03, -.6470D-03,   &
     &    -.7952D-03, -.9425D-03, -.1089D-02, -.1383D-02, -.1524D-02,   &
     &    -.1962D-02, -.2243D-02, -.2666D-02, -.3227D-02, -.3769D-02,   &
     &    -.4434D-02, -.5209D-02, -.6075D-02, -.7007D-02, -.7963D-02,   &
     &    -.8887D-02, -.9694D-02, -.1011D-01, -.1027D-01, -.9623D-02,   &
     &    -.7967D-02, -.4835D-02, -.5091D-03, 0.5340D-02, 0.1151D-01,   &
     &    0.1643D-01, 0.1747D-01, 0.1237D-01, 0.7897D-03, -.1390D-01,   &
     &    -.2616D-01, -.3083D-01, -.2674D-01, -.1655D-01, -.4410D-02,   &
     &    0.6429D-02, 0.1431D-01, 0.1894D-01, 0.2087D-01, 0.2082D-01,   &
     &    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1299D-01, 0.1083D-01,   &
     &    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,   &
     &    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7622D-03, 0.5780D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,   &
     &    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j, 2), j = 1,neta) /-.1546D-03, -.3044D-03,         &
     &    -.3042D-03, -.3038D-03, -.4532D-03, -.4523D-03, -.6011D-03,   &
     &    -.7493D-03, -.8966D-03, -.1043D-02, -.1337D-02, -.1628D-02,   &
     &    -.1916D-02, -.2347D-02, -.2770D-02, -.3181D-02, -.3873D-02,   &
     &    -.4538D-02, -.5313D-02, -.6180D-02, -.6961D-02, -.7918D-02,   &
     &    -.8841D-02, -.9649D-02, -.1022D-01, -.1023D-01, -.9578D-02,   &
     &    -.7923D-02, -.4941D-02, -.4661D-03, 0.5382D-02, 0.1155D-01,   &
     &    0.1647D-01, 0.1750D-01, 0.1240D-01, 0.8170D-03, -.1388D-01,   &
     &    -.2616D-01, -.3083D-01, -.2673D-01, -.1655D-01, -.4404D-02,   &
     &    0.6433D-02, 0.1429D-01, 0.1894D-01, 0.2086D-01, 0.2082D-01,   &
     &    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,   &
     &    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,   &
     &    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7622D-03, 0.5780D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,   &
     &    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j, 3), j = 1,neta) /-.2373D-03, -.2372D-03,         &
     &    -.2369D-03, -.3865D-03, -.3859D-03, -.5351D-03, -.6838D-03,   &
     &    -.6820D-03, -.9793D-03, -.1125D-02, -.1270D-02, -.1561D-02,   &
     &    -.1848D-02, -.2280D-02, -.2703D-02, -.3264D-02, -.3806D-02,   &
     &    -.4471D-02, -.5246D-02, -.6112D-02, -.7044D-02, -.8001D-02,   &
     &    -.8924D-02, -.9582D-02, -.1015D-01, -.1016D-01, -.9512D-02,   &
     &    -.7858D-02, -.4877D-02, -.4031D-03, 0.5293D-02, 0.1145D-01,   &
     &    0.1637D-01, 0.1755D-01, 0.1244D-01, 0.8570D-03, -.1399D-01,   &
     &    -.2615D-01, -.3083D-01, -.2673D-01, -.1656D-01, -.4395D-02,   &
     &    0.6424D-02, 0.1430D-01, 0.1893D-01, 0.2086D-01, 0.2082D-01,   &
     &    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1299D-01, 0.1083D-01,   &
     &    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,   &
     &    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7622D-03, 0.5778D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,   &
     &    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j, 4), j = 1,neta) /-.1385D-03, -.2883D-03,         &
     &    -.2881D-03, -.2877D-03, -.4371D-03, -.5862D-03, -.5850D-03,   &
     &    -.7331D-03, -.8804D-03, -.1026D-02, -.1321D-02, -.1612D-02,   &
     &    -.1900D-02, -.2331D-02, -.2754D-02, -.3165D-02, -.3857D-02,   &
     &    -.4522D-02, -.5297D-02, -.6164D-02, -.6946D-02, -.7902D-02,   &
     &    -.8826D-02, -.9634D-02, -.1020D-01, -.1021D-01, -.9565D-02,   &
     &    -.7912D-02, -.4932D-02, -.4606D-03, 0.5233D-02, 0.1154D-01,   &
     &    0.1645D-01, 0.1748D-01, 0.1236D-01, 0.7658D-03, -.1394D-01,   &
     &    -.2615D-01, -.3082D-01, -.2673D-01, -.1655D-01, -.4398D-02,   &
     &    0.6433D-02, 0.1429D-01, 0.1894D-01, 0.2087D-01, 0.2083D-01,   &
     &    0.1952D-01, 0.1753D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,   &
     &    0.8899D-02, 0.7216D-02, 0.5790D-02, 0.4600D-02, 0.3625D-02,   &
     &    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7622D-03, 0.5778D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,   &
     &    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j, 5), j = 1,neta) /-.1435D-03, -.2933D-03,         &
     &    -.2930D-03, -.2926D-03, -.4421D-03, -.5912D-03, -.5900D-03,   &
     &    -.7381D-03, -.8854D-03, -.1031D-02, -.1326D-02, -.1617D-02,   &
     &    -.1905D-02, -.2336D-02, -.2759D-02, -.3170D-02, -.3862D-02,   &
     &    -.4527D-02, -.5302D-02, -.6169D-02, -.6951D-02, -.7908D-02,   &
     &    -.8831D-02, -.9640D-02, -.1021D-01, -.1022D-01, -.9573D-02,   &
     &    -.7921D-02, -.4944D-02, -.4749D-03, 0.5215D-02, 0.1152D-01,   &
     &    0.1642D-01, 0.1744D-01, 0.1231D-01, 0.8520D-03, -.1402D-01,   &
     &    -.2614D-01, -.3081D-01, -.2671D-01, -.1654D-01, -.4394D-02,   &
     &    0.6431D-02, 0.1430D-01, 0.1893D-01, 0.2087D-01, 0.2083D-01,   &
     &    0.1953D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,   &
     &    0.8898D-02, 0.7216D-02, 0.5788D-02, 0.4600D-02, 0.3625D-02,   &
     &    0.2835D-02, 0.2205D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7621D-03, 0.5778D-03, 0.4365D-03, 0.3286D-03, 0.2464D-03,   &
     &    0.1844D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j, 6), j = 1,neta) /-.2310D-03, -.2308D-03,         &
     &    -.2305D-03, -.3801D-03, -.3795D-03, -.5287D-03, -.6774D-03,   &
     &    -.8256D-03, -.9729D-03, -.1119D-02, -.1263D-02, -.1555D-02,   &
     &    -.1842D-02, -.2274D-02, -.2697D-02, -.3257D-02, -.3799D-02,   &
     &    -.4464D-02, -.5240D-02, -.6107D-02, -.7039D-02, -.7996D-02,   &
     &    -.8920D-02, -.9579D-02, -.1015D-01, -.1016D-01, -.9515D-02,   &
     &    -.7865D-02, -.4891D-02, -.5759D-03, 0.5258D-02, 0.1140D-01,   &
     &    0.1630D-01, 0.1745D-01, 0.1231D-01, 0.8284D-03, -.1392D-01,   &
     &    -.2614D-01, -.3080D-01, -.2671D-01, -.1653D-01, -.4397D-02,   &
     &    0.6421D-02, 0.1430D-01, 0.1894D-01, 0.2086D-01, 0.2082D-01,   &
     &    0.1953D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,   &
     &    0.8897D-02, 0.7216D-02, 0.5788D-02, 0.4599D-02, 0.3625D-02,   &
     &    0.2836D-02, 0.2205D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7621D-03, 0.5779D-03, 0.4365D-03, 0.3284D-03, 0.2464D-03,   &
     &    0.1844D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j, 7), j = 1,neta) /-.2194D-03, -.2192D-03,         &
     &    -.2189D-03, -.3685D-03, -.3680D-03, -.5171D-03, -.6659D-03,   &
     &    -.8140D-03, -.9613D-03, -.1107D-02, -.1252D-02, -.1543D-02,   &
     &    -.1831D-02, -.2262D-02, -.2685D-02, -.3246D-02, -.3788D-02,   &
     &    -.4453D-02, -.5228D-02, -.6096D-02, -.7028D-02, -.7985D-02,   &
     &    -.8910D-02, -.9569D-02, -.1014D-01, -.1030D-01, -.9660D-02,   &
     &    -.7863D-02, -.5043D-02, -.5842D-03, 0.5241D-02, 0.1137D-01,   &
     &    0.1625D-01, 0.1739D-01, 0.1222D-01, 0.7137D-03, -.1391D-01,   &
     &    -.2612D-01, -.3079D-01, -.2669D-01, -.1652D-01, -.4402D-02,   &
     &    0.6419D-02, 0.1429D-01, 0.1892D-01, 0.2086D-01, 0.2081D-01,   &
     &    0.1952D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,   &
     &    0.8896D-02, 0.7215D-02, 0.5787D-02, 0.4599D-02, 0.3625D-02,   &
     &    0.2836D-02, 0.2205D-02, 0.1704D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7621D-03, 0.5779D-03, 0.4365D-03, 0.3285D-03, 0.2464D-03,   &
     &    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j, 8), j = 1,neta) /-.2128D-03, -.2126D-03,         &
     &    -.3623D-03, -.3619D-03, -.3613D-03, -.5105D-03, -.6592D-03,   &
     &    -.8074D-03, -.9547D-03, -.1101D-02, -.1245D-02, -.1536D-02,   &
     &    -.1824D-02, -.2256D-02, -.2679D-02, -.3239D-02, -.3782D-02,   &
     &    -.4447D-02, -.5222D-02, -.6090D-02, -.7022D-02, -.7980D-02,   &
     &    -.8905D-02, -.9566D-02, -.1014D-01, -.1030D-01, -.9663D-02,   &
     &    -.8021D-02, -.5056D-02, -.6067D-03, 0.5056D-02, 0.1132D-01,   &
     &    0.1618D-01, 0.1713D-01, 0.1223D-01, 0.6853D-03, -.1398D-01,   &
     &    -.2611D-01, -.3077D-01, -.2667D-01, -.1652D-01, -.4388D-02,   &
     &    0.6431D-02, 0.1429D-01, 0.1893D-01, 0.2086D-01, 0.2082D-01,   &
     &    0.1951D-01, 0.1753D-01, 0.1526D-01, 0.1298D-01, 0.1083D-01,   &
     &    0.8895D-02, 0.7215D-02, 0.5788D-02, 0.4598D-02, 0.3624D-02,   &
     &    0.2836D-02, 0.2203D-02, 0.1704D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7620D-03, 0.5779D-03, 0.4365D-03, 0.3285D-03, 0.2464D-03,   &
     &    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j, 9), j = 1,neta) /-.1453D-03, -.2952D-03,         &
     &    -.2949D-03, -.2945D-03, -.4439D-03, -.4431D-03, -.5918D-03,   &
     &    -.7400D-03, -.8873D-03, -.1033D-02, -.1328D-02, -.1619D-02,   &
     &    -.1907D-02, -.2188D-02, -.2762D-02, -.3172D-02, -.3864D-02,   &
     &    -.4530D-02, -.5306D-02, -.6023D-02, -.6956D-02, -.7915D-02,   &
     &    -.8841D-02, -.9653D-02, -.1023D-01, -.1024D-01, -.9610D-02,   &
     &    -.7974D-02, -.5019D-02, -.7318D-03, 0.4913D-02, 0.1115D-01,   &
     &    0.1598D-01, 0.1704D-01, 0.1209D-01, 0.6323D-03, -.1395D-01,   &
     &    -.2608D-01, -.3072D-01, -.2665D-01, -.1649D-01, -.4378D-02,   &
     &    0.6416D-02, 0.1428D-01, 0.1891D-01, 0.2085D-01, 0.2080D-01,   &
     &    0.1950D-01, 0.1752D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,   &
     &    0.8894D-02, 0.7213D-02, 0.5787D-02, 0.4599D-02, 0.3624D-02,   &
     &    0.2835D-02, 0.2203D-02, 0.1702D-02, 0.1309D-02, 0.1001D-02,   &
     &    0.7620D-03, 0.5777D-03, 0.4363D-03, 0.3285D-03, 0.2464D-03,   &
     &    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7581D-04, 0.5611D-04,   &
     &    0.4143D-04/                                                   
                                                                        
      data (calcpts(j,10), j = 1,neta) /-.2188D-03, -.2186D-03,         &
     &    -.2183D-03, -.3679D-03, -.3673D-03, -.5165D-03, -.6652D-03,   &
     &    -.8134D-03, -.9608D-03, -.1107D-02, -.1251D-02, -.1543D-02,   &
     &    -.1830D-02, -.2262D-02, -.2685D-02, -.3246D-02, -.3788D-02,   &
     &    -.4454D-02, -.5230D-02, -.6098D-02, -.7032D-02, -.7841D-02,   &
     &    -.8769D-02, -.9583D-02, -.1016D-01, -.1018D-01, -.9704D-02,   &
     &    -.8077D-02, -.5135D-02, -.8675D-03, 0.4751D-02, 0.1096D-01,   &
     &    0.1573D-01, 0.1673D-01, 0.1185D-01, 0.4632D-03, -.1406D-01,   &
     &    -.2606D-01, -.3067D-01, -.2659D-01, -.1647D-01, -.4373D-02,   &
     &    0.6415D-02, 0.1427D-01, 0.1891D-01, 0.2083D-01, 0.2079D-01,   &
     &    0.1950D-01, 0.1752D-01, 0.1526D-01, 0.1297D-01, 0.1082D-01,   &
     &    0.8891D-02, 0.7211D-02, 0.5785D-02, 0.4598D-02, 0.3623D-02,   &
     &    0.2835D-02, 0.2204D-02, 0.1702D-02, 0.1308D-02, 0.1001D-02,   &
     &    0.7619D-03, 0.5776D-03, 0.4364D-03, 0.3285D-03, 0.2463D-03,   &
     &    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7581D-04, 0.5610D-04,   &
     &    0.4142D-04/                                                   
                                                                        
      data (calcpts(j,11), j = 1,neta) /-.1437D-03, -.2935D-03,         &
     &    -.2933D-03, -.2929D-03, -.4423D-03, -.4414D-03, -.5902D-03,   &
     &    -.7384D-03, -.8857D-03, -.1032D-02, -.1326D-02, -.1618D-02,   &
     &    -.1905D-02, -.2187D-02, -.2610D-02, -.3171D-02, -.3714D-02,   &
     &    -.4380D-02, -.5156D-02, -.6025D-02, -.6960D-02, -.7920D-02,   &
     &    -.8850D-02, -.9667D-02, -.1010D-01, -.1028D-01, -.9659D-02,   &
     &    -.8046D-02, -.5273D-02, -.1033D-02, 0.4546D-02, 0.1055D-01,   &
     &    0.1540D-01, 0.1646D-01, 0.1163D-01, 0.4108D-03, -.1410D-01,   &
     &    -.2601D-01, -.3059D-01, -.2652D-01, -.1642D-01, -.4356D-02,   &
     &    0.6410D-02, 0.1426D-01, 0.1888D-01, 0.2081D-01, 0.2078D-01,   &
     &    0.1949D-01, 0.1752D-01, 0.1525D-01, 0.1297D-01, 0.1082D-01,   &
     &    0.8887D-02, 0.7209D-02, 0.5783D-02, 0.4596D-02, 0.3622D-02,   &
     &    0.2834D-02, 0.2202D-02, 0.1703D-02, 0.1308D-02, 0.1000D-02,   &
     &    0.7617D-03, 0.5775D-03, 0.4362D-03, 0.3284D-03, 0.2463D-03,   &
     &    0.1843D-03, 0.1374D-03, 0.1022D-03, 0.7580D-04, 0.5609D-04,   &
     &    0.4142D-04/                                                   
                                                                        
      data (calcpts(j,12), j = 1,neta) /-.1721D-03, -.1719D-03,         &
     &    -.3216D-03, -.3212D-03, -.4707D-03, -.4698D-03, -.6186D-03,   &
     &    -.7668D-03, -.9141D-03, -.1060D-02, -.1355D-02, -.1496D-02,   &
     &    -.1934D-02, -.2216D-02, -.2639D-02, -.3200D-02, -.3743D-02,   &
     &    -.4410D-02, -.5187D-02, -.6056D-02, -.6993D-02, -.7805D-02,   &
     &    -.8738D-02, -.9560D-02, -.1015D-01, -.1019D-01, -.9731D-02,   &
     &    -.8137D-02, -.5394D-02, -.1194D-02, 0.4180D-02, 0.1010D-01,   &
     &    0.1486D-01, 0.1594D-01, 0.1109D-01, 0.1429D-03, -.1411D-01,   &
     &    -.2595D-01, -.3047D-01, -.2643D-01, -.1637D-01, -.4346D-02,   &
     &    0.6403D-02, 0.1424D-01, 0.1885D-01, 0.2079D-01, 0.2076D-01,   &
     &    0.1946D-01, 0.1749D-01, 0.1524D-01, 0.1296D-01, 0.1081D-01,   &
     &    0.8882D-02, 0.7204D-02, 0.5779D-02, 0.4593D-02, 0.3620D-02,   &
     &    0.2833D-02, 0.2201D-02, 0.1701D-02, 0.1308D-02, 0.1000D-02,   &
     &    0.7615D-03, 0.5774D-03, 0.4361D-03, 0.3282D-03, 0.2463D-03,   &
     &    0.1841D-03, 0.1373D-03, 0.1021D-03, 0.7577D-04, 0.5607D-04,   &
     &    0.4140D-04/                                                   
                                                                        
      data (calcpts(j,13), j = 1,neta) /-.1707D-03, -.1705D-03,         &
     &    -.3202D-03, -.3198D-03, -.4693D-03, -.4684D-03, -.6172D-03,   &
     &    -.7654D-03, -.9128D-03, -.1059D-02, -.1353D-02, -.1495D-02,   &
     &    -.1783D-02, -.2215D-02, -.2639D-02, -.3200D-02, -.3743D-02,   &
     &    -.4410D-02, -.5188D-02, -.5909D-02, -.6848D-02, -.7813D-02,   &
     &    -.8751D-02, -.9579D-02, -.1018D-01, -.1023D-01, -.9793D-02,   &
     &    -.8378D-02, -.5676D-02, -.1534D-02, 0.3758D-02, 0.9572D-02,   &
     &    0.1418D-01, 0.1522D-01, 0.1059D-01, -.1719D-03, -.1426D-01,   &
     &    -.2585D-01, -.3032D-01, -.2629D-01, -.1629D-01, -.4321D-02,   &
     &    0.6391D-02, 0.1421D-01, 0.1882D-01, 0.2075D-01, 0.2072D-01,   &
     &    0.1943D-01, 0.1748D-01, 0.1521D-01, 0.1294D-01, 0.1080D-01,   &
     &    0.8874D-02, 0.7198D-02, 0.5775D-02, 0.4590D-02, 0.3617D-02,   &
     &    0.2831D-02, 0.2200D-02, 0.1700D-02, 0.1307D-02, 0.9996D-03,   &
     &    0.7612D-03, 0.5771D-03, 0.4359D-03, 0.3281D-03, 0.2462D-03,   &
     &    0.1841D-03, 0.1373D-03, 0.1021D-03, 0.7575D-04, 0.5606D-04,   &
     &    0.4139D-04/                                                   
                                                                        
      data (calcpts(j,14), j = 1,neta) /-.1968D-03, -.1967D-03,         &
     &    -.3464D-03, -.3460D-03, -.3455D-03, -.4946D-03, -.6434D-03,   &
     &    -.7917D-03, -.9391D-03, -.1085D-02, -.1230D-02, -.1521D-02,   &
     &    -.1809D-02, -.2242D-02, -.2666D-02, -.3077D-02, -.3621D-02,   &
     &    -.4289D-02, -.5069D-02, -.5942D-02, -.6883D-02, -.7703D-02,   &
     &    -.8647D-02, -.9484D-02, -.1010D-01, -.1032D-01, -.9760D-02,   &
     &    -.8537D-02, -.5893D-02, -.1986D-02, 0.3039D-02, 0.8692D-02,   &
     &    0.1309D-01, 0.1430D-01, 0.9794D-02, -.7502D-03, -.1435D-01,   &
     &    -.2570D-01, -.3009D-01, -.2609D-01, -.1617D-01, -.4278D-02,   &
     &    0.6379D-02, 0.1415D-01, 0.1876D-01, 0.2070D-01, 0.2068D-01,   &
     &    0.1941D-01, 0.1744D-01, 0.1520D-01, 0.1292D-01, 0.1078D-01,   &
     &    0.8862D-02, 0.7189D-02, 0.5769D-02, 0.4586D-02, 0.3615D-02,   &
     &    0.2828D-02, 0.2198D-02, 0.1699D-02, 0.1306D-02, 0.9988D-03,   &
     &    0.7606D-03, 0.5768D-03, 0.4357D-03, 0.3279D-03, 0.2461D-03,   &
     &    0.1840D-03, 0.1372D-03, 0.1021D-03, 0.7573D-04, 0.5604D-04,   &
     &    0.4138D-04/                                                   
                                                                        
      data (calcpts(j,15), j = 1,neta) /-.1824D-03, -.1823D-03,         &
     &    -.3320D-03, -.3316D-03, -.4811D-03, -.4803D-03, -.6291D-03,   &
     &    -.7773D-03, -.9248D-03, -.1071D-02, -.1216D-02, -.1507D-02,   &
     &    -.1796D-02, -.2228D-02, -.2503D-02, -.3065D-02, -.3610D-02,   &
     &    -.4279D-02, -.5061D-02, -.5787D-02, -.6732D-02, -.7708D-02,   &
     &    -.8511D-02, -.9361D-02, -.9993D-02, -.1024D-01, -.9876D-02,   &
     &    -.8711D-02, -.6303D-02, -.2665D-02, 0.2193D-02, 0.7467D-02,   &
     &    0.1186D-01, 0.1284D-01, 0.8604D-02, -.1434D-02, -.1442D-01,   &
     &    -.2550D-01, -.2975D-01, -.2580D-01, -.1602D-01, -.4239D-02,   &
     &    0.6339D-02, 0.1408D-01, 0.1867D-01, 0.2062D-01, 0.2060D-01,   &
     &    0.1933D-01, 0.1739D-01, 0.1515D-01, 0.1289D-01, 0.1076D-01,   &
     &    0.8844D-02, 0.7176D-02, 0.5758D-02, 0.4578D-02, 0.3609D-02,   &
     &    0.2824D-02, 0.2195D-02, 0.1697D-02, 0.1304D-02, 0.9978D-03,   &
     &    0.7599D-03, 0.5762D-03, 0.4354D-03, 0.3277D-03, 0.2459D-03,   &
     &    0.1839D-03, 0.1371D-03, 0.1020D-03, 0.7567D-04, 0.5600D-04,   &
     &    0.4136D-04/                                                   
                                                                        
      data (calcpts(j,16), j = 1,neta) /-.1800D-03, -.1799D-03,         &
     &    -.3296D-03, -.3292D-03, -.3287D-03, -.4779D-03, -.6267D-03,   &
     &    -.6250D-03, -.7725D-03, -.1069D-02, -.1213D-02, -.1506D-02,   &
     &    -.1794D-02, -.2077D-02, -.2502D-02, -.2915D-02, -.3612D-02,   &
     &    -.4133D-02, -.4917D-02, -.5647D-02, -.6598D-02, -.7583D-02,   &
     &    -.8399D-02, -.9268D-02, -.9927D-02, -.1022D-01, -.1006D-01,   &
     &    -.8976D-02, -.6836D-02, -.3517D-02, 0.9542D-03, 0.5906D-02,   &
     &    0.1002D-01, 0.1105D-01, 0.7198D-02, -.2258D-02, -.1472D-01,   &
     &    -.2521D-01, -.2927D-01, -.2542D-01, -.1580D-01, -.4190D-02,   &
     &    0.6275D-02, 0.1396D-01, 0.1855D-01, 0.2048D-01, 0.2050D-01,   &
     &    0.1925D-01, 0.1732D-01, 0.1510D-01, 0.1285D-01, 0.1073D-01,   &
     &    0.8819D-02, 0.7157D-02, 0.5744D-02, 0.4567D-02, 0.3601D-02,   &
     &    0.2819D-02, 0.2191D-02, 0.1694D-02, 0.1302D-02, 0.9963D-03,   &
     &    0.7588D-03, 0.5754D-03, 0.4348D-03, 0.3272D-03, 0.2455D-03,   &
     &    0.1837D-03, 0.1370D-03, 0.1019D-03, 0.7560D-04, 0.5596D-04,   &
     &    0.4132D-04/                                                   
                                                                        
      data (calcpts(j,17), j = 1,neta) /-.1148D-03, -.2646D-03,         &
     &    -.2644D-03, -.2640D-03, -.4135D-03, -.4127D-03, -.5616D-03,   &
     &    -.7100D-03, -.8576D-03, -.1004D-02, -.1149D-02, -.1441D-02,   &
     &    -.1730D-02, -.2013D-02, -.2439D-02, -.2854D-02, -.3402D-02,   &
     &    -.4076D-02, -.4714D-02, -.5599D-02, -.6409D-02, -.7256D-02,   &
     &    -.8239D-02, -.9134D-02, -.9831D-02, -.1017D-01, -.1010D-01,   &
     &    -.9280D-02, -.7456D-02, -.4522D-02, -.5274D-03, 0.3977D-02,   &
     &    0.7644D-02, 0.8816D-02, 0.5388D-02, -.3332D-02, -.1483D-01,   &
     &    -.2478D-01, -.2863D-01, -.2489D-01, -.1552D-01, -.4146D-02,   &
     &    0.6172D-02, 0.1378D-01, 0.1835D-01, 0.2029D-01, 0.2033D-01,   &
     &    0.1912D-01, 0.1722D-01, 0.1502D-01, 0.1278D-01, 0.1068D-01,   &
     &    0.8782D-02, 0.7130D-02, 0.5725D-02, 0.4553D-02, 0.3590D-02,   &
     &    0.2811D-02, 0.2186D-02, 0.1690D-02, 0.1299D-02, 0.9941D-03,   &
     &    0.7572D-03, 0.5743D-03, 0.4340D-03, 0.3268D-03, 0.2452D-03,   &
     &    0.1835D-03, 0.1368D-03, 0.1018D-03, 0.7550D-04, 0.5588D-04,   &
     &    0.4127D-04/                                                   
                                                                        
      data (calcpts(j,18), j = 1,neta) /-.1467D-03, -.1465D-03,         &
     &    -.2963D-03, -.2960D-03, -.2955D-03, -.4447D-03, -.5937D-03,   &
     &    -.5921D-03, -.7398D-03, -.8864D-03, -.1181D-02, -.1324D-02,   &
     &    -.1613D-02, -.1898D-02, -.2325D-02, -.2741D-02, -.3291D-02,   &
     &    -.3819D-02, -.4462D-02, -.5205D-02, -.6176D-02, -.7039D-02,   &
     &    -.7897D-02, -.8826D-02, -.9575D-02, -.9992D-02, -.1002D-01,   &
     &    -.9512D-02, -.8062D-02, -.5594D-02, -.2193D-02, 0.1706D-02,   &
     &    0.5020D-02, 0.6064D-02, 0.3033D-02, -.4576D-02, -.1507D-01,   &
     &    -.2416D-01, -.2776D-01, -.2419D-01, -.1519D-01, -.4142D-02,   &
     &    0.5976D-02, 0.1351D-01, 0.1805D-01, 0.2003D-01, 0.2009D-01,   &
     &    0.1892D-01, 0.1705D-01, 0.1489D-01, 0.1269D-01, 0.1061D-01,   &
     &    0.8730D-02, 0.7091D-02, 0.5696D-02, 0.4531D-02, 0.3575D-02,   &
     &    0.2799D-02, 0.2178D-02, 0.1683D-02, 0.1295D-02, 0.9910D-03,   &
     &    0.7550D-03, 0.5727D-03, 0.4329D-03, 0.3260D-03, 0.2446D-03,   &
     &    0.1830D-03, 0.1365D-03, 0.1016D-03, 0.7536D-04, 0.5579D-04,   &
     &    0.4120D-04/                                                   
                                                                        
      data (calcpts(j,19), j = 1,neta) /-.2090D-03, -.2088D-03,         &
     &    -.2086D-03, -.2083D-03, -.3578D-03, -.3571D-03, -.5061D-03,   &
     &    -.6547D-03, -.6525D-03, -.7993D-03, -.1095D-02, -.1238D-02,   &
     &    -.1528D-02, -.1813D-02, -.2092D-02, -.2510D-02, -.3064D-02,   &
     &    -.3595D-02, -.4245D-02, -.4999D-02, -.5684D-02, -.6569D-02,   &
     &    -.7458D-02, -.8283D-02, -.9099D-02, -.9764D-02, -.9935D-02,   &
     &    -.9630D-02, -.8473D-02, -.6571D-02, -.3899D-02, -.6442D-03,   &
     &    0.2218D-02, 0.3113D-02, 0.6896D-03, -.5955D-02, -.1509D-01,   &
     &    -.2328D-01, -.2662D-01, -.2333D-01, -.1482D-01, -.4195D-02,   &
     &    0.5655D-02, 0.1305D-01, 0.1759D-01, 0.1960D-01, 0.1974D-01,   &
     &    0.1863D-01, 0.1682D-01, 0.1472D-01, 0.1256D-01, 0.1051D-01,   &
     &    0.8655D-02, 0.7035D-02, 0.5655D-02, 0.4501D-02, 0.3553D-02,   &
     &    0.2784D-02, 0.2166D-02, 0.1676D-02, 0.1289D-02, 0.9868D-03,   &
     &    0.7519D-03, 0.5706D-03, 0.4312D-03, 0.3248D-03, 0.2438D-03,   &
     &    0.1824D-03, 0.1361D-03, 0.1013D-03, 0.7515D-04, 0.5564D-04,   &
     &    0.4110D-04/                                                   
                                                                        
      data (calcpts(j,20), j = 1,neta) /-.1704D-03, -.1703D-03,         &
     &    -.1701D-03, -.1698D-03, -.3194D-03, -.3188D-03, -.4679D-03,   &
     &    -.4665D-03, -.6145D-03, -.7616D-03, -.9074D-03, -.1051D-02,   &
     &    -.1342D-02, -.1629D-02, -.1909D-02, -.2330D-02, -.2737D-02,   &
     &    -.3275D-02, -.3784D-02, -.4550D-02, -.5253D-02, -.6015D-02,   &
     &    -.6793D-02, -.7677D-02, -.8426D-02, -.9065D-02, -.9413D-02,   &
     &    -.9366D-02, -.8727D-02, -.7347D-02, -.5105D-02, -.2548D-02,   &
     &    -.2590D-03, 0.4423D-03, -.1496D-02, -.6912D-02, -.1477D-01,   &
     &    -.2202D-01, -.2513D-01, -.2227D-01, -.1444D-01, -.4398D-02,   &
     &    0.5099D-02, 0.1237D-01, 0.1690D-01, 0.1899D-01, 0.1922D-01,   &
     &    0.1822D-01, 0.1651D-01, 0.1447D-01, 0.1237D-01, 0.1037D-01,   &
     &    0.8549D-02, 0.6956D-02, 0.5596D-02, 0.4459D-02, 0.3522D-02,   &
     &    0.2761D-02, 0.2149D-02, 0.1663D-02, 0.1280D-02, 0.9806D-03,   &
     &    0.7475D-03, 0.5674D-03, 0.4290D-03, 0.3232D-03, 0.2427D-03,   &
     &    0.1816D-03, 0.1355D-03, 0.1009D-03, 0.7488D-04, 0.5544D-04,   &
     &    0.4096D-04/                                                   
                                                                        
      data (calcpts(j,21), j = 1,neta) /-.9777D-04, -.9765D-04,         &
     &    -.2475D-03, -.2472D-03, -.2468D-03, -.3963D-03, -.3955D-03,   &
     &    -.5443D-03, -.5425D-03, -.6900D-03, -.8362D-03, -.9806D-03,   &
     &    -.1272D-02, -.1411D-02, -.1693D-02, -.2117D-02, -.2380D-02,   &
     &    -.2924D-02, -.3443D-02, -.3924D-02, -.4649D-02, -.5293D-02,   &
     &    -.6119D-02, -.6921D-02, -.7621D-02, -.8255D-02, -.8666D-02,   &
     &    -.8774D-02, -.8275D-02, -.7367D-02, -.5844D-02, -.3874D-02,   &
     &    -.1962D-02, -.1328D-02, -.2876D-02, -.7216D-02, -.1382D-01,   &
     &    -.2019D-01, -.2324D-01, -.2102D-01, -.1410D-01, -.4830D-02,   &
     &    0.4201D-02, 0.1132D-01, 0.1589D-01, 0.1810D-01, 0.1848D-01,   &
     &    0.1764D-01, 0.1604D-01, 0.1411D-01, 0.1210D-01, 0.1017D-01,   &
     &    0.8402D-02, 0.6848D-02, 0.5517D-02, 0.4401D-02, 0.3480D-02,   &
     &    0.2730D-02, 0.2128D-02, 0.1649D-02, 0.1269D-02, 0.9725D-03,   &
     &    0.7418D-03, 0.5633D-03, 0.4261D-03, 0.3212D-03, 0.2412D-03,   &
     &    0.1805D-03, 0.1348D-03, 0.1003D-03, 0.7450D-04, 0.5519D-04,   &
     &    0.4077D-04/                                                   
                                                                        
      data (calcpts(j,22), j = 1,neta) /-.1735D-03, -.1734D-03,         &
     &    -.1732D-03, -.1730D-03, -.1727D-03, -.3222D-03, -.3215D-03,   &
     &    -.4705D-03, -.4690D-03, -.6168D-03, -.7635D-03, -.9088D-03,   &
     &    -.1052D-02, -.1192D-02, -.1476D-02, -.1754D-02, -.2022D-02,   &
     &    -.2424D-02, -.2805D-02, -.3302D-02, -.3902D-02, -.4582D-02,   &
     &    -.5160D-02, -.5890D-02, -.6402D-02, -.7051D-02, -.7399D-02,   &
     &    -.7551D-02, -.7244D-02, -.6584D-02, -.5435D-02, -.3748D-02,   &
     &    -.2404D-02, -.1634D-02, -.2806D-02, -.6324D-02, -.1186D-01,   &
     &    -.1759D-01, -.2080D-01, -.1952D-01, -.1382D-01, -.5557D-02,   &
     &    0.2891D-02, 0.9818D-02, 0.1445D-01, 0.1684D-01, 0.1745D-01,   &
     &    0.1682D-01, 0.1542D-01, 0.1364D-01, 0.1175D-01, 0.9902D-02,   &
     &    0.8205D-02, 0.6703D-02, 0.5412D-02, 0.4324D-02, 0.3423D-02,   &
     &    0.2689D-02, 0.2099D-02, 0.1627D-02, 0.1254D-02, 0.9617D-03,   &
     &    0.7340D-03, 0.5578D-03, 0.4222D-03, 0.3184D-03, 0.2392D-03,   &
     &    0.1791D-03, 0.1338D-03, 0.9964D-04, 0.7402D-04, 0.5483D-04,   &
     &    0.4054D-04/                                                   
                                                                        
      data (calcpts(j,23), j = 1,neta) /-.1129D-03, -.1128D-03,         &
     &    -.1127D-03, -.1125D-03, -.1122D-03, -.2618D-03, -.2612D-03,   &
     &    -.2604D-03, -.4091D-03, -.4073D-03, -.5546D-03, -.7007D-03,   &
     &    -.8449D-03, -.9864D-03, -.1124D-02, -.1406D-02, -.1679D-02,   &
     &    -.1939D-02, -.2331D-02, -.2697D-02, -.3172D-02, -.3590D-02,   &
     &    -.4073D-02, -.4583D-02, -.5063D-02, -.5583D-02, -.5880D-02,   &
     &    -.5942D-02, -.5700D-02, -.5019D-02, -.3989D-02, -.2646D-02,   &
     &    -.1380D-02, -.6668D-03, -.1348D-02, -.4099D-02, -.8787D-02,   &
     &    -.1408D-01, -.1771D-01, -.1766D-01, -.1350D-01, -.6539D-02,   &
     &    0.1131D-02, 0.7788D-02, 0.1250D-01, 0.1516D-01, 0.1607D-01,   &
     &    0.1573D-01, 0.1458D-01, 0.1301D-01, 0.1127D-01, 0.9550D-02,   &
     &    0.7946D-02, 0.6514D-02, 0.5274D-02, 0.4223D-02, 0.3352D-02,   &
     &    0.2638D-02, 0.2061D-02, 0.1599D-02, 0.1235D-02, 0.9479D-03,   &
     &    0.7242D-03, 0.5508D-03, 0.4171D-03, 0.3147D-03, 0.2367D-03,   &
     &    0.1774D-03, 0.1326D-03, 0.9877D-04, 0.7339D-04, 0.5439D-04,   &
     &    0.4023D-04/                                                   
                                                                        
      data (calcpts(j,24), j = 1,neta) /-.6910D-04, -.6903D-04,         &
     &    -.9893D-04, -.1138D-03, -.1286D-03, -.1583D-03, -.2028D-03,   &
     &    -.2471D-03, -.2911D-03, -.3496D-03, -.4225D-03, -.5093D-03,   &
     &    -.6097D-03, -.7229D-03, -.8780D-03, -.1043D-02, -.1247D-02,   &
     &    -.1470D-02, -.1739D-02, -.2031D-02, -.2367D-02, -.2716D-02,   &
     &    -.3103D-02, -.3481D-02, -.3821D-02, -.4103D-02, -.4266D-02,   &
     &    -.4227D-02, -.3915D-02, -.3268D-02, -.2253D-02, -.9436D-03,   &
     &    0.4012D-03, 0.1290D-02, 0.1046D-02, -.9929D-03, -.4925D-02,   &
     &    -.9856D-02, -.1397D-01, -.1528D-01, -.1294D-01, -.7601D-02,   &
     &    -.9618D-03, 0.5278D-02, 0.1004D-01, 0.1299D-01, 0.1429D-01,   &
     &    0.1432D-01, 0.1350D-01, 0.1220D-01, 0.1067D-01, 0.9105D-02,   &
     &    0.7620D-02, 0.6276D-02, 0.5100D-02, 0.4098D-02, 0.3261D-02,   &
     &    0.2573D-02, 0.2015D-02, 0.1566D-02, 0.1211D-02, 0.9308D-03,   &
     &    0.7119D-03, 0.5422D-03, 0.4110D-03, 0.3105D-03, 0.2336D-03,   &
     &    0.1753D-03, 0.1310D-03, 0.9769D-04, 0.7262D-04, 0.5386D-04,   &
     &    0.3984D-04/                                                   
                                                                        
      data (calcpts(j,25), j = 1,neta) /-.4463D-04, -.5957D-04,         &
     &    -.7450D-04, -.8938D-04, -.1042D-03, -.1190D-03, -.1486D-03,   &
     &    -.1781D-03, -.2073D-03, -.2512D-03, -.3095D-03, -.3671D-03,   &
     &    -.4385D-03, -.5383D-03, -.6356D-03, -.7593D-03, -.8927D-03,   &
     &    -.1063D-02, -.1253D-02, -.1455D-02, -.1694D-02, -.1941D-02,   &
     &    -.2196D-02, -.2435D-02, -.2639D-02, -.2786D-02, -.2809D-02,   &
     &    -.2651D-02, -.2252D-02, -.1543D-02, -.5098D-03, 0.8178D-03,   &
     &    0.2215D-02, 0.3330D-02, 0.3531D-02, 0.2191D-02, -.9599D-03,   &
     &    -.5427D-02, -.9834D-02, -.1238D-01, -.1187D-01, -.8389D-02,   &
     &    -.3088D-02, 0.2501D-02, 0.7192D-02, 0.1042D-01, 0.1214D-01,   &
     &    0.1261D-01, 0.1219D-01, 0.1120D-01, 0.9929D-02, 0.8561D-02,   &
     &    0.7221D-02, 0.5986D-02, 0.4890D-02, 0.3947D-02, 0.3152D-02,   &
     &    0.2494D-02, 0.1957D-02, 0.1526D-02, 0.1182D-02, 0.9102D-03,   &
     &    0.6974D-03, 0.5317D-03, 0.4036D-03, 0.3053D-03, 0.2299D-03,   &
     &    0.1726D-03, 0.1292D-03, 0.9638D-04, 0.7171D-04, 0.5322D-04,   &
     &    0.3940D-04/                                                   
                                                                        
      data (calcpts(j,26), j = 1,neta) /-.2966D-04, -.2962D-04,         &
     &    -.4456D-04, -.4447D-04, -.5935D-04, -.7417D-04, -.8890D-04,   &
     &    -.1185D-03, -.1329D-03, -.1621D-03, -.2058D-03, -.2490D-03,   &
     &    -.3063D-03, -.3624D-03, -.4316D-03, -.5132D-03, -.6057D-03,   &
     &    -.7225D-03, -.8457D-03, -.9865D-03, -.1139D-02, -.1295D-02,   &
     &    -.1441D-02, -.1591D-02, -.1687D-02, -.1708D-02, -.1632D-02,   &
     &    -.1397D-02, -.9495D-03, -.2161D-03, 0.8048D-03, 0.2109D-02,   &
     &    0.3533D-02, 0.4767D-02, 0.5314D-02, 0.4615D-02, 0.2265D-02,   &
     &    -.1537D-02, -.5856D-02, -.9181D-02, -.1023D-01, -.8583D-02,   &
     &    -.4844D-02, -.1984D-03, 0.4188D-02, 0.7570D-02, 0.9685D-02,   &
     &    0.1062D-01, 0.1064D-01, 0.1003D-01, 0.9054D-02, 0.7917D-02,   &
     &    0.6752D-02, 0.5644D-02, 0.4644D-02, 0.3768D-02, 0.3024D-02,   &
     &    0.2402D-02, 0.1891D-02, 0.1479D-02, 0.1148D-02, 0.8863D-03,   &
     &    0.6802D-03, 0.5196D-03, 0.3951D-03, 0.2992D-03, 0.2257D-03,   &
     &    0.1695D-03, 0.1270D-03, 0.9488D-04, 0.7065D-04, 0.5247D-04,   &
     &    0.3887D-04/                                                   
                                                                        
      data (calcpts(j,27), j = 1,neta) /-.3332D-04, -.3329D-04,         &
     &    -.4825D-04, -.4819D-04, -.6309D-04, -.6296D-04, -.7777D-04,   &
     &    -.9248D-04, -.1071D-03, -.1364D-03, -.1505D-03, -.1792D-03,   &
     &    -.2222D-03, -.2494D-03, -.3051D-03, -.3589D-03, -.4248D-03,   &
     &    -.4865D-03, -.5719D-03, -.6482D-03, -.7412D-03, -.8295D-03,   &
     &    -.9192D-03, -.9822D-03, -.9994D-03, -.9586D-03, -.8365D-03,   &
     &    -.5633D-03, -.9504D-04, 0.5896D-03, 0.1553D-02, 0.2755D-02,   &
     &    0.4087D-02, 0.5337D-02, 0.6085D-02, 0.5854D-02, 0.4228D-02,   &
     &    0.1195D-02, -.2655D-02, -.6188D-02, -.8228D-02, -.8095D-02,   &
     &    -.5908D-02, -.2429D-02, 0.1368D-02, 0.4683D-02, 0.7072D-02,   &
     &    0.8434D-02, 0.8900D-02, 0.8695D-02, 0.8056D-02, 0.7179D-02,   &
     &    0.6213D-02, 0.5253D-02, 0.4361D-02, 0.3564D-02, 0.2877D-02,   &
     &    0.2297D-02, 0.1817D-02, 0.1425D-02, 0.1110D-02, 0.8591D-03,   &
     &    0.6609D-03, 0.5058D-03, 0.3854D-03, 0.2922D-03, 0.2208D-03,   &
     &    0.1661D-03, 0.1246D-03, 0.9317D-04, 0.6945D-04, 0.5163D-04,   &
     &    0.3828D-04/                                                   
                                                                        
      data (calcpts(j,28), j = 1,neta) /-.1367D-04, -.1365D-04,         &
     &    -.2862D-04, -.2858D-04, -.2851D-04, -.4342D-04, -.4328D-04,   &
     &    -.5807D-04, -.7277D-04, -.7232D-04, -.1017D-03, -.1157D-03,   &
     &    -.1293D-03, -.1572D-03, -.1842D-03, -.2248D-03, -.2633D-03,   &
     &    -.2987D-03, -.3447D-03, -.3991D-03, -.4439D-03, -.4897D-03,   &
     &    -.5300D-03, -.5403D-03, -.5221D-03, -.4407D-03, -.2989D-03,   &
     &    -.2706D-04, 0.3975D-03, 0.1014D-02, 0.1850D-02, 0.2886D-02,   &
     &    0.4067D-02, 0.5210D-02, 0.6002D-02, 0.6036D-02, 0.4981D-02,   &
     &    0.2682D-02, -.5298D-03, -.3840D-02, -.6280D-02, -.7128D-02,   &
     &    -.6212D-02, -.3917D-02, -.9303D-03, 0.2049D-02, 0.4500D-02,   &
     &    0.6172D-02, 0.7042D-02, 0.7241D-02, 0.6951D-02, 0.6357D-02,   &
     &    0.5610D-02, 0.4815D-02, 0.4043D-02, 0.3336D-02, 0.2713D-02,   &
     &    0.2179D-02, 0.1734D-02, 0.1365D-02, 0.1067D-02, 0.8287D-03,   &
     &    0.6394D-03, 0.4906D-03, 0.3745D-03, 0.2845D-03, 0.2153D-03,   &
     &    0.1623D-03, 0.1219D-03, 0.9126D-04, 0.6811D-04, 0.5068D-04,   &
     &    0.3761D-04/                                                   
                                                                        
      data (calcpts(j,29), j = 1,neta) /0.8002D-06, -.1419D-04,         &
     &    -.1416D-04, -.1413D-04, -.1409D-04, -.1402D-04, -.2892D-04,   &
     &    -.2877D-04, -.2856D-04, -.4325D-04, -.5778D-04, -.5711D-04,   &
     &    -.7112D-04, -.8466D-04, -.1125D-03, -.1244D-03, -.1498D-03,   &
     &    -.1730D-03, -.1931D-03, -.2236D-03, -.2473D-03, -.2610D-03,   &
     &    -.2753D-03, -.2534D-03, -.2158D-03, -.1335D-03, 0.2768D-04,   &
     &    0.2657D-03, 0.6328D-03, 0.1148D-02, 0.1843D-02, 0.2699D-02,   &
     &    0.3677D-02, 0.4635D-02, 0.5363D-02, 0.5530D-02, 0.4838D-02,   &
     &    0.3127D-02, 0.5668D-03, -.2303D-02, -.4731D-02, -.6054D-02,   &
     &    -.5981D-02, -.4655D-02, -.2514D-02, -.7367D-04, 0.2202D-02,   &
     &    0.3995D-02, 0.5164D-02, 0.5717D-02, 0.5769D-02, 0.5467D-02,   &
     &    0.4952D-02, 0.4334D-02, 0.3695D-02, 0.3085D-02, 0.2533D-02,   &
     &    0.2051D-02, 0.1640D-02, 0.1300D-02, 0.1021D-02, 0.7954D-03,   &
     &    0.6157D-03, 0.4738D-03, 0.3626D-03, 0.2761D-03, 0.2094D-03,   &
     &    0.1580D-03, 0.1189D-03, 0.8917D-04, 0.6664D-04, 0.4965D-04,   &
     &    0.3688D-04/                                                   
                                                                        
      data (calcpts(j,30), j = 1,neta) /0.2726D-05, -.1226D-04,         &
     &    -.1225D-04, -.1223D-04, -.1219D-04, -.1215D-04, -.1208D-04,   &
     &    -.1198D-04, -.2683D-04, -.2661D-04, -.2628D-04, -.4081D-04,   &
     &    -.4012D-04, -.5410D-04, -.6761D-04, -.6541D-04, -.7719D-04,   &
     &    -.1025D-03, -.1105D-03, -.1154D-03, -.1305D-03, -.1237D-03,   &
     &    -.1217D-03, -.8993D-04, -.5168D-04, 0.3277D-04, 0.1769D-03,   &
     &    0.3852D-03, 0.6838D-03, 0.1107D-02, 0.1652D-02, 0.2325D-02,   &
     &    0.3112D-02, 0.3884D-02, 0.4477D-02, 0.4672D-02, 0.4216D-02,   &
     &    0.2951D-02, 0.9433D-03, -.1449D-02, -.3665D-02, -.5139D-02,   &
     &    -.5535D-02, -.4866D-02, -.3416D-02, -.1555D-02, 0.3704D-03,   &
     &    0.2080D-02, 0.3384D-02, 0.4200D-02, 0.4549D-02, 0.4527D-02,   &
     &    0.4248D-02, 0.3816D-02, 0.3319D-02, 0.2814D-02, 0.2337D-02,   &
     &    0.1910D-02, 0.1540D-02, 0.1228D-02, 0.9698D-03, 0.7593D-03,   &
     &    0.5900D-03, 0.4556D-03, 0.3496D-03, 0.2670D-03, 0.2029D-03,   &
     &    0.1536D-03, 0.1157D-03, 0.8690D-04, 0.6504D-04, 0.4852D-04,   &
     &    0.3610D-04/                                                   
                                                                        
      data (calcpts(j,31), j = 1,neta) /0.1204D-05, 0.1211D-05,         &
     &    0.1222D-05, 0.1237D-05, 0.1259D-05, -.1371D-04, -.1366D-04,   &
     &    -.1359D-04, -.1349D-04, -.1333D-04, -.1311D-04, -.1278D-04,   &
     &    -.2730D-04, -.2659D-04, -.2556D-04, -.3904D-04, -.3680D-04,   &
     &    -.4853D-04, -.4372D-04, -.5167D-04, -.5635D-04, -.4120D-04,   &
     &    -.3402D-04, -.1605D-05, 0.4573D-04, 0.1297D-03, 0.2447D-03,   &
     &    0.4041D-03, 0.6562D-03, 0.9796D-03, 0.1404D-02, 0.1920D-02,   &
     &    0.2519D-02, 0.3115D-02, 0.3590D-02, 0.3764D-02, 0.3443D-02,   &
     &    0.2495D-02, 0.9307D-03, -.1023D-02, -.2965D-02, -.4429D-02,   &
     &    -.5075D-02, -.4820D-02, -.3847D-02, -.2457D-02, -.9175D-03,   &
     &    0.5657D-03, 0.1835D-02, 0.2778D-02, 0.3347D-02, 0.3567D-02,   &
     &    0.3512D-02, 0.3267D-02, 0.2916D-02, 0.2522D-02, 0.2127D-02,   &
     &    0.1761D-02, 0.1433D-02, 0.1152D-02, 0.9153D-03, 0.7205D-03,   &
     &    0.5625D-03, 0.4360D-03, 0.3358D-03, 0.2572D-03, 0.1960D-03,   &
     &    0.1486D-03, 0.1123D-03, 0.8446D-04, 0.6331D-04, 0.4732D-04,   &
     &    0.3525D-04/                                                   
                                                                        
      data (calcpts(j,32), j = 1,neta) /-.4108D-06, -.4060D-06,         &
     &    -.3988D-06, -.3883D-06, -.1873D-05, -.1850D-05, -.3317D-05,   &
     &    -.3268D-05, -.4697D-05, -.6092D-05, -.7438D-05, -.8712D-05,   &
     &    -.9880D-05, -.1089D-04, -.1318D-04, -.1513D-04, -.1659D-04,   &
     &    -.1733D-04, -.1702D-04, -.1515D-04, -.9533D-05, 0.9116D-06,   &
     &    0.1771D-04, 0.4607D-04, 0.8921D-04, 0.1533D-03, 0.2492D-03,   &
     &    0.3834D-03, 0.5712D-03, 0.8215D-03, 0.1145D-02, 0.1540D-02,   &
     &    0.1985D-02, 0.2433D-02, 0.2792D-02, 0.2929D-02, 0.2695D-02,   &
     &    0.1979D-02, 0.7654D-03, -.8107D-03, -.2468D-02, -.3849D-02,   &
     &    -.4632D-02, -.4666D-02, -.4031D-02, -.2965D-02, -.1732D-02,   &
     &    -.5033D-03, 0.6184D-03, 0.1553D-02, 0.2232D-02, 0.2630D-02,   &
     &    0.2766D-02, 0.2698D-02, 0.2493D-02, 0.2213D-02, 0.1905D-02,   &
     &    0.1600D-02, 0.1319D-02, 0.1070D-02, 0.8571D-03, 0.6791D-03,   &
     &    0.5331D-03, 0.4152D-03, 0.3211D-03, 0.2467D-03, 0.1886D-03,   &
     &    0.1434D-03, 0.1086D-03, 0.8187D-04, 0.6149D-04, 0.4602D-04,   &
     &    0.3434D-04/                                                   
                                                                        
      data (calcpts(j,33), j = 1,neta) /-.1502D-05, -.1499D-05,         &
     &    -.1494D-05, -.2987D-05, -.2976D-05, -.2960D-05, -.2938D-05,   &
     &    -.2904D-05, -.2855D-05, -.4283D-05, -.4177D-05, -.4021D-05,   &
     &    -.5293D-05, -.4958D-05, -.5967D-05, -.5246D-05, -.5687D-05,   &
     &    -.4135D-05, -.1857D-05, 0.2986D-05, 0.9379D-05, 0.1956D-04,   &
     &    0.3607D-04, 0.6194D-04, 0.9788D-04, 0.1516D-03, 0.2260D-03,   &
     &    0.3319D-03, 0.4751D-03, 0.6637D-03, 0.9059D-03, 0.1200D-02,   &
     &    0.1530D-02, 0.1861D-02, 0.2124D-02, 0.2225D-02, 0.2050D-02,   &
     &    0.1508D-02, 0.5710D-03, -.6807D-03, -.2063D-02, -.3315D-02,   &
     &    -.4162D-02, -.4421D-02, -.4069D-02, -.3260D-02, -.2236D-02,   &
     &    -.1198D-02, -.2422D-03, 0.5943D-03, 0.1277D-02, 0.1765D-02,   &
     &    0.2043D-02, 0.2126D-02, 0.2058D-02, 0.1891D-02, 0.1669D-02,   &
     &    0.1431D-02, 0.1198D-02, 0.9835D-03, 0.7955D-03, 0.6352D-03,   &
     &    0.5020D-03, 0.3931D-03, 0.3054D-03, 0.2357D-03, 0.1807D-03,   &
     &    0.1379D-03, 0.1047D-03, 0.7910D-04, 0.5955D-04, 0.4466D-04,   &
     &    0.3338D-04/                                                   
                                                                        
      data (calcpts(j,34), j = 1,neta) /-.6676D-06, -.6653D-06,         &
     &    -.6619D-06, -.6570D-06, -.6497D-06, -.6391D-06, -.6234D-06,   &
     &    -.6005D-06, -.5668D-06, -.5174D-06, -.4448D-06, -.3383D-06,   &
     &    -.1820D-06, 0.4757D-07, 0.3840D-06, 0.8782D-06, 0.3104D-05,   &
     &    0.5667D-05, 0.8728D-05, 0.1252D-04, 0.2037D-04, 0.2979D-04,   &
     &    0.4449D-04, 0.6552D-04, 0.9590D-04, 0.1378D-03, 0.1958D-03,   &
     &    0.2772D-03, 0.3849D-03, 0.5267D-03, 0.7048D-03, 0.9213D-03,   &
     &    0.1163D-02, 0.1404D-02, 0.1595D-02, 0.1666D-02, 0.1531D-02,   &
     &    0.1122D-02, 0.4051D-03, -.5752D-03, -.1702D-02, -.2792D-02,   &
     &    -.3638D-02, -.4057D-02, -.3963D-02, -.3408D-02, -.2568D-02,   &
     &    -.1655D-02, -.8125D-03, -.8359D-04, 0.5332D-03, 0.1029D-02,   &
     &    0.1379D-02, 0.1572D-02, 0.1621D-02, 0.1560D-02, 0.1425D-02,   &
     &    0.1253D-02, 0.1070D-02, 0.8921D-03, 0.7305D-03, 0.5890D-03,   &
     &    0.4691D-03, 0.3697D-03, 0.2889D-03, 0.2240D-03, 0.1725D-03,   &
     &    0.1320D-03, 0.1005D-03, 0.7618D-04, 0.5748D-04, 0.4321D-04,   &
     &    0.3237D-04/                                                   
                                                                        
      data (calcpts(j,35), j = 1,neta) /0.5347D-06, 0.5363D-06,         &
     &    0.5386D-06, 0.5419D-06, 0.5469D-06, 0.5542D-06, 0.5649D-06,   &
     &    0.5806D-06, 0.6036D-06, 0.6374D-06, 0.2187D-05, 0.2260D-05,   &
     &    0.2367D-05, 0.2524D-05, 0.4254D-05, 0.4592D-05, 0.6588D-05,   &
     &    0.8816D-05, 0.1288D-04, 0.1745D-04, 0.2274D-04, 0.3211D-04,   &
     &    0.4453D-04, 0.6073D-04, 0.8475D-04, 0.1181D-03, 0.1628D-03,   &
     &    0.2234D-03, 0.3054D-03, 0.4095D-03, 0.5410D-03, 0.6985D-03,   &
     &    0.8741D-03, 0.1048D-02, 0.1186D-02, 0.1233D-02, 0.1131D-02,   &
     &    0.8216D-03, 0.2791D-03, -.4777D-03, -.1375D-02, -.2291D-02,   &
     &    -.3077D-02, -.3580D-02, -.3695D-02, -.3395D-02, -.2766D-02,   &
     &    -.1979D-02, -.1205D-02, -.5397D-03, 0.7416D-05, 0.4582D-03,   &
     &    0.8161D-03, 0.1067D-02, 0.1201D-02, 0.1229D-02, 0.1175D-02,   &
     &    0.1069D-02, 0.9362D-03, 0.7963D-03, 0.6621D-03, 0.5404D-03,   &
     &    0.4347D-03, 0.3453D-03, 0.2716D-03, 0.2118D-03, 0.1638D-03,   &
     &    0.1259D-03, 0.9621D-04, 0.7313D-04, 0.5534D-04, 0.4170D-04,   &
     &    0.3129D-04/                                                   
                                                                        
      data (calcpts(j,36), j = 1,neta) /-.1272D-06, -.1261D-06,         &
     &    -.1245D-06, -.1222D-06, -.1188D-06, -.1139D-06, 0.1393D-05,   &
     &    0.1404D-05, 0.1420D-05, 0.1443D-05, 0.1477D-05, 0.1527D-05,   &
     &    0.3100D-05, 0.3207D-05, 0.4864D-05, 0.5095D-05, 0.6934D-05,   &
     &    0.8931D-05, 0.1266D-04, 0.1673D-04, 0.2130D-04, 0.2960D-04,   &
     &    0.3896D-04, 0.5288D-04, 0.7206D-04, 0.9603D-04, 0.1307D-03,   &
     &    0.1766D-03, 0.2366D-03, 0.3126D-03, 0.4092D-03, 0.5243D-03,   &
     &    0.6506D-03, 0.7755D-03, 0.8721D-03, 0.9047D-03, 0.8264D-03,   &
     &    0.5968D-03, 0.1887D-03, -.3877D-03, -.1088D-02, -.1834D-02,   &
     &    -.2521D-02, -.3038D-02, -.3286D-02, -.3207D-02, -.2811D-02,   &
     &    -.2193D-02, -.1499D-02, -.8651D-03, -.3506D-03, 0.5516D-04,   &
     &    0.3822D-03, 0.6395D-03, 0.8182D-03, 0.9113D-03, 0.9262D-03,   &
     &    0.8813D-03, 0.7983D-03, 0.6966D-03, 0.5905D-03, 0.4894D-03,   &
     &    0.3984D-03, 0.3197D-03, 0.2535D-03, 0.1989D-03, 0.1548D-03,   &
     &    0.1195D-03, 0.9167D-04, 0.6994D-04, 0.5308D-04, 0.4011D-04,   &
     &    0.3018D-04/                                                   
                                                                        
      data (calcpts(j,37), j = 1,neta) /-.3661D-07, -.3588D-07,         &
     &    -.3480D-07, -.3323D-07, -.3091D-07, -.2751D-07, 0.1477D-05,   &
     &    0.1485D-05, 0.1496D-05, 0.1511D-05, 0.1534D-05, 0.1568D-05,   &
     &    0.3118D-05, 0.3191D-05, 0.4799D-05, 0.4956D-05, 0.6688D-05,   &
     &    0.8527D-05, 0.1202D-04, 0.1426D-04, 0.1982D-04, 0.2589D-04,   &
     &    0.3269D-04, 0.4355D-04, 0.5745D-04, 0.7660D-04, 0.1035D-03,   &
     &    0.1364D-03, 0.1804D-03, 0.2378D-03, 0.3072D-03, 0.3892D-03,   &
     &    0.4797D-03, 0.5693D-03, 0.6385D-03, 0.6609D-03, 0.6013D-03,   &
     &    0.4300D-03, 0.1266D-03, -.3072D-03, -.8445D-03, -.1435D-02,   &
     &    -.2010D-02, -.2491D-02, -.2801D-02, -.2875D-02, -.2689D-02,   &
     &    -.2270D-02, -.1706D-02, -.1120D-02, -.6135D-03, -.2218D-03,   &
     &    0.7605D-04, 0.3118D-03, 0.4963D-03, 0.6232D-03, 0.6876D-03,   &
     &    0.6946D-03, 0.6579D-03, 0.5936D-03, 0.5163D-03, 0.4364D-03,   &
     &    0.3607D-03, 0.2929D-03, 0.2344D-03, 0.1855D-03, 0.1452D-03,   &
     &    0.1128D-03, 0.8695D-04, 0.6660D-04, 0.5073D-04, 0.3844D-04,   &
     &    0.2901D-04/                                                   
                                                                        
      data (calcpts(j,38), j = 1,neta) /0.4340D-06, 0.4345D-06,         &
     &    0.4352D-06, 0.5863D-06, 0.5879D-06, 0.7402D-06, 0.8936D-06,   &
     &    0.1049D-05, 0.1206D-05, 0.1517D-05, 0.1832D-05, 0.2156D-05,   &
     &    0.2640D-05, 0.3290D-05, 0.4113D-05, 0.5120D-05, 0.6328D-05,   &
     &    0.7909D-05, 0.1005D-04, 0.1265D-04, 0.1623D-04, 0.2090D-04,   &
     &    0.2711D-04, 0.3525D-04, 0.4610D-04, 0.6057D-04, 0.7963D-04,   &
     &    0.1045D-03, 0.1369D-03, 0.1778D-03, 0.2282D-03, 0.2876D-03,   &
     &    0.3529D-03, 0.4165D-03, 0.4653D-03, 0.4797D-03, 0.4353D-03,   &
     &    0.3089D-03, 0.8466D-04, -.2385D-03, -.6450D-03, -.1103D-02,   &
     &    -.1567D-02, -.1985D-02, -.2300D-02, -.2460D-02, -.2429D-02,   &
     &    -.2195D-02, -.1796D-02, -.1306D-02, -.8268D-03, -.4301D-03,   &
     &    -.1358D-03, 0.8103D-04, 0.2500D-03, 0.3818D-03, 0.4719D-03,   &
     &    0.5163D-03, 0.5186D-03, 0.4891D-03, 0.4398D-03, 0.3814D-03,   &
     &    0.3214D-03, 0.2650D-03, 0.2148D-03, 0.1714D-03, 0.1354D-03,   &
     &    0.1058D-03, 0.8203D-04, 0.6313D-04, 0.4828D-04, 0.3672D-04,   &
     &    0.2779D-04/                                                   
                                                                        
      data (calcpts(j,39), j = 1,neta) /0.5623D-07, 0.5657D-07,         &
     &    0.2071D-06, 0.2078D-06, 0.3589D-06, 0.3605D-06, 0.5128D-06,   &
     &    0.6662D-06, 0.8212D-06, 0.9785D-06, 0.1289D-05, 0.1605D-05,   &
     &    0.2078D-05, 0.2562D-05, 0.3212D-05, 0.4036D-05, 0.5043D-05,   &
     &    0.6251D-05, 0.7983D-05, 0.1012D-04, 0.1287D-04, 0.1645D-04,   &
     &    0.2127D-04, 0.2748D-04, 0.3561D-04, 0.4644D-04, 0.6040D-04,   &
     &    0.7877D-04, 0.1022D-03, 0.1320D-03, 0.1684D-03, 0.2110D-03,   &
     &    0.2576D-03, 0.3029D-03, 0.3373D-03, 0.3468D-03, 0.3138D-03,   &
     &    0.2211D-03, 0.5647D-04, -.1822D-03, -.4860D-03, -.8348D-03,   &
     &    -.1199D-02, -.1545D-02, -.1832D-02, -.2025D-02, -.2087D-02,   &
     &    -.1997D-02, -.1755D-02, -.1398D-02, -.9886D-03, -.6044D-03,   &
     &    -.2986D-03, -.7958D-04, 0.7717D-04, 0.1978D-03, 0.2916D-03,   &
     &    0.3554D-03, 0.3859D-03, 0.3857D-03, 0.3623D-03, 0.3247D-03,   &
     &    0.2808D-03, 0.2361D-03, 0.1942D-03, 0.1570D-03, 0.1251D-03,   &
     &    0.9858D-04, 0.7692D-04, 0.5953D-04, 0.4575D-04, 0.3493D-04,   &
     &    0.2653D-04/                                                   
                                                                        
      data (calcpts(j,40), j = 1,neta) /0.5510D-07, 0.2053D-06,         &
     &    0.2057D-06, 0.2062D-06, 0.3569D-06, 0.3580D-06, 0.5096D-06,   &
     &    0.6619D-06, 0.8153D-06, 0.9703D-06, 0.1128D-05, 0.1438D-05,   &
     &    0.1754D-05, 0.2227D-05, 0.2711D-05, 0.3361D-05, 0.4185D-05,   &
     &    0.5192D-05, 0.6400D-05, 0.8132D-05, 0.1027D-04, 0.1302D-04,   &
     &    0.1660D-04, 0.2126D-04, 0.2732D-04, 0.3528D-04, 0.4562D-04,   &
     &    0.5906D-04, 0.7606D-04, 0.9755D-04, 0.1236D-03, 0.1542D-03,   &
     &    0.1874D-03, 0.2196D-03, 0.2437D-03, 0.2500D-03, 0.2255D-03,   &
     &    0.1579D-03, 0.3784D-04, -.1373D-03, -.3623D-03, -.6244D-03,   &
     &    -.9049D-03, -.1181D-02, -.1427D-02, -.1616D-02, -.1722D-02,   &
     &    -.1723D-02, -.1607D-02, -.1381D-02, -.1074D-02, -.7406D-03,   &
     &    -.4383D-03, -.2052D-03, -.4368D-04, 0.6896D-04, 0.1547D-03,   &
     &    0.2212D-03, 0.2663D-03, 0.2872D-03, 0.2859D-03, 0.2676D-03,   &
     &    0.2391D-03, 0.2061D-03, 0.1729D-03, 0.1419D-03, 0.1145D-03,   &
     &    0.9106D-04, 0.7162D-04, 0.5580D-04, 0.4311D-04, 0.3307D-04,   &
     &    0.2523D-04/                                                   
                                                                        
      data (calcpts(j,41), j = 1,neta) /0.1538D-06, 0.1540D-06,         &
     &    0.1542D-06, 0.3046D-06, 0.3051D-06, 0.4558D-06, 0.4569D-06,   &
     &    0.6085D-06, 0.6108D-06, 0.7642D-06, 0.9192D-06, 0.1227D-05,   &
     &    0.1387D-05, 0.1853D-05, 0.2176D-05, 0.2660D-05, 0.3310D-05,   &
     &    0.4134D-05, 0.5141D-05, 0.6349D-05, 0.8080D-05, 0.1007D-04,   &
     &    0.1282D-04, 0.1624D-04, 0.2075D-04, 0.2664D-04, 0.3413D-04,   &
     &    0.4397D-04, 0.5625D-04, 0.7167D-04, 0.9044D-04, 0.1121D-03,   &
     &    0.1358D-03, 0.1586D-03, 0.1756D-03, 0.1796D-03, 0.1617D-03,   &
     &    0.1126D-03, 0.2545D-04, -.1023D-03, -.2677D-03, -.4625D-03,   &
     &    -.6750D-03, -.8898D-03, -.1090D-02, -.1259D-02, -.1376D-02,   &
     &    -.1426D-02, -.1393D-02, -.1273D-02, -.1072D-02, -.8171D-03,   &
     &    -.5502D-03, -.3156D-03, -.1398D-03, -.2141D-04, 0.5911D-04,   &
     &    0.1198D-03, 0.1670D-03, 0.1987D-03, 0.2130D-03, 0.2110D-03,   &
     &    0.1969D-03, 0.1755D-03, 0.1509D-03, 0.1263D-03, 0.1034D-03,   &
     &    0.8329D-04, 0.6615D-04, 0.5193D-04, 0.4039D-04, 0.3117D-04,   &
     &    0.2388D-04/                                                   
                                                                        
      data (calcpts(j,42), j = 1,neta) /0.1268D-06, 0.1269D-06,         &
     &    0.1271D-06, 0.1273D-06, 0.2777D-06, 0.2782D-06, 0.2789D-06,   &
     &    0.4300D-06, 0.5816D-06, 0.5839D-06, 0.7373D-06, 0.8923D-06,   &
     &    0.1050D-05, 0.1360D-05, 0.1676D-05, 0.1999D-05, 0.2484D-05,   &
     &    0.3133D-05, 0.3957D-05, 0.4814D-05, 0.6172D-05, 0.7603D-05,   &
     &    0.9741D-05, 0.1219D-04, 0.1561D-04, 0.1981D-04, 0.2539D-04,   &
     &    0.3239D-04, 0.4125D-04, 0.5232D-04, 0.6577D-04, 0.8122D-04,   &
     &    0.9796D-04, 0.1141D-03, 0.1261D-03, 0.1287D-03, 0.1156D-03,   &
     &    0.8019D-04, 0.1712D-04, -.7555D-04, -.1962D-03, -.3400D-03,   &
     &    -.4988D-03, -.6630D-03, -.8216D-03, -.9624D-03, -.1073D-02,   &
     &    -.1142D-02, -.1157D-02, -.1108D-02, -.9944D-03, -.8232D-03,   &
     &    -.6161D-03, -.4059D-03, -.2258D-03, -.9430D-04, -.8106D-05,   &
     &    0.4920D-04, 0.9207D-04, 0.1254D-03, 0.1477D-03, 0.1575D-03,   &
     &    0.1554D-03, 0.1445D-03, 0.1285D-03, 0.1102D-03, 0.9204D-04,   &
     &    0.7524D-04, 0.6046D-04, 0.4794D-04, 0.3757D-04, 0.2919D-04,   &
     &    0.2248D-04/                                                   
                                                                        
      data (calcpts(j,43), j = 1,neta) /0.3333D-07, 0.3340D-07,         &
     &    0.1835D-06, 0.1837D-06, 0.1839D-06, 0.1842D-06, 0.3347D-06,   &
     &    0.3355D-06, 0.3366D-06, 0.4881D-06, 0.6405D-06, 0.6439D-06,   &
     &    0.7989D-06, 0.1106D-05, 0.1267D-05, 0.1583D-05, 0.1906D-05,   &
     &    0.2390D-05, 0.3040D-05, 0.3713D-05, 0.4571D-05, 0.5778D-05,   &
     &    0.7209D-05, 0.9196D-05, 0.1164D-04, 0.1475D-04, 0.1864D-04,   &
     &    0.2375D-04, 0.3010D-04, 0.3810D-04, 0.4761D-04, 0.5868D-04,   &
     &    0.7061D-04, 0.8200D-04, 0.9031D-04, 0.9201D-04, 0.8259D-04,   &
     &    0.5698D-04, 0.1157D-04, -.5540D-04, -.1431D-03, -.2484D-03,   &
     &    -.3660D-03, -.4896D-03, -.6121D-03, -.7254D-03, -.8216D-03,   &
     &    -.8921D-03, -.9283D-03, -.9227D-03, -.8695D-03, -.7683D-03,   &
     &    -.6264D-03, -.4612D-03, -.2978D-03, -.1608D-03, -.6301D-04,   &
     &    -.5616D-06, 0.4006D-04, 0.7022D-04, 0.9372D-04, 0.1094D-03,   &
     &    0.1160D-03, 0.1141D-03, 0.1058D-03, 0.9379D-04, 0.8031D-04,   &
     &    0.6693D-04, 0.5461D-04, 0.4381D-04, 0.3468D-04, 0.2715D-04,   &
     &    0.2104D-04/                                                   
                                                                        
      data (calcpts(j,44), j = 1,neta) /0.8178D-07, 0.9683D-07,         &
     &    0.1119D-06, 0.1270D-06, 0.1572D-06, 0.1724D-06, 0.2177D-06,   &
     &    0.2632D-06, 0.3090D-06, 0.3701D-06, 0.4466D-06, 0.5540D-06,   &
     &    0.6624D-06, 0.8174D-06, 0.9897D-06, 0.1210D-05, 0.1481D-05,   &
     &    0.1835D-05, 0.2259D-05, 0.2788D-05, 0.3462D-05, 0.4319D-05,   &
     &    0.5406D-05, 0.6791D-05, 0.8566D-05, 0.1082D-04, 0.1369D-04,   &
     &    0.1736D-04, 0.2194D-04, 0.2760D-04, 0.3441D-04, 0.4223D-04,   &
     &    0.5065D-04, 0.5868D-04, 0.6457D-04, 0.6569D-04, 0.5879D-04,   &
     &    0.4045D-04, 0.7843D-05, -.4037D-04, -.1038D-03, -.1805D-03,   &
     &    -.2670D-03, -.3590D-03, -.4519D-03, -.5404D-03, -.6195D-03,   &
     &    -.6833D-03, -.7262D-03, -.7420D-03, -.7260D-03, -.6746D-03,   &
     &    -.5881D-03, -.4730D-03, -.3430D-03, -.2173D-03, -.1139D-03,   &
     &    -.4169D-04, 0.3367D-05, 0.3205D-04, 0.5322D-04, 0.6976D-04,   &
     &    0.8076D-04, 0.8520D-04, 0.8352D-04, 0.7725D-04, 0.6834D-04,   &
     &    0.5838D-04, 0.4857D-04, 0.3955D-04, 0.3168D-04, 0.2505D-04,   &
     &    0.1957D-04/                                                   
                                                                        
      data (calcpts(j,45), j = 1,neta) /0.3399D-07, 0.4903D-07,         &
     &    0.4908D-07, 0.6415D-07, 0.9426D-07, 0.1094D-06, 0.1396D-06,   &
     &    0.1700D-06, 0.2155D-06, 0.2612D-06, 0.3223D-06, 0.3839D-06,   &
     &    0.4762D-06, 0.5846D-06, 0.7246D-06, 0.8820D-06, 0.1088D-05,   &
     &    0.1344D-05, 0.1652D-05, 0.2046D-05, 0.2546D-05, 0.3174D-05,   &
     &    0.3971D-05, 0.4982D-05, 0.6261D-05, 0.7899D-05, 0.9971D-05,   &
     &    0.1259D-04, 0.1587D-04, 0.1989D-04, 0.2474D-04, 0.3029D-04,   &
     &    0.3624D-04, 0.4189D-04, 0.4602D-04, 0.4677D-04, 0.4180D-04,   &
     &    0.2866D-04, 0.5308D-05, -.2928D-04, -.7499D-04, -.1305D-03,   &
     &    -.1937D-03, -.2616D-03, -.3313D-03, -.3991D-03, -.4619D-03,   &
     &    -.5157D-03, -.5569D-03, -.5813D-03, -.5850D-03, -.5648D-03,   &
     &    -.5184D-03, -.4467D-03, -.3548D-03, -.2537D-03, -.1578D-03,   &
     &    -.8039D-04, -.2727D-04, 0.5103D-05, 0.2530D-04, 0.4012D-04,   &
     &    0.5173D-04, 0.5943D-04, 0.6243D-04, 0.6099D-04, 0.5628D-04,   &
     &    0.4968D-04, 0.4236D-04, 0.3517D-04, 0.2860D-04, 0.2287D-04,   &
     &    0.1806D-04/                                                   
                                                                        
      data (calcpts(j,46), j = 1,neta) /0.2403D-07, 0.3905D-07,         &
     &    0.5409D-07, 0.5414D-07, 0.6921D-07, 0.8432D-07, 0.1145D-06,   &
     &    0.1297D-06, 0.1601D-06, 0.1906D-06, 0.2363D-06, 0.2974D-06,   &
     &    0.3589D-06, 0.4363D-06, 0.5447D-06, 0.6547D-06, 0.8120D-06,   &
     &    0.1003D-05, 0.1229D-05, 0.1522D-05, 0.1886D-05, 0.2341D-05,   &
     &    0.2923D-05, 0.3645D-05, 0.4581D-05, 0.5753D-05, 0.7236D-05,   &
     &    0.9121D-05, 0.1145D-04, 0.1432D-04, 0.1775D-04, 0.2168D-04,   &
     &    0.2590D-04, 0.2987D-04, 0.3277D-04, 0.3325D-04, 0.2967D-04,   &
     &    0.2028D-04, 0.3616D-05, -.2114D-04, -.5397D-04, -.9405D-04,   &
     &    -.1399D-03, -.1898D-03, -.2413D-03, -.2927D-03, -.3412D-03,   &
     &    -.3847D-03, -.4206D-03, -.4463D-03, -.4591D-03, -.4560D-03,   &
     &    -.4351D-03, -.3952D-03, -.3368D-03, -.2646D-03, -.1869D-03,   &
     &    -.1142D-03, -.5652D-04, -.1763D-04, 0.5553D-05, 0.1974D-04,   &
     &    0.3009D-04, 0.3822D-04, 0.4360D-04, 0.4561D-04, 0.4443D-04,   &
     &    0.4090D-04, 0.3603D-04, 0.3067D-04, 0.2542D-04, 0.2064D-04,   &
     &    0.1816D-04/                                                   
                                                                        
      data (calcpts(j,47), j = 1,neta) /0.3417D-07, 0.3418D-07,         &
     &    0.3421D-07, 0.4924D-07, 0.6429D-07, 0.6436D-07, 0.7947D-07,   &
     &    0.1096D-06, 0.1249D-06, 0.1552D-06, 0.1857D-06, 0.2314D-06,   &
     &    0.2775D-06, 0.3391D-06, 0.4014D-06, 0.4948D-06, 0.6048D-06,   &
     &    0.7472D-06, 0.9079D-06, 0.1119D-05, 0.1382D-05, 0.1716D-05,   &
     &    0.2140D-05, 0.2663D-05, 0.3339D-05, 0.4184D-05, 0.5248D-05,   &
     &    0.6591D-05, 0.8255D-05, 0.1029D-04, 0.1273D-04, 0.1550D-04,   &
     &    0.1847D-04, 0.2126D-04, 0.2327D-04, 0.2360D-04, 0.2103D-04,   &
     &    0.1434D-04, 0.2465D-05, -.1521D-04, -.3871D-04, -.6754D-04,   &
     &    -.1007D-03, -.1370D-03, -.1751D-03, -.2133D-03, -.2503D-03,   &
     &    -.2844D-03, -.3140D-03, -.3374D-03, -.3528D-03, -.3583D-03,   &
     &    -.3521D-03, -.3326D-03, -.2990D-03, -.2525D-03, -.1964D-03,   &
     &    -.1370D-03, -.8239D-04, -.3957D-04, -.1122D-04, 0.5333D-05,   &
     &    0.1525D-04, 0.2350D-04, 0.2827D-04, 0.3192D-04, 0.3325D-04,   &
     &    0.3231D-04, 0.3967D-04, 0.2610D-04, 0.2217D-04, 0.2139D-04,   &
     &    0.1488D-04/                                                   
                                                                        
      data (calcpts(j,48), j = 1,neta) /0.1551D-07, 0.3052D-07,         &
     &    0.3053D-07, 0.3056D-07, 0.4559D-07, 0.4564D-07, 0.6072D-07,   &
     &    0.7582D-07, 0.9098D-07, 0.1062D-06, 0.1366D-06, 0.1671D-06,   &
     &    0.1978D-06, 0.2439D-06, 0.2904D-06, 0.3678D-06, 0.4462D-06,   &
     &    0.5412D-06, 0.6685D-06, 0.8143D-06, 0.1010D-05, 0.1258D-05,   &
     &    0.1547D-05, 0.1926D-05, 0.2419D-05, 0.3019D-05, 0.3787D-05,   &
     &    0.4727D-05, 0.5913D-05, 0.7366D-05, 0.9086D-05, 0.1104D-04,   &
     &    0.1313D-04, 0.1509D-04, 0.1650D-04, 0.1671D-04, 0.1489D-04,   &
     &    0.1013D-04, 0.1680D-05, -.1091D-04, -.2770D-04, -.4837D-04,   &
     &    -.7228D-04, -.9860D-04, -.1264D-03, -.1548D-03, -.1824D-03,   &
     &    -.2087D-03, -.2323D-03, -.2522D-03, -.2670D-03, -.2758D-03,   &
     &    -.2771D-03, -.2696D-03, -.2523D-03, -.2250D-03, -.1884D-03,   &
     &    -.1451D-03, -.1001D-03, -.5924D-04, -.2765D-04, -.7038D-05,   &
     &    0.4754D-05, 0.1169D-04, 0.1671D-04, 0.2068D-04, 0.2329D-04,   &
     &    0.2419D-04, 0.2344D-04, 0.2149D-04, 0.1885D-04, 0.1600D-04,   &
     &    0.1322D-04/                                                   
                                                                        
      data (calcpts(j,49), j = 1,neta) /0.1268D-07, 0.1269D-07,         &
     &    0.2770D-07, 0.2771D-07, 0.2774D-07, 0.4277D-07, 0.4282D-07,   &
     &    0.5790D-07, 0.7300D-07, 0.7316D-07, 0.1034D-06, 0.1187D-06,   &
     &    0.1492D-06, 0.1800D-06, 0.2110D-06, 0.2576D-06, 0.3200D-06,   &
     &    0.3984D-06, 0.4784D-06, 0.5907D-06, 0.7364D-06, 0.9022D-06,   &
     &    0.1120D-05, 0.1394D-05, 0.1743D-05, 0.2175D-05, 0.2714D-05,   &
     &    0.3389D-05, 0.4234D-05, 0.5260D-05, 0.6466D-05, 0.7858D-05,   &
     &    0.9321D-05, 0.1070D-04, 0.1170D-04, 0.1182D-04, 0.1052D-04,   &
     &    0.7142D-05, 0.1146D-05, -.7803D-05, -.1976D-04, -.3455D-04,   &
     &    -.5172D-04, -.7074D-04, -.9095D-04, -.1117D-03, -.1324D-03,   &
     &    -.1522D-03, -.1706D-03, -.1866D-03, -.1996D-03, -.2088D-03,   &
     &    -.2135D-03, -.2124D-03, -.2049D-03, -.1902D-03, -.1683D-03,   &
     &    -.1398D-03, -.1068D-03, -.7290D-04, -.4251D-04, -.1928D-04,   &
     &    -.4354D-05, 0.4011D-05, 0.8844D-05, 0.1234D-04, 0.1510D-04,   &
     &    0.1693D-04, 0.1753D-04, 0.1695D-04, 0.1551D-04, 0.1360D-04,   &
     &    0.1152D-04/                                                   
                                                                        
      data (dlaeta(j), j = 1,neta) /                                    &
     & -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,       &
     & -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0,       &
     & -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0,               &
     & -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0,       &
     & -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,             &
     & -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,       &
     & -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,&
     & -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,         &
     &  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,           &
     &  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,  &
     &  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,           &
     &  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,           &
     &  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,    &
     &  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0,           &
     &  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/           
                                                                        
      data (dlaxi(j), j = 1,nxi) /                                      &
     & -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,       &
     & -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,       &
     & -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,&
     & -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,         &
     &  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,           &
     &  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,  &
     &  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,           &
     &  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,           &
     &  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,    &
     &  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/                         
                                                                        
      dleta = dlog10(eta) 
      dlxi = dlog10(xi) 
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1) 
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi) 
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta) 
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1) 
      call locate(dlaeta,neta, dleta, ieta) 
      call locate(dlaxi, nxi, dlxi, ixi) 
!     interpolating between the appropriate points                      
      delxi = 1d0/6d0 
      deleta = 1d0/6d0 
!  lagrange 3-pt.                                                       
      if (ixi .le. 2) ixi = 2 
      if (ixi .ge. 48) ixi = 48 
      if (ieta .le. 2) ieta = 2 
      if (ieta .ge. 72) ieta = 72 
      pxi = (dlxi - dlaxi(ixi))/delxi 
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +                 &
     &     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +                         &
     &     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)                      
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +                    &
     &     (1d0 - pxi**2)*calcpts(ieta,ixi) +                           &
     &     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)                        
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +                  &
     &     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +                         &
     &     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)                      
      peta = (dleta - dlaeta(ieta))/deleta 
      h1_FTg = peta*(peta-1d0)/2d0*f(-1) +                              &
     &     (1d0 - peta**2)*f(0) +                                       &
     &     peta*(peta+1d0)/2d0*f(1)                                     
!MB  +     + peta*(peta+1d0)/2d0*f(1)                                   
      return 
      END                                           
                                                                        
!     ==========================================                        
      double precision function h1bar_Tg(eta,xi) 
!     ==========================================                        
                                                                        
!     eq (12) in PLB347 (1995) 143 - 151 for the transverse piece       
!     MSbar scheme                                                      
!     This routine is called subctbar in the original code.             
!     Called sctbar in updated code (03/06/96).                         
                                                                        
      implicit none 
      integer neta, nxi 
      parameter (neta = 73, nxi = 49) 
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi) 
      double precision eta, xi, dleta, dlxi 
      double precision pxi, peta, f(-1:1), delxi, deleta 
      integer j, ieta, ixi 
                                                                        
      data (calcpts(j, 1), j = 1,neta) /0.2829D-03, 0.3429D-03,         &
     &    0.4153D-03, 0.5032D-03, 0.6093D-03, 0.7385D-03, 0.8944D-03,   &
     &    0.1084D-02, 0.1313D-02, 0.1591D-02, 0.1928D-02, 0.2339D-02,   &
     &    0.2827D-02, 0.3429D-02, 0.4159D-02, 0.5038D-02, 0.6106D-02,   &
     &    0.7404D-02, 0.8979D-02, 0.1089D-01, 0.1322D-01, 0.1605D-01,   &
     &    0.1950D-01, 0.2372D-01, 0.2888D-01, 0.3520D-01, 0.4295D-01,   &
     &    0.5243D-01, 0.6398D-01, 0.7789D-01, 0.9419D-01, 0.1127D+00,   &
     &    0.1321D+00, 0.1504D+00, 0.1646D+00, 0.1713D+00, 0.1691D+00,   &
     &    0.1584D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8429D-01,   &
     &    0.6827D-01, 0.5456D-01, 0.4314D-01, 0.3383D-01, 0.2625D-01,   &
     &    0.2023D-01, 0.1549D-01, 0.1175D-01, 0.8913D-02, 0.6710D-02,   &
     &    0.4996D-02, 0.3763D-02, 0.2807D-02, 0.2058D-02, 0.1515D-02,   &
     &    0.1108D-02, 0.8360D-03, 0.6327D-03, 0.4304D-03, 0.2955D-03,   &
     &    0.2278D-03, 0.1604D-03, 0.9327D-04, 0.9293D-04, 0.9271D-04,   &
     &    0.2589D-04, 0.2578D-04, 0.2571D-04, 0.2566D-04, 0.2563D-04,   &
     &    0.2561D-04/                                                   
                                                                        
      data (calcpts(j, 2), j = 1,neta) /0.2830D-03, 0.3423D-03,         &
     &    0.4154D-03, 0.5027D-03, 0.6095D-03, 0.7380D-03, 0.8946D-03,   &
     &    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1928D-02, 0.2333D-02,   &
     &    0.2828D-02, 0.3430D-02, 0.4153D-02, 0.5039D-02, 0.6107D-02,   &
     &    0.7399D-02, 0.8973D-02, 0.1089D-01, 0.1321D-01, 0.1604D-01,   &
     &    0.1950D-01, 0.2371D-01, 0.2888D-01, 0.3519D-01, 0.4294D-01,   &
     &    0.5242D-01, 0.6398D-01, 0.7789D-01, 0.9419D-01, 0.1127D+00,   &
     &    0.1321D+00, 0.1504D+00, 0.1645D+00, 0.1713D+00, 0.1691D+00,   &
     &    0.1584D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8429D-01,   &
     &    0.6827D-01, 0.5462D-01, 0.4320D-01, 0.3382D-01, 0.2623D-01,   &
     &    0.2021D-01, 0.1548D-01, 0.1173D-01, 0.8899D-02, 0.6697D-02,   &
     &    0.5049D-02, 0.3750D-02, 0.2794D-02, 0.2045D-02, 0.1501D-02,   &
     &    0.1094D-02, 0.8227D-03, 0.6194D-03, 0.4172D-03, 0.3490D-03,   &
     &    0.2146D-03, 0.1472D-03, 0.1467D-03, 0.7970D-04, 0.7948D-04,   &
     &    0.7932D-04, 0.1255D-04, 0.1248D-04, 0.1243D-04, 0.1240D-04,   &
     &    0.1237D-04/                                                   
                                                                        
      data (calcpts(j, 3), j = 1,neta) /0.2825D-03, 0.3425D-03,         &
     &    0.4150D-03, 0.5030D-03, 0.6091D-03, 0.7384D-03, 0.8943D-03,   &
     &    0.1084D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2333D-02,   &
     &    0.2829D-02, 0.3431D-02, 0.4154D-02, 0.5033D-02, 0.6102D-02,   &
     &    0.7400D-02, 0.8975D-02, 0.1088D-01, 0.1322D-01, 0.1605D-01,   &
     &    0.1950D-01, 0.2372D-01, 0.2887D-01, 0.3519D-01, 0.4294D-01,   &
     &    0.5242D-01, 0.6397D-01, 0.7783D-01, 0.9418D-01, 0.1127D+00,   &
     &    0.1321D+00, 0.1503D+00, 0.1645D+00, 0.1713D+00, 0.1691D+00,   &
     &    0.1583D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8428D-01,   &
     &    0.6826D-01, 0.5460D-01, 0.4318D-01, 0.3380D-01, 0.2621D-01,   &
     &    0.2019D-01, 0.1546D-01, 0.1178D-01, 0.8880D-02, 0.6677D-02,   &
     &    0.5030D-02, 0.3730D-02, 0.2774D-02, 0.2092D-02, 0.1549D-02,   &
     &    0.1142D-02, 0.8033D-03, 0.6000D-03, 0.4644D-03, 0.3296D-03,   &
     &    0.2618D-03, 0.1945D-03, 0.1273D-03, 0.6031D-04, 0.6008D-04,   &
     &    0.5993D-04, 0.5982D-04, -.6914D-05, -.6963D-05, -.6996D-05,   &
     &    -.7019D-05/                                                   
                                                                        
      data (calcpts(j, 4), j = 1,neta) /0.2827D-03, 0.3428D-03,         &
     &    0.4153D-03, 0.5027D-03, 0.6089D-03, 0.7382D-03, 0.8942D-03,   &
     &    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2335D-02,   &
     &    0.2830D-02, 0.3426D-02, 0.4156D-02, 0.5035D-02, 0.6104D-02,   &
     &    0.7403D-02, 0.8971D-02, 0.1089D-01, 0.1321D-01, 0.1604D-01,   &
     &    0.1949D-01, 0.2371D-01, 0.2887D-01, 0.3519D-01, 0.4293D-01,   &
     &    0.5241D-01, 0.6395D-01, 0.7783D-01, 0.9418D-01, 0.1126D+00,   &
     &    0.1320D+00, 0.1503D+00, 0.1644D+00, 0.1713D+00, 0.1691D+00,   &
     &    0.1583D+00, 0.1416D+00, 0.1221D+00, 0.1024D+00, 0.8428D-01,   &
     &    0.6826D-01, 0.5457D-01, 0.4315D-01, 0.3377D-01, 0.2625D-01,   &
     &    0.2023D-01, 0.1550D-01, 0.1175D-01, 0.8918D-02, 0.6715D-02,   &
     &    0.5001D-02, 0.3768D-02, 0.2813D-02, 0.2064D-02, 0.1520D-02,   &
     &    0.1113D-02, 0.8415D-03, 0.6382D-03, 0.4360D-03, 0.3011D-03,   &
     &    0.2334D-03, 0.1660D-03, 0.9883D-04, 0.9849D-04, 0.3160D-04,   &
     &    0.3145D-04, 0.3134D-04, 0.3127D-04, 0.3122D-04, 0.3119D-04,   &
     &    0.3117D-04/                                                   
                                                                        
      data (calcpts(j, 5), j = 1,neta) /0.2824D-03, 0.3425D-03,         &
     &    0.4151D-03, 0.5025D-03, 0.6088D-03, 0.7382D-03, 0.8944D-03,   &
     &    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2336D-02,   &
     &    0.2832D-02, 0.3428D-02, 0.4152D-02, 0.5031D-02, 0.6100D-02,   &
     &    0.7399D-02, 0.8968D-02, 0.1088D-01, 0.1321D-01, 0.1604D-01,   &
     &    0.1949D-01, 0.2370D-01, 0.2886D-01, 0.3518D-01, 0.4292D-01,   &
     &    0.5239D-01, 0.6393D-01, 0.7782D-01, 0.9411D-01, 0.1126D+00,   &
     &    0.1320D+00, 0.1503D+00, 0.1644D+00, 0.1713D+00, 0.1690D+00,   &
     &    0.1583D+00, 0.1415D+00, 0.1221D+00, 0.1024D+00, 0.8427D-01,   &
     &    0.6825D-01, 0.5459D-01, 0.4317D-01, 0.3380D-01, 0.2621D-01,   &
     &    0.2019D-01, 0.1545D-01, 0.1178D-01, 0.8876D-02, 0.6674D-02,   &
     &    0.5026D-02, 0.3727D-02, 0.2771D-02, 0.2089D-02, 0.1545D-02,   &
     &    0.1138D-02, 0.7997D-03, 0.5964D-03, 0.4608D-03, 0.3260D-03,   &
     &    0.2582D-03, 0.1909D-03, 0.1237D-03, 0.5670D-04, 0.5648D-04,   &
     &    0.5632D-04, 0.5622D-04, 0.5615D-04, -.1057D-04, -.1060D-04,   &
     &    -.1062D-04/                                                   
                                                                        
      data (calcpts(j, 6), j = 1,neta) /0.2829D-03, 0.3424D-03,         &
     &    0.4150D-03, 0.5026D-03, 0.6090D-03, 0.7379D-03, 0.8935D-03,   &
     &    0.1083D-02, 0.1312D-02, 0.1590D-02, 0.1925D-02, 0.2332D-02,   &
     &    0.2828D-02, 0.3424D-02, 0.4155D-02, 0.5035D-02, 0.6098D-02,   &
     &    0.7398D-02, 0.8967D-02, 0.1088D-01, 0.1320D-01, 0.1603D-01,   &
     &    0.1948D-01, 0.2369D-01, 0.2885D-01, 0.3516D-01, 0.4290D-01,   &
     &    0.5237D-01, 0.6390D-01, 0.7776D-01, 0.9410D-01, 0.1125D+00,   &
     &    0.1319D+00, 0.1502D+00, 0.1643D+00, 0.1711D+00, 0.1690D+00,   &
     &    0.1582D+00, 0.1415D+00, 0.1220D+00, 0.1024D+00, 0.8425D-01,   &
     &    0.6824D-01, 0.5459D-01, 0.4318D-01, 0.3380D-01, 0.2621D-01,   &
     &    0.2020D-01, 0.1546D-01, 0.1178D-01, 0.8882D-02, 0.6679D-02,   &
     &    0.5031D-02, 0.3732D-02, 0.2776D-02, 0.2094D-02, 0.1550D-02,   &
     &    0.1143D-02, 0.8052D-03, 0.6018D-03, 0.4662D-03, 0.3314D-03,   &
     &    0.2637D-03, 0.1963D-03, 0.1291D-03, 0.6213D-04, 0.6190D-04,   &
     &    0.6175D-04, 0.6164D-04, -.5098D-05, -.5147D-05, -.5180D-05,   &
     &    -.5203D-05/                                                   
                                                                        
      data (calcpts(j, 7), j = 1,neta) /0.2822D-03, 0.3418D-03,         &
     &    0.4146D-03, 0.5024D-03, 0.6083D-03, 0.7374D-03, 0.8933D-03,   &
     &    0.1082D-02, 0.1311D-02, 0.1589D-02, 0.1925D-02, 0.2335D-02,   &
     &    0.2825D-02, 0.3422D-02, 0.4147D-02, 0.5028D-02, 0.6098D-02,   &
     &    0.7392D-02, 0.8962D-02, 0.1087D-01, 0.1319D-01, 0.1602D-01,   &
     &    0.1947D-01, 0.2368D-01, 0.2883D-01, 0.3514D-01, 0.4287D-01,   &
     &    0.5234D-01, 0.6386D-01, 0.7775D-01, 0.9403D-01, 0.1124D+00,   &
     &    0.1318D+00, 0.1501D+00, 0.1642D+00, 0.1711D+00, 0.1689D+00,   &
     &    0.1581D+00, 0.1414D+00, 0.1220D+00, 0.1024D+00, 0.8422D-01,   &
     &    0.6822D-01, 0.5457D-01, 0.4315D-01, 0.3378D-01, 0.2626D-01,   &
     &    0.2024D-01, 0.1544D-01, 0.1176D-01, 0.8925D-02, 0.6722D-02,   &
     &    0.5008D-02, 0.3775D-02, 0.2820D-02, 0.2071D-02, 0.1527D-02,   &
     &    0.1120D-02, 0.8487D-03, 0.5787D-03, 0.4431D-03, 0.3083D-03,   &
     &    0.2405D-03, 0.1732D-03, 0.1060D-03, 0.1057D-03, 0.3878D-04,   &
     &    0.3863D-04, 0.3852D-04, 0.3845D-04, 0.3840D-04, 0.3837D-04,   &
     &    0.3835D-04/                                                   
                                                                        
      data (calcpts(j, 8), j = 1,neta) /0.2819D-03, 0.3417D-03,         &
     &    0.4140D-03, 0.5020D-03, 0.6082D-03, 0.7369D-03, 0.8925D-03,   &
     &    0.1081D-02, 0.1311D-02, 0.1588D-02, 0.1923D-02, 0.2327D-02,   &
     &    0.2824D-02, 0.3422D-02, 0.4148D-02, 0.5023D-02, 0.6094D-02,   &
     &    0.7383D-02, 0.8954D-02, 0.1087D-01, 0.1319D-01, 0.1601D-01,   &
     &    0.1946D-01, 0.2366D-01, 0.2880D-01, 0.3511D-01, 0.4283D-01,   &
     &    0.5229D-01, 0.6380D-01, 0.7762D-01, 0.9395D-01, 0.1123D+00,   &
     &    0.1317D+00, 0.1500D+00, 0.1640D+00, 0.1709D+00, 0.1687D+00,   &
     &    0.1580D+00, 0.1414D+00, 0.1219D+00, 0.1023D+00, 0.8419D-01,   &
     &    0.6819D-01, 0.5450D-01, 0.4315D-01, 0.3378D-01, 0.2626D-01,   &
     &    0.2017D-01, 0.1544D-01, 0.1176D-01, 0.8926D-02, 0.6724D-02,   &
     &    0.5010D-02, 0.3777D-02, 0.2755D-02, 0.2073D-02, 0.1529D-02,   &
     &    0.1122D-02, 0.8504D-03, 0.5805D-03, 0.4449D-03, 0.3100D-03,   &
     &    0.2423D-03, 0.1749D-03, 0.1078D-03, 0.1074D-03, 0.4054D-04,   &
     &    0.4039D-04, 0.4028D-04, 0.4021D-04, 0.4016D-04, 0.4013D-04,   &
     &    0.4011D-04/                                                   
                                                                        
      data (calcpts(j, 9), j = 1,neta) /0.2821D-03, 0.3414D-03,         &
     &    0.4141D-03, 0.5010D-03, 0.6076D-03, 0.7361D-03, 0.8916D-03,   &
     &    0.1080D-02, 0.1309D-02, 0.1585D-02, 0.1921D-02, 0.2328D-02,   &
     &    0.2820D-02, 0.3419D-02, 0.4139D-02, 0.5022D-02, 0.6082D-02,   &
     &    0.7378D-02, 0.8945D-02, 0.1085D-01, 0.1317D-01, 0.1599D-01,   &
     &    0.1943D-01, 0.2363D-01, 0.2877D-01, 0.3506D-01, 0.4277D-01,   &
     &    0.5221D-01, 0.6370D-01, 0.7755D-01, 0.9379D-01, 0.1121D+00,   &
     &    0.1315D+00, 0.1497D+00, 0.1638D+00, 0.1707D+00, 0.1685D+00,   &
     &    0.1579D+00, 0.1412D+00, 0.1218D+00, 0.1023D+00, 0.8414D-01,   &
     &    0.6816D-01, 0.5450D-01, 0.4309D-01, 0.3378D-01, 0.2620D-01,   &
     &    0.2018D-01, 0.1544D-01, 0.1177D-01, 0.8867D-02, 0.6665D-02,   &
     &    0.5017D-02, 0.3718D-02, 0.2762D-02, 0.2080D-02, 0.1537D-02,   &
     &    0.1130D-02, 0.7915D-03, 0.5882D-03, 0.4526D-03, 0.3177D-03,   &
     &    0.2500D-03, 0.1826D-03, 0.1155D-03, 0.1151D-03, 0.4825D-04,   &
     &    0.4810D-04, 0.4800D-04, 0.4793D-04, 0.4788D-04, -.1882D-04,   &
     &    -.1885D-04/                                                   
                                                                        
      data (calcpts(j,10), j = 1,neta) /0.2816D-03, 0.3406D-03,         &
     &    0.4130D-03, 0.5005D-03, 0.6063D-03, 0.7348D-03, 0.8897D-03,   &
     &    0.1078D-02, 0.1307D-02, 0.1583D-02, 0.1917D-02, 0.2324D-02,   &
     &    0.2812D-02, 0.3413D-02, 0.4136D-02, 0.5014D-02, 0.6076D-02,   &
     &    0.7362D-02, 0.8930D-02, 0.1083D-01, 0.1315D-01, 0.1596D-01,   &
     &    0.1939D-01, 0.2359D-01, 0.2871D-01, 0.3500D-01, 0.4269D-01,   &
     &    0.5211D-01, 0.6357D-01, 0.7734D-01, 0.9356D-01, 0.1119D+00,   &
     &    0.1311D+00, 0.1493D+00, 0.1634D+00, 0.1703D+00, 0.1682D+00,   &
     &    0.1576D+00, 0.1410D+00, 0.1217D+00, 0.1022D+00, 0.8406D-01,   &
     &    0.6810D-01, 0.5448D-01, 0.4307D-01, 0.3376D-01, 0.2618D-01,   &
     &    0.2016D-01, 0.1543D-01, 0.1175D-01, 0.8918D-02, 0.6716D-02,   &
     &    0.5002D-02, 0.3770D-02, 0.2814D-02, 0.2066D-02, 0.1522D-02,   &
     &    0.1115D-02, 0.8435D-03, 0.5735D-03, 0.4379D-03, 0.3031D-03,   &
     &    0.2354D-03, 0.1680D-03, 0.1008D-03, 0.1005D-03, 0.3361D-04,   &
     &    0.3346D-04, 0.3335D-04, 0.3328D-04, 0.3324D-04, 0.3320D-04,   &
     &    0.3318D-04/                                                   
                                                                        
      data (calcpts(j,11), j = 1,neta) /0.2808D-03, 0.3397D-03,         &
     &    0.4121D-03, 0.4989D-03, 0.6049D-03, 0.7330D-03, 0.8876D-03,   &
     &    0.1076D-02, 0.1304D-02, 0.1579D-02, 0.1913D-02, 0.2318D-02,   &
     &    0.2811D-02, 0.3401D-02, 0.4126D-02, 0.5001D-02, 0.6060D-02,   &
     &    0.7342D-02, 0.8908D-02, 0.1080D-01, 0.1311D-01, 0.1592D-01,   &
     &    0.1934D-01, 0.2352D-01, 0.2864D-01, 0.3490D-01, 0.4257D-01,   &
     &    0.5195D-01, 0.6338D-01, 0.7713D-01, 0.9325D-01, 0.1115D+00,   &
     &    0.1307D+00, 0.1489D+00, 0.1630D+00, 0.1698D+00, 0.1678D+00,   &
     &    0.1573D+00, 0.1408D+00, 0.1215D+00, 0.1020D+00, 0.8395D-01,   &
     &    0.6802D-01, 0.5440D-01, 0.4305D-01, 0.3368D-01, 0.2616D-01,   &
     &    0.2015D-01, 0.1541D-01, 0.1174D-01, 0.8907D-02, 0.6705D-02,   &
     &    0.4991D-02, 0.3759D-02, 0.2804D-02, 0.2055D-02, 0.1512D-02,   &
     &    0.1105D-02, 0.8330D-03, 0.6298D-03, 0.4275D-03, 0.2927D-03,   &
     &    0.2250D-03, 0.1576D-03, 0.9045D-04, 0.9012D-04, 0.8989D-04,   &
     &    0.2308D-04, 0.2297D-04, 0.2290D-04, 0.2285D-04, 0.2282D-04,   &
     &    0.2280D-04/                                                   
                                                                        
      data (calcpts(j,12), j = 1,neta) /0.2794D-03, 0.3384D-03,         &
     &    0.4104D-03, 0.4976D-03, 0.6028D-03, 0.7303D-03, 0.8845D-03,   &
     &    0.1072D-02, 0.1298D-02, 0.1573D-02, 0.1906D-02, 0.2310D-02,   &
     &    0.2798D-02, 0.3391D-02, 0.4107D-02, 0.4980D-02, 0.6037D-02,   &
     &    0.7318D-02, 0.8875D-02, 0.1076D-01, 0.1306D-01, 0.1586D-01,   &
     &    0.1927D-01, 0.2343D-01, 0.2853D-01, 0.3476D-01, 0.4239D-01,   &
     &    0.5173D-01, 0.6310D-01, 0.7678D-01, 0.9279D-01, 0.1109D+00,   &
     &    0.1301D+00, 0.1481D+00, 0.1622D+00, 0.1691D+00, 0.1672D+00,   &
     &    0.1568D+00, 0.1404D+00, 0.1212D+00, 0.1018D+00, 0.8379D-01,   &
     &    0.6790D-01, 0.5432D-01, 0.4298D-01, 0.3368D-01, 0.2616D-01,   &
     &    0.2015D-01, 0.1542D-01, 0.1174D-01, 0.8843D-02, 0.6708D-02,   &
     &    0.4995D-02, 0.3762D-02, 0.2807D-02, 0.2059D-02, 0.1515D-02,   &
     &    0.1108D-02, 0.8366D-03, 0.6334D-03, 0.4312D-03, 0.2963D-03,   &
     &    0.2286D-03, 0.1613D-03, 0.9411D-04, 0.9378D-04, 0.9356D-04,   &
     &    0.2674D-04, 0.2664D-04, 0.2657D-04, 0.2652D-04, 0.2649D-04,   &
     &    0.2647D-04/                                                   
                                                                        
      data (calcpts(j,13), j = 1,neta) /0.2781D-03, 0.3369D-03,         &
     &    0.4082D-03, 0.4949D-03, 0.5992D-03, 0.7261D-03, 0.8799D-03,   &
     &    0.1066D-02, 0.1291D-02, 0.1565D-02, 0.1896D-02, 0.2297D-02,   &
     &    0.2783D-02, 0.3376D-02, 0.4084D-02, 0.4957D-02, 0.6001D-02,   &
     &    0.7282D-02, 0.8828D-02, 0.1071D-01, 0.1300D-01, 0.1577D-01,   &
     &    0.1916D-01, 0.2330D-01, 0.2836D-01, 0.3455D-01, 0.4214D-01,   &
     &    0.5141D-01, 0.6268D-01, 0.7623D-01, 0.9216D-01, 0.1102D+00,   &
     &    0.1291D+00, 0.1471D+00, 0.1611D+00, 0.1681D+00, 0.1663D+00,   &
     &    0.1560D+00, 0.1398D+00, 0.1208D+00, 0.1015D+00, 0.8356D-01,   &
     &    0.6773D-01, 0.5417D-01, 0.4290D-01, 0.3360D-01, 0.2609D-01,   &
     &    0.2015D-01, 0.1542D-01, 0.1174D-01, 0.8844D-02, 0.6643D-02,   &
     &    0.4997D-02, 0.3765D-02, 0.2810D-02, 0.2062D-02, 0.1518D-02,   &
     &    0.1111D-02, 0.8399D-03, 0.6366D-03, 0.4344D-03, 0.2996D-03,   &
     &    0.2319D-03, 0.1645D-03, 0.9741D-04, 0.9708D-04, 0.9686D-04,   &
     &    0.3005D-04, 0.2994D-04, 0.2987D-04, 0.2983D-04, 0.2979D-04,   &
     &    0.2977D-04/                                                   
                                                                        
      data (calcpts(j,14), j = 1,neta) /0.2757D-03, 0.3342D-03,         &
     &    0.4053D-03, 0.4909D-03, 0.5944D-03, 0.7208D-03, 0.8734D-03,   &
     &    0.1058D-02, 0.1282D-02, 0.1553D-02, 0.1881D-02, 0.2279D-02,   &
     &    0.2760D-02, 0.3346D-02, 0.4057D-02, 0.4912D-02, 0.5959D-02,   &
     &    0.7225D-02, 0.8761D-02, 0.1063D-01, 0.1289D-01, 0.1565D-01,   &
     &    0.1901D-01, 0.2312D-01, 0.2813D-01, 0.3426D-01, 0.4177D-01,   &
     &    0.5094D-01, 0.6209D-01, 0.7546D-01, 0.9123D-01, 0.1090D+00,   &
     &    0.1277D+00, 0.1456D+00, 0.1595D+00, 0.1666D+00, 0.1649D+00,   &
     &    0.1550D+00, 0.1390D+00, 0.1201D+00, 0.1010D+00, 0.8322D-01,   &
     &    0.6748D-01, 0.5402D-01, 0.4276D-01, 0.3354D-01, 0.2604D-01,   &
     &    0.2009D-01, 0.1537D-01, 0.1169D-01, 0.8864D-02, 0.6664D-02,   &
     &    0.5018D-02, 0.3720D-02, 0.2765D-02, 0.2084D-02, 0.1540D-02,   &
     &    0.1134D-02, 0.7956D-03, 0.5924D-03, 0.4569D-03, 0.3221D-03,   &
     &    0.2544D-03, 0.1870D-03, 0.1199D-03, 0.1196D-03, 0.5270D-04,   &
     &    0.5255D-04, 0.5245D-04, 0.5238D-04, -.1433D-04, -.1436D-04,   &
     &    -.1438D-04/                                                   
                                                                        
      data (calcpts(j,15), j = 1,neta) /0.2728D-03, 0.3303D-03,         &
     &    0.4008D-03, 0.4855D-03, 0.5879D-03, 0.7125D-03, 0.8631D-03,   &
     &    0.1045D-02, 0.1267D-02, 0.1535D-02, 0.1860D-02, 0.2254D-02,   &
     &    0.2733D-02, 0.3311D-02, 0.4014D-02, 0.4862D-02, 0.5890D-02,   &
     &    0.7144D-02, 0.8656D-02, 0.1050D-01, 0.1274D-01, 0.1547D-01,   &
     &    0.1879D-01, 0.2284D-01, 0.2779D-01, 0.3384D-01, 0.4124D-01,   &
     &    0.5028D-01, 0.6126D-01, 0.7442D-01, 0.8991D-01, 0.1074D+00,   &
     &    0.1259D+00, 0.1435D+00, 0.1573D+00, 0.1644D+00, 0.1630D+00,   &
     &    0.1534D+00, 0.1378D+00, 0.1192D+00, 0.1004D+00, 0.8273D-01,   &
     &    0.6712D-01, 0.5375D-01, 0.4256D-01, 0.3335D-01, 0.2591D-01,   &
     &    0.1998D-01, 0.1532D-01, 0.1165D-01, 0.8822D-02, 0.6623D-02,   &
     &    0.4978D-02, 0.3748D-02, 0.2793D-02, 0.2045D-02, 0.1502D-02,   &
     &    0.1095D-02, 0.8240D-03, 0.6209D-03, 0.4188D-03, 0.3507D-03,   &
     &    0.2163D-03, 0.1490D-03, 0.1485D-03, 0.8154D-04, 0.8133D-04,   &
     &    0.1452D-04, 0.1442D-04, 0.1435D-04, 0.1431D-04, 0.1427D-04,   &
     &    0.1425D-04/                                                   
                                                                        
      data (calcpts(j,16), j = 1,neta) /0.2682D-03, 0.3250D-03,         &
     &    0.3946D-03, 0.4778D-03, 0.5786D-03, 0.7010D-03, 0.8497D-03,   &
     &    0.1029D-02, 0.1247D-02, 0.1511D-02, 0.1830D-02, 0.2218D-02,   &
     &    0.2686D-02, 0.3253D-02, 0.3946D-02, 0.4780D-02, 0.5795D-02,   &
     &    0.7024D-02, 0.8518D-02, 0.1033D-01, 0.1254D-01, 0.1521D-01,   &
     &    0.1848D-01, 0.2246D-01, 0.2732D-01, 0.3325D-01, 0.4050D-01,   &
     &    0.4935D-01, 0.6008D-01, 0.7296D-01, 0.8805D-01, 0.1051D+00,   &
     &    0.1232D+00, 0.1404D+00, 0.1541D+00, 0.1614D+00, 0.1603D+00,   &
     &    0.1512D+00, 0.1361D+00, 0.1180D+00, 0.9940D-01, 0.8202D-01,   &
     &    0.6661D-01, 0.5338D-01, 0.4228D-01, 0.3315D-01, 0.2579D-01,   &
     &    0.1993D-01, 0.1528D-01, 0.1161D-01, 0.8786D-02, 0.6655D-02,   &
     &    0.4945D-02, 0.3715D-02, 0.2761D-02, 0.2080D-02, 0.1537D-02,   &
     &    0.1131D-02, 0.7928D-03, 0.5897D-03, 0.4543D-03, 0.3196D-03,   &
     &    0.2519D-03, 0.1846D-03, 0.1175D-03, 0.1172D-03, 0.5032D-04,   &
     &    0.5017D-04, 0.5008D-04, 0.5001D-04, 0.4997D-04, -.1673D-04,   &
     &    -.1675D-04/                                                   
                                                                        
      data (calcpts(j,17), j = 1,neta) /0.2625D-03, 0.3178D-03,         &
     &    0.3854D-03, 0.4667D-03, 0.5652D-03, 0.6851D-03, 0.8304D-03,   &
     &    0.1006D-02, 0.1219D-02, 0.1476D-02, 0.1789D-02, 0.2167D-02,   &
     &    0.2629D-02, 0.3185D-02, 0.3855D-02, 0.4675D-02, 0.5665D-02,   &
     &    0.6864D-02, 0.8322D-02, 0.1010D-01, 0.1225D-01, 0.1486D-01,   &
     &    0.1804D-01, 0.2192D-01, 0.2666D-01, 0.3243D-01, 0.3947D-01,   &
     &    0.4806D-01, 0.5845D-01, 0.7091D-01, 0.8548D-01, 0.1020D+00,   &
     &    0.1195D+00, 0.1363D+00, 0.1497D+00, 0.1571D+00, 0.1566D+00,   &
     &    0.1481D+00, 0.1336D+00, 0.1161D+00, 0.9804D-01, 0.8102D-01,   &
     &    0.6588D-01, 0.5284D-01, 0.4189D-01, 0.3291D-01, 0.2564D-01,   &
     &    0.1978D-01, 0.1514D-01, 0.1154D-01, 0.8721D-02, 0.6593D-02,   &
     &    0.4951D-02, 0.3722D-02, 0.2768D-02, 0.2022D-02, 0.1479D-02,   &
     &    0.1139D-02, 0.8017D-03, 0.5988D-03, 0.4634D-03, 0.3287D-03,   &
     &    0.2611D-03, 0.1938D-03, 0.1267D-03, 0.5977D-04, 0.5957D-04,   &
     &    0.5944D-04, 0.5934D-04, -.7387D-05, -.7430D-05, -.7460D-05,   &
     &    -.7480D-05/                                                   
                                                                        
      data (calcpts(j,18), j = 1,neta) /0.2543D-03, 0.3078D-03,         &
     &    0.3732D-03, 0.4520D-03, 0.5474D-03, 0.6629D-03, 0.8035D-03,   &
     &    0.9733D-03, 0.1180D-02, 0.1429D-02, 0.1731D-02, 0.2098D-02,   &
     &    0.2541D-02, 0.3079D-02, 0.3729D-02, 0.4525D-02, 0.5479D-02,   &
     &    0.6644D-02, 0.8051D-02, 0.9766D-02, 0.1184D-01, 0.1437D-01,   &
     &    0.1745D-01, 0.2119D-01, 0.2575D-01, 0.3131D-01, 0.3808D-01,   &
     &    0.4632D-01, 0.5627D-01, 0.6816D-01, 0.8206D-01, 0.9782D-01,   &
     &    0.1145D+00, 0.1306D+00, 0.1438D+00, 0.1513D+00, 0.1513D+00,   &
     &    0.1437D+00, 0.1302D+00, 0.1135D+00, 0.9614D-01, 0.7963D-01,   &
     &    0.6486D-01, 0.5210D-01, 0.4140D-01, 0.3251D-01, 0.2532D-01,   &
     &    0.1955D-01, 0.1505D-01, 0.1146D-01, 0.8710D-02, 0.6519D-02,   &
     &    0.4945D-02, 0.3651D-02, 0.2766D-02, 0.2020D-02, 0.1478D-02,   &
     &    0.1138D-02, 0.8008D-03, 0.5980D-03, 0.4628D-03, 0.3282D-03,   &
     &    0.2606D-03, 0.1934D-03, 0.1263D-03, 0.5934D-04, 0.5915D-04,   &
     &    0.5902D-04, 0.5893D-04, -.7793D-05, -.7834D-05, -.7862D-05,   &
     &    -.7881D-05/                                                   
                                                                        
      data (calcpts(j,19), j = 1,neta) /0.2427D-03, 0.2943D-03,         &
     &    0.3564D-03, 0.4321D-03, 0.5233D-03, 0.6339D-03, 0.7677D-03,   &
     &    0.9304D-03, 0.1128D-02, 0.1366D-02, 0.1654D-02, 0.2005D-02,   &
     &    0.2429D-02, 0.2943D-02, 0.3568D-02, 0.4323D-02, 0.5235D-02,   &
     &    0.6346D-02, 0.7694D-02, 0.9331D-02, 0.1131D-01, 0.1372D-01,   &
     &    0.1665D-01, 0.2022D-01, 0.2455D-01, 0.2983D-01, 0.3625D-01,   &
     &    0.4403D-01, 0.5342D-01, 0.6460D-01, 0.7767D-01, 0.9241D-01,   &
     &    0.1081D+00, 0.1234D+00, 0.1360D+00, 0.1437D+00, 0.1443D+00,   &
     &    0.1378D+00, 0.1256D+00, 0.1100D+00, 0.9352D-01, 0.7771D-01,   &
     &    0.6346D-01, 0.5109D-01, 0.4065D-01, 0.3199D-01, 0.2496D-01,   &
     &    0.1934D-01, 0.1485D-01, 0.1134D-01, 0.8593D-02, 0.6472D-02,   &
     &    0.4902D-02, 0.3676D-02, 0.2725D-02, 0.2047D-02, 0.1505D-02,   &
     &    0.1100D-02, 0.8295D-03, 0.6269D-03, 0.4251D-03, 0.2906D-03,   &
     &    0.2231D-03, 0.1559D-03, 0.8884D-04, 0.8859D-04, 0.8841D-04,   &
     &    0.2162D-04, 0.2154D-04, 0.2149D-04, 0.2145D-04, 0.2142D-04,   &
     &    0.2140D-04/                                                   
                                                                        
      data (calcpts(j,20), j = 1,neta) /0.2281D-03, 0.2765D-03,         &
     &    0.3351D-03, 0.4057D-03, 0.4920D-03, 0.5961D-03, 0.7219D-03,   &
     &    0.8744D-03, 0.1060D-02, 0.1284D-02, 0.1555D-02, 0.1885D-02,   &
     &    0.2284D-02, 0.2768D-02, 0.3353D-02, 0.4060D-02, 0.4921D-02,   &
     &    0.5965D-02, 0.7228D-02, 0.8768D-02, 0.1063D-01, 0.1289D-01,   &
     &    0.1564D-01, 0.1897D-01, 0.2303D-01, 0.2795D-01, 0.3393D-01,   &
     &    0.4116D-01, 0.4985D-01, 0.6017D-01, 0.7220D-01, 0.8575D-01,   &
     &    0.1002D+00, 0.1144D+00, 0.1263D+00, 0.1338D+00, 0.1352D+00,   &
     &    0.1300D+00, 0.1193D+00, 0.1053D+00, 0.8999D-01, 0.7513D-01,   &
     &    0.6159D-01, 0.4974D-01, 0.3967D-01, 0.3130D-01, 0.2449D-01,   &
     &    0.1896D-01, 0.1462D-01, 0.1112D-01, 0.8449D-02, 0.6401D-02,   &
     &    0.4834D-02, 0.3611D-02, 0.2662D-02, 0.1985D-02, 0.1511D-02,   &
     &    0.1106D-02, 0.7688D-03, 0.5665D-03, 0.4316D-03, 0.2972D-03,   &
     &    0.2298D-03, 0.1626D-03, 0.9560D-04, 0.9537D-04, 0.2855D-04,   &
     &    0.2844D-04, 0.2836D-04, 0.2831D-04, 0.2828D-04, 0.2826D-04,   &
     &    0.2824D-04/                                                   
                                                                        
      data (calcpts(j,21), j = 1,neta) /0.2103D-03, 0.2549D-03,         &
     &    0.3087D-03, 0.3736D-03, 0.4527D-03, 0.5489D-03, 0.6649D-03,   &
     &    0.8050D-03, 0.9762D-03, 0.1182D-02, 0.1432D-02, 0.1735D-02,   &
     &    0.2103D-02, 0.2547D-02, 0.3085D-02, 0.3741D-02, 0.4530D-02,   &
     &    0.5493D-02, 0.6658D-02, 0.8067D-02, 0.9784D-02, 0.1186D-01,   &
     &    0.1438D-01, 0.1744D-01, 0.2116D-01, 0.2566D-01, 0.3112D-01,   &
     &    0.3769D-01, 0.4558D-01, 0.5491D-01, 0.6575D-01, 0.7794D-01,   &
     &    0.9094D-01, 0.1037D+00, 0.1147D+00, 0.1220D+00, 0.1241D+00,   &
     &    0.1202D+00, 0.1113D+00, 0.9908D-01, 0.8539D-01, 0.7177D-01,   &
     &    0.5916D-01, 0.4799D-01, 0.3842D-01, 0.3041D-01, 0.2384D-01,   &
     &    0.1852D-01, 0.1426D-01, 0.1091D-01, 0.8312D-02, 0.6336D-02,   &
     &    0.4774D-02, 0.3554D-02, 0.2674D-02, 0.1998D-02, 0.1458D-02,   &
     &    0.1120D-02, 0.7841D-03, 0.5821D-03, 0.4474D-03, 0.3131D-03,   &
     &    0.2458D-03, 0.1787D-03, 0.1117D-03, 0.1115D-03, 0.4471D-04,   &
     &    0.4462D-04, 0.4455D-04, 0.4451D-04, 0.4448D-04, 0.4446D-04,   &
     &    0.4445D-04/                                                   
                                                                        
      data (calcpts(j,22), j = 1,neta) /0.1892D-03, 0.2287D-03,         &
     &    0.2776D-03, 0.3361D-03, 0.4075D-03, 0.4932D-03, 0.5976D-03,   &
     &    0.7242D-03, 0.8775D-03, 0.1063D-02, 0.1288D-02, 0.1560D-02,   &
     &    0.1890D-02, 0.2291D-02, 0.2775D-02, 0.3362D-02, 0.4075D-02,   &
     &    0.4940D-02, 0.5984D-02, 0.7251D-02, 0.8790D-02, 0.1066D-01,   &
     &    0.1292D-01, 0.1566D-01, 0.1898D-01, 0.2301D-01, 0.2788D-01,   &
     &    0.3373D-01, 0.4073D-01, 0.4899D-01, 0.5855D-01, 0.6927D-01,   &
     &    0.8071D-01, 0.9201D-01, 0.1019D+00, 0.1087D+00, 0.1111D+00,   &
     &    0.1086D+00, 0.1016D+00, 0.9138D-01, 0.7959D-01, 0.6752D-01,   &
     &    0.5609D-01, 0.4579D-01, 0.3685D-01, 0.2929D-01, 0.2304D-01,   &
     &    0.1796D-01, 0.1389D-01, 0.1066D-01, 0.8130D-02, 0.6135D-02,   &
     &    0.4644D-02, 0.3495D-02, 0.2617D-02, 0.1942D-02, 0.1470D-02,   &
     &    0.1067D-02, 0.7975D-03, 0.5958D-03, 0.3947D-03, 0.3272D-03,   &
     &    0.2600D-03, 0.1930D-03, 0.1261D-03, 0.5924D-04, 0.5913D-04,   &
     &    0.5905D-04, 0.5900D-04, 0.5896D-04, -.7732D-05, -.7749D-05,   &
     &    -.7760D-05/                                                   
                                                                        
      data (calcpts(j,23), j = 1,neta) /0.1655D-03, 0.2005D-03,         &
     &    0.2427D-03, 0.2942D-03, 0.3569D-03, 0.4318D-03, 0.5232D-03,   &
     &    0.6342D-03, 0.7686D-03, 0.9306D-03, 0.1128D-02, 0.1366D-02,   &
     &    0.1655D-02, 0.2006D-02, 0.2430D-02, 0.2944D-02, 0.3566D-02,   &
     &    0.4324D-02, 0.5236D-02, 0.6346D-02, 0.7697D-02, 0.9327D-02,   &
     &    0.1130D-01, 0.1370D-01, 0.1660D-01, 0.2012D-01, 0.2435D-01,   &
     &    0.2944D-01, 0.3551D-01, 0.4267D-01, 0.5093D-01, 0.6019D-01,   &
     &    0.7004D-01, 0.7982D-01, 0.8841D-01, 0.9454D-01, 0.9712D-01,   &
     &    0.9561D-01, 0.9035D-01, 0.8227D-01, 0.7258D-01, 0.6234D-01,   &
     &    0.5234D-01, 0.4311D-01, 0.3494D-01, 0.2794D-01, 0.2208D-01,   &
     &    0.1727D-01, 0.1340D-01, 0.1032D-01, 0.7891D-02, 0.6003D-02,   &
     &    0.4538D-02, 0.3418D-02, 0.2556D-02, 0.1909D-02, 0.1419D-02,   &
     &    0.1049D-02, 0.7738D-03, 0.5724D-03, 0.4115D-03, 0.3043D-03,   &
     &    0.2172D-03, 0.1635D-03, 0.1167D-03, 0.8322D-04, 0.5646D-04,   &
     &    0.4307D-04, 0.2969D-04, 0.2300D-04, 0.1631D-04, 0.9633D-05,   &
     &    0.2957D-05/                                                   
                                                                        
      data (calcpts(j,24), j = 1,neta) /0.1409D-03, 0.1707D-03,         &
     &    0.2069D-03, 0.2508D-03, 0.3035D-03, 0.3675D-03, 0.4456D-03,   &
     &    0.5401D-03, 0.6543D-03, 0.7925D-03, 0.9600D-03, 0.1164D-02,   &
     &    0.1410D-02, 0.1708D-02, 0.2069D-02, 0.2507D-02, 0.3038D-02,   &
     &    0.3684D-02, 0.4462D-02, 0.5404D-02, 0.6550D-02, 0.7939D-02,   &
     &    0.9619D-02, 0.1166D-01, 0.1413D-01, 0.1711D-01, 0.2072D-01,   &
     &    0.2504D-01, 0.3019D-01, 0.3626D-01, 0.4327D-01, 0.5112D-01,   &
     &    0.5950D-01, 0.6782D-01, 0.7521D-01, 0.8060D-01, 0.8310D-01,   &
     &    0.8228D-01, 0.7840D-01, 0.7221D-01, 0.6458D-01, 0.5629D-01,   &
     &    0.4793D-01, 0.3996D-01, 0.3271D-01, 0.2636D-01, 0.2096D-01,   &
     &    0.1649D-01, 0.1285D-01, 0.9932D-02, 0.7623D-02, 0.5816D-02,   &
     &    0.4408D-02, 0.3325D-02, 0.2498D-02, 0.1867D-02, 0.1391D-02,   &
     &    0.1029D-02, 0.7605D-03, 0.5595D-03, 0.4122D-03, 0.3051D-03,   &
     &    0.2181D-03, 0.1579D-03, 0.1177D-03, 0.8429D-04, 0.6423D-04,   &
     &    0.4418D-04, 0.3082D-04, 0.2413D-04, 0.1745D-04, 0.1077D-04,   &
     &    0.1076D-04/                                                   
                                                                        
      data (calcpts(j,25), j = 1,neta) /0.1168D-03, 0.1415D-03,         &
     &    0.1715D-03, 0.2077D-03, 0.2514D-03, 0.3048D-03, 0.3695D-03,   &
     &    0.4475D-03, 0.5420D-03, 0.6569D-03, 0.7959D-03, 0.9642D-03,   &
     &    0.1169D-02, 0.1415D-02, 0.1715D-02, 0.2078D-02, 0.2518D-02,   &
     &    0.3051D-02, 0.3697D-02, 0.4481D-02, 0.5431D-02, 0.6581D-02,   &
     &    0.7974D-02, 0.9667D-02, 0.1171D-01, 0.1419D-01, 0.1717D-01,   &
     &    0.2076D-01, 0.2503D-01, 0.3008D-01, 0.3591D-01, 0.4247D-01,   &
     &    0.4949D-01, 0.5653D-01, 0.6285D-01, 0.6757D-01, 0.6993D-01,   &
     &    0.6954D-01, 0.6664D-01, 0.6189D-01, 0.5601D-01, 0.4956D-01,   &
     &    0.4291D-01, 0.3634D-01, 0.3015D-01, 0.2456D-01, 0.1970D-01,   &
     &    0.1560D-01, 0.1222D-01, 0.9487D-02, 0.7313D-02, 0.5599D-02,   &
     &    0.4256D-02, 0.3222D-02, 0.2424D-02, 0.1814D-02, 0.1359D-02,   &
     &    0.1011D-02, 0.7496D-03, 0.5489D-03, 0.4018D-03, 0.2948D-03,   &
     &    0.2146D-03, 0.1611D-03, 0.1143D-03, 0.8092D-04, 0.6087D-04,   &
     &    0.4084D-04, 0.3415D-04, 0.2080D-04, 0.1413D-04, 0.1412D-04,   &
     &    0.7449D-05/                                                   
                                                                        
      data (calcpts(j,26), j = 1,neta) /0.9441D-04, 0.1144D-03,         &
     &    0.1386D-03, 0.1679D-03, 0.2035D-03, 0.2465D-03, 0.2988D-03,   &
     &    0.3618D-03, 0.4387D-03, 0.5310D-03, 0.6434D-03, 0.7796D-03,   &
     &    0.9444D-03, 0.1144D-02, 0.1386D-02, 0.1680D-02, 0.2035D-02,   &
     &    0.2466D-02, 0.2989D-02, 0.3622D-02, 0.4389D-02, 0.5322D-02,   &
     &    0.6448D-02, 0.7811D-02, 0.9470D-02, 0.1148D-01, 0.1389D-01,   &
     &    0.1680D-01, 0.2027D-01, 0.2438D-01, 0.2914D-01, 0.3452D-01,   &
     &    0.4033D-01, 0.4624D-01, 0.5164D-01, 0.5581D-01, 0.5808D-01,   &
     &    0.5806D-01, 0.5589D-01, 0.5214D-01, 0.4753D-01, 0.4257D-01,   &
     &    0.3746D-01, 0.3231D-01, 0.2728D-01, 0.2255D-01, 0.1829D-01,   &
     &    0.1461D-01, 0.1153D-01, 0.8999D-02, 0.6966D-02, 0.5350D-02,   &
     &    0.4084D-02, 0.3099D-02, 0.2343D-02, 0.1761D-02, 0.1313D-02,   &
     &    0.9785D-03, 0.7245D-03, 0.5374D-03, 0.3904D-03, 0.2902D-03,   &
     &    0.2101D-03, 0.1567D-03, 0.1099D-03, 0.7655D-04, 0.5652D-04,   &
     &    0.4316D-04, 0.2982D-04, 0.1647D-04, 0.1647D-04, 0.9795D-05,   &
     &    0.3125D-05/                                                   
                                                                        
      data (calcpts(j,27), j = 1,neta) /0.7459D-04, 0.9038D-04,         &
     &    0.1096D-03, 0.1328D-03, 0.1608D-03, 0.1948D-03, 0.2361D-03,   &
     &    0.2860D-03, 0.3463D-03, 0.4201D-03, 0.5086D-03, 0.6162D-03,   &
     &    0.7467D-03, 0.9047D-03, 0.1096D-02, 0.1328D-02, 0.1609D-02,   &
     &    0.1950D-02, 0.2363D-02, 0.2863D-02, 0.3470D-02, 0.4206D-02,   &
     &    0.5098D-02, 0.6182D-02, 0.7492D-02, 0.9074D-02, 0.1099D-01,   &
     &    0.1330D-01, 0.1607D-01, 0.1933D-01, 0.2315D-01, 0.2749D-01,   &
     &    0.3223D-01, 0.3712D-01, 0.4171D-01, 0.4543D-01, 0.4767D-01,   &
     &    0.4805D-01, 0.4654D-01, 0.4356D-01, 0.3980D-01, 0.3583D-01,   &
     &    0.3191D-01, 0.2802D-01, 0.2413D-01, 0.2032D-01, 0.1674D-01,   &
     &    0.1353D-01, 0.1078D-01, 0.8474D-02, 0.6599D-02, 0.5100D-02,   &
     &    0.3910D-02, 0.2980D-02, 0.2259D-02, 0.1704D-02, 0.1277D-02,   &
     &    0.9560D-03, 0.7089D-03, 0.5286D-03, 0.3884D-03, 0.2883D-03,   &
     &    0.2149D-03, 0.1548D-03, 0.1148D-03, 0.8145D-04, 0.6143D-04,   &
     &    0.4808D-04, 0.3474D-04, 0.2807D-04, 0.2140D-04, 0.1473D-04,   &
     &    0.1472D-04/                                                   
                                                                        
      data (calcpts(j,28), j = 1,neta) /0.5791D-04, 0.7018D-04,         &
     &    0.8503D-04, 0.1030D-03, 0.1248D-03, 0.1512D-03, 0.1832D-03,   &
     &    0.2219D-03, 0.2689D-03, 0.3258D-03, 0.3947D-03, 0.4780D-03,   &
     &    0.5794D-03, 0.7018D-03, 0.8505D-03, 0.1030D-02, 0.1249D-02,   &
     &    0.1513D-02, 0.1834D-02, 0.2222D-02, 0.2693D-02, 0.3264D-02,   &
     &    0.3956D-02, 0.4796D-02, 0.5814D-02, 0.7043D-02, 0.8538D-02,   &
     &    0.1034D-01, 0.1248D-01, 0.1505D-01, 0.1805D-01, 0.2148D-01,   &
     &    0.2527D-01, 0.2925D-01, 0.3310D-01, 0.3637D-01, 0.3858D-01,   &
     &    0.3935D-01, 0.3852D-01, 0.3628D-01, 0.3320D-01, 0.2986D-01,   &
     &    0.2667D-01, 0.2369D-01, 0.2079D-01, 0.1789D-01, 0.1503D-01,   &
     &    0.1235D-01, 0.9957D-02, 0.7905D-02, 0.6194D-02, 0.4811D-02,   &
     &    0.3709D-02, 0.2841D-02, 0.2160D-02, 0.1633D-02, 0.1232D-02,   &
     &    0.9185D-03, 0.6850D-03, 0.5115D-03, 0.3781D-03, 0.2780D-03,   &
     &    0.2046D-03, 0.1512D-03, 0.1112D-03, 0.7787D-04, 0.5786D-04,   &
     &    0.4452D-04, 0.3119D-04, 0.2452D-04, 0.1785D-04, 0.1118D-04,   &
     &    0.1118D-04/                                                   
                                                                        
      data (calcpts(j,29), j = 1,neta) /0.4422D-04, 0.5359D-04,         &
     &    0.6494D-04, 0.7870D-04, 0.9534D-04, 0.1155D-03, 0.1400D-03,   &
     &    0.1695D-03, 0.2054D-03, 0.2489D-03, 0.3015D-03, 0.3653D-03,   &
     &    0.4423D-03, 0.5363D-03, 0.6496D-03, 0.7869D-03, 0.9536D-03,   &
     &    0.1156D-02, 0.1400D-02, 0.1697D-02, 0.2057D-02, 0.2493D-02,   &
     &    0.3022D-02, 0.3664D-02, 0.4441D-02, 0.5384D-02, 0.6524D-02,   &
     &    0.7899D-02, 0.9553D-02, 0.1153D-01, 0.1384D-01, 0.1651D-01,   &
     &    0.1948D-01, 0.2266D-01, 0.2581D-01, 0.2862D-01, 0.3073D-01,   &
     &    0.3179D-01, 0.3158D-01, 0.3012D-01, 0.2772D-01, 0.2490D-01,   &
     &    0.2214D-01, 0.1968D-01, 0.1747D-01, 0.1533D-01, 0.1318D-01,   &
     &    0.1106D-01, 0.9063D-02, 0.7286D-02, 0.5765D-02, 0.4510D-02,   &
     &    0.3496D-02, 0.2688D-02, 0.2055D-02, 0.1561D-02, 0.1174D-02,   &
     &    0.8874D-03, 0.6607D-03, 0.4939D-03, 0.3672D-03, 0.2672D-03,   &
     &    0.2005D-03, 0.1472D-03, 0.1071D-03, 0.7381D-04, 0.5380D-04,   &
     &    0.4047D-04, 0.2713D-04, 0.2046D-04, 0.1379D-04, 0.7127D-05,   &
     &    0.7127D-05/                                                   
                                                                        
      data (calcpts(j,30), j = 1,neta) /0.3339D-04, 0.4040D-04,         &
     &    0.4896D-04, 0.5931D-04, 0.7186D-04, 0.8708D-04, 0.1055D-03,   &
     &    0.1279D-03, 0.1549D-03, 0.1876D-03, 0.2273D-03, 0.2755D-03,   &
     &    0.3337D-03, 0.4043D-03, 0.4899D-03, 0.5933D-03, 0.7195D-03,   &
     &    0.8717D-03, 0.1056D-02, 0.1280D-02, 0.1551D-02, 0.1880D-02,   &
     &    0.2279D-02, 0.2763D-02, 0.3350D-02, 0.4061D-02, 0.4922D-02,   &
     &    0.5962D-02, 0.7212D-02, 0.8703D-02, 0.1047D-01, 0.1251D-01,   &
     &    0.1481D-01, 0.1729D-01, 0.1981D-01, 0.2216D-01, 0.2408D-01,   &
     &    0.2527D-01, 0.2553D-01, 0.2477D-01, 0.2311D-01, 0.2086D-01,   &
     &    0.1846D-01, 0.1628D-01, 0.1443D-01, 0.1281D-01, 0.1125D-01,   &
     &    0.9669D-02, 0.8097D-02, 0.6622D-02, 0.5310D-02, 0.4192D-02,   &
     &    0.3272D-02, 0.2532D-02, 0.1945D-02, 0.1485D-02, 0.1125D-02,   &
     &    0.8448D-03, 0.6381D-03, 0.4781D-03, 0.3514D-03, 0.2648D-03,   &
     &    0.1914D-03, 0.1448D-03, 0.1048D-03, 0.7809D-04, 0.5809D-04,   &
     &    0.3809D-04, 0.3142D-04, 0.1809D-04, 0.1809D-04, 0.1142D-04,   &
     &    0.4756D-05/                                                   
                                                                        
      data (calcpts(j,31), j = 1,neta) /0.2490D-04, 0.3016D-04,         &
     &    0.3654D-04, 0.4428D-04, 0.5367D-04, 0.6502D-04, 0.7877D-04,   &
     &    0.9543D-04, 0.1156D-03, 0.1401D-03, 0.1697D-03, 0.2056D-03,   &
     &    0.2490D-03, 0.3017D-03, 0.3656D-03, 0.4430D-03, 0.5366D-03,   &
     &    0.6505D-03, 0.7880D-03, 0.9552D-03, 0.1158D-02, 0.1403D-02,   &
     &    0.1701D-02, 0.2062D-02, 0.2499D-02, 0.3031D-02, 0.3673D-02,   &
     &    0.4450D-02, 0.5386D-02, 0.6504D-02, 0.7828D-02, 0.9372D-02,   &
     &    0.1112D-01, 0.1302D-01, 0.1501D-01, 0.1691D-01, 0.1855D-01,   &
     &    0.1974D-01, 0.2028D-01, 0.2007D-01, 0.1909D-01, 0.1747D-01,   &
     &    0.1552D-01, 0.1357D-01, 0.1189D-01, 0.1053D-01, 0.9356D-02,   &
     &    0.8220D-02, 0.7059D-02, 0.5903D-02, 0.4817D-02, 0.3855D-02,   &
     &    0.3039D-02, 0.2368D-02, 0.1827D-02, 0.1400D-02, 0.1067D-02,   &
     &    0.8068D-03, 0.6068D-03, 0.4535D-03, 0.3402D-03, 0.2535D-03,   &
     &    0.1869D-03, 0.1402D-03, 0.1002D-03, 0.7354D-04, 0.5354D-04,   &
     &    0.4021D-04, 0.2687D-04, 0.2021D-04, 0.1354D-04, 0.1354D-04,   &
     &    0.6874D-05/                                                   
                                                                        
      data (calcpts(j,32), j = 1,neta) /0.1842D-04, 0.2232D-04,         &
     &    0.2705D-04, 0.3277D-04, 0.3967D-04, 0.4809D-04, 0.5828D-04,   &
     &    0.7059D-04, 0.8552D-04, 0.1036D-03, 0.1255D-03, 0.1521D-03,   &
     &    0.1842D-03, 0.2232D-03, 0.2705D-03, 0.3277D-03, 0.3971D-03,   &
     &    0.4812D-03, 0.5832D-03, 0.7063D-03, 0.8566D-03, 0.1038D-02,   &
     &    0.1258D-02, 0.1525D-02, 0.1849D-02, 0.2242D-02, 0.2717D-02,   &
     &    0.3293D-02, 0.3986D-02, 0.4815D-02, 0.5799D-02, 0.6949D-02,   &
     &    0.8259D-02, 0.9705D-02, 0.1123D-01, 0.1273D-01, 0.1409D-01,   &
     &    0.1517D-01, 0.1583D-01, 0.1597D-01, 0.1551D-01, 0.1450D-01,   &
     &    0.1306D-01, 0.1144D-01, 0.9914D-02, 0.8646D-02, 0.7648D-02,   &
     &    0.6802D-02, 0.5979D-02, 0.5131D-02, 0.4284D-02, 0.3490D-02,   &
     &    0.2787D-02, 0.2193D-02, 0.1706D-02, 0.1315D-02, 0.1007D-02,   &
     &    0.7654D-03, 0.5787D-03, 0.4354D-03, 0.3261D-03, 0.2428D-03,   &
     &    0.1801D-03, 0.1328D-03, 0.9812D-04, 0.7146D-04, 0.5213D-04,   &
     &    0.3813D-04, 0.2746D-04, 0.1946D-04, 0.1413D-04, 0.1013D-04,   &
     &    0.6796D-05/                                                   
                                                                        
      data (calcpts(j,33), j = 1,neta) /0.1353D-04, 0.1639D-04,         &
     &    0.1986D-04, 0.2406D-04, 0.2915D-04, 0.3532D-04, 0.4280D-04,   &
     &    0.5186D-04, 0.6284D-04, 0.7611D-04, 0.9222D-04, 0.1117D-03,   &
     &    0.1353D-03, 0.1640D-03, 0.1987D-03, 0.2407D-03, 0.2917D-03,   &
     &    0.3535D-03, 0.4283D-03, 0.5190D-03, 0.6291D-03, 0.7624D-03,   &
     &    0.9242D-03, 0.1120D-02, 0.1359D-02, 0.1647D-02, 0.1996D-02,   &
     &    0.2419D-02, 0.2929D-02, 0.3539D-02, 0.4264D-02, 0.5114D-02,   &
     &    0.6087D-02, 0.7170D-02, 0.8324D-02, 0.9486D-02, 0.1058D-01,   &
     &    0.1150D-01, 0.1216D-01, 0.1247D-01, 0.1237D-01, 0.1182D-01,   &
     &    0.1089D-01, 0.9674D-02, 0.8381D-02, 0.7203D-02, 0.6260D-02,   &
     &    0.5537D-02, 0.4928D-02, 0.4334D-02, 0.3718D-02, 0.3101D-02,   &
     &    0.2522D-02, 0.2011D-02, 0.1580D-02, 0.1228D-02, 0.9457D-03,   &
     &    0.7231D-03, 0.5498D-03, 0.4151D-03, 0.3125D-03, 0.2338D-03,   &
     &    0.1745D-03, 0.1299D-03, 0.9586D-04, 0.7119D-04, 0.5253D-04,   &
     &    0.3853D-04, 0.2853D-04, 0.2053D-04, 0.1520D-04, 0.1120D-04,   &
     &    0.8532D-05/                                                   
                                                                        
      data (calcpts(j,34), j = 1,neta) /0.9884D-05, 0.1197D-04,         &
     &    0.1451D-04, 0.1758D-04, 0.2129D-04, 0.2579D-04, 0.3125D-04,   &
     &    0.3787D-04, 0.4585D-04, 0.5560D-04, 0.6733D-04, 0.8161D-04,   &
     &    0.9883D-04, 0.1198D-03, 0.1451D-03, 0.1758D-03, 0.2130D-03,   &
     &    0.2581D-03, 0.3128D-03, 0.3790D-03, 0.4594D-03, 0.5567D-03,   &
     &    0.6748D-03, 0.8180D-03, 0.9920D-03, 0.1203D-02, 0.1457D-02,   &
     &    0.1766D-02, 0.2138D-02, 0.2585D-02, 0.3116D-02, 0.3739D-02,   &
     &    0.4456D-02, 0.5258D-02, 0.6121D-02, 0.7005D-02, 0.7857D-02,   &
     &    0.8612D-02, 0.9205D-02, 0.9575D-02, 0.9668D-02, 0.9447D-02,   &
     &    0.8908D-02, 0.8095D-02, 0.7109D-02, 0.6099D-02, 0.5209D-02,   &
     &    0.4514D-02, 0.3993D-02, 0.3557D-02, 0.3130D-02, 0.2683D-02,   &
     &    0.2236D-02, 0.1816D-02, 0.1445D-02, 0.1134D-02, 0.8796D-03,   &
     &    0.6770D-03, 0.5170D-03, 0.3924D-03, 0.2930D-03, 0.2224D-03,   &
     &    0.1664D-03, 0.1237D-03, 0.9174D-04, 0.6774D-04, 0.4974D-04,   &
     &    0.3641D-04, 0.2708D-04, 0.1974D-04, 0.1441D-04, 0.1041D-04,   &
     &    0.7744D-05/                                                   
                                                                        
      data (calcpts(j,35), j = 1,neta) /0.7181D-05, 0.8703D-05,         &
     &    0.1054D-04, 0.1277D-04, 0.1548D-04, 0.1875D-04, 0.2272D-04,   &
     &    0.2752D-04, 0.3334D-04, 0.4039D-04, 0.4895D-04, 0.5928D-04,   &
     &    0.7186D-04, 0.8704D-04, 0.1055D-03, 0.1278D-03, 0.1548D-03,   &
     &    0.1876D-03, 0.2273D-03, 0.2754D-03, 0.3338D-03, 0.4046D-03,   &
     &    0.4904D-03, 0.5944D-03, 0.7209D-03, 0.8739D-03, 0.1059D-02,   &
     &    0.1283D-02, 0.1554D-02, 0.1878D-02, 0.2265D-02, 0.2719D-02,   &
     &    0.3243D-02, 0.3833D-02, 0.4472D-02, 0.5136D-02, 0.5787D-02,   &
     &    0.6385D-02, 0.6885D-02, 0.7246D-02, 0.7428D-02, 0.7396D-02,   &
     &    0.7134D-02, 0.6646D-02, 0.5971D-02, 0.5191D-02, 0.4417D-02,   &
     &    0.3752D-02, 0.3245D-02, 0.2871D-02, 0.2560D-02, 0.2253D-02,   &
     &    0.1931D-02, 0.1607D-02, 0.1303D-02, 0.1036D-02, 0.8116D-03,   &
     &    0.6290D-03, 0.4830D-03, 0.3684D-03, 0.2791D-03, 0.2104D-03,   &
     &    0.1578D-03, 0.1178D-03, 0.8778D-04, 0.6511D-04, 0.4778D-04,   &
     &    0.3512D-04, 0.2578D-04, 0.1845D-04, 0.1378D-04, 0.9784D-05,   &
     &    0.7117D-05/                                                   
                                                                        
      data (calcpts(j,36), j = 1,neta) /0.5199D-05, 0.6298D-05,         &
     &    0.7628D-05, 0.9240D-05, 0.1120D-04, 0.1356D-04, 0.1644D-04,   &
     &    0.1991D-04, 0.2413D-04, 0.2923D-04, 0.3541D-04, 0.4290D-04,   &
     &    0.5199D-04, 0.6297D-04, 0.7629D-04, 0.9246D-04, 0.1120D-03,   &
     &    0.1357D-03, 0.1645D-03, 0.1993D-03, 0.2415D-03, 0.2927D-03,   &
     &    0.3548D-03, 0.4301D-03, 0.5213D-03, 0.6320D-03, 0.7660D-03,   &
     &    0.9282D-03, 0.1124D-02, 0.1359D-02, 0.1639D-02, 0.1969D-02,   &
     &    0.2350D-02, 0.2780D-02, 0.3250D-02, 0.3743D-02, 0.4234D-02,   &
     &    0.4697D-02, 0.5101D-02, 0.5419D-02, 0.5623D-02, 0.5688D-02,   &
     &    0.5595D-02, 0.5336D-02, 0.4918D-02, 0.4375D-02, 0.3771D-02,   &
     &    0.3185D-02, 0.2694D-02, 0.2326D-02, 0.2059D-02, 0.1837D-02,   &
     &    0.1617D-02, 0.1386D-02, 0.1152D-02, 0.9331D-03, 0.7411D-03,   &
     &    0.5799D-03, 0.4492D-03, 0.3446D-03, 0.2626D-03, 0.1993D-03,   &
     &    0.1499D-03, 0.1126D-03, 0.8394D-04, 0.6261D-04, 0.4595D-04,   &
     &    0.3395D-04, 0.2528D-04, 0.1795D-04, 0.1328D-04, 0.9951D-05,   &
     &    0.7284D-05/                                                   
                                                                        
      data (calcpts(j,37), j = 1,neta) /0.3747D-05, 0.4542D-05,         &
     &    0.5498D-05, 0.6662D-05, 0.8071D-05, 0.9782D-05, 0.1185D-04,   &
     &    0.1435D-04, 0.1739D-04, 0.2107D-04, 0.2553D-04, 0.3093D-04,   &
     &    0.3748D-04, 0.4540D-04, 0.5502D-04, 0.6667D-04, 0.8072D-04,   &
     &    0.9783D-04, 0.1185D-03, 0.1437D-03, 0.1741D-03, 0.2110D-03,   &
     &    0.2558D-03, 0.3100D-03, 0.3758D-03, 0.4556D-03, 0.5522D-03,   &
     &    0.6690D-03, 0.8100D-03, 0.9794D-03, 0.1181D-02, 0.1419D-02,   &
     &    0.1695D-02, 0.2008D-02, 0.2351D-02, 0.2714D-02, 0.3080D-02,   &
     &    0.3432D-02, 0.3749D-02, 0.4013D-02, 0.4205D-02, 0.4308D-02,   &
     &    0.4308D-02, 0.4192D-02, 0.3958D-02, 0.3614D-02, 0.3188D-02,   &
