//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


// Definition of the client_socket class

#ifndef _sockets_client_socket_class_
#define _sockets_client_socket_class_

#include "socket.hpp"

namespace sockets
{

  //
  // client_socket: a user-friendly wrapper for
  // authors of socket clients. Simply constructing
  // the object creates a client socket, and connects it
  // to the server.
  //
  class client_socket : private socket
  {
  public:

    client_socket ( const std::string host, const int port );
    virtual ~client_socket(){};

    const client_socket& operator << ( const std::string& ) const;
    const client_socket& operator >> ( std::string& ) const;

  };

};


#endif
