/***************************************************************************
 *   Copyright (C) 2007-2009 by Miguel Chavez Gamboa                  *
 *   miguel.chavez.gamboa@gmail.com                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *

 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include "inputdialog.h"
#include "settings.h"

#include <QtGui>
#include <kiconloader.h>
#include <klocale.h>
#include <QPixmap>
#include <kstandarddirs.h>

InputDialog::InputDialog(QWidget *parent, bool integer, DialogType type, QString msg, double min, double max)
{
  setParent(parent);
  setWindowFlags(Qt::Dialog|Qt::FramelessWindowHint);
  setWindowModality(Qt::ApplicationModal);
  setModal(true);

  vLayout       = new QVBoxLayout(this);
  titleLayout   = new QHBoxLayout();
  gridLayout    = new QGridLayout();
  lPixmap       = new QLabel(this);
  
  if (type == dialogMeasures) lPixmap->setPixmap(DesktopIcon("kruler", 48));
  else if (type == dialogMoney) lPixmap->setPixmap(DesktopIcon("lemon-money", 48));
  else if (type==dialogCashOut) lPixmap->setPixmap(DesktopIcon("lemon-cashout", 48));
  else if (type == dialogTicket) lPixmap->setPixmap(DesktopIcon("lemon-ticket-cancel", 48));
  titleLayout->addWidget(lPixmap);
  label = new QLabel(msg, this);
  titleLayout->addWidget(label);
  QSpacerItem *spacerItem2 = new QSpacerItem(50, 50, QSizePolicy::Minimum, QSizePolicy::Maximum);
  vLayout->addLayout(titleLayout);
  vLayout->addItem(spacerItem2);
  lineEdit = new QLineEdit(this);
  qLabel = new QLabel(i18n("Amount:"));
  reasonLabel = new QLabel(i18n("Reason:"), this);
  if (type==dialogTicket) qLabel->setText(i18n("Ticket #:"));
  reasonEdit = new QLineEdit(this);
  gridLayout->addWidget(qLabel, 0,0,1,1);
  gridLayout->addWidget(lineEdit, 0,1,1,1);
  gridLayout->addWidget(reasonLabel, 1,0,1,1);
  gridLayout->addWidget(reasonEdit, 1,1,1,1);
  vLayout->addLayout(gridLayout);

  if (type!=dialogCashOut) {
    reasonLabel->hide();
    reasonEdit->hide();
  }
  
  //qDebug()<<"Min:"<<min<<"Max:"<<max;
  if (integer) {
    int imin=min; int imax=0;
    if (max>2147483640) imax=2147483647; else imax=max; //max positive value for INT
    //qulonglong imax=max;
    //qDebug()<<"Min:"<<imin<<"Max:"<<imax;
    //FIXME: El valor pasado a max es un DOUBLE, y es mas chico que qulonglong. en mi compu ambos son de 8 bytes.
    //qDebug()<<"Size of qulonglong is "<<sizeof(qulonglong);
    //qDebug()<<"Size of a double is   "<<sizeof(double);
    QIntValidator *validator = new QIntValidator(imin, imax,this);
    lineEdit->setValidator(validator);
    //qintvalidator range is in int (not qlonglong)
    // I NEED TO MAKE VALIDATION WITH REGULAR EXPRESSIONS TO SUPPORT LARGE NUMBERS if we need to do so.. ticket numbers larger
    // than 2,147,483,647. For now, its ok, its at the order of billions (thousand millions).
  } else {
    QDoubleValidator *validator = new QDoubleValidator(min, max, 3,this);
    lineEdit->setValidator(validator);
  }

  
  buttonsLayout = new QHBoxLayout();
  buttonAccept = new QPushButton(this);
  buttonAccept->setText(i18n("Ok"));
  buttonAccept->setDefault( true );
  buttonCancel = new QPushButton(this);
  buttonCancel->setText(i18n("Cancel"));
  buttonCancel->setShortcut(Qt::Key_Escape);
  buttonsLayout->addWidget(buttonCancel);
  buttonsLayout->addWidget(buttonAccept);
  //QSpacerItem *spacerItem3 = new QSpacerItem(70, 70, QSizePolicy::Minimum, QSizePolicy::Maximum);
  //buttonsLayout->addItem(spacerItem3);
  vLayout->addLayout(buttonsLayout);

  buttonAccept->setMaximumSize(QSize(130, 27));
  buttonCancel->setMaximumSize(QSize(130, 27));
  lineEdit->setMaximumSize(QSize(220, 27));
  reasonEdit->setMaximumSize(QSize(220, 27));
  
  iValue = 0;
  dValue = 0.0;
  reason = "";

  label->setObjectName("titleLabelInputDialog");

  //style
  //QRect geom = geometry();
  //qDebug()<<"Geometry before resize:"<<geom;
  resize(365,160);
  //geom = geometry();
  //qDebug()<<"Geometry after resize:"<<geom;
  QString path = KStandardDirs::locate("appdata", "styles/");
  QPixmap pixm = QPixmap(path + Settings::styleName() + "/dialog.png");
  setMask( pixm.mask() );
  
  connect(lineEdit, SIGNAL(returnPressed()), this, SLOT(acceptIt()));
  connect(reasonEdit, SIGNAL(returnPressed()), this, SLOT(acceptIt()));
  connect(buttonAccept, SIGNAL(clicked()), this, SLOT(acceptIt()));
  connect(buttonCancel, SIGNAL(clicked()), this, SLOT(reject()));
}

void InputDialog::paint(QPainter *)
{}

/* This is a workaround for the login/password dialog background.
* Simply draw the pixmap, instead the style painting.
*/
void InputDialog::paintEvent(QPaintEvent *e)
{
  QDialog::paintEvent(e);
  QPainter painter(this);
  painter.setClipRegion(e->region());
  
  QString path = KStandardDirs::locate("appdata", "styles/");
  QPixmap bg = QPixmap(path + Settings::styleName() + "/dialog.png");
  painter.drawPixmap(QPoint(0,0), bg);
}

void InputDialog::acceptIt()
{
  //set values even if not accepted...
  dValue = lineEdit->text().toDouble();
  iValue = lineEdit->text().toULongLong();
  reason = reasonEdit->text();
  
  if (lineEdit->hasAcceptableInput()) {
    if (!reasonEdit->isHidden()) { //cash out dialog
      if (!reasonEdit->text().isEmpty()) {
        QDialog::accept();
      }
    }
    else { //no cashOut dialog ..
      QDialog::accept();
    }
  }
}


#include "inputdialog.moc"

