/***************************************************************************
 *   Copyright (C) 2007 by Miguel Chavez Gamboa                            *
 *   miguel.chavez.gamboa@gmail.com                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *

 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include "inputdialog.h"

#include <QtGui>
#include <kiconloader.h>
#include <klocale.h>

InputDialog::InputDialog(QWidget *parent, bool integer, DialogType type, QString msg, double min, double max)
{
  setParent(parent);
  setWindowFlags(Qt::Dialog|Qt::FramelessWindowHint);
  setWindowModality(Qt::ApplicationModal);
  setModal(true);

  vLayout       = new QVBoxLayout(this);
  titleLayout = new QHBoxLayout();
  lPixmap = new QLabel(this);
  if (type == dialogMeasures) lPixmap->setPixmap(DesktopIcon("kruler", 48));
  else if (type == dialogMoney) lPixmap->setPixmap(DesktopIcon("lemon-money", 48));
  else if (type == dialogTicket) lPixmap->setPixmap(DesktopIcon("lemon-ticket-cancel", 48));
  titleLayout->addWidget(lPixmap);
  label = new QLabel(msg, this);
  titleLayout->addWidget(label);
  vLayout->addLayout(titleLayout);

  lineEdit = new QLineEdit(this);
  if (integer) {
    int imin=min;
    int imax=max;
    QIntValidator *validator = new QIntValidator(imin, imax,this);
    lineEdit->setValidator(validator);
  } else {
    QDoubleValidator *validator = new QDoubleValidator(min, max, 3,this);
    lineEdit->setValidator(validator);
  }
  vLayout->addWidget(lineEdit);
  buttonsLayout = new QHBoxLayout();
  buttonAccept = new QPushButton(this);
  buttonAccept->setText(i18n("Ok"));
  buttonAccept->setDefault( true );
  buttonCancel = new QPushButton(this);
  buttonCancel->setText(i18n("Cancel"));
  buttonCancel->setShortcut(Qt::Key_Escape);
  buttonsLayout->addWidget(buttonCancel);
  buttonsLayout->addWidget(buttonAccept);
  vLayout->addLayout(buttonsLayout);

  iValue = 0;
  dValue = 0.0;

  connect(lineEdit, SIGNAL(returnPressed()), this, SLOT(acceptIt()));
  connect(buttonAccept, SIGNAL(clicked()), this, SLOT(acceptIt()));
  connect(buttonCancel, SIGNAL(clicked()), this, SLOT(reject()));
}

void InputDialog::paint(QPainter *)
{}

void InputDialog::paintEvent(QPaintEvent *e)
{
  QPainter painter;
  painter.begin(this);
  painter.setClipRect(e->rect());
  painter.setRenderHint(QPainter::Antialiasing);


//   QPixmap pix("/home/mich/rect.png");
//   setMask(pix.mask());

  paint(&painter);
  int level = 180;
  painter.setPen(QPen(QColor(level, level, level), 6));
  painter.setBrush(Qt::NoBrush);
  painter.drawRect(rect());
}

void InputDialog::acceptIt()
{
  if (lineEdit->hasAcceptableInput()) {
  dValue = lineEdit->text().toDouble();
  iValue = lineEdit->text().toInt();

  QDialog::accept();
  }
}


#include "inputdialog.moc"

