/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Linux Desktop Testing Project http://ldtp.freedesktop.org
 *
 * Author:
 *    Anupa Kamath  <anupakamath@gmail.com>
 *
 * Copyright 2009 - VMware Inc.,
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110, USA.
 */

#include "ldtp.h"
#include "ldtp-gui.h"
#include "ldtp-error.h"
#include "ldtp-logger.h"
#include "ldtp-command.h"
#include "ldtp-gui-comp.h"

static gboolean
is_object_progress_bar (Accessible *object, FILE *log_fp)
{
	if (wait_till_object_state_contains (object, PROGRESS_BAR, log_fp) != 0) {
		LDTPErrorCode error;
		error = LDTP_ERROR_INVALID_OBJECT_STATE;
		log_msg (LDTP_LOG_CAUSE, ldtp_error_get_message (error), log_fp);
		return FALSE;
	}
	return TRUE;
}

static gboolean
is_progress_bar_state_visible (Accessible *object)
{
	AccessibleStateSet *state;
	state = Accessible_getStateSet (object);

	/*
	  Check if the progress bar is visible or not 
	*/

	if (AccessibleStateSet_contains (state, SPI_STATE_VISIBLE))
		return TRUE; //Visible State
	else
		return FALSE;  //Invisible State
}

LDTPErrorCode
progress_bar_main (LDTPClientContext* cctxt, int command)
{
	LDTPErrorCode error;
	switch (command) {
	case LDTP_CMD_VERIFYPROGRESSBAR:
		if (is_object_progress_bar (cctxt->gui_handle->handle, cctxt->log_fp))
			error = LDTP_ERROR_SUCCESS;
		else
			error = LDTP_ERROR_INVALID_OBJECT_STATE;
		break;
	case LDTP_CMD_VERIFYPROGRESSBARVISIBLE:
		if (is_progress_bar_state_visible (cctxt->gui_handle->handle))
			error = LDTP_ERROR_SUCCESS;
		else
			error = LDTP_ERROR_PROGRESSBAR_NOT_VISIBLE;
		break;
	default:
		error = LDTP_ERROR_COMMAND_NOT_IMPLEMENTED;
	}
	return error;
}
