#############################################################################
#
#  Linux Desktop Testing Project http://ldtp.freedesktop.org
# 
#  Author:
#      Nagappan Alagappan (nagappan@gmail.com)   
# 
#  Copyright 2004 - 2007 Novell, Inc.
# 
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
# 
#  You should have received a copy of the GNU Lesser General Public
#  License along with this program; if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA 02110, USA.
#
#############################################################################

import os
import re
import sys
import time
import types
import select
import struct
import socket
import random
import thread
import signal
import threading
import traceback
from xml.dom.minidom import *
from xml.parsers.expat import ExpatError
from xml.sax import saxutils

#Wildcard Specific Globals
appList = []
APPHOME = "%s/.ldtp" % os.environ['HOME']
APPROOT = "/usr/share/ldtp"

#ooldtp support Global
contextList = []

# Let us not register our application under at-spi application list
os.environ ['GTK_MODULES'] = ''

from ldtplibutils import *

_ldtpDebug = os.getenv ('LDTP_DEBUG')
_sockFdPool = sockFdPool
_socketPath = '/tmp/ldtp-record-' + os.getenv ('USER') + '-' + os.getenv ('DISPLAY')


# Default GUI timeout 30 seconds
_ldtpGuiTimeout = 30

class ConnectionLost (Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr (self.value)

# generate XML content
def generatexml (commandId, _requestId, name = None, application = None, argument = None):
    _xml = '<?xml version=\"1.0\"?>'
    _xml += '<REQUEST>'
    # Fill action name
    _xml = _xml + '<ID>' + _requestId + '</ID>'
    _xml = _xml + '<COMMAND>' + str (commandId) + '</COMMAND>'
    if application != None:
        _xml = _xml + '<APPLICATION>' + saxutils.escape (application) + '</APPLICATION>'
    if name is not None:
        _xml = _xml + '<NAME>' + saxutils.escape (name) + '</NAME>'
    _xml = _xml + '<ARGUMENTS>'
    _xml = _xml + '<ARGUMENT>ALL</ARGUMENT>'
    _xml = _xml + '</ARGUMENTS>'
    _xml += '</REQUEST>'
    return _xml

def connect2LdtpCodegen ():
    _display = os.getenv ('DISPLAY')

    if _display == None:
        raise LdtpExecutionError ('Missing DISPLAY environment variable. Running in text mode ?')    

    _sockFd = None    
    _ldtpUseTcp = False
    _ldtpServerAddr = None
    _ldtpServerPort = None
    if os.environ.has_key("LDTP_SERVER_ADDR"):
        _ldtpServerAddr = os.environ ["LDTP_SERVER_ADDR"]
        if os.environ.has_key ("LDTP_SERVER_PORT"):
            _ldtpServerPort = int (os.environ ["LDTP_SERVER_PORT"])
        else:
            _ldtpServerPort = 23457
        _ldtpUseTcp = True

    try:
        # Create a client socket
        _sockFd = None
        if _ldtpUseTcp:
            _sockFd = socket.socket (socket.AF_INET, socket.SOCK_STREAM)
        else:
            _sockFd = socket.socket (socket.AF_UNIX, socket.SOCK_STREAM)
    except socket.error,msg:
        if _ldtpUseTcp:
            raise LdtpExecutionError ('Error while creating socket  ' + str (msg))
        else:
            raise LdtpExecutionError ('Error while creating UNIX socket  ' + str (msg))    
    
    # Let us retry connecting to the server for 3 times
    _retryCount = 0

    while True:
        try:
            try:
                # Connect to server socket
                if _ldtpUseTcp:
                    _sockFd.connect((_ldtpServerAddr, _ldtpServerPort))
                else:
                    _sockFd.connect (_socketPath)
                return _sockFd, _ldtpUseTcp
            except TypeError:
                raise ConnectionLost ('Environment LDTP_AUTH_SOCK variable not set')
        except socket.error, msg:
            if _retryCount == 3:
                raise ConnectionLost ('Could not establish connection ' + str (msg))
            _retryCount += 1
            #If we are not trying to connect to a remote server then we can attempt to
            #startup the ldtp server and then try to re-connect to it.
            if not _ldtpUseTcp:
                _pid = os.fork ()
                if _pid == 0:
                    try:
                        os.execvpe ('ldtpcodegen', [''], os.environ)
                    except OSError:
                        raise LdtpExecutionError ('ldtp executable not in PATH')
                else:
                    # Let us wait for 1 second, let the server starts
                    time.sleep (1)

def getText (nodelist):
    rc = ""
    for node in nodelist:
        if node.nodeType == node.TEXT_NODE:
            rc = rc + node.data
    return rc

def getCData (nodelist):
    rc = ""
    for node in nodelist:
        if node.nodeType == node.CDATA_SECTION_NODE:
            rc = rc + node.data
    return rc

def parsexml (xmldata):
    """Returns the value obtained from the server's return LDTP packet"""
    _statusMsg      = None
    _statusCode     = None
    _responseType   = None
    _requestId      = None
    _responseObj    = None
    _data           = None

    try:
        dom = parseString (xmldata)
        try:
            _responseObj   = dom.getElementsByTagName ('RESPONSE')[0]
            _responseType = 'response'
        except IndexError:
            try:
                _responseObj   = dom.getElementsByTagName ('NOTIFICATION')[0]
                #_responseType = 'notification'
                return 'notification', None, None
            except IndexError:
                try:
                    _responseObj   = dom.getElementsByTagName ('KEYBOARD')[0]
                    #_responseType = 'keyboard'
                    return 'keyboard', None, None
                except IndexError:
                    return None
        try:
            _responseStatusObj = _responseObj.getElementsByTagName ('STATUS')[0]
            _statusCode = int (getText (_responseStatusObj.getElementsByTagName ('CODE')[0].childNodes))
        except ValueError:
            return None
        except IndexError:
            return None
        try:
            _statusMsg  = getText (_responseStatusObj.getElementsByTagName ('MESSAGE')[0].childNodes)
        except ValueError:
            pass
        except IndexError:
            pass
        try:
            _requestId  = getText (_responseObj.getElementsByTagName ('ID')[0].childNodes)
        except IndexError:
            # On notification _requestId will be empty
            pass
        try:
            _data = getText (_responseObj.getElementsByTagName ('DATA')[0].childNodes).encode ('utf-8')
        except ValueError:
            pass
        except IndexError:
            # Data tag may not be present
            pass
    except ExpatError, msg:
        if xml.parsers.expat.ErrorString (msg.code) == xml.parsers.expat.errors.XML_ERROR_NO_ELEMENTS:
            return None
        raise LdtpExecutionError ('Parsing XML error: ' + str (msg))
    return _responseType, (_statusCode, _statusMsg, _requestId), _data

def parsenotificationxml (xmldata):
    """Returns the value obtained from the server's return LDTP packet"""
    _windowName = None
    _objectName = None
    _objectType = None
    _eventType  = None
    _key        = None
    _data       = None
    _detail1    = None
    _detail2    = None
    _timeElapsed     = None
    _notificationObj = None

    try:
        dom = parseString (xmldata)
        try:
            _notificationObj   = dom.getElementsByTagName ('NOTIFICATION')[0]
        except IndexError:
            return None
        try:
            _windowName = getText (_notificationObj.getElementsByTagName ('WINDOWNAME')[0].childNodes)
            _objectName = getText (_notificationObj.getElementsByTagName ('OBJECTNAME')[0].childNodes)
            _objectType = getText (_notificationObj.getElementsByTagName ('OBJECTTYPE')[0].childNodes)
            _eventType  = getText (_notificationObj.getElementsByTagName ('EVENTTYPE')[0].childNodes)
            _timeElapsed  = getText (_notificationObj.getElementsByTagName ('TIMEELAPSED')[0].childNodes)
        except ValueError:
            return None
        except IndexError:
            return None
        try:
            _key  = getText (_notificationObj.getElementsByTagName ('KEY')[0].childNodes)
        except ValueError:
            pass
        except IndexError:
            pass
        try:
            _data  = getText (_notificationObj.getElementsByTagName ('DATA')[0].childNodes)
        except ValueError:
            pass
        except IndexError:
            pass
        try:
            _detail1  = getText (_notificationObj.getElementsByTagName ('DETAIL1')[0].childNodes)
        except ValueError:
            pass
        except IndexError:
            pass
        try:
            _detail2  = getText (_notificationObj.getElementsByTagName ('DETAIL2')[0].childNodes)
        except ValueError:
            pass
        except IndexError:
            pass
    except ExpatError, msg:
        if xml.parsers.expat.ErrorString (msg.code) == xml.parsers.expat.errors.XML_ERROR_NO_ELEMENTS:
            return None
        raise LdtpExecutionError ('Parsing XML error: ' + str (msg))
    return _windowName, _objectName, _objectType, _eventType, _timeElapsed, _key, _data, _detail1, _detail2

def parsekeyboardxml (xmldata):
    """Returns the value obtained from the server's return LDTP packet"""
    _keyboardData = None
    _timeElapsed  = None
    _keyboardObj  = None

    try:
        dom = parseString (xmldata)
        try:
            _keyboardObj   = dom.getElementsByTagName ('KEYBOARD')[0]
        except IndexError:
            return None
        try:
            _keyboardData = getText (_keyboardObj.getElementsByTagName ('DATA')[0].childNodes)
        except ValueError:
            return None
        except IndexError:
            return None
    except ExpatError, msg:
        if xml.parsers.expat.ErrorString (msg.code) == xml.parsers.expat.errors.XML_ERROR_NO_ELEMENTS:
            return None
        raise LdtpExecutionError ('Parsing XML error: ' + str (msg))
    return _keyboardData

class packetInfo:
    def __init__ (self, packetType, windowName, objectName, objectType, eventType,
              timeElapsed, key = None, data = None, detail1 = None,
              detail2 = None):
        self.packetType = packetType
        self.windowName = windowName
        self.objectName = objectName
        self.objectType = objectType
        self.eventType = eventType
        self.timeElapsed = timeElapsed
        self.key = key
        self.data = data
        self.detail1 = detail1
        self.detail2 = detail2

class packet:
    def __init__ (self):
        self._packet = {}
        self._endPacketId = 0
        self._startPacketId = 0
        self._pushPacketEvent = threading.Event ()
        self._popPacketEvent = threading.Event ()
        self._pushPacketEvent.set ()
        self._popPacketEvent.set ()
    def pushPacket (self, packetType, windowName = None, objectName = None, objectType = None,
            eventType = None, timeElapsed = None, key = None, data = None,
            detail1 = None, detail2 = None):
        if self._pushPacketEvent.isSet ():
            self._pushPacketEvent.wait ()
            self._pushPacketEvent.clear ()
            _pcktInfo = packetInfo (packetType, windowName, objectName, objectType, eventType,
                        timeElapsed, key, data, detail1, detail2)
            self._packet [self._endPacketId] = _pcktInfo
            self._endPacketId += 1
            self._pushPacketEvent.set ()
    def fetchPacket (self):
        if self._popPacketEvent.isSet ():
            self._popPacketEvent.wait ()
            self._popPacketEvent.clear ()
            _pcktInfo = None
            if self._startPacketId in self._packet:
                _pcktInfo = self._packet.pop (self._startPacketId)
            else:
                self._popPacketEvent.set ()
                return None
            self._startPacketId += 1
            self._popPacketEvent.set ()
            return _pcktInfo
    def peekPacket (self, pcktId = None):
        _pcktInfo = None
        if pcktId is not None:
            if pcktId in self._packet:
                _pcktInfo = self._packet [pcktId]
        else:
            if self._startPacketId in self._packet:
                _pcktInfo = self._packet [self._startPacketId]
        return _pcktInfo

def getresponse (packetId = None, sockfd = None, timeOut = True):
    global _ldtpGuiTimeout
    count = 0
    # Let us initialize with empty string, as we are going to check for None later
    # returned by recvpacket later
    _responsePacket = ''
    while count < _ldtpGuiTimeout:
        try:
            _responsePacket = recvpacket (sockfd = sockfd)
            break
        except LdtpExecutionError, msg:
            if msg.value == 'Timeout':
                if timeOut is False:
                    # don't timeout, so don't increase the count !
                    continue
                # If timeout, let us retry for _ldtpGuiTimeout times
                count += 1
                continue
            raise
    if _responsePacket == None:
        return None, None
    try:
        _responseType, _responseStatus, _responseData = parsexml (_responsePacket)
        if _responseType == 'response':
            # If response type is response, then let us enforce checking packetId
            if _responseStatus [2] == packetId:
                return _responseStatus, _responseData
            else:
                if _ldtpDebug:
                    print 'Invalid response packet', _responseStatus [2], packetId
                return (-1, "Invalid response packet", packetId), (0, None)
        else:
            # If notification, then return directly, don't check
            _windowName, _objectName, _objectType, _eventType, \
                _timeElapsed, _key, _data, _detail1, \
                _detail2 = parsenotificationxml (_responsePacket)
            pckt.pushPacket (_responseType, _windowName, _objectName,
                             _objectType, _eventType, _timeElapsed, _key,
                             _data, _detail1, _detail2)
            if _ldtpDebug:
                print 'notification', _responseType, _responseStatus
        return _responseType, _responseStatus
    except TypeError, msg:
        if _ldtpDebug:
            if hasattr (traceback, 'format_exc'):
                print traceback.format_exc ()
            else:
                print traceback.print_exc ()
        if _ldtpDebug != None and _ldtpDebug == '2':
            print 'TypeError', msg
        return -1, "Invalid response packet"
    except:
        if _ldtpDebug:
            if hasattr (traceback, 'format_exc'):
                print traceback.format_exc ()
            else:
                print traceback.print_exc ()
        return None, None

def doesWindowExist (windowName):
    try:
        # global _pollThread
        _clientFd, _ldtpUseTcp = connect2LdtpCodegen ()
        _requestId  = str (random.randint (0, sys.maxint))
        _message = generatexml (RecordCommand.WINDOWEXIST, _requestId, windowName)
        sendpacket (_message, _clientFd, recorder = True)
        _responseStatus, _responseData = getresponse (_requestId, _clientFd)
        if _responseStatus [0] == 0:
            return True
        else:
            return False
    except:
        return False

def getObjectName (objName):
    try:
        # global _pollThread
        _clientFd, _ldtpUseTcp = connect2LdtpCodegen ()
        _requestId  = str (random.randint (0, sys.maxint))
        _message = generatexml (RecordCommand.GETOBJECTNAME, _requestId, objName)
        sendpacket (_message, _clientFd, recorder = True)
        _responseStatus, _responseData = getresponse (_requestId, _clientFd)
        if _responseStatus [0] == 0:
            return _responseData
        else:
            return None
    except:
        if hasattr (traceback, 'format_exc'):
            print traceback.format_exc ()
        else:
            print traceback.print_exc ()
        return None

def addWait (callbackFunc, timeElapsed):
    global generatedCode
    if _ldtpDebug:
        print 'Time elapsed',  int (timeElapsed)
    try:
        if int (timeElapsed) > 0:
            codeToBeAdded = 'wait (' + timeElapsed + ')\n'
            generatedCode += codeToBeAdded
            callbackFunc (codeToBeAdded)
    except ValueError:
        pass

#Wildcard specific function... Get applist
def getapps ():
    appList = []
    path = "%s/appdata" % APPHOME
    if os.path.exists (path):
	appListPath = path
    else:
        if _ldtpDebug:
            print "Home copy not available"
	path = "%s/appdata" % APPROOT
	if os.path.exists (path):
            appListPath = path
        else:
            if _ldtpDebug:
                print "Even root copy not available"
	    return appList
    f = open (appListPath)
    for item in f:
        appList.append (item.strip ())
    f.close ()
    return appList

#Wildcard specific function... Replace with wildcards
def wildcard (str):
    global appList
    if len (appList) == 0:
        appList = getapps ()
    for item in appList:
        regex= '\"\S*?%s\S*?\"' % item
        item = '\"*%s*\"' % item
        str = re.compile (regex).sub (item, str, 1)
    return str

#Wildcard specific function... Save applist
def saveAppList (newAppList):
    global appList
    appList = newAppList
    path = "%s/appdata" % APPHOME
    if os.path.exists (APPHOME) == False:
        os.mkdir (APPHOME, 0755)
    f = open (path, 'w')
    for item in appList:
        item = "%s\n" % item
        f.write (item)
    f.close ()

#oldtp support specific function... initContext
def initContext():
    global contextList
    contextList = []

#ooldtp support specific function... objectOrient
def objectOrient (line):
    global contextList
    re1 = re.compile ('\".*?\"')
    shrink = re1.findall (line)[0]
    re3 = re.compile ('\W|^\d*')
    context = re3.sub ('', shrink)
    re2 = re.compile ('\".*?\"\,\s')
    if re2.search (line) != None:
        parts = re2.split (line, 1)
    else:
        parts = re1.split (line, 1)
    for all in contextList:
        if all == context:
            line = '%s.%s%s' % (context, parts[0], parts[1])
            return line
    contextList.append (context)
    #last = len(context) - 1
    line = '%s = context(%s)\n\t' % (context, shrink)
    line = '%s%s.%s%s' % (line, context, parts[0], parts[1])
    return line

# Class Prefs to manage user preferences
class Prefs:
    def __init__ (self):
        self.prefList = []
        self.prefDic = {}
        self.APPHOME = APPHOME
        self.APPROOT = APPROOT
        self.hash = re.compile ('^#')
        self.equalTo = re.compile ('\s*\=\s*')
        self.nonWhiteSpace = re.compile ('\S')
    
    def loadPrefs (self):
        path = "%s/editor.conf" % self.APPHOME
        if os.path.exists (path):
	    prefListPath = path
        else:
            if _ldtpDebug:
                print "Home copy not available"
	    path = "%s/editor.conf" % self.APPROOT
	    if os.path.exists (path):
                prefListPath = path
            else:
                if _ldtpDebug:
                    print "Even root copy not available"
	        return
        f = open (prefListPath)
        for item in f:
            self.prefList.append (item.strip ())
        f.close ()
        self.makePrefDic ()
        return self.prefDic

    def makePrefDic (self):
        for item in self.prefList:
            if self.hash.match (item) == None and self.nonWhiteSpace.search (item) != None:
                valList = self.equalTo.split (item)
                if  valList [1] == 'True':
                    self.prefDic [valList [0]] = True
                else:
                    self.prefDic [valList [0]] = False

    def savePrefDic (self, dic):
        self.prefDic = dic
        for i in range (len (self.prefList)):
            if self.hash.match (self.prefList[i]) == None and self.nonWhiteSpace.search (self.prefList[i]) != None:
                valList = self.equalTo.split (self.prefList[i])
                for param, value in self.prefDic.iteritems ():
                    if param == valList[0]:
                        if value == True:
                            self.prefList[i] = "%s = True" % param
                        else:
                            self.prefList[i] = "%s = False" % param
                        break
        self.savePrefs()

    def savePrefs (self):
        path = "%s/editor.conf" % self.APPHOME
        if os.path.exists (self.APPHOME) == False:
            os.mkdir (self.APPHOME, 0755)
        f = open (path, 'w')
        for item in self.prefList:
            item = "%s\n" % item
            f.write (item)
        f.close ()

def callback (guiCallbackFunc, data, timeElapsed = None):
    global generatedCode
    if timeElapsed is not None:
        addWait (guiCallbackFunc, timeElapsed)
    if data is None:
        return
    newlineIndex = data.find ('\n')
    if newlineIndex > 0 and data [newlineIndex - 1] != ')':
        tmpLines = data.split ("\n")
        data = ""
        # Chances that one more more line can be part of single command
        # So let us use the above logic for searching \n without )
        for tmpLine in tmpLines:
            tmpData = ""
            if tmpLine != "" and tmpLine [-1:] != ')':
                tmpData = "\\n"
            data = "%s%s%s" % (data, tmpLine, tmpData)
        data += "\n"
    #get Windownames replaced by wildcards here
    data = wildcard (data)
    generatedCode += data
    guiCallbackFunc (data)

def processData (pckt, callbackFunc):
    try:
        processDataDebug (pckt, callbackFunc)
    except:
        if hasattr (traceback, 'format_exc'):
            print traceback.format_exc ()
        else:
            print traceback.print_exc ()

def processDataDebug (pckt, callbackFunc):
    global generatedCode
    # Its a hack, please remove it, once debugging is done
    while True:
        try:
            _pcktInfo = pckt.peekPacket ()
            if _pcktInfo:
                if pckt._startPacketId == pckt._endPacketId:
                    # If both are same, let us wait till we receive the next packet
                    pckt._pushPacketEvent.wait ()
                if _ldtpDebug and _ldtpDebug == '2':
                    print 'libldtpcodegen', _pcktInfo.windowName, _pcktInfo.objectName,
                    print _pcktInfo.objectType, _pcktInfo.eventType,
                    print _pcktInfo.key, _pcktInfo.data
                if _pcktInfo.packetType == 'keyboard':
                    # FIXME: Manipulate the keyboard strings with the text box
                    _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                    callback (callbackFunc, 'enterstring (\"'+ _data + '\")\n', None)
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                if _pcktInfo.objectType == 'push button':
                    if _ldtpDebug:
                        print pckt._startPacketId, pckt._endPacketId
                    if _pcktInfo.eventType.startswith ('object:state-changed:armed') and \
                           pckt._startPacketId != pckt._endPacketId:
                        _tmpPckt = pckt.peekPacket (pckt._startPacketId + 1)
                        if _ldtpDebug and _ldtpDebug == 2 and _tmpPckt != None:
                            print '*** tmpPckt', _tmpPckt
                        if _tmpPckt == None or (_tmpPckt.objectType == _pcktInfo.objectType and \
                                        _tmpPckt.windowName == _pcktInfo.windowName and \
                                        _tmpPckt.objectName == _pcktInfo.objectName and \
                                        _tmpPckt.eventType.startswith ('focus:')):
                            _data = re.sub ("\"", "\\\"", _pcktInfo.objectName)
                            callback (callbackFunc, 'click (\"'+ _pcktInfo.windowName + \
                                      '\", \"' + _data + '\")\n', _pcktInfo.timeElapsed)
                            _pcktInfo = pckt.fetchPacket ()
                            _pcktInfo = pckt.fetchPacket () # Note we are fetching two times
                            continue
                    elif _pcktInfo.eventType.startswith ('focus:') and doesWindowExist (_pcktInfo.windowName):
                        if _ldtpDebug:
                            print '*** Window exist'
                        _pcktInfo = pckt.fetchPacket ()
                        continue
                    elif _pcktInfo.eventType.startswith ('focus:') and \
                           pckt._startPacketId != pckt._endPacketId:
                        _tmpPckt = pckt.peekPacket (pckt._startPacketId + 1)
                        if _ldtpDebug and _ldtpDebug == 2:
                            print '*** tmpPckt', _tmpPckt
                        if _tmpPckt == None or (_tmpPckt.objectType == _pcktInfo.objectType and \
                                    _tmpPckt.windowName == _pcktInfo.windowName and \
                                    _tmpPckt.objectName == _pcktInfo.objectName and \
                                    _tmpPckt.eventType.startswith ('object:state-changed:armed')):
                            _data = re.sub ("\"", "\\\"", _pcktInfo.objectName)
                            callback (callbackFunc, 'click (\"'+ _pcktInfo.windowName + \
                                      '\", \"' + _data + '\")\n',
                                  _pcktInfo.timeElapsed)
                            _pcktInfo = pckt.fetchPacket ()
                            _pcktInfo = pckt.fetchPacket () # Note we are fetching two times
                            continue
                    _data = re.sub ("\"", "\\\"", _pcktInfo.objectName)
                    callback (callbackFunc, 'click (\"'+ _pcktInfo.windowName + \
                              '\", \"' + _data + '\")\n', _pcktInfo.timeElapsed)
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.eventType.startswith ('object:state-changed:checked'):
                    if _pcktInfo.objectType == 'check box':
                        _data = re.sub ("\"", "\\\"", _pcktInfo.objectName)
                        if _pcktInfo.detail1 == '1':
                            callback (callbackFunc, 'check (\"'+ _pcktInfo.windowName + \
                                      '\", \"' + _data + '\")\n',
                                  _pcktInfo.timeElapsed)
                        else:
                            callback (callbackFunc, 'uncheck (\"'+ _pcktInfo.windowName + \
                                      '\", \"' + _data + '\")\n',
                                  _pcktInfo.timeElapsed)
                        _pcktInfo = pckt.fetchPacket ()
                        continue
                    elif _pcktInfo.objectType == 'radio button' or \
                         _pcktInfo.objectType == 'toggle button':
                        _data = re.sub ("\"", "\\\"", _pcktInfo.objectName)
                        callback (callbackFunc, 'click (\"'+ _pcktInfo.windowName + \
                                  '\", \"' + _data + '\")\n',
                              _pcktInfo.timeElapsed)
                        _pcktInfo = pckt.fetchPacket ()
                        continue
                    else:
                        _pcktInfo = pckt.fetchPacket ()
                        if _ldtpDebug:
                            print 'Invalid packet with object:state-changed:checked event type ??'
                        continue
                elif _pcktInfo.eventType.startswith ('object:state-changed:selected'):
                    if _pcktInfo.objectType == 'page tab':
                        _responseData = getObjectName (_pcktInfo.objectName)
                        if _responseData is not None:
                            _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                            callback (callbackFunc, 'selecttab (\"'+ _pcktInfo.windowName + \
                                      '\", \"' + _responseData + '\", \"' + \
                                      _data + '\")\n',
                                  _pcktInfo.timeElapsed)
                        _pcktInfo = pckt.fetchPacket ()
                        continue
                    elif _pcktInfo.objectType == 'table cell':
                        _responseData = getObjectName (_pcktInfo.objectName)
                        if _responseData is not None:
                            # Escape " as \" in data argument
                            _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                            callback (callbackFunc, 'selectrow (\"'+ _pcktInfo.windowName + \
                                      '\", \"' + _responseData + '\", \"' + \
                                      _data + '\")\n',
                                  _pcktInfo.timeElapsed)
                        _pcktInfo = pckt.fetchPacket ()
                        continue
                    else:
                        _pcktInfo = pckt.fetchPacket ()
                        if _ldtpDebug:
                            print 'Invalid packet with object:state-changed:selected event type ??'
                        continue
                elif _pcktInfo.eventType.startswith ('focus:') and \
                     _pcktInfo.objectType == 'table cell':
                    _tmpPckt = None
                    if pckt._startPacketId != pckt._endPacketId:
                        _tmpPckt = pckt.peekPacket (pckt._startPacketId + 1)
                        if _tmpPckt is not None and str (_tmpPckt.eventType).startswith ('focus:') == False and \
                               _tmpPckt.objectType != _pcktInfo.objectType:
                            _tmpPckt = None
                    if _tmpPckt == None or (_tmpPckt.objectType == _pcktInfo.objectType and \
                                _tmpPckt.windowName == _pcktInfo.windowName and \
                                _tmpPckt.objectName == _pcktInfo.objectName and \
                                _tmpPckt.eventType.startswith ('focus:')):
                        _responseData = getObjectName (_pcktInfo.objectName)
                        if _responseData is not None:
                            _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                            callback (callbackFunc, 'selectrow (\"'+ _pcktInfo.windowName + \
                                      '\", \"' + _responseData + '\", \"' + \
                                      _data + '\")\n', _pcktInfo.timeElapsed)
                        _pcktInfo = pckt.fetchPacket ()
                        if _tmpPckt is not None:
                            _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.eventType.startswith ('window:create'):
                    callback (callbackFunc, 'waittillguiexist (\"' + _pcktInfo.windowName + '\")\n')
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.eventType.startswith ('window:destroy'):
                    callback (callbackFunc, 'waittillguinotexist (\"' + _pcktInfo.windowName + '\")\n')
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.objectType == 'spin button':
                    _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                    callback (callbackFunc, 'setvalue (\"'+ _pcktInfo.windowName + \
                              '\", \"' + _pcktInfo.objectName + '\", \"' + \
                              _data + '\")\n',
                          _pcktInfo.timeElapsed)
                    _pcktInfo = pckt.fetchPacket ()
#                    if pckt._startPacketId != pckt._endPacketId:
#                        _tmpPckt = pckt.peekPacket (pckt._startPacketId + 1)
#                        if _ldtpDebug and _ldtpDebug == 2:
#                            print '*** tmpPckt', _tmpPckt
#                        if _tmpPckt == None or (_tmpPckt.objectType == _pcktInfo.objectType and \
#                                    _tmpPckt.windowName == _pcktInfo.windowName and \
#                                    _tmpPckt.objectName == _pcktInfo.objectName):
#                            addWait (generatedCode, callbackFunc, _pcktInfo.timeElapsed)
#                            generatedCode += 'setvalue (\"'+ _pcktInfo.windowName + \
#                                     '\", \"' + _pcktInfo.objectName + '\", \"' + \
#                                     _pcktInfo.data + '\")\n'
#                            callbackFunc ('setvalue (\"'+ _pcktInfo.windowName + \
#                                     '\", \"' + _pcktInfo.objectName + '\", \"' + \
#                                     _pcktInfo.data + '\")\n')
#                            if _tmpPckt is not None:
#                                _pcktInfo = pckt.fetchPacket ()
#                            _pcktInfo = pckt.fetchPacket ()
#                    else:
#                        addWait (generatedCode, callbackFunc, _pcktInfo.timeElapsed)
#                        generatedCode += 'setvalue (\"'+ _pcktInfo.windowName + \
#                                 '\", \"' + _pcktInfo.objectName + '\", \"' + \
#                                 _pcktInfo.data + '\")\n'
#                        callbackFunc ('setvalue (\"'+ _pcktInfo.windowName + \
#                                 '\", \"' + _pcktInfo.objectName + '\", \"' + \
#                                 _pcktInfo.data + '\")\n')
#                        _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.objectType == 'text':
                    _objName = _pcktInfo.objectName
                    if re.search ('|', _objName) is not None:
                        _responseData = getObjectName (_pcktInfo.objectName)
                        if _responseData is not None:
                            _objName = _responseData
                    _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                    callback (callbackFunc, 'settextvalue (\"'+ _pcktInfo.windowName + \
                              '\", \"' + _objName + '\", \"' + \
                              _data + '\")\n',
                          _pcktInfo.timeElapsed)
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.objectType == 'combo box':
                    _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                    callback (callbackFunc, 'comboselect (\"'+ _pcktInfo.windowName + \
                              '\", \"' + _pcktInfo.objectName + '\", \"' + \
                              _data + '\")\n',
                          _pcktInfo.timeElapsed)
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.objectType == 'menu item':
                    _data = re.sub ("\"", "\\\"", _pcktInfo.objectName)
                    callback (callbackFunc, 'selectmenuitem (\"'+ _pcktInfo.windowName + \
                              '\", \"' + _data + '\")\n',
                          _pcktInfo.timeElapsed)
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.objectType == 'right click':
                    _objName = _pcktInfo.objectName
                    if re.search ('|', _objName) is not None:
                        _responseData = getObjectName (_pcktInfo.objectName)
                        if _responseData is not None:
                            _objName = _responseData
                    _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                    callback (callbackFunc, 'rightclick (\"'+ _pcktInfo.windowName + \
                              '\", \"' + _objName + '\", \"' + \
                              _data + '\")\n',
                          _pcktInfo.timeElapsed)
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                elif _pcktInfo.objectType == 'panel' and \
                     _pcktInfo.eventType.startswith ('object:state-changed:focused'):
                    _objName = _pcktInfo.objectName
                    if re.search ('|', _objName) is not None:
                        _responseData = getObjectName (_pcktInfo.objectName)
                        if _responseData is not None:
                            _objName = _responseData
                    _data = re.sub ("\"", "\\\"", _pcktInfo.data)
                    callback (callbackFunc, 'selectpanelname (\"'+ _pcktInfo.windowName + \
                              '\", \"' + _objName + '\", \"' + \
                              _data + '\")\n',
                          _pcktInfo.timeElapsed)
                    _pcktInfo = pckt.fetchPacket ()
                    continue
                else:
                    if _ldtpDebug:
                        print 'Unknown object type', _pcktInfo.objectType
                    _pcktInfo = pckt.fetchPacket ()
                    continue
            else:
                time.sleep (1)
        except KeyboardInterrupt:
            break
        except:
            if hasattr (traceback, 'format_exc'):
                print traceback.format_exc ()
            else:
                print traceback.print_exc ()
            pckt.fetchPacket ()
            raise

def stoprecord (filename = None):
    try:
        # global _pollThread
        _clientFd, _ldtpUseTcp = connect2LdtpCodegen ()
        _requestId  = str (random.randint (0, sys.maxint))
        _message = generatexml (RecordCommand.STOP, _requestId)
        sendpacket (_message, _clientFd, recorder = True)
        _responseStatus, _responseData = getresponse (_requestId, _clientFd)
    except:
        pass

def shutdown ():
    if calledFromGui == True:
        return
    if threading.activeCount () > 1:
        thread.exit ()
    sys.exit ()

def __shutdownAndExit (signum, frame):
    global generatedCode,  _mainSock
    if _mainSock:
        _mainSock.close ()
        _mainSock = None
        stoprecord ()
    shutdown ()
    if _ldtpDebug:
        print ''
        print ''
        print ''
        print generatedCode.encode ('utf8')
        print ''
        print ''
        print ''

def stop ():
    __shutdownAndExit (0, 0)

# Create read flag
_readFlag = threading.Event ()
# Clear the flag by default
_readFlag.clear ()

# Create notification flag
_notificationFlag = threading.Event ()
# Set the flag by default
_notificationFlag.set ()

# Create keyboard flag
_keyboardFlag = threading.Event ()
# Set the flag by default
_keyboardFlag.set ()

# Contains poll fd's
# _serverPoll = None

# Send lock
_sendLck = threading.Lock ()
# Recieve lock
_recvLck = threading.Lock ()

_mainSock = None
# _pollThread = None
calledFromGui = False
generatedCode = ''
pckt = packet ()

def invokecallback (_clientFd):
    global _mainSock
    _mainSock = _clientFd
    try:
        _requestId  = str (random.randint (0, sys.maxint))
        _message = generatexml (RecordCommand.NOTIFICATION, _requestId)
        sendpacket (_message, _clientFd, recorder = True)
    except KeyboardInterrupt:
        if _ldtpDebug:
            print 'Keyboard interrupt'
        return
    except socket.error:
        if _ldtpDebug:
            print 'Socket error'
        return
    except:
        if _ldtpDebug:
            if hasattr (traceback, 'format_exc'):
                print traceback.format_exc ()
            else:
                print traceback.print_exc ()

    while True:
        try:
            _responseStatus, _responseData = getresponse (sockfd = _clientFd,
                                                          timeOut = False)
            if _responseStatus == None:
                if _mainSock:
                    _mainSock.close ()
                    _mainSock = None
                # Server closed connection
                if _ldtpDebug:
                    print 'Server closed connection'
                break
        except KeyboardInterrupt:
            if _ldtpDebug:
                print 'Keyboard interrupt'
            break
        except LdtpExecutionError, error:
            if _ldtpDebug:
                print 'Ldtp execution error %s' % str (error)
            break
        except socket.error:
            if _ldtpDebug:
                print 'Socket error'
            break
        except:
            if _ldtpDebug:
                if hasattr (traceback, 'format_exc'):
                    print traceback.format_exc ()
                else:
                    print traceback.print_exc ()
            break

#All default parameters, and checking whether action is stoprecord, are to be removed
def start (callbackFunc, appName = 'ALL', args = None):
    if callbackFunc == None or callable (callbackFunc) == False:
        raise LdtpExecutionError ('Callback function is not callable')
    global generatedCode
    generatedCode = 'from ldtp import *\n\n'
    _clientFd, _ldtpUseTcp = connect2LdtpCodegen ()

    _sockFdPool = sockFdPool
    _sockFdPool [threading.currentThread ()] = _clientFd

    thread.start_new_thread (invokecallback, (_clientFd, ))
    thread.start_new_thread (processData, (pckt, callbackFunc))
