/*
 * $Id: kl_mem_s390x.h,v 1.1 2004/12/21 23:26:22 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __KL_MEM_S390X_H
#define __KL_MEM_S390X_H

#define KL_KSTACK_SIZE_S390X        0x4000ULL
#define KL_PAGE_OFFSET_S390X        0x0

#define KL_PAGE_SHIFT_S390X         12
#define KL_PAGE_SIZE_S390X          (1ULL << KL_PAGE_SHIFT_S390X)
#define KL_PAGE_MASK_S390X          (~(KL_PAGE_SIZE_S390X-1))

#define KL_PGDIR_SHIFT_S390X        31
#define KL_PGDIR_SIZE_S390X         (1ULL << KL_PGDIR_SHIFT_S390X)
#define KL_PGDIR_MASK_S390X         (~(KL_PGDIR_SIZE_S390X-1))

#define KL_PMD_SHIFT_S390X          20
#define KL_PMD_SIZE_S390X           (1ULL << KL_PMD_SHIFT_S390X)
#define KL_PMD_MASK_S390X           (~(KL_PMD_SIZE_S390X-1))

#define KL_PTRS_PER_PGD_S390X       2048
#define KL_PTRS_PER_PMD_S390X       2048
#define KL_PTRS_PER_PTE_S390X       256

#define KL_PMD_BASE_MASK_S390X      (~((1ULL<<12)-1))
#define KL_PT_BASE_MASK_S390X       (~((1ULL<<11)-1))
#define KL_PAGE_BASE_MASK_S390X     (~((1ULL<<12)-1))


/* Flags used in entries of page dirs and page tables. 
 */
#define KL_PAGE_PRESENT_S390X   0x001ULL /* set: loaded in physical memory
				      * clear: not loaded in physical mem */
#define KL_PAGE_RO_S390X       0x200ULL /* HW read-only */
#define KL_PAGE_INVALID_S390X  0x400ULL /* HW invalid */
#define KL_PAGE_INVALID_MASK_S390X 0x601ULL /* for linux 2.6 */
#define KL_PAGE_INVALID_NONE_S390X 0x401ULL /* for linux 2.6 */
#define KL_PMD_ENTRY_INV_S390X 0x20ULL  /* invalid segment table entry      */
#define KL_PGD_ENTRY_INV_S390X 0x20ULL  /* invalid region table entry       */
#define KL_PMD_ENTRY_S390X     0x00        
#define KL_PGD_ENTRY_FIRST_S390X  0x05  /* first part of pmd is valid */
#define KL_PGD_ENTRY_SECOND_S390X 0xc7  /* second part of pmd is valid */
#define KL_PGD_ENTRY_FULL_S390X   0x07  /* complete pmd is valid */

/* bits 52, 55 must contain zeroes in a pte */
#define KL_PTE_INVALID_MASK_S390X  0x900ULL
#define KL_PTE_INVALID_S390X(x) ((x) & KL_PTE_INVALID_MASK_S390X)

/* pgd/pmd/pte query functions */ 
#define kl_pgd_none_s390x(x) ((x) & KL_PGD_ENTRY_INV_S390X)
#define kl_pgd_bad_s390x(x) !( (((x) & KL_PGD_ENTRY_FIRST_S390X) == \
                             KL_PGD_ENTRY_FIRST_S390X) || \
                             (((x) & KL_PGD_ENTRY_SECOND_S390X) == \
                             KL_PGD_ENTRY_SECOND_S390X) || \
                              (((x) & KL_PGD_ENTRY_FULL_S390X) == \
                             KL_PGD_ENTRY_FULL_S390X))

#define kl_pmd_none_s390x(x) ((x) & KL_PMD_ENTRY_INV_S390X)
#define kl_pmd_bad_s390x(x) (((x) & (~KL_PT_BASE_MASK_S390X & \
                                     ~KL_PMD_ENTRY_INV_S390X)) != \
                             KL_PMD_ENTRY_S390X)

#define kl_pte_none_s390x(x) (((x) & (KL_PAGE_INVALID_S390X | \
				      KL_PAGE_RO_S390X | \
				      KL_PAGE_PRESENT_S390X)) == \
                              KL_PAGE_INVALID_S390X)


/* functions needed for dump architecture specific memory mapping */
kaddr_t kl_mmap_virtop_s390x(
	kaddr_t vaddr   /* kernel virtual address */,
	void *mmp       /* pointer to struct mm_struct */);

kaddr_t kl_kernelstack_s390x(kaddr_t task);

#endif /* __KL_MEM_S390X_H */
