/*
 * $Id: kl_klconfig.h,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libhwconfig.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003-2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef __KL_KLCONFIG_H
#define __KL_KLCONFIG_H

#define BASE_ADDR(NID) (KL_PAGE_OFFSET + ((uint64_t)(NID) << KL_NASID_SHIFT))

/* The following KLCONFIG defines are lifted from 
 * linux/include/asm-ia64/sn/klconfig.h
 * See this header files for background, comments, details, etc.
 */
#define KLCLASS_MASK    	0xf0
#define KLCLASS_NONE    	0x00
#define KLCLASS_NODE    	0x10
#define KLCLASS_CPU     	KLCLASS_NODE
#define KLCLASS_IO      	0x20
#define KLCLASS_ROUTER  	0x30
#define KLCLASS_MIDPLANE 	0x40
#define KLCLASS_GFX     	0x50
#define KLCLASS_PSEUDO_GFX      0x60
#define KLCLASS_IOBRICK 	0x70          

#define KLCLASS_MAX     8             /* Bump this if a new CLASS is added */
#define KLTYPE_MAX      11            /* Bump this if a new CLASS is added */

#define KLCLASS_UNKNOWN 0xf0

#define KLCLASS(_x) ((_x) & KLCLASS_MASK)

#define KLTYPE_MASK     0x0f
#define KLTYPE_NONE     0x00
#define KLTYPE_EMPTY    0x00

#define KLTYPE_WEIRDCPU 	(KLCLASS_CPU | 0x0)
#define KLTYPE_SNIA     	(KLCLASS_CPU | 0x1)

#define KLTYPE_WEIRDIO  	(KLCLASS_IOBRICK  | 0x0)
#define KLTYPE_BASEIO   	(KLCLASS_IO  | 0x1) 
#define KLTYPE_IO6      	KLTYPE_BASEIO       
#define KLTYPE_4CHSCSI  	(KLCLASS_IO  | 0x2)
#define KLTYPE_MSCSI    	KLTYPE_4CHSCSI      
#define KLTYPE_ETHERNET 	(KLCLASS_IO  | 0x3)
#define KLTYPE_MENET    	KLTYPE_ETHERNET     
#define KLTYPE_FDDI     	(KLCLASS_IO  | 0x4)
#define KLTYPE_UNUSED   	(KLCLASS_IO  | 0x5) 
#define KLTYPE_HAROLD   	(KLCLASS_IO  | 0x6) 
#define KLTYPE_PCI      	KLTYPE_HAROLD
#define KLTYPE_VME      	(KLCLASS_IO  | 0x7) 
#define KLTYPE_MIO      	(KLCLASS_IO  | 0x8)
#define KLTYPE_FC       	(KLCLASS_IO  | 0x9)
#define KLTYPE_LINC     	(KLCLASS_IO  | 0xA)
#define KLTYPE_TPU      	(KLCLASS_IO  | 0xB) 
#define KLTYPE_GSN_A    	(KLCLASS_IO  | 0xC) 
#define KLTYPE_GSN_B    	(KLCLASS_IO  | 0xD) 
#define KLTYPE_SHOEHORN 	(KLCLASS_IO  | 0xE)
#define KLTYPE_SERIAL_HIPPI 	(KLCLASS_IO  | 0xF)

#define KLTYPE_GFX      	(KLCLASS_GFX | 0x0)
#define KLTYPE_GFX_KONA 	(KLCLASS_GFX | 0x1)
#define KLTYPE_GFX_MGRA 	(KLCLASS_GFX | 0x3)

#define KLTYPE_WEIRDROUTER 	(KLCLASS_ROUTER | 0x0)
#define KLTYPE_ROUTER     	(KLCLASS_ROUTER | 0x1)
#define KLTYPE_ROUTER2    	KLTYPE_ROUTER         
#define KLTYPE_NULL_ROUTER 	(KLCLASS_ROUTER | 0x2)
#define KLTYPE_META_ROUTER 	(KLCLASS_ROUTER | 0x3)
#define KLTYPE_REPEATER_ROUTER 	(KLCLASS_ROUTER | 0x4)
#define KLTYPE_WEIRDMIDPLANE 	(KLCLASS_MIDPLANE | 0x0)
#define KLTYPE_MIDPLANE8  	(KLCLASS_MIDPLANE | 0x1) 
#define KLTYPE_MIDPLANE    	KLTYPE_MIDPLANE8
#define KLTYPE_IOBRICK_XBOW     (KLCLASS_MIDPLANE | 0x2)

#define KLTYPE_IOBRICK          (KLCLASS_IOBRICK | 0x0)
#define KLTYPE_IBRICK           (KLCLASS_IOBRICK | 0x1)
#define KLTYPE_PBRICK           (KLCLASS_IOBRICK | 0x2)
#define KLTYPE_XBRICK           (KLCLASS_IOBRICK | 0x3)
#define KLTYPE_NBRICK           (KLCLASS_IOBRICK | 0x4)
#define KLTYPE_PEBRICK          (KLCLASS_IOBRICK | 0x5)
#define KLTYPE_PXBRICK          (KLCLASS_IOBRICK | 0x6)
#define KLTYPE_IXBRICK          (KLCLASS_IOBRICK | 0x7)
#define KLTYPE_CGBRICK          (KLCLASS_IOBRICK | 0x8)

/* KLINFO defines (component types)
 */
#define KLSTRUCT_UNKNOWN        0
#define KLSTRUCT_CPU            1
#define KLSTRUCT_HUB            2
#define KLSTRUCT_MEMBNK         3
#define KLSTRUCT_XBOW           4
#define KLSTRUCT_BRI            5
#define KLSTRUCT_IOC3           6
#define KLSTRUCT_PCI            7
#define KLSTRUCT_VME            8
#define KLSTRUCT_ROU            9
#define KLSTRUCT_GFX            10
#define KLSTRUCT_SCSI           11
#define KLSTRUCT_FDDI           12
#define KLSTRUCT_MIO            13
#define KLSTRUCT_DISK           14
#define KLSTRUCT_TAPE           15
#define KLSTRUCT_CDROM          16
#define KLSTRUCT_HUB_UART       17
#define KLSTRUCT_IOC3ENET       18
#define KLSTRUCT_IOC3UART       19
#define KLSTRUCT_UNUSED         20 /* XXX UNUSED */
#define KLSTRUCT_IOC3PCKM       21
#define KLSTRUCT_RAD            22
#define KLSTRUCT_HUB_TTY        23
#define KLSTRUCT_IOC3_TTY       24

/* Early Access IO proms are compatible
   only with KLSTRUCT values upto 24. */

#define KLSTRUCT_FIBERCHANNEL   25
#define KLSTRUCT_MOD_SERIAL_NUM 26
#define KLSTRUCT_IOC3MS         27
#define KLSTRUCT_TPU            28
#define KLSTRUCT_GSN_A          29
#define KLSTRUCT_GSN_B          30
#define KLSTRUCT_XTHD           31
#define KLSTRUCT_QLFIBRE        32
#define KLSTRUCT_1394           33
#define KLSTRUCT_USB            34
#define KLSTRUCT_USBKBD         35
#define KLSTRUCT_USBMS          36
#define KLSTRUCT_SCSI_CTLR      37
#define KLSTRUCT_PEBRICK        38
#define KLSTRUCT_GIGE           39
#define KLSTRUCT_IDE            40

#define LAST_KLSTRUCT_TYPE 	40

extern char *comp_name[];

/* Function prototypes
 */
kaddr_t offset_to_addr(kaddr_t, kaddr_t);
void *get_kl_config_hdr(kaddr_t, int);
void *get_lboard_s(kaddr_t, kaddr_t, int);
void *get_klinfo(kaddr_t, int);
kaddr_t kl_klgraph_addr(void);
kaddr_t kl_klconfig_addr(int);

#endif /* __KL_KLCONFIG_H */
