/*
 * $Id: util_s390.c,v 1.1 2004/12/21 23:26:18 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

/*
 *  get_cpu_lowcore_s390
 *
 *  Return the lowcore of the given cpu
 */

void* get_cpu_lowcore_s390(int cpu)
{
	kaddr_t  lc_ptr;
	void*  lc = NULL;
	syment_t *lowcore_sym;
	int _LOWCORE_SZ;

	if(!(_LOWCORE_SZ = kl_struct_len("_lowcore"))) {
		goto out;
	}

	/* find out addresses of lowcores */

	if(!(lowcore_sym = kl_lkup_symname("lowcore_ptr"))) {
		goto out;
	}

/* 	GET_BLOCK(lowcore_sym->s_addr + cpu * KL_NBPW, KL_NBPW, &lc_ptr); */
	lc_ptr = KL_VREAD_PTR(lowcore_sym->s_addr + cpu * KL_NBPW);

	/* get lowcore of cpu */

	if(!(lc = kl_alloc_block(_LOWCORE_SZ, K_TEMP))) {
		goto out;
	}

	GET_BLOCK(lc_ptr, _LOWCORE_SZ, lc);
	if (KL_ERROR) {
		kl_free_block(lc);
		lc = NULL;
	}	
out:
	return lc;
}

/*
 *  free_cpu_lowcore_s390 
 *
 *  free the lowcore of the given cpu
 */

void free_cpu_lowcore_s390(void* lc)
{
        if(lc) {
                kl_free_block(lc);
	}
}
