/*
 * $Id: lc_trace_s390x.h,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __LC_TRACE_S390X_H
#define __LC_TRACE_S390X_H

#define STACK_SEGMENTS_S390X   2
#define STACK_SIZE_S390X       KL_KSTACK_SIZE_S390X
#define STACK_MASK_S390X       (~(STACK_SIZE_S390X - 1))
#define ALLOCA_PATCH_STK_SZ    0x2000UL
#define ALLOCA_PATCH_STK_MASK  (~(ALLOCA_PATCH_STK_SZ - 1))
/* XXX - need to be separated from s390 stuff */
#define STD_SFRAME_SIZE_S390X  160
#define RA_OFFSET_S390X        112
/* #define ADDR_MASK              0xffffffffffffffffUL */
#define IS_USER_PSW_S390X(PSW) ((PSW) & 0x1000000000000ULL)

#define TF_TRACEREC_VALID  0x01 /* The trace_rec_s has been setup already!   */
#define TF_SUPPRESS_HEADER 0x02 /* Suppress header output from trace cmds    */


/* init trace stuff for s390x dumps */
int  trace_init_s390x(void);

#endif /* __LC_TRACE_S390X_H */
