/*
 * $Id: lc_trace_i386.h,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __LC_TRACE_I386_H
#define __LC_TRACE_I386_H

#define STACK_SEGMENTS_I386	1
#define STACK_SIZE_I386         KL_KSTACK_SIZE_I386

/* Stack frame updating macro */
#define UPDATE_FRAME_I386(FUNCNAME, PC, RA, SP, FP, ASP, SRCNAME, LINE_NO, \
                          SIZE, FLAG) \
        curframe->funcname = FUNCNAME; \
        curframe->pc = PC; \
        curframe->sp = SP; \
        curframe->ra = RA; \
        curframe->fp = FP; \
        curframe->asp = ASP; \
        curframe->srcfile = SRCNAME; \
        curframe->line_no = LINE_NO; \
        curframe->frame_size = SIZE; \
        curframe->ptr = curstkidx; \
        kl_enqueue((element_t **)&trace->frame, (element_t *)curframe); \
        trace->nframes++; \
        curframe->flag |=FLAG;\

/* flag field of sframe_t */
#define EX_FRAME_I386 0x1 /* this frame is an interrupt or exception 
			   * frame, pt_regs field of sframe_t is valid 
			   * in this case */
/*
 * function prototypes
 */

/* init trace stuff for i386 dumps */
int trace_init_i386(void);

/* used in cmd_mktrace.c -> i386 only */
void finish_trace_i386(trace_t*);
int  add_frame_i386(trace_t*, kaddr_t, kaddr_t);

#endif /* __LC_TRACE_I386_H */
