/*
 * $Id: lc_dump_arch.h,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __LC_DUMP_ARCH_H
#define __LC_DUMP_ARCH_H

#ifdef DUMP_ARCH_ALPHA
# include <lc_dis_alpha.h>
# include <lc_trace_alpha.h>
int  dumparch_init_alpha(FILE *);
#endif
#ifdef DUMP_ARCH_ARM
# include <lc_dis_arm.h>
# include <lc_trace_arm.h>
int dumparch_init_arm(FILE*);
#endif
#ifdef DUMP_ARCH_IA64
# include <lc_dis_ia64.h>
# include <lc_trace_ia64.h>
int  dumparch_init_ia64(FILE *);
#endif
#ifdef DUMP_ARCH_I386
# include <lc_dis_i386.h>
# include <lc_trace_i386.h>
int  dumparch_init_i386(FILE *);
#endif
#ifdef DUMP_ARCH_PPC64
# include <lc_dis_ppc64.h>
# include <lc_trace_ppc64.h>
int dumparch_init_ppc64(FILE *);
#endif
#ifdef DUMP_ARCH_S390
# include <lc_dis_s390.h>
# include <lc_trace_s390.h>
# include <lc_report_s390.h>
# include <lc_util_s390.h>
int  dumparch_init_s390(FILE *);
#endif
#ifdef DUMP_ARCH_S390X
# include <lc_dis_s390.h>
# include <lc_trace_s390x.h>
# include <lc_report_s390.h>
# include <lc_util_s390.h>
int  dumparch_init_s390x(FILE *);
#endif

#endif /* __LC_DUMP_ARCH_H */
