#
# Adds the r_uid column to dpm_get_filereq and populates
# Adds the groups column to dpm_space_reserv and populates
# Updates schema_version_dpm table
# i.e. the update from schema 3.1.0 to 3.2.0
#

package UpdateDpmDatabase;

use DBI;
use Common;
use strict;
use warnings; 

sub update_mysql($) {
	my ($dbh_dpm) = @_;

	$dbh_dpm->do ("ALTER TABLE dpm_get_filereq ADD r_uid INTEGER");
	$dbh_dpm->do ("UPDATE dpm_get_filereq, dpm_req SET dpm_get_filereq.r_uid = dpm_req.r_uid WHERE dpm_get_filereq.r_token = dpm_req.r_token");
	$dbh_dpm->do ("UPDATE dpm_get_filereq, dpm_pending_req SET dpm_get_filereq.r_uid = dpm_pending_req.r_uid WHERE dpm_get_filereq.r_token = dpm_pending_req.r_token");

	$dbh_dpm->do ("ALTER TABLE dpm_space_reserv ADD groups VARCHAR(255) BINARY");
	$dbh_dpm->do ("UPDATE dpm_space_reserv SET groups = s_gid");

	$dbh_dpm->do ("UPDATE schema_version_dpm SET major = 3, minor = 2, patch = 0");

	$dbh_dpm->commit;
}

sub update_oracle($) {
        my ($dbh_dpm) = @_;

	$dbh_dpm->do ("ALTER TABLE dpm_get_filereq ADD r_uid NUMBER(10)");
	$dbh_dpm->do ("UPDATE dpm_get_filereq SET r_uid = (SELECT r_uid FROM dpm_req WHERE dpm_req.r_token = dpm_get_filereq.r_token)");
	$dbh_dpm->do ("UPDATE dpm_get_filereq SET r_uid = (SELECT r_uid FROM dpm_pending_req WHERE dpm_pending_req.r_token = dpm_get_filereq.r_token)");

	$dbh_dpm->do ("ALTER TABLE dpm_space_reserv ADD groups VARCHAR2(255)");
	$dbh_dpm->do ("UPDATE dpm_space_reserv SET groups = s_gid");

	$dbh_dpm->do ("UPDATE schema_version_dpm SET major = 3, minor = 2, patch = 0");

	$dbh_dpm->commit;
}

1;
