/* document_view.c generated by valac 0.32.0.7-5c081, the Vala compiler
 * generated from document_view.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2016 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <latexila.h>
#include <gspell/gspell.h>
#include <glib/gi18n-lib.h>


#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentViewPrivate DocumentViewPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _Block18Data Block18Data;

struct _DocumentView {
	GtkSourceView parent_instance;
	DocumentViewPrivate * priv;
};

struct _DocumentViewClass {
	GtkSourceViewClass parent_class;
};

struct _DocumentViewPrivate {
	GSettings* _editor_settings;
	PangoFontDescription* _font_desc;
};

struct _Block18Data {
	int _ref_count_;
	DocumentView* self;
	GspellChecker* spell_checker;
};


static gpointer document_view_parent_class = NULL;
static gboolean document_view__no_spell_language_dialog_shown;
static gboolean document_view__no_spell_language_dialog_shown = FALSE;

GType document_view_get_type (void) G_GNUC_CONST;
#define DOCUMENT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_VIEW, DocumentViewPrivate))
enum  {
	DOCUMENT_VIEW_DUMMY_PROPERTY
};
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
#define DOCUMENT_VIEW_SCROLL_MARGIN 0.02
#define DOCUMENT_VIEW_METADATA_ATTRIBUTE_SPELL_LANGUAGE "metadata::latexila-spell-language"
#define DOCUMENT_VIEW_METADATA_ATTRIBUTE_INLINE_SPELL "metadata::latexila-inline-spell"
#define DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR "1"
#define DOCUMENT_VIEW_INLINE_SPELL_DISABLED_STR "0"
GType document_get_type (void) G_GNUC_CONST;
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type, Document* doc);
static void __lambda53_ (DocumentView* self, GObject* d, GParamSpec* p);
gboolean document_get_readonly (Document* self);
static void ___lambda53__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void document_view_set_font_from_settings (DocumentView* self);
void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id);
GType completion_provider_get_type (void) G_GNUC_CONST;
CompletionProvider* completion_provider_get_default (void);
static void document_view_hide_completion_calltip_when_needed (DocumentView* self);
static void document_view_init_spell_checking (DocumentView* self);
static gboolean document_view_on_button_release_event (DocumentView* self, GdkEventButton* event);
static gboolean _document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
void document_view_cut_selection (DocumentView* self);
void document_view_copy_selection (DocumentView* self);
void document_view_my_paste_clipboard (DocumentView* self);
void document_view_delete_selection (DocumentView* self);
void document_view_my_select_all (DocumentView* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
const gchar* app_settings_get_system_font (AppSettings* self);
void document_view_set_font_from_string (DocumentView* self, const gchar* font);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
gchar* document_view_get_indentation_style (DocumentView* self);
GFile* document_get_location (Document* self);
GFile* document_get_main_file (Document* self);
static void __lambda54_ (DocumentView* self);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static void ___lambda54__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static GspellLanguage* document_view_get_spell_language (DocumentView* self);
void document_view_setup_inline_spell_checker (DocumentView* self);
static void document_view_inline_checker_enabled_notify_cb (DocumentView* self);
static void _document_view_inline_checker_enabled_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda55_ (Block18Data* _data18_);
static void ___lambda55__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda56_ (Block18Data* _data18_);
static void ___lambda56__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda57_ (DocumentView* self);
static void ___lambda57__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
gchar* document_get_metadata (Document* self, const gchar* key);
static GspellChecker* document_view_get_spell_checker (DocumentView* self);
void document_view_launch_spell_checker_dialog (DocumentView* self);
void document_view_launch_spell_language_chooser_dialog (DocumentView* self);
void document_view_save_spell_language_metadata (DocumentView* self);
void document_set_metadata (Document* self, const gchar* key, const gchar* val);
void document_view_save_inline_spell_metadata (DocumentView* self);
static void document_view_finalize (GObject* obj);


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static void __lambda53_ (DocumentView* self, GObject* d, GParamSpec* p) {
	GObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (d != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = d;
	_tmp1_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DOCUMENT, Document));
	_tmp2_ = _tmp1_;
	gtk_text_view_set_editable ((GtkTextView*) self, !_tmp2_);
}


static void ___lambda53__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda53_ ((DocumentView*) self, _sender, pspec);
}


static gboolean _document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = document_view_on_button_release_event ((DocumentView*) self, event);
	return result;
}


DocumentView* document_view_construct (GType object_type, Document* doc) {
	DocumentView * self = NULL;
	Document* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	guint tmp = 0U;
	GSettings* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GSettings* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	Document* _tmp11_ = NULL;
	GSettings* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	Document* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentView*) g_object_new (object_type, NULL);
	_tmp0_ = doc;
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) _tmp0_);
	_tmp1_ = doc;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::readonly", (GCallback) ___lambda53__g_object_notify, self, 0);
	gtk_text_view_set_wrap_mode ((GtkTextView*) self, GTK_WRAP_WORD);
	gtk_source_view_set_auto_indent ((GtkSourceView*) self, TRUE);
	gtk_source_view_set_indent_width ((GtkSourceView*) self, -1);
	_tmp2_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_g_object_unref0 (self->priv->_editor_settings);
	self->priv->_editor_settings = _tmp2_;
	_tmp3_ = self->priv->_editor_settings;
	g_settings_bind (_tmp3_, "forget-no-tabs", (GObject*) self, "smart-backspace", G_SETTINGS_BIND_GET);
	document_view_set_font_from_settings (self);
	_tmp4_ = self->priv->_editor_settings;
	g_settings_get (_tmp4_, "tabs-size", "u", &tmp);
	gtk_source_view_set_tab_width ((GtkSourceView*) self, tmp);
	_tmp5_ = self->priv->_editor_settings;
	_tmp6_ = g_settings_get_boolean (_tmp5_, "insert-spaces");
	gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) self, _tmp6_);
	_tmp7_ = self->priv->_editor_settings;
	_tmp8_ = g_settings_get_boolean (_tmp7_, "display-line-numbers");
	gtk_source_view_set_show_line_numbers ((GtkSourceView*) self, _tmp8_);
	_tmp9_ = self->priv->_editor_settings;
	_tmp10_ = g_settings_get_boolean (_tmp9_, "highlight-current-line");
	gtk_source_view_set_highlight_current_line ((GtkSourceView*) self, _tmp10_);
	_tmp11_ = doc;
	_tmp12_ = self->priv->_editor_settings;
	_tmp13_ = g_settings_get_boolean (_tmp12_, "bracket-matching");
	gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) _tmp11_, _tmp13_);
	_tmp14_ = doc;
	_tmp15_ = self->priv->_editor_settings;
	_tmp16_ = g_settings_get_string (_tmp15_, "scheme");
	_tmp17_ = _tmp16_;
	document_set_style_scheme_from_string (_tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	gtk_source_view_set_smart_home_end ((GtkSourceView*) self, GTK_SOURCE_SMART_HOME_END_AFTER);
	{
		CompletionProvider* provider = NULL;
		CompletionProvider* _tmp18_ = NULL;
		GtkSourceCompletion* _tmp19_ = NULL;
		GtkSourceCompletion* _tmp20_ = NULL;
		GtkSourceCompletion* _tmp21_ = NULL;
		GtkSourceCompletion* _tmp22_ = NULL;
		GtkSourceCompletion* _tmp23_ = NULL;
		GtkSourceCompletion* _tmp24_ = NULL;
		GtkSourceCompletion* _tmp25_ = NULL;
		GtkSourceCompletion* _tmp26_ = NULL;
		GtkSourceCompletion* _tmp27_ = NULL;
		GtkSourceCompletion* _tmp28_ = NULL;
		_tmp18_ = completion_provider_get_default ();
		provider = _tmp18_;
		_tmp19_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp20_ = _tmp19_;
		gtk_source_completion_add_provider (_tmp20_, (GtkSourceCompletionProvider*) provider, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (provider);
			goto __catch16_g_error;
		}
		_tmp21_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp22_ = _tmp21_;
		g_object_set (_tmp22_, "remember-info-visibility", TRUE, NULL);
		_tmp23_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp24_ = _tmp23_;
		g_object_set (_tmp24_, "show-headers", FALSE, NULL);
		_tmp25_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp26_ = _tmp25_;
		g_object_set (_tmp26_, "auto-complete-delay", (guint) 0, NULL);
		_tmp27_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp28_ = _tmp27_;
		g_object_set (_tmp28_, "accelerators", (guint) 0, NULL);
		document_view_hide_completion_calltip_when_needed (self);
		_g_object_unref0 (provider);
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("document_view.vala:86: Completion: %s", _tmp30_);
		_g_error_free0 (e);
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	document_view_init_spell_checking (self);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _document_view_on_button_release_event_gtk_widget_button_release_event, self, 0);
	return self;
}


DocumentView* document_view_new (Document* doc) {
	return document_view_construct (TYPE_DOCUMENT_VIEW, doc);
}


void document_view_scroll_to_cursor (DocumentView* self, gdouble margin) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	_tmp3_ = margin;
	gtk_text_view_scroll_to_mark ((GtkTextView*) self, _tmp2_, _tmp3_, FALSE, (gdouble) 0, (gdouble) 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void document_view_cut_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DOCUMENT, Document));
	_tmp9_ = _tmp8_;
	gtk_text_buffer_cut_clipboard (_tmp5_, clipboard, !_tmp9_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_copy_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_copy_clipboard (_tmp5_, clipboard);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_my_paste_clipboard (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DOCUMENT, Document));
	_tmp9_ = _tmp8_;
	gtk_text_buffer_paste_clipboard (_tmp5_, clipboard, NULL, !_tmp9_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_delete_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DOCUMENT, Document));
	_tmp7_ = _tmp6_;
	gtk_text_buffer_delete_selection (_tmp3_, TRUE, !_tmp7_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
}


void document_view_my_select_all (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_bounds (_tmp3_, &_tmp4_, &_tmp5_);
	start = _tmp4_;
	end = _tmp5_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = start;
	_tmp9_ = end;
	gtk_text_buffer_select_range (_tmp7_, &_tmp8_, &_tmp9_);
}


void document_view_set_font_from_settings (DocumentView* self) {
	gchar* font = NULL;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_editor_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "use-default-font");
	if (_tmp1_) {
		AppSettings* _tmp2_ = NULL;
		AppSettings* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp2_ = app_settings_get_default ();
		_tmp3_ = _tmp2_;
		_tmp4_ = app_settings_get_system_font (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (font);
		font = _tmp6_;
		_g_object_unref0 (_tmp3_);
	} else {
		GSettings* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp7_ = self->priv->_editor_settings;
		_tmp8_ = g_settings_get_string (_tmp7_, "editor-font");
		_g_free0 (font);
		font = _tmp8_;
	}
	_tmp9_ = font;
	document_view_set_font_from_string (self, _tmp9_);
	_g_free0 (font);
}


void document_view_set_font_from_string (DocumentView* self, const gchar* font) {
	const gchar* _tmp0_ = NULL;
	PangoFontDescription* _tmp1_ = NULL;
	PangoFontDescription* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	_tmp0_ = font;
	_tmp1_ = pango_font_description_from_string (_tmp0_);
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
	self->priv->_font_desc = _tmp1_;
	_tmp2_ = self->priv->_font_desc;
	gtk_widget_override_font ((GtkWidget*) self, _tmp2_);
}


void document_view_enlarge_font (DocumentView* self) {
	PangoFontDescription* _tmp0_ = NULL;
	PangoFontDescription* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	PangoFontDescription* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_font_desc;
	_tmp1_ = self->priv->_font_desc;
	_tmp2_ = pango_font_description_get_size (_tmp1_);
	pango_font_description_set_size (_tmp0_, _tmp2_ + PANGO_SCALE);
	_tmp3_ = self->priv->_font_desc;
	gtk_widget_override_font ((GtkWidget*) self, _tmp3_);
}


void document_view_shrink_font (DocumentView* self) {
	PangoFontDescription* _tmp0_ = NULL;
	PangoFontDescription* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	PangoFontDescription* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_font_desc;
	_tmp1_ = self->priv->_font_desc;
	_tmp2_ = pango_font_description_get_size (_tmp1_);
	pango_font_description_set_size (_tmp0_, _tmp2_ - PANGO_SCALE);
	_tmp3_ = self->priv->_font_desc;
	gtk_widget_override_font ((GtkWidget*) self, _tmp3_);
}


gchar* document_view_get_indentation_style (DocumentView* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_source_view_get_insert_spaces_instead_of_tabs ((GtkSourceView*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		gchar* _tmp4_ = NULL;
		_tmp2_ = gtk_source_view_get_tab_width ((GtkSourceView*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strnfill ((gsize) _tmp3_, ' ');
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup ("\t");
	result = _tmp5_;
	return result;
}


static gboolean document_view_on_button_release_event (DocumentView* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ == ((guint) 1)) {
		GdkEventButton* _tmp3_ = NULL;
		GdkModifierType _tmp4_ = 0;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->state;
		_tmp0_ = (_tmp4_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		LatexilaSynctex* synctex = NULL;
		LatexilaSynctex* _tmp5_ = NULL;
		LatexilaSynctex* _tmp6_ = NULL;
		Document* doc = NULL;
		GtkTextBuffer* _tmp7_ = NULL;
		GtkTextBuffer* _tmp8_ = NULL;
		Document* _tmp9_ = NULL;
		LatexilaSynctex* _tmp10_ = NULL;
		GtkTextBuffer* _tmp11_ = NULL;
		GtkTextBuffer* _tmp12_ = NULL;
		Document* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		Document* _tmp16_ = NULL;
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GdkEventButton* _tmp19_ = NULL;
		guint32 _tmp20_ = 0U;
		_tmp5_ = latexila_synctex_get_instance ();
		_tmp6_ = _g_object_ref0 (_tmp5_);
		synctex = _tmp6_;
		_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_DOCUMENT) ? ((Document*) _tmp8_) : NULL);
		doc = _tmp9_;
		_tmp10_ = synctex;
		_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = doc;
		_tmp14_ = document_get_location (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = doc;
		_tmp17_ = document_get_main_file (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = event;
		_tmp20_ = _tmp19_->time;
		latexila_synctex_forward_search (_tmp10_, _tmp12_, _tmp15_, _tmp18_, (guint) _tmp20_);
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (doc);
		_g_object_unref0 (synctex);
	}
	result = FALSE;
	return result;
}


static void __lambda54_ (DocumentView* self) {
	CompletionProvider* provider = NULL;
	CompletionProvider* _tmp0_ = NULL;
	_tmp0_ = completion_provider_get_default ();
	provider = _tmp0_;
	completion_provider_hide_calltip_window (provider);
	_g_object_unref0 (provider);
}


static void ___lambda54__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda54_ ((DocumentView*) self);
}


static void document_view_hide_completion_calltip_when_needed (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::cursor-position", (GCallback) ___lambda54__g_object_notify, self, 0);
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		DocumentView* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->spell_checker);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}


static void _document_view_inline_checker_enabled_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_view_inline_checker_enabled_notify_cb ((DocumentView*) self);
}


static void __lambda55_ (Block18Data* _data18_) {
	DocumentView* self;
	GspellLanguage* _tmp0_ = NULL;
	self = _data18_->self;
	_tmp0_ = document_view_get_spell_language (self);
	gspell_checker_set_language (_data18_->spell_checker, _tmp0_);
	document_view_setup_inline_spell_checker (self);
}


static void ___lambda55__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda55_ (self);
}


static void __lambda56_ (Block18Data* _data18_) {
	DocumentView* self;
	GspellLanguage* _tmp0_ = NULL;
	self = _data18_->self;
	_tmp0_ = document_view_get_spell_language (self);
	gspell_checker_set_language (_data18_->spell_checker, _tmp0_);
}


static void ___lambda56__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda56_ (self);
}


static void __lambda57_ (DocumentView* self) {
	document_view_setup_inline_spell_checker (self);
}


static void ___lambda57__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda57_ ((DocumentView*) self);
}


static void document_view_init_spell_checking (DocumentView* self) {
	Block18Data* _data18_;
	GspellLanguage* _tmp0_ = NULL;
	GspellChecker* _tmp1_ = NULL;
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GspellTextBuffer* _tmp4_ = NULL;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp5_ = NULL;
	GspellTextView* _tmp6_ = NULL;
	Document* doc = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	Document* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = document_view_get_spell_language (self);
	_tmp1_ = gspell_checker_new (_tmp0_);
	_data18_->spell_checker = _tmp1_;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp3_);
	gspell_buffer = _tmp4_;
	gspell_text_buffer_set_spell_checker (gspell_buffer, _data18_->spell_checker);
	document_view_setup_inline_spell_checker (self);
	_tmp5_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	gspell_view = _tmp6_;
	g_signal_connect_object ((GObject*) gspell_view, "notify::inline-spell-checking", (GCallback) _document_view_inline_checker_enabled_notify_cb_g_object_notify, self, 0);
	_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_DOCUMENT) ? ((Document*) _tmp7_) : NULL);
	doc = _tmp8_;
	g_signal_connect_data ((GObject*) doc, "notify::location", (GCallback) ___lambda55__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp9_ = self->priv->_editor_settings;
	g_signal_connect_data (_tmp9_, "changed::spell-checking-language", (GCallback) ___lambda56__g_settings_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp10_ = self->priv->_editor_settings;
	g_signal_connect_object (_tmp10_, "changed::highlight-misspelled-words", (GCallback) ___lambda57__g_settings_changed, self, 0);
	_g_object_unref0 (doc);
	_g_object_unref0 (gspell_view);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static GspellLanguage* document_view_get_spell_language (DocumentView* self) {
	GspellLanguage* result = NULL;
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	gchar* lang_code = NULL;
	Document* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar _tmp8_ = '\0';
	const gchar* _tmp9_ = NULL;
	GspellLanguage* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DOCUMENT) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = doc;
	_tmp3_ = document_get_metadata (_tmp2_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_SPELL_LANGUAGE);
	lang_code = _tmp3_;
	_tmp4_ = lang_code;
	if (_tmp4_ == NULL) {
		GSettings* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = self->priv->_editor_settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "spell-checking-language");
		_g_free0 (lang_code);
		lang_code = _tmp6_;
	}
	_tmp7_ = lang_code;
	_tmp8_ = string_get (_tmp7_, (glong) 0);
	if (_tmp8_ == '\0') {
		result = NULL;
		_g_free0 (lang_code);
		_g_object_unref0 (doc);
		return result;
	}
	_tmp9_ = lang_code;
	_tmp10_ = gspell_language_lookup (_tmp9_);
	result = _tmp10_;
	_g_free0 (lang_code);
	_g_object_unref0 (doc);
	return result;
}


static GspellChecker* document_view_get_spell_checker (DocumentView* self) {
	GspellChecker* result = NULL;
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GspellTextBuffer* _tmp2_ = NULL;
	GspellChecker* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp1_);
	gspell_buffer = _tmp2_;
	_tmp3_ = gspell_text_buffer_get_spell_checker (gspell_buffer);
	result = _tmp3_;
	return result;
}


void document_view_setup_inline_spell_checker (DocumentView* self) {
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	gboolean enabled = FALSE;
	gchar* metadata = NULL;
	Document* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp8_ = NULL;
	GspellTextView* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DOCUMENT) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = doc;
	_tmp3_ = document_get_metadata (_tmp2_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_INLINE_SPELL);
	metadata = _tmp3_;
	_tmp4_ = metadata;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = metadata;
		enabled = g_strcmp0 (_tmp5_, DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR) == 0;
	} else {
		GSettings* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->_editor_settings;
		_tmp7_ = g_settings_get_boolean (_tmp6_, "highlight-misspelled-words");
		enabled = _tmp7_;
	}
	_tmp8_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	gspell_view = _tmp9_;
	_tmp10_ = enabled;
	gspell_text_view_set_inline_spell_checking (gspell_view, _tmp10_);
	_g_object_unref0 (gspell_view);
	_g_free0 (metadata);
	_g_object_unref0 (doc);
}


void document_view_launch_spell_checker_dialog (DocumentView* self) {
	GspellNavigator* navigator = NULL;
	GspellNavigator* _tmp0_ = NULL;
	GspellNavigator* _tmp1_ = NULL;
	GspellCheckerDialog* dialog = NULL;
	GtkWidget* _tmp2_ = NULL;
	GspellCheckerDialog* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gspell_navigator_text_view_new (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	navigator = _tmp1_;
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp3_ = (GspellCheckerDialog*) gspell_checker_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, navigator);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (navigator);
}


void document_view_launch_spell_language_chooser_dialog (DocumentView* self) {
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp0_ = NULL;
	GspellChecker* _tmp1_ = NULL;
	GspellLanguageChooserDialog* dialog = NULL;
	GtkWidget* _tmp2_ = NULL;
	GspellLanguage* _tmp3_ = NULL;
	GspellLanguageChooserDialog* _tmp4_ = NULL;
	GspellLanguage* lang = NULL;
	GspellLanguage* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = document_view_get_spell_checker (self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	spell_checker = _tmp1_;
	g_return_if_fail (spell_checker != NULL);
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp3_ = gspell_checker_get_language (spell_checker);
	_tmp4_ = (GspellLanguageChooserDialog*) gspell_language_chooser_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, _tmp3_, (GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL) | GTK_DIALOG_USE_HEADER_BAR);
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	gtk_dialog_run ((GtkDialog*) dialog);
	_tmp5_ = gspell_language_chooser_get_language ((GspellLanguageChooser*) dialog);
	lang = _tmp5_;
	gspell_checker_set_language (spell_checker, lang);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (spell_checker);
}


void document_view_save_spell_language_metadata (DocumentView* self) {
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp0_ = NULL;
	GspellChecker* _tmp1_ = NULL;
	GspellChecker* _tmp2_ = NULL;
	Document* doc = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	Document* _tmp4_ = NULL;
	GspellLanguage* lang = NULL;
	GspellChecker* _tmp5_ = NULL;
	GspellLanguage* _tmp6_ = NULL;
	GspellLanguage* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = document_view_get_spell_checker (self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	spell_checker = _tmp1_;
	_tmp2_ = spell_checker;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_DOCUMENT) ? ((Document*) _tmp3_) : NULL);
	doc = _tmp4_;
	_tmp5_ = spell_checker;
	_tmp6_ = gspell_checker_get_language (_tmp5_);
	lang = _tmp6_;
	_tmp7_ = lang;
	if (_tmp7_ != NULL) {
		Document* _tmp8_ = NULL;
		GspellLanguage* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp8_ = doc;
		_tmp9_ = lang;
		_tmp10_ = gspell_language_get_code (_tmp9_);
		document_set_metadata (_tmp8_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_SPELL_LANGUAGE, _tmp10_);
	} else {
		Document* _tmp11_ = NULL;
		_tmp11_ = doc;
		document_set_metadata (_tmp11_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_SPELL_LANGUAGE, NULL);
	}
	_g_object_unref0 (doc);
	_g_object_unref0 (spell_checker);
}


void document_view_save_inline_spell_metadata (DocumentView* self) {
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp2_ = NULL;
	GspellTextView* _tmp3_ = NULL;
	GspellTextView* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DOCUMENT) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	gspell_view = _tmp3_;
	_tmp4_ = gspell_view;
	_tmp5_ = gspell_text_view_get_inline_spell_checking (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		Document* _tmp7_ = NULL;
		_tmp7_ = doc;
		document_set_metadata (_tmp7_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_INLINE_SPELL, DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR);
	} else {
		Document* _tmp8_ = NULL;
		_tmp8_ = doc;
		document_set_metadata (_tmp8_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_INLINE_SPELL, DOCUMENT_VIEW_INLINE_SPELL_DISABLED_STR);
	}
	_g_object_unref0 (gspell_view);
	_g_object_unref0 (doc);
}


static void document_view_inline_checker_enabled_notify_cb (DocumentView* self) {
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp0_ = NULL;
	GspellTextView* _tmp1_ = NULL;
	GspellTextView* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp5_ = NULL;
	GspellChecker* _tmp6_ = NULL;
	GspellChecker* _tmp7_ = NULL;
	GspellChecker* _tmp8_ = NULL;
	GspellLanguage* _tmp9_ = NULL;
	GspellTextView* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkWidget* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkMessageDialog* _tmp14_ = NULL;
	GtkMessageDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GtkMessageDialog* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gspell_view = _tmp1_;
	_tmp2_ = gspell_view;
	_tmp3_ = gspell_text_view_get_inline_spell_checking (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		_g_object_unref0 (gspell_view);
		return;
	}
	_tmp5_ = document_view_get_spell_checker (self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	spell_checker = _tmp6_;
	_tmp7_ = spell_checker;
	g_return_if_fail (_tmp7_ != NULL);
	_tmp8_ = spell_checker;
	_tmp9_ = gspell_checker_get_language (_tmp8_);
	if (_tmp9_ != NULL) {
		_g_object_unref0 (spell_checker);
		_g_object_unref0 (gspell_view);
		return;
	}
	_tmp10_ = gspell_view;
	gspell_text_view_set_inline_spell_checking (_tmp10_, FALSE);
	_tmp11_ = document_view__no_spell_language_dialog_shown;
	if (_tmp11_) {
		_g_object_unref0 (spell_checker);
		_g_object_unref0 (gspell_view);
		return;
	}
	document_view__no_spell_language_dialog_shown = TRUE;
	_tmp12_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp13_ = _ ("No dictionaries available for the spell checking.");
	_tmp14_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp12_) : NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _tmp13_);
	g_object_ref_sink (_tmp14_);
	dialog = _tmp14_;
	_tmp15_ = dialog;
	_tmp16_ = _ ("_Help");
	_tmp17_ = _ ("_OK");
	gtk_dialog_add_buttons ((GtkDialog*) _tmp15_, _tmp16_, GTK_RESPONSE_HELP, _tmp17_, GTK_RESPONSE_OK, NULL, NULL);
	_tmp18_ = dialog;
	_tmp19_ = gtk_dialog_run ((GtkDialog*) _tmp18_);
	response = _tmp19_;
	_tmp20_ = response;
	if (_tmp20_ == ((gint) GTK_RESPONSE_HELP)) {
		{
			GdkScreen* _tmp21_ = NULL;
			_tmp21_ = gtk_widget_get_screen ((GtkWidget*) self);
			gtk_show_uri (_tmp21_, "help:latexila/spell_checking", (guint32) GDK_CURRENT_TIME, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch17_g_error;
			}
		}
		goto __finally17;
		__catch17_g_error:
		{
			GError* e = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			g_warning ("document_view.vala:384: Impossible to open the documentation: %s", _tmp23_);
			_g_error_free0 (e);
		}
		__finally17:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (dialog);
			_g_object_unref0 (spell_checker);
			_g_object_unref0 (gspell_view);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp24_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp24_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (spell_checker);
	_g_object_unref0 (gspell_view);
}


static void document_view_class_init (DocumentViewClass * klass) {
	document_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = document_view_finalize;
}


static void document_view_instance_init (DocumentView * self) {
	self->priv = DOCUMENT_VIEW_GET_PRIVATE (self);
}


static void document_view_finalize (GObject* obj) {
	DocumentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_VIEW, DocumentView);
	_g_object_unref0 (self->priv->_editor_settings);
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
	G_OBJECT_CLASS (document_view_parent_class)->finalize (obj);
}


GType document_view_get_type (void) {
	static volatile gsize document_view_type_id__volatile = 0;
	if (g_once_init_enter (&document_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentView), 0, (GInstanceInitFunc) document_view_instance_init, NULL };
		GType document_view_type_id;
		document_view_type_id = g_type_register_static (gtk_source_view_get_type (), "DocumentView", &g_define_type_info, 0);
		g_once_init_leave (&document_view_type_id__volatile, document_view_type_id);
	}
	return document_view_type_id__volatile;
}



