/* project_dialogs.c generated by valac 0.12.1, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtksourceview/gtksourceview.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block11Data Block11Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block12Data Block12Data;

struct _Block11Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block12Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
GtkWidget* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
static void _lambda86_ (Block11Data* _data11_);
static void __lambda86__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
Project* projects_get (Projects* self, gint id);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
void project_dialogs_update_model (GtkListStore* model);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void _lambda87_ (Block12Data* _data12_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void __lambda87__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda88_ (Block12Data* _data12_);
void projects_delete (Projects* self, gint num);
static void __lambda88__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda89_ (Block12Data* _data12_);
void projects_clear_all (Projects* self);
static void __lambda89__gtk_button_clicked (GtkButton* _sender, gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->main_file_chooser);
		_g_object_unref0 (_data11_->directory_chooser);
		g_slice_free (Block11Data, _data11_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda86_ (Block11Data* _data11_) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* dir;
	GError * _inner_error_ = NULL;
	_tmp0_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data11_->directory_chooser);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	dir = _tmp1_;
	gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _data11_->main_file_chooser, dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch27_g_error;
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (dir);
}


static void __lambda86__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
	_lambda86_ (self);
}


void project_dialogs_new_project (MainWindow* main_window) {
	Block11Data* _data11_;
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	GtkVBox* _tmp4_;
	GtkVBox* content_area;
	const gchar* _tmp5_ = NULL;
	GtkFileChooserButton* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* component;
	const gchar* _tmp9_ = NULL;
	GtkFileChooserButton* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkWidget* _tmp12_ = NULL;
	Document* _tmp13_ = NULL;
	Document* _tmp14_;
	Document* doc;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_tmp0_ = _ ("New Project");
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_NEW, GTK_RESPONSE_OK, NULL, NULL);
	dialog = g_object_ref_sink (_tmp1_);
	_tmp2_ = gtk_dialog_get_content_area (dialog);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (GTK_IS_VBOX (_tmp3_) ? ((GtkVBox*) _tmp3_) : NULL);
	content_area = _tmp4_;
	_tmp5_ = _ ("Directory");
	_tmp6_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp5_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	_data11_->directory_chooser = g_object_ref_sink (_tmp6_);
	gtk_widget_set_size_request ((GtkWidget*) _data11_->directory_chooser, 250, -1);
	_tmp7_ = _ ("Directory");
	_tmp8_ = utils_get_dialog_component (_tmp7_, (GtkWidget*) _data11_->directory_chooser);
	component = _tmp8_;
	gtk_box_pack_start ((GtkBox*) content_area, component, FALSE, TRUE, (guint) 0);
	_tmp9_ = _ ("Main File");
	_tmp10_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp9_, GTK_FILE_CHOOSER_ACTION_OPEN);
	_data11_->main_file_chooser = g_object_ref_sink (_tmp10_);
	_tmp11_ = _ ("Main File");
	_tmp12_ = utils_get_dialog_component (_tmp11_, (GtkWidget*) _data11_->main_file_chooser);
	_g_object_unref0 (component);
	component = _tmp12_;
	gtk_box_pack_start ((GtkBox*) content_area, component, FALSE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (_data11_->directory_chooser, "file-set", (GCallback) __lambda86__gtk_file_chooser_button_file_set, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp13_ = main_window_get_active_document (main_window);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	doc = _tmp14_;
	if (doc != NULL) {
		GFile* _tmp16_ = NULL;
		_tmp16_ = document_get_location (doc);
		_tmp15_ = _tmp16_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GFile* _tmp19_;
		GFile* _tmp20_ = NULL;
		_tmp17_ = document_get_location (doc);
		_tmp18_ = g_file_get_parent (_tmp17_);
		_tmp19_ = _tmp18_;
		gtk_file_chooser_set_file ((GtkFileChooser*) _data11_->directory_chooser, _tmp19_, &_inner_error_);
		_g_object_unref0 (_tmp19_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
		_tmp20_ = document_get_location (doc);
		gtk_file_chooser_set_file ((GtkFileChooser*) _data11_->main_file_chooser, _tmp20_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
		goto __finally28;
		__catch28_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally28:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (doc);
			_g_object_unref0 (component);
			_g_object_unref0 (content_area);
			_g_object_unref0 (dialog);
			block11_data_unref (_data11_);
			_data11_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		gint _tmp21_;
		GFile* _tmp22_ = NULL;
		GFile* _tmp23_;
		GFile* directory;
		GFile* _tmp24_ = NULL;
		GFile* _tmp25_;
		GFile* main_file;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_;
		Project project = {0};
		GFile* _tmp28_;
		GFile* _tmp29_;
		GFile* conflict = NULL;
		Projects* _tmp30_ = NULL;
		Projects* _tmp31_;
		GFile* _tmp32_ = NULL;
		gboolean _tmp33_;
		gboolean _tmp34_;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		GtkMessageDialog* _tmp42_ = NULL;
		GtkDialog* _tmp43_;
		GtkDialog* error_dialog;
		_tmp21_ = gtk_dialog_run (dialog);
		if (!(_tmp21_ == GTK_RESPONSE_OK)) {
			break;
		}
		_tmp22_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data11_->directory_chooser);
		_tmp23_ = _g_object_ref0 (_tmp22_);
		directory = _tmp23_;
		_tmp24_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data11_->main_file_chooser);
		_tmp25_ = _g_object_ref0 (_tmp24_);
		main_file = _tmp25_;
		if (directory == NULL) {
			_tmp26_ = TRUE;
		} else {
			_tmp26_ = main_file == NULL;
		}
		if (_tmp26_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		_tmp27_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) dialog, main_file, directory);
		if (!_tmp27_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		memset (&project, 0, sizeof (Project));
		_tmp28_ = _g_object_ref0 (directory);
		_g_object_unref0 (project.directory);
		project.directory = _tmp28_;
		_tmp29_ = _g_object_ref0 (main_file);
		_g_object_unref0 (project.main_file);
		project.main_file = _tmp29_;
		_tmp30_ = projects_get_default ();
		_tmp31_ = _tmp30_;
		_tmp33_ = projects_add (_tmp31_, &project, &_tmp32_);
		_g_object_unref0 (conflict);
		conflict = _tmp32_;
		_tmp34_ = _tmp33_;
		_projects_unref0 (_tmp31_);
		if (_tmp34_) {
			_g_object_unref0 (conflict);
			project_destroy (&project);
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			break;
		}
		_tmp35_ = _ ("There is a conflict with the project \"%s\".");
		_tmp36_ = g_file_get_parse_name (conflict);
		_tmp37_ = _tmp36_;
		_tmp38_ = utils_replace_home_dir_with_tilde (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp39_, "/", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp35_, _tmp41_);
		_tmp43_ = (GtkDialog*) g_object_ref_sink (_tmp42_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		error_dialog = _tmp43_;
		gtk_dialog_run (error_dialog);
		gtk_object_destroy ((GtkObject*) error_dialog);
		_g_object_unref0 (error_dialog);
		_g_object_unref0 (conflict);
		project_destroy (&project);
		_g_object_unref0 (main_file);
		_g_object_unref0 (directory);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (doc);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}


gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id) {
	gboolean result = FALSE;
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_;
	Project* _tmp2_ = NULL;
	Project* _tmp3_;
	Project* project;
	const gchar* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkDialog* dialog;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* _tmp7_;
	GtkVBox* _tmp8_;
	GtkVBox* content_area;
	gchar* _tmp9_ = NULL;
	gchar* project_dir;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* location;
	const gchar* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	GtkWidget* component;
	const gchar* _tmp16_ = NULL;
	GtkFileChooserButton* _tmp17_ = NULL;
	GtkFileChooserButton* main_file_chooser;
	const gchar* _tmp18_ = NULL;
	GtkWidget* _tmp19_ = NULL;
	gboolean ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, FALSE);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = projects_get (_tmp1_, project_id);
	_tmp3_ = _tmp2_;
	_projects_unref0 (_tmp1_);
	project = _tmp3_;
	g_return_val_if_fail (project != NULL, FALSE);
	_tmp4_ = _ ("Configure Project");
	_tmp5_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp4_, main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL, NULL);
	dialog = g_object_ref_sink (_tmp5_);
	_tmp6_ = gtk_dialog_get_content_area (dialog);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (GTK_IS_VBOX (_tmp7_) ? ((GtkVBox*) _tmp7_) : NULL);
	content_area = _tmp8_;
	_tmp9_ = g_file_get_parse_name ((*project).directory);
	project_dir = _tmp9_;
	_tmp10_ = utils_replace_home_dir_with_tilde (project_dir);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "/", NULL);
	_g_free0 (project_dir);
	project_dir = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp13_ = (GtkLabel*) gtk_label_new (project_dir);
	location = g_object_ref_sink (_tmp13_);
	gtk_label_set_line_wrap (location, TRUE);
	_tmp14_ = _ ("Location of the project");
	_tmp15_ = utils_get_dialog_component (_tmp14_, (GtkWidget*) location);
	component = _tmp15_;
	gtk_box_pack_start ((GtkBox*) content_area, component, FALSE, TRUE, (guint) 0);
	_tmp16_ = _ ("Main File");
	_tmp17_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp16_, GTK_FILE_CHOOSER_ACTION_OPEN);
	main_file_chooser = g_object_ref_sink (_tmp17_);
	_tmp18_ = _ ("Main File");
	_tmp19_ = utils_get_dialog_component (_tmp18_, (GtkWidget*) main_file_chooser);
	_g_object_unref0 (component);
	component = _tmp19_;
	gtk_box_pack_start ((GtkBox*) content_area, component, FALSE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	gtk_file_chooser_set_file ((GtkFileChooser*) main_file_chooser, (*project).main_file, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch29_g_error;
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (main_file_chooser);
		_g_object_unref0 (component);
		_g_object_unref0 (location);
		_g_free0 (project_dir);
		_g_object_unref0 (content_area);
		_g_object_unref0 (dialog);
		_project_free0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = FALSE;
	while (TRUE) {
		gint _tmp20_;
		GFile* _tmp21_ = NULL;
		GFile* _tmp22_;
		GFile* main_file;
		gboolean _tmp23_;
		Projects* _tmp24_ = NULL;
		Projects* _tmp25_;
		gboolean _tmp26_;
		_tmp20_ = gtk_dialog_run (dialog);
		if (!(_tmp20_ == GTK_RESPONSE_OK)) {
			break;
		}
		_tmp21_ = gtk_file_chooser_get_file ((GtkFileChooser*) main_file_chooser);
		_tmp22_ = _g_object_ref0 (_tmp21_);
		main_file = _tmp22_;
		if (main_file == NULL) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp23_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) dialog, main_file, (*project).directory);
		if (!_tmp23_) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp24_ = projects_get_default ();
		_tmp25_ = _tmp24_;
		_tmp26_ = projects_change_main_file (_tmp25_, project_id, main_file);
		ret = _tmp26_;
		_projects_unref0 (_tmp25_);
		_g_object_unref0 (main_file);
		break;
	}
	gtk_object_destroy ((GtkObject*) dialog);
	result = ret;
	_g_object_unref0 (main_file_chooser);
	_g_object_unref0 (component);
	_g_object_unref0 (location);
	_g_free0 (project_dir);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_project_free0 (project);
	return result;
}


GType project_dialogs_project_column_get_type (void) {
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->treeview);
		_g_object_unref0 (_data12_->store);
		_g_object_unref0 (_data12_->dialog);
		g_slice_free (Block12Data, _data12_);
	}
}


static void _lambda87_ (Block12Data* _data12_) {
	gint _tmp0_;
	gint i;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = utils_get_selected_row (_data12_->treeview, NULL);
	i = _tmp0_;
	if (i != (-1)) {
		gboolean _tmp2_;
		_tmp2_ = project_dialogs_configure_project ((GtkWindow*) _data12_->dialog, i);
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		project_dialogs_update_model (_data12_->store);
	}
}


static void __lambda87__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda87_ (self);
}


static void _lambda88_ (Block12Data* _data12_) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	gchar* directory = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	const gchar* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	GtkDialog* delete_dialog;
	gint _tmp5_;
	_tmp1_ = utils_get_selected_row (_data12_->treeview, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	if (i == (-1)) {
		return;
	}
	_tmp2_ = _g_object_ref0 (GTK_TREE_MODEL (_data12_->store));
	model = _tmp2_;
	gtk_tree_model_get (model, &iter, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
	_tmp3_ = _ ("Do you really want to delete the project \"%s\"?");
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data12_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp3_, directory);
	delete_dialog = (GtkDialog*) g_object_ref_sink (_tmp4_);
	gtk_dialog_add_buttons (delete_dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	_tmp5_ = gtk_dialog_run (delete_dialog);
	if (_tmp5_ == GTK_RESPONSE_YES) {
		Projects* _tmp6_ = NULL;
		Projects* _tmp7_;
		gtk_list_store_remove (_data12_->store, &iter);
		_tmp6_ = projects_get_default ();
		_tmp7_ = _tmp6_;
		projects_delete (_tmp7_, i);
		_projects_unref0 (_tmp7_);
	}
	gtk_object_destroy ((GtkObject*) delete_dialog);
	_g_object_unref0 (delete_dialog);
	_g_object_unref0 (model);
	_g_free0 (directory);
}


static void __lambda88__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda88_ (self);
}


static void _lambda89_ (Block12Data* _data12_) {
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	GtkDialog* clear_dialog;
	const gchar* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* button;
	GtkImage* _tmp4_ = NULL;
	GtkImage* img;
	gint _tmp5_;
	_tmp0_ = _ ("Do you really want to clear all projects?");
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data12_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp0_);
	clear_dialog = (GtkDialog*) g_object_ref_sink (_tmp1_);
	gtk_dialog_add_button (clear_dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = _ ("Clear All");
	_tmp3_ = (GtkButton*) gtk_button_new_with_label (_tmp2_);
	button = g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
	img = g_object_ref_sink (_tmp4_);
	gtk_button_set_image (button, (GtkWidget*) img);
	gtk_widget_show_all ((GtkWidget*) button);
	gtk_dialog_add_action_widget (clear_dialog, (GtkWidget*) button, (gint) GTK_RESPONSE_YES);
	_tmp5_ = gtk_dialog_run (clear_dialog);
	if (_tmp5_ == GTK_RESPONSE_YES) {
		Projects* _tmp6_ = NULL;
		Projects* _tmp7_;
		_tmp6_ = projects_get_default ();
		_tmp7_ = _tmp6_;
		projects_clear_all (_tmp7_);
		_projects_unref0 (_tmp7_);
		gtk_list_store_clear (_data12_->store);
	}
	gtk_object_destroy ((GtkObject*) clear_dialog);
	_g_object_unref0 (img);
	_g_object_unref0 (button);
	_g_object_unref0 (clear_dialog);
}


static void __lambda89__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda89_ (self);
}


void project_dialogs_manage_projects (MainWindow* main_window) {
	Block12Data* _data12_;
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkVBox* _tmp3_;
	GtkVBox* content_area;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeViewColumn* _tmp6_ = NULL;
	GtkTreeViewColumn* column;
	const gchar* _tmp7_ = NULL;
	GtkCellRendererPixbuf* _tmp8_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp9_ = NULL;
	GtkCellRendererText* text_renderer;
	GtkTreeViewColumn* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkCellRendererPixbuf* _tmp12_ = NULL;
	GtkCellRendererText* _tmp13_ = NULL;
	GtkTreeSelection* _tmp14_ = NULL;
	GtkTreeSelection* _tmp15_;
	GtkTreeSelection* select;
	GtkWidget* _tmp16_ = NULL;
	GtkWidget* sw;
	GtkHBox* _tmp17_ = NULL;
	GtkHBox* hbox;
	GtkButton* _tmp18_ = NULL;
	GtkButton* edit_button;
	GtkButton* _tmp19_ = NULL;
	GtkButton* delete_button;
	const gchar* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* clear_all_button;
	GtkImage* _tmp22_ = NULL;
	GtkImage* image;
	g_return_if_fail (main_window != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_tmp0_ = _ ("Manage Projects");
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_OK, NULL, NULL);
	_data12_->dialog = g_object_ref_sink (_tmp1_);
	_tmp2_ = gtk_dialog_get_content_area (_data12_->dialog);
	_tmp3_ = _g_object_ref0 (GTK_VBOX (_tmp2_));
	content_area = _tmp3_;
	_tmp4_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	_data12_->store = _tmp4_;
	project_dialogs_update_model (_data12_->store);
	_tmp5_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data12_->store);
	_data12_->treeview = g_object_ref_sink (_tmp5_);
	gtk_widget_set_size_request ((GtkWidget*) _data12_->treeview, 400, 150);
	gtk_tree_view_set_rules_hint (_data12_->treeview, TRUE);
	_tmp6_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp6_);
	gtk_tree_view_append_column (_data12_->treeview, column);
	_tmp7_ = _ ("Directory");
	gtk_tree_view_column_set_title (column, _tmp7_);
	_tmp8_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp8_);
	g_object_set (pixbuf_renderer, "stock-id", GTK_STOCK_DIRECTORY, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp9_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp9_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
	_tmp10_ = gtk_tree_view_column_new ();
	_g_object_unref0 (column);
	column = g_object_ref_sink (_tmp10_);
	gtk_tree_view_append_column (_data12_->treeview, column);
	_tmp11_ = _ ("Main File");
	gtk_tree_view_column_set_title (column, _tmp11_);
	_tmp12_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_g_object_unref0 (pixbuf_renderer);
	pixbuf_renderer = g_object_ref_sink (_tmp12_);
	g_object_set (pixbuf_renderer, "stock-id", GTK_STOCK_FILE, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp13_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (text_renderer);
	text_renderer = g_object_ref_sink (_tmp13_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
	_tmp14_ = gtk_tree_view_get_selection (_data12_->treeview);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	select = _tmp15_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp16_ = utils_add_scrollbar ((GtkWidget*) _data12_->treeview);
	sw = _tmp16_;
	gtk_box_pack_start ((GtkBox*) content_area, sw, TRUE, TRUE, (guint) 0);
	_tmp17_ = (GtkHBox*) gtk_hbox_new (FALSE, 5);
	hbox = g_object_ref_sink (_tmp17_);
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) hbox, FALSE, FALSE, (guint) 5);
	_tmp18_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_PROPERTIES);
	edit_button = g_object_ref_sink (_tmp18_);
	_tmp19_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_DELETE);
	delete_button = g_object_ref_sink (_tmp19_);
	_tmp20_ = _ ("Clear All");
	_tmp21_ = (GtkButton*) gtk_button_new_with_label (_tmp20_);
	clear_all_button = g_object_ref_sink (_tmp21_);
	_tmp22_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU);
	image = g_object_ref_sink (_tmp22_);
	gtk_button_set_image (clear_all_button, (GtkWidget*) image);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) edit_button, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) delete_button, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) clear_all_button, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (edit_button, "clicked", (GCallback) __lambda87__gtk_button_clicked, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	g_signal_connect_data (delete_button, "clicked", (GCallback) __lambda88__gtk_button_clicked, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) __lambda89__gtk_button_clicked, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	gtk_dialog_run (_data12_->dialog);
	gtk_object_destroy ((GtkObject*) _data12_->dialog);
	_g_object_unref0 (image);
	_g_object_unref0 (clear_all_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (hbox);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (content_area);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}


gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	GtkDialog* error_dialog;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (main_file != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = g_file_has_prefix (main_file, directory);
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = _ ("The Main File is not in the directory.");
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp1_);
	error_dialog = (GtkDialog*) g_object_ref_sink (_tmp2_);
	gtk_dialog_run (error_dialog);
	gtk_object_destroy ((GtkObject*) error_dialog);
	result = FALSE;
	_g_object_unref0 (error_dialog);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


void project_dialogs_update_model (GtkListStore* model) {
	g_return_if_fail (model != NULL);
	gtk_list_store_clear (model);
	{
		Projects* _tmp0_ = NULL;
		Projects* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _project_it;
		_tmp0_ = projects_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = projects_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_projects_unref0 (_tmp1_);
		_project_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			Project* _tmp6_;
			Project _tmp7_;
			Project _tmp8_ = {0};
			Project _tmp9_;
			Project project;
			gchar* _tmp10_ = NULL;
			gchar* uri_directory;
			gchar* _tmp11_ = NULL;
			gchar* uri_main_file;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* dir;
			gint _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* main_file;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp19_ = {0};
			_tmp4_ = gee_iterator_next (_project_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_project_it);
			_tmp6_ = (Project*) _tmp5_;
			project_copy (_tmp6_, &_tmp8_);
			_tmp7_ = _tmp8_;
			_tmp9_ = _tmp7_;
			_project_free0 (_tmp6_);
			project = _tmp9_;
			_tmp10_ = g_file_get_parse_name (project.directory);
			uri_directory = _tmp10_;
			_tmp11_ = g_file_get_parse_name (project.main_file);
			uri_main_file = _tmp11_;
			_tmp12_ = utils_replace_home_dir_with_tilde (uri_directory);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp13_, "/", NULL);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp13_);
			dir = _tmp15_;
			_tmp16_ = strlen (uri_directory);
			_tmp17_ = strlen (uri_main_file);
			_tmp18_ = string_slice (uri_main_file, (glong) (_tmp16_ + 1), (glong) _tmp17_);
			main_file = _tmp18_;
			gtk_list_store_append (model, &_tmp19_);
			iter = _tmp19_;
			gtk_list_store_set (model, &iter, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, dir, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, main_file, -1, -1);
			_g_free0 (main_file);
			_g_free0 (dir);
			_g_free0 (uri_main_file);
			_g_free0 (uri_directory);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
}



