/* dialogs.c generated by valac 0.12.1, the Vala compiler
 * generated from dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define DIALOGS_TYPE_UNSAVED_DOC_COLUMN (dialogs_unsaved_doc_column_get_type ())

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block19Data Block19Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	DIALOGS_UNSAVED_DOC_COLUMN_SAVE,
	DIALOGS_UNSAVED_DOC_COLUMN_NAME,
	DIALOGS_UNSAVED_DOC_COLUMN_DOC,
	DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS
} DialogsUnsavedDocColumn;

struct _Block19Data {
	int _ref_count_;
	GtkListStore* store;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};



GType dialogs_unsaved_doc_column_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
void dialogs_close_several_unsaved_documents (MainWindow* window, GList* unsaved_docs);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (Block19Data* _data19_);
GType document_tab_get_type (void) G_GNUC_CONST;
const gchar* document_tab_get_label_text (DocumentTab* self);
static void _lambda84_ (const gchar* path_str, Block19Data* _data19_);
static void __lambda84__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
void main_window_remove_all_tabs (MainWindow* self);
GList* main_window_get_documents (MainWindow* self);
gboolean document_get_modified (Document* self);
gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);


GType dialogs_unsaved_doc_column_get_type (void) {
	static volatile gsize dialogs_unsaved_doc_column_type_id__volatile = 0;
	if (g_once_init_enter (&dialogs_unsaved_doc_column_type_id__volatile)) {
		static const GEnumValue values[] = {{DIALOGS_UNSAVED_DOC_COLUMN_SAVE, "DIALOGS_UNSAVED_DOC_COLUMN_SAVE", "save"}, {DIALOGS_UNSAVED_DOC_COLUMN_NAME, "DIALOGS_UNSAVED_DOC_COLUMN_NAME", "name"}, {DIALOGS_UNSAVED_DOC_COLUMN_DOC, "DIALOGS_UNSAVED_DOC_COLUMN_DOC", "doc"}, {DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS, "DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType dialogs_unsaved_doc_column_type_id;
		dialogs_unsaved_doc_column_type_id = g_enum_register_static ("DialogsUnsavedDocColumn", values);
		g_once_init_leave (&dialogs_unsaved_doc_column_type_id__volatile, dialogs_unsaved_doc_column_type_id);
	}
	return dialogs_unsaved_doc_column_type_id__volatile;
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (Block19Data* _data19_) {
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		_g_object_unref0 (_data19_->store);
		g_slice_free (Block19Data, _data19_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda84_ (const gchar* path_str, Block19Data* _data19_) {
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* path;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkTreeIter _tmp1_ = {0};
	g_return_if_fail (path_str != NULL);
	_tmp0_ = gtk_tree_path_new_from_string (path_str);
	path = _tmp0_;
	gtk_tree_model_get_iter ((GtkTreeModel*) _data19_->store, &_tmp1_, path);
	iter = _tmp1_;
	gtk_tree_model_get ((GtkTreeModel*) _data19_->store, &iter, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, &active, -1, -1);
	gtk_list_store_set (_data19_->store, &iter, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, !active, -1, -1);
	_gtk_tree_path_free0 (path);
}


static void __lambda84__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	_lambda84_ (path, self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void dialogs_close_several_unsaved_documents (MainWindow* window, GList* unsaved_docs) {
	Block19Data* _data19_;
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* dialog;
	GtkHBox* _tmp3_ = NULL;
	GtkHBox* hbox;
	GtkWidget* _tmp4_ = NULL;
	GtkVBox* _tmp5_;
	GtkVBox* content_area;
	GtkImage* _tmp6_ = NULL;
	GtkImage* image;
	GtkVBox* _tmp7_ = NULL;
	GtkVBox* vbox;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* primary_label;
	const gchar* _tmp9_ = NULL;
	guint _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkVBox* _tmp17_ = NULL;
	GtkVBox* vbox2;
	const gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* select_label;
	GtkTreeView* _tmp20_ = NULL;
	GtkTreeView* treeview;
	GtkListStore* _tmp21_ = NULL;
	GtkCellRendererToggle* _tmp25_ = NULL;
	GtkCellRendererToggle* renderer1;
	GtkTreeViewColumn* _tmp26_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererText* _tmp27_ = NULL;
	GtkCellRendererText* renderer2;
	GtkTreeViewColumn* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	GtkScrolledWindow* sw;
	const gchar* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	GtkLabel* secondary_label;
	gint _tmp32_;
	gint resp;
	g_return_if_fail (window != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_tmp0_ = g_list_length (unsaved_docs);
	g_return_if_fail (_tmp0_ >= 2);
	_tmp1_ = _ ("Close without Saving");
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, _tmp1_, GTK_RESPONSE_CLOSE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	dialog = g_object_ref_sink (_tmp2_);
	gtk_dialog_set_has_separator (dialog, FALSE);
	_tmp3_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	hbox = g_object_ref_sink (_tmp3_);
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 5);
	_tmp4_ = gtk_dialog_get_content_area (dialog);
	_tmp5_ = _g_object_ref0 (GTK_VBOX (_tmp4_));
	content_area = _tmp5_;
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
	_tmp6_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
	image = g_object_ref_sink (_tmp6_);
	gtk_misc_set_alignment ((GtkMisc*) image, (gfloat) 0.5, (gfloat) 0.0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp7_ = (GtkVBox*) gtk_vbox_new (FALSE, 12);
	vbox = g_object_ref_sink (_tmp7_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	_tmp8_ = (GtkLabel*) gtk_label_new (NULL);
	primary_label = g_object_ref_sink (_tmp8_);
	gtk_label_set_line_wrap (primary_label, TRUE);
	gtk_label_set_use_markup (primary_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) primary_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_label_set_selectable (primary_label, TRUE);
	_tmp9_ = _ ("There are %d documents with unsaved changes. Save changes before closi" \
"ng?");
	_tmp10_ = g_list_length (unsaved_docs);
	_tmp11_ = g_strdup_printf (_tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, "</span>", NULL);
	_tmp16_ = _tmp15_;
	gtk_label_set_markup (primary_label, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) primary_label, FALSE, FALSE, (guint) 0);
	_tmp17_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	vbox2 = g_object_ref_sink (_tmp17_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) vbox2, FALSE, FALSE, (guint) 0);
	_tmp18_ = _ ("Select the documents you want to save:");
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	select_label = g_object_ref_sink (_tmp19_);
	gtk_label_set_line_wrap (select_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) select_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) select_label, FALSE, FALSE, (guint) 0);
	_tmp20_ = (GtkTreeView*) gtk_tree_view_new ();
	treeview = g_object_ref_sink (_tmp20_);
	gtk_widget_set_size_request ((GtkWidget*) treeview, 260, 120);
	gtk_tree_view_set_headers_visible (treeview, FALSE);
	gtk_tree_view_set_enable_search (treeview, FALSE);
	_tmp21_ = gtk_list_store_new ((gint) DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, TYPE_DOCUMENT);
	_data19_->store = _tmp21_;
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = unsaved_docs;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp22_;
			Document* doc;
			_tmp22_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp22_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp23_ = {0};
				const gchar* _tmp24_ = NULL;
				gtk_list_store_append (_data19_->store, &_tmp23_);
				iter = _tmp23_;
				_tmp24_ = document_tab_get_label_text (doc->tab);
				gtk_list_store_set (_data19_->store, &iter, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, TRUE, DIALOGS_UNSAVED_DOC_COLUMN_NAME, _tmp24_, DIALOGS_UNSAVED_DOC_COLUMN_DOC, doc, -1, -1);
				_g_object_unref0 (doc);
			}
		}
	}
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) _data19_->store);
	_tmp25_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	renderer1 = g_object_ref_sink (_tmp25_);
	g_signal_connect_data (renderer1, "toggled", (GCallback) __lambda84__gtk_cell_renderer_toggle_toggled, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp26_ = gtk_tree_view_column_new_with_attributes ("Save?", (GtkCellRenderer*) renderer1, "active", DIALOGS_UNSAVED_DOC_COLUMN_SAVE, NULL, NULL);
	column = g_object_ref_sink (_tmp26_);
	gtk_tree_view_append_column (treeview, column);
	_tmp27_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer2 = g_object_ref_sink (_tmp27_);
	_tmp28_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) renderer2, "text", DIALOGS_UNSAVED_DOC_COLUMN_NAME, NULL, NULL);
	_g_object_unref0 (column);
	column = g_object_ref_sink (_tmp28_);
	gtk_tree_view_append_column (treeview, column);
	_tmp29_ = utils_add_scrollbar ((GtkWidget*) treeview);
	sw = GTK_SCROLLED_WINDOW (_tmp29_);
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	_tmp30_ = _ ("If you don't save, all your changes will be permanently lost.");
	_tmp31_ = (GtkLabel*) gtk_label_new (_tmp30_);
	secondary_label = g_object_ref_sink (_tmp31_);
	gtk_label_set_line_wrap (secondary_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) secondary_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_label_set_selectable (secondary_label, TRUE);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) secondary_label, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	_tmp32_ = gtk_dialog_run (dialog);
	resp = _tmp32_;
	if (resp == GTK_RESPONSE_CLOSE) {
		main_window_remove_all_tabs (window);
	} else {
		if (resp == GTK_RESPONSE_ACCEPT) {
			GList* _tmp33_ = NULL;
			GList* selected_docs;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp36_ = {0};
			gboolean _tmp37_;
			gboolean valid;
			_tmp33_ = main_window_get_documents (window);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = _tmp33_;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					Document* _tmp34_;
					Document* doc;
					_tmp34_ = _g_object_ref0 ((Document*) doc_it->data);
					doc = _tmp34_;
					{
						gboolean _tmp35_;
						_tmp35_ = document_get_modified (doc);
						if (!_tmp35_) {
							main_window_close_tab (window, doc->tab, FALSE);
						}
						_g_object_unref0 (doc);
					}
				}
				__g_list_free__g_object_unref0_0 (doc_collection);
			}
			selected_docs = NULL;
			_tmp37_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _data19_->store, &_tmp36_);
			iter = _tmp36_;
			valid = _tmp37_;
			while (TRUE) {
				gboolean selected = FALSE;
				Document* doc = NULL;
				gboolean _tmp39_;
				if (!valid) {
					break;
				}
				gtk_tree_model_get ((GtkTreeModel*) _data19_->store, &iter, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, &selected, DIALOGS_UNSAVED_DOC_COLUMN_DOC, &doc, -1, -1);
				if (selected) {
					Document* _tmp38_;
					_tmp38_ = _g_object_ref0 (doc);
					selected_docs = g_list_prepend (selected_docs, _tmp38_);
				} else {
					main_window_close_tab (window, doc->tab, TRUE);
				}
				_tmp39_ = gtk_tree_model_iter_next ((GtkTreeModel*) _data19_->store, &iter);
				valid = _tmp39_;
				_g_object_unref0 (doc);
			}
			selected_docs = g_list_reverse (selected_docs);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = selected_docs;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					Document* _tmp40_;
					Document* doc;
					_tmp40_ = _g_object_ref0 ((Document*) doc_it->data);
					doc = _tmp40_;
					{
						gboolean _tmp41_;
						_tmp41_ = main_window_save_document (window, doc, FALSE);
						if (_tmp41_) {
							main_window_close_tab (window, doc->tab, TRUE);
						}
						_g_object_unref0 (doc);
					}
				}
			}
			__g_list_free__g_object_unref0_0 (selected_docs);
		}
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (secondary_label);
	_g_object_unref0 (sw);
	_g_object_unref0 (renderer2);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer1);
	_g_object_unref0 (treeview);
	_g_object_unref0 (select_label);
	_g_object_unref0 (vbox2);
	_g_object_unref0 (primary_label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (image);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hbox);
	_g_object_unref0 (dialog);
	block19_data_unref (_data19_);
	_data19_ = NULL;
}



