/* build_tool_runner.c generated by valac 0.10.3, the Vala compiler
 * generated from build_tool_runner.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <glib/gi18n-lib.h>


#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
typedef struct _BuildToolRunnerPrivate BuildToolRunnerPrivate;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;

#define TYPE_PARTITION_STATE (partition_state_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POST_PROCESSOR, PostProcessorIface))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorIface PostProcessorIface;

#define TYPE_BUILD_ISSUE (build_issue_get_type ())

#define TYPE_BUILD_MESSAGE_TYPE (build_message_type_get_type ())
typedef struct _BuildIssue BuildIssue;

#define TYPE_NO_OUTPUT_POST_PROCESSOR (no_output_post_processor_get_type ())
#define NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessor))
#define NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))
#define IS_NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define IS_NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define NO_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))

typedef struct _NoOutputPostProcessor NoOutputPostProcessor;
typedef struct _NoOutputPostProcessorClass NoOutputPostProcessorClass;

#define TYPE_ALL_OUTPUT_POST_PROCESSOR (all_output_post_processor_get_type ())
#define ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessor))
#define ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))
#define IS_ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define IS_ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define ALL_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))

typedef struct _AllOutputPostProcessor AllOutputPostProcessor;
typedef struct _AllOutputPostProcessorClass AllOutputPostProcessorClass;

#define TYPE_RUBBER_POST_PROCESSOR (rubber_post_processor_get_type ())
#define RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor))
#define RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))
#define IS_RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RUBBER_POST_PROCESSOR))
#define IS_RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RUBBER_POST_PROCESSOR))
#define RUBBER_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))

typedef struct _RubberPostProcessor RubberPostProcessor;
typedef struct _RubberPostProcessorClass RubberPostProcessorClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BuildToolRunner {
	GObject parent_instance;
	BuildToolRunnerPrivate * priv;
};

struct _BuildToolRunnerClass {
	GObjectClass parent_class;
};

struct _BuildJob {
	gboolean must_succeed;
	char* post_processor;
	char* command;
	char** command_args;
	gint command_args_length1;
};

struct _BuildToolRunnerPrivate {
	GPid* child_pid;
	guint* handlers;
	gint handlers_length1;
	gint _handlers_size_;
	GIOChannel* out_channel;
	gboolean read_output;
	char* output;
	BuildView* view;
	gboolean compilation;
	char* document_view_program;
	GtkAction* action_stop_exec;
	GFile* file;
	char* filename;
	char* shortname;
	char* directory;
	GList* jobs;
	gint job_num;
	BuildJob current_job;
	GtkTreeIter root_partition;
	GtkTreeIter* job_partitions;
	gint job_partitions_length1;
	gint _job_partitions_size_;
};

struct _BuildTool {
	char* description;
	char* extensions;
	char* label;
	char* icon;
	gboolean compilation;
	GList* jobs;
};

typedef enum  {
	PARTITION_STATE_RUNNING,
	PARTITION_STATE_SUCCEEDED,
	PARTITION_STATE_FAILED,
	PARTITION_STATE_ABORTED
} PartitionState;

typedef enum  {
	BUILD_MESSAGE_TYPE_ERROR,
	BUILD_MESSAGE_TYPE_WARNING,
	BUILD_MESSAGE_TYPE_BADBOX,
	BUILD_MESSAGE_TYPE_OTHER
} BuildMessageType;

struct _BuildIssue {
	char* message;
	BuildMessageType message_type;
	char* filename;
	gint start_line;
	gint end_line;
};

struct _PostProcessorIface {
	GTypeInterface parent_iface;
	void (*process) (PostProcessor* self, GFile* file, const char* output, gint status);
	BuildIssue* (*get_issues) (PostProcessor* self, int* result_length1);
	gboolean (*get_successful) (PostProcessor* self);
	void (*set_successful) (PostProcessor* self, gboolean value);
};


static gpointer build_tool_runner_parent_class = NULL;

GType build_tool_runner_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
#define BUILD_TOOL_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerPrivate))
enum  {
	BUILD_TOOL_RUNNER_DUMMY_PROPERTY
};
#define BUILD_TOOL_RUNNER_POLL_INTERVAL 250
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
char* utils_get_shortname (const char* path);
char* utils_get_extension (const char* path);
static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle);
void build_view_clear (BuildView* self);
GType partition_state_get_type (void) G_GNUC_CONST;
void build_view_add_partition (BuildView* self, const char* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result);
static char** build_tool_runner_get_command (BuildToolRunner* self, BuildJob* build_job, gboolean basename, int* result_length1);
static void _vala_array_add3 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value);
static void build_tool_runner_proceed (BuildToolRunner* self);
BuildToolRunner* build_tool_runner_new_web_browser (GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct_web_browser (GType object_type, GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec);
static void build_tool_runner_execute (BuildToolRunner* self, char** command, int command_length1, const char* working_directory, GError** error);
static void _lambda57_ (BuildToolRunner* self);
static void __lambda57__gspawn_child_setup_func (gpointer self);
static GPid* _g_pid_dup (GPid* self);
static void build_tool_runner_on_exit (BuildToolRunner* self, GPid pid, gint status);
static void _build_tool_runner_on_exit_gchild_watch_func (GPid pid, gint status, gpointer self);
static void _vala_array_add4 (guint** array, int* length, int* size, guint value);
static gboolean build_tool_runner_on_output (BuildToolRunner* self);
static gboolean _build_tool_runner_on_output_gsource_func (gpointer self);
static void _vala_array_add5 (guint** array, int* length, int* size, guint value);
static void build_tool_runner_execute_without_output (BuildToolRunner* self, char** command, int command_length1, const char* working_directory, GError** error);
static void _vala_array_add6 (guint** array, int* length, int* size, guint value);
void build_tool_runner_abort (BuildToolRunner* self);
void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state);
GType build_issue_get_type (void) G_GNUC_CONST;
GType build_message_type_get_type (void) G_GNUC_CONST;
BuildIssue* build_issue_dup (const BuildIssue* self);
void build_issue_free (BuildIssue* self);
void build_issue_copy (const BuildIssue* self, BuildIssue* dest);
void build_issue_destroy (BuildIssue* self);
GType post_processor_get_type (void) G_GNUC_CONST;
NoOutputPostProcessor* no_output_post_processor_new (void);
NoOutputPostProcessor* no_output_post_processor_construct (GType object_type);
GType no_output_post_processor_get_type (void) G_GNUC_CONST;
AllOutputPostProcessor* all_output_post_processor_new (void);
AllOutputPostProcessor* all_output_post_processor_construct (GType object_type);
GType all_output_post_processor_get_type (void) G_GNUC_CONST;
RubberPostProcessor* rubber_post_processor_new (void);
RubberPostProcessor* rubber_post_processor_construct (GType object_type);
GType rubber_post_processor_get_type (void) G_GNUC_CONST;
void post_processor_process (PostProcessor* self, GFile* file, const char* output, gint status);
void build_view_append_issues (BuildView* self, GtkTreeIter* partition_id, BuildIssue* issues, int issues_length1);
BuildIssue* post_processor_get_issues (PostProcessor* self, int* result_length1);
static void _vala_BuildIssue_array_free (BuildIssue* array, gint array_length);
gboolean post_processor_get_successful (PostProcessor* self);
static void build_tool_runner_failed (BuildToolRunner* self);
static char** _vala_array_dup1 (char** self, int length);
static void _vala_array_add7 (char*** array, int* length, int* size, char* value);
static void _vala_array_add8 (char*** array, int* length, int* size, char* value);
static char** _vala_array_dup2 (char** self, int length);
static void build_tool_runner_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_vala_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add3 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTreeIter, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec) {
	BuildToolRunner * self = NULL;
	GFile* _tmp0_;
	GtkAction* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	GFile* _tmp4_;
	char* _tmp5_;
	GSettings* settings;
	char* _tmp6_;
	gint extensions_length1;
	gint _extensions_size_;
	char** _tmp8_;
	char** _tmp7_;
	char** extensions;
	gboolean _tmp9_ = FALSE;
	BuildView* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (action_stop_exec != NULL, NULL);
	self = (BuildToolRunner*) g_object_new (object_type, NULL);
	self->priv->file = (_tmp0_ = _g_object_ref0 (file), _g_object_unref0 (self->priv->file), _tmp0_);
	self->priv->compilation = (*tool).compilation;
	self->priv->action_stop_exec = (_tmp1_ = _g_object_ref0 (action_stop_exec), _g_object_unref0 (self->priv->action_stop_exec), _tmp1_);
	self->priv->filename = (_tmp2_ = g_file_get_parse_name (file), _g_free0 (self->priv->filename), _tmp2_);
	self->priv->shortname = (_tmp3_ = utils_get_shortname (self->priv->filename), _g_free0 (self->priv->shortname), _tmp3_);
	self->priv->directory = (_tmp5_ = g_file_get_parse_name (_tmp4_ = g_file_get_parent (file)), _g_free0 (self->priv->directory), _tmp5_);
	_g_object_unref0 (_tmp4_);
	settings = g_settings_new ("org.gnome.latexila.preferences.latex");
	self->priv->document_view_program = (_tmp6_ = g_settings_get_string (settings, "document-view-program"), _g_free0 (self->priv->document_view_program), _tmp6_);
	extensions = (_tmp8_ = _tmp7_ = g_strsplit ((*tool).extensions, " ", 0), extensions_length1 = _vala_array_length (_tmp7_), _extensions_size_ = extensions_length1, _tmp8_);
	if (string_get_length ((*tool).extensions) > 0) {
		char* _tmp10_;
		_tmp9_ = !_vala_string_array_contains (extensions, extensions_length1, _tmp10_ = utils_get_extension (self->priv->filename));
		_g_free0 (_tmp10_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		fprintf (stderr, "Warning: bad file extension\n");
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		return self;
	}
	self->priv->jobs = (*tool).jobs;
	self->priv->view = (_tmp11_ = _g_object_ref0 (view), _g_object_unref0 (self->priv->view), _tmp11_);
	build_view_clear (view);
	self->priv->root_partition = (build_view_add_partition (view, (*tool).label, PARTITION_STATE_RUNNING, NULL, TRUE, &_tmp12_), _tmp12_);
	{
		GList* job_collection;
		GList* job_it;
		job_collection = self->priv->jobs;
		for (job_it = job_collection; job_it != NULL; job_it = job_it->next) {
			BuildJob _tmp18_ = {0};
			BuildJob job;
			job = (build_job_copy ((BuildJob*) job_it->data, &_tmp18_), _tmp18_);
			{
				gint command_length1;
				gint _command_size_;
				char** _tmp14_;
				gint _tmp13_;
				char** command;
				char* _tmp15_;
				GtkTreeIter _tmp16_ = {0};
				GtkTreeIter _tmp17_;
				command = (_tmp14_ = build_tool_runner_get_command (self, &job, TRUE, &_tmp13_), command_length1 = _tmp13_, _command_size_ = command_length1, _tmp14_);
				_vala_array_add3 (&self->priv->job_partitions, &self->priv->job_partitions_length1, &self->priv->_job_partitions_size_, (_tmp17_ = (build_view_add_partition (view, _tmp15_ = g_strjoinv (" ", command), PARTITION_STATE_RUNNING, &self->priv->root_partition, FALSE, &_tmp16_), _tmp16_), &_tmp17_));
				_g_free0 (_tmp15_);
				command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
				build_job_destroy (&job);
			}
		}
	}
	gtk_action_set_sensitive (action_stop_exec, TRUE);
	build_tool_runner_proceed (self);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	return self;
}


BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec) {
	return build_tool_runner_construct (TYPE_BUILD_TOOL_RUNNER, file, tool, view, action_stop_exec);
}


static gpointer _build_job_dup0 (gpointer self) {
	return self ? build_job_dup (self) : NULL;
}


BuildToolRunner* build_tool_runner_construct_web_browser (GType object_type, GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec) {
	BuildToolRunner * self = NULL;
	GSettings* settings;
	BuildTool build_tool = {0};
	char* _tmp0_;
	char* _tmp1_;
	BuildJob build_job = {0};
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (action_stop_exec != NULL, NULL);
	settings = g_settings_new ("org.gnome.latexila.preferences.editor");
	memset (&build_tool, 0, sizeof (BuildTool));
	build_tool.extensions = (_tmp0_ = g_strdup (""), _g_free0 (build_tool.extensions), _tmp0_);
	build_tool.label = (_tmp1_ = g_strdup (label), _g_free0 (build_tool.label), _tmp1_);
	memset (&build_job, 0, sizeof (BuildJob));
	build_job.post_processor = (_tmp2_ = g_strdup ("no-output"), _g_free0 (build_job.post_processor), _tmp2_);
	build_job.must_succeed = TRUE;
	build_job.command = (_tmp4_ = g_strdup_printf ("%s $filename", _tmp3_ = g_settings_get_string (settings, "web-browser")), _g_free0 (build_job.command), _tmp4_);
	_g_free0 (_tmp3_);
	build_tool.jobs = g_list_append (build_tool.jobs, _build_job_dup0 (&build_job));
	self = (BuildToolRunner*) build_tool_runner_construct (object_type, file, &build_tool, view, action_stop_exec);
	build_job_destroy (&build_job);
	build_tool_destroy (&build_tool);
	_g_object_unref0 (settings);
	return self;
}


BuildToolRunner* build_tool_runner_new_web_browser (GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec) {
	return build_tool_runner_construct_web_browser (TYPE_BUILD_TOOL_RUNNER, file, label, view, action_stop_exec);
}


static void _lambda57_ (BuildToolRunner* self) {
	dup2 (STDOUT_FILENO, STDERR_FILENO);
}


static void __lambda57__gspawn_child_setup_func (gpointer self) {
	_lambda57_ (self);
}


static GPid* _g_pid_dup (GPid* self) {
	GPid* dup;
	dup = g_new0 (GPid, 1);
	memcpy (dup, self, sizeof (GPid));
	return dup;
}


static gpointer __g_pid_dup0 (gpointer self) {
	return self ? _g_pid_dup (self) : NULL;
}


static void _build_tool_runner_on_exit_gchild_watch_func (GPid pid, gint status, gpointer self) {
	build_tool_runner_on_exit (self, pid, status);
}


static void _vala_array_add4 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean _build_tool_runner_on_output_gsource_func (gpointer self) {
	gboolean result;
	result = build_tool_runner_on_output (self);
	return result;
}


static void _vala_array_add5 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void build_tool_runner_execute (BuildToolRunner* self, char** command, int command_length1, const char* working_directory, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint std_out = 0;
		GPid _tmp0_;
		GPid* _tmp1_;
		GIOChannel* _tmp2_;
		g_spawn_async_with_pipes (working_directory, command, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, __lambda57__gspawn_child_setup_func, self, &_tmp0_, NULL, &std_out, NULL, &_inner_error_);
		self->priv->child_pid = (_tmp1_ = __g_pid_dup0 (&_tmp0_), _g_free0 (self->priv->child_pid), _tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		_vala_array_add4 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, *self->priv->child_pid, _build_tool_runner_on_exit_gchild_watch_func, g_object_ref (self), g_object_unref));
		self->priv->out_channel = (_tmp2_ = g_io_channel_unix_new (std_out), _g_io_channel_unref0 (self->priv->out_channel), _tmp2_);
		g_io_channel_set_flags (self->priv->out_channel, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		_vala_array_add5 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BUILD_TOOL_RUNNER_POLL_INTERVAL, _build_tool_runner_on_output_gsource_func, g_object_ref (self), g_object_unref));
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = _g_error_copy0 (e);
			{
				_g_error_free0 (e);
				goto __finally14;
			}
			_g_error_free0 (e);
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _vala_array_add6 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void build_tool_runner_execute_without_output (BuildToolRunner* self, char** command, int command_length1, const char* working_directory, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->read_output = FALSE;
	{
		GPid _tmp0_;
		GPid* _tmp1_;
		g_spawn_async (working_directory, command, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp0_, &_inner_error_);
		self->priv->child_pid = (_tmp1_ = __g_pid_dup0 (&_tmp0_), _g_free0 (self->priv->child_pid), _tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_vala_array_add6 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, *self->priv->child_pid, _build_tool_runner_on_exit_gchild_watch_func, g_object_ref (self), g_object_unref));
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = _g_error_copy0 (e);
			{
				_g_error_free0 (e);
				goto __finally15;
			}
			_g_error_free0 (e);
		}
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void build_tool_runner_abort (BuildToolRunner* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->child_pid == NULL) {
		return;
	}
	{
		guint* handler_collection;
		int handler_collection_length1;
		int handler_it;
		handler_collection = self->priv->handlers;
		handler_collection_length1 = self->priv->handlers_length1;
		for (handler_it = 0; handler_it < self->priv->handlers_length1; handler_it = handler_it + 1) {
			guint handler;
			handler = handler_collection[handler_it];
			{
				g_source_remove (handler);
			}
		}
	}
	kill (*self->priv->child_pid, SIGTERM);
	gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
	build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_ABORTED);
	{
		gint i;
		i = self->priv->job_num;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->job_partitions_length1)) {
					break;
				}
				build_view_set_partition_state (self->priv->view, (_tmp1_ = self->priv->job_partitions[i], &_tmp1_), PARTITION_STATE_ABORTED);
			}
		}
	}
}


static gboolean build_tool_runner_on_output (BuildToolRunner* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (self->priv->read_output, FALSE);
	{
		char* text;
		gsize length = 0UL;
		char* _tmp0_ = NULL;
		char* _tmp1_;
		text = NULL;
		g_io_channel_read_to_end (self->priv->out_channel, &_tmp0_, &length, &_inner_error_);
		text = (_tmp1_ = _tmp0_, _g_free0 (text), _tmp1_);
		if (_inner_error_ != NULL) {
			_g_free0 (text);
			goto __catch16_g_error;
		}
		if (length > 0) {
			char* _tmp2_;
			self->priv->output = (_tmp2_ = g_strconcat (self->priv->output, text, NULL), _g_free0 (self->priv->output), _tmp2_);
		}
		_g_free0 (text);
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void _vala_BuildIssue_array_free (BuildIssue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			build_issue_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void build_tool_runner_on_exit (BuildToolRunner* self, GPid pid, gint status) {
	PostProcessor* post_processor;
	const char* _tmp4_;
	GQuark _tmp5_;
	static GQuark _tmp5__label0 = 0;
	static GQuark _tmp5__label1 = 0;
	static GQuark _tmp5__label2 = 0;
	gint _tmp6_;
	BuildIssue* _tmp7_;
	gint _tmp7__length1;
	GtkTreeIter _tmp8_;
	BuildIssue* _tmp9_;
	g_return_if_fail (self != NULL);
	{
		guint* handler_collection;
		int handler_collection_length1;
		int handler_it;
		handler_collection = self->priv->handlers;
		handler_collection_length1 = self->priv->handlers_length1;
		for (handler_it = 0; handler_it < self->priv->handlers_length1; handler_it = handler_it + 1) {
			guint handler;
			handler = handler_collection[handler_it];
			{
				g_source_remove (handler);
			}
		}
	}
	if (self->priv->read_output) {
		build_tool_runner_on_output (self);
	}
	post_processor = NULL;
	_tmp4_ = self->priv->current_job.post_processor;
	_tmp5_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp5_ == ((0 != _tmp5__label0) ? _tmp5__label0 : (_tmp5__label0 = g_quark_from_static_string ("no-output"))))
	switch (0) {
		default:
		{
			PostProcessor* _tmp0_;
			post_processor = (_tmp0_ = (PostProcessor*) no_output_post_processor_new (), _g_object_unref0 (post_processor), _tmp0_);
			break;
		}
	} else if (_tmp5_ == ((0 != _tmp5__label1) ? _tmp5__label1 : (_tmp5__label1 = g_quark_from_static_string ("all-output"))))
	switch (0) {
		default:
		{
			PostProcessor* _tmp1_;
			post_processor = (_tmp1_ = (PostProcessor*) all_output_post_processor_new (), _g_object_unref0 (post_processor), _tmp1_);
			break;
		}
	} else if (_tmp5_ == ((0 != _tmp5__label2) ? _tmp5__label2 : (_tmp5__label2 = g_quark_from_static_string ("rubber"))))
	switch (0) {
		default:
		{
			PostProcessor* _tmp2_;
			post_processor = (_tmp2_ = (PostProcessor*) rubber_post_processor_new (), _g_object_unref0 (post_processor), _tmp2_);
			break;
		}
	} else
	switch (0) {
		default:
		{
			PostProcessor* _tmp3_;
			fprintf (stderr, "Warning: unknown post processor \"%s\". Use no-output.", self->priv->current_job.post_processor);
			post_processor = (_tmp3_ = (PostProcessor*) no_output_post_processor_new (), _g_object_unref0 (post_processor), _tmp3_);
			break;
		}
	}
	post_processor_process (post_processor, self->priv->file, self->priv->output, status);
	_tmp9_ = (_tmp7_ = post_processor_get_issues (post_processor, &_tmp6_), _tmp7__length1 = _tmp6_, _tmp7_);
	build_view_append_issues (self->priv->view, (_tmp8_ = self->priv->job_partitions[self->priv->job_num], &_tmp8_), _tmp9_, _tmp6_);
	_tmp7_ = (_vala_BuildIssue_array_free (_tmp7_, _tmp7__length1), NULL);
	if (post_processor_get_successful (post_processor)) {
		GtkTreeIter _tmp10_;
		build_view_set_partition_state (self->priv->view, (_tmp10_ = self->priv->job_partitions[self->priv->job_num], &_tmp10_), PARTITION_STATE_SUCCEEDED);
		self->priv->job_num++;
		build_tool_runner_proceed (self);
	} else {
		GtkTreeIter _tmp11_;
		build_view_set_partition_state (self->priv->view, (_tmp11_ = self->priv->job_partitions[self->priv->job_num], &_tmp11_), PARTITION_STATE_FAILED);
		if (self->priv->current_job.must_succeed) {
			build_tool_runner_failed (self);
		} else {
			self->priv->job_num++;
			build_tool_runner_proceed (self);
		}
	}
	_g_object_unref0 (post_processor);
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static void build_tool_runner_proceed (BuildToolRunner* self) {
	char* _tmp0_;
	gint command_length1;
	gint _command_size_;
	char** _tmp2_;
	gint _tmp1_;
	char** command;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->job_num >= g_list_length (self->priv->jobs)) {
		build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_SUCCEEDED);
		gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
		g_signal_emit_by_name (self, "finished");
		return;
	}
	self->priv->output = (_tmp0_ = g_strdup (""), _g_free0 (self->priv->output), _tmp0_);
	self->priv->current_job = *((BuildJob*) g_list_nth_data (self->priv->jobs, (guint) self->priv->job_num));
	command = (_tmp2_ = build_tool_runner_get_command (self, &self->priv->current_job, FALSE, &_tmp1_), command_length1 = _tmp1_, _command_size_ = command_length1, _tmp2_);
	{
		if (_vala_strcmp0 (self->priv->current_job.post_processor, "no-output") == 0) {
			build_tool_runner_execute_without_output (self, command, command_length1, self->priv->directory, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
		} else {
			if (string_contains (self->priv->filename, " ")) {
				gint issues_length1;
				gint _issues_size_;
				BuildIssue* _tmp3_;
				BuildIssue* issues;
				BuildIssue issue = {0};
				char* _tmp4_;
				char* _tmp5_;
				BuildIssue _tmp6_ = {0};
				BuildIssue _tmp7_;
				GtkTreeIter _tmp8_;
				issues = (_tmp3_ = g_new0 (BuildIssue, 1), issues_length1 = 1, _issues_size_ = issues_length1, _tmp3_);
				memset (&issue, 0, sizeof (BuildIssue));
				issue.message = (_tmp4_ = g_strdup (_ ("Rubber may not support filenames with spaces (even in a directory)")), _g_free0 (issue.message), _tmp4_);
				issue.message_type = BUILD_MESSAGE_TYPE_WARNING;
				issue.filename = (_tmp5_ = g_strdup (self->priv->filename), _g_free0 (issue.filename), _tmp5_);
				issues[0] = (_tmp7_ = (build_issue_copy (&issue, &_tmp6_), _tmp6_), build_issue_destroy (&issues[0]), _tmp7_);
				build_view_append_issues (self->priv->view, (_tmp8_ = self->priv->job_partitions[self->priv->job_num], &_tmp8_), issues, issues_length1);
				build_issue_destroy (&issue);
				issues = (_vala_BuildIssue_array_free (issues, issues_length1), NULL);
			}
			build_tool_runner_execute (self, command, command_length1, self->priv->directory, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkTreeIter _tmp9_;
			GtkTreeIter _tmp10_;
			GtkTreeIter _tmp11_ = {0};
			build_view_set_partition_state (self->priv->view, (_tmp9_ = self->priv->job_partitions[self->priv->job_num], &_tmp9_), PARTITION_STATE_FAILED);
			build_view_add_partition (self->priv->view, e->message, PARTITION_STATE_FAILED, (_tmp10_ = self->priv->job_partitions[self->priv->job_num], &_tmp10_), FALSE, &_tmp11_);
			_tmp11_;
			if (self->priv->current_job.must_succeed) {
				build_tool_runner_failed (self);
			} else {
				self->priv->job_num++;
				build_tool_runner_proceed (self);
			}
			_g_error_free0 (e);
		}
	}
	__finally17:
	if (_inner_error_ != NULL) {
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _vala_array_add7 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static char* g_unichar_to_string (gunichar self) {
	char* result = NULL;
	char* str;
	str = (char*) g_new0 (gchar, 7);
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static void _vala_array_add8 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static char** build_tool_runner_get_command (BuildToolRunner* self, BuildJob* build_job, gboolean basename, int* result_length1) {
	char** result = NULL;
	char* base_filename;
	char* base_shortname;
	gint command_length1;
	gint _command_size_;
	char** _tmp3_;
	char** _tmp2_ = NULL;
	char** command;
	char** _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	base_filename = NULL;
	base_shortname = NULL;
	if (basename) {
		char* _tmp0_;
		char* _tmp1_;
		base_filename = (_tmp0_ = g_file_get_basename (self->priv->file), _g_free0 (base_filename), _tmp0_);
		base_shortname = (_tmp1_ = utils_get_shortname (base_filename), _g_free0 (base_shortname), _tmp1_);
	}
	command = (_tmp3_ = (_tmp2_ = g_new0 (char*, 0 + 1), _tmp2_), command_length1 = 0, _command_size_ = command_length1, _tmp3_);
	if ((*build_job).command_args != NULL) {
		char** _tmp4_;
		char** _tmp5_;
		command = (_tmp5_ = (_tmp4_ = (*build_job).command_args, (_tmp4_ == NULL) ? ((gpointer) _tmp4_) : _vala_array_dup1 (_tmp4_, (*build_job).command_args_length1)), command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL), command_length1 = (*build_job).command_args_length1, _command_size_ = command_length1, _tmp5_);
	} else {
		gint args_length1;
		gint _args_size_;
		char** _tmp7_;
		char** _tmp6_;
		char** args;
		char* arg_buf;
		char* delimiter;
		char** _tmp16_;
		char** _tmp17_;
		args = (_tmp7_ = _tmp6_ = g_strsplit ((*build_job).command, " ", 0), args_length1 = _vala_array_length (_tmp6_), _args_size_ = args_length1, _tmp7_);
		arg_buf = g_strdup ("");
		delimiter = NULL;
		{
			char** arg_collection;
			int arg_collection_length1;
			int arg_it;
			arg_collection = args;
			arg_collection_length1 = args_length1;
			for (arg_it = 0; arg_it < args_length1; arg_it = arg_it + 1) {
				char* arg;
				arg = g_strdup (arg_collection[arg_it]);
				{
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					if (delimiter != NULL) {
						char* _tmp8_;
						char* _tmp9_;
						arg_buf = (_tmp9_ = g_strconcat (arg_buf, _tmp8_ = g_strconcat (" ", arg, NULL), NULL), _g_free0 (arg_buf), _tmp9_);
						_g_free0 (_tmp8_);
						if (g_str_has_suffix (arg, delimiter)) {
							char* _tmp10_;
							delimiter = (_tmp10_ = NULL, _g_free0 (delimiter), _tmp10_);
							_vala_array_add7 (&command, &command_length1, &_command_size_, g_strdup (arg_buf));
						}
						_g_free0 (arg);
						continue;
					}
					if (g_str_has_prefix (arg, "'")) {
						_tmp12_ = !g_str_has_suffix (arg, "'");
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						_tmp11_ = TRUE;
					} else {
						gboolean _tmp13_ = FALSE;
						if (g_str_has_prefix (arg, "\"")) {
							_tmp13_ = !g_str_has_suffix (arg, "\"");
						} else {
							_tmp13_ = FALSE;
						}
						_tmp11_ = _tmp13_;
					}
					if (_tmp11_) {
						char* _tmp14_;
						char* _tmp15_;
						delimiter = (_tmp14_ = g_unichar_to_string (g_utf8_get_char (g_utf8_offset_to_pointer (arg, 0))), _g_free0 (delimiter), _tmp14_);
						arg_buf = (_tmp15_ = g_strdup (arg), _g_free0 (arg_buf), _tmp15_);
						_g_free0 (arg);
						continue;
					}
					_vala_array_add8 (&command, &command_length1, &_command_size_, g_strdup (arg));
					_g_free0 (arg);
				}
			}
		}
		(*build_job).command_args = (_tmp17_ = (_tmp16_ = command, (_tmp16_ == NULL) ? ((gpointer) _tmp16_) : _vala_array_dup2 (_tmp16_, command_length1)), (*build_job).command_args = (_vala_array_free ((*build_job).command_args, (*build_job).command_args_length1, (GDestroyNotify) g_free), NULL), (*build_job).command_args_length1 = command_length1, _tmp17_);
		_g_free0 (delimiter);
		_g_free0 (arg_buf);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp18_;
			_tmp18_ = TRUE;
			while (TRUE) {
				if (!_tmp18_) {
					i++;
				}
				_tmp18_ = FALSE;
				if (!(i < command_length1)) {
					break;
				}
				if (string_contains (command[i], "$view")) {
					char* _tmp19_;
					command[i] = (_tmp19_ = string_replace (command[i], "$view", self->priv->document_view_program), _g_free0 (command[i]), _tmp19_);
					continue;
				}
				if (string_contains (command[i], "$filename")) {
					char* _tmp20_;
					char* _tmp22_;
					_tmp20_ = g_strdup (base_filename);
					if (_tmp20_ == NULL) {
						char* _tmp21_;
						_tmp20_ = (_tmp21_ = g_strdup (self->priv->filename), _g_free0 (_tmp20_), _tmp21_);
					}
					command[i] = (_tmp22_ = string_replace (command[i], "$filename", _tmp20_), _g_free0 (command[i]), _tmp22_);
					_g_free0 (_tmp20_);
					continue;
				}
				if (string_contains (command[i], "$shortname")) {
					char* _tmp23_;
					char* _tmp25_;
					_tmp23_ = g_strdup (base_shortname);
					if (_tmp23_ == NULL) {
						char* _tmp24_;
						_tmp23_ = (_tmp24_ = g_strdup (self->priv->shortname), _g_free0 (_tmp23_), _tmp24_);
					}
					command[i] = (_tmp25_ = string_replace (command[i], "$shortname", _tmp23_), _g_free0 (command[i]), _tmp25_);
					_g_free0 (_tmp23_);
					continue;
				}
			}
		}
	}
	result = (_tmp26_ = command, *result_length1 = command_length1, _tmp26_);
	_g_free0 (base_shortname);
	_g_free0 (base_filename);
	return result;
	command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (base_shortname);
	_g_free0 (base_filename);
}


static void build_tool_runner_failed (BuildToolRunner* self) {
	g_return_if_fail (self != NULL);
	build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_FAILED);
	{
		gint i;
		i = self->priv->job_num + 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->job_partitions_length1)) {
					break;
				}
				build_view_set_partition_state (self->priv->view, (_tmp1_ = self->priv->job_partitions[i], &_tmp1_), PARTITION_STATE_ABORTED);
			}
		}
	}
	gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
}


static void build_tool_runner_class_init (BuildToolRunnerClass * klass) {
	build_tool_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolRunnerPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_runner_finalize;
	g_signal_new ("finished", TYPE_BUILD_TOOL_RUNNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void build_tool_runner_instance_init (BuildToolRunner * self) {
	guint* _tmp0_ = NULL;
	self->priv = BUILD_TOOL_RUNNER_GET_PRIVATE (self);
	self->priv->child_pid = NULL;
	self->priv->handlers = (_tmp0_ = g_new0 (guint, 0), _tmp0_);
	self->priv->handlers_length1 = 0;
	self->priv->_handlers_size_ = self->priv->handlers_length1;
	self->priv->read_output = TRUE;
	self->priv->output = g_strdup ("");
	self->priv->job_num = 0;
}


static void build_tool_runner_finalize (GObject* obj) {
	BuildToolRunner * self;
	self = BUILD_TOOL_RUNNER (obj);
	_g_free0 (self->priv->child_pid);
	self->priv->handlers = (g_free (self->priv->handlers), NULL);
	_g_io_channel_unref0 (self->priv->out_channel);
	_g_free0 (self->priv->output);
	_g_object_unref0 (self->priv->view);
	_g_free0 (self->priv->document_view_program);
	_g_object_unref0 (self->priv->action_stop_exec);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->filename);
	_g_free0 (self->priv->shortname);
	_g_free0 (self->priv->directory);
	self->priv->job_partitions = (g_free (self->priv->job_partitions), NULL);
	G_OBJECT_CLASS (build_tool_runner_parent_class)->finalize (obj);
}


GType build_tool_runner_get_type (void) {
	static volatile gsize build_tool_runner_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolRunner), 0, (GInstanceInitFunc) build_tool_runner_instance_init, NULL };
		GType build_tool_runner_type_id;
		build_tool_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolRunner", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_runner_type_id__volatile, build_tool_runner_type_id);
	}
	return build_tool_runner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




