/*
 * TestLaTeXDrawNumber.java
 */
package junit.test;

import junit.framework.TestCase;
import latexDraw.util.LaTeXDrawNumber;

import org.junit.Test;

/** 
 * This class contains tests the methods of the class <code>LaTeXDrawNumber</code>.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 12/18/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestLaTeXDrawNumber extends TestCase
{
	
	@Test
	public void testGetCutNumberFloat()
	{
		float value = 0.0001f;
		
		assertEquals(value, LaTeXDrawNumber.getCutNumber(value, 0.000001));
		assertEquals(0f, LaTeXDrawNumber.getCutNumber(value, 0.1));
		assert(LaTeXDrawNumber.getCutNumber(value, 0.00001)==0f);
		assert(LaTeXDrawNumber.getCutNumber(value, 0.1)==value);
		
		value = -0.001f;
		assertEquals(value, LaTeXDrawNumber.getCutNumber(value, 0.000001));
		assertEquals(0f, LaTeXDrawNumber.getCutNumber(value, 1));
		assert(LaTeXDrawNumber.getCutNumber(value, 0.00001)==0f);
		assert(LaTeXDrawNumber.getCutNumber(value, 0.1)==value);
	}
	
	
	
	@Test
	public void testGetCutNumberDouble()
	{
		double value = 0.0001;
		
		assertEquals(value, LaTeXDrawNumber.getCutNumber(value, 0.000001));
		assertEquals(0., LaTeXDrawNumber.getCutNumber(value, 0.1));
		assert(LaTeXDrawNumber.getCutNumber(value, 0.00001)==0.);
		assert(LaTeXDrawNumber.getCutNumber(value, 0.1)==value);
		
		value = -0.001;
		assertEquals(value, LaTeXDrawNumber.getCutNumber(value, 0.000001));
		assertEquals(0., LaTeXDrawNumber.getCutNumber(value, 1));
		assert(LaTeXDrawNumber.getCutNumber(value, 0.00001)==0.);
		assert(LaTeXDrawNumber.getCutNumber(value, 0.1)==value);
	}
}


