package latexDraw.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.ui.dialog.PreferencesFrame;
import latexDraw.util.LaTeXDrawException;
import latexDraw.util.LaTeXDrawNamespace;
import latexDraw.util.LaTeXDrawPath;

/** 
 * This class defines the localisation.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 09/01/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public abstract class LaTeXDrawLang
{
	/** The name of the file where preferences are saved */
	public static final String PREF_FILENAME = ".preferences";//$NON-NLS-1$
	
	public static final String LANG_EN = "English";//$NON-NLS-1$
	
	public static final String LANG_EN_US = "English-US";//$NON-NLS-1$
	
	public static final String LANG_FR = "Français";//$NON-NLS-1$
	
	public static final String LANG_ES = "Español";//$NON-NLS-1$
	
	public static final String LANG_DE = "Deutsch";//$NON-NLS-1$
	
	public static final String LANG_IT = "Italiano";//$NON-NLS-1$
	
	public static final String LANG_PL = "Język polski";//$NON-NLS-1$
	
	public static final String MISSING_KEY = "missingKey";//$NON-NLS-1$
	
	private static String langCurrent = readLang();

	public static final String TOKEN_LANG_EN = "lang.en";//$NON-NLS-1$
	
	public static final String TOKEN_LANG_EN_US = "lang.en-US";//$NON-NLS-1$
	
	public static final String TOKEN_LANG_FR = "lang.fr";//$NON-NLS-1$
	
	public static final String TOKEN_LANG_ES = "lang.es";//$NON-NLS-1$

	public static final String TOKEN_LANG_DE = "lang.de";//$NON-NLS-1$
	
	public static final String TOKEN_LANG_IT = "lang.it";//$NON-NLS-1$
	
	public static final String TOKEN_LANG_PL = "lang.pl";//$NON-NLS-1$
	
	public static final String LANG_DEFAULT = LANG_EN;
	
	private static ResourceBundle resourceBundleLaTeXDrawFrame = ResourceBundle.getBundle(
							LaTeXDrawLang.getTokenLang()+".LaTeXDrawFrame");//$NON-NLS-1$

	private static ResourceBundle resourceBundleDialogFrame = ResourceBundle.getBundle(
							LaTeXDrawLang.getTokenLang()+".dialogFrames");//$NON-NLS-1$

	private static ResourceBundle resourceBundleOthers = ResourceBundle.getBundle(
							LaTeXDrawLang.getTokenLang()+".others"); //$NON-NLS-1$

	private static ResourceBundle resourceBundle1_6 = ResourceBundle.getBundle(
							LaTeXDrawLang.getTokenLang()+".1_6"); //$NON-NLS-1$
	
	private static ResourceBundle resourceBundle1_7 = ResourceBundle.getBundle(
							LaTeXDrawLang.getTokenLang()+".1_7"); //$NON-NLS-1$
	
	private static ResourceBundle resourceBundle1_8 = ResourceBundle.getBundle(
							LaTeXDrawLang.getTokenLang()+".1_8"); //$NON-NLS-1$
	
	private static ResourceBundle resourceBundle1_9 = ResourceBundle.getBundle(
							LaTeXDrawLang.getTokenLang()+".1_9"); //$NON-NLS-1$


	/**
	 * Allows to get a string of the others components
	 * @param key The key of the string
	 * @return The string
	 */
	public static String getOthersString(String key)
	{
		try { return resourceBundleOthers.getString(key); } 
		catch(MissingResourceException e)	{ return '!' + key + '!'; }
		catch(NullPointerException e) 		{ return '!' + MISSING_KEY + '!'; }
	}
	

	
	
	/**
	 * Allows to get a string of the LaTeXDrawFrame
	 * @param key The key of the string
	 * @return The string
	 */
	public static String getStringLaTeXDrawFrame(String key)
	{
		try { return resourceBundleLaTeXDrawFrame.getString(key); }
		catch(MissingResourceException e) { return '!' + key + '!'; }
		catch(NullPointerException e) 	  { return '!' + MISSING_KEY + '!'; }
	}
	
	
	
	/**
	 * Allows to get a string of the new 1.6 strings.
	 * @param key The key of the string.
	 * @return The string.
	 */
	public static String getString1_6(String key)
	{
		try { return resourceBundle1_6.getString(key); }
		catch(MissingResourceException e) { return '!' + key + '!'; }
		catch(NullPointerException e) 	  { return '!' + MISSING_KEY + '!'; }
	}
	
	
	
	/**
	 * Allows to get a string of the new 1.7 strings.
	 * @param key The key of the string.
	 * @return The string.
	 * @since 1.7
	 */
	public static String getString1_7(String key)
	{
		try { return resourceBundle1_7.getString(key); }
		catch(MissingResourceException e) { return '!' + key + '!'; }
		catch(NullPointerException e) 	  { return '!' + MISSING_KEY + '!'; }
	}
	
	
	
	/**
	 * Allows to get a string of the new 1.8 strings.
	 * @param key The key of the string.
	 * @return The string.
	 * @since 1.8
	 */
	public static String getString1_8(String key)
	{
		try { return resourceBundle1_8.getString(key); }
		catch(MissingResourceException e) { return '!' + key + '!'; }
		catch(NullPointerException e) 	  { return '!' + MISSING_KEY + '!'; }
	}
	
	
	
	/**
	 * Allows to get a string of the new 1.8 strings.
	 * @param key The key of the string.
	 * @return The string.
	 * @since 1.8
	 */
	public static String getString1_9(String key)
	{
		try { return resourceBundle1_9.getString(key); }
		catch(MissingResourceException e) { return '!' + key + '!'; }
		catch(NullPointerException e) 	  { return '!' + MISSING_KEY + '!'; }
	}
	
	
	
	/**
	 * Allows to get a string of the dialog frames.
	 * @param key The key of the string.
	 * @return The string.
	 */
	public static String getDialogFrameString(String key)
	{
		try { return resourceBundleDialogFrame.getString(key); } 
		catch (MissingResourceException e) { return '!' + key + '!'; }
		catch(NullPointerException e) 		 { return '!' + MISSING_KEY + '!'; }
	}
	
	
	
	
	
	/**
	 * Allows to get the language of the program.<br>
	 * @return The language.
	 */
	public static String readLang()
	{
		try 
		{
			File xml = new File(LaTeXDrawPath.PATH_PREFERENCES_XML_FILE);
			
			if(xml.exists())
			{
	            DocumentBuilderFactory fabrique = DocumentBuilderFactory.newInstance();
	            DocumentBuilder constructeur = fabrique.newDocumentBuilder();
	            Document document = constructeur.parse(xml);
	            Node n = document.getFirstChild();
	            NodeList nl;
	            
	            if(n==null || !n.getNodeName().equals(LaTeXDrawNamespace.XML_ROOT_PREFERENCES))
	            	throw new NullPointerException();
	            
	            nl = n.getChildNodes();
	            
	            for(int i=0, size=nl.getLength() ; i<size; i++)
	            	if(nl.item(i).getNodeName().equals(LaTeXDrawNamespace.XML_LANG))
	            		return nl.item(i).getTextContent();
			}
			else
			{
				InputStream is = new FileInputStream(new File(LaTeXDrawPath.PATH_PREFERENCES_FILE_OLD));
				ObjectInputStream in = new ObjectInputStream(is);
				Object o = in.readObject();
	
				if(!(o instanceof String) || !((String)o).equals(PreferencesFrame.LABEL_PREFERENCES))
					throw new LaTeXDrawException(LaTeXDrawException.NOT_TEXDRAW_FILE);
				
				o = in.readObject();
				in.readBoolean();
				in.readBoolean();
				in.readBoolean();
				in.readBoolean();
				in.readObject();
				in.readObject();
				in.readBoolean();
				in.readBoolean();
				in.readBoolean();
				in.readBoolean();
				in.readBoolean();
				in.readObject();
				in.readBoolean();
				
				if(((String)o).compareTo(LaTeXDrawFrame.VERSION)<=0)
				{
					in.readBoolean();
					return (String)in.readObject();
				}
				
				in.close();
				is.close();
			}
		}
		catch(Exception e) 
		{ 
			String userLang = System.getProperty("user.language"); //$NON-NLS-1$
		
			if(userLang.equals("fr")) //$NON-NLS-1$
				return LaTeXDrawLang.LANG_FR;
			
			if(userLang.equals("es")) //$NON-NLS-1$
				return LaTeXDrawLang.LANG_ES;

			if(userLang.equals("de")) //$NON-NLS-1$
				return LaTeXDrawLang.LANG_DE;
			
			if(userLang.equals("it")) //$NON-NLS-1$
				return LaTeXDrawLang.LANG_IT;
			
			if(userLang.equals("pl")) //$NON-NLS-1$
				return LaTeXDrawLang.LANG_PL;
			
			return LaTeXDrawLang.LANG_DEFAULT; 
		}
		
		return LaTeXDrawLang.LANG_DEFAULT;
	}

	
	
	
	/**
	 * Allows to get the language of the package.
	 * @return The language of the package.
	 */
	public static final String getTokenLang()
	{
		if(langCurrent==null)
		{
			String userLang = System.getProperty("user.language");//$NON-NLS-1$
			
			if(userLang.equals("fr"))//$NON-NLS-1$
				return  TOKEN_LANG_FR;
			
			if(userLang.equals("es"))//$NON-NLS-1$
				return TOKEN_LANG_ES;

			if(userLang.equals("de"))//$NON-NLS-1$
				return TOKEN_LANG_DE;
			
			if(userLang.equals("it"))//$NON-NLS-1$
				return TOKEN_LANG_IT;
			
			if(userLang.equals("pl"))//$NON-NLS-1$
				return TOKEN_LANG_PL;
			
			return TOKEN_LANG_EN;
		}
		
		if(langCurrent.equals(LANG_ES))
			return TOKEN_LANG_ES;
		
		if(langCurrent.equals(LANG_FR))
			return TOKEN_LANG_FR;
		
		if(langCurrent.equals(LANG_EN_US))
			return TOKEN_LANG_EN_US;
		
		if(langCurrent.equals(LANG_DE))
			return TOKEN_LANG_DE;
		
		if(langCurrent.equals(LANG_IT))
			return TOKEN_LANG_IT;
		
		if(langCurrent.equals(LANG_PL))
			return TOKEN_LANG_PL;
		 
		return TOKEN_LANG_EN;
	}
	
	
	
	/**
	 * @return the current language.
	 */
	public static String getlangCurrent()
	{
		return langCurrent;
	}

	
	
	/**
	 * @param lang the language to set.
	 */
	public static void setlangCurrent(String lang)
	{
		if(lang!=null && (lang.equals(LANG_DE) || 
			lang.equals(LANG_EN) || lang.equals(LANG_EN_US) ||
			lang.equals(LANG_ES) || lang.equals(LANG_FR) || 
			lang.equals(LANG_IT) || lang.equals(LANG_PL)))
			langCurrent = lang;
	}
}
