package latexDraw.parsers.svg.elements.path;

/**
 * Defines the SVGPath quadratic curveto segment.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/20/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1
 */
public class SVGPathSegCurvetoQuadratic extends SVGPathSeg
{
	/** The X-coordinate of the second point of the curve. @since 0.1 */
	protected double x;
	
	/** The Y-coordinate of the second point of the curve. @since 0.1 */
	protected double y;
	
	/** The x-coordinate of the first control point. @since 0.1 */
	protected double x1;
	
	/** The y-coordinate of the first control point. @since 0.1 */
	protected double y1;
	
	
	/**
	 * The main constructor.
	 * @param x The X-coordinate of the second point of the curve.
	 * @param y The Y-coordinate of the second point of the curve.
	 * @param x1 The x-coordinate of the first control point.
	 * @param y1 The y-coordinate of the first control point
	 * @param isRelative isRelative True: the path segment is relative, false it is absolute.
	 */
	public SVGPathSegCurvetoQuadratic(double x, double y, double x1, double y1, boolean isRelative)
	{
		super(isRelative);
		
		this.x = x;
		this.y = y;
		this.x1 = x1;
		this.y1 = y1;
	}
	
	
	
	@Override
	public String toString()
	{
		StringBuffer stringBuffer = new StringBuffer();
		
		stringBuffer.append((isRelative() ? "q" : "Q")); //$NON-NLS-1$ //$NON-NLS-2$
		stringBuffer.append(' ');
		stringBuffer.append(x1);
		stringBuffer.append(' ');
		stringBuffer.append(y1);
		stringBuffer.append(' ');
		stringBuffer.append(x);
		stringBuffer.append(' ');
		stringBuffer.append(y);
		
		return stringBuffer.toString();
	}
	
	
	
	/**
	 * @return the x.
	 * @since 0.1
	 */
	public double getX()
	{
		return x;
	}

	
	/**
	 * @return the y.
	 * @since 0.1
	 */
	public double getY()
	{
		return y;
	}

	
	/**
	 * @return the x1.
	 * @since 0.1
	 */
	public double getX1()
	{
		return x1;
	}

	
	/**
	 * @return the y1.
	 * @since 0.1
	 */
	public double getY1()
	{
		return y1;
	}


	@Override
	public PathSeg getType()
	{
		return isRelative() ? PathSeg.CURVETO_QUADRATIC_REL : PathSeg.CURVETO_QUADRATIC_ABS;
	}
}
