package latexDraw.parsers.svg.elements;

import java.awt.geom.Point2D;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGDocument;

import org.w3c.dom.Node;

/**
 * Defines a model for shapes that have the <code>points</code> SVG attribute.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 09/11/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1
 */
public abstract class AbstractPointsElement extends SVGElement
{
	public AbstractPointsElement(Node n, SVGElement p) throws MalformedSVGDocument
	{
		super(n, p);
	}
	
	
	
	public AbstractPointsElement(SVGDocument doc)
	{
		super(doc);
		
		setAttribute(SVGAttributes.SVG_POINTS, "0,0 1,1");//$NON-NLS-1$
	}



	@Override
	public boolean checkAttributes()
	{
		Vector<Point2D> pts = getPoints()==null ? null : getPoints2D();
		
		return pts!=null && pts.size()>1;
	}
	
	
	
	/**
	 * @return The points that make up the shape.
	 * @since 0.1
	 */
	public String getPoints()
	{
		return getAttribute(getUsablePrefix()+SVGAttributes.SVG_POINTS);
	}

	
	
	/**
	 * @return The set of points in the Point2D format or null if the format of <code>points</code> is not valid.
	 * @since 0.1
	 */
	public Vector<Point2D> getPoints2D()
	{
		boolean again;
		Vector<Point2D> pts = new Vector<Point2D>();
		
		try
		{
			String s = getPoints();
			s = s.replaceAll("[ \t\n\r\f]+", " ");//$NON-NLS-1$//$NON-NLS-2$
			s = s.replaceAll("[ \t\n\r\f]*,[ \t\n\r\f]*", ",");//$NON-NLS-1$//$NON-NLS-2$
			s = s.replaceAll("^ ", "");//$NON-NLS-1$//$NON-NLS-2$
			s = s.replaceAll(" $", "");//$NON-NLS-1$//$NON-NLS-2$
			String[] strPts = s.split(" ");//$NON-NLS-1$
			String[] strPt;
			int i;
			
			if(strPts==null)
				again = false;
			else
	
					for(i=0, again = true; again && i<strPts.length; i++)
					{
						strPt = strPts[i].split(",");//$NON-NLS-1$
						
						if(strPt==null || strPt.length!=2)
							again = false;
						else
							try
							{
								pts.add(new Point2D.Double(Double.valueOf(strPt[0]).doubleValue(), Double.valueOf(strPt[1]).doubleValue()));
							}
							catch(NumberFormatException e){ again = false; }
					}
		}
		catch(PatternSyntaxException e){ again = false; }
			
		return again ? pts : null;
	}
}
