package latexDraw.parsers.latexdraw;

import java.awt.geom.Point2D;
import java.text.ParseException;
import java.util.Vector;

import latexDraw.parsers.svg.parsers.AbstractSVGParser;

/**
 * Defines a parser that parses points path for latexdraw XML attributes.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/03/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class PointsParser extends AbstractSVGParser
{

	public PointsParser(String code)
	{
		super(code);
	}

	
	
	/**
	 * Parses the code and transforms it to a set of points.
	 * @return A set of points.
	 * @throws ParseException If the given code is not well-formed.
	 * @since 2.0.0
	 */
	public Vector<Point2D> parse() throws ParseException
	{
		Vector<Point2D> points = new Vector<Point2D>();
		String[] coords = code.split(" ");//$NON-NLS-1$
		int i;
		
		if(coords==null || coords.length%2!=0)
			return points;
		
		for(i=1; i<coords.length; i+=2)
			try { points.add(new Point2D.Double(Double.valueOf(coords[i-1]), Double.valueOf(coords[i]))); }
			catch(NumberFormatException e) 
			{ throw new ParseException("Wrong format: not able to parse the following coordinate: " + coords[i] + " or " + coords[i] + ".", i); }//$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
		
		return points;
	}

	
	
	/**
	 * Parses the given code and transforms it to a set of points.
	 * @param code The code to parse.
	 * @return A set of points.
	 * @throws ParseException If the given code is not well-formed.
	 * @since 2.0.0
	 */
	public static Vector<Point2D> getPoints(String code) throws ParseException
	{
		return new PointsParser(code).parse();
	}
}
