package junit.test.svg;

import java.awt.geom.Point2D;
import java.util.Vector;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.elements.SVGPolyLineElement;

import org.junit.Test;

/** 
 * This class contains tests for the SVGPolylineElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/10/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGPolylineElement extends AbstractTestSVGElement
{
	@Test
	public void testGetPoints()
	{
		try
		{
			String path = "10,10 20,20";
			node.setAttribute(SVGAttributes.SVG_POINTS, path);
			SVGPolyLineElement pl = new SVGPolyLineElement(node, null);
			
			assertEquals(pl.getPoints(), path);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testEnableRendering()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_POINTS, "10,10 20,20");
			SVGPolyLineElement pl = new SVGPolyLineElement(node, null);
			assertTrue(pl.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetPoints2D()
	{
		try
		{
			String path = "	  10\t ,\n	10 	\t 	20 \t\n\t\r,	\n20 	\r30,30	\n";
			
			node.setAttribute(SVGAttributes.SVG_POINTS, path);
			SVGPolyLineElement pl = new SVGPolyLineElement(node, null);
			Vector<Point2D> pts;
			
			pts = pl.getPoints2D();
			assertNotNull(pts);
			assertEquals(3, pts.size());
			assertEquals(new Point2D.Double(10, 10), pts.firstElement());
			assertEquals(new Point2D.Double(20, 20), pts.elementAt(1));
			assertEquals(new Point2D.Double(30, 30), pts.lastElement());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGPolyLineElement(null, null);
			fail();
		}
		catch(Exception e){/**/}
		
		try
		{ 
			new SVGPolyLineElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_POINTS, "");
			new SVGPolyLineElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_POINTS, "dsqdgfd");
			new SVGPolyLineElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_POINTS, "10,10");
			new SVGPolyLineElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_POINTS, ",");
			new SVGPolyLineElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_POINTS, "10,10 20,20");
			new SVGPolyLineElement(node, null);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_POLY_LINE;
	}
}
