/*
 * TestButtonIcon.java
 */

package junit.test;

import java.awt.Color;

import javax.swing.JButton;

import junit.framework.TestCase;
import latexDraw.ui.components.ButtonIcon;

import org.junit.Before;
import org.junit.Test;

/** 
 * This class contains tests the methods on the class <code>ButtonIcon</code>.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 02/14/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestButtonIcon extends TestCase
{
	private ButtonIcon	bi;

	private final Color	cNull	= null;

	private final Color	c1		= new Color(100, 100, 100);

	private final Color	c2		= new Color(50, 50, 50);





	@Override
	@Before
	public void setUp()
	{
		bi = new ButtonIcon(c1);
	}
	
	
	
	@Test
	public void testConstructor()
	{
		try
		{
			new ButtonIcon(cNull);
			fail();
		}catch(IllegalArgumentException e) { /* Good */ }
	}
	
	
	
	@Test
	public void testPaintIcon()
	{
		JButton b = new JButton();
		
		b.setIcon(bi);
		b.repaint();
	}
	
	
	
	@Test
	public void testGetSetColor()
	{
		try
		{
			bi.setColor(cNull);
			fail();
		}catch(Exception e) { /* Good */ }

		bi.setColor(c2);
		assertEquals(c2, bi.getColor());
	}

	
	
	@Test
	public void testGetIconWidthHeight()
	{
		assertEquals(bi.getIconWidth(), ButtonIcon.WIDTH);
		assertEquals(bi.getIconHeight(), ButtonIcon.HEIGHT);
	}
}

	
	

