// Copyright 2007 Last.fm Ltd.
// Released under a GPL v2 license

#ifndef WINSTYLEOVERRIDES_H
#define WINSTYLEOVERRIDES_H

#ifdef WIN32
#   include <QWindowsXPStyle>
#   include <QWindowsStyle>
#elif defined Q_WS_X11
    // we like this on Linux too, so hack it to work
#   include <QPlastiqueStyle>
#   define QWindowsStyle QPlastiqueStyle
#   define QWindowsXPStyle QPlastiqueStyle
#endif

#ifndef Q_WS_MAC

// Need to have one class for XP and a different for pre-XP

class WinXPStyleOverrides : public QWindowsXPStyle
{
    virtual void drawPrimitive( PrimitiveElement pe,
                                const QStyleOption *opt,
                                QPainter *p,
                                const QWidget *w = 0) const;
};

class WinStyleOverrides : public QWindowsStyle
{
    virtual void drawPrimitive( PrimitiveElement pe,
                                const QStyleOption *opt,
                                QPainter *p,
                                const QWidget *w = 0) const;
};

#endif // !Q_WS_MAC

#endif // WINSTYLEOVERRIDES_H
