/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef TAGDIALOG_H
#define TAGDIALOG_H

#include <QtCore>
#include <QMenu>
#include "metadata.h"
#include "ui_tagdialog.h"
#include "WebService/fwd.h"

class TagDialog : public QDialog
{
    Q_OBJECT

    public:
        TagDialog( int defaultTagType = -1, // if -1, use most recently used
                   QWidget *parent = 0 );

    private:
        Ui::TagDialog ui;

        MetaData m_metaData;
        QString m_originalTags;
        QMenu m_sortMenu;

    public slots:
        void setSong( MetaData metaData );
        void setSong( Track track );

    private slots:
        void okPressed();
        void cancelPressed();
        void tagTypeChanged( int type );

        void tagsResult( Request* );

        void addTag( QListWidgetItem *item );
		
		void validateTag();
};

#endif // TAGDIALOG_H
