/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *      Max Howell, Last.fm Ltd <max@last.fm>                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "systray.h"
#include "container.h"
#include "logger.h"
#include "iconshack.h"
#include "container.h"
#include "containerutils.h"
#include "trayicon/trayicon.h"
#include "Settings.h"
#include <QSystemTrayIcon>


/******************************************************************************
    SysTray
******************************************************************************/
SysTray::SysTray( Container* parent )
      : QObject( parent ),
        m_trayIcon( new QSystemTrayIcon( parent ) ),
        m_trayMenu( new QMenu( parent ) ),
        m_tipFormat( QString("%1 ") + QChar(8211) /*en dash*/ + " %2 | %3" )
{
    Q_DEBUG_BLOCK;

    // Build popup menu
    QAction* openAct = m_trayMenu->addAction( tr( "Open" ), parent, SLOT( restoreWindow() ) );
    m_trayMenu->setDefaultAction( openAct );

    #ifdef Q_WS_MAC
    m_trayMenu->addSeparator();
    m_trayMenu->addAction( tr( "Preferences..." ), parent, SLOT( showSettingsDialog() ) );
    m_macParent = parent;
    #endif

    m_trayMenu->addSeparator();
    m_trayMenu->addAction( parent->ui.actionDashboard );
    m_trayMenu->addAction( parent->ui.actionToggleScrobbling );
    m_userMenu = m_trayMenu->addMenu( tr( "Change User" ) );

    m_trayMenu->addSeparator();
    m_trayMenu->addAction( parent->ui.actionLove );
    m_trayMenu->addAction( parent->ui.actionBan );

#ifndef HIDE_RADIO
    m_trayMenu->addSeparator();
#endif

    m_trayMenu->addAction( parent->ui.actionSkip );
    #ifndef Q_WS_MAC
        m_trayMenu->addAction( parent->ui.actionPlay );
        m_trayMenu->addAction( parent->ui.actionStop );
    #else
        m_trayMenu->addActions( parent->sysTrayActions()->actions() );
    #endif

    m_trayMenu->addSeparator();

  #ifndef WIN32
    QString const quit_text = tr( "&Quit" );
  #else
    QString const quit_text = tr( "E&xit" );
  #endif
    m_trayMenu->addAction( quit_text, parent, SLOT( actualClose() ) );

    #if QT_VERSION >= 0x040200
    m_trayIcon->setContextMenu( m_trayMenu );
    #else
    m_trayIcon->setPopup( m_trayMenu );
    #endif

    #ifdef Q_WS_MAC
        QImage image( dataPath( "icons/systray_mac.png" ) );
        m_pixmap = QPixmap::fromImage( image );
        image.invertPixels();
        m_inverted_pixmap = QPixmap::fromImage( image ); //used when the menu is open

        //TODO check QIcon convertion requirements
        m_trayIcon->setIcon( m_pixmap );

        //TODO when Qt get themselves sorted, use this instead of the below
        //connect( m_trayMenu, SIGNAL(aboutToHide()), SLOT(aboutToHideMenu()) );
        //connect( m_trayMenu, SIGNAL( triggered( QAction* )), SLOT( aboutToHideMenu()) );

    #else
        if (The::currentUser().isNull())
            m_trayIcon->setIcon( IconShack::instance().GetGoodUserIcon( eRed ) );
        else
            m_trayIcon->setIcon( IconShack::instance().GetGoodUserIcon( The::currentUser().icon() ) );
    #endif

    #if QT_VERSION >= 0x040200
    connect( m_trayIcon, SIGNAL( activated( QSystemTrayIcon::ActivationReason ) ),
             this,       SLOT  ( trayAction( QSystemTrayIcon::ActivationReason ) ) );
    #else
    connect( m_trayIcon, SIGNAL( doubleClicked( QPoint ) ),
             m_parent,   SLOT  ( restoreWindow() ) );
    #endif

    connect( m_trayMenu, SIGNAL( aboutToShow()), SLOT(aboutToShowMenu()) );
    connect( m_userMenu, SIGNAL( triggered( QAction* ) ),
             parent,       SLOT( userSelected( QAction* ) ) );
}


/******************************************************************************
    setUser
******************************************************************************/
void
SysTray::setUser( UserSettings& currentUser )
{
    UserIconColour iconColour = currentUser.icon();
    QPixmap icon;
    if ( currentUser.isLogToProfile() )
    {
        #ifdef Q_WS_MAC
            icon = m_pixmap;
        #else
            icon = IconShack::instance().GetGoodUserIcon( iconColour );
        #endif
    }
    else
    {
        #ifdef Q_WS_MAC
            icon = QIcon(m_pixmap).pixmap( 19, 12, QIcon::Disabled );
        #else
            icon = IconShack::instance().GetDisabledUserIcon( iconColour );
        #endif
    }

    m_trayIcon->setIcon( icon );
    m_user = currentUser.username();
    refreshToolTip();
}


/******************************************************************************
    setTrack
******************************************************************************/
void
SysTray::setTrack( const MetaData &track )
{
    m_artist = track.artist();
    m_track = track.track();
    refreshToolTip();
}


/******************************************************************************
    aboutToShowMenu
******************************************************************************/
void
SysTray::aboutToShowMenu()
{
  #if 0
    //disable until Qt gives us an onHide event for the menu as otherwise we get
    //a white on white logo on depress
    m_trayIcon->setIcon( m_inverted_pixmap );
  #endif

    m_userMenu->clear();

    #ifdef Q_WS_MAC
    m_userMenu->addAction( m_macParent->ui.actionAddUser );
    m_userMenu->addAction( m_macParent->ui.actionDeleteUser );
    m_userMenu->addSeparator();
    #endif

    QString currentUser = The::settings().currentUsername();
    foreach (QString const username, The::settings().allUsers())
    {
        QAction* action = new QAction( m_userMenu );
        action->setData( "user" );
        action->setText( username );
        action->setCheckable( true );
        action->setChecked( username == currentUser );

        m_userMenu->addAction( action );
    }
}


void
SysTray::aboutToHideMenu()
{
  #ifdef Q_WS_MAC
    m_trayIcon->setIcon( m_pixmap );
  #endif
}


/******************************************************************************
    refreshToolTip
******************************************************************************/
void
SysTray::refreshToolTip()
{
    QString tip;
    if ( m_artist != "" && m_track != "" )
    {
        tip = m_tipFormat.arg( m_artist, m_track, m_user );
    }
    else
    {
        tip = tr( "%1 is logged in" ).arg( m_user );
    }

    #ifdef WIN32
        // Good old crappy Win32
        tip.replace( "&", "&&&" );
    #endif

    m_trayIcon->setToolTip( tip );
}


#if QT_VERSION >= 0x040200
void
SysTray::trayAction( QSystemTrayIcon::ActivationReason reason )
{
    // typical linux behavior is single clicking tray icon toggles
    // the main window

    #ifdef Q_WS_X11
    if (reason == QSystemTrayIcon::Trigger)
        Container::instance().toggleWindowVisibility();
    #else
    if (reason == QSystemTrayIcon::DoubleClick)
        Container::instance().restoreWindow();
    #endif
}
#endif
