TEMPLATE = app
TARGET = Last.fm
QT += gui network xml sql

INCLUDEPATH += lib zlib-1.2.3

PRECOMPILED_HEADER = precompiled.h
CONFIG += precompile_header

unix {
    # precompiled headers breaks icecream builds for some reason :(
    system( test `ps aux | grep iceccd | wc -l` -gt 1 ): CONFIG -= precompile_header
}

unix:!macx {
    # we need to use a shellscript named 'last.fm' on linux
    TARGET = last.fm.app
}

#universal binaries cannot be built from precompiled headers
unix:macx:release:CONFIG -= precompile_header

win32 {
	# Keep the old exe name for backwards compatibility and to avoid potential bugs
	TARGET = LastFM
}

include( ../definitions.pro.inc )


FORMS   = container.ui \
          settingsdialog.ui \
          settingsdialog_account.ui \
          settingsdialog_radio.ui \
          settingsdialog_scrobbling.ui \
          settingsdialog_connection.ui \
          settingsdialog_mediadevices.ui \
          aboutdialog.ui \
          loginwidget.ui \
          progresswidget.ui \
          confirmwidget.ui \
          mediaDeviceConfirmWidget.ui \
          MediaDeviceConfirmDialog.ui \
          addplayerdialog.ui \
          selectpluginwidget.ui \
          selectupdateswidget.ui \
          dialogshell.ui \
          deleteuserdialog.ui \
          playcontrols.ui \
          failedlogindialog.ui \
          tagdialog.ui \
          recommenddialog.ui \
          metadataextension/metadata3.ui \
          metadataextension/notplayingwidget.ui \
          RestStateWidget.ui

HEADERS = container.h \
          settingsdialog.h \
          crashhandler.h \
          aboutdialog.h \
          Scrobbler-1.2.h \
          simplewizard.h \
          configwizard.h \
          wizardinfopage.h \
          wizardconfirmpage.h \
          wizardmediadeviceconfirmpage.h \
          wizardloginpage.h \
          wizardprogresspage.h \
          wizardselectpluginpage.h \
          wizardbootstrappage.h \
          addplayerdialog.h \
          loginwidget.h \
          updateinfogetter.h \
          componentinfo.h \
          plugininfo.h \
          appinfo.h \
          exceptions.h \
          versionnumber.h \
          lib/FileVersionInfo/FileVersionInfo.h \
          lib/KillProcess/KillProcess.h \
          autoupdater.h \
          updatewizard.h \
          wizardselectupdatespage.h \
          playerlistener.h \
          playercommandparser.h \
          playercommands.h \
          playerconnection.h \
          stopwatch.h \
          logindialog.h \
          iconshack.h \
          systray.h \
          progressframe.h \
          trayicon/trayicon.h \
          checkdirtree.h \
          deleteuserdialog.h \
          failedlogindialog.h \
          volumeslider.h \
          controlinterface.h \
          tagdialog.h \
          recommenddialog.h \
          lastfmapplication.h \
          itunesscript.h \
          mediadevices/mediadevice.h \
          AudioController.h \
          Radio.h \
          RadioPlaylist.h \
          XspfResolver.h \
          MediaDeviceConfirmDialog.h \
          sidebarextension/sidebartree.h \
          sidebarextension/SideBarModel.h \
          sidebarextension/SideBarDelegate.h \
          sidebarextension/treestyle.h \
          sidebarextension/ToolTipLabel.h \
          sidebarextension/RevealPopup.h \
          metadataextension/metadataextension.h \
		  TagListWidget.h \
		  version.h \
		  TrackProgressFrame.h \
          RestStateWidget.h

macx:HEADERS += macstyleoverrides.h
win32:HEADERS += winstyleoverrides.h 
                     
SOURCES = main.cpp \
          container.cpp \
          settingsdialog.cpp \
          crashhandler.cpp \
          aboutdialog.cpp \
          Scrobbler-1.2.cpp \
          simplewizard.cpp \
          configwizard.cpp \
          wizardinfopage.cpp \
          wizardconfirmpage.cpp \
          wizardmediadeviceconfirmpage.cpp \
          wizardloginpage.cpp \
          wizardprogresspage.cpp \
          wizardselectpluginpage.cpp \
          wizardbootstrappage.cpp \
          addplayerdialog.cpp \
          loginwidget.cpp \
          updateinfogetter.cpp \
          componentinfo.cpp \
          plugininfo.cpp \
          appinfo.cpp \
          versionnumber.cpp \
          lib/FileVersionInfo/FileVersionInfo.cpp \
          autoupdater.cpp \
          updatewizard.cpp \
          wizardselectupdatespage.cpp \
          playerlistener.cpp \
          playercommandparser.cpp \
          playerconnection.cpp \
          stopwatch.cpp \
          logindialog.cpp \
          iconshack.cpp \
          systray.cpp \
          progressframe.cpp \
          trayicon/trayicon.cpp \
          checkdirtree.cpp \
          deleteuserdialog.cpp \
          failedlogindialog.cpp \
          volumeslider.cpp \
          controlinterface.cpp \
          tagdialog.cpp \
          recommenddialog.cpp \
          lastfmapplication.cpp \
          itunesscript.cpp \
          mediadevices/mediadevice.cpp \
          AudioController.cpp \
          Radio.cpp \
          RadioPlaylist.cpp \
          XspfResolver.cpp \
	      MediaDeviceConfirmDialog.cpp \
          sidebarextension/sidebartree.cpp \
          sidebarextension/SideBarModel.cpp \
          sidebarextension/SideBarDelegate.cpp \          
          sidebarextension/treestyle.cpp \
          sidebarextension/ToolTipLabel.cpp \
          sidebarextension/RevealPopup.cpp \          
          metadataextension/metadataextension.cpp \
		  TagListWidget.cpp \
          winstyleoverrides.cpp \     
		  TrackProgressFrame.cpp \
          RestStateWidget.cpp

unix:!mac {
    FORMS += wizarddialog_mac.ui \
             wizardshell_mac.ui \
             searchextension/search_win.ui
    
    SOURCES += trayicon/trayicon_x11.cpp \
                simplewizard_mac.cpp
                
    #--warning
    HEADERS -= itunesscript.h
                
    HEADERS += simplewizard_mac.h
}

unix:mac {
    FORMS += wizarddialog_mac.ui \
             wizardshell_mac.ui \
             searchextension/search_mac.ui
    
    SOURCES += trayicon/trayicon_mac.cpp \
               simplewizard_mac.cpp \
               macstyleoverrides.cpp
               
    SOURCES -= sidebarextension/treestyle.cpp \
               winstyleoverrides.cpp
                
    HEADERS += simplewizard_mac.h
    
    ICON = ../bin/data/icons/lastfm.icns
}

win32 {
    FORMS += wizarddialog_win.ui \
             wizardextshell_win.ui \
             wizardintshell_win.ui \
             searchextension/search_win.ui
        
    LIBS += -Lzlib-1.2.3 -lzlibwapi -lshfolder -luser32 -lshell32 -lversion -lWs2_32 -lGdi32
    
    HEADERS += simplewizard_win.h

    SOURCES += trayicon/trayicon_win.cpp \
               simplewizard_win.cpp

	# Set up target for the automatic version updating
	TOOLS_DIR = $$ROOT_DIR\tools

	versionTarget.target   = dummy
	versionTarget.commands = $${TOOLS_DIR}\VersionUpdater.exe version.h $$VERSION_UPDATE_PATTERN \
							 container.rc		        $${BUILD_DIR}/container.i.rc \
							 trustInfo.manifest         $${BUILD_DIR}/trustInfo.i.manifest \
							 ..\build-installer-win.iss ..\build-installer-win.i.iss
							 
	# Tell qmake that this targets should get built
	QMAKE_EXTRA_TARGETS += versionTarget

	# Ensure this target is built before the main target
	PRE_TARGETDEPS += $$versionTarget.target

	RC_FILE = $${BUILD_DIR}/container.i.rc

	COMPILER_IS_2005 = $$system( echo %QMAKESPEC% | find \"msvc2005\" )
	isEmpty( COMPILER_IS_2005 ) {
		# If we're building with 2003.NET, no manifest will have been embedded so use -outputresource
		QMAKE_POST_LINK = mt.exe -manifest $${BUILD_DIR}/trustInfo.i.manifest \
								 -outputresource:"$${DESTDIR}/$${TARGET}.exe;$${LITERAL_HASH}1"							 
	} else {
		# If we're building with 2005, the linker has embedded a manifest and we need -updateresource
		QMAKE_POST_LINK = mt.exe -manifest $${BUILD_DIR}/trustInfo.i.manifest \
							     -updateresource:"$${DESTDIR}/$${TARGET}.exe;$${LITERAL_HASH}1"	
	}
}


CONFIG(debug, debug|release) {
    DEFINES += MONITOR_STREAMING
    FORMS += streambuffermonitor.ui
    HEADERS += StreamBufferMonitor.h
    SOURCES += StreamBufferMonitor.cpp
}

RESOURCES = ../qrc/last.fm.qrc
