
#ifndef SIDE_BAR_DELEGATE_H
#define SIDE_BAR_DELEGATE_H

#include <QItemDelegate>
#include <QFont>


class SideBarDelegate : public QItemDelegate
{
	Q_OBJECT

	virtual void paint( QPainter*, const QStyleOptionViewItem&, const QModelIndex& ) const;

public:
	QSize sizeHint( const QStyleOptionViewItem& option, const QModelIndex& index ) const;
	
	QString truncateString( QString str, QFont font, int sideBarWidth ) const;
	
	QFont font() { return m_font; };
	void setFont( QFont font ) { m_font = font; };
	int sideBarWidth() { return m_sideBarWidth; };
	void setSideBarWidth( int width ) { m_sideBarWidth = width; };

private:
	QFont m_font;
	int m_sideBarWidth;
};

#endif
