/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jalevik, Last.fm Ltd <erik@last.fm>                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef PROGRESSFRAME_H
#define PROGRESSFRAME_H

#include "stopwatch.h"
#include "metadata.h"

#include <QtGui>

class ProgressFrame : public QFrame
{
    Q_OBJECT

    public:
        ProgressFrame( QWidget *parent = 0 );

        void clear();
        bool isActive();
        int value() { return m_value; }

        // The stopwatch whose time to reflect. The StopWatch must have a
        // timeout for reverse display to work.
        void setStopWatch( StopWatch* watch );
        void setReverse( bool reverse ) { m_reverse = reverse; }

        // The main text
        QString text() { return m_text; }
        void setText( const QString& text );

        // Temporary message that should only be displayed for a few seconds
        void pushText( const QString& text, int seconds = 3 );

        // Allows setting a text string where the clock normally is
        QString clockText() { return m_clockText; }
        void setClockText( const QString& text );

        // Temporary message that should only be displayed for a few seconds
        void pushClockText( const QString& text, int seconds = 3 );

        // Icon displayed to the left of the text
        QPixmap icon() { return m_pixmap; }
        void setIcon( QPixmap pixmap ) { m_pixmap = pixmap; }

        // Background and progress bar gradient
        void setBackgroundGradient( const QLinearGradient& bg ) { m_backgroundGradient = bg; }
        void setForegroundGradient( const QLinearGradient& fg ) { m_foregroundGradient = fg; }

        // No progress will be shown is this is off
        void setProgressEnabled( bool enabled );

        // No clock will be shown if this is off
        void setClockEnabled( bool enabled );

        void setEnabled( bool enabled )
        {
            setProgressEnabled( enabled );
            setClockEnabled( enabled );
        }

        // Drag and drop functions
        QHash<QString, QString> itemData() { return m_itemData; }
        void setItemData( QHash<QString, QString> data ) { m_itemData = data; }
        int itemType() { return m_itemType; }
        void setItemType( int type ) { m_itemType = type; }

    public slots:

    protected:

        void
        mouseMoveEvent( QMouseEvent *event );

        virtual int
        paintProgressBar( QPainter* painter, const QLinearGradient& grad );
        
        virtual void
        paintBackground( QPainter* painter, int xPos, const QLinearGradient& grad );
        
        virtual void
        paintIcon( QPainter* painter, QRect rect, const QPixmap& icon );
        
        virtual QRect
        paintClock( QPainter* painter, QRect rect );
        
        virtual void
        paintText( QPainter* painter, QRect rect, QRect clockRect );

        QString
        secondsToTimeString( int time );

    // EJ TODO: these should really be private but there was too much
    // getting the subclass to work properly so made them protected for now
    //private:

        void paintEvent( QPaintEvent* event );
        void disconnectWatch();

        QPixmap m_pixmap;

        QString m_text;
        QString m_savedText;

        QString m_clockText;

        QLinearGradient m_backgroundGradient;
        QLinearGradient m_foregroundGradient;

        int m_itemType;
        QHash<QString, QString> m_itemData;

        bool m_progressEnabled;
        bool m_clockEnabled;

        bool m_reverse;

        QTimer m_textPushTimer;
        QTimer m_clockPushTimer;

        StopWatch* m_watch;
        int m_value;

    private slots:

        void setValue( int secs );

        void popText();
        void popClockText();

};

#endif
