/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef LOGINWIDGET_H
#define LOGINWIDGET_H

#include "ui_loginwidget.h"
#include "WebService/fwd.h"


class LoginWidget : public QWidget
{
    Q_OBJECT

    public:

        enum Mode
        {
            ADD_USER,
            LOGIN,
            CHANGE_PASS 
        };

        LoginWidget( QWidget* parent, Mode mode = LOGIN, QString  defaultUser = "" );

        void verify();
        void save();

    signals:
        void verifyResult( bool result, bool bootstrap );

    protected:
        Ui::LoginWidget ui;

    private:
        Mode m_Mode;
        bool m_saveLowerPass;

        const QString m_badUserError;
        const QString m_badPassError;

        bool verifyLocally();

    private slots:
        void verifyResult( Request* );
        void userComboChanged( QString user );

};

#endif // LOGINWIDGET_H
